.\"(c) Copyright 1992, by Panagiotis Tsirigotis
.\"(c) Sections Copyright 1998-2001 by Rob Braun
.\"All rights reserved.  The file named COPYRIGHT specifies the terms 
.\"and conditions for redistribution.
.\"
.\" $Id: xinetd.conf.man,v 1.20 2007-09-20 14:58:27 bbraun Exp $
.TH XINETD.CONF 5 "14 June 2001"
.\" *************************** NAME *********************************
.SH NAME
xinetd.conf \- Extended Internet Services Daemon configuration file
.\" *********************** DESCRIPTION ****************************
.SH DESCRIPTION
.B "xinetd.conf"
is the configuration file that
determines the services provided by \fBxinetd\fP.
Any line whose first non-white-space character is a '#' is considered
a comment line. Empty lines are ignored.
.LP
The file contains entries of the form:
.RS
.nf
.ft B
.sp
service <service_name>
{
.RS
.ft B
<attribute> <assign_op> <value> <value> ...
.I "..."
.RE
}
.ft R
.fi
.RE
.LP
The assignment operator,
.I assign_op,
can be one of 
.B '=', 
.B '+=',
.B '-='.
The majority of attributes support only the simple assignment operator,
.B '='.
Attributes whose value is a set of values support all assignment operators.
For such attributes,
.B '+=' 
means adding a value to the set and 
.B '-='
means removing a value from the set.
A list of these attributes will be given
after all the attributes are described.
.LP
Each entry defines a service identified by the \fIservice_name\fP.
The following is a list of available attributes:
.TP 17
.B id
This attribute is used to uniquely identify a service.
This is useful because there exist services that can use different 
protocols and need to be described with different entries in the
configuration file.
By default, the service id is the same as the service name.
.TP
.B type
Any combination of the following values may be used:
.RS
.TP 12
.B RPC
if this is an RPC service
.TP
.B INTERNAL
if this is a service provided by \fBxinetd\fP.
.TP
.B TCPMUX/TCPMUXPLUS
if this is a service that will be started according to the RFC 1078 protocol on the TCPMUX well-known port. See the section describing TCPMUX services below.
.TP
.B UNLISTED
if this is a service not listed in a standard system file
(like
.I /etc/rpc 
for RPC services, or
.I /etc/services
for non-RPC services).
.RE
.TP
.B flags
Any combination of the following flags may be used:
.RS
.TP 12
.B INTERCEPT
Intercept packets or accepted connections in order to verify that they
are coming from acceptable locations (internal or multi-threaded
services cannot be intercepted).
.TP
.B NORETRY
Avoid retry attempts in case of fork failure.
.TP
.B IDONLY
Accept connections only when the remote end identifies the remote user
(i.e. the remote host must run an identification server).
This flag applies only to connection-based services.
This flag is ineffective if the
.B USERID
log option is not used.
.TP
.B NAMEINARGS
This will cause the first argument in "server_args" to be argv[0] when
executing the server, as specified in "server".  This allows you to use
tcpd by putting tcpd in "server" and the name of the server in "server_args"
like in normal inetd.
.TP
.B NODELAY
If the service is a tcp service and the NODELAY flag is set, then the
TCP_NODELAY flag will be set on the socket.  If the service is not
a tcp service, this option has no effect.
.TP
.B KEEPALIVE
If the service is a tcp service and the KEEPALIVE flag is set, then 
the SO_KEEPALIVE socket flag will be set on the socket.  If the service
is not a tcp service, this option has no effect.
.TP
.B NOLIBWRAP
This disables internal calling of the tcpwrap library to determine access
to the service.  This may be needed in order to use libwrap functionality
not available to long-running processes such as xinetd; in this case,
the tcpd program can be called explicitly (see also the NAMEINARGS flag).
For RPC services using TCP transport, this flag is automatically turned on,
because xinetd cannot get remote host address information for the rpc port.
.TP
.B SENSOR
This replaces the service with a sensor that detects accesses to the 
specified port. NOTE: It will NOT detect stealth scans. This flag 
should be used only on services that you know you don't need. When an 
access is made to this service's port, the IP Address is added to a global
no_access list. This causes all subsequent accesses from the originating IP
address to be denied access until the deny_time setting expires. The amount
of time spent on this list is configurable as the deny_time attribute. The
SENSOR flag will also cause xinetd to consider the server attribute to be
INTERNAL no matter what is typed on the same line. Another important thing
to remember is that if the socket_type is set to stream, then the wait 
attribute should be set to no.
.TP
.B IPv4
Sets the service to be an IPv4 service (AF_INET).
.TP
.B IPv6
Sets the service to be an IPv6 service (AF_INET6), if IPv6 is available on the system.
.TP
.B LABELED
The LABELED flag will tell xinetd to change the child processes SE Linux context to match that of the incoming connection as it starts the service. This only works for external tcp non-waiting servers and is an error if applied to an internal, udp, or tcp-wait server.
.TP
.B REUSE
The REUSE flag is deprecated.  All services now implicitly use the REUSE flag.
.RE
.TP
.B disable
This is boolean "yes" or "no".  This will result in the service
being disabled and not starting.  See the DISABLE flag description.
.RE
.TP
.B socket_type
Possible values for this attribute include:
.RS
.TP 12
.I stream
stream-based service
.TP
.I dgram
datagram-based service
.TP
.I raw
service that requires direct access to IP
.TP
.I seqpacket
service that requires reliable sequential datagram transmission
.RE
.TP
.B protocol
determines the protocol that is employed by the service.
The protocol must exist in
.I /etc/protocols.
If this
attribute is not defined, the default protocol employed by the service
will be used.
.TP
.B wait
This attribute determines if the service is single-threaded or
multi-threaded and whether or not xinetd accepts the connection or the server
program accepts the connection. If its value is \fIyes\fP, the service is 
single-threaded; this means that \fBxinetd\fP will start the server and then 
it will stop handling requests for the service until the server dies and that
the server software will accept the connection. If the attribute value is 
\fIno\fP, the service is multi-threaded and \fBxinetd\fP will keep handling 
new service requests and xinetd will accept the connection. It should be noted 
that udp/dgram services normally expect the value to be yes since udp is not
connection oriented, while tcp/stream servers normally expect the value to be
no.
.TP
.B user
determines the uid for the server process. The user attribute can either 
be numeric or a name. If a name is given (recommended),  the user name must 
exist in
.I /etc/passwd.
This attribute is ineffective if the effective user ID 
of \fBxinetd\fP is not super-user.
.TP
.B group
determines the gid for the server process. The group attribute can either
be numeric or a name. If a name is given (recommended), the group name must 
exist in
.I /etc/group.
If a group is not specified, the group
of \fIuser\fP will be used (from 
.I /etc/passwd).
This attribute is ineffective if the effective user ID 
of \fBxinetd\fP is not super-user and if the \fBgroups\fP attribute
is not set to 'yes'.
.TP
.B instances
determines the number of servers that can be simultaneously active
for a service (the default is no limit). The value of this
attribute can be either a number or
.B UNLIMITED
which means that there is no limit.
.TP
.B nice
determines the server priority. Its value is a (possibly negative) number;
check nice(3) for more information.
.TP
.B server
determines the program to execute for this service.
.TP
.B server_args
determines the arguments passed to the server. In contrast to \fBinetd\fP,
the server name should \fInot\fP be included in \fIserver_args\fP.
.TP
+.B libwrap
overrides the service name passed to libwrap (which defaults to the
server name, the first server_args component with NAMEINARGS, the id
for internal services and the service name for redirected services).
This attribute is only valid if xinetd has been configured with the libwrap
option.
.TP
.B only_from
determines the remote hosts to which the particular
service is available.
Its value is a list of IP addresses which can be specified in any
combination of the following ways:
.RS
.TP 5
.B a)
a numeric address in the form of %d.%d.%d.%d. If the rightmost components are 
0, they are treated as wildcards 
(for example, 128.138.12.0 matches all hosts on the 128.138.12 subnet).
0.0.0.0 matches all Internet addresses.  IPv6 hosts may be specified in the form of abcd:ef01::2345:6789.  The rightmost rule for IPv4 addresses does not apply to IPv6 addresses.
.TP
.B b)
a factorized address in the form of %d.%d.%d.{%d,%d,...}.
There is no need for all 4 components (i.e. %d.%d.{%d,%d,...%d} is also ok).
However, the factorized part must be at the end of the address.  This form does not work for IPv6 hosts.
.TP
.B c)
a network name (from
.I /etc/networks).  This form does not work for IPv6 hosts.
.TP
.B d)
a host name.  When a connection is made to xinetd, a reverse lookup is
performed, and the canonical name returned is compared to the specified host
name.  You may also use domain names in the form of .domain.com.  If the
reverse lookup of the client's IP is within .domain.com, a match occurs.
.TP
.B e)
an ip address/netmask range in the form of 1.2.3.4/32.  IPv6 address/netmask
ranges in the form of 1234::/46 are also valid.
.RE
.TP
.B ""
Specifying this attribute
without a value makes the service available to nobody.
.TP
.B no_access
determines the remote hosts to which the particular
service is unavailable. Its value can be specified in the same way as the
value of the \fBonly_from\fP
attribute. These two attributes determine the location access control 
enforced by \fBxinetd\fP. If none of the two is specified for a service,
the service is available to anyone. If both are specified for a service,
the one that is the better match for
the address of the remote host determines
if the service is available to that host (for example, if the 
\fBonly_from\fP list contains 128.138.209.0 and the
\fBno_access\fP list contains 128.138.209.10
then the host with the address 128.138.209.10 can not access the service).
.TP
.B access_times
determines the time intervals when the service is available. An interval
has the form \fIhour:min-hour:min\fP (connections 
.I will 
be accepted at the bounds of an interval). Hours can range from 0 to 23 and
minutes from 0 to 59.
.TP
.B log_type
determines where the service log output is sent. There are two formats:
.RS
.TP
.B SYSLOG " \fIsyslog_facility [syslog_level]\fP"
The log output is sent to syslog at the specified facility. Possible facility
names include:
.I daemon,
.I auth,
.I authpriv,
.I user,
.I mail,
.I lpr,
.I news,
.I uucp,
.I ftp
.I "local0-7."
Possible level names include:
.I emerg,
.I alert,
.I crit,
.I err,
.I warning,
.I notice,
.I info,
.I debug.
If a level is not present, the messages will be recorded at the
.I info
level.
.TP
.B FILE " \fIfile [soft_limit [hard_limit]]\fP"
The log output is appended to \fIfile\fP which will be created if it does
not exist. Two limits on the size of the log file can be optionally specified.
The first limit is a soft one;
.B xinetd 
will log a message the first time this limit is exceeded (if 
.B xinetd
logs to syslog, the message will be sent at the 
.I alert
priority level).
The second limit is a hard limit; 
.B xinetd 
will stop logging for the affected service (if the log file is a
common log file, then more than one service may be affected)
and will log a message about this (if
.B xinetd
logs to syslog, the message will be sent at the 
.I alert
priority level).
If a hard limit is not specified, it defaults to the soft limit
increased by 1% but the extra size must be within the parameters
.SM LOG_EXTRA_MIN
and
.SM LOG_EXTRA_MAX
which default to 5K and 20K respectively (these constants are defined in 
\fIxconfig.h\fP).
.RE
.TP
.B log_on_success
determines what information is logged when a server is started and when
that server exits (the service id is always included in the log entry).
Any combination of the following values may be specified:
.RS
.TP 12
.B PID
logs the server process id (if the service is implemented by \fBxinetd\fP
without forking another process the logged process id will be 0)
.TP
.B HOST
logs the remote host address
.TP
.B USERID
logs the user id of the remote user using the RFC 1413 identification protocol.
This option is available only for multi-threaded stream services.
.TP
.B EXIT
logs the fact that a server exited along with the exit status or the
termination signal
(the process id is also logged if the
.B PID
option is used)
.TP
.B DURATION 
logs the duration of a service session
.TP
.B TRAFFIC
logs the total bytes in and out for a redirected service.
.RE
.TP
.B log_on_failure
determines what information is logged when a server cannot be started
(either because of a lack of resources or because of access control
restrictions). The service id is always included in the log entry along
with the reason for failure.
Any combination of the following values may be specified:
.RS
.TP 12
.B HOST
logs the remote host address.
.TP
.B USERID
logs the user id of the remote user using the RFC 1413 identification protocol.
This option is available only for multi-threaded stream services.
.TP 
.B ATTEMPT
logs the fact that a failed attempt was made
(this option is implied by all others).
.RE
.TP
.B rpc_version
determines the RPC version for a RPC service. The version can be
a single number or a range in the form \fInumber\fP-\fInumber\fP.
.TP
.B rpc_number
determines the number for an
.I UNLISTED
RPC service (this attribute is ignored if the service is not unlisted).
.TP
.B env
The value of this attribute is a list of strings of the form 'name=value'.
These strings will be added to the environment before
starting a server (therefore the server's environment will include
\fBxinetd\fP's environment plus the specified strings).
.TP
.B passenv
The value of this attribute is a list of environment variables from
\fBxinetd\fP's environment that will be passed to the server.
An empty list implies passing no variables to the server
except for those explicitly defined using the
.I env
attribute.
(notice that you can use this attribute in conjunction with the
.I env
attribute to specify exactly what environment will be passed to the server).
.TP
.B port
determines the service port. If this attribute is specified for a service 
listed in
.I /etc/services,
it must be equal to the port number listed in that file.
.TP
.B redirect
Allows a tcp service to be redirected to another host.  When xinetd receives
a tcp connection on this port it spawns a process that establishes a
connection to the host and port number specified, and forwards all data
between the two hosts.  This option is useful when your internal machines
are not visible to the outside world.  Syntax is: redirect = (ip address) 
(port).  You can also use a hostname instead of the IP address in this
field.  The hostname lookup is performed only once, when xinetd is 
started, and the first IP address returned is the one that is used
until xinetd is restarted.
The "server" attribute is not required when this option is specified.  If
the "server" attribute is specified, this attribute takes priority.
.TP
.B bind
Allows a service to be bound to a specific interface on the machine.
This means you can have a telnet server listening on a local, secured
interface, and not on the external interface.  Or one port on one interface
can do something, while the same port on a different interface can do 
something completely different.  Syntax: bind = (ip address of interface).
.TP
.B interface
Synonym for bind.
.TP
.B banner
Takes the name of a file to be splatted at the remote host when a 
connection to that service is established.  This banner is printed
regardless of access control.  It should *always* be printed when
a connection has been made.  \fBxinetd\fP outputs the file as-is,
so you must ensure the file is correctly formatted for the service's
protocol.  In paticular, if the protocol requires CR-LF pairs for line
termination, you must supply them.
.TP
.B banner_success
Takes the name of a file to be splatted at the remote host when a
connection to that service is granted.  This banner is printed
as soon as access is granted for the service.  \fBxinetd\fP outputs the
file as-is, so you must ensure the file is correctly formatted for
the service's protocol.  In paticular, if the protocol requires CR-LF
pairs for line termination, you must supply them.
.TP
.B banner_fail
Takes the name of a file to be splatted at the remote host when a
connection to that service is denied.  This banner is printed 
immediately upon denial of access.  This is useful for informing
your users that they are doing something bad and they shouldn't be
doing it anymore.  \fBxinetd\fP outputs the file as-is,
so you must ensure the file is correctly formatted for the service's
protocol.  In paticular, if the protocol requires CR-LF pairs for line
termination, you must supply them.
.TP
.B per_source
Takes an integer or "UNLIMITED" as an argument.  This specifies the
maximum instances of this service per source IP address.  This can
also be specified in the defaults section.
.TP
.B cps
Limits the rate of incoming connections.  Takes two arguments.  
The first argument is the number of connections per second to handle.
If the rate of incoming connections is higher than this, the service
will be temporarily disabled.  The second argument is the number of
seconds to wait before re-enabling the service after it has been disabled.
The default for this setting is 50 incoming connections and the interval
is 10 seconds.
.TP
.B max_load
Takes a floating point value as the load at which the service will 
stop accepting connections.  For example: 2 or 2.5.  The service
will stop accepting connections at this load.  This is the one minute
load average.  This is an OS dependent feature, and currently only
Linux, Solaris, and FreeBSD are supported for this.  This feature is
only avaliable if xinetd was configured with the -with-loadavg option.
.TP
.B groups
Takes either "yes" or "no".  If the groups attribute is set to
"yes", then the server is executed with access to the groups that the
server's effective UID has access to.  Alternatively, if the \fBgroup\fP
attribute is set, the server is executed with access to the groups
specified.  If the groups attribute is set 
to "no", then the server runs with no supplementary groups.  This
attribute must be set to "yes" for many BSD systems.  This attribute
can be set in the defaults section as well.
.TP
.B mdns
Takes either "yes" or "no".  On systems that support mdns registration
of services (currently only Mac OS X), this will enable or disable
registration of the service.  This defaults to "yes".
.TP
.B umask
Sets the inherited umask for the service.  Expects an octal value.  
This option may be set in the "defaults" section to set a umask
for all services.  xinetd sets its own umask to the previous umask
OR'd with 022.  This is the umask that will be inherited by all 
child processes if the umask option is not used.
.TP
.B enabled
Takes a list of service ID's to enable.  This will enable only the
services listed as arguments to this attribute; the rest will be
disabled.  If you have 2 ftp services, you will need to list both of
their ID's and not just ftp. (ftp is the service name, not the ID. It
might accidentally be the ID, but you better check.) Note that the 
service "disable" attribute and "DISABLE" flag can prevent a service 
from being enabled despite being listed in this attribute. 
.TP
.B include
Takes a filename in the form of "include /etc/xinetd/service".
The file is then parsed as a new configuration file.  It is not 
the same thing as pasting the file into xinetd.conf where the 
include directive is given.  The included file must be in the 
same form as xinetd.conf.  This may not be specified from within
a service.  It must be specified outside a service declaration.
.TP
.B includedir
Takes a directory name in the form of "includedir /etc/xinetd.d".
Every file inside that directory, excluding files with names containing
a dot ('.') or ending with a tilde ('~'), will be parsed as xinetd 
configuration files.  The files will be parsed in alphabetical order
according to the C locale. This allows you to specify services one 
per file within a directory.  The
.B includedir
directive may not be specified from within a service declaration.  
.TP
.B rlimit_as
Sets the Address Space resource limit for the service. One parameter
is required, which is either a positive integer representing the number
of bytes to set the limit to (K or M may be used to specify
kilobytes/megabytes) or "UNLIMITED".  Due to the way Linux's libc malloc
is implemented, it is more useful to set this limit than rlimit_data,
rlimit_rss and rlimit_stack. This resource limit is only implemented on
Linux systems.
.TP
.B rlimit_cpu
Sets the maximum number of CPU seconds that the service may use.
One parameter is required, which is either a positive integer representing
the number of CPU seconds limit to, or "UNLIMITED".
.TP
.B rlimit_data
Sets the maximum data size resource limit for the service.
One parameter is required, which is either a positive integer representing
the number of bytes or "UNLIMITED".
.TP
.B rlimit_rss
Sets the maximum resident set size limit for the service.  Setting this
value low will make the process a likely candidate for swapping out to
disk when memory is low.
One parameter is required, which is either a positive integer representing
the number of bytes or "UNLIMITED".
.TP
.B rlimit_stack
Set the maximum stack size limit for the service.
One parameter is required, which is either a positive integer representing
the number of bytes or "UNLIMITED".
.TP
.B deny_time
Sets the time span that access to all services on all IP addresses are
denied to someone that sets off the SENSOR. The unit of time is in minutes.
Valid options are: FOREVER, NEVER, and a numeric value. FOREVER causes
the IP address not to be purged until xinetd is restarted. NEVER has the
effect of just logging the offending IP address. A typical time value would
be 60 minutes. This should stop most DOS attacks while allowing IP addresses
that come from a pool to be recycled for legitimate purposes. This option
must be used in conjunction with the SENSOR flag.
.LP
You don't need to specify all of the above attributes for each service.
The necessary attributes for a service are:
.sp 1
.PD .1v
.RS
.TP 18
.B socket_type
.TP
.B user
(non-\fIinternal\fP services only)
.TP
.B server
(non-\fIinternal\fP services only)
.TP
.B wait
.TP
.B protocol
(\fIRPC\fP and \fIunlisted\fP services only)
.TP
.B rpc_version
(\fIRPC\fP services only)
.TP
.B rpc_number
(\fIunlisted\fP RPC services only)
.TP
.B port
(\fIunlisted\fP non-RPC services only)
.RE
.PD
.LP
The following attributes support all assignment operators:
.sp 1
.PD .1v
.RS
.TP 18
.B only_from
.TP
.B no_access
.TP
.B log_on_success
.TP
.B log_on_failure
.TP
.B passenv
.TP
.B env
(does not support the
.B '-='
operator)
.RE
.PD
.LP
These attributes can also appear more than once in a service entry.
The remaining attributes support only the 
.B '='
operator and can appear at most once in a service entry.
.LP
The configuration file may also contain a single defaults entry
that has the form
.LP
.RS
.nf
.ft B
defaults
{
.RS
.ft B
<attribute> = <value> <value> ...
.I "..."
.RE
.ft B
}
.ft R
.fi
.RE
.LP
This entry provides default attribute values for service entries that
don't specify those attributes. Possible default attributes:
.sp 1
.PD .1v
.RS
.TP 18
.B log_type
(cumulative effect)
.TP
.B bind 
.TP
.B per_source 
.TP
.B umask 
.TP
.B log_on_success
(cumulative effect)
.TP
.B log_on_failure
(cumulative effect)
.TP
.B only_from
(cumulative effect)
.TP
.B no_access
(cumulative effect)
.TP
.B passenv
(cumulative effect)
.TP
.B instances
.TP
.B disabled
(cumulative effect)
.TP
.B enabled
(cumulative effect)
.TP
.B banner 
.TP
.B banner_success 
.TP
.B banner_fail
.TP
.B per_source 
.TP
.B groups 
.TP
.B cps 
.TP
.B max_load 
.TP
.RE
.PD
.LP
Attributes with a cumulative effect can be specified multiple times
with the values specified each time accumulating (i.e. '=' does
the same thing as '+=').
With the exception of
.I disabled
they all have the same meaning as if they were specified in a service entry.
.I disabled
determines services that are disabled even if they have entries in
the configuration file. This allows for quick reconfiguration by
specifying disabled services with the
.I disabled
attribute instead of commenting them out.
The value of this attribute is a list of space separated service ids.
.I enabled 
has the same properties as disabled.  The difference being that
.I enabled 
is a list of which services are to be enabled.  If 
.I enabled 
is specified, only the services specified are available.  If
.I enabled 
is not specified, all services are assumed to be enabled,
except those listed in 
.I disabled.

.\" *********************** INTERNAL SERVICES ****************************
.SH "INTERNAL SERVICES"
.LP
\fBxinetd\fP provides the following services internally (both
stream and datagram based):
.I echo,
.I time,
.I daytime,
.I chargen,
and
.I discard.
These services are under the same access restrictions as all other
services except for the ones that don't require \fBxinetd\fP to fork
another process for them. Those ones (\fItime\fP, \fIdaytime\fP,
and the datagram-based \fIecho\fP, \fIchargen\fP, and \fIdiscard\fP) 
have no limitation in the number of 
.B instances.
.LP
.\" *********************** TCPMUX Services ****************************
.SH "TCPMUX Services"
.LP
\fBxinetd\fP supports TCPMUX services that conform to RFC 1078. These services 
may not have a well-known port associated with them, and can be accessed via 
the TCPMUX well-known port.
.LP
For each service that is to be accessed via TCPMUX, a service entry in
\fB/etc/xinetd.conf\fP or in a configuration file in an \fBincludedir\fP 
directory must exist.
.LP
The \fIservice_name\fP field (as defined above for each service in any 
\fBxinetd\fP 
configuration file) must be identical to the string that is passed (according 
to RFC 1078 protocol) to \fBxinetd\fP when the remote service requestor first 
makes the connection on the TCPMUX well-known port.  Private protocols should 
use a service name that has a high probability of being unique. One way is to 
prepend the service name with some form of organization ID.
.LP
The \fItype\fP field can be either \fBTCPMUX\fP or \fBTCPMUXPLUS\fP. If the
type is \fBTCPMUXPLUS\fP, \fBxinetd\fP will handle the initial protocol
handshake (as defined in RFC 1078) with the calling process before initiating
the service. If the type is \fBTCPMUX\fP, the server that is started is
responsible for performing the handshake.
.LP
The \fItype\fP field should also include \fBUNLISTED\fP if the service is
not listed in a standard system file
(like
.I /etc/rpc
for RPC services, or
.I /etc/services
for non-RPC services).
.LP	
The \fIsocket_type\fP for these services must be \fBstream\fP, and the 
\fIprotocol\fP must be \fBtcp\fP.
.LP
Following is a sample TCPMUX service configuration:
.PD .1v
.RS
.nf

service myorg_server
{
.RS
.IP disable 20
= no
.IP type
= TCPMUX
.IP socket_type
= stream
.IP protocol
= tcp
.IP wait
= no
.IP user
= root
.IP server
= /usr/etc/my_server_exec
.RE
}
.fi
.RE
.PD
.LP
Besides a service entry for each service that can be accessed
via the TCPMUX well-known port, a service entry for TCPMUX itself
must also be included in the \fBxinetd\fP configuration. Consider the following
sample:
.PD .1v
.RS
.nf

service tcpmux
{
.RS
.IP type 20
= INTERNAL
.IP id
= tcpmux
.IP socket_type
= stream
.IP protocol
= tcp
.IP user
= root
.IP wait
= no
.RE
}
.fi
.RE
.PD                                                                               



.\" *********************** NOTES ****************************
.SH NOTES
.IP 1. 4
The following service attributes \fIcannot\fP be changed on reconfiguration:
.B socket_type,
.B wait,
.B protocol,
.B type.
.IP 2.
When the attributes
.I only_from
and
.I no_access
are not specified for a service (either directly or via \fIdefaults\fP)
the address check is considered successful (i.e. access will not be
denied).
.IP 3.
The address check is based on the IP address of the remote host and
not on its domain address. We do this so that we can avoid
remote name lookups which may take a long time (since
.B xinetd
is single-threaded, a name lookup will prevent the daemon from
accepting any other requests until the lookup is resolved).
The down side of this scheme is that if the IP address of a remote
host changes, then access to that host may be denied until
.B xinetd
is reconfigured.
Whether access is actually denied or not will depend on whether the
new host IP address is among those allowed access. For example, if
the IP address of a host changes from 1.2.3.4 to 1.2.3.5 and 
only_from is specified as 1.2.3.0 then access will not be denied.
.IP 4.
If the
.B USERID
log option is specified and the remote host either does not run an 
identification server or the server sends back a bad reply,
access will not be denied unless the
.I IDONLY
service flag is used.
.IP 5.
Interception works by forking a process which acts as a filter
between the remote host(s) and the local server. 
This obviously has a performance impact so
it is up to you to make the compromise between security and performance
for each service.
The following tables show the overhead of interception.
The first table shows the time overhead-per-datagram for a UDP-based service
using various datagram sizes.
For TCP-based services we measured the bandwidth reduction 
because of interception while sending
a certain amount of data from client to server (the time overhead should
the same as for UDP-based services but it is "paid" only by the first
packet of a continuous data transmission).
The amount of data is given
in the table as \fIsystem_calls\fPx\fIdata_sent_per_call\fP, i.e.
each
.I "send(2)"
system call transferred so many bytes of data. 
The bandwidth reduction is given in terms of bytes per second and as
a percentage of the bandwidth when interception is not performed.
All measurements were done on a SparcStation IPC running SunOS 4.1.
.sp 1
.RS
.RS
.PD .1v
.TP 25
Datagram size (bytes)
Latency (msec)
.TP
---------------------
--------------
.TP
64
1.19
.TP
256
1.51
.TP
1024
1.51
.TP
4096
3.58
.sp 2
.TP
Bytes sent
Bandwidth reduction
.TP
----------
-------------------
.TP
10000x64
941 (1.2%)
.TP
10000x256
4,231 (1.8%)
.TP
10000x1024
319,300 (39.5%)
.TP
10000x4096
824,461 (62.1%)
.RE
.RE
.sp 1
.\" *********************** EXAMPLE ****************************
.SH EXAMPLE
.LP
.PD .1v
.RS
.nf
#
# Sample configuration file for xinetd
#

defaults
{
.RS
.IP log_type 20
= FILE /var/log/servicelog
.IP log_on_success
= PID
.IP log_on_failure 
= HOST 
.IP only_from
= 128.138.193.0 128.138.204.0 
.IP only_from
= 128.138.252.1 
.IP instances
= 10
.IP disabled
= rstatd
.RE
}

#
# Note 1: the protocol attribute is not required
# Note 2: the instances attribute overrides the default
#
service login
{
.RS
.IP socket_type 20
= stream
.IP protocol
= tcp
.IP wait
= no
.IP user
= root
.IP server
= /usr/etc/in.rlogind
.IP instances
= UNLIMITED
.RE
}

#
# Note 1: the instances attribute overrides the default
# Note 2: the log_on_success flags are augmented
#
service shell
{
.RS
.IP socket_type 20
= stream
.IP wait
= no
.IP user
= root
.IP instances
= UNLIMITED
.IP server
= /usr/etc/in.rshd
.IP log_on_success
+= HOST 
.RE
}

service ftp
{
.RS
.IP socket_type 20
= stream
.IP wait
= no
.IP nice
= 10
.IP user
= root
.IP server
= /usr/etc/in.ftpd
.IP server_args
= -l
.IP instances
= 4
.IP log_on_success
+= DURATION HOST USERID
.IP access_times
= 2:00-9:00 12:00-24:00
.RE
}

# Limit telnet sessions to 8 Mbytes of memory and a total
# 20 CPU seconds for child processes.
service telnet
{
.RS
.IP socket_type 20
= stream
.IP wait
= no
.IP nice
= 10
.IP user
= root
.IP server
= /usr/etc/in.telnetd
.IP rlimit_as
= 8M
.IP rlimit_cpu
= 20
.RE
}

#
# This entry and the next one specify internal services. Since
# this is the same service using a different socket type, the
# id attribute is used to uniquely identify each entry
#
service echo
{
.RS
.IP id 20
= echo-stream
.IP type
= INTERNAL
.IP socket_type
= stream
.IP user
= root
.IP wait
= no
.RE
}

service echo
{
.RS
.IP id 20
= echo-dgram
.IP type
= INTERNAL
.IP socket_type
= dgram
.IP user
= root
.IP wait
= no
.RE
}

#
# Sample RPC service
#
service rstatd
{
.RS
.IP type 20
= RPC
.IP socket_type
= dgram
.IP protocol
= udp
.IP server
= /usr/etc/rpc.rstatd
.IP wait
= yes
.IP user
= root
.IP rpc_version
= 2-4
.IP env
= LD_LIBRARY_PATH=/etc/securelib
.RE
}

#
# Sample unlisted service
#
service unlisted
{
.RS
.IP type 20
= UNLISTED
.IP socket_type
= stream
.IP protocol
= tcp
.IP wait
= no
.IP server
= /home/user/some_server
.IP port
= 20020
.RE
}
.RE
.PD
.\" *********************** SEE ALSO ****************************
.SH "SEE ALSO"
.I "xinetd(1L),"
.LP
.I "xinetd.log(5)"
.LP
Postel J.,
.IR "Echo Protocol" ,
RFC 862,
May 1983
.LP
Postel J.,
.IR "Discard Protocol" ,
RFC 863,
May 1983
.LP
Postel J.,
.IR "Character Generator Protocol" ,
RFC 864,
May 1983
.LP
Postel J.,
.IR "Daytime Protocol" ,
RFC 867,
May 1983
.LP
Postel J., Harrenstien K.,
.IR "Time Protocol" ,
RFC 868,
May 1983
.LP
M. Lottor,
.IR "TCP Port Service Multiplexer (TCPMUX)" ,
RFC 1078
Nov 1988
.LP
StJohns M.,
.IR " Identification Protocol" ,
RFC 1413,
February 1993
.\" *********************** BUGS ****************************
.SH BUGS
.LP
If the
.B INTERCEPT
flag is not used,
access control on the address of the remote host is not performed when
\fIwait\fP is \fIyes\fP and \fIsocket_type\fP is \fIstream\fP.
.LP
The NOLIBWRAP flag is automatically turned on for RPC services whose
\fIsocket_type\fP is \fIstream\fP because xinetd cannot determine the
address of the remote host.
.LP
If the 
.B INTERCEPT
flag is not used,
access control on the address of the remote host for
services where \fIwait\fP is \fIyes\fP and \fIsocket_type\fP is \fIdgram\fP
is performed only on the first packet. The server may then accept packets
from hosts not in the access control list. This can happen with 
.B RPC
services.
.LP
There is no way to put a
.SM SPACE
in an environment variable.
.LP
When \fIwait\fP is \fIyes\fP and \fIsocket_type\fP is \fIstream\fP,
the socket passed to the server can only accept connections.
.LP
The
.B INTERCEPT
flag is not supported for internal services or multi-threaded services.
