/*
 * Decompiled with CFR 0.152.
 */
package org.anywikidraw.pmwiki;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import org.anywikidraw.any.AbstractDrawingApplet;
import org.anywikidraw.any.DrawingPanel;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.ImageInputFormat;
import org.jhotdraw.draw.ImageOutputFormat;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.gui.DrawingComponent;
import org.jhotdraw.samples.svg.gui.ProgressIndicator;
import org.jhotdraw.samples.svg.gui.ServerAuthenticationException;
import org.jhotdraw.samples.svg.io.ClientHttpRequest;
import org.jhotdraw.samples.svg.io.ImageMapOutputFormat;
import org.jhotdraw.samples.svg.io.SVGOutputFormat;
import org.jhotdraw.samples.svg.io.SVGZInputFormat;
import org.jhotdraw.samples.svg.io.SVGZOutputFormat;
import org.jhotdraw.util.ResourceBundleUtil;

public class PmWikiDrawingApplet
extends AbstractDrawingApplet {
    private static char[] password = null;

    public PmWikiDrawingApplet() {
        this.setName(MessageFormat.format("AnyWikiDraw {0} for PmWiki", this.getVersion()));
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PmWikiDrawingApplet pmWikiDrawingApplet = new PmWikiDrawingApplet();
                JFrame jFrame = new JFrame(pmWikiDrawingApplet.getName());
                jFrame.getContentPane().setLayout(new BorderLayout());
                jFrame.setDefaultCloseOperation(3);
                jFrame.getContentPane().add((Component)pmWikiDrawingApplet, "Center");
                jFrame.setSize(400, 400);
                pmWikiDrawingApplet.init();
                jFrame.setVisible(true);
            }
        });
    }

    @Override
    protected Drawing createDrawing() {
        DefaultDrawing defaultDrawing = new DefaultDrawing();
        LinkedList<InputFormat> linkedList = new LinkedList<InputFormat>();
        linkedList.add(new SVGZInputFormat());
        linkedList.add(new ImageInputFormat(new SVGImageFigure()));
        linkedList.add(new ImageInputFormat(new SVGImageFigure(), "JPEG", "JPEG", "jpg", 1));
        LinkedList<OutputFormat> linkedList2 = new LinkedList<OutputFormat>();
        linkedList2.add(new SVGOutputFormat());
        linkedList2.add(new SVGZOutputFormat());
        linkedList2.add(new ImageOutputFormat());
        linkedList2.add(new ImageOutputFormat("JPG", "Joint Photographics Experts Group (JPEG)", "jpg", 1));
        linkedList2.add(new ImageOutputFormat("BMP", "Windows Bitmap (BMP)", "bmp", 13));
        defaultDrawing.setInputFormats(linkedList);
        defaultDrawing.setOutputFormats(linkedList2);
        if (this.getParameter("DrawingWidth") != null && this.getParameter("DrawingHeight") != null) {
            try {
                double d = Double.parseDouble(this.getParameter("DrawingWidth"));
                double d2 = Double.parseDouble(this.getParameter("DrawingHeight"));
                if (d > 0.0 && d2 > 0.0) {
                    SVGAttributeKeys.CANVAS_WIDTH.set(defaultDrawing, d);
                    SVGAttributeKeys.CANVAS_HEIGHT.set(defaultDrawing, d2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultDrawing;
    }

    @Override
    protected DrawingComponent createDrawingComponent() {
        DrawingPanel drawingPanel = new DrawingPanel();
        drawingPanel.setSummaryVisible(false);
        return drawingPanel;
    }

    @Override
    protected DrawingPanel getDrawingComponent() {
        return (DrawingPanel)super.getDrawingComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void saveDrawing(Drawing drawing, ProgressIndicator progressIndicator) throws IOException, ServerAuthenticationException {
        block27: {
            Object object;
            Closeable closeable;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string = this.getParameter("DrawingName");
            String string2 = string = string == null ? "" : string.substring(string.lastIndexOf(46) + 1);
            if (string.equals("")) {
                string = "svg";
            }
            byte[] byArray = null;
            for (OutputFormat object32 : drawing.getOutputFormats()) {
                if (!string.equals(object32.getFileExtension())) continue;
                object32.write(byteArrayOutputStream, drawing);
                byArray = byteArrayOutputStream.toByteArray();
                break;
            }
            if (byArray == null) {
                throw new IOException("Unsupported file format.");
            }
            Dimension dimension = new Dimension(-1, -1);
            try {
                dimension.width = Integer.parseInt(this.getParameter("DrawingWidth"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dimension.height = Integer.parseInt(this.getParameter("DrawingHeight"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dimension.width == -1 || dimension.height == -1) {
                void var7_13;
                Object var7_12 = null;
                for (Figure figure : drawing.getChildren()) {
                    if (var7_13 == null) {
                        Rectangle2D.Double double_ = figure.getDrawingArea();
                        continue;
                    }
                    var7_13.add(figure.getDrawingArea());
                }
                if (dimension.width == -1) {
                    dimension.width = (int)(Math.abs(var7_13.x) + var7_13.getWidth());
                }
                if (dimension.height == -1) {
                    dimension.height = (int)(Math.abs(var7_13.y) + var7_13.getHeight());
                }
            }
            Object var7_16 = null;
            Object object2 = null;
            if (string.startsWith("svg")) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                ImageOutputFormat imageOutputFormat = new ImageOutputFormat();
                imageOutputFormat.write(byteArrayOutputStream, drawing, new AffineTransform(), dimension);
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream = new ByteArrayOutputStream();
                closeable = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
                ((Writer)closeable).write("<map name=\"" + this.getParameter("DrawingName") + "\" id=\"" + this.getParameter("DrawingName") + "\">");
                ((OutputStreamWriter)closeable).flush();
                object = new ImageMapOutputFormat();
                ((ImageMapOutputFormat)object).write((OutputStream)byteArrayOutputStream, drawing, new AffineTransform(), dimension);
                ((Writer)closeable).write("</map>");
                ((OutputStreamWriter)closeable).flush();
                object2 = byteArrayOutputStream.toByteArray();
            }
            HttpURLConnection httpURLConnection = null;
            closeable = null;
            try {
                String string3;
                void var7_18;
                object = new URL(this.getDocumentBase(), this.getParameter("UploadURL"));
                HttpURLConnection httpURLConnection2 = (HttpURLConnection)((URL)object).openConnection();
                ClientHttpRequest clientHttpRequest = new ClientHttpRequest(httpURLConnection2);
                clientHttpRequest.setParameter("pagename", this.getParameter("PageName"));
                if (password != null) {
                    clientHttpRequest.setParameter("authpw", new String(password));
                }
                clientHttpRequest.setParameter("noredirect", "fish");
                clientHttpRequest.setParameter("redirect", "0");
                clientHttpRequest.setParameter("action", this.getParameter("UploadAction"));
                clientHttpRequest.setParameter("UploadDescription", this.getDrawingComponent().getSummary());
                clientHttpRequest.setParameter("DrawingName", this.getParameter("DrawingName"));
                clientHttpRequest.setParameter("DrawingRevision", this.getParameter("DrawingRevision"));
                clientHttpRequest.setParameter("DrawingWidth", Integer.toString(dimension.width));
                clientHttpRequest.setParameter("DrawingHeight", Integer.toString(dimension.height));
                clientHttpRequest.setParameter("DrawingData", this.getParameter("DrawingName"), new ByteArrayInputStream(byArray));
                if (var7_18 != null) {
                    clientHttpRequest.setParameter("RenderedImageData", this.getParameter("DrawingName") + ".png", new ByteArrayInputStream((byte[])var7_18));
                }
                if (object2 != null) {
                    clientHttpRequest.setParameter("ImageMapData", this.getParameter("DrawingName") + ".map", new ByteArrayInputStream((byte[])object2));
                }
                clientHttpRequest.post();
                int n = httpURLConnection2.getResponseCode();
                closeable = new BufferedReader(new InputStreamReader(httpURLConnection2.getInputStream(), "UTF-8"));
                StringBuilder stringBuilder = new StringBuilder();
                while (null != (string3 = ((BufferedReader)closeable).readLine())) {
                    stringBuilder.append(string3);
                }
                ((BufferedReader)closeable).close();
                closeable = null;
                Object var9_25 = null;
                if (stringBuilder.indexOf("name='authpw'") != -1) {
                    throw new ServerAuthenticationException();
                }
            }
            catch (ServerAuthenticationException serverAuthenticationException) {
                throw serverAuthenticationException;
            }
            catch (IOException iOException) {
                Object object3;
                if (httpURLConnection == null) break block27;
                StringBuilder stringBuilder = new StringBuilder();
                try {
                    closeable = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream(), "UTF-8"));
                    while (null != (object3 = ((BufferedReader)closeable).readLine())) {
                        stringBuilder.append((String)object3);
                    }
                }
                finally {
                    if (closeable != null) {
                        ((BufferedReader)closeable).close();
                        closeable = null;
                    }
                }
                if (stringBuilder.length() > 0) {
                    object3 = new IOException(stringBuilder.toString());
                    ((Throwable)object3).initCause(iOException);
                    throw object3;
                }
                throw iOException;
            }
        }
    }

    @Override
    protected int showAuthenticationDialog() {
        JPasswordField jPasswordField = new JPasswordField();
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.anywikidraw.any.Labels");
        int n = JOptionPane.showConfirmDialog(this, jPasswordField, resourceBundleUtil.getString("enterPassword"), 2);
        if (n == 0) {
            password = jPasswordField.getPassword();
        }
        return n;
    }

    private void initComponents() {
    }
}

