/* liblouis Braille Translation and Back-Translation Library

Copyright (C) 2012 Swiss Library for the Blind, Visually Impaired and Print Disabled

Copying and distribution of this file, with or without modification,
are permitted in any medium without royalty provided the copyright
notice and this notice are preserved. This file is offered as-is,
without any warranty. */

/* This is not a test per se, i.e. it doesn't invoke any functionality
   of liblouis and compares the result with a known good value.

   Instead it just invokes the liblouis translation machinery on a
   fairly large text. This is done simply to be able to run valgrind
   on a big translation.

   Thanks to this a number of bugs have been found and as I write this
   there are still some memory problems remaining. There are errors
   such as Invalid reads and writes, Conditional jump or move depends
   on uninitialized value and Use of uninitialized value.

   See the section on finding memory leaks in HACKING to find out how
   you can use valgrind to find and possibly fix the remaining
   problems. */

#include <config.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "liblouis.h"
#include "internal.h"

int
main (int argc, char **argv)
{
    const char* strings[] = {
		"I",
		"Alice's Adventures In Wonderland",
		"II",
		"The King and Queen inspecting the tarts",
		"III",
		"Alice's Adventures In Wonderland",
		"By",
		"\n                    Lewis Carroll. ",
		"With Forty-Two\n                        Illustrations",
		"By",
		"\n                    John Tenniel. ",
		"\n                    NEW YORK\n                    1866. ",
		"IV",
		"V",
		"All in the golden afternoon",
		"Full leisurely we glide;",
		"For both our oars, with little skill,",
		"By little arms are plied,",
		"While little hands make vain pretence",
		"Our wanderings to guide.",
		"Ah, cruel Three! In such an hour",
		"Beneath such dreamy weather,",
		"To beg a tale of breath too weak",
		"To stir the tiniest feather!",
		"Yet what can one poor voice avail",
		"Against three tongues together?",
		"VI",
		"Imperious Prima flashes forth",
		"Her edict 'to begin it'--",
		"In gentler tone Secunda hopes",
		"'There will be nonsense in it'--",
		"While Tertia interrupts the tale",
		"Not more than once a minute.",
		"Anon, to sudden silence won,",
		"In fancy they pursue",
		"The dream-child moving through a land",
		"Of wonders wild and new,",
		"In friendly chat with bird or beast--",
		" And half believe it true.",
		"And ever, as the story drained",
		"The wells of fancy dry,",
		"And faintly strove that weary one",
		"To put the subject by,",
		"\"The rest next time--\" \"It is next time!\"",
		"The happy voices cry.",
		"VII",
		"Thus grew the tale of Wonderland:",
		"Thus slowly, one by one,",
		"Its quaint events were hammered out--",
		"And now the tale is done,",
		"And home we steer, a merry crew,",
		"Beneath the setting sun.",
		"Alice! a childish story take,",
		"And with a gentle hand",
		"Lay it where Childhood's dreams are twined",
		"In Memory's mystic band,",
		"Like pilgrim's wither'd wreath of flowers",
		"Pluck'd in a far-off land.",
		"VIII",
		"Contents",
		"IX",
		"I. Down the Rabbit-Hole",
		"II. The Pool of Tears",
		"III. A Caucus-Race and a Long Tale",
		"List of images",
		"The King and Queen inspecting the tarts",
		"White Rabbit checking watch",
		"Alice finding tiny door behind curtain",
		"Alice taking “Drink Me” bottle",
		"Alice stretched tall",
		"Giant Alice watching Rabbit run away",
		"Alice in pool of tears",
		"Alice with Mouse in pool of tears",
		"Mouse telling story to birds and Alice",
		"Dodo presenting thimble",
		"1",
		"White Rabbit checking watch",
		"\n                    Chapter I.                     \n                    Down the Rabbit-Hole\n                ",
		"\n                    Alice was beginning to get very tired of sitting by her sister on\n                    the bank, and of having nothing to do: once or twice she had peeped into the\n                    book her sister was reading, but it had no pictures or conversations in it, ",
		"\"and what is ",
		"2",
		" the use of a book,\"",
		"\n                    thought Alice, \"without pictures or\n                        conversation?\"\n                ",
		" So she was considering in her own mind (as well as she could, for the hot day\n                    made her feel very sleepy and stupid), whether the pleasure of making a\n                    daisy-chain would be worth the trouble of getting up and picking the daisies,\n                    when suddenly a White Rabbit with pink eyes ran close by her. ",
		"There was nothing so very remarkable in that; nor did\n                        Alice think it so very much out of the way to hear\n                    the Rabbitsay to itself, \"Oh dear! Oh dear! I shall\n                        be late!\" (when she thought it over afterwards, it occurred to her that\n                    she ought to have wondered at this, but at the time it all seemed quite\n                    natural); but when the Rabbit actually took a watch out of its\n                        waistcoat-pocket, and looked at it, and then hurried on,\n                        Alice started to her feet, for it flashed across her mind that\n                    she had never before seen a rabbit with either a waistcoat-pocket, or a watch to\n                    take out of it, and, ",
		"3",
		" burning with curiosity, she ran\n                    across the field after it, and fortunately was just in time to see it pop down a\n                    large rabbit-hole under the hedge. ",
		"In another moment down went Alice after it, never once considering\n                    how in the world she was to get out again.",
		"The rabbit-hole went straight on like a tunnel for some way, and then dipped\n                    suddenly down, so suddenly that Alice had not a moment to think\n                    about stopping herself before she found herself falling down a very deep well. ",
		" Either the well was very deep, or she fell very slowly, for she had plenty of\n                    time as she went down to look about her and to wonder what was going to happen\n                    next. First, she tried to look down and make out what she was coming to, but it\n                    was too dark to see anything; then she looked at the sides of the well, and\n                    noticed that they were filled with cupboards and book-shelves; here and there\n                    she saw maps and pictures hung upon pegs. She took down B2 ",
		"4",
		" a jar from one of the shelves as she passed; it was labelled \"ORANGE\n                    MARMALADE\", but to her great disappointment it was empty: she did not like to\n                    drop the jar for fear of killing somebody, so managed to put it into one of the\n                    cupboards as she fell past it. ",
		"\"Well!\" thought Alice to herself, \"after such a fall as this, I shall think nothing of tumbling down stairs!\n                        How brave they'll all think me at home! Why, I wouldn\"t say anything about\n                        it, even if I fell off the top of the house!\"  (Which was very likely\n                    true.) ",
		" Down, down, down. Would the fall never come to an end! \"I wonder how many miles I've fallen by this time?\" she said\n                    aloud. ",
		"\"I must be getting somewhere near the centre of the earth.\n                        Let me see: that would be four thousand miles down, I think—\" (for, you see,\n                            Alice had learnt several things of this sort in her lessons\n                        in the schoolroom, and though this was not a very good\n                        opportunity for showing off her knowledge, as there was no one to listen to\n                            ",
		"5",
		"her, still it was good practice to say it over)\n                        \"—yes, that's about the right distance—but then I wonder what Latitude or\n                        Longitude I've got to?\"",
		" (Alice had no idea what Latitude was, or\n                    Longitude either, but thought they were nice grand words to say.)",
		"Presently she began again. \"I wonder if I shall fall right\n                            through the earth! How funny it'll seem to come out among\n                        the people that walk with their heads downward! The Antipathies, I\n                        think—\" (she was rather glad there was no one listening,\n                    this time, as it didn't sound at all the right word) \" —but I\n                        shall have to ask them what the name of the country is, you know. Please,\n                        Ma'am, is this New Zealand or Australia?\" (and she tried to curtsey as\n                    she spoke—fancy curtseying as you\"re falling through the air! Do\n                    you think you could manage it?) \"And what an ignorant little girl\n                        she'll think me for asking! No, it'll never do to ask: perhaps I shall see\n                        it written up somewhere.\"",
		"6",
		"Down, down, down. There was nothing else to do, so Alice soon began\n                    talking again. \"Dinah 'll miss me very much\n                        to-night, I should think!\" (Dinah was the cat.) \"I hope they'll remember her saucer of milk at tea-time.\n                            Dinah my dear! I wish you were down here with me! There are\n                        no mice in the air, I'm afraid, but you might catch a bat, and that's very\n                        like a mouse, you know. But do cats eat bats, I wonder?\" And here\n                        Alice began to get rather sleepy, and went on saying to\n                    herself, in a dreamy sort of way, \"Do cats eat bats? Do cats eat\n                        bats?\" and sometimes, \"Do bats eat cats?\" for, you\n                    see, as she couldn't answer either question, it didn't much matter which way she\n                    put it. She felt that she was dozing off, and had just begun to dream that she\n                    was walking hand in hand with Dinah, and saying to her very\n                    earnestly, \"Now, Dinah, tell me the truth: did you\n                        ever eat a bat?\" when suddenly, thump! thump! down she came upon a heap\n                    of sticks and dry leaves, and the fall was over.",
		"7",
		"Alice was not a bit hurt, and she jumped up on to her feet in a\n                    moment: she looked up, but it was all dark overhead; before her was another long\n                    passage, and the White Rabbit was still in sight, hurrying down it. There was\n                    not a moment to be lost: away went Alice like the wind, and was\n                    just in time to hear it say, as it turned a corner, \"Oh my ears\n                        and whiskers, how late it's getting!\" She was close behind it when she\n                    turned the corner, but the Rabbitwas no longer to be seen: she\n                    found herself in a long, low hall, which was lit up by a row of lamps hanging\n                    from the roof.",
		"There were doors all round the hall, but they were all locked; and when\n                        Alice had been all the way down one side and up the other,\n                    trying every door, she walked sadly down the middle, wondering how she was ever\n                    to get out again.",
		"Suddenly she came upon a little three-legged table, all made of solid glass;\n                    there was nothing on it except a tiny golden key, and Alice's first thought was\n                    that it might belong to one of the ",
		"8",
		" doors of the hall;\n                    but, alas! either the locks were too large, or the key was too small, but at any\n                    rate it would not open any of them. However, on the second time round, she came\n                    upon a low curtain she had not noticed before, and behind it was a little door\n                    about fifteen inches high: she tried the little golden key in the lock, and to\n                    her great delight it fitted!",
		"Alice finding tiny door behind curtain",
		"Alice opened the door and found that it led into a small passage,\n                    not much larger than a rat-hole: she knelt down and looked along the passage\n                    into the loveliest garden you ever saw. How she longed to get out of that dark\n                    hall, and wander about among those beds of bright ",
		"9",
		" flowers\n                    and those cool fountains, but she could not even get her head though the\n                    doorway; \"and even if my head would go through,\" thought poor\n                        Alice, \"it would be of very little use without\n                        my shoulders. Oh, how I wish I could shut up like a telescope! I think I\n                        could, if I only know how to begin.\" For, you see, so many\n                    out-of-the-way things had happened lately, that Alice had begun to\n                    think that very few things indeed were really impossible.",
		"There seemed to be no use in waiting by the little door, so she went back to the\n                    table, half hoping she might find another key on it, or at any rate a book of\n                    rules for shutting people up like telescopes: this time she found a little\n                    bottle on it, (\"which certainly was not here before,\" said Alice,)\n                    and round the neck of the bottle was a paper label, with the words \"DRINK ME\"\n                    beautifully printed on it in large letters.",
		"It was all very well to say \"Drink me,\" but the wise little Alice\n                    was not going to do that\n                    ",
		"10",
		"in a hurry. \"No, I'll look first,\" she\n                    said, \"and see whether it’s marked 'poison' or not:\" for she\n                    had read several nice little histories about children who had got burnt, and\n                    eaten up by wild beasts and other unpleasant things, all because they\n                        would not remember the simple rules their friends had taught\n                    them: such as, that a red-hot poker will burn you if you hold it too long; and\n                    that if you cut your finger very deeply with a knife, it usually\n                    bleeds; and she had never forgotten that, if you drink much from a bottle marked\n                    \"poison,\" it is almost certain to disagree with you, sooner or later.",
		"Alice taking “Drink Me” bottle",
		"However, this bottle was not marked \"poison,\" ",
		"11",
		" so Alice ventured to taste it, and finding it very nice, (it\n                    had, in fact, a sort of mixed flavour of cherry-tart, custard, pine-apple, roast\n                    turkey, toffee, and hot buttered toast,) she very soon finished it off.",
		"\"What a curious feeling!\" said Alice, \"I must be shutting up like a telescope.\"",
		"And so it was indeed: she was now only ten inches high, and her face brightened\n                    up at the thought that she was now the right size for going through the little\n                    door into that lovely garden. First, however, she waited for a few minutes to\n                    see if she was going to shrink any further: she felt a little nervous about\n                    this; \"for it might end, you know,\" said Alice\n                    to herself, \"in my going out altogether, like a candle. I wonder\n                        what I should be like then?\" And she tried to fancy what the flame of a\n                    candle is like after the candle is blown out, ",
		"12",
		" for she\n                    could not remember ever having seen such a thing.",
		"After a while, finding that nothing more happened, she decided on going into the\n                    garden at once; but, alas for poor Alice! when she got to the door, she found\n                    she had forgotten the little golden key, and when she went back to the table for\n                    it, she found she could not possibly reach it: she could see it quite plainly\n                    through the glass, and she tried her best to climb up one of the legs of the\n                    table, but it was too slippery; and when she had tired herself out with trying,\n                    the poor little thing sat down and cried.",
		"\"Come, there’s no use in crying like that!\" said\n                        Alice to herself, rather sharply; \"I advise you\n                        to leave off this minute!\" She generally gave herself very good advice,\n                    (though she very seldom followed it,) and sometimes she scolded herself so\n                    severely as to bring tears into her eyes; and once she remembered trying to box\n                    her own ears for having cheated herself ",
		"13",
		" in\n                    a game of croquet she was playing against herself, for this curious child was\n                    very fond of pretending to be two people. \"But it’s no use\n                        now,\" thought poor Alice, \"to pretend to be\n                        two people! Why, there's hardly enough of me left to make one\n                        respectable person!\"",
		"Soon her eye fell on a little glass box that was lying under the table: she\n                    opened it, and found in it a very small cake, on which the words \"EAT ME\" were\n                    beautifully marked in currants. \"Well, I’ll eat it,\" said\n                        Alice, \"and if it makes me grow larger, I can\n                        reach the key; and if it makes me grow smaller, I can creep under the door;\n                        so either way I’ll get into the garden, and I don’t care which\n                    happens!\"",
		"She ate a little bit, and said anxiously to herself, ‘Which way?\n                        Which way?’, holding her hand on the top of her head to feel which way\n                    it was growing, and she was quite surprised to find that she remained the same\n                    size: to be sure, this generally happens when one eats cake, but\n                        Alice had got so much into the ",
		"14",
		" way of expecting nothing but out-of-the-way things to happen,\n                    that it seemed quite dull and stupid for life to go on in the common way.",
		"So she set to work, and very soon finished off the cake.",
		"15",
		"CHAPTER II",
		"The Pool of Tears",
		"Alice stretched tall",
		"\"Curiouser and curiouser!\" cried Alice (she was so much surprised,\n                    that for the moment she quite forgot how to speak good English); \"now I'm\n                    opening out like the largest telescope that ever was! Good-bye, feet!\" (for when\n                    she looked down at her feet, they seemed to be almost out of sight, they were\n                    getting so far off). \"Oh, my poor little feet, I wonder ",
		"16",
		"who will put on your shoes and stockings for you now, dears?\n                    I'm sure I shan't be able! I shall be a great deal too far off to\n                    trouble myself about you: you must manage the best way you can; -but I must be\n                    kind to them,\" thought Alice, \"or perhaps they won't walk the way I\n                    want to go! Let me see: I'll give them a new pair of boots every Christmas.\"",
		"And she went on planning to herself how she would manage it. \"They must go by the\n                    carrier,\" she thought; \"and how funny it'll seem, sending presents to one's own\n                    feet! And how odd the directions will look!",
		"Alice's Right Foot, Esq.",
		"    Hearthrug,",
		"        Near the fender,",
		"            (with Alice's love).",
		"Oh dear, what nonsense I'm talking!\"",
		"Just then her head struck against the roof of the hall: in fact she was now more\n                    than nine feet high, and she at once took up the little golden key and hurried\n                    off to the garden door.",
		"17",
		"Poor Alice! It was as much as she could do, lying down on one side, to look\n                    through into the garden with one eye; but to get through was more hopeless than\n                    ever: she sat down and began to cry again.",
		"\"You ought to be ashamed of yourself,\" said Alice, \"a great girl\n                    like you,\" (she might well say this), \"to go on crying in this way! Stop this\n                    moment, I tell you!\" But she went on all the same, shedding gallons of tears,\n                    until there was a large pool all round her, about four inches deep and reaching\n                    half down the hall.",
		"After a time she heard a little pattering of feet in the distance, and she\n                    hastily dried her eyes to see what was coming. It was the White Rabbit\n                    returning, splendidly dressed, with a pair of white kid gloves in one hand and a\n                    large fan in the other: he came trotting along in a great hurry, muttering to\n                    himself as he came, \"Oh! the Duchess, the Duchess! Oh! won't she be savage if\n                    I've kept her waiting!\" Alice felt so desperate that she was ready\n                    to ask help ",
		"18",
		" of any one; so, when the\n                        Rabbitcame near her, she began, in a low, timid voice, \"If you\n                    please, sir-\" The Rabbit started violently, dropped the white kid gloves and the\n                    fan, and skurried away into the darkness as hard as he could go.",
		"Giant Alice watching Rabbit run away",
		"19",
		"Alice took up the fan and gloves, and, as the hall was very hot, she\n                    kept fanning herself all the time she went on talking: \"Dear, dear! How queer\n                    everything is to-day! And yesterday things went on just as usual. I wonder if\n                    I've been changed in the night? Let me think: was I the same when I got up this\n                    morning? I almost think I can remember feeling a little different. But if I'm\n                    not the same, the next question is, Who in the world am I? Ah,\n                        that's the great puzzle!\" And she began thinking over all the\n                    children she knew that were of the same age as herself, to see if she could have\n                    been changed for any of them.",
		"\"I'm sure I'm not Ada,\" she said, \"for her hair goes in such long ringlets, and\n                    mine doesn't go in ringlets at all; and I'm sure I can't be Mabel, for I know\n                    all sorts of things, and she, oh! she knows such a very little! Besides,\n                        she's she, and I'm I, and-oh dear, how puzzling it all is! I'll\n                    try if I know all the things I used to know. Let me see: four times five is\n                    twelve, ",
		"20",
		" and four times six is thirteen, and\n                    four times seven is-oh dear! I shall never get to twenty at that rate! However,\n                    the Multiplication Table doesn't signify: let's try Geography. London is the\n                    capital of Paris, and Paris is the capital of Rome, and Rome-no,\n                        that's all wrong, I'm certain! I must have been changed for\n                    Mabel! I'll try and say \"How doth the little-'\" and she crossed her hands on her\n                    lap as if she were saying lessons, and began to repeat it, but her voice sounded\n                    hoarse and strange, and the words did not come the same as they used to do:-",
		"\"How doth the little crocodile",
		"    Improve his shining tail,",
		"And pour the waters of the Nile",
		"    On every golden scale!",
		"\"How cheerfully he seems to grin,",
		"    How neatly spread his claws,",
		"And welcome little fishes in",
		"    With gently smiling jaws!\"",
		"21",
		"\"I'm sure those are not the right words,\" said poor Alice, and her\n                    eyes filled with tears again as she went on, \"I must be Mabel after all, and I\n                    shall have to go and live in that poky little house, and have next to no toys to\n                    play with, and oh! ever so many lessons to learn! No, I've made up my mind about\n                    it; if I'm Mabel, I'll stay down here! It'll be no use their putting their heads\n                    down and saying \"Come up again, dear!\" I shall only look up and say \"Who am I\n                    then? Tell me that first, and then, if I like being that person, I'll come up:\n                    if not, I'll stay down here till I'm somebody else' -but, oh dear!\" cried\n                        Alice, with a sudden burst of tears, \"I do wish they\n                        would put their heads down! I am so very tired of\n                    being all alone here!\"",
		"As she said this she looked down at her hands, and was surprised to see that she\n                    had put on one of the Rabbit's little white kid gloves while she was talking.\n                    \"How can I have done that?\" she thought. \"I must be growing\n                        small",
		"22",
		" again.\" She got up and went to the\n                    table to measure herself by it, and found that, as nearly as she could guess,\n                    she was now about two feet high, and was going on shrinking rapidly: she soon\n                    found out that the cause of this was the fan she was holding, and she dropped it\n                    hastily, just in time to avoid shrinking away altogether.",
		"\"That was a narrow escape!\" said Alice, a good deal\n                    frightened at the sudden change, but very glad to find herself still in\n                    existence; \"and now for the garden!\" and she ran with all speed back to the\n                    little door: but, alas! the little door was shut again, and the little golden\n                    key was lying on the glass table as before, \"and things are worse than ever,\"\n                    thought the poor child, \"for I never was so small as this before, never! And I\n                    declare it's too bad, that it is!\"",
		"As she said these words her foot slipped, and in another moment, splash! she was\n                    up to her chin in salt water. Her first idea was that she had somehow fallen\n                    into the sea, \"and in ",
		"23",
		"that case I can go\n                    back by railway,\" she said to herself. (Alice had been to the seaside once in\n                    her life, and had come to the general conclusion, that wherever you go to on the\n                    English coast you find a number of bathing machines in the sea, some children\n                    digging in the sand with wooden spades, then a row of lodging houses, and behind\n                    them a railway station.) However, she soon made out that she was in the pool of\n                    tears which she had wept when she was nine feet high.",
		"Alice in pool of tears",
		"\"I wish I hadn't cried so much!\" said Alice, as she swam about,\n                    trying to find her way out.",
		"24",
		" \"I shall be\n                    punished for it now, I suppose, by being drowned in my own tears! That\n                        will be a queer thing, to be sure! However, everything is queer\n                    to-day.\"",
		"Just then she heard something splashing about in the pool a little way off, and\n                    she swam nearer to make out what it was: at first she thought it must be a\n                    walrus or hippopotamus, but then she remembered how small she was now, and she\n                    soon made out that it was only a mouse that had slipped in like herself.",
		"\"Would it be of any use, now,\" thought Alice, \"to speak to this\n                    mouse? Everything is so out-of-the-way down here, that I should think very\n                    likely it can talk: at any rate, there's no harm in trying.\" So she began: \"O\n                    Mouse, do you know the way out of this pool? I am very tired of swimming about\n                    here, O Mouse!\" (Alice thought this must be the right way of speaking to a\n                    mouse: she had never done such a thing before, but she remembered having seen in\n                    her brother's Latin Grammar, \"A mouse- ",
		"25",
		"of a\n                    mouse-to a mouse-a mouse-O mouse!\" The Mouse looked at her rather inquisitively,\n                    and seemed to her to wink with one of its little eyes, but it said nothing.",
		"\"Perhaps it doesn't understand English,\" thought Alice; \"I daresay it's a French mouse, come over with William the\n                        Conqueror.\" (For, with all her knowledge of history, Alice\n                    had no very clear notion how long ago anything had happened.) So she began\n                    again: \"Ou est ma chatte?\" which was the first sentence in\n                    her French lesson-book. The Mousegave a sudden leap out of the\n                    water, and seemed to quiver all over with fright. \"Oh, I beg your\n                        pardon!\" cried Alice hastily, afraid that she had hurt the\n                    poor animal's feelings. \"I quite forgot you didn't like\n                        cats.\"",
		"\"Not like cats!\" cried the Mouse, in a shrill, passionate\n                    voice. \"Would you like cats if you were me?\"",
		"\"Well, perhaps not,\" said Alice in a soothing\n                    tone: ",
		"\"don't be angry about it. And yet ",
		"26",
		"I wish I could show you our cat Dinah: I\n                        think you'd take a fancy to cats if you could only see her. She is such a\n                        dear quiet thing,\"",
		"\n                    Alice went on, half to herself, as she swam lazily ",
		"\n                        Alice with Mousein pool of tears ",
		" about\n                    in the pool, \"and she sits purring so nicely by the fire, licking\n                        her paws and washing her face-and she is such a nice soft thing to nurse-and\n                        she's such a capital one for catching mice-oh, I beg your pardon!\" cried\n                        Alice again, for this time the Mousewas bristling\n                    all over, and she felt certain it must be really ",
		"27",
		" offended. \"We won't talk about her any more if\n                        you'd rather not.\"",
		"\"We indeed!\" cried the Mouse, who was trembling down to the\n                    end of his tail. \"As if I would talk on such a subject! Our\n                        family always hated cats: nasty, low, vulgar things! Don't let\n                        me hear the name again!\"",
		"\"I won't indeed!\" said Alice, in a great hurry to change the subject\n                    of conversation. \"Are you-are you fond-of-of dogs?\" The Mousedid\n                    not answer, so Alice went on eagerly: \"There is such a nice little\n                    dog near our house I should like to show you! A little bright-eyed terrier, you\n                    know, with oh, such long curly brown hair! And it'll fetch things when you throw\n                    them, and it'll sit up and beg for its dinner, and all sorts of things-I can't\n                    remember half of them-and it belongs to a farmer, you know, and he says it's so\n                    useful, it's worth a hundred pounds! He says it kills all the rats and-oh dear!\"\n                    cried Alice in a sorrowful tone, \"I'm afraid I've offended it ",
		"28",
		" again!\" For the Mousewas swimming away from her as\n                    hard as it could go, and making quite a commotion in the pool as it went.",
		"So she called softly after it, \"Mouse dear! Do come back again, and we won't talk\n                    about cats or dogs either, if you don't like them!\" When the\n                    Mouseheard this, it turned round and swam slowly back to her: its\n                    face was quite pale (with passion, Alice thought), and it said in a\n                    low trembling voice, \"Let us get to the shore, and then I'll tell you my\n                    history, and you'll understand why it is I hate cats and dogs.\"",
		"It was high time to go, for the pool was getting quite crowded with the birds and\n                    animals that had fallen into it: there were a Duck and a Dodo, a Lory and an\n                    Eaglet, and several other curious creatures. Alice led the way, and\n                    the whole party swam to the shore.",
		"29",
		"CHAPTER III",
		"A Caucus-Race and a Long Tale",
		"Mouse telling story to birds and Alice",
		"They were indeed a queer-looking party that assembled on the bank-the birds with\n                    draggled feathers, the animals with their fur clinging close to them, and all\n                    dripping wet, cross, and uncomfortable.",
		"The first question of course was, how to get dry again: they had a consultation\n                    about this, ",
		"30",
		" and after a few minutes it seemed quite\n                    natural to Alice to find herself talking familiarly with them, as\n                    if she had known them all her life. Indeed, she had quite a long argument with\n                    the Lory, who at last turned sulky, and would only say, \"I am older than you,\n                    and must know better;\" and this Alice would not allow without\n                    knowing how old it was, and, as the Lory positively refused to tell its age,\n                    there was no more to be said.",
		"At last the Mouse, who seemed to be a person of authority among them, called out,\n                    \"Sit down, all of you, and listen to me! I'll soon make you dry\n                    enough!\" They all sat down at once, in a large ring, with the\n                    Mousein the middle. Alice kept her eyes anxiously\n                    fixed on it, for she felt sure she would catch a bad cold if she did not get dry\n                    very soon.",
		"\"Ahem!\" said the Mousewith an important air, \"are you all ready?\n                    This is the driest thing I know. Silence all round, if you please!\n                        'William the Conqueror, whose cause was ",
		"31",
		" favoured by the pope, was soon submitted to by the English,\n                    who wanted leaders, and had been of late much accustomed to usurpation and\n                    conquest. Edwin and Morcar, the earls of Mercia and\n                    Northumbria-'\"",
		"\"Ugh!\" said the Lory, with a shiver.",
		"\"I beg your pardon?\" said the Mouse, frowning, but very politely: \"Did you\n                    speak?\"",
		"\"Not I!\" said the Lory hastily.",
		"\"I thought you did,\" said the Mouse. -\"I proceed. 'Edwin and\n                        Morcar, the earls of Mercia and Northumbria, declared for him: and even\n                        Stigand, the patriotic archbishop of Canterbury, found it\n                    advisable-'\"",
		"\"Found what?\" said the Duck.",
		"\"Found it,\" the Mouse replied rather crossly: \"of course you know\n                    what 'it' means.\"",
		"\"I know what 'it' means well enough, when I find a thing,\" said the Duck: \"it's\n                    generally a frog or a worm. The question is, what did the archbishop find?\"",
		"The Mousedid not notice this question, but ",
		"32",
		" hurriedly went on, \"'-found it advisable to go with Edgar\n                    Atheling to meet William and offer him the crown. William's conduct at first was\n                    moderate. But the insolence of his Normans-' How are you getting on now, my\n                    dear?\" it continued, turning to Alice as it spoke.",
		"\"As wet as ever,\" said Alice in a melancholy tone: \"it doesn't seem\n                    to dry me at all.\"",
		"\"In that case,\" said the Dodo solemnly, rising to its feet, \"I move that the\n                    meeting adjourn, for the immediate adoption of more energetic remedies-\"",
		"\"Speak English!\" said the Eaglet. \"I don't know the meaning of half those long\n                    words, and, what's more, I don't believe you do either!\" And the Eaglet bent\n                    down its head to hide a smile: some of the other birds tittered audibly.",
		"\"What I was going to say,\" said the Dodo in an offended tone, \"was, that the best\n                    thing to get us dry would be a Caucus-race.\"",
		"\"What is a Caucus-race?\" said Alice; not that she wanted much to\n                    know, but the Dodo ",
		"33",
		" had paused as if it\n                    thought that somebody ought to speak, and no one else seemed\n                    inclined to say anything.",
		"\"Why,\" said the Dodo, \"the best way to explain it is to do it.\" (And, as you\n                    might like to try the thing yourself, some winter day, I will tell you how the\n                    Dodo managed it.)",
		"First it marked out a race-course, in a sort of circle, (\"the exact shape doesn't\n                    matter,\" it said,) and then all the party were placed along the course, here and\n                    there. There was no \"One, two, three, and away,\" but they began running when\n                    they liked, and left off when they liked, so that it was not easy to know when\n                    the race was over. However, when they had been running half an hour or so, and\n                    were quite dry again, the Dodo suddenly called out \"The race is over!\" and they\n                    all crowded round it, panting, and asking, \"But who has won?\"",
		"This question the Dodo could not answer without a great deal of thought, and it\n                    sat for a long time with one finger pressed upon its ",
		"34",
		" forehead (the position in which you usually see Shakespeare,\n                    in the pictures of him), while the rest waited in silence. At last the Dodo\n                    said, \"everybody has won, and all must have prizes.\"",
		"\"But who is to give the prizes?\" quite a chorus of voices asked.",
		"\"Why, she, of course,\" said the Dodo, pointing to Alice\n                    with one finger; and the whole party at once crowded round her, calling out in a\n                    confused way, \"Prizes! Prizes!\"",
		"Alice had no idea what to do, and in despair she put her hand in her\n                    pocket, and pulled out a box of comfits, (luckily the salt water had not got\n                    into it), and handed them round as prizes. There was exactly one a-piece all\n                    round.",
		"\"But she must have a prize herself, you know,\" said the Mouse.",
		"\"Of course,\" the Dodo replied very gravely. \"What else have you got in your\n                    pocket?\" he went on, turning to Alice.",
		"\"Only a thimble,\" said Alice sadly.",
		"\"Hand it over here,\" said the Dodo.",
		"35",
		"Dodo presenting thimble",
		"Then they all crowded round her once more, while the Dodo solemnly presented the\n                    thimble, saying \"We beg your acceptance of this elegant thimble;\" and, when it\n                    had finished this short speech, they all cheered.",
		"36",
		"Alice thought the whole thing very absurd, but they all looked so\n                    grave that she did not dare to laugh; and, as she could not think of anything to\n                    say, she simply bowed, and took the thimble, looking as solemn as she could.",
		"The next thing was to eat the comfits: this caused some noise and confusion, as\n                    the large birds complained that they could not taste theirs, and the small ones\n                    choked and had to be patted on the back. However, it was over at last, and they\n                    sat down again in a ring, and begged the Mouseto tell them\n                    something more.",
		"\"You promised to tell me your history, you know,\" said Alice, \"and\n                    why it is you hate-C and D,\" she added in a whisper, half afraid that it would\n                    be offended again.",
		"\"Mine is a long and a sad tale!\" said the Mouse, turning to Alice,\n                    and sighing.",
		"It is a long tail, certainly,\" said\n                        Alice, looking down with wonder at the Mouse's tail; \"but why do you call it sad?\" And she kept on puzzling about\n                    it while the Mousewas speaking, ",
		"37",
		" so that her idea of the tale was something like this:-",
		"                    \"Fury said to a",
		"                mouse, That he",
		"            met in the",
		"        house,",
		"    \"Let us",
		"        both go to",
		"            law: I will",
		"                prosecute",
		"                    you.-Come,",
		"                        I'll take no",
		"                            denial; We",
		"                        must have a",
		"                    trial: For",
		"                really this",
		"                    morning I've",
		"                        nothing",
		"                            to do.\"",
		"                        Said the",
		"                    mouse to the",
		"                cur, \"Such",
		"                    a trial,",
		"                        dear Sir,",
		"                            With",
		"                                no jury",
		"                            or judge,",
		"                        would be",
		"                    wasting",
		"                our",
		"                    breath.\"",
		"                        \"I'll be",
		"                            judge, I'll",
		"                                be jury,\"",
		"                                    Said",
		"                                        cunning",
		"                                            old Fury:",
		"                                        \"I'll",
		"                                            try the",
		"                                                whole",
		"                                                    cause,",
		"                                                        and",
		"                                                    condemn",
		"                                                you",
		"                                            to",
		"                                        death.\"",
		"38",
		"\"You are not attending!\" said the Mouseto Alice\n                    severely. \"What are you thinking of?\"",
		"\"I beg your pardon,\" said Alice very humbly: \"you had got to the\n                    fifth bend, I think?\"",
		"\"I had not!\" cried the Mouse, sharply and very angrily.",
		"\"A knot!\" said Alice, always ready to make herself useful, and\n                    looking anxiously about her. \"Oh, do let me help to undo it!\"",
		"\"I shall do nothing of the sort,\" said the Mouse, getting up and walking away.\n                    \"You insult me by talking such nonsense!\"",
		"\"I didn't mean it!\" pleaded poor Alice. \"But you're so easily offended, you\n                    know!\"",
		"The Mouseonly growled in reply.",
		"\"Please come back and finish your story!\" Alice called after it; and\n                    the others all joined in chorus, \"Yes, please do!\" but the\n                    Mouseonly shook its head impatiently, and walked a little\n                    quicker.",
		"\"What a pity it wouldn't stay!\" sighed the Lory, as soon as it was quite out of\n                    sight; ",
		"39",
		" and an old Crab took the opportunity\n                    of saying to her daughter \"Ah, my dear! Let this be a lesson to you never to\n                    lose your temper!\" \"Hold your tongue, Ma!\" said the young Crab, a\n                    little snappishly. \"You're enough to try the patience of an oyster!\"",
		"\"I wish I had our Dinah here, I know I do!\" said Alice\n                    aloud, addressing nobody in particular. \"She'd soon fetch it back!\"",
		"\"And who is Dinah, if I might venture to ask the question?\" said the\n                    Lory.",
		"Alice replied eagerly, for she was always ready to talk about her\n                    pet: \"Dinah's our cat. And she's such a capital one for catching\n                    mice you can't think! And oh, I wish you could see her after the birds! Why,\n                    she'll eat a little bird as soon as look at it!\"",
		"This speech caused a remarkable sensation among the party. Some of the birds\n                    hurried off at once: one old Magpie began wrapping itself up very carefully,\n                    remarking, \"I really must be getting home; the night-air doesn't ",
		"40",
		" suit my throat!\" and a Canary called out in a\n                    trembling voice to its children, \"Come away, my dears! It's high time you were\n                    all in bed!\" On various pretexts they all moved off, and Alice was\n                    soon left alone.",
		"\"I wish I hadn't mentioned Dinah!\" she said to herself in a\n                    melancholy tone. \"Nobody seems to like her, down here, and I'm sure she's the\n                    best cat in the world! Oh, my dear Dinah! I wonder if I shall ever\n                    see you any more!\" And here poor Alice began to cry again, for she\n                    felt very lonely and low-spirited. In a little while, however, she again heard a\n                    little pattering of footsteps in the distance, and she looked up eagerly, half\n                    hoping that the Mousehad changed his mind, and was coming back to\n                    finish his story.",		"I",
		"Alice's Adventures In Wonderland",
		"II",
		"The King and Queen inspecting the tarts",
		"III",
		"Alice's Adventures In Wonderland",
		"By",
		"\n                    Lewis Carroll. ",
		"With Forty-Two\n                        Illustrations",
		"By",
		"\n                    John Tenniel. ",
		"\n                    NEW YORK\n                    1866. ",
		"IV",
		"V",
		"All in the golden afternoon",
		"Full leisurely we glide;",
		"For both our oars, with little skill,",
		"By little arms are plied,",
		"While little hands make vain pretence",
		"Our wanderings to guide.",
		"Ah, cruel Three! In such an hour",
		"Beneath such dreamy weather,",
		"To beg a tale of breath too weak",
		"To stir the tiniest feather!",
		"Yet what can one poor voice avail",
		"Against three tongues together?",
		"VI",
		"Imperious Prima flashes forth",
		"Her edict 'to begin it'--",
		"In gentler tone Secunda hopes",
		"'There will be nonsense in it'--",
		"While Tertia interrupts the tale",
		"Not more than once a minute.",
		"Anon, to sudden silence won,",
		"In fancy they pursue",
		"The dream-child moving through a land",
		"Of wonders wild and new,",
		"In friendly chat with bird or beast--",
		" And half believe it true.",
		"And ever, as the story drained",
		"The wells of fancy dry,",
		"And faintly strove that weary one",
		"To put the subject by,",
		"\"The rest next time--\" \"It is next time!\"",
		"The happy voices cry.",
		"VII",
		"Thus grew the tale of Wonderland:",
		"Thus slowly, one by one,",
		"Its quaint events were hammered out--",
		"And now the tale is done,",
		"And home we steer, a merry crew,",
		"Beneath the setting sun.",
		"Alice! a childish story take,",
		"And with a gentle hand",
		"Lay it where Childhood's dreams are twined",
		"In Memory's mystic band,",
		"Like pilgrim's wither'd wreath of flowers",
		"Pluck'd in a far-off land.",
		"VIII",
		"Contents",
		"IX",
		"I. Down the Rabbit-Hole",
		"II. The Pool of Tears",
		"III. A Caucus-Race and a Long Tale",
		"List of images",
		"The King and Queen inspecting the tarts",
		"White Rabbit checking watch",
		"Alice finding tiny door behind curtain",
		"Alice taking “Drink Me” bottle",
		"Alice stretched tall",
		"Giant Alice watching Rabbit run away",
		"Alice in pool of tears",
		"Alice with Mouse in pool of tears",
		"Mouse telling story to birds and Alice",
		"Dodo presenting thimble",
		"1",
		"White Rabbit checking watch",
		"\n                    Chapter I.                     \n                    Down the Rabbit-Hole\n                ",
		"\n                    Alice was beginning to get very tired of sitting by her sister on\n                    the bank, and of having nothing to do: once or twice she had peeped into the\n                    book her sister was reading, but it had no pictures or conversations in it, ",
		"\"and what is ",
		"2",
		" the use of a book,\"",
		"\n                    thought Alice, \"without pictures or\n                        conversation?\"\n                ",
		" So she was considering in her own mind (as well as she could, for the hot day\n                    made her feel very sleepy and stupid), whether the pleasure of making a\n                    daisy-chain would be worth the trouble of getting up and picking the daisies,\n                    when suddenly a White Rabbit with pink eyes ran close by her. ",
		"There was nothing so very remarkable in that; nor did\n                        Alice think it so very much out of the way to hear\n                    the Rabbitsay to itself, \"Oh dear! Oh dear! I shall\n                        be late!\" (when she thought it over afterwards, it occurred to her that\n                    she ought to have wondered at this, but at the time it all seemed quite\n                    natural); but when the Rabbit actually took a watch out of its\n                        waistcoat-pocket, and looked at it, and then hurried on,\n                        Alice started to her feet, for it flashed across her mind that\n                    she had never before seen a rabbit with either a waistcoat-pocket, or a watch to\n                    take out of it, and, ",
		"3",
		" burning with curiosity, she ran\n                    across the field after it, and fortunately was just in time to see it pop down a\n                    large rabbit-hole under the hedge. ",
		"In another moment down went Alice after it, never once considering\n                    how in the world she was to get out again.",
		"The rabbit-hole went straight on like a tunnel for some way, and then dipped\n                    suddenly down, so suddenly that Alice had not a moment to think\n                    about stopping herself before she found herself falling down a very deep well. ",
		" Either the well was very deep, or she fell very slowly, for she had plenty of\n                    time as she went down to look about her and to wonder what was going to happen\n                    next. First, she tried to look down and make out what she was coming to, but it\n                    was too dark to see anything; then she looked at the sides of the well, and\n                    noticed that they were filled with cupboards and book-shelves; here and there\n                    she saw maps and pictures hung upon pegs. She took down B2 ",
		"4",
		" a jar from one of the shelves as she passed; it was labelled \"ORANGE\n                    MARMALADE\", but to her great disappointment it was empty: she did not like to\n                    drop the jar for fear of killing somebody, so managed to put it into one of the\n                    cupboards as she fell past it. ",
		"\"Well!\" thought Alice to herself, \"after such a fall as this, I shall think nothing of tumbling down stairs!\n                        How brave they'll all think me at home! Why, I wouldn\"t say anything about\n                        it, even if I fell off the top of the house!\"  (Which was very likely\n                    true.) ",
		" Down, down, down. Would the fall never come to an end! \"I wonder how many miles I've fallen by this time?\" she said\n                    aloud. ",
		"\"I must be getting somewhere near the centre of the earth.\n                        Let me see: that would be four thousand miles down, I think—\" (for, you see,\n                            Alice had learnt several things of this sort in her lessons\n                        in the schoolroom, and though this was not a very good\n                        opportunity for showing off her knowledge, as there was no one to listen to\n                            ",
		"5",
		"her, still it was good practice to say it over)\n                        \"—yes, that's about the right distance—but then I wonder what Latitude or\n                        Longitude I've got to?\"",
		" (Alice had no idea what Latitude was, or\n                    Longitude either, but thought they were nice grand words to say.)",
		"Presently she began again. \"I wonder if I shall fall right\n                            through the earth! How funny it'll seem to come out among\n                        the people that walk with their heads downward! The Antipathies, I\n                        think—\" (she was rather glad there was no one listening,\n                    this time, as it didn't sound at all the right word) \" —but I\n                        shall have to ask them what the name of the country is, you know. Please,\n                        Ma'am, is this New Zealand or Australia?\" (and she tried to curtsey as\n                    she spoke—fancy curtseying as you\"re falling through the air! Do\n                    you think you could manage it?) \"And what an ignorant little girl\n                        she'll think me for asking! No, it'll never do to ask: perhaps I shall see\n                        it written up somewhere.\"",
		"6",
		"Down, down, down. There was nothing else to do, so Alice soon began\n                    talking again. \"Dinah 'll miss me very much\n                        to-night, I should think!\" (Dinah was the cat.) \"I hope they'll remember her saucer of milk at tea-time.\n                            Dinah my dear! I wish you were down here with me! There are\n                        no mice in the air, I'm afraid, but you might catch a bat, and that's very\n                        like a mouse, you know. But do cats eat bats, I wonder?\" And here\n                        Alice began to get rather sleepy, and went on saying to\n                    herself, in a dreamy sort of way, \"Do cats eat bats? Do cats eat\n                        bats?\" and sometimes, \"Do bats eat cats?\" for, you\n                    see, as she couldn't answer either question, it didn't much matter which way she\n                    put it. She felt that she was dozing off, and had just begun to dream that she\n                    was walking hand in hand with Dinah, and saying to her very\n                    earnestly, \"Now, Dinah, tell me the truth: did you\n                        ever eat a bat?\" when suddenly, thump! thump! down she came upon a heap\n                    of sticks and dry leaves, and the fall was over.",
		"7",
		"Alice was not a bit hurt, and she jumped up on to her feet in a\n                    moment: she looked up, but it was all dark overhead; before her was another long\n                    passage, and the White Rabbit was still in sight, hurrying down it. There was\n                    not a moment to be lost: away went Alice like the wind, and was\n                    just in time to hear it say, as it turned a corner, \"Oh my ears\n                        and whiskers, how late it's getting!\" She was close behind it when she\n                    turned the corner, but the Rabbitwas no longer to be seen: she\n                    found herself in a long, low hall, which was lit up by a row of lamps hanging\n                    from the roof.",
		"There were doors all round the hall, but they were all locked; and when\n                        Alice had been all the way down one side and up the other,\n                    trying every door, she walked sadly down the middle, wondering how she was ever\n                    to get out again.",
		"Suddenly she came upon a little three-legged table, all made of solid glass;\n                    there was nothing on it except a tiny golden key, and Alice's first thought was\n                    that it might belong to one of the ",
		"8",
		" doors of the hall;\n                    but, alas! either the locks were too large, or the key was too small, but at any\n                    rate it would not open any of them. However, on the second time round, she came\n                    upon a low curtain she had not noticed before, and behind it was a little door\n                    about fifteen inches high: she tried the little golden key in the lock, and to\n                    her great delight it fitted!",
		"Alice finding tiny door behind curtain",
		"Alice opened the door and found that it led into a small passage,\n                    not much larger than a rat-hole: she knelt down and looked along the passage\n                    into the loveliest garden you ever saw. How she longed to get out of that dark\n                    hall, and wander about among those beds of bright ",
		"9",
		" flowers\n                    and those cool fountains, but she could not even get her head though the\n                    doorway; \"and even if my head would go through,\" thought poor\n                        Alice, \"it would be of very little use without\n                        my shoulders. Oh, how I wish I could shut up like a telescope! I think I\n                        could, if I only know how to begin.\" For, you see, so many\n                    out-of-the-way things had happened lately, that Alice had begun to\n                    think that very few things indeed were really impossible.",
		"There seemed to be no use in waiting by the little door, so she went back to the\n                    table, half hoping she might find another key on it, or at any rate a book of\n                    rules for shutting people up like telescopes: this time she found a little\n                    bottle on it, (\"which certainly was not here before,\" said Alice,)\n                    and round the neck of the bottle was a paper label, with the words \"DRINK ME\"\n                    beautifully printed on it in large letters.",
		"It was all very well to say \"Drink me,\" but the wise little Alice\n                    was not going to do that\n                    ",
		"10",
		"in a hurry. \"No, I'll look first,\" she\n                    said, \"and see whether it’s marked 'poison' or not:\" for she\n                    had read several nice little histories about children who had got burnt, and\n                    eaten up by wild beasts and other unpleasant things, all because they\n                        would not remember the simple rules their friends had taught\n                    them: such as, that a red-hot poker will burn you if you hold it too long; and\n                    that if you cut your finger very deeply with a knife, it usually\n                    bleeds; and she had never forgotten that, if you drink much from a bottle marked\n                    \"poison,\" it is almost certain to disagree with you, sooner or later.",
		"Alice taking “Drink Me” bottle",
		"However, this bottle was not marked \"poison,\" ",
		"11",
		" so Alice ventured to taste it, and finding it very nice, (it\n                    had, in fact, a sort of mixed flavour of cherry-tart, custard, pine-apple, roast\n                    turkey, toffee, and hot buttered toast,) she very soon finished it off.",
		"\"What a curious feeling!\" said Alice, \"I must be shutting up like a telescope.\"",
		"And so it was indeed: she was now only ten inches high, and her face brightened\n                    up at the thought that she was now the right size for going through the little\n                    door into that lovely garden. First, however, she waited for a few minutes to\n                    see if she was going to shrink any further: she felt a little nervous about\n                    this; \"for it might end, you know,\" said Alice\n                    to herself, \"in my going out altogether, like a candle. I wonder\n                        what I should be like then?\" And she tried to fancy what the flame of a\n                    candle is like after the candle is blown out, ",
		"12",
		" for she\n                    could not remember ever having seen such a thing.",
		"After a while, finding that nothing more happened, she decided on going into the\n                    garden at once; but, alas for poor Alice! when she got to the door, she found\n                    she had forgotten the little golden key, and when she went back to the table for\n                    it, she found she could not possibly reach it: she could see it quite plainly\n                    through the glass, and she tried her best to climb up one of the legs of the\n                    table, but it was too slippery; and when she had tired herself out with trying,\n                    the poor little thing sat down and cried.",
		"\"Come, there’s no use in crying like that!\" said\n                        Alice to herself, rather sharply; \"I advise you\n                        to leave off this minute!\" She generally gave herself very good advice,\n                    (though she very seldom followed it,) and sometimes she scolded herself so\n                    severely as to bring tears into her eyes; and once she remembered trying to box\n                    her own ears for having cheated herself ",
		"13",
		" in\n                    a game of croquet she was playing against herself, for this curious child was\n                    very fond of pretending to be two people. \"But it’s no use\n                        now,\" thought poor Alice, \"to pretend to be\n                        two people! Why, there's hardly enough of me left to make one\n                        respectable person!\"",
		"Soon her eye fell on a little glass box that was lying under the table: she\n                    opened it, and found in it a very small cake, on which the words \"EAT ME\" were\n                    beautifully marked in currants. \"Well, I’ll eat it,\" said\n                        Alice, \"and if it makes me grow larger, I can\n                        reach the key; and if it makes me grow smaller, I can creep under the door;\n                        so either way I’ll get into the garden, and I don’t care which\n                    happens!\"",
		"She ate a little bit, and said anxiously to herself, ‘Which way?\n                        Which way?’, holding her hand on the top of her head to feel which way\n                    it was growing, and she was quite surprised to find that she remained the same\n                    size: to be sure, this generally happens when one eats cake, but\n                        Alice had got so much into the ",
		"14",
		" way of expecting nothing but out-of-the-way things to happen,\n                    that it seemed quite dull and stupid for life to go on in the common way.",
		"So she set to work, and very soon finished off the cake.",
		"15",
		"CHAPTER II",
		"The Pool of Tears",
		"Alice stretched tall",
		"\"Curiouser and curiouser!\" cried Alice (she was so much surprised,\n                    that for the moment she quite forgot how to speak good English); \"now I'm\n                    opening out like the largest telescope that ever was! Good-bye, feet!\" (for when\n                    she looked down at her feet, they seemed to be almost out of sight, they were\n                    getting so far off). \"Oh, my poor little feet, I wonder ",
		"16",
		"who will put on your shoes and stockings for you now, dears?\n                    I'm sure I shan't be able! I shall be a great deal too far off to\n                    trouble myself about you: you must manage the best way you can; -but I must be\n                    kind to them,\" thought Alice, \"or perhaps they won't walk the way I\n                    want to go! Let me see: I'll give them a new pair of boots every Christmas.\"",
		"And she went on planning to herself how she would manage it. \"They must go by the\n                    carrier,\" she thought; \"and how funny it'll seem, sending presents to one's own\n                    feet! And how odd the directions will look!",
		"Alice's Right Foot, Esq.",
		"    Hearthrug,",
		"        Near the fender,",
		"            (with Alice's love).",
		"Oh dear, what nonsense I'm talking!\"",
		"Just then her head struck against the roof of the hall: in fact she was now more\n                    than nine feet high, and she at once took up the little golden key and hurried\n                    off to the garden door.",
		"17",
		"Poor Alice! It was as much as she could do, lying down on one side, to look\n                    through into the garden with one eye; but to get through was more hopeless than\n                    ever: she sat down and began to cry again.",
		"\"You ought to be ashamed of yourself,\" said Alice, \"a great girl\n                    like you,\" (she might well say this), \"to go on crying in this way! Stop this\n                    moment, I tell you!\" But she went on all the same, shedding gallons of tears,\n                    until there was a large pool all round her, about four inches deep and reaching\n                    half down the hall.",
		"After a time she heard a little pattering of feet in the distance, and she\n                    hastily dried her eyes to see what was coming. It was the White Rabbit\n                    returning, splendidly dressed, with a pair of white kid gloves in one hand and a\n                    large fan in the other: he came trotting along in a great hurry, muttering to\n                    himself as he came, \"Oh! the Duchess, the Duchess! Oh! won't she be savage if\n                    I've kept her waiting!\" Alice felt so desperate that she was ready\n                    to ask help ",
		"18",
		" of any one; so, when the\n                        Rabbitcame near her, she began, in a low, timid voice, \"If you\n                    please, sir-\" The Rabbit started violently, dropped the white kid gloves and the\n                    fan, and skurried away into the darkness as hard as he could go.",
		"Giant Alice watching Rabbit run away",
		"19",
		"Alice took up the fan and gloves, and, as the hall was very hot, she\n                    kept fanning herself all the time she went on talking: \"Dear, dear! How queer\n                    everything is to-day! And yesterday things went on just as usual. I wonder if\n                    I've been changed in the night? Let me think: was I the same when I got up this\n                    morning? I almost think I can remember feeling a little different. But if I'm\n                    not the same, the next question is, Who in the world am I? Ah,\n                        that's the great puzzle!\" And she began thinking over all the\n                    children she knew that were of the same age as herself, to see if she could have\n                    been changed for any of them.",
		"\"I'm sure I'm not Ada,\" she said, \"for her hair goes in such long ringlets, and\n                    mine doesn't go in ringlets at all; and I'm sure I can't be Mabel, for I know\n                    all sorts of things, and she, oh! she knows such a very little! Besides,\n                        she's she, and I'm I, and-oh dear, how puzzling it all is! I'll\n                    try if I know all the things I used to know. Let me see: four times five is\n                    twelve, ",
		"20",
		" and four times six is thirteen, and\n                    four times seven is-oh dear! I shall never get to twenty at that rate! However,\n                    the Multiplication Table doesn't signify: let's try Geography. London is the\n                    capital of Paris, and Paris is the capital of Rome, and Rome-no,\n                        that's all wrong, I'm certain! I must have been changed for\n                    Mabel! I'll try and say \"How doth the little-'\" and she crossed her hands on her\n                    lap as if she were saying lessons, and began to repeat it, but her voice sounded\n                    hoarse and strange, and the words did not come the same as they used to do:-",
		"\"How doth the little crocodile",
		"    Improve his shining tail,",
		"And pour the waters of the Nile",
		"    On every golden scale!",
		"\"How cheerfully he seems to grin,",
		"    How neatly spread his claws,",
		"And welcome little fishes in",
		"    With gently smiling jaws!\"",
		"21",
		"\"I'm sure those are not the right words,\" said poor Alice, and her\n                    eyes filled with tears again as she went on, \"I must be Mabel after all, and I\n                    shall have to go and live in that poky little house, and have next to no toys to\n                    play with, and oh! ever so many lessons to learn! No, I've made up my mind about\n                    it; if I'm Mabel, I'll stay down here! It'll be no use their putting their heads\n                    down and saying \"Come up again, dear!\" I shall only look up and say \"Who am I\n                    then? Tell me that first, and then, if I like being that person, I'll come up:\n                    if not, I'll stay down here till I'm somebody else' -but, oh dear!\" cried\n                        Alice, with a sudden burst of tears, \"I do wish they\n                        would put their heads down! I am so very tired of\n                    being all alone here!\"",
		"As she said this she looked down at her hands, and was surprised to see that she\n                    had put on one of the Rabbit's little white kid gloves while she was talking.\n                    \"How can I have done that?\" she thought. \"I must be growing\n                        small",
		"22",
		" again.\" She got up and went to the\n                    table to measure herself by it, and found that, as nearly as she could guess,\n                    she was now about two feet high, and was going on shrinking rapidly: she soon\n                    found out that the cause of this was the fan she was holding, and she dropped it\n                    hastily, just in time to avoid shrinking away altogether.",
		"\"That was a narrow escape!\" said Alice, a good deal\n                    frightened at the sudden change, but very glad to find herself still in\n                    existence; \"and now for the garden!\" and she ran with all speed back to the\n                    little door: but, alas! the little door was shut again, and the little golden\n                    key was lying on the glass table as before, \"and things are worse than ever,\"\n                    thought the poor child, \"for I never was so small as this before, never! And I\n                    declare it's too bad, that it is!\"",
		"As she said these words her foot slipped, and in another moment, splash! she was\n                    up to her chin in salt water. Her first idea was that she had somehow fallen\n                    into the sea, \"and in ",
		"23",
		"that case I can go\n                    back by railway,\" she said to herself. (Alice had been to the seaside once in\n                    her life, and had come to the general conclusion, that wherever you go to on the\n                    English coast you find a number of bathing machines in the sea, some children\n                    digging in the sand with wooden spades, then a row of lodging houses, and behind\n                    them a railway station.) However, she soon made out that she was in the pool of\n                    tears which she had wept when she was nine feet high.",
		"Alice in pool of tears",
		"\"I wish I hadn't cried so much!\" said Alice, as she swam about,\n                    trying to find her way out.",
		"24",
		" \"I shall be\n                    punished for it now, I suppose, by being drowned in my own tears! That\n                        will be a queer thing, to be sure! However, everything is queer\n                    to-day.\"",
		"Just then she heard something splashing about in the pool a little way off, and\n                    she swam nearer to make out what it was: at first she thought it must be a\n                    walrus or hippopotamus, but then she remembered how small she was now, and she\n                    soon made out that it was only a mouse that had slipped in like herself.",
		"\"Would it be of any use, now,\" thought Alice, \"to speak to this\n                    mouse? Everything is so out-of-the-way down here, that I should think very\n                    likely it can talk: at any rate, there's no harm in trying.\" So she began: \"O\n                    Mouse, do you know the way out of this pool? I am very tired of swimming about\n                    here, O Mouse!\" (Alice thought this must be the right way of speaking to a\n                    mouse: she had never done such a thing before, but she remembered having seen in\n                    her brother's Latin Grammar, \"A mouse- ",
		"25",
		"of a\n                    mouse-to a mouse-a mouse-O mouse!\" The Mouse looked at her rather inquisitively,\n                    and seemed to her to wink with one of its little eyes, but it said nothing.",
		"\"Perhaps it doesn't understand English,\" thought Alice; \"I daresay it's a French mouse, come over with William the\n                        Conqueror.\" (For, with all her knowledge of history, Alice\n                    had no very clear notion how long ago anything had happened.) So she began\n                    again: \"Ou est ma chatte?\" which was the first sentence in\n                    her French lesson-book. The Mousegave a sudden leap out of the\n                    water, and seemed to quiver all over with fright. \"Oh, I beg your\n                        pardon!\" cried Alice hastily, afraid that she had hurt the\n                    poor animal's feelings. \"I quite forgot you didn't like\n                        cats.\"",
		"\"Not like cats!\" cried the Mouse, in a shrill, passionate\n                    voice. \"Would you like cats if you were me?\"",
		"\"Well, perhaps not,\" said Alice in a soothing\n                    tone: ",
		"\"don't be angry about it. And yet ",
		"26",
		"I wish I could show you our cat Dinah: I\n                        think you'd take a fancy to cats if you could only see her. She is such a\n                        dear quiet thing,\"",
		"\n                    Alice went on, half to herself, as she swam lazily ",
		"\n                        Alice with Mousein pool of tears ",
		" about\n                    in the pool, \"and she sits purring so nicely by the fire, licking\n                        her paws and washing her face-and she is such a nice soft thing to nurse-and\n                        she's such a capital one for catching mice-oh, I beg your pardon!\" cried\n                        Alice again, for this time the Mousewas bristling\n                    all over, and she felt certain it must be really ",
		"27",
		" offended. \"We won't talk about her any more if\n                        you'd rather not.\"",
		"\"We indeed!\" cried the Mouse, who was trembling down to the\n                    end of his tail. \"As if I would talk on such a subject! Our\n                        family always hated cats: nasty, low, vulgar things! Don't let\n                        me hear the name again!\"",
		"\"I won't indeed!\" said Alice, in a great hurry to change the subject\n                    of conversation. \"Are you-are you fond-of-of dogs?\" The Mousedid\n                    not answer, so Alice went on eagerly: \"There is such a nice little\n                    dog near our house I should like to show you! A little bright-eyed terrier, you\n                    know, with oh, such long curly brown hair! And it'll fetch things when you throw\n                    them, and it'll sit up and beg for its dinner, and all sorts of things-I can't\n                    remember half of them-and it belongs to a farmer, you know, and he says it's so\n                    useful, it's worth a hundred pounds! He says it kills all the rats and-oh dear!\"\n                    cried Alice in a sorrowful tone, \"I'm afraid I've offended it ",
		"28",
		" again!\" For the Mousewas swimming away from her as\n                    hard as it could go, and making quite a commotion in the pool as it went.",
		"So she called softly after it, \"Mouse dear! Do come back again, and we won't talk\n                    about cats or dogs either, if you don't like them!\" When the\n                    Mouseheard this, it turned round and swam slowly back to her: its\n                    face was quite pale (with passion, Alice thought), and it said in a\n                    low trembling voice, \"Let us get to the shore, and then I'll tell you my\n                    history, and you'll understand why it is I hate cats and dogs.\"",
		"It was high time to go, for the pool was getting quite crowded with the birds and\n                    animals that had fallen into it: there were a Duck and a Dodo, a Lory and an\n                    Eaglet, and several other curious creatures. Alice led the way, and\n                    the whole party swam to the shore.",
		"29",
		"CHAPTER III",
		"A Caucus-Race and a Long Tale",
		"Mouse telling story to birds and Alice",
		"They were indeed a queer-looking party that assembled on the bank-the birds with\n                    draggled feathers, the animals with their fur clinging close to them, and all\n                    dripping wet, cross, and uncomfortable.",
		"The first question of course was, how to get dry again: they had a consultation\n                    about this, ",
		"30",
		" and after a few minutes it seemed quite\n                    natural to Alice to find herself talking familiarly with them, as\n                    if she had known them all her life. Indeed, she had quite a long argument with\n                    the Lory, who at last turned sulky, and would only say, \"I am older than you,\n                    and must know better;\" and this Alice would not allow without\n                    knowing how old it was, and, as the Lory positively refused to tell its age,\n                    there was no more to be said.",
		"At last the Mouse, who seemed to be a person of authority among them, called out,\n                    \"Sit down, all of you, and listen to me! I'll soon make you dry\n                    enough!\" They all sat down at once, in a large ring, with the\n                    Mousein the middle. Alice kept her eyes anxiously\n                    fixed on it, for she felt sure she would catch a bad cold if she did not get dry\n                    very soon.",
		"\"Ahem!\" said the Mousewith an important air, \"are you all ready?\n                    This is the driest thing I know. Silence all round, if you please!\n                        'William the Conqueror, whose cause was ",
		"31",
		" favoured by the pope, was soon submitted to by the English,\n                    who wanted leaders, and had been of late much accustomed to usurpation and\n                    conquest. Edwin and Morcar, the earls of Mercia and\n                    Northumbria-'\"",
		"\"Ugh!\" said the Lory, with a shiver.",
		"\"I beg your pardon?\" said the Mouse, frowning, but very politely: \"Did you\n                    speak?\"",
		"\"Not I!\" said the Lory hastily.",
		"\"I thought you did,\" said the Mouse. -\"I proceed. 'Edwin and\n                        Morcar, the earls of Mercia and Northumbria, declared for him: and even\n                        Stigand, the patriotic archbishop of Canterbury, found it\n                    advisable-'\"",
		"\"Found what?\" said the Duck.",
		"\"Found it,\" the Mouse replied rather crossly: \"of course you know\n                    what 'it' means.\"",
		"\"I know what 'it' means well enough, when I find a thing,\" said the Duck: \"it's\n                    generally a frog or a worm. The question is, what did the archbishop find?\"",
		"The Mousedid not notice this question, but ",
		"32",
		" hurriedly went on, \"'-found it advisable to go with Edgar\n                    Atheling to meet William and offer him the crown. William's conduct at first was\n                    moderate. But the insolence of his Normans-' How are you getting on now, my\n                    dear?\" it continued, turning to Alice as it spoke.",
		"\"As wet as ever,\" said Alice in a melancholy tone: \"it doesn't seem\n                    to dry me at all.\"",
		"\"In that case,\" said the Dodo solemnly, rising to its feet, \"I move that the\n                    meeting adjourn, for the immediate adoption of more energetic remedies-\"",
		"\"Speak English!\" said the Eaglet. \"I don't know the meaning of half those long\n                    words, and, what's more, I don't believe you do either!\" And the Eaglet bent\n                    down its head to hide a smile: some of the other birds tittered audibly.",
		"\"What I was going to say,\" said the Dodo in an offended tone, \"was, that the best\n                    thing to get us dry would be a Caucus-race.\"",
		"\"What is a Caucus-race?\" said Alice; not that she wanted much to\n                    know, but the Dodo ",
		"33",
		" had paused as if it\n                    thought that somebody ought to speak, and no one else seemed\n                    inclined to say anything.",
		"\"Why,\" said the Dodo, \"the best way to explain it is to do it.\" (And, as you\n                    might like to try the thing yourself, some winter day, I will tell you how the\n                    Dodo managed it.)",
		"First it marked out a race-course, in a sort of circle, (\"the exact shape doesn't\n                    matter,\" it said,) and then all the party were placed along the course, here and\n                    there. There was no \"One, two, three, and away,\" but they began running when\n                    they liked, and left off when they liked, so that it was not easy to know when\n                    the race was over. However, when they had been running half an hour or so, and\n                    were quite dry again, the Dodo suddenly called out \"The race is over!\" and they\n                    all crowded round it, panting, and asking, \"But who has won?\"",
		"This question the Dodo could not answer without a great deal of thought, and it\n                    sat for a long time with one finger pressed upon its ",
		"34",
		" forehead (the position in which you usually see Shakespeare,\n                    in the pictures of him), while the rest waited in silence. At last the Dodo\n                    said, \"everybody has won, and all must have prizes.\"",
		"\"But who is to give the prizes?\" quite a chorus of voices asked.",
		"\"Why, she, of course,\" said the Dodo, pointing to Alice\n                    with one finger; and the whole party at once crowded round her, calling out in a\n                    confused way, \"Prizes! Prizes!\"",
		"Alice had no idea what to do, and in despair she put her hand in her\n                    pocket, and pulled out a box of comfits, (luckily the salt water had not got\n                    into it), and handed them round as prizes. There was exactly one a-piece all\n                    round.",
		"\"But she must have a prize herself, you know,\" said the Mouse.",
		"\"Of course,\" the Dodo replied very gravely. \"What else have you got in your\n                    pocket?\" he went on, turning to Alice.",
		"\"Only a thimble,\" said Alice sadly.",
		"\"Hand it over here,\" said the Dodo.",
		"35",
		"Dodo presenting thimble",
		"Then they all crowded round her once more, while the Dodo solemnly presented the\n                    thimble, saying \"We beg your acceptance of this elegant thimble;\" and, when it\n                    had finished this short speech, they all cheered.",
		"36",
		"Alice thought the whole thing very absurd, but they all looked so\n                    grave that she did not dare to laugh; and, as she could not think of anything to\n                    say, she simply bowed, and took the thimble, looking as solemn as she could.",
		"The next thing was to eat the comfits: this caused some noise and confusion, as\n                    the large birds complained that they could not taste theirs, and the small ones\n                    choked and had to be patted on the back. However, it was over at last, and they\n                    sat down again in a ring, and begged the Mouseto tell them\n                    something more.",
		"\"You promised to tell me your history, you know,\" said Alice, \"and\n                    why it is you hate-C and D,\" she added in a whisper, half afraid that it would\n                    be offended again.",
		"\"Mine is a long and a sad tale!\" said the Mouse, turning to Alice,\n                    and sighing.",
		"It is a long tail, certainly,\" said\n                        Alice, looking down with wonder at the Mouse's tail; \"but why do you call it sad?\" And she kept on puzzling about\n                    it while the Mousewas speaking, ",
		"37",
		" so that her idea of the tale was something like this:-",
		"                    \"Fury said to a",
		"                mouse, That he",
		"            met in the",
		"        house,",
		"    \"Let us",
		"        both go to",
		"            law: I will",
		"                prosecute",
		"                    you.-Come,",
		"                        I'll take no",
		"                            denial; We",
		"                        must have a",
		"                    trial: For",
		"                really this",
		"                    morning I've",
		"                        nothing",
		"                            to do.\"",
		"                        Said the",
		"                    mouse to the",
		"                cur, \"Such",
		"                    a trial,",
		"                        dear Sir,",
		"                            With",
		"                                no jury",
		"                            or judge,",
		"                        would be",
		"                    wasting",
		"                our",
		"                    breath.\"",
		"                        \"I'll be",
		"                            judge, I'll",
		"                                be jury,\"",
		"                                    Said",
		"                                        cunning",
		"                                            old Fury:",
		"                                        \"I'll",
		"                                            try the",
		"                                                whole",
		"                                                    cause,",
		"                                                        and",
		"                                                    condemn",
		"                                                you",
		"                                            to",
		"                                        death.\"",
		"38",
		"\"You are not attending!\" said the Mouseto Alice\n                    severely. \"What are you thinking of?\"",
		"\"I beg your pardon,\" said Alice very humbly: \"you had got to the\n                    fifth bend, I think?\"",
		"\"I had not!\" cried the Mouse, sharply and very angrily.",
		"\"A knot!\" said Alice, always ready to make herself useful, and\n                    looking anxiously about her. \"Oh, do let me help to undo it!\"",
		"\"I shall do nothing of the sort,\" said the Mouse, getting up and walking away.\n                    \"You insult me by talking such nonsense!\"",
		"\"I didn't mean it!\" pleaded poor Alice. \"But you're so easily offended, you\n                    know!\"",
		"The Mouseonly growled in reply.",
		"\"Please come back and finish your story!\" Alice called after it; and\n                    the others all joined in chorus, \"Yes, please do!\" but the\n                    Mouseonly shook its head impatiently, and walked a little\n                    quicker.",
		"\"What a pity it wouldn't stay!\" sighed the Lory, as soon as it was quite out of\n                    sight; ",
		"39",
		" and an old Crab took the opportunity\n                    of saying to her daughter \"Ah, my dear! Let this be a lesson to you never to\n                    lose your temper!\" \"Hold your tongue, Ma!\" said the young Crab, a\n                    little snappishly. \"You're enough to try the patience of an oyster!\"",
		"\"I wish I had our Dinah here, I know I do!\" said Alice\n                    aloud, addressing nobody in particular. \"She'd soon fetch it back!\"",
		"\"And who is Dinah, if I might venture to ask the question?\" said the\n                    Lory.",
		"Alice replied eagerly, for she was always ready to talk about her\n                    pet: \"Dinah's our cat. And she's such a capital one for catching\n                    mice you can't think! And oh, I wish you could see her after the birds! Why,\n                    she'll eat a little bird as soon as look at it!\"",
		"This speech caused a remarkable sensation among the party. Some of the birds\n                    hurried off at once: one old Magpie began wrapping itself up very carefully,\n                    remarking, \"I really must be getting home; the night-air doesn't ",
		"40",
		" suit my throat!\" and a Canary called out in a\n                    trembling voice to its children, \"Come away, my dears! It's high time you were\n                    all in bed!\" On various pretexts they all moved off, and Alice was\n                    soon left alone.",
		"\"I wish I hadn't mentioned Dinah!\" she said to herself in a\n                    melancholy tone. \"Nobody seems to like her, down here, and I'm sure she's the\n                    best cat in the world! Oh, my dear Dinah! I wonder if I shall ever\n                    see you any more!\" And here poor Alice began to cry again, for she\n                    felt very lonely and low-spirited. In a little while, however, she again heard a\n                    little pattering of footsteps in the distance, and she looked up eagerly, half\n                    hoping that the Mousehad changed his mind, and was coming back to\n                    finish his story."
    };

    const char* table = "tables/unicode.dis,tables/en-us-g2.ctb";

    unsigned int i;
    int j;
    for (i=0; i < sizeof(strings)/sizeof(strings[0]); i++) {
        int inlen = strlen(strings[i]);
        int outlen = inlen * 3;
        widechar* inbuf = malloc(inlen * sizeof(widechar));
        widechar* outbuf = malloc(outlen * sizeof(widechar));
        formtype* typeform = malloc(outlen * sizeof(formtype));
        for (j=0; j<=inlen; j++)
            typeform[j] = 0;
        inlen = _lou_extParseChars(strings[i], inbuf);
        if (!lou_translate(table, inbuf, &inlen, outbuf, &outlen, typeform, NULL, NULL, NULL, NULL, 0))
            return 1;
        free(inbuf);
        free(outbuf);
        free(typeform);
    }

    lou_free();

    return 0;
}
