/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.value.UntypedAtomicValue;

final class AttributeEnumeration
extends AxisIteratorImpl {
    private TinyDocumentImpl doc;
    private int element;
    private NodeTest nodeTest;
    private int index;

    protected AttributeEnumeration(TinyDocumentImpl tinyDocumentImpl, int n, NodeTest nodeTest) {
        this.nodeTest = nodeTest;
        this.doc = tinyDocumentImpl;
        this.element = n;
        this.index = tinyDocumentImpl.alpha[n];
    }

    public Item next() {
        while (true) {
            if (this.index >= this.doc.numberOfAttributes || this.doc.attParent[this.index] != this.element) {
                this.index = Integer.MAX_VALUE;
                return null;
            }
            int n = this.doc.getAttributeAnnotation(this.index);
            if (this.nodeTest.matches(2, this.doc.attCode[this.index], n)) {
                ++this.position;
                int n2 = this.index++;
                if (this.nodeTest instanceof NameTest) {
                    this.index = Integer.MAX_VALUE;
                }
                if (this.isAtomizing() && n == -1) {
                    this.current = new UntypedAtomicValue(this.doc.attValue[n2]);
                    return this.current;
                }
                this.current = this.doc.getAttributeNode(n2);
                return this.current;
            }
            ++this.index;
        }
    }

    public SequenceIterator getAnother() {
        return new AttributeEnumeration(this.doc, this.element, this.nodeTest);
    }
}

