/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import javax.xml.transform.TransformerException;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.AtomicValue;

public class ComplexContentOutputter
extends Outputter {
    private NamePool namePool;
    private Receiver receiver;
    private int pendingStartTag = -1;
    private int[] pendingAttCode = new int[20];
    private int[] pendingAttType = new int[20];
    private CharSequence[] pendingAttValue = new String[20];
    private int[] pendingAttProp = new int[20];
    private int pendingAttListSize = 0;
    private int[] pendingNSList = new int[20];
    private int pendingNSListSize = 0;
    private int currentSimpleType = 0;
    private boolean suppressAttributes = false;
    private int startElementProperties;

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setSystemId(String string) {
    }

    public String getSystemId() {
        return null;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public void startDocument() throws TransformerException {
        this.receiver.startDocument();
        this.previousAtomic = false;
    }

    public void characters(CharSequence charSequence, int n) throws TransformerException {
        if (charSequence == null) {
            return;
        }
        int n2 = charSequence.length();
        if (n2 == 0) {
            return;
        }
        if (this.pendingStartTag != -1) {
            this.startContent();
        }
        this.receiver.characters(charSequence, n);
        this.previousAtomic = false;
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        if (n == -1) {
            this.suppressAttributes = true;
            return;
        }
        this.suppressAttributes = false;
        this.startElementProperties = n3;
        if (this.pendingStartTag != -1) {
            this.startContent();
        }
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTag = n;
        this.currentSimpleType = n2;
        this.previousAtomic = false;
    }

    public void namespace(int n, int n2) throws TransformerException {
        if (this.suppressAttributes) {
            return;
        }
        if (this.pendingStartTag == -1) {
            throw new NoOpenStartTagException("Cannot write a namespace declaration when there is no open start tag");
        }
        boolean bl = (n2 & 0x20) != 0;
        int n3 = 0;
        while (n3 < this.pendingNSListSize) {
            if (n == this.pendingNSList[n3]) {
                return;
            }
            if (n >> 16 == this.pendingNSList[n3] >> 16) {
                if (bl) {
                    throw new TransformerException("Cannot create two namespace nodes with the same name");
                }
                return;
            }
            ++n3;
        }
        if (n >> 16 == 0 && (n & 0xFFFF) != 0 && (this.namePool.allocateNamespaceCode(this.pendingStartTag) & 0xFFFF) == 0) {
            throw new TransformerException("Cannot output a namespace node for the default namespace when the element is in no namespace");
        }
        if (this.pendingNSListSize + 1 > this.pendingNSList.length) {
            int[] nArray = new int[this.pendingNSListSize * 2];
            System.arraycopy(this.pendingNSList, 0, nArray, 0, this.pendingNSListSize);
            this.pendingNSList = nArray;
        }
        this.pendingNSList[this.pendingNSListSize++] = n;
        this.previousAtomic = false;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3) throws TransformerException {
        if (this.suppressAttributes) {
            return;
        }
        if (this.pendingStartTag == -1) {
            throw new NoOpenStartTagException("Cannot write an attribute when there is no open start tag");
        }
        int n4 = 0;
        while (n4 < this.pendingAttListSize) {
            if (this.pendingAttCode[n4] == n) {
                if ((n3 & 0x20) == 0) {
                    this.pendingAttType[n4] = n2;
                    this.pendingAttValue[n4] = charSequence;
                    this.pendingAttProp[n4] = n3;
                    return;
                }
                throw new TransformerException("Duplicate attribute: " + this.namePool.getDisplayName(n));
            }
            ++n4;
        }
        if (this.pendingAttListSize >= this.pendingAttCode.length) {
            int[] nArray = new int[this.pendingAttListSize * 2];
            int[] nArray2 = new int[this.pendingAttListSize * 2];
            String[] stringArray = new String[this.pendingAttListSize * 2];
            int[] nArray3 = new int[this.pendingAttListSize * 2];
            System.arraycopy(this.pendingAttCode, 0, nArray, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttType, 0, nArray2, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttValue, 0, stringArray, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttProp, 0, nArray3, 0, this.pendingAttListSize);
            this.pendingAttCode = nArray;
            this.pendingAttType = nArray2;
            this.pendingAttValue = stringArray;
            this.pendingAttProp = nArray3;
        }
        this.pendingAttCode[this.pendingAttListSize] = n;
        this.pendingAttType[this.pendingAttListSize] = n2;
        this.pendingAttValue[this.pendingAttListSize] = charSequence;
        this.pendingAttProp[this.pendingAttListSize] = n3;
        ++this.pendingAttListSize;
        this.previousAtomic = false;
    }

    private int checkProposedPrefix(int n, int n2) throws TransformerException {
        int n3 = this.namePool.allocateNamespaceCode(n);
        int n4 = n3 >> 16;
        int n5 = 0;
        while (n5 < this.pendingNSListSize) {
            if (n4 == this.pendingNSList[n5] >> 16) {
                if ((n3 & 0xFFFF) == (this.pendingNSList[n5] & 0xFFFF)) {
                    return n;
                }
                String string = this.getSubstitutePrefix(n3, n2);
                int n6 = this.namePool.allocate(string, this.namePool.getURI(n), this.namePool.getLocalName(n));
                this.namespace(this.namePool.allocateNamespaceCode(n6), 0);
                return n6;
            }
            ++n5;
        }
        this.namespace(n3, 0);
        return n;
    }

    private String getSubstitutePrefix(int n, int n2) {
        String string = this.namePool.getPrefixFromNamespaceCode(n);
        return string + "_" + n2;
    }

    public void endElement() throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.startContent();
        }
        this.receiver.endElement();
        this.previousAtomic = false;
    }

    public void comment(CharSequence charSequence, int n) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.startContent();
        }
        this.receiver.comment(charSequence, n);
        this.previousAtomic = false;
    }

    public void processingInstruction(String string, CharSequence charSequence, int n) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.startContent();
        }
        this.receiver.processingInstruction(string, charSequence, n);
        this.previousAtomic = false;
    }

    public void append(Item item) throws TransformerException {
        if (item instanceof AtomicValue) {
            if (this.previousAtomic) {
                this.characters(" ", 0);
            }
            this.characters(item.getStringValue(), 0);
            this.previousAtomic = true;
        } else if (item instanceof DocumentInfo) {
            Item item2;
            AxisIterator axisIterator = ((DocumentInfo)item).iterateAxis((byte)3);
            while ((item2 = axisIterator.next()) != null) {
                this.append(item2);
            }
        } else {
            ((NodeInfo)item).copy(this, 2, true);
            this.previousAtomic = false;
        }
    }

    public void endDocument() throws TransformerException {
        this.receiver.endDocument();
        this.previousAtomic = false;
    }

    public void startContent() throws TransformerException {
        int n;
        if (this.pendingStartTag == -1) {
            return;
        }
        int n2 = this.checkProposedPrefix(this.pendingStartTag, 0);
        this.receiver.startElement(n2, this.currentSimpleType, this.startElementProperties);
        int n3 = 0;
        while (n3 < this.pendingAttListSize) {
            n = this.pendingAttCode[n3];
            if ((n >> 20 & 0xFF) != 0) {
                n = this.checkProposedPrefix(n, n3 + 1);
            }
            this.receiver.attribute(n, this.pendingAttType[n3], this.pendingAttValue[n3], this.pendingAttProp[n3]);
            ++n3;
        }
        n = 0;
        while (n < this.pendingNSListSize) {
            this.receiver.namespace(this.pendingNSList[n], 0);
            ++n;
        }
        this.receiver.startContent();
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTag = -1;
        this.previousAtomic = false;
    }
}

