// SPDX-License-Identifier: GPL-2.0 OR BSD-3-Clause
/* Copyright(c) 2019-2022  Realtek Corporation
 */

#include "phy.h"
#include "reg.h"
#include "rtw8852c_table.h"

static const struct rtw89_reg2_def rtw89_8852c_phy_bb_regs[] = {
	{0xF0FF0000, 0x00000000},
	{0xF03300FF, 0x00000001},
	{0xF03400FF, 0x00000002},
	{0x70C, 0x00000020},
	{0x704, 0x601E0100},
	{0x4000, 0x00000000},
	{0x4004, 0xCA014000},
	{0x4008, 0xC751D4F0},
	{0x400C, 0x44511475},
	{0x4010, 0x00000000},
	{0x4014, 0x00000000},
	{0x44AC, 0x01F60380},
	{0x4018, 0x4F4C4B4B},
	{0x401C, 0x494A4E52},
	{0x4020, 0x4D504E4B},
	{0x4024, 0x4F4C4949},
	{0x4028, 0x49484C50},
	{0x402C, 0x4C50504C},
	{0x4030, 0x54544D4A},
	{0x4034, 0x504B5654},
	{0x4038, 0x6A6C605A},
	{0x403C, 0x48484848},
	{0x4040, 0x48483D47},
	{0x4044, 0x3D474848},
	{0x4048, 0x51484848},
	{0x404C, 0x4A4A404F},
	{0x4050, 0x514F4C4A},
	{0x4054, 0x524E4A4A},
	{0x4058, 0x4A4A5154},
	{0x405C, 0x53555554},
	{0x4060, 0x45454545},
	{0x4064, 0x45454144},
	{0x4068, 0x40434445},
	{0x406C, 0x44454545},
	{0x4070, 0x44444043},
	{0x4074, 0x42434444},
	{0x4078, 0x46454444},
	{0x407C, 0x44444843},
	{0x4080, 0x4B4E4A47},
	{0x4084, 0x514D4A49},
	{0x4088, 0x4A495454},
	{0x408C, 0x5454514D},
	{0x4090, 0x524E4B4A},
	{0x4094, 0x4C4B5455},
	{0x4098, 0x55565550},
	{0x409C, 0x5959504D},
	{0x40A0, 0x544E5D5A},
	{0x40A4, 0x7975665F},
	{0x40A8, 0x48484848},
	{0x40AC, 0x48483D47},
	{0x40B0, 0x3D474848},
	{0x40B4, 0x48484848},
	{0x40B8, 0x48483E48},
	{0x40BC, 0x3E4A4A49},
	{0x40C0, 0x514E4948},
	{0x40C4, 0x4A49404F},
	{0x40C8, 0x42525555},
	{0x40CC, 0x47474747},
	{0x40D0, 0x47474747},
	{0x40D4, 0x47474747},
	{0x40D8, 0x48484848},
	{0x40DC, 0x48474848},
	{0x40E0, 0x4A484848},
	{0x40E4, 0x49484847},
	{0x40E8, 0x4847524D},
	{0x40EC, 0x55544F4B},
	{0x40F0, 0x00000000},
	{0x4604, 0x4C4C4D4E},
	{0x4608, 0x3D3D6A56},
	{0x460C, 0x53515140},
	{0x4610, 0x42404041},
	{0x4614, 0x54544B48},
	{0x4618, 0x795D5554},
	{0x461C, 0x3E3E3D3D},
	{0x4620, 0x47474240},
	{0x4624, 0x55524A48},
	{0x4ED4, 0x00000000},
	{0x40F4, 0x00000006},
	{0x4628, 0x00000000},
	{0x4E9C, 0x26663333},
	{0x4EA0, 0x6EDA4148},
	{0x4EA4, 0x599A0000},
	{0x4EA8, 0x40000000},
	{0x4ED0, 0x00000001},
	{0x40F8, 0x00000000},
	{0x40FC, 0x8C30C30C},
	{0x4100, 0x4C30C30C},
	{0x4104, 0x0C30C30C},
	{0x4108, 0x0C30C30C},
	{0x410C, 0x0C30C30C},
	{0x4110, 0x0C30C30C},
	{0x4114, 0x28A28A28},
	{0x4118, 0x28A28A28},
	{0x411C, 0x28A28A28},
	{0x4120, 0x28A28A28},
	{0x4124, 0x28A28A28},
	{0x4128, 0x28A28A28},
	{0x412C, 0x06666666},
	{0x4130, 0x33333333},
	{0x4134, 0x33333333},
	{0x4138, 0x33333333},
	{0x413C, 0x00000031},
	{0x462C, 0x0C30C30C},
	{0x4630, 0x0C30C30C},
	{0x4634, 0x28A28A28},
	{0x4638, 0x28A28A28},
	{0x463C, 0x33333333},
	{0x4640, 0x00000033},
	{0x4140, 0x5100600A},
	{0x4144, 0x18363113},
	{0x4148, 0x1D976DDC},
	{0x414C, 0x1C072DD7},
	{0x4150, 0x1127CDF4},
	{0x4154, 0x1E37BDF1},
	{0x4158, 0x1FB7F1D6},
	{0x415C, 0x1EA7DDF9},
	{0x4160, 0x1FE445DD},
	{0x4164, 0x1F97F1FE},
	{0x4168, 0x1FF781ED},
	{0x416C, 0x1FA7F5FE},
	{0x4170, 0x1E07B913},
	{0x4174, 0x1FD7FDFF},
	{0x4178, 0x1E17B9FA},
	{0x417C, 0x19A66914},
	{0x4180, 0x10F65598},
	{0x4184, 0x14A5A111},
	{0x4188, 0x1D3765DB},
	{0x418C, 0x17C685CA},
	{0x4190, 0x1107C5F3},
	{0x4194, 0x1B5785EB},
	{0x4198, 0x1F97ED8F},
	{0x419C, 0x1BC7A5F3},
	{0x41A0, 0x1FE43595},
	{0x41A4, 0x1EB7D9FC},
	{0x41A8, 0x1FE65DBE},
	{0x41AC, 0x1EC7D9FC},
	{0x41B0, 0x1976FCFF},
	{0x41B4, 0x1F77F5FF},
	{0x41B8, 0x1976FDEC},
	{0x41BC, 0x198664EF},
	{0x41C0, 0x11062D93},
	{0x41C4, 0x10C4E910},
	{0x41C8, 0x1CA759DB},
	{0x41CC, 0x1335A9B5},
	{0x41D0, 0x1097B9F3},
	{0x41D4, 0x17B72DE1},
	{0x41D8, 0x1F67ED42},
	{0x41DC, 0x18074DE9},
	{0x41E0, 0x1FD40547},
	{0x41E4, 0x1D57ADF9},
	{0x41E8, 0x1FE52182},
	{0x41EC, 0x1D67B1F9},
	{0x41F0, 0x14860CE1},
	{0x41F4, 0x1EC7E9FE},
	{0x41F8, 0x14860DD6},
	{0x41FC, 0x195664C7},
	{0x4200, 0x0005E58A},
	{0x4204, 0x00000000},
	{0x4208, 0x00000000},
	{0x420C, 0x7A000000},
	{0x4210, 0x0F9F3D7A},
	{0x4214, 0x0040817C},
	{0x4218, 0x00E10204},
	{0x421C, 0x257D94CD},
	{0x4220, 0x0802DB6D},
	{0x4224, 0x00000200},
	{0x4228, 0x04688000},
	{0x4644, 0x00000000},
	{0x4648, 0x00000000},
	{0x464C, 0x00000000},
	{0x4650, 0x00000020},
	{0x4ECC, 0x00000001},
	{0x422C, 0x0060B002},
	{0x4230, 0x9A8249A8},
	{0x4234, 0x26A1469E},
	{0x4238, 0x2099A824},
	{0x423C, 0x2359461C},
	{0x4240, 0x1631A675},
	{0x4244, 0x2C6B1D63},
	{0x4248, 0x0000000E},
	{0x424C, 0x00000001},
	{0x4250, 0x00000001},
	{0x4254, 0x00000000},
	{0x4258, 0x00000000},
	{0x425C, 0x00000000},
	{0x4260, 0x01E0000C},
	{0x4654, 0x00000000},
	{0x4658, 0x00000000},
	{0x465C, 0x0000001E},
	{0x4E74, 0x00000000},
	{0x4264, 0x00000000},
	{0x4268, 0x00000000},
	{0x426C, 0x0418317C},
	{0x46C0, 0x00000001},
	{0x4270, 0x00D6135C},
	{0x46C4, 0x00000033},
	{0x4274, 0x00000000},
	{0x4278, 0x00000000},
	{0x427C, 0x00000000},
	{0x4280, 0x00000000},
	{0x4284, 0x00000000},
	{0x4288, 0x00000000},
	{0x46D8, 0x00000000},
	{0x46DC, 0x00000000},
	{0x46E0, 0x00000000},
	{0x46E4, 0x00000000},
	{0x46E8, 0x00000000},
	{0x428C, 0x00000000},
	{0x4290, 0x00000000},
	{0x4294, 0x00000000},
	{0x4298, 0x84026000},
	{0x429C, 0x0051AC20},
	{0x46EC, 0x1020C040},
	{0x46F0, 0xB8BEBEB8},
	{0x46F4, 0x021102BE},
	{0x46F8, 0x14221142},
	{0x46FC, 0x18C4098C},
	{0x4700, 0x00021084},
	{0x42A0, 0x02024008},
	{0x42A4, 0x00000000},
	{0x42A8, 0x00000000},
	{0x42AC, 0x22CE803C},
	{0x42B0, 0x32000000},
	{0x42B4, 0x996FD67D},
	{0x42B8, 0xBD67D67D},
	{0x42BC, 0x7D67D65B},
	{0x42C0, 0x28029F59},
	{0x42C4, 0x00280280},
	{0x4704, 0x00000000},
	{0x42C8, 0x00000000},
	{0x42CC, 0x00000000},
	{0x42D0, 0x00000003},
	{0x4708, 0x00280000},
	{0x42D4, 0x00000001},
	{0x42D8, 0x61861800},
	{0x42DC, 0x830C30C3},
	{0x42E0, 0xC30C30C3},
	{0x42E4, 0x830C30C3},
	{0x42E8, 0x451450C3},
	{0x42EC, 0x05145145},
	{0x42F0, 0x05145145},
	{0x42F4, 0x05145145},
	{0x42F8, 0x03207145},
	{0x42FC, 0x041C32C6},
	{0x4300, 0x031C5247},
	{0x4304, 0x030C5143},
	{0x4308, 0x030C30C3},
	{0x430C, 0x0F3CF3C3},
	{0x4310, 0x0F3CF3CF},
	{0x4314, 0x0F3CF3CF},
	{0x4318, 0x0F3CF3CF},
	{0x431C, 0x0F3CF3CF},
	{0x4320, 0x030C10C3},
	{0x4324, 0x051430C3},
	{0x4328, 0x051490CB},
	{0x432C, 0x030C70D1},
	{0x4330, 0x050C50C7},
	{0x4334, 0x051492CB},
	{0x4338, 0x05145145},
	{0x433C, 0x05145145},
	{0x4340, 0x05145145},
	{0x4344, 0x05145145},
	{0x4348, 0x090CD243},
	{0x434C, 0x0918A1C5},
	{0x4350, 0x071C3143},
	{0x4354, 0x071431C3},
	{0x4358, 0x0F3CF1C5},
	{0x435C, 0x0F3CF3CF},
	{0x4360, 0x0F3CF3CF},
	{0x4364, 0x0F3CF3CF},
	{0x4368, 0x0F3CF3CF},
	{0x436C, 0x090C91CF},
	{0x4370, 0x11243143},
	{0x4374, 0x9777A777},
	{0x4378, 0xBB7BAC95},
	{0x437C, 0xB667B889},
	{0x4380, 0x7B9B8899},
	{0x4384, 0x7A5567C8},
	{0x4388, 0x2278CCCC},
	{0x438C, 0x7C222222},
	{0x4390, 0x0000049B},
	{0x470C, 0x00000888},
	{0x4EB4, 0x00000002},
	{0x4394, 0x001CCCCC},
	{0x4710, 0xCCCCCAAC},
	{0x4714, 0x0000AACC},
	{0x4398, 0x00000000},
	{0x439C, 0x00000008},
	{0x49A4, 0x00000000},
	{0x43A0, 0x00000000},
	{0x43A4, 0x00000000},
	{0x43A8, 0x00000000},
	{0x43AC, 0x10000000},
	{0x43B0, 0x00401001},
	{0x43B4, 0x00061003},
	{0x4718, 0x00003000},
	{0x43B8, 0x000024D8},
	{0x43BC, 0x00000000},
	{0x43C0, 0x10000020},
	{0x43C4, 0x20000200},
	{0x43C8, 0x00000000},
	{0x43CC, 0x04000000},
	{0x43D0, 0x44000100},
	{0x43D4, 0x60804060},
	{0x43D8, 0x44204210},
	{0x43DC, 0x82108082},
	{0x43E0, 0x82108402},
	{0x43E4, 0xC8082108},
	{0x43E8, 0xC8202084},
	{0x43EC, 0x44208208},
	{0x43F0, 0x84108204},
	{0x43F4, 0xD0108104},
	{0x43F8, 0xF8210108},
	{0x43FC, 0x6431E930},
	{0x4400, 0x02109468},
	{0x4404, 0x10C61C22},
	{0x4408, 0x02109469},
	{0x440C, 0x10C61C22},
	{0x4410, 0x00041049},
	{0x471C, 0x0B02C080},
	{0x4414, 0x00000000},
	{0x4418, 0x00000000},
	{0x441C, 0x80000000},
	{0x4420, 0xB0200000},
	{0x4424, 0x00001FF0},
	{0x4780, 0xEC000000},
	{0x4784, 0x8C400020},
	{0x4964, 0x51089104},
	{0x4968, 0x88448844},
	{0x496C, 0x07000044},
	{0x4E4C, 0x00000000},
	{0x4428, 0x00000000},
	{0x442C, 0x00000000},
	{0x4430, 0x00000000},
	{0x4434, 0x00000000},
	{0x4438, 0x590642D0},
	{0x443C, 0x398668A0},
	{0x4440, 0x6C100808},
	{0x4444, 0x4A145344},
	{0x4448, 0x0C5B008F},
	{0x444C, 0x6E30498A},
	{0x4450, 0x656E371B},
	{0x4454, 0x00000F53},
	{0x49A8, 0x68120000},
	{0x49AC, 0xDA0681E0},
	{0x49BC, 0x14060180},
	{0x49D8, 0x600603FF},
	{0x49DC, 0x3C502000},
	{0x49E0, 0x2C580050},
	{0x49E4, 0x45B055EF},
	{0x49E8, 0x00000290},
	{0x4A0C, 0x00000001},
	{0x4A28, 0x0DAC1B58},
	{0x4A2C, 0x0000001E},
	{0x4E50, 0x16878003},
	{0x4E54, 0x0F00F078},
	{0x4E58, 0x03C1E0B4},
	{0x4E5C, 0x78584830},
	{0x4E60, 0x88C0140C},
	{0x4E64, 0x90302C24},
	{0x4E68, 0x0F84A00A},
	{0x4E6C, 0x00000011},
	{0x4E78, 0x00003039},
	{0x4E7C, 0x0000D431},
	{0x4E80, 0x00008235},
	{0x4E84, 0x00000000},
	{0x4E88, 0x000056CE},
	{0x4E8C, 0x00002B67},
	{0x4E90, 0x00000237},
	{0x4EB8, 0x00004624},
	{0x4A30, 0x00000000},
	{0x4458, 0x00000000},
	{0x445C, 0x4801442E},
	{0x4460, 0x0051A0B8},
	{0x4A34, 0x0000011F},
	{0x4EBC, 0x00000000},
	{0x4A38, 0x0000011F},
	{0x4EC0, 0x00000000},
	{0x4464, 0x00000000},
	{0x4468, 0x00000000},
	{0x446C, 0x00000000},
	{0x4470, 0x00000000},
	{0x4474, 0x00000000},
	{0x4478, 0x00000000},
	{0x447C, 0x00000000},
	{0x4480, 0x2A0AA040},
	{0x4484, 0x0A886926},
	{0x4488, 0x00000004},
	{0x4A3C, 0x00002B1C},
	{0x448C, 0x00000000},
	{0x4490, 0x88000000},
	{0x4494, 0x10000000},
	{0x4498, 0xE0000000},
	{0x4A08, 0x00000FE6},
	{0x4A40, 0x00000000},
	{0x4A44, 0x00000000},
	{0x4A48, 0x00000000},
	{0x4A4C, 0x00000000},
	{0x4A50, 0x00000000},
	{0x4A54, 0x00000000},
	{0x449C, 0x00000019},
	{0x44A0, 0x02B2E394},
	{0x44A4, 0x00000400},
	{0x4A58, 0x14285208},
	{0x4A84, 0x02850A14},
	{0x4A88, 0x048D0A14},
	{0x4A8C, 0x01123401},
	{0x4A90, 0x34011234},
	{0x4A94, 0x23450112},
	{0x4A98, 0x45123451},
	{0x4AAC, 0x12345123},
	{0x4AB0, 0x00000000},
	{0x44A8, 0x00000001},
	{0x44B0, 0x00000000},
	{0x44B4, 0x00000000},
	{0x44B8, 0x00000000},
	{0x44BC, 0x00000000},
	{0x44C0, 0x00000000},
	{0x44C4, 0x00000000},
	{0x44C8, 0x00000000},
	{0x44CC, 0x00000000},
	{0x44D0, 0x00000000},
	{0x44D4, 0x00000000},
	{0x44D8, 0x00000000},
	{0x44DC, 0x00000000},
	{0x44E0, 0x00000000},
	{0x44E4, 0x00000000},
	{0x44E8, 0x00000000},
	{0x44EC, 0x00000000},
	{0x44F0, 0x00000000},
	{0x44F4, 0x00000000},
	{0x44F8, 0x00000000},
	{0x44FC, 0x00000000},
	{0x4500, 0x00000000},
	{0x4504, 0x00000000},
	{0x4508, 0x00000000},
	{0x450C, 0x00000000},
	{0x4510, 0x00000000},
	{0x4514, 0x00000000},
	{0x4518, 0x00000000},
	{0x451C, 0x00000000},
	{0x4520, 0x00000000},
	{0x4524, 0x00000000},
	{0x4528, 0x00000000},
	{0x452C, 0x00000000},
	{0x4530, 0x4ED80C81},
	{0x4534, 0x00001808},
	{0x4538, 0x000000FF},
	{0x453C, 0x00000000},
	{0x4540, 0x00000000},
	{0x4544, 0x00000000},
	{0x4548, 0x00000000},
	{0x454C, 0x00000000},
	{0x4550, 0x00000000},
	{0x4554, 0x00000000},
	{0x4558, 0x00000000},
	{0x455C, 0x00000000},
	{0x4560, 0x40600033},
	{0x4564, 0x40000000},
	{0x4568, 0x00000000},
	{0x456C, 0x20000000},
	{0x4570, 0x04AAA407},
	{0x4574, 0x0001A2B4},
	{0x4578, 0x0002024B},
	{0x457C, 0x00200000},
	{0x4580, 0x00001B40},
	{0x4584, 0x00000000},
	{0x4588, 0x000000C8},
	{0x458C, 0x30000000},
	{0x4590, 0x00000000},
	{0x4594, 0x00000000},
	{0x4598, 0x00000001},
	{0x459C, 0x0003FE00},
	{0x45A0, 0x00000000},
	{0x45A4, 0x00000000},
	{0x45A8, 0xC00002C0},
	{0x45AC, 0x78028000},
	{0x45B0, 0x80000048},
	{0x45B4, 0x00098800},
	{0x45B8, 0x00200002},
	{0x4AB4, 0x00000000},
	{0x4AB8, 0x00000000},
	{0x4ABC, 0x00000000},
	{0x4AC0, 0x00000000},
	{0x4AC4, 0x00000000},
	{0x4AC8, 0x00000000},
	{0x4AF4, 0x00000000},
	{0x4AF8, 0x00000000},
	{0x4AFC, 0x00000000},
	{0x4B00, 0x00000000},
	{0x4B04, 0x00000000},
	{0x4B08, 0x00000000},
	{0x4B0C, 0x00000000},
	{0x4B10, 0x00000000},
	{0x4B14, 0x00000000},
	{0x4B18, 0xB0000000},
	{0x4B1C, 0x00000000},
	{0x4B20, 0x00000000},
	{0x4B24, 0x00000000},
	{0x4B28, 0x00000000},
	{0x4B2C, 0x00000000},
	{0x4B30, 0x00000000},
	{0x4B34, 0x00000000},
	{0x4B38, 0x00000000},
	{0x4B3C, 0x00000000},
	{0x4B40, 0x00000000},
	{0x45BC, 0x06748790},
	{0x45C0, 0x80000000},
	{0x45C4, 0x00000000},
	{0x45C8, 0x00000000},
	{0x45CC, 0x00558670},
	{0x45D0, 0x002883F0},
	{0x45D4, 0x00090120},
	{0x45D8, 0x00000000},
	{0x4B44, 0x00000100},
	{0x4B48, 0xA6DBC4B1},
	{0x4B4C, 0x64F624C3},
	{0x4B50, 0x00D4EF15},
	{0x49B0, 0x11110F0A},
	{0x49B4, 0x00000003},
	{0x49B8, 0x0000000A},
	{0x4B54, 0xBE9007FF},
	{0x4B58, 0x00000001},
	{0x49C0, 0x00000007},
	{0x49C4, 0x000003D9},
	{0x4A10, 0x00000001},
	{0x49C8, 0x002B1CB0},
	{0x4A00, 0xC0000000},
	{0x4A04, 0x00001000},
	{0x4B5C, 0x00000005},
	{0x4A18, 0x00000007},
	{0x4B60, 0x00000024},
	{0x49CC, 0x00000001},
	{0x49D0, 0x00000010},
	{0x49D4, 0x00000001},
	{0x4B64, 0x927FBFBF},
	{0x4B68, 0x1D07BDD0},
	{0x4B6C, 0x318A4DEF},
	{0x4B70, 0x158C5318},
	{0x4B74, 0x18C5318C},
	{0x4B78, 0x4E7394EC},
	{0x4B7C, 0xD9081CE5},
	{0x4B80, 0x00000001},
	{0x49EC, 0x00000001},
	{0x4B84, 0x00000000},
	{0x4B88, 0x00000000},
	{0x4B8C, 0x00000000},
	{0x4B90, 0x00000000},
	{0x4B94, 0x00000000},
	{0x4B98, 0x00000000},
	{0x4B9C, 0x00000000},
	{0x4BA0, 0x00000000},
	{0x4BA4, 0x00EA99A2},
	{0x49F8, 0x0000C4C3},
	{0x4A1C, 0x00020800},
	{0x4A20, 0x0002CC00},
	{0x4BA8, 0x002B6456},
	{0x45E0, 0x00000000},
	{0x45E4, 0x00000000},
	{0x45E8, 0x00E2E1E1},
	{0x45EC, 0xCBCBB6B6},
	{0x45F0, 0x59100FCA},
	{0x4BAC, 0x12CAB6DE},
	{0x4BB0, 0x00001110},
	{0x45F4, 0x08882550},
	{0x45F8, 0x08CC2660},
	{0x45FC, 0x09102660},
	{0x4600, 0x00000154},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x45DC, 0xE1CB38E8},
	{0x4660, 0x4A2E1800},
	{0x4664, 0x6750E462},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x45DC, 0xD1B942F4},
	{0x4660, 0x41250EF4},
	{0x4664, 0x6750E458},
	{0x903400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x45DC, 0xE1CB38E8},
	{0x4660, 0x4A2E1800},
	{0x4664, 0x6750E462},
	{0xA0000000, 0x00000000},
	{0x45DC, 0xE1CB38E8},
	{0x4660, 0x4A2E1800},
	{0x4664, 0x6750E462},
	{0xB0000000, 0x00000000},
	{0x4668, 0x0E0CFB0A},
	{0x466C, 0x30100F06},
	{0x4670, 0x34333333},
	{0x4674, 0x34343434},
	{0x4678, 0xC39D38E8},
	{0x467C, 0x482800E3},
	{0x4680, 0x5836E46A},
	{0x4684, 0xFBEBDA00},
	{0x4688, 0x1A10FF04},
	{0x468C, 0x282A3000},
	{0x4690, 0x2A29292A},
	{0x4694, 0x04FA2A2A},
	{0x4698, 0xEE0F04D1},
	{0x469C, 0x89291436},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x46A0, 0x0701E79E},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x46A0, 0x0701E79E},
	{0x903400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x46A0, 0x0701E79E},
	{0xA0000000, 0x00000000},
	{0x46A0, 0x0701E79E},
	{0xB0000000, 0x00000000},
	{0x46A4, 0x08D07CFF},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x46A8, 0x2212FF14},
	{0x46AC, 0x60423537},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x46A8, 0x4D1E7F14},
	{0x46AC, 0x60B37C4E},
	{0x903400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x46A8, 0x2212FF14},
	{0x46AC, 0x60423537},
	{0xA0000000, 0x00000000},
	{0x46A8, 0x2212FF14},
	{0x46AC, 0x60423537},
	{0xB0000000, 0x00000000},
	{0x46B0, 0x63666666},
	{0x46B4, 0x35374425},
	{0x46B8, 0x25883043},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x46BC, 0x5107C252},
	{0x4720, 0x3FFFFD63},
	{0x4724, 0xB58D11FF},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x46BC, 0x5107C252},
	{0x4720, 0x27795843},
	{0x4724, 0xB58D11F5},
	{0x903400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x46BC, 0x5107C252},
	{0x4720, 0x27795303},
	{0x4724, 0xB58D11F5},
	{0xA0000000, 0x00000000},
	{0x46BC, 0x5107C252},
	{0x4720, 0x3FFFFD63},
	{0x4724, 0xB58D11FF},
	{0xB0000000, 0x00000000},
	{0x4728, 0x07FFFFFF},
	{0x472C, 0x0E7893B6},
	{0x4730, 0xE0399201},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x4734, 0x00000020},
	{0x4738, 0x8325C500},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x4734, 0x003D4C20},
	{0x4738, 0x8F25C500},
	{0x903400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x4734, 0x003D5420},
	{0x4738, 0x8725C500},
	{0xA0000000, 0x00000000},
	{0x4734, 0x00000020},
	{0x4738, 0x8325C500},
	{0xB0000000, 0x00000000},
	{0x473C, 0x00000B7F},
	{0x4ACC, 0x000F7D00},
	{0x4AD0, 0x00000000},
	{0x4AD4, 0x00000040},
	{0x4AE4, 0x5379E99E},
	{0x4AE8, 0x00000744},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x4BB4, 0xFBD5B89F},
	{0x4BB8, 0x99563918},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x4BB4, 0x05EBC8AF},
	{0x4BB8, 0x99543D24},
	{0x903400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x4BB4, 0xFBD5B89F},
	{0x4BB8, 0x99563918},
	{0xA0000000, 0x00000000},
	{0x4BB4, 0xFBD5B89F},
	{0x4BB8, 0x99563918},
	{0xB0000000, 0x00000000},
	{0x4BBC, 0x12EED5B8},
	{0x4BC0, 0x80C4542F},
	{0x4BC4, 0x005A007F},
	{0x4BC8, 0x40000000},
	{0x4BCC, 0x40000000},
	{0x4BD0, 0x00000000},
	{0x4BD4, 0x40000000},
	{0x4BD8, 0xC0000000},
	{0x4BDC, 0x40000000},
	{0x4BE0, 0x80000000},
	{0x4BE4, 0xBAAC8000},
	{0x4BE8, 0x638A88C5},
	{0x4BEC, 0x00900000},
	{0x4EAC, 0x00000000},
	{0x4BF0, 0x00000000},
	{0x4BF4, 0x00000000},
	{0x4BF8, 0x00000219},
	{0x4EC4, 0x00000001},
	{0x4EE8, 0x00002020},
	{0x4BFC, 0x00000000},
	{0x4C00, 0x00000010},
	{0x4C04, 0x00000001},
	{0x4C08, 0x00000001},
	{0x4C0C, 0x00000000},
	{0x4C10, 0x00000000},
	{0x4C14, 0x00000151},
	{0x4C18, 0x00000000},
	{0x4C1C, 0x00000000},
	{0x4C20, 0x00000151},
	{0x4C24, 0x00000498},
	{0x4C28, 0x00000498},
	{0x4C2C, 0x00000498},
	{0x4C30, 0x00000498},
	{0x4C34, 0x00000498},
	{0x4C38, 0x00000498},
	{0x4C3C, 0x00000498},
	{0x4C40, 0x00000498},
	{0x4C44, 0x00000000},
	{0x4C48, 0x00000000},
	{0x4C4C, 0x00001146},
	{0x4C50, 0x00000000},
	{0x4C54, 0x00000000},
	{0x4C58, 0x00001146},
	{0x4C5C, 0x00000000},
	{0x4C60, 0x00000000},
	{0x4C64, 0xE2E1E1DE},
	{0x4C68, 0xB6B600B6},
	{0x4C6C, 0xCACBCBCA},
	{0x4C70, 0x8091010F},
	{0x4C74, 0x00000B11},
	{0x46C8, 0x08882550},
	{0x46CC, 0x08CC2660},
	{0x46D0, 0x09102660},
	{0x46D4, 0x00000154},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x4740, 0xE4CD38E8},
	{0x4744, 0x4C321B04},
	{0x4748, 0x6750E466},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x4740, 0xC5AD42F4},
	{0x4744, 0x412504E8},
	{0x4748, 0x6850E459},
	{0x903400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x4740, 0xE4CD38E8},
	{0x4744, 0x4C321B04},
	{0x4748, 0x6750E466},
	{0xA0000000, 0x00000000},
	{0x4740, 0xE4CD38E8},
	{0x4744, 0x4C321B04},
	{0x4748, 0x6750E466},
	{0xB0000000, 0x00000000},
	{0x474C, 0x0E0CFB0A},
	{0x4750, 0x30100F06},
	{0x4754, 0x34333333},
	{0x4758, 0x34343434},
	{0x475C, 0xC49E38E8},
	{0x4760, 0x482800E2},
	{0x4764, 0x5636E466},
	{0x4768, 0xFBEBDA00},
	{0x476C, 0x1A10FF04},
	{0x4770, 0x282A3000},
	{0x4774, 0x2A29292A},
	{0x4778, 0x04FA2A2A},
	{0x477C, 0xEE0F04D1},
	{0x49F0, 0x89291436},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x49F4, 0x0701E79E},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x49F4, 0x0701E79E},
	{0x903400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x49F4, 0x0701E79E},
	{0xA0000000, 0x00000000},
	{0x49F4, 0x0701E79E},
	{0xB0000000, 0x00000000},
	{0x49FC, 0x08D07CFF},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x4A5C, 0x2212FF14},
	{0x4A60, 0x60423537},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x4A5C, 0x4D1E7F14},
	{0x4A60, 0x60B37C4E},
	{0x903400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x4A5C, 0x2212FF14},
	{0x4A60, 0x60423537},
	{0xA0000000, 0x00000000},
	{0x4A5C, 0x2212FF14},
	{0x4A60, 0x60423537},
	{0xB0000000, 0x00000000},
	{0x4A64, 0x63666666},
	{0x4A68, 0x35374425},
	{0x4A6C, 0x25883043},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x4A70, 0x5107C252},
	{0x4A74, 0x3FFFFD63},
	{0x4A78, 0xB58D11FF},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x4A70, 0x5107C252},
	{0x4A74, 0x27795843},
	{0x4A78, 0xB58D11F5},
	{0x903400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x4A70, 0x5107C252},
	{0x4A74, 0x27795303},
	{0x4A78, 0xB58D11F5},
	{0xA0000000, 0x00000000},
	{0x4A70, 0x5107C252},
	{0x4A74, 0x3FFFFD63},
	{0x4A78, 0xB58D11FF},
	{0xB0000000, 0x00000000},
	{0x4A7C, 0x07FFFFFF},
	{0x4A80, 0x0E7893B6},
	{0x4A9C, 0xE0399201},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x4AA0, 0x00000020},
	{0x4AA4, 0x8325C500},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x4AA0, 0x003D4C20},
	{0x4AA4, 0x8F25C500},
	{0x903400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x4AA0, 0x003D5420},
	{0x4AA4, 0x8725C500},
	{0xA0000000, 0x00000000},
	{0x4AA0, 0x00000020},
	{0x4AA4, 0x8325C500},
	{0xB0000000, 0x00000000},
	{0x4AA8, 0x00000B7F},
	{0x4AD8, 0x000F7D00},
	{0x4ADC, 0x00000000},
	{0x4AE0, 0x00000040},
	{0x4AEC, 0x5379E99E},
	{0x4AF0, 0x00000744},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x4C78, 0xFBD5B89F},
	{0x4C7C, 0x99563918},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x4C78, 0x07ECC9B0},
	{0x4C7C, 0x995B4126},
	{0x903400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x4C78, 0xFBD5B89F},
	{0x4C7C, 0x99563918},
	{0xA0000000, 0x00000000},
	{0x4C78, 0xFBD5B89F},
	{0x4C7C, 0x99563918},
	{0xB0000000, 0x00000000},
	{0x4C80, 0x12EED5B8},
	{0x4C84, 0x80C4542F},
	{0x4C88, 0x005A007F},
	{0x4C8C, 0x40000000},
	{0x4C90, 0x40000000},
	{0x4C94, 0x00000000},
	{0x4C98, 0x40000000},
	{0x4C9C, 0xC0000000},
	{0x4CA0, 0x40000000},
	{0x4CA4, 0x80000000},
	{0x4CA8, 0xBAAC8000},
	{0x4CAC, 0x638A88C5},
	{0x4CB0, 0x00900000},
	{0x4EB0, 0x00000000},
	{0x4CB4, 0x00000000},
	{0x4CB8, 0x00000000},
	{0x4CBC, 0x00000219},
	{0x4EC8, 0x00000001},
	{0x4EEC, 0x00002020},
	{0x4CC0, 0x00000000},
	{0x4CC4, 0x00000010},
	{0x4CC8, 0x00000001},
	{0x4CCC, 0x00000001},
	{0x4CD0, 0x00000000},
	{0x4CD4, 0x00000000},
	{0x4CD8, 0x00000151},
	{0x4CDC, 0x00000000},
	{0x4CE0, 0x00000000},
	{0x4CE4, 0x00000151},
	{0x4CE8, 0x00000498},
	{0x4CEC, 0x00000498},
	{0x4CF0, 0x00000498},
	{0x4CF4, 0x00000498},
	{0x4CF8, 0x00000498},
	{0x4CFC, 0x00000498},
	{0x4D00, 0x00000498},
	{0x4D04, 0x00000498},
	{0x4D08, 0x00000000},
	{0x4D0C, 0x00000000},
	{0x4D10, 0x00001146},
	{0x4D14, 0x00000000},
	{0x4D18, 0x00000000},
	{0x4D1C, 0x00001146},
	{0x4788, 0x00000000},
	{0x478C, 0xA32103FE},
	{0x4790, 0xB20A7B28},
	{0x4794, 0xC6A7B14F},
	{0x4798, 0x000000D3},
	{0x4D20, 0x00000000},
	{0x4D24, 0x0C442416},
	{0x4D28, 0x00000000},
	{0x479C, 0x009B902A},
	{0x47A0, 0x009B902A},
	{0x47A4, 0x98682C18},
	{0x47A8, 0x6318C4C1},
	{0x47AC, 0x6248C631},
	{0x47B0, 0x922A8253},
	{0x47B4, 0x00000005},
	{0x4D2C, 0x0008C0C1},
	{0x47B8, 0x00001759},
	{0x47BC, 0x4B702400},
	{0x47C0, 0x831508BA},
	{0x4A14, 0x000000E9},
	{0x4D30, 0x00000001},
	{0x4E94, 0x000000FC},
	{0x47C4, 0x9ABBCACB},
	{0x47C8, 0x56767578},
	{0x47CC, 0xBBCCBBB3},
	{0x47D0, 0x57889989},
	{0x47D4, 0x00000F45},
	{0x4D34, 0x7BB167AB},
	{0x4D38, 0xBBBBBB05},
	{0x4D3C, 0x777777BB},
	{0x4D40, 0x00015277},
	{0x47D8, 0x27039CE9},
	{0x47DC, 0x41414432},
	{0x47E0, 0x36058342},
	{0x47E4, 0x00000006},
	{0x4D44, 0x00000687},
	{0x47E8, 0x00000001},
	{0x47EC, 0x00000001},
	{0x47F0, 0xC7013016},
	{0x47F4, 0x84413016},
	{0x47F8, 0x84413016},
	{0x47FC, 0x8C413016},
	{0x4800, 0x8C40B028},
	{0x4804, 0x3140B028},
	{0x4808, 0x2940B028},
	{0x480C, 0x8440B028},
	{0x4810, 0x6318C610},
	{0x4814, 0x45334753},
	{0x4818, 0x236A6A88},
	{0x4D48, 0x8C413016},
	{0x4D4C, 0xA140B028},
	{0x4D50, 0x00150A31},
	{0x481C, 0x576DF814},
	{0x4820, 0xA08877AC},
	{0x4824, 0x0000007A},
	{0x4D54, 0x00001184},
	{0x4828, 0xBCEB4A14},
	{0x482C, 0x000A3A4A},
	{0x4830, 0xBCEB4A14},
	{0x4834, 0x000A3A4A},
	{0x4D58, 0x2F63DD3A},
	{0x4838, 0xBCBDBD85},
	{0x483C, 0x0CABB99A},
	{0x4D5C, 0x000000BC},
	{0x4840, 0x38384242},
	{0x4844, 0x0086102E},
	{0x4848, 0xCA24C82A},
	{0x4D60, 0x00000000},
	{0x4D64, 0x0000F49D},
	{0x4ED8, 0x00000001},
	{0x4D68, 0x000001C4},
	{0x4D6C, 0x00000000},
	{0x4D70, 0x38384242},
	{0x4D74, 0x030E902E},
	{0x4D78, 0x994C1502},
	{0x4D7C, 0x00017912},
	{0x4EDC, 0x00000001},
	{0x484C, 0x00008A62},
	{0x4D80, 0x00000002},
	{0x4850, 0x00000008},
	{0x4854, 0x009B902A},
	{0x4858, 0x009B902A},
	{0x485C, 0x98682C18},
	{0x4860, 0x6318C4C1},
	{0x4864, 0x6248C631},
	{0x4868, 0x922A8253},
	{0x486C, 0x00000005},
	{0x4D84, 0x0008C0C1},
	{0x4870, 0x00001759},
	{0x4874, 0x4B702400},
	{0x4878, 0x831508BA},
	{0x4A24, 0x000000E9},
	{0x4D88, 0x00000001},
	{0x4E98, 0x000000FC},
	{0x487C, 0x9898A8BB},
	{0x4880, 0x54535368},
	{0x4884, 0x999999B3},
	{0x4888, 0x35555589},
	{0x488C, 0x00000745},
	{0x4D8C, 0x6AB14487},
	{0x4D90, 0xBBBBBB04},
	{0x4D94, 0x777777BB},
	{0x4D98, 0x00015277},
	{0x4890, 0x27039CE9},
	{0x4894, 0x41414432},
	{0x4898, 0x36058342},
	{0x489C, 0x00000006},
	{0x4D9C, 0x00000687},
	{0x48A0, 0x00000001},
	{0x48A4, 0x00000001},
	{0x48A8, 0xC7013016},
	{0x48AC, 0x84413016},
	{0x48B0, 0x84413016},
	{0x48B4, 0x8C413016},
	{0x48B8, 0x8C40B028},
	{0x48BC, 0x3140B028},
	{0x48C0, 0x2940B028},
	{0x48C4, 0x8440B028},
	{0x48C8, 0x6318C610},
	{0x48CC, 0x45334753},
	{0x48D0, 0x236A6A88},
	{0x4DA0, 0x8C413016},
	{0x4DA4, 0xA140B028},
	{0x4DA8, 0x00150A31},
	{0x48D4, 0x576DF814},
	{0x48D8, 0xA08877AC},
	{0x48DC, 0x0000007A},
	{0x4DAC, 0x00001184},
	{0x48E0, 0xBCEB4A14},
	{0x48E4, 0x000A3A4A},
	{0x48E8, 0xBCEB4A14},
	{0x48EC, 0x000A3A4A},
	{0x4DB0, 0x2F63DD3A},
	{0x48F0, 0x9A8A8A85},
	{0x48F4, 0x0C9BB99A},
	{0x4DB4, 0x0000009A},
	{0x48F8, 0x38384242},
	{0x48FC, 0x0086102E},
	{0x4900, 0xCA24C82A},
	{0x4DB8, 0x00000000},
	{0x4DBC, 0x0000F49D},
	{0x4EE0, 0x00000001},
	{0x4DC0, 0x000001C4},
	{0x4DC4, 0x00000000},
	{0x4DC8, 0x38384242},
	{0x4DCC, 0x030E902E},
	{0x4DD0, 0x994C1502},
	{0x4DD4, 0x00017912},
	{0x4EE4, 0x00000001},
	{0x4904, 0x00008A62},
	{0x4DD8, 0x00000002},
	{0x4908, 0x00000008},
	{0x490C, 0x80040000},
	{0x4910, 0x80040000},
	{0x4914, 0xFE800000},
	{0x4918, 0x834C0000},
	{0x491C, 0x00000000},
	{0x4920, 0x00000000},
	{0x4924, 0x000003FF},
	{0x4928, 0x00000000},
	{0x492C, 0x00000000},
	{0x4930, 0x00000000},
	{0x4934, 0x40000000},
	{0x4938, 0x00000000},
	{0x493C, 0x00000000},
	{0x4940, 0x00000000},
	{0x4944, 0x00000000},
	{0x4948, 0x04065800},
	{0x494C, 0x02010080},
	{0x4950, 0x0E1E3E05},
	{0x4954, 0x0A163068},
	{0x4958, 0x00206040},
	{0x495C, 0x02020202},
	{0x4960, 0x00002020},
	{0x4DDC, 0x18002000},
	{0x4DE0, 0x00004001},
	{0x4DE4, 0x00040004},
	{0x4DE8, 0x00400040},
	{0x4DEC, 0x04000400},
	{0x4DF0, 0x08080618},
	{0x4DF4, 0x08081616},
	{0x4DF8, 0x08080808},
	{0x4DFC, 0x18180808},
	{0x4E00, 0x01020100},
	{0x4E04, 0x05020502},
	{0x4E08, 0x00020E0F},
	{0x4E0C, 0x00000000},
	{0x4E10, 0x16080806},
	{0x4E14, 0x08080816},
	{0x4E18, 0x08080808},
	{0x4E1C, 0x00181808},
	{0x4E20, 0x02010201},
	{0x4E24, 0x0F050205},
	{0x4E28, 0x0000020E},
	{0x4E2C, 0x00000000},
	{0x4E70, 0x00000001},
	{0x4970, 0x00000000},
	{0x4974, 0xC00CD62D},
	{0x4978, 0x00000103},
	{0x4E30, 0x02E416A8},
	{0x497C, 0x00000000},
	{0x4980, 0x00000000},
	{0x4984, 0x00000000},
	{0x4988, 0x00000000},
	{0x498C, 0x00000000},
	{0x4E34, 0x00FC0000},
	{0x4E38, 0x0000F800},
	{0x4E3C, 0x00000001},
	{0x4990, 0x00000000},
	{0x4994, 0x00000000},
	{0x4998, 0x00000000},
	{0x499C, 0x00000000},
	{0x49A0, 0x00000000},
	{0x4E40, 0x00FC0000},
	{0x4E44, 0x0000F800},
	{0x4E48, 0x00000001},
	{0xC54, 0x10014368},
	{0xC58, 0x61000000},
	{0xC5C, 0x805580F0},
	{0xC64, 0x0010A030},
	{0x189C, 0x000003FF},
	{0xC6C, 0x00060020},
	{0xC3C, 0x2840E1BF},
	{0xC40, 0x00000000},
	{0xC44, 0x00000007},
	{0xC48, 0x410E4000},
	{0xC54, 0x1EE1436A},
	{0xC58, 0x61000000},
	{0x730, 0x00000002},
	{0xC60, 0x017FFFF2},
	{0xC64, 0x0010A170},
	{0xC64, 0x0010A170},
	{0xC68, 0x000000FF},
	{0xC64, 0x0010A130},
	{0xC54, 0x1AE1436A},
	{0xC6C, 0x00060020},
	{0xC58, 0x41000000},
	{0x708, 0x00000000},
	{0xC6C, 0x00061020},
	{0x884, 0x0043F01D},
	{0x704, 0x601E0100},
	{0x710, 0xEF810000},
	{0xC54, 0x1AE1436A},
	{0xC58, 0x41000000},
	{0xC68, 0x10000050},
	{0xC6C, 0x20061020},
	{0x704, 0x601E0100},
	{0xC74, 0x00000000},
	{0x90C, 0x00300000},
	{0xC70, 0x071BFC00},
	{0xC74, 0x3FFFFFFF},
	{0xC78, 0x3FFFFFFF},
	{0xC7C, 0x0000BFFF},
	{0xD40, 0xF64FA0F7},
	{0xD44, 0x0400463F},
	{0xD48, 0x0003FFFF},
	{0xD4C, 0x00000000},
	{0xD50, 0xF64FA0F7},
	{0xD54, 0x04100437},
	{0xD58, 0x0000FF7F},
	{0xD5C, 0x00000000},
	{0xD60, 0x00000000},
	{0xD64, 0x00000000},
	{0xD70, 0x00000015},
	{0xD90, 0x000003FF},
	{0xD94, 0x00000000},
	{0xD98, 0x0000003F},
	{0xD9C, 0x00000000},
	{0xDA0, 0x000003FE},
	{0xDA4, 0x00000000},
	{0xDA8, 0x0000003F},
	{0xDAC, 0x00000000},
	{0xD00, 0x77777777},
	{0xD04, 0xBBBBBBBB},
	{0xD08, 0xBBBBBBBB},
	{0xD0C, 0x00000070},
	{0xD10, 0x20110900},
	{0xD10, 0x20110FFF},
	{0xD78, 0x00000001},
	{0xD7C, 0x001C040A},
	{0xD84, 0x00006007},
	{0xD84, 0x00006607},
	{0xD10, 0x28110FFF},
	{0xD18, 0x50209900},
	{0xD80, 0x00804100},
	{0xD80, 0x00804200},
	{0x718, 0x1333233F},
	{0x604, 0x041E1E1E},
	{0x714, 0x00010000},
	{0x586C, 0x000000F0},
	{0x586C, 0x000000E0},
	{0x586C, 0x000000D0},
	{0x586C, 0x000000C0},
	{0x586C, 0x000000B0},
	{0x586C, 0x000000A0},
	{0x586C, 0x00000090},
	{0x586C, 0x00000080},
	{0x586C, 0x00000070},
	{0x586C, 0x00000060},
	{0x586C, 0x00000050},
	{0x586C, 0x00000040},
	{0x586C, 0x00000030},
	{0x586C, 0x00000020},
	{0x586C, 0x00000010},
	{0x586C, 0x00000000},
	{0x786C, 0x000000F0},
	{0x786C, 0x000000E0},
	{0x786C, 0x000000D0},
	{0x786C, 0x000000C0},
	{0x786C, 0x000000B0},
	{0x786C, 0x000000A0},
	{0x786C, 0x00000090},
	{0x786C, 0x00000080},
	{0x786C, 0x00000070},
	{0x786C, 0x00000060},
	{0x786C, 0x00000050},
	{0x786C, 0x00000040},
	{0x786C, 0x00000030},
	{0x786C, 0x00000020},
	{0x786C, 0x00000010},
	{0x786C, 0x00000000},
	{0x304, 0x0CE31333},
	{0x300, 0xF30CE31C},
	{0x304, 0x13EF1F19},
	{0x308, 0x0C13E3F3},
	{0x30C, 0x130C0C0C},
	{0x310, 0x80496000},
	{0x314, 0x0041E000},
	{0x318, 0x20022042},
	{0x31C, 0x20448009},
	{0x320, 0x00490040},
	{0x324, 0xE0000070},
	{0x328, 0xE000E000},
	{0x32C, 0x0041E000},
	{0x35C, 0x000004C4},
	{0xC0D4, 0xA7C41460},
	{0xC0D8, 0xC6BA7F67},
	{0xC0DC, 0x30C52868},
	{0xC0E0, 0x75008128},
	{0xC0E4, 0x0000272B},
	{0xC1D4, 0xA7C41460},
	{0xC1D8, 0xC6BA7F67},
	{0xC1DC, 0x30C52868},
	{0xC1E0, 0x75008128},
	{0xC1E4, 0x0000272B},
	{0xC0EC, 0x00030003},
	{0xC1EC, 0x00030003},
	{0xC004, 0x03020000},
	{0xC024, 0x03020000},
	{0xC104, 0x03020000},
	{0xC124, 0x03020000},
	{0xC0E8, 0x000A0C81},
	{0xC0F0, 0x00000024},
	{0xC1E8, 0x000A0C81},
	{0xC1F0, 0x00000024},
	{0x334, 0xFFFFFFFF},
	{0x33C, 0x55000000},
	{0x340, 0x00005555},
	{0x724, 0x00111201},
	{0x5868, 0xA9550000},
	{0x5870, 0x33221100},
	{0x5874, 0x77665544},
	{0x5878, 0xBBAA9988},
	{0x587C, 0xFFEEDDCC},
	{0x5880, 0x76543210},
	{0x5884, 0xFEDCBA98},
	{0x5888, 0x00000000},
	{0x588C, 0x00000000},
	{0x5894, 0x00000008},
	{0x7868, 0xA9550000},
	{0x7870, 0x33221100},
	{0x7874, 0x77665544},
	{0x7878, 0xBBAA9988},
	{0x787C, 0xFFEEDDCC},
	{0x7880, 0x76543210},
	{0x7884, 0xFEDCBA98},
	{0x7888, 0x00000000},
	{0x788C, 0x00000000},
	{0x7894, 0x00000008},
	{0x650, 0x00200888},
	{0x710, 0xF3810000},
	{0x020, 0x0000F381},
	{0x024, 0x0000F381},
	{0xC0A8, 0x00000080},
	{0xC0AC, 0x00000100},
	{0xC0B8, 0x00020000},
	{0xC1A8, 0x00000080},
	{0xC1AC, 0x00000100},
	{0xC1B8, 0x00020000},
	{0x1038, 0x00003100},
	{0x1038, 0x00003100},
	{0x3038, 0x00003100},
	{0x3038, 0x00003100},
	{0xC14, 0xA5000000},
	{0x908, 0x00000001},
	{0xC54, 0x1EE14368},
	{0xC88, 0xC2AC8000},
	{0xC8C, 0x02F2FC08},
	{0xC70, 0x071BFC00},
	{0x980, 0x10002251},
	{0x988, 0x3C3C4107},
	{0x904, 0x00000005},
	{0x994, 0x00000010},
	{0x000, 0x0580801F},
	{0x240C, 0x00000000},
	{0x010, 0x000C01FF},
	{0x010, 0x001C01FF},
	{0x2424, 0x00000008},
	{0x620, 0x00141A30},
	{0x660, 0x00000004},
	{0x2620, 0x00141A30},
	{0x2660, 0x00000000},
	{0x640, 0x180A141E},
	{0x640, 0x1814141E},
	{0x640, 0x1814141E},
	{0x640, 0x14141414},
	{0x644, 0x3C14283C},
	{0x644, 0x3C29283C},
	{0x644, 0x3C29203C},
	{0x644, 0x3C29201A},
	{0x2640, 0x180A141E},
	{0x2640, 0x1814141E},
	{0x2640, 0x1814141E},
	{0x2640, 0x14141414},
	{0x2644, 0x3C14283C},
	{0x2644, 0x3C29283C},
	{0x2644, 0x3C29203C},
	{0x2644, 0x3C29201A},
	{0x620, 0x00141A40},
	{0x64C, 0x1D0A141E},
	{0x64C, 0x1D1D141E},
	{0x64C, 0x1D1D1D1E},
	{0x2620, 0x00141A40},
	{0x264C, 0x1D0A141E},
	{0x264C, 0x1D1D141E},
	{0x264C, 0x1D1D1D1E},
	{0x2300, 0x03020100},
	{0x2304, 0x07060504},
	{0x2308, 0x0B0A0908},
	{0x230C, 0x0F0E0D0C},
	{0x2310, 0x13121110},
	{0x2314, 0x17161514},
	{0x2318, 0x00000018},
	{0x231C, 0x00C00000},
	{0x2320, 0x00000000},
	{0x2324, 0x0005298F},
	{0x2328, 0x0015296E},
	{0x232C, 0x0D3B5200},
	{0x2330, 0x00000000},
	{0x2334, 0x00000000},
	{0x2338, 0x00000000},
	{0x233C, 0x00000402},
	{0x2340, 0x00020080},
	{0x2344, 0x03C00000},
	{0x2348, 0x0001FFFF},
	{0x234C, 0x00C80064},
	{0x2350, 0x0190012C},
	{0x2354, 0x000032FE},
	{0x2358, 0xF0203C28},
	{0x235C, 0xF027C000},
	{0x2360, 0x01210C00},
	{0x2320, 0x00000001},
	{0x2300, 0x0C811B40},
	{0x2304, 0xF3FC4ED8},
	{0x2308, 0x08FF808F},
	{0x230C, 0xFCBC80C8},
	{0x2310, 0xBC80536C},
	{0x2314, 0x0363A0F3},
	{0x2318, 0x000000BB},
	{0x724, 0x00111200},
	{0x704, 0x601E0D00},
	{0xC78, 0xBFFFFFFF},
	{0x704, 0x601E0D02},
	{0x704, 0x601E0D02},
	{0x5864, 0x080801FF},
	{0x7864, 0x080801FF},
	{0xC60, 0x017FFFF3},
	{0xC6C, 0x20061021},
	{0x58AC, 0x08000000},
	{0x78AC, 0x08000000},
	{0x8088, 0x007F0000},
	{0x81A4, 0x003F3A00},
	{0x81B4, 0x0100007F},
	{0x81C0, 0x0060010B},
	{0x81A0, 0x00000010},
	{0x8138, 0x40000002},
	{0x82A4, 0x003F3A00},
	{0x82B4, 0x0100007F},
	{0x82C0, 0x0060010B},
	{0x82A0, 0x00000010},
	{0x81A0, 0x00000010},
	{0x8238, 0x40000002},
	{0x8088, 0x00000000},
	{0x8020, 0x00000000},
	{0x8120, 0x00000000},
	{0x8220, 0x00000000},
	{0x8124, 0x00000F0F},
	{0x8224, 0x00000F0F},
	{0x5864, 0x180801FF},
	{0x7864, 0x180801FF},
	{0xC60, 0x017FFFF3},
	{0xC70, 0x071BFE00},
	{0xC70, 0x071BFE60},
	{0xC6C, 0x20061021},
	{0x58AC, 0x08000000},
	{0x78AC, 0x08000000},
	{0x8120, 0x10000000},
	{0x8120, 0x10030000},
	{0x8124, 0x00000F0F},
	{0x8124, 0x00000F0F},
	{0x8224, 0x00000F0F},
	{0x8224, 0x00000F0F},
	{0x8220, 0x10000000},
	{0x8220, 0x10030000},
	{0x704, 0x601E0D00},
	{0x5864, 0x100801FF},
	{0x7864, 0x100801FF},
	{0x5864, 0x180801FF},
	{0x7864, 0x180801FF},
	{0xC60, 0x017FFFF3},
	{0x58D4, 0x7401FE00},
	{0x78D4, 0x7401FE00},
	{0x58F0, 0x400401FF},
	{0x78F0, 0x400401FF},
	{0x58F0, 0x400401FF},
	{0x78F0, 0x400401FF},
	{0x704, 0x601E0D02},
	{0xC7C, 0x0020BFFF},
	{0x58C0, 0x00FE0000},
	{0x58FC, 0x00000000},
	{0x566C, 0x00010005},
	{0x566C, 0x00011005},
	{0x700, 0x00000030},
	{0x9D0, 0x00001001},
	{0x704, 0x601E0D02},
	{0x704, 0x601E0D00},
	{0x704, 0x601C0502},
	{0x000, 0x0580801F},
	{0x980, 0x10002250},
	{0x010, 0x001C01FF},
	{0xC3C, 0x2840E1BF},
	{0x12A8, 0x33337824},
	{0x32A8, 0x33337824},
	{0x620, 0x00141A40},
	{0x2320, 0x00000000},
	{0x664, 0x0000000C},
	{0xC0F8, 0x00000001},
	{0xC1F8, 0x00000001},
	{0x2D7C, 0x739C040A},
	{0x1010, 0x00000000},
	{0x3010, 0x00000000},
	{0x2C14, 0x80000005},
	{0x5818, 0x082C1800},
	{0x7818, 0x082C1800},
	{0x624, 0x0101030A},
	{0x028, 0x0000F381},
	{0x02C, 0x0000F381},
	{0x720, 0x20000000},
	{0x1200, 0x00010142},
	{0x12A0, 0x24903056},
	{0x12AC, 0x12333121},
	{0x12B8, 0x30020000},
	{0x2000, 0x18BBBF84},
	{0x2C14, 0x85000005},
	{0x3200, 0x00010142},
	{0x32A0, 0x24903056},
	{0x32AC, 0x12333121},
	{0x32B8, 0x30020000},
	{0x5800, 0x03FF807F},
	{0x5804, 0x04237040},
	{0x5808, 0x04237040},
	{0x7800, 0x03FF807F},
	{0x7804, 0x04237040},
	{0x7808, 0x04237040},
	{0x010, 0x001C61FF},
	{0x56C8, 0x0E800400},
	{0x76C8, 0x0E800400},
	{0x984, 0x000000E0},
	{0x2008, 0x000FFFFF},
	{0x58B0, 0x00000800},
	{0x5A00, 0x00000000},
	{0x5A04, 0x00000000},
	{0x5A08, 0x00000000},
	{0x5A0C, 0x00000000},
	{0x5A10, 0x00000000},
	{0x5A14, 0x00000000},
	{0x5A18, 0x00000000},
	{0x5A1C, 0x00000000},
	{0x5A20, 0x00000000},
	{0x5A24, 0x00050000},
	{0x5A28, 0x00000000},
	{0x5A2C, 0x00000000},
	{0x5A30, 0x00000000},
	{0x5A34, 0x00000000},
	{0x5A38, 0x00000000},
	{0x5A3C, 0x00000000},
	{0x5A40, 0x00000000},
	{0x5A44, 0x00000005},
	{0x5A48, 0x00000000},
	{0x5A4C, 0x00000000},
	{0x5A50, 0x00000000},
	{0x5A54, 0x00000000},
	{0x5A58, 0x00000000},
	{0x5A5C, 0x00000000},
	{0x5A60, 0x00050000},
	{0x5A64, 0x00000000},
	{0x5A68, 0x00000000},
	{0x5A6C, 0x00000000},
	{0x5A70, 0x00000000},
	{0x5A74, 0x00000000},
	{0x5A78, 0x00000000},
	{0x5A7C, 0x00000000},
	{0x5A80, 0x00000000},
	{0x5A84, 0x00000000},
	{0x5A88, 0x00000000},
	{0x5A8C, 0x00000000},
	{0x5A90, 0x00000000},
	{0x5A94, 0x00000000},
	{0x5A98, 0x00000000},
	{0x5A9C, 0x00000000},
	{0x5AA0, 0x00000000},
	{0x5AA4, 0x00000000},
	{0x5AA8, 0x00000000},
	{0x5AAC, 0x00000000},
	{0x5AB0, 0x00050005},
	{0x5AB4, 0x00050005},
	{0x5AB8, 0x00050005},
	{0x5ABC, 0x00050005},
	{0x5AC0, 0x00000005},
	{0x78B0, 0x00000800},
	{0x7A00, 0x00000000},
	{0x7A04, 0x00000000},
	{0x7A08, 0x00000000},
	{0x7A0C, 0x00000000},
	{0x7A10, 0x00000000},
	{0x7A14, 0x00000000},
	{0x7A18, 0x00000000},
	{0x7A1C, 0x00000000},
	{0x7A20, 0x00000000},
	{0x7A24, 0x00050000},
	{0x7A28, 0x00000000},
	{0x7A2C, 0x00000000},
	{0x7A30, 0x00000000},
	{0x7A34, 0x00000000},
	{0x7A38, 0x00000000},
	{0x7A3C, 0x00000000},
	{0x7A40, 0x00000000},
	{0x7A44, 0x00000005},
	{0x7A48, 0x00000000},
	{0x7A4C, 0x00000000},
	{0x7A50, 0x00000000},
	{0x7A54, 0x00000000},
	{0x7A58, 0x00000000},
	{0x7A5C, 0x00000000},
	{0x7A60, 0x00050000},
	{0x7A64, 0x00000000},
	{0x7A68, 0x00000000},
	{0x7A6C, 0x00000000},
	{0x7A70, 0x00000000},
	{0x7A74, 0x00000000},
	{0x7A78, 0x00000000},
	{0x7A7C, 0x00000000},
	{0x7A80, 0x00000000},
	{0x7A84, 0x00000000},
	{0x7A88, 0x00000000},
	{0x7A8C, 0x00000000},
	{0x7A90, 0x00000000},
	{0x7A94, 0x00000000},
	{0x7A98, 0x00000000},
	{0x7A9C, 0x00000000},
	{0x7AA0, 0x00000000},
	{0x7AA4, 0x00000000},
	{0x7AA8, 0x00000000},
	{0x7AAC, 0x00000000},
	{0x7AB0, 0x00050005},
	{0x7AB4, 0x00050005},
	{0x7AB8, 0x00050005},
	{0x7ABC, 0x00050005},
	{0x7AC0, 0x00000005},
	{0x0F0, 0x00010000},
	{0x0F4, 0x00000018},
	{0x0F8, 0x20220120},
};

static const struct rtw89_reg2_def rtw89_8852c_phy_bb_reg_gain[] = {
	{0xF0FF0000, 0x00000000},
	{0xF03300FF, 0x00000001},
	{0x000, 0x01E3C39F},
	{0x001, 0x00694727},
	{0x002, 0x00005536},
	{0x100, 0x02E3C39F},
	{0x101, 0x0069472A},
	{0x102, 0x00005536},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x10000, 0x1A02E1C9},
	{0x10001, 0x00644A30},
	{0x10002, 0x00006750},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x10000, 0x0EF4D1B9},
	{0x10001, 0x00584125},
	{0x10002, 0x00006750},
	{0xA0000000, 0x00000000},
	{0x10000, 0x1A02E1C9},
	{0x10001, 0x00644A30},
	{0x10002, 0x00006750},
	{0xB0000000, 0x00000000},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x10100, 0x1901E1C8},
	{0x10101, 0x0061482D},
	{0x10102, 0x00006750},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x10100, 0x04E8C5AD},
	{0x10101, 0x00594125},
	{0x10102, 0x00006850},
	{0xA0000000, 0x00000000},
	{0x10100, 0x1901E1C8},
	{0x10101, 0x0061482D},
	{0x10102, 0x00006750},
	{0xB0000000, 0x00000000},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x20000, 0x1601E2CA},
	{0x20001, 0x005D452A},
	{0x20002, 0x00006750},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x20000, 0x0EF4D3BB},
	{0x20001, 0x00563F25},
	{0x20002, 0x00006850},
	{0xA0000000, 0x00000000},
	{0x20000, 0x1601E2CA},
	{0x20001, 0x005D452A},
	{0x20002, 0x00006750},
	{0xB0000000, 0x00000000},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x20100, 0x1901E1C8},
	{0x20101, 0x0061482D},
	{0x20102, 0x00006750},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x20100, 0x0BF1CFB7},
	{0x20101, 0x00574025},
	{0x20102, 0x00006750},
	{0xA0000000, 0x00000000},
	{0x20100, 0x1901E1C8},
	{0x20101, 0x0061482D},
	{0x20102, 0x00006750},
	{0xB0000000, 0x00000000},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x30000, 0x1700E1CA},
	{0x30001, 0x005E472B},
	{0x30002, 0x00006750},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x30000, 0x05EFCEB7},
	{0x30001, 0x004B351A},
	{0x30002, 0x00006850},
	{0xA0000000, 0x00000000},
	{0x30000, 0x1700E1CA},
	{0x30001, 0x005E472B},
	{0x30002, 0x00006750},
	{0xB0000000, 0x00000000},
	{0x80ff0000, 0x00000000}, {0x40000000, 0x00000000},
	{0x30100, 0x14FEE0C9},
	{0x30101, 0x00594428},
	{0x30102, 0x00006650},
	{0x903300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x30100, 0x0CF2D1B9},
	{0x30101, 0x00563F24},
	{0x30102, 0x00006750},
	{0xA0000000, 0x00000000},
	{0x30100, 0x14FEE0C9},
	{0x30101, 0x00594428},
	{0x30102, 0x00006650},
	{0xB0000000, 0x00000000},
	{0x40000, 0x13FCDDC8},
	{0x40001, 0x005D4328},
	{0x40002, 0x00006850},
	{0x40100, 0x14FEE3CF},
	{0x40101, 0x00583E24},
	{0x40102, 0x00006850},
	{0x50000, 0x0DF4D6C6},
	{0x50001, 0x00604227},
	{0x50002, 0x00006850},
	{0x50100, 0x1903E7D5},
	{0x50101, 0x0061462B},
	{0x50102, 0x00006850},
	{0x60000, 0x0FF5D7C6},
	{0x60001, 0x005D4429},
	{0x60002, 0x00006850},
	{0x60100, 0x12FADECF},
	{0x60101, 0x005B4126},
	{0x60102, 0x00006850},
	{0x70000, 0x09F1D2C3},
	{0x70001, 0x00554026},
	{0x70002, 0x00006750},
	{0x70100, 0x0CF5DACC},
	{0x70101, 0x00563E25},
	{0x70102, 0x00006750},
	{0x2000000, 0x02E4C4A0},
	{0x2000001, 0x006A4828},
	{0x2000100, 0x02E4C5A1},
	{0x2000101, 0x00664629},
	{0x2010000, 0x05EBC8AF},
	{0x2010001, 0x00543D24},
	{0x2010100, 0x07ECC9B0},
	{0x2010101, 0x005B4126},
	{0x2020000, 0x05EDCCB2},
	{0x2020001, 0x004D361C},
	{0x2020100, 0x06ECCBB2},
	{0x2020101, 0x00553D22},
	{0x2030000, 0x02ECCCB3},
	{0x2030001, 0x00483118},
	{0x2030100, 0x04ECCCB2},
	{0x2030101, 0x004F381C},
	{0x3000000, 0x00000000},
	{0x3000001, 0x00000000},
	{0x3000002, 0x00000000},
	{0x3000003, 0x00000000},
	{0x3000100, 0x00000000},
	{0x3000101, 0x00000000},
	{0x3000102, 0x00000000},
	{0x3000103, 0x00000000},
	{0x3010000, 0x0E0CFB0A},
	{0x3010001, 0x00100F06},
	{0x3010002, 0x34333333},
	{0x3010003, 0x3434343C},
	{0x3010100, 0x0E0CFB0A},
	{0x3010101, 0x00100F06},
	{0x3010102, 0x34333333},
	{0x3010103, 0x3434343C},
	{0x3020000, 0x0E0CFB0A},
	{0x3020001, 0x00100F06},
	{0x3020002, 0x34333333},
	{0x3020003, 0x3434343C},
	{0x3020100, 0x0E0CFB0A},
	{0x3020101, 0x00100F06},
	{0x3020102, 0x34333333},
	{0x3020103, 0x3434343C},
	{0x3030000, 0x0E0CFB0A},
	{0x3030001, 0x00100F06},
	{0x3030002, 0x34333333},
	{0x3030003, 0x3434343C},
	{0x3030100, 0x0E0CFB0A},
	{0x3030101, 0x00100F06},
	{0x3030102, 0x34333333},
	{0x3030103, 0x3434343C},
	{0x3040000, 0x0E0CFB0A},
	{0x3040001, 0x00100F06},
	{0x3040002, 0x343B3333},
	{0x3040003, 0x34343C3C},
	{0x3040100, 0x0E0CFB0A},
	{0x3040101, 0x00100F06},
	{0x3040102, 0x343B3333},
	{0x3040103, 0x34343C3C},
	{0x3050000, 0x0E0CFB0A},
	{0x3050001, 0x00100F06},
	{0x3050002, 0x343B3333},
	{0x3050003, 0x34343C3C},
	{0x3050100, 0x0E0CFB0A},
	{0x3050101, 0x00100F06},
	{0x3050102, 0x343B3333},
	{0x3050103, 0x34343C3C},
	{0x3060000, 0x0E0CFB0A},
	{0x3060001, 0x00100F06},
	{0x3060002, 0x3C3B3333},
	{0x3060003, 0x34343C3C},
	{0x3060100, 0x0E0CFB0A},
	{0x3060101, 0x00100F06},
	{0x3060102, 0x3C3B3333},
	{0x3060103, 0x34343C3C},
	{0x3070000, 0x0E0CFB0A},
	{0x3070001, 0x00100F06},
	{0x3070002, 0x3C3B3333},
	{0x3070003, 0x34343C3C},
	{0x3070100, 0x0E0CFB0A},
	{0x3070101, 0x00100F06},
	{0x3070102, 0x3C3B3333},
	{0x3070103, 0x34343C3C},
};

static const struct rtw89_reg2_def rtw89_8852c_phy_radioa_regs[] =  {
	{0xF0010000, 0x00000000},
	{0xF0020000, 0x00000001},
	{0xF0320000, 0x00000002},
	{0xF0330000, 0x00000003},
	{0xF0340000, 0x00000004},
	{0xF0350000, 0x00000005},
	{0xF0360000, 0x00000006},
	{0xF0010001, 0x00000007},
	{0xF0020001, 0x00000008},
	{0xF0320001, 0x00000009},
	{0xF0330001, 0x0000000A},
	{0xF0340001, 0x0000000B},
	{0xF0350001, 0x0000000C},
	{0xF0360001, 0x0000000D},
	{0xF03F0001, 0x0000000E},
	{0xF0400001, 0x0000000F},
	{0x005, 0x00000000},
	{0x10005, 0x00000000},
	{0x000, 0x00030001},
	{0x10000, 0x00030000},
	{0x018, 0x00011124},
	{0x10018, 0x00011124},
	{0x0EF, 0x00080000},
	{0x033, 0x00000001},
	{0x03E, 0x00000620},
	{0x03F, 0x0000020C},
	{0x0EF, 0x00000000},
	{0x05F, 0x00000032},
	{0x097, 0x00043200},
	{0x0A6, 0x00066DB7},
	{0x0EF, 0x00004000},
	{0x033, 0x00000005},
	{0x03E, 0x00000000},
	{0x03F, 0x00010500},
	{0x033, 0x00000003},
	{0x03E, 0x00000000},
	{0x03F, 0x00028B00},
	{0x033, 0x00000002},
	{0x03E, 0x00000000},
	{0x03F, 0x0009AB00},
	{0x033, 0x0000000D},
	{0x03E, 0x00000000},
	{0x03F, 0x00010500},
	{0x033, 0x0000000B},
	{0x03E, 0x00000000},
	{0x03F, 0x00028B00},
	{0x033, 0x0000000A},
	{0x03E, 0x00000000},
	{0x03F, 0x0009AB00},
	{0x0EF, 0x00000000},
	{0x000, 0x00033C01},
	{0x10000, 0x00033C00},
	{0x01A, 0x00040004},
	{0x0FE, 0x00000000},
	{0x096, 0x00015200},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0004D000},
	{0x0DA, 0x000D4009},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0004D000},
	{0x0DA, 0x000D4009},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0004D000},
	{0x0DA, 0x000D4009},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0004D000},
	{0x0DA, 0x000D4009},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0004D000},
	{0x0DA, 0x000D4009},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0004D000},
	{0x0DA, 0x000D4009},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0004D000},
	{0x0DA, 0x000D4009},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0xA0000000, 0x00000000},
	{0x067, 0x0004D000},
	{0x0DA, 0x000D4009},
	{0xB0000000, 0x00000000},
	{0x057, 0x0000D589},
	{0x05A, 0x0007FFFF},
	{0x043, 0x00005000},
	{0x0B5, 0x00001720},
	{0x0ED, 0x00000080},
	{0x033, 0x00000000},
	{0x03E, 0x00013FAB},
	{0x03F, 0x000FD800},
	{0x033, 0x00000010},
	{0x03E, 0x00013FAB},
	{0x03F, 0x000FD800},
	{0x033, 0x00000020},
	{0x03E, 0x00013FAB},
	{0x03F, 0x000FD800},
	{0x0ED, 0x00000000},
	{0x0ED, 0x00000200},
	{0x033, 0x00000000},
	{0x03F, 0x000000FA},
	{0x033, 0x00000001},
	{0x03F, 0x000000F2},
	{0x033, 0x00000002},
	{0x03F, 0x000000EA},
	{0x033, 0x00000003},
	{0x03F, 0x000000E2},
	{0x033, 0x00000004},
	{0x03F, 0x000000DA},
	{0x033, 0x00000005},
	{0x03F, 0x000000D2},
	{0x033, 0x00000006},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000CA},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000CA},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000CA},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000CA},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000CA},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000CA},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000CA},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000CC},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000CC},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000CC},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000CC},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000CC},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000CC},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000CC},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000CC},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000CC},
	{0xA0000000, 0x00000000},
	{0x03F, 0x000000CA},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000007},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000C2},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000C2},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000C2},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000C2},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000C2},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000C2},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000C2},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000C4},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000C4},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000C4},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000C4},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000C4},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000C4},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000C4},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000C4},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000C4},
	{0xA0000000, 0x00000000},
	{0x03F, 0x000000C2},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000008},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B8},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B8},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B8},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B8},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B8},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B8},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B8},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0xA0000000, 0x00000000},
	{0x03F, 0x000000B8},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000009},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B0},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B0},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B0},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B0},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B0},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B0},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B0},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0xA0000000, 0x00000000},
	{0x03F, 0x000000B0},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000000A},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A8},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A8},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A8},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A8},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A8},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A8},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A8},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0xA0000000, 0x00000000},
	{0x03F, 0x000000A8},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000000B},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A0},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A0},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A0},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A0},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A0},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A0},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A0},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0xA0000000, 0x00000000},
	{0x03F, 0x000000A0},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000000C},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000098},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000000D},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000098},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000000E},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000088},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000000F},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000088},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000010},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B8},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B8},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B8},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B8},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B8},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B8},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B8},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000BC},
	{0xA0000000, 0x00000000},
	{0x03F, 0x000000B8},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000011},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B0},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B0},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B0},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B0},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B0},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B0},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B0},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000B4},
	{0xA0000000, 0x00000000},
	{0x03F, 0x000000B0},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000012},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A8},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A8},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A8},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A8},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A8},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A8},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A8},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000AC},
	{0xA0000000, 0x00000000},
	{0x03F, 0x000000A8},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000013},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A0},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A0},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A0},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A0},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A0},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A0},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A0},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000000A4},
	{0xA0000000, 0x00000000},
	{0x03F, 0x000000A0},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000014},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000098},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000098},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000015},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000090},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000090},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000090},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000090},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000090},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000090},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000090},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000094},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000090},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000016},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000088},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000008C},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000088},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000017},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000080},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000080},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000080},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000080},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000080},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000080},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000080},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000084},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000080},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000018},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000038},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000038},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000038},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000038},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000038},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000038},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000038},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000003C},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000003C},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000003C},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000003C},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000003C},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000003C},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000003C},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000003C},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000003C},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000038},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000019},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000030},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000030},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000030},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000030},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000030},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000030},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000030},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000034},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000034},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000034},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000034},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000034},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000034},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000034},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000034},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000034},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000030},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000001A},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000028},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000028},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000028},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000028},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000028},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000028},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000028},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000002C},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000002C},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000002C},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000002C},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000002C},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000002C},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000002C},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000002C},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000002C},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000028},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000001B},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000020},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000020},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000020},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000020},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000020},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000020},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000020},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000024},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000024},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000024},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000024},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000024},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000024},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000024},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000024},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000024},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000020},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000001C},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000018},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000018},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000018},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000018},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000018},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000018},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000018},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000001C},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000001C},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000001C},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000001C},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000001C},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000001C},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000001C},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000001C},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000001C},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000018},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000001D},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000010},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000010},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000010},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000010},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000010},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000010},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000010},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000014},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000014},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000014},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000014},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000014},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000014},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000014},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000014},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000014},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000010},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000001E},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000008},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000008},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000008},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000008},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000008},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000008},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000008},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000000C},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000000C},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000000C},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000000C},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000000C},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000000C},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000000C},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000000C},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000000C},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000008},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000001F},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000000},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000000},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000000},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000000},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000000},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000000},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000000},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000004},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000004},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000004},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000004},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000004},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000004},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000004},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000004},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000004},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000000},
	{0xB0000000, 0x00000000},
	{0x0ED, 0x00000000},
	{0x0B9, 0x00020440},
	{0x018, 0x00001001},
	{0x10018, 0x00001001},
	{0x002, 0x0000000D},
	{0x10002, 0x0000000D},
	{0x0EE, 0x00000000},
	{0x033, 0x0000000B},
	{0x03F, 0x0000000B},
	{0x033, 0x0000000C},
	{0x03F, 0x00000012},
	{0x033, 0x0000000D},
	{0x03F, 0x00000019},
	{0x0EE, 0x00000000},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1752},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1752},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1752},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1752},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1752},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1752},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1752},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0xA0000000, 0x00000000},
	{0x08F, 0x000D1752},
	{0xB0000000, 0x00000000},
	{0x0EB, 0x00000000},
	{0x030, 0x000109B0},
	{0x030, 0x000189B0},
	{0x0EB, 0x00000000},
	{0x0EE, 0x00000010},
	{0x033, 0x00000006},
	{0x03F, 0x00000003},
	{0x033, 0x00000007},
	{0x03F, 0x00000003},
	{0x033, 0x00000008},
	{0x03F, 0x00000001},
	{0x0EE, 0x00000000},
	{0x0EF, 0x00001000},
	{0x033, 0x00000000},
	{0x03F, 0x00000015},
	{0x033, 0x00000001},
	{0x03F, 0x00000017},
	{0x0EF, 0x00000000},
	{0x0EF, 0x00008000},
	{0x033, 0x00000020},
	{0x03F, 0x00060001},
	{0x033, 0x00000021},
	{0x03F, 0x00060032},
	{0x033, 0x00000022},
	{0x03F, 0x00050042},
	{0x033, 0x00000023},
	{0x03F, 0x00040042},
	{0x033, 0x00000024},
	{0x03F, 0x00000001},
	{0x033, 0x00000025},
	{0x03F, 0x00000002},
	{0x033, 0x00000026},
	{0x03F, 0x00000003},
	{0x033, 0x00000027},
	{0x03F, 0x00000003},
	{0x033, 0x00000028},
	{0x03F, 0x00060001},
	{0x033, 0x00000029},
	{0x03F, 0x00060032},
	{0x033, 0x0000002A},
	{0x03F, 0x00050042},
	{0x033, 0x0000002B},
	{0x03F, 0x00040042},
	{0x033, 0x0000002C},
	{0x03F, 0x00000001},
	{0x033, 0x0000002D},
	{0x03F, 0x00000002},
	{0x033, 0x0000002E},
	{0x03F, 0x00000003},
	{0x033, 0x0000002F},
	{0x03F, 0x00000003},
	{0x033, 0x00000030},
	{0x03F, 0x00060001},
	{0x033, 0x00000031},
	{0x03F, 0x00060032},
	{0x033, 0x00000032},
	{0x03F, 0x00050042},
	{0x033, 0x00000033},
	{0x03F, 0x00040042},
	{0x033, 0x00000034},
	{0x03F, 0x00000001},
	{0x033, 0x00000035},
	{0x03F, 0x00000002},
	{0x033, 0x00000036},
	{0x03F, 0x00000003},
	{0x033, 0x00000037},
	{0x03F, 0x00000003},
	{0x033, 0x00000060},
	{0x03F, 0x00060001},
	{0x033, 0x00000061},
	{0x03F, 0x00060032},
	{0x033, 0x00000062},
	{0x03F, 0x00050042},
	{0x033, 0x00000063},
	{0x03F, 0x00040042},
	{0x033, 0x00000064},
	{0x03F, 0x00000001},
	{0x033, 0x00000065},
	{0x03F, 0x00000002},
	{0x033, 0x00000066},
	{0x03F, 0x00000003},
	{0x033, 0x00000067},
	{0x03F, 0x00000003},
	{0x033, 0x00000068},
	{0x03F, 0x00060001},
	{0x033, 0x00000069},
	{0x03F, 0x00060032},
	{0x033, 0x0000006A},
	{0x03F, 0x00050042},
	{0x033, 0x0000006B},
	{0x03F, 0x00040042},
	{0x033, 0x0000006C},
	{0x03F, 0x00000001},
	{0x033, 0x0000006D},
	{0x03F, 0x00000002},
	{0x033, 0x0000006E},
	{0x03F, 0x00000003},
	{0x033, 0x0000006F},
	{0x03F, 0x00000003},
	{0x033, 0x00000070},
	{0x03F, 0x00060001},
	{0x033, 0x00000071},
	{0x03F, 0x00060032},
	{0x033, 0x00000072},
	{0x03F, 0x00050042},
	{0x033, 0x00000073},
	{0x03F, 0x00040042},
	{0x033, 0x00000074},
	{0x03F, 0x00000001},
	{0x033, 0x00000075},
	{0x03F, 0x00000002},
	{0x033, 0x00000076},
	{0x03F, 0x00000003},
	{0x033, 0x00000077},
	{0x03F, 0x00000003},
	{0x033, 0x00000078},
	{0x03F, 0x00060001},
	{0x033, 0x00000079},
	{0x03F, 0x00060032},
	{0x033, 0x0000007A},
	{0x03F, 0x00050042},
	{0x033, 0x0000007B},
	{0x03F, 0x00040042},
	{0x033, 0x0000007C},
	{0x03F, 0x00000001},
	{0x033, 0x0000007D},
	{0x03F, 0x00000002},
	{0x033, 0x0000007E},
	{0x03F, 0x00000003},
	{0x033, 0x0000007F},
	{0x03F, 0x00000003},
	{0x033, 0x000000A0},
	{0x03F, 0x00060001},
	{0x033, 0x000000A1},
	{0x03F, 0x00060032},
	{0x033, 0x000000A2},
	{0x03F, 0x00050042},
	{0x033, 0x000000A3},
	{0x03F, 0x00040042},
	{0x033, 0x000000A4},
	{0x03F, 0x00000001},
	{0x033, 0x000000A5},
	{0x03F, 0x00000002},
	{0x033, 0x000000A6},
	{0x03F, 0x00000003},
	{0x033, 0x000000A7},
	{0x03F, 0x00000003},
	{0x033, 0x000000A8},
	{0x03F, 0x00060001},
	{0x033, 0x000000A9},
	{0x03F, 0x00060032},
	{0x033, 0x000000AA},
	{0x03F, 0x00050042},
	{0x033, 0x000000AB},
	{0x03F, 0x00040042},
	{0x033, 0x000000AC},
	{0x03F, 0x00000001},
	{0x033, 0x000000AD},
	{0x03F, 0x00000002},
	{0x033, 0x000000AE},
	{0x03F, 0x00000003},
	{0x033, 0x000000AF},
	{0x03F, 0x00000003},
	{0x033, 0x000000B0},
	{0x03F, 0x00060001},
	{0x033, 0x000000B1},
	{0x03F, 0x00060032},
	{0x033, 0x000000B2},
	{0x03F, 0x00050042},
	{0x033, 0x000000B3},
	{0x03F, 0x00040042},
	{0x033, 0x000000B4},
	{0x03F, 0x00000001},
	{0x033, 0x000000B5},
	{0x03F, 0x00000002},
	{0x033, 0x000000B6},
	{0x03F, 0x00000003},
	{0x033, 0x000000B7},
	{0x03F, 0x00000003},
	{0x033, 0x000000E0},
	{0x03F, 0x00060001},
	{0x033, 0x000000E1},
	{0x03F, 0x00060032},
	{0x033, 0x000000E2},
	{0x03F, 0x00050042},
	{0x033, 0x000000E3},
	{0x03F, 0x00040042},
	{0x033, 0x000000E4},
	{0x03F, 0x00000001},
	{0x033, 0x000000E5},
	{0x03F, 0x00000002},
	{0x033, 0x000000E6},
	{0x03F, 0x00000003},
	{0x033, 0x000000E7},
	{0x03F, 0x00000003},
	{0x033, 0x000000E8},
	{0x03F, 0x00060001},
	{0x033, 0x000000E9},
	{0x03F, 0x00060032},
	{0x033, 0x000000EA},
	{0x03F, 0x00050042},
	{0x033, 0x000000EB},
	{0x03F, 0x00040042},
	{0x033, 0x000000EC},
	{0x03F, 0x00000001},
	{0x033, 0x000000ED},
	{0x03F, 0x00000002},
	{0x033, 0x000000EE},
	{0x03F, 0x00000003},
	{0x033, 0x000000EF},
	{0x03F, 0x00000003},
	{0x033, 0x000000F0},
	{0x03F, 0x00060001},
	{0x033, 0x000000F1},
	{0x03F, 0x00060032},
	{0x033, 0x000000F2},
	{0x03F, 0x00050042},
	{0x033, 0x000000F3},
	{0x03F, 0x00040042},
	{0x033, 0x000000F4},
	{0x03F, 0x00000001},
	{0x033, 0x000000F5},
	{0x03F, 0x00000002},
	{0x033, 0x000000F6},
	{0x03F, 0x00000003},
	{0x033, 0x000000F7},
	{0x03F, 0x00000003},
	{0x033, 0x000000F8},
	{0x03F, 0x00060001},
	{0x033, 0x000000F9},
	{0x03F, 0x00060032},
	{0x033, 0x000000FA},
	{0x03F, 0x00050042},
	{0x033, 0x000000FB},
	{0x03F, 0x00040042},
	{0x033, 0x000000FC},
	{0x03F, 0x00000001},
	{0x033, 0x000000FD},
	{0x03F, 0x00000002},
	{0x033, 0x000000FE},
	{0x03F, 0x00000003},
	{0x033, 0x000000FF},
	{0x03F, 0x00000003},
	{0x033, 0x00000120},
	{0x03F, 0x00060001},
	{0x033, 0x00000121},
	{0x03F, 0x00060032},
	{0x033, 0x00000122},
	{0x03F, 0x00050042},
	{0x033, 0x00000123},
	{0x03F, 0x00040042},
	{0x033, 0x00000124},
	{0x03F, 0x00000001},
	{0x033, 0x00000125},
	{0x03F, 0x00000002},
	{0x033, 0x00000126},
	{0x03F, 0x00000003},
	{0x033, 0x00000127},
	{0x03F, 0x00000003},
	{0x033, 0x00000128},
	{0x03F, 0x00060001},
	{0x033, 0x00000129},
	{0x03F, 0x00060032},
	{0x033, 0x0000012A},
	{0x03F, 0x00050042},
	{0x033, 0x0000012B},
	{0x03F, 0x00040042},
	{0x033, 0x0000012C},
	{0x03F, 0x00000001},
	{0x033, 0x0000012D},
	{0x03F, 0x00000002},
	{0x033, 0x0000012E},
	{0x03F, 0x00000003},
	{0x033, 0x0000012F},
	{0x03F, 0x00000003},
	{0x033, 0x00000130},
	{0x03F, 0x00060001},
	{0x033, 0x00000131},
	{0x03F, 0x00060032},
	{0x033, 0x00000132},
	{0x03F, 0x00050042},
	{0x033, 0x00000133},
	{0x03F, 0x00040042},
	{0x033, 0x00000134},
	{0x03F, 0x00000001},
	{0x033, 0x00000135},
	{0x03F, 0x00000002},
	{0x033, 0x00000136},
	{0x03F, 0x00000003},
	{0x033, 0x00000137},
	{0x03F, 0x00000003},
	{0x033, 0x00000160},
	{0x03F, 0x00060001},
	{0x033, 0x00000161},
	{0x03F, 0x00060032},
	{0x033, 0x00000162},
	{0x03F, 0x00050042},
	{0x033, 0x00000163},
	{0x03F, 0x00040042},
	{0x033, 0x00000164},
	{0x03F, 0x00000001},
	{0x033, 0x00000165},
	{0x03F, 0x00000002},
	{0x033, 0x00000166},
	{0x03F, 0x00000003},
	{0x033, 0x00000167},
	{0x03F, 0x00000003},
	{0x033, 0x00000168},
	{0x03F, 0x00060001},
	{0x033, 0x00000169},
	{0x03F, 0x00060032},
	{0x033, 0x0000016A},
	{0x03F, 0x00050042},
	{0x033, 0x0000016B},
	{0x03F, 0x00040042},
	{0x033, 0x0000016C},
	{0x03F, 0x00000001},
	{0x033, 0x0000016D},
	{0x03F, 0x00000002},
	{0x033, 0x0000016E},
	{0x03F, 0x00000003},
	{0x033, 0x0000016F},
	{0x03F, 0x00000003},
	{0x033, 0x00000170},
	{0x03F, 0x00060001},
	{0x033, 0x00000171},
	{0x03F, 0x00060032},
	{0x033, 0x00000172},
	{0x03F, 0x00050042},
	{0x033, 0x00000173},
	{0x03F, 0x00040042},
	{0x033, 0x00000174},
	{0x03F, 0x00000001},
	{0x033, 0x00000175},
	{0x03F, 0x00000002},
	{0x033, 0x00000176},
	{0x03F, 0x00000003},
	{0x033, 0x00000177},
	{0x03F, 0x00000003},
	{0x033, 0x00000178},
	{0x03F, 0x00060001},
	{0x033, 0x00000179},
	{0x03F, 0x00060032},
	{0x033, 0x0000017A},
	{0x03F, 0x00050042},
	{0x033, 0x0000017B},
	{0x03F, 0x00040042},
	{0x033, 0x0000017C},
	{0x03F, 0x00000001},
	{0x033, 0x0000017D},
	{0x03F, 0x00000002},
	{0x033, 0x0000017E},
	{0x03F, 0x00000003},
	{0x033, 0x0000017F},
	{0x03F, 0x00000003},
	{0x033, 0x000001A0},
	{0x03F, 0x00060001},
	{0x033, 0x000001A1},
	{0x03F, 0x00060032},
	{0x033, 0x000001A2},
	{0x03F, 0x00050042},
	{0x033, 0x000001A3},
	{0x03F, 0x00040042},
	{0x033, 0x000001A4},
	{0x03F, 0x00000001},
	{0x033, 0x000001A5},
	{0x03F, 0x00000002},
	{0x033, 0x000001A6},
	{0x03F, 0x00000003},
	{0x033, 0x000001A7},
	{0x03F, 0x00000003},
	{0x033, 0x000001A8},
	{0x03F, 0x00060001},
	{0x033, 0x000001A9},
	{0x03F, 0x00060032},
	{0x033, 0x000001AA},
	{0x03F, 0x00050042},
	{0x033, 0x000001AB},
	{0x03F, 0x00040042},
	{0x033, 0x000001AC},
	{0x03F, 0x00000001},
	{0x033, 0x000001AD},
	{0x03F, 0x00000002},
	{0x033, 0x000001AE},
	{0x03F, 0x00000003},
	{0x033, 0x000001AF},
	{0x03F, 0x00000003},
	{0x033, 0x000001B0},
	{0x03F, 0x00060001},
	{0x033, 0x000001B1},
	{0x03F, 0x00060032},
	{0x033, 0x000001B2},
	{0x03F, 0x00050042},
	{0x033, 0x000001B3},
	{0x03F, 0x00040042},
	{0x033, 0x000001B4},
	{0x03F, 0x00000001},
	{0x033, 0x000001B5},
	{0x03F, 0x00000002},
	{0x033, 0x000001B6},
	{0x03F, 0x00000003},
	{0x033, 0x000001B7},
	{0x03F, 0x00000003},
	{0x033, 0x000001E0},
	{0x03F, 0x00060001},
	{0x033, 0x000001E1},
	{0x03F, 0x00060032},
	{0x033, 0x000001E2},
	{0x03F, 0x00050042},
	{0x033, 0x000001E3},
	{0x03F, 0x00040042},
	{0x033, 0x000001E4},
	{0x03F, 0x00000001},
	{0x033, 0x000001E5},
	{0x03F, 0x00000002},
	{0x033, 0x000001E6},
	{0x03F, 0x00000003},
	{0x033, 0x000001E7},
	{0x03F, 0x00000003},
	{0x033, 0x000001E8},
	{0x03F, 0x00060001},
	{0x033, 0x000001E9},
	{0x03F, 0x00060032},
	{0x033, 0x000001EA},
	{0x03F, 0x00050042},
	{0x033, 0x000001EB},
	{0x03F, 0x00040042},
	{0x033, 0x000001EC},
	{0x03F, 0x00000001},
	{0x033, 0x000001ED},
	{0x03F, 0x00000002},
	{0x033, 0x000001EE},
	{0x03F, 0x00000003},
	{0x033, 0x000001EF},
	{0x03F, 0x00000003},
	{0x033, 0x000001F0},
	{0x03F, 0x00060001},
	{0x033, 0x000001F1},
	{0x03F, 0x00060032},
	{0x033, 0x000001F2},
	{0x03F, 0x00050042},
	{0x033, 0x000001F3},
	{0x03F, 0x00040042},
	{0x033, 0x000001F4},
	{0x03F, 0x00000001},
	{0x033, 0x000001F5},
	{0x03F, 0x00000002},
	{0x033, 0x000001F6},
	{0x03F, 0x00000003},
	{0x033, 0x000001F7},
	{0x03F, 0x00000003},
	{0x033, 0x000001F8},
	{0x03F, 0x00060001},
	{0x033, 0x000001F9},
	{0x03F, 0x00060032},
	{0x033, 0x000001FA},
	{0x03F, 0x00050042},
	{0x033, 0x000001FB},
	{0x03F, 0x00040042},
	{0x033, 0x000001FC},
	{0x03F, 0x00000001},
	{0x033, 0x000001FD},
	{0x03F, 0x00000002},
	{0x033, 0x000001FE},
	{0x03F, 0x00000003},
	{0x033, 0x000001FF},
	{0x03F, 0x00000003},
	{0x0EF, 0x00000000},
	{0x0EF, 0x00000100},
	{0x033, 0x00000001},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000002},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000003},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000004},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000005},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000006},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000007},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000008},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000009},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000000A},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000000B},
	{0x03F, 0x0000AFFF},
	{0x033, 0x0000000C},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000000D},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000000E},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000000F},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000010},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000011},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000012},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000013},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000014},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000015},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000E3FF},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000E3FF},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000E3FF},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000E3FF},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000E3FF},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000E3FF},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000E3FF},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0xA0000000, 0x00000000},
	{0x03F, 0x0000E3FF},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000016},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000017},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000018},
	{0x03F, 0x0000FBFF},
	{0x033, 0x00000019},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000001A},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000001B},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000001C},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000001D},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000001E},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000001F},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000020},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000021},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000022},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000023},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000024},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000025},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000026},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000027},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000028},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000029},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000002A},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000002B},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000002C},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000002D},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000002E},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000002F},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000030},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000031},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000032},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000033},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000034},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000035},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000036},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000037},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000038},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000039},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000003A},
	{0x03F, 0x0000EFFF},
	{0x0EF, 0x00000000},
	{0x0EF, 0x00000040},
	{0x033, 0x00000000},
	{0x03F, 0x00004344},
	{0x033, 0x00000001},
	{0x03F, 0x00004344},
	{0x033, 0x00000002},
	{0x03F, 0x00004344},
	{0x033, 0x00000003},
	{0x03F, 0x00004344},
	{0x033, 0x00000004},
	{0x03F, 0x00004344},
	{0x033, 0x00000005},
	{0x03F, 0x00004344},
	{0x033, 0x00000006},
	{0x03F, 0x00004324},
	{0x033, 0x00000007},
	{0x03F, 0x00004344},
	{0x033, 0x00000008},
	{0x03F, 0x00004344},
	{0x033, 0x00000009},
	{0x03F, 0x00004344},
	{0x033, 0x0000000A},
	{0x03F, 0x00004344},
	{0x033, 0x0000000B},
	{0x03F, 0x00004344},
	{0x033, 0x00000010},
	{0x03F, 0x00004344},
	{0x033, 0x00000011},
	{0x03F, 0x00004344},
	{0x033, 0x00000012},
	{0x03F, 0x00004344},
	{0x033, 0x00000013},
	{0x03F, 0x00004344},
	{0x033, 0x00000014},
	{0x03F, 0x00004344},
	{0x033, 0x00000015},
	{0x03F, 0x00004344},
	{0x033, 0x00000016},
	{0x03F, 0x00004344},
	{0x033, 0x00000017},
	{0x03F, 0x00004344},
	{0x033, 0x00000018},
	{0x03F, 0x00004344},
	{0x033, 0x00000019},
	{0x03F, 0x00004344},
	{0x033, 0x0000001A},
	{0x03F, 0x00004344},
	{0x033, 0x0000001B},
	{0x03F, 0x00004344},
	{0x033, 0x0000001C},
	{0x03F, 0x00004344},
	{0x033, 0x0000001D},
	{0x03F, 0x00004344},
	{0x033, 0x0000001E},
	{0x03F, 0x00004344},
	{0x033, 0x0000001F},
	{0x03F, 0x00004344},
	{0x0EF, 0x00000000},
	{0x0EF, 0x00000020},
	{0x033, 0x00000010},
	{0x03F, 0x00000200},
	{0x033, 0x00000011},
	{0x03F, 0x00000200},
	{0x033, 0x00000012},
	{0x03F, 0x00000200},
	{0x033, 0x00000013},
	{0x03F, 0x00000200},
	{0x033, 0x00000020},
	{0x03F, 0x00000200},
	{0x033, 0x00000021},
	{0x03F, 0x00000200},
	{0x033, 0x00000022},
	{0x03F, 0x00000200},
	{0x033, 0x00000023},
	{0x03F, 0x00000200},
	{0x0EF, 0x00000000},
	{0x0EF, 0x00000010},
	{0x030, 0x000084DC},
	{0x030, 0x000103C9},
	{0x030, 0x00018399},
	{0x030, 0x00020287},
	{0x030, 0x00028277},
	{0x030, 0x00030165},
	{0x030, 0x00038144},
	{0x030, 0x00040044},
	{0x030, 0x00048022},
	{0x030, 0x00050011},
	{0x030, 0x00058000},
	{0x030, 0x00060000},
	{0x030, 0x00068000},
	{0x030, 0x00070000},
	{0x0EF, 0x00000000},
	{0x0EF, 0x00000080},
	{0x033, 0x00000004},
	{0x03E, 0x00000013},
	{0x03F, 0x00023C58},
	{0x033, 0x00000005},
	{0x03E, 0x00000013},
	{0x03F, 0x00023C58},
	{0x033, 0x00000006},
	{0x03E, 0x00000014},
	{0x03F, 0x00021C58},
	{0x033, 0x00000007},
	{0x03E, 0x00000014},
	{0x03F, 0x00022B58},
	{0x033, 0x00000008},
	{0x03E, 0x00000013},
	{0x03F, 0x00023C58},
	{0x033, 0x00000009},
	{0x03E, 0x00000013},
	{0x03F, 0x00023C58},
	{0x033, 0x0000000A},
	{0x03E, 0x00000014},
	{0x03F, 0x00021C58},
	{0x033, 0x0000000B},
	{0x03E, 0x00000014},
	{0x03F, 0x00022B58},
	{0x033, 0x0000000C},
	{0x03E, 0x00000013},
	{0x03F, 0x00023C58},
	{0x033, 0x0000000D},
	{0x03E, 0x00000013},
	{0x03F, 0x00023C58},
	{0x033, 0x0000000E},
	{0x03E, 0x00000014},
	{0x03F, 0x00021C58},
	{0x033, 0x0000000F},
	{0x03E, 0x00000014},
	{0x03F, 0x00022B58},
	{0x033, 0x00000010},
	{0x03E, 0x00000013},
	{0x03F, 0x00023C58},
	{0x033, 0x00000011},
	{0x03E, 0x0000001B},
	{0x03F, 0x00023C58},
	{0x033, 0x00000012},
	{0x03E, 0x00000014},
	{0x03F, 0x00021C58},
	{0x033, 0x00000013},
	{0x03E, 0x00000014},
	{0x03F, 0x00022B58},
	{0x033, 0x00000014},
	{0x03E, 0x00000013},
	{0x03F, 0x00023C58},
	{0x033, 0x00000015},
	{0x03E, 0x0000001B},
	{0x03F, 0x00025A58},
	{0x033, 0x00000016},
	{0x03E, 0x0000001C},
	{0x03F, 0x00021C58},
	{0x033, 0x00000017},
	{0x03E, 0x00000014},
	{0x03F, 0x00022A58},
	{0x033, 0x00000018},
	{0x03E, 0x00000013},
	{0x03F, 0x00025A58},
	{0x033, 0x00000019},
	{0x03E, 0x0000001B},
	{0x03F, 0x00025A58},
	{0x033, 0x0000001A},
	{0x03E, 0x00000014},
	{0x03F, 0x00022A58},
	{0x033, 0x0000001B},
	{0x03E, 0x00000014},
	{0x03F, 0x00022A58},
	{0x033, 0x0000001C},
	{0x03E, 0x00000014},
	{0x03F, 0x0002CD58},
	{0x033, 0x0000001D},
	{0x03E, 0x0000001B},
	{0x03F, 0x00025A58},
	{0x033, 0x0000001E},
	{0x03E, 0x00000013},
	{0x03F, 0x00021E58},
	{0x033, 0x0000001F},
	{0x03E, 0x00000013},
	{0x03F, 0x00022A58},
	{0x033, 0x00000020},
	{0x03E, 0x00000014},
	{0x03F, 0x0002CD58},
	{0x033, 0x00000021},
	{0x03E, 0x0000001C},
	{0x03F, 0x0002CD58},
	{0x033, 0x00000022},
	{0x03E, 0x00000014},
	{0x03F, 0x00021E58},
	{0x033, 0x00000023},
	{0x03E, 0x00000014},
	{0x03F, 0x00022D58},
	{0x033, 0x00000024},
	{0x03E, 0x00000014},
	{0x03F, 0x0002CD58},
	{0x033, 0x00000025},
	{0x03E, 0x00000014},
	{0x03F, 0x0002CD58},
	{0x033, 0x00000026},
	{0x03E, 0x00000014},
	{0x03F, 0x00021E58},
	{0x033, 0x00000027},
	{0x03E, 0x00000014},
	{0x03F, 0x00022D58},
	{0x033, 0x00000028},
	{0x03E, 0x00000014},
	{0x03F, 0x0002CD58},
	{0x033, 0x00000029},
	{0x03E, 0x00000014},
	{0x03F, 0x0002CD58},
	{0x033, 0x0000002A},
	{0x03E, 0x00000014},
	{0x03F, 0x00021E58},
	{0x033, 0x0000002B},
	{0x03E, 0x00000014},
	{0x03F, 0x00022D58},
	{0x033, 0x0000002C},
	{0x03E, 0x00000014},
	{0x03F, 0x0002CD58},
	{0x033, 0x0000002D},
	{0x03E, 0x00000014},
	{0x03F, 0x0002CD58},
	{0x033, 0x0000002E},
	{0x03E, 0x00000014},
	{0x03F, 0x00021E58},
	{0x033, 0x0000002F},
	{0x03E, 0x00000014},
	{0x03F, 0x00022D58},
	{0x033, 0x00000030},
	{0x03E, 0x00000014},
	{0x03F, 0x0002CD58},
	{0x033, 0x00000031},
	{0x03E, 0x00000014},
	{0x03F, 0x0002CD58},
	{0x033, 0x00000032},
	{0x03E, 0x00000014},
	{0x03F, 0x00021E58},
	{0x033, 0x00000033},
	{0x03E, 0x00000014},
	{0x03F, 0x00022D58},
	{0x033, 0x00000034},
	{0x03E, 0x00000014},
	{0x03F, 0x0002CD58},
	{0x033, 0x00000035},
	{0x03E, 0x00000014},
	{0x03F, 0x0002CD58},
	{0x033, 0x00000036},
	{0x03E, 0x00000014},
	{0x03F, 0x00021E58},
	{0x033, 0x00000037},
	{0x03E, 0x00000014},
	{0x03F, 0x00022D58},
	{0x033, 0x00000038},
	{0x03E, 0x00000014},
	{0x03F, 0x0002CD58},
	{0x033, 0x00000039},
	{0x03E, 0x00000014},
	{0x03F, 0x0002CD58},
	{0x033, 0x0000003A},
	{0x03E, 0x00000014},
	{0x03F, 0x00021E58},
	{0x033, 0x0000003B},
	{0x03E, 0x00000014},
	{0x03F, 0x00022D58},
	{0x033, 0x0000003C},
	{0x03E, 0x00000014},
	{0x03F, 0x0002CD58},
	{0x033, 0x0000003D},
	{0x03E, 0x00000014},
	{0x03F, 0x0002CD58},
	{0x033, 0x0000003E},
	{0x03E, 0x00000014},
	{0x03F, 0x00021E58},
	{0x033, 0x0000003F},
	{0x03E, 0x00000014},
	{0x03F, 0x00022D58},
	{0x0EF, 0x00000000},
	{0x0EE, 0x00000800},
	{0x033, 0x00000000},
	{0x03F, 0x00000031},
	{0x033, 0x00000001},
	{0x03F, 0x00000023},
	{0x033, 0x00000002},
	{0x03F, 0x00000015},
	{0x033, 0x00000003},
	{0x03F, 0x00000007},
	{0x0EE, 0x00000000},
	{0x0EC, 0x00000400},
	{0x033, 0x00000003},
	{0x03F, 0x00000030},
	{0x033, 0x00000004},
	{0x03F, 0x00000021},
	{0x0EC, 0x00000000},
	{0x0DE, 0x00000000},
	{0x0EF, 0x00000000},
	{0x033, 0x00000000},
	{0x008, 0x00060280},
	{0x009, 0x00030400},
	{0x0EF, 0x00000000},
	{0x0A7, 0x00080308},
	{0x066, 0x00006000},
	{0x0EF, 0x00000400},
	{0x030, 0x000001FF},
	{0x030, 0x000081FF},
	{0x030, 0x000101FF},
	{0x030, 0x000181FF},
	{0x030, 0x000201FF},
	{0x030, 0x000281FF},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x030, 0x0003017F},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x030, 0x0003017F},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x030, 0x0003017F},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x030, 0x0003017F},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x030, 0x0003017F},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x030, 0x0003017F},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x030, 0x0003017F},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x030, 0x000300FF},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x030, 0x000300FF},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x030, 0x000300FF},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x030, 0x000300FF},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x030, 0x000300FF},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x030, 0x000300FF},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x030, 0x000300FF},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x030, 0x000300FF},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x030, 0x000300FF},
	{0xA0000000, 0x00000000},
	{0x030, 0x0003017F},
	{0xB0000000, 0x00000000},
	{0x030, 0x000380FB},
	{0x0EF, 0x00000000},
	{0x06E, 0x00077A18},
	{0x06D, 0x00000C31},
	{0x06A, 0x000E0F8A},
	{0x06B, 0x000018A0},
	{0x06F, 0x000F81FC},
	{0x05E, 0x0000001F},
	{0x0EF, 0x00000200},
	{0x030, 0x0003D407},
	{0x030, 0x00035A87},
	{0x030, 0x0002CF07},
	{0x030, 0x00024F07},
	{0x030, 0x0001CF07},
	{0x030, 0x00014F07},
	{0x030, 0x0000CF07},
	{0x030, 0x00004F07},
	{0x0EF, 0x00000000},
	{0x0EB, 0x00080000},
	{0x030, 0x00008038},
	{0x030, 0x00010038},
	{0x030, 0x00018038},
	{0x030, 0x00020038},
	{0x030, 0x00028038},
	{0x030, 0x00030038},
	{0x030, 0x0003803C},
	{0x030, 0x0004003C},
	{0x030, 0x0004803C},
	{0x030, 0x0005003C},
	{0x030, 0x0005803C},
	{0x030, 0x0006003C},
	{0x030, 0x0006803C},
	{0x030, 0x0007003C},
	{0x0EB, 0x00000000},
	{0x094, 0x000000FC},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000000},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000000},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000000},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000000},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000000},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000000},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000000},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0xA0000000, 0x00000000},
	{0x095, 0x00000000},
	{0xB0000000, 0x00000000},
	{0x0EE, 0x00001000},
	{0x033, 0x00000020},
	{0x03F, 0x00000052},
	{0x033, 0x00000024},
	{0x03F, 0x0000005A},
	{0x033, 0x00000028},
	{0x03F, 0x0000009C},
	{0x033, 0x0000002C},
	{0x03F, 0x0000019C},
	{0x033, 0x00000030},
	{0x03F, 0x000001A4},
	{0x033, 0x00000034},
	{0x03F, 0x000001E7},
	{0x033, 0x00000038},
	{0x03F, 0x000002E7},
	{0x033, 0x0000003C},
	{0x03F, 0x000003E7},
	{0x033, 0x00000021},
	{0x03F, 0x00000052},
	{0x033, 0x00000025},
	{0x03F, 0x0000005A},
	{0x033, 0x00000029},
	{0x03F, 0x0000009C},
	{0x033, 0x0000002D},
	{0x03F, 0x0000019C},
	{0x033, 0x00000031},
	{0x03F, 0x000001A4},
	{0x033, 0x00000035},
	{0x03F, 0x000001E6},
	{0x033, 0x00000039},
	{0x03F, 0x000002E6},
	{0x033, 0x0000003D},
	{0x03F, 0x000003E6},
	{0x033, 0x00000022},
	{0x03F, 0x00000052},
	{0x033, 0x00000026},
	{0x03F, 0x0000005A},
	{0x033, 0x0000002A},
	{0x03F, 0x0000009C},
	{0x033, 0x0000002E},
	{0x03F, 0x0000019C},
	{0x033, 0x00000032},
	{0x03F, 0x000001A4},
	{0x033, 0x00000036},
	{0x03F, 0x000001E6},
	{0x033, 0x0000003A},
	{0x03F, 0x000002E6},
	{0x033, 0x0000003E},
	{0x03F, 0x000003E6},
	{0x033, 0x00000060},
	{0x03F, 0x00000052},
	{0x033, 0x00000064},
	{0x03F, 0x0000005A},
	{0x033, 0x00000068},
	{0x03F, 0x0000009C},
	{0x033, 0x0000006C},
	{0x03F, 0x0000019C},
	{0x033, 0x00000070},
	{0x03F, 0x000001A4},
	{0x033, 0x00000074},
	{0x03F, 0x000001E6},
	{0x033, 0x00000078},
	{0x03F, 0x000002E6},
	{0x033, 0x0000007C},
	{0x03F, 0x000003E6},
	{0x033, 0x00000061},
	{0x03F, 0x00000052},
	{0x033, 0x00000065},
	{0x03F, 0x0000005A},
	{0x033, 0x00000069},
	{0x03F, 0x0000009C},
	{0x033, 0x0000006D},
	{0x03F, 0x0000019C},
	{0x033, 0x00000071},
	{0x03F, 0x000001A4},
	{0x033, 0x00000075},
	{0x03F, 0x000001E6},
	{0x033, 0x00000079},
	{0x03F, 0x000002E6},
	{0x033, 0x0000007D},
	{0x03F, 0x000003E6},
	{0x033, 0x00000062},
	{0x03F, 0x00000052},
	{0x033, 0x00000066},
	{0x03F, 0x0000005A},
	{0x033, 0x0000006A},
	{0x03F, 0x0000009C},
	{0x033, 0x0000006E},
	{0x03F, 0x0000019C},
	{0x033, 0x00000072},
	{0x03F, 0x000001A4},
	{0x033, 0x00000076},
	{0x03F, 0x000001E6},
	{0x033, 0x0000007A},
	{0x03F, 0x000002E6},
	{0x033, 0x0000007E},
	{0x03F, 0x000003E6},
	{0x033, 0x00000063},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000052},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000052},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000052},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000052},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000052},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000052},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000052},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000052},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000067},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000005A},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000005A},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000005A},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000005A},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000005A},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000005A},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000005A},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0xA0000000, 0x00000000},
	{0x03F, 0x0000005A},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000006B},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0xA0000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000006F},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0xA0000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000073},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0xA0000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000077},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0xA0000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000007B},
	{0x03F, 0x000002E7},
	{0x033, 0x0000007F},
	{0x03F, 0x000003E7},
	{0x0EE, 0x00000000},
	{0x100EE, 0x00004000},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000001EF},
	{0x10030, 0x000005E9},
	{0x10030, 0x000009E3},
	{0x10030, 0x00000DDD},
	{0x10030, 0x000011D7},
	{0x10030, 0x0000159F},
	{0x10030, 0x00001999},
	{0x10030, 0x00001D5F},
	{0x10030, 0x00002159},
	{0x10030, 0x0000251F},
	{0x10030, 0x00002919},
	{0x10030, 0x00002CDF},
	{0x10030, 0x000030D9},
	{0x10030, 0x0000349F},
	{0x10030, 0x00003899},
	{0x10030, 0x00003C5F},
	{0x10030, 0x00004059},
	{0x10030, 0x00004453},
	{0x10030, 0x000201ED},
	{0x10030, 0x000205AD},
	{0x10030, 0x000209A7},
	{0x10030, 0x00020DA1},
	{0x10030, 0x0002119B},
	{0x10030, 0x00021561},
	{0x10030, 0x0002195B},
	{0x10030, 0x00021D27},
	{0x10030, 0x00022121},
	{0x10030, 0x000224E9},
	{0x10030, 0x000228E3},
	{0x10030, 0x00022CA9},
	{0x10030, 0x000230A3},
	{0x10030, 0x00023469},
	{0x10030, 0x00023863},
	{0x10030, 0x00023C29},
	{0x10030, 0x00024023},
	{0x10030, 0x0002441D},
	{0x10030, 0x000281EF},
	{0x10030, 0x000285AF},
	{0x10030, 0x000289A9},
	{0x10030, 0x00028DA3},
	{0x10030, 0x0002919D},
	{0x10030, 0x00029563},
	{0x10030, 0x0002995D},
	{0x10030, 0x00029D25},
	{0x10030, 0x0002A11F},
	{0x10030, 0x0002A4E7},
	{0x10030, 0x0002A8E1},
	{0x10030, 0x0002ACA7},
	{0x10030, 0x0002B0A1},
	{0x10030, 0x0002B467},
	{0x10030, 0x0002B861},
	{0x10030, 0x0002BC27},
	{0x10030, 0x0002C021},
	{0x10030, 0x0002C41B},
	{0x10030, 0x000301EF},
	{0x10030, 0x000305AF},
	{0x10030, 0x000309A9},
	{0x10030, 0x00030DA3},
	{0x10030, 0x0003119D},
	{0x10030, 0x00031563},
	{0x10030, 0x0003195D},
	{0x10030, 0x00031D25},
	{0x10030, 0x0003211F},
	{0x10030, 0x000324E7},
	{0x10030, 0x000328E1},
	{0x10030, 0x00032CA7},
	{0x10030, 0x000330A1},
	{0x10030, 0x00033467},
	{0x10030, 0x00033861},
	{0x10030, 0x00033C27},
	{0x10030, 0x00034021},
	{0x10030, 0x0003441B},
	{0x10030, 0x000601EB},
	{0x10030, 0x000605AB},
	{0x10030, 0x000609A5},
	{0x10030, 0x00060D9F},
	{0x10030, 0x00061199},
	{0x10030, 0x00061593},
	{0x10030, 0x00061959},
	{0x10030, 0x00061D53},
	{0x10030, 0x0006211B},
	{0x10030, 0x00062515},
	{0x10030, 0x000628DD},
	{0x10030, 0x00062CD7},
	{0x10030, 0x0006309D},
	{0x10030, 0x00063497},
	{0x10030, 0x0006385D},
	{0x10030, 0x00063C57},
	{0x10030, 0x0006401D},
	{0x10030, 0x00064417},
	{0x10030, 0x000681E7},
	{0x10030, 0x000685A7},
	{0x10030, 0x000689A1},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955F},
	{0x10030, 0x00069959},
	{0x10030, 0x00069D21},
	{0x10030, 0x0006A11B},
	{0x10030, 0x0006A4E3},
	{0x10030, 0x0006A8DD},
	{0x10030, 0x0006ACA5},
	{0x10030, 0x0006B09F},
	{0x10030, 0x0006B465},
	{0x10030, 0x0006B85F},
	{0x10030, 0x0006BC25},
	{0x10030, 0x0006C01F},
	{0x10030, 0x0006C419},
	{0x10030, 0x000701E7},
	{0x10030, 0x000705A7},
	{0x10030, 0x000709A1},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071955},
	{0x10030, 0x00071D1D},
	{0x10030, 0x00072117},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072CA1},
	{0x10030, 0x0007309B},
	{0x10030, 0x00073461},
	{0x10030, 0x0007385B},
	{0x10030, 0x00073C21},
	{0x10030, 0x0007401B},
	{0x10030, 0x0007441B},
	{0x10030, 0x000781E9},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000001EF},
	{0x10030, 0x000005E9},
	{0x10030, 0x000009E3},
	{0x10030, 0x00000DDD},
	{0x10030, 0x000011D7},
	{0x10030, 0x0000159F},
	{0x10030, 0x00001999},
	{0x10030, 0x00001D5F},
	{0x10030, 0x00002159},
	{0x10030, 0x0000251F},
	{0x10030, 0x00002919},
	{0x10030, 0x00002CDF},
	{0x10030, 0x000030D9},
	{0x10030, 0x0000349F},
	{0x10030, 0x00003899},
	{0x10030, 0x00003C5F},
	{0x10030, 0x00004059},
	{0x10030, 0x00004453},
	{0x10030, 0x000201ED},
	{0x10030, 0x000205AD},
	{0x10030, 0x000209A7},
	{0x10030, 0x00020DA1},
	{0x10030, 0x0002119B},
	{0x10030, 0x00021561},
	{0x10030, 0x0002195B},
	{0x10030, 0x00021D27},
	{0x10030, 0x00022121},
	{0x10030, 0x000224E9},
	{0x10030, 0x000228E3},
	{0x10030, 0x00022CA9},
	{0x10030, 0x000230A3},
	{0x10030, 0x00023469},
	{0x10030, 0x00023863},
	{0x10030, 0x00023C29},
	{0x10030, 0x00024023},
	{0x10030, 0x0002441D},
	{0x10030, 0x000281EF},
	{0x10030, 0x000285AF},
	{0x10030, 0x000289A9},
	{0x10030, 0x00028DA3},
	{0x10030, 0x0002919D},
	{0x10030, 0x00029563},
	{0x10030, 0x0002995D},
	{0x10030, 0x00029D25},
	{0x10030, 0x0002A11F},
	{0x10030, 0x0002A4E7},
	{0x10030, 0x0002A8E1},
	{0x10030, 0x0002ACA7},
	{0x10030, 0x0002B0A1},
	{0x10030, 0x0002B467},
	{0x10030, 0x0002B861},
	{0x10030, 0x0002BC27},
	{0x10030, 0x0002C021},
	{0x10030, 0x0002C41B},
	{0x10030, 0x000301EF},
	{0x10030, 0x000305AF},
	{0x10030, 0x000309A9},
	{0x10030, 0x00030DA3},
	{0x10030, 0x0003119D},
	{0x10030, 0x00031563},
	{0x10030, 0x0003195D},
	{0x10030, 0x00031D25},
	{0x10030, 0x0003211F},
	{0x10030, 0x000324E7},
	{0x10030, 0x000328E1},
	{0x10030, 0x00032CA7},
	{0x10030, 0x000330A1},
	{0x10030, 0x00033467},
	{0x10030, 0x00033861},
	{0x10030, 0x00033C27},
	{0x10030, 0x00034021},
	{0x10030, 0x0003441B},
	{0x10030, 0x000601EB},
	{0x10030, 0x000605AB},
	{0x10030, 0x000609A5},
	{0x10030, 0x00060D9F},
	{0x10030, 0x00061199},
	{0x10030, 0x00061593},
	{0x10030, 0x00061959},
	{0x10030, 0x00061D53},
	{0x10030, 0x0006211B},
	{0x10030, 0x00062515},
	{0x10030, 0x000628DD},
	{0x10030, 0x00062CD7},
	{0x10030, 0x0006309D},
	{0x10030, 0x00063497},
	{0x10030, 0x0006385D},
	{0x10030, 0x00063C57},
	{0x10030, 0x0006401D},
	{0x10030, 0x00064417},
	{0x10030, 0x000681E7},
	{0x10030, 0x000685A7},
	{0x10030, 0x000689A1},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955F},
	{0x10030, 0x00069959},
	{0x10030, 0x00069D21},
	{0x10030, 0x0006A11B},
	{0x10030, 0x0006A4E3},
	{0x10030, 0x0006A8DD},
	{0x10030, 0x0006ACA5},
	{0x10030, 0x0006B09F},
	{0x10030, 0x0006B465},
	{0x10030, 0x0006B85F},
	{0x10030, 0x0006BC25},
	{0x10030, 0x0006C01F},
	{0x10030, 0x0006C419},
	{0x10030, 0x000701E7},
	{0x10030, 0x000705A7},
	{0x10030, 0x000709A1},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071955},
	{0x10030, 0x00071D1D},
	{0x10030, 0x00072117},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072CA1},
	{0x10030, 0x0007309B},
	{0x10030, 0x00073461},
	{0x10030, 0x0007385B},
	{0x10030, 0x00073C21},
	{0x10030, 0x0007401B},
	{0x10030, 0x0007441B},
	{0x10030, 0x000781E9},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000001EF},
	{0x10030, 0x000005E9},
	{0x10030, 0x000009E3},
	{0x10030, 0x00000DDD},
	{0x10030, 0x000011D7},
	{0x10030, 0x0000159F},
	{0x10030, 0x00001999},
	{0x10030, 0x00001D5F},
	{0x10030, 0x00002159},
	{0x10030, 0x0000251F},
	{0x10030, 0x00002919},
	{0x10030, 0x00002CDF},
	{0x10030, 0x000030D9},
	{0x10030, 0x0000349F},
	{0x10030, 0x00003899},
	{0x10030, 0x00003C5F},
	{0x10030, 0x00004059},
	{0x10030, 0x00004453},
	{0x10030, 0x000201ED},
	{0x10030, 0x000205AD},
	{0x10030, 0x000209A7},
	{0x10030, 0x00020DA1},
	{0x10030, 0x0002119B},
	{0x10030, 0x00021561},
	{0x10030, 0x0002195B},
	{0x10030, 0x00021D27},
	{0x10030, 0x00022121},
	{0x10030, 0x000224E9},
	{0x10030, 0x000228E3},
	{0x10030, 0x00022CA9},
	{0x10030, 0x000230A3},
	{0x10030, 0x00023469},
	{0x10030, 0x00023863},
	{0x10030, 0x00023C29},
	{0x10030, 0x00024023},
	{0x10030, 0x0002441D},
	{0x10030, 0x000281EF},
	{0x10030, 0x000285AF},
	{0x10030, 0x000289A9},
	{0x10030, 0x00028DA3},
	{0x10030, 0x0002919D},
	{0x10030, 0x00029563},
	{0x10030, 0x0002995D},
	{0x10030, 0x00029D25},
	{0x10030, 0x0002A11F},
	{0x10030, 0x0002A4E7},
	{0x10030, 0x0002A8E1},
	{0x10030, 0x0002ACA7},
	{0x10030, 0x0002B0A1},
	{0x10030, 0x0002B467},
	{0x10030, 0x0002B861},
	{0x10030, 0x0002BC27},
	{0x10030, 0x0002C021},
	{0x10030, 0x0002C41B},
	{0x10030, 0x000301EF},
	{0x10030, 0x000305AF},
	{0x10030, 0x000309A9},
	{0x10030, 0x00030DA3},
	{0x10030, 0x0003119D},
	{0x10030, 0x00031563},
	{0x10030, 0x0003195D},
	{0x10030, 0x00031D25},
	{0x10030, 0x0003211F},
	{0x10030, 0x000324E7},
	{0x10030, 0x000328E1},
	{0x10030, 0x00032CA7},
	{0x10030, 0x000330A1},
	{0x10030, 0x00033467},
	{0x10030, 0x00033861},
	{0x10030, 0x00033C27},
	{0x10030, 0x00034021},
	{0x10030, 0x0003441B},
	{0x10030, 0x000601EB},
	{0x10030, 0x000605AB},
	{0x10030, 0x000609A5},
	{0x10030, 0x00060D9F},
	{0x10030, 0x00061199},
	{0x10030, 0x00061593},
	{0x10030, 0x00061959},
	{0x10030, 0x00061D53},
	{0x10030, 0x0006211B},
	{0x10030, 0x00062515},
	{0x10030, 0x000628DD},
	{0x10030, 0x00062CD7},
	{0x10030, 0x0006309D},
	{0x10030, 0x00063497},
	{0x10030, 0x0006385D},
	{0x10030, 0x00063C57},
	{0x10030, 0x0006401D},
	{0x10030, 0x00064417},
	{0x10030, 0x000681E7},
	{0x10030, 0x000685A7},
	{0x10030, 0x000689A1},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955F},
	{0x10030, 0x00069959},
	{0x10030, 0x00069D21},
	{0x10030, 0x0006A11B},
	{0x10030, 0x0006A4E3},
	{0x10030, 0x0006A8DD},
	{0x10030, 0x0006ACA5},
	{0x10030, 0x0006B09F},
	{0x10030, 0x0006B465},
	{0x10030, 0x0006B85F},
	{0x10030, 0x0006BC25},
	{0x10030, 0x0006C01F},
	{0x10030, 0x0006C419},
	{0x10030, 0x000701E7},
	{0x10030, 0x000705A7},
	{0x10030, 0x000709A1},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071955},
	{0x10030, 0x00071D1D},
	{0x10030, 0x00072117},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072CA1},
	{0x10030, 0x0007309B},
	{0x10030, 0x00073461},
	{0x10030, 0x0007385B},
	{0x10030, 0x00073C21},
	{0x10030, 0x0007401B},
	{0x10030, 0x0007441B},
	{0x10030, 0x000781E9},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000001EF},
	{0x10030, 0x000005E9},
	{0x10030, 0x000009E3},
	{0x10030, 0x00000DDD},
	{0x10030, 0x000011D7},
	{0x10030, 0x0000159F},
	{0x10030, 0x00001999},
	{0x10030, 0x00001D5F},
	{0x10030, 0x00002159},
	{0x10030, 0x0000251F},
	{0x10030, 0x00002919},
	{0x10030, 0x00002CDF},
	{0x10030, 0x000030D9},
	{0x10030, 0x0000349F},
	{0x10030, 0x00003899},
	{0x10030, 0x00003C5F},
	{0x10030, 0x00004059},
	{0x10030, 0x00004453},
	{0x10030, 0x000201ED},
	{0x10030, 0x000205AD},
	{0x10030, 0x000209A7},
	{0x10030, 0x00020DA1},
	{0x10030, 0x0002119B},
	{0x10030, 0x00021561},
	{0x10030, 0x0002195B},
	{0x10030, 0x00021D27},
	{0x10030, 0x00022121},
	{0x10030, 0x000224E9},
	{0x10030, 0x000228E3},
	{0x10030, 0x00022CA9},
	{0x10030, 0x000230A3},
	{0x10030, 0x00023469},
	{0x10030, 0x00023863},
	{0x10030, 0x00023C29},
	{0x10030, 0x00024023},
	{0x10030, 0x0002441D},
	{0x10030, 0x000281EF},
	{0x10030, 0x000285AF},
	{0x10030, 0x000289A9},
	{0x10030, 0x00028DA3},
	{0x10030, 0x0002919D},
	{0x10030, 0x00029563},
	{0x10030, 0x0002995D},
	{0x10030, 0x00029D25},
	{0x10030, 0x0002A11F},
	{0x10030, 0x0002A4E7},
	{0x10030, 0x0002A8E1},
	{0x10030, 0x0002ACA7},
	{0x10030, 0x0002B0A1},
	{0x10030, 0x0002B467},
	{0x10030, 0x0002B861},
	{0x10030, 0x0002BC27},
	{0x10030, 0x0002C021},
	{0x10030, 0x0002C41B},
	{0x10030, 0x000301EF},
	{0x10030, 0x000305AF},
	{0x10030, 0x000309A9},
	{0x10030, 0x00030DA3},
	{0x10030, 0x0003119D},
	{0x10030, 0x00031563},
	{0x10030, 0x0003195D},
	{0x10030, 0x00031D25},
	{0x10030, 0x0003211F},
	{0x10030, 0x000324E7},
	{0x10030, 0x000328E1},
	{0x10030, 0x00032CA7},
	{0x10030, 0x000330A1},
	{0x10030, 0x00033467},
	{0x10030, 0x00033861},
	{0x10030, 0x00033C27},
	{0x10030, 0x00034021},
	{0x10030, 0x0003441B},
	{0x10030, 0x000601EB},
	{0x10030, 0x000605AB},
	{0x10030, 0x000609A5},
	{0x10030, 0x00060D9F},
	{0x10030, 0x00061199},
	{0x10030, 0x00061593},
	{0x10030, 0x00061959},
	{0x10030, 0x00061D53},
	{0x10030, 0x0006211B},
	{0x10030, 0x00062515},
	{0x10030, 0x000628DD},
	{0x10030, 0x00062CD7},
	{0x10030, 0x0006309D},
	{0x10030, 0x00063497},
	{0x10030, 0x0006385D},
	{0x10030, 0x00063C57},
	{0x10030, 0x0006401D},
	{0x10030, 0x00064417},
	{0x10030, 0x000681E7},
	{0x10030, 0x000685A7},
	{0x10030, 0x000689A1},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955F},
	{0x10030, 0x00069959},
	{0x10030, 0x00069D21},
	{0x10030, 0x0006A11B},
	{0x10030, 0x0006A4E3},
	{0x10030, 0x0006A8DD},
	{0x10030, 0x0006ACA5},
	{0x10030, 0x0006B09F},
	{0x10030, 0x0006B465},
	{0x10030, 0x0006B85F},
	{0x10030, 0x0006BC25},
	{0x10030, 0x0006C01F},
	{0x10030, 0x0006C419},
	{0x10030, 0x000701E7},
	{0x10030, 0x000705A7},
	{0x10030, 0x000709A1},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071955},
	{0x10030, 0x00071D1D},
	{0x10030, 0x00072117},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072CA1},
	{0x10030, 0x0007309B},
	{0x10030, 0x00073461},
	{0x10030, 0x0007385B},
	{0x10030, 0x00073C21},
	{0x10030, 0x0007401B},
	{0x10030, 0x0007441B},
	{0x10030, 0x000781EF},
	{0x10030, 0x000785E9},
	{0x10030, 0x000789E3},
	{0x10030, 0x00078DA3},
	{0x10030, 0x00079161},
	{0x10030, 0x0007955B},
	{0x10030, 0x00079921},
	{0x10030, 0x00079D1B},
	{0x10030, 0x0007A0E1},
	{0x10030, 0x0007A4DB},
	{0x10030, 0x0007A8A1},
	{0x10030, 0x0007AC9B},
	{0x10030, 0x0007B061},
	{0x10030, 0x0007B45B},
	{0x10030, 0x0007B821},
	{0x10030, 0x0007BC1B},
	{0x10030, 0x0007C015},
	{0x10030, 0x0007C40F},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000001EF},
	{0x10030, 0x000005E9},
	{0x10030, 0x000009E3},
	{0x10030, 0x00000DDD},
	{0x10030, 0x000011D7},
	{0x10030, 0x0000159F},
	{0x10030, 0x00001999},
	{0x10030, 0x00001D5F},
	{0x10030, 0x00002159},
	{0x10030, 0x0000251F},
	{0x10030, 0x00002919},
	{0x10030, 0x00002CDF},
	{0x10030, 0x000030D9},
	{0x10030, 0x0000349F},
	{0x10030, 0x00003899},
	{0x10030, 0x00003C5F},
	{0x10030, 0x00004059},
	{0x10030, 0x00004453},
	{0x10030, 0x000201ED},
	{0x10030, 0x000205AD},
	{0x10030, 0x000209A7},
	{0x10030, 0x00020DA1},
	{0x10030, 0x0002119B},
	{0x10030, 0x00021561},
	{0x10030, 0x0002195B},
	{0x10030, 0x00021D27},
	{0x10030, 0x00022121},
	{0x10030, 0x000224E9},
	{0x10030, 0x000228E3},
	{0x10030, 0x00022CA9},
	{0x10030, 0x000230A3},
	{0x10030, 0x00023469},
	{0x10030, 0x00023863},
	{0x10030, 0x00023C29},
	{0x10030, 0x00024023},
	{0x10030, 0x0002441D},
	{0x10030, 0x000281EF},
	{0x10030, 0x000285AF},
	{0x10030, 0x000289A9},
	{0x10030, 0x00028DA3},
	{0x10030, 0x0002919D},
	{0x10030, 0x00029563},
	{0x10030, 0x0002995D},
	{0x10030, 0x00029D25},
	{0x10030, 0x0002A11F},
	{0x10030, 0x0002A4E7},
	{0x10030, 0x0002A8E1},
	{0x10030, 0x0002ACA7},
	{0x10030, 0x0002B0A1},
	{0x10030, 0x0002B467},
	{0x10030, 0x0002B861},
	{0x10030, 0x0002BC27},
	{0x10030, 0x0002C021},
	{0x10030, 0x0002C41B},
	{0x10030, 0x000301EF},
	{0x10030, 0x000305AF},
	{0x10030, 0x000309A9},
	{0x10030, 0x00030DA3},
	{0x10030, 0x0003119D},
	{0x10030, 0x00031563},
	{0x10030, 0x0003195D},
	{0x10030, 0x00031D25},
	{0x10030, 0x0003211F},
	{0x10030, 0x000324E7},
	{0x10030, 0x000328E1},
	{0x10030, 0x00032CA7},
	{0x10030, 0x000330A1},
	{0x10030, 0x00033467},
	{0x10030, 0x00033861},
	{0x10030, 0x00033C27},
	{0x10030, 0x00034021},
	{0x10030, 0x0003441B},
	{0x10030, 0x000601EB},
	{0x10030, 0x000605AB},
	{0x10030, 0x000609A5},
	{0x10030, 0x00060D9F},
	{0x10030, 0x00061199},
	{0x10030, 0x00061593},
	{0x10030, 0x00061959},
	{0x10030, 0x00061D53},
	{0x10030, 0x0006211B},
	{0x10030, 0x00062515},
	{0x10030, 0x000628DD},
	{0x10030, 0x00062CD7},
	{0x10030, 0x0006309D},
	{0x10030, 0x00063497},
	{0x10030, 0x0006385D},
	{0x10030, 0x00063C57},
	{0x10030, 0x0006401D},
	{0x10030, 0x00064417},
	{0x10030, 0x000681E7},
	{0x10030, 0x000685A7},
	{0x10030, 0x000689A1},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955F},
	{0x10030, 0x00069959},
	{0x10030, 0x00069D21},
	{0x10030, 0x0006A11B},
	{0x10030, 0x0006A4E3},
	{0x10030, 0x0006A8DD},
	{0x10030, 0x0006ACA5},
	{0x10030, 0x0006B09F},
	{0x10030, 0x0006B465},
	{0x10030, 0x0006B85F},
	{0x10030, 0x0006BC25},
	{0x10030, 0x0006C01F},
	{0x10030, 0x0006C419},
	{0x10030, 0x000701E7},
	{0x10030, 0x000705A7},
	{0x10030, 0x000709A1},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071955},
	{0x10030, 0x00071D1D},
	{0x10030, 0x00072117},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072CA1},
	{0x10030, 0x0007309B},
	{0x10030, 0x00073461},
	{0x10030, 0x0007385B},
	{0x10030, 0x00073C21},
	{0x10030, 0x0007401B},
	{0x10030, 0x0007441B},
	{0x10030, 0x000781EF},
	{0x10030, 0x000785E9},
	{0x10030, 0x000789E3},
	{0x10030, 0x00078DA3},
	{0x10030, 0x00079161},
	{0x10030, 0x0007955B},
	{0x10030, 0x00079921},
	{0x10030, 0x00079D1B},
	{0x10030, 0x0007A0E1},
	{0x10030, 0x0007A4DB},
	{0x10030, 0x0007A8A1},
	{0x10030, 0x0007AC9B},
	{0x10030, 0x0007B061},
	{0x10030, 0x0007B45B},
	{0x10030, 0x0007B821},
	{0x10030, 0x0007BC1B},
	{0x10030, 0x0007C015},
	{0x10030, 0x0007C40F},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000001EF},
	{0x10030, 0x000005E9},
	{0x10030, 0x000009E3},
	{0x10030, 0x00000DDD},
	{0x10030, 0x000011D7},
	{0x10030, 0x0000159F},
	{0x10030, 0x00001999},
	{0x10030, 0x00001D5F},
	{0x10030, 0x00002159},
	{0x10030, 0x0000251F},
	{0x10030, 0x00002919},
	{0x10030, 0x00002CDF},
	{0x10030, 0x000030D9},
	{0x10030, 0x0000349F},
	{0x10030, 0x00003899},
	{0x10030, 0x00003C5F},
	{0x10030, 0x00004059},
	{0x10030, 0x00004453},
	{0x10030, 0x000201ED},
	{0x10030, 0x000205AD},
	{0x10030, 0x000209A7},
	{0x10030, 0x00020DA1},
	{0x10030, 0x0002119B},
	{0x10030, 0x00021561},
	{0x10030, 0x0002195B},
	{0x10030, 0x00021D27},
	{0x10030, 0x00022121},
	{0x10030, 0x000224E9},
	{0x10030, 0x000228E3},
	{0x10030, 0x00022CA9},
	{0x10030, 0x000230A3},
	{0x10030, 0x00023469},
	{0x10030, 0x00023863},
	{0x10030, 0x00023C29},
	{0x10030, 0x00024023},
	{0x10030, 0x0002441D},
	{0x10030, 0x000281EF},
	{0x10030, 0x000285AF},
	{0x10030, 0x000289A9},
	{0x10030, 0x00028DA3},
	{0x10030, 0x0002919D},
	{0x10030, 0x00029563},
	{0x10030, 0x0002995D},
	{0x10030, 0x00029D25},
	{0x10030, 0x0002A11F},
	{0x10030, 0x0002A4E7},
	{0x10030, 0x0002A8E1},
	{0x10030, 0x0002ACA7},
	{0x10030, 0x0002B0A1},
	{0x10030, 0x0002B467},
	{0x10030, 0x0002B861},
	{0x10030, 0x0002BC27},
	{0x10030, 0x0002C021},
	{0x10030, 0x0002C41B},
	{0x10030, 0x000301EF},
	{0x10030, 0x000305AF},
	{0x10030, 0x000309A9},
	{0x10030, 0x00030DA3},
	{0x10030, 0x0003119D},
	{0x10030, 0x00031563},
	{0x10030, 0x0003195D},
	{0x10030, 0x00031D25},
	{0x10030, 0x0003211F},
	{0x10030, 0x000324E7},
	{0x10030, 0x000328E1},
	{0x10030, 0x00032CA7},
	{0x10030, 0x000330A1},
	{0x10030, 0x00033467},
	{0x10030, 0x00033861},
	{0x10030, 0x00033C27},
	{0x10030, 0x00034021},
	{0x10030, 0x0003441B},
	{0x10030, 0x000601EB},
	{0x10030, 0x000605AB},
	{0x10030, 0x000609A5},
	{0x10030, 0x00060D9F},
	{0x10030, 0x00061199},
	{0x10030, 0x00061593},
	{0x10030, 0x00061959},
	{0x10030, 0x00061D53},
	{0x10030, 0x0006211B},
	{0x10030, 0x00062515},
	{0x10030, 0x000628DD},
	{0x10030, 0x00062CD7},
	{0x10030, 0x0006309D},
	{0x10030, 0x00063497},
	{0x10030, 0x0006385D},
	{0x10030, 0x00063C57},
	{0x10030, 0x0006401D},
	{0x10030, 0x00064417},
	{0x10030, 0x000681E7},
	{0x10030, 0x000685A7},
	{0x10030, 0x000689A1},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955F},
	{0x10030, 0x00069959},
	{0x10030, 0x00069D21},
	{0x10030, 0x0006A11B},
	{0x10030, 0x0006A4E3},
	{0x10030, 0x0006A8DD},
	{0x10030, 0x0006ACA5},
	{0x10030, 0x0006B09F},
	{0x10030, 0x0006B465},
	{0x10030, 0x0006B85F},
	{0x10030, 0x0006BC25},
	{0x10030, 0x0006C01F},
	{0x10030, 0x0006C419},
	{0x10030, 0x000701E7},
	{0x10030, 0x000705A7},
	{0x10030, 0x000709A1},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071955},
	{0x10030, 0x00071D1D},
	{0x10030, 0x00072117},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072CA1},
	{0x10030, 0x0007309B},
	{0x10030, 0x00073461},
	{0x10030, 0x0007385B},
	{0x10030, 0x00073C21},
	{0x10030, 0x0007401B},
	{0x10030, 0x0007441B},
	{0x10030, 0x000781EF},
	{0x10030, 0x000785E9},
	{0x10030, 0x000789E3},
	{0x10030, 0x00078DA3},
	{0x10030, 0x00079161},
	{0x10030, 0x0007955B},
	{0x10030, 0x00079921},
	{0x10030, 0x00079D1B},
	{0x10030, 0x0007A0E1},
	{0x10030, 0x0007A4DB},
	{0x10030, 0x0007A8A1},
	{0x10030, 0x0007AC9B},
	{0x10030, 0x0007B061},
	{0x10030, 0x0007B45B},
	{0x10030, 0x0007B821},
	{0x10030, 0x0007BC1B},
	{0x10030, 0x0007C015},
	{0x10030, 0x0007C40F},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0xA0000000, 0x00000000},
	{0x10030, 0x000001EF},
	{0x10030, 0x000005E9},
	{0x10030, 0x000009E3},
	{0x10030, 0x00000DDD},
	{0x10030, 0x000011D7},
	{0x10030, 0x0000159F},
	{0x10030, 0x00001999},
	{0x10030, 0x00001D5F},
	{0x10030, 0x00002159},
	{0x10030, 0x0000251F},
	{0x10030, 0x00002919},
	{0x10030, 0x00002CDF},
	{0x10030, 0x000030D9},
	{0x10030, 0x0000349F},
	{0x10030, 0x00003899},
	{0x10030, 0x00003C5F},
	{0x10030, 0x00004059},
	{0x10030, 0x00004453},
	{0x10030, 0x000201ED},
	{0x10030, 0x000205AD},
	{0x10030, 0x000209A7},
	{0x10030, 0x00020DA1},
	{0x10030, 0x0002119B},
	{0x10030, 0x00021561},
	{0x10030, 0x0002195B},
	{0x10030, 0x00021D27},
	{0x10030, 0x00022121},
	{0x10030, 0x000224E9},
	{0x10030, 0x000228E3},
	{0x10030, 0x00022CA9},
	{0x10030, 0x000230A3},
	{0x10030, 0x00023469},
	{0x10030, 0x00023863},
	{0x10030, 0x00023C29},
	{0x10030, 0x00024023},
	{0x10030, 0x0002441D},
	{0x10030, 0x000281EF},
	{0x10030, 0x000285AF},
	{0x10030, 0x000289A9},
	{0x10030, 0x00028DA3},
	{0x10030, 0x0002919D},
	{0x10030, 0x00029563},
	{0x10030, 0x0002995D},
	{0x10030, 0x00029D25},
	{0x10030, 0x0002A11F},
	{0x10030, 0x0002A4E7},
	{0x10030, 0x0002A8E1},
	{0x10030, 0x0002ACA7},
	{0x10030, 0x0002B0A1},
	{0x10030, 0x0002B467},
	{0x10030, 0x0002B861},
	{0x10030, 0x0002BC27},
	{0x10030, 0x0002C021},
	{0x10030, 0x0002C41B},
	{0x10030, 0x000301EF},
	{0x10030, 0x000305AF},
	{0x10030, 0x000309A9},
	{0x10030, 0x00030DA3},
	{0x10030, 0x0003119D},
	{0x10030, 0x00031563},
	{0x10030, 0x0003195D},
	{0x10030, 0x00031D25},
	{0x10030, 0x0003211F},
	{0x10030, 0x000324E7},
	{0x10030, 0x000328E1},
	{0x10030, 0x00032CA7},
	{0x10030, 0x000330A1},
	{0x10030, 0x00033467},
	{0x10030, 0x00033861},
	{0x10030, 0x00033C27},
	{0x10030, 0x00034021},
	{0x10030, 0x0003441B},
	{0x10030, 0x000601EB},
	{0x10030, 0x000605AB},
	{0x10030, 0x000609A5},
	{0x10030, 0x00060D9F},
	{0x10030, 0x00061199},
	{0x10030, 0x00061593},
	{0x10030, 0x00061959},
	{0x10030, 0x00061D53},
	{0x10030, 0x0006211B},
	{0x10030, 0x00062515},
	{0x10030, 0x000628DD},
	{0x10030, 0x00062CD7},
	{0x10030, 0x0006309D},
	{0x10030, 0x00063497},
	{0x10030, 0x0006385D},
	{0x10030, 0x00063C57},
	{0x10030, 0x0006401D},
	{0x10030, 0x00064417},
	{0x10030, 0x000681E7},
	{0x10030, 0x000685A7},
	{0x10030, 0x000689A1},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955F},
	{0x10030, 0x00069959},
	{0x10030, 0x00069D21},
	{0x10030, 0x0006A11B},
	{0x10030, 0x0006A4E3},
	{0x10030, 0x0006A8DD},
	{0x10030, 0x0006ACA5},
	{0x10030, 0x0006B09F},
	{0x10030, 0x0006B465},
	{0x10030, 0x0006B85F},
	{0x10030, 0x0006BC25},
	{0x10030, 0x0006C01F},
	{0x10030, 0x0006C419},
	{0x10030, 0x000701E7},
	{0x10030, 0x000705A7},
	{0x10030, 0x000709A1},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071955},
	{0x10030, 0x00071D1D},
	{0x10030, 0x00072117},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072CA1},
	{0x10030, 0x0007309B},
	{0x10030, 0x00073461},
	{0x10030, 0x0007385B},
	{0x10030, 0x00073C21},
	{0x10030, 0x0007401B},
	{0x10030, 0x0007441B},
	{0x10030, 0x000781E9},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0xB0000000, 0x00000000},
	{0x100EE, 0x00000000},
	{0x100EE, 0x00002000},
	{0x10030, 0x000000FC},
	{0x10030, 0x000004F9},
	{0x10030, 0x000008F6},
	{0x10030, 0x00000CF3},
	{0x10030, 0x000010F0},
	{0x10030, 0x000014ED},
	{0x10030, 0x000018AC},
	{0x10030, 0x00001CA9},
	{0x10030, 0x00002069},
	{0x10030, 0x00002466},
	{0x10030, 0x00002829},
	{0x10030, 0x00002C26},
	{0x10030, 0x00003023},
	{0x10030, 0x00003420},
	{0x10030, 0x0000381D},
	{0x10030, 0x00003C1A},
	{0x10030, 0x00004017},
	{0x100EE, 0x00000000},
	{0x100EE, 0x00002000},
	{0x10030, 0x000780F4},
	{0x10030, 0x000784F1},
	{0x10030, 0x000788EE},
	{0x10030, 0x00078CEB},
	{0x10030, 0x000790E8},
	{0x10030, 0x000794E5},
	{0x10030, 0x000798E2},
	{0x10030, 0x00079CDF},
	{0x10030, 0x0007A0DC},
	{0x10030, 0x0007A4D9},
	{0x10030, 0x0007A8D6},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B0D0},
	{0x10030, 0x0007B4CD},
	{0x10030, 0x0007B8CA},
	{0x10030, 0x0007BC07},
	{0x10030, 0x0007C004},
	{0x100EE, 0x00000000},
	{0x0EF, 0x00002000},
	{0x033, 0x00000008},
	{0x03F, 0x00000004},
	{0x033, 0x00000009},
	{0x03F, 0x00000003},
	{0x033, 0x0000000A},
	{0x03F, 0x00000003},
	{0x033, 0x0000000B},
	{0x03F, 0x00000002},
	{0x033, 0x0000000C},
	{0x03F, 0x00000002},
	{0x033, 0x0000000D},
	{0x03F, 0x00000002},
	{0x033, 0x0000000E},
	{0x03F, 0x00000002},
	{0x033, 0x0000000F},
	{0x03F, 0x00000002},
	{0x0EF, 0x00000000},
	{0x0EB, 0x00040000},
	{0x030, 0x000109B7},
	{0x0EB, 0x00000000},
	{0x0EF, 0x00008000},
	{0x033, 0x00000020},
	{0x03F, 0x00050002},
	{0x033, 0x00000021},
	{0x03F, 0x00060032},
	{0x033, 0x00000022},
	{0x03F, 0x00050042},
	{0x033, 0x00000023},
	{0x03F, 0x00040042},
	{0x033, 0x00000024},
	{0x03F, 0x00008001},
	{0x033, 0x00000025},
	{0x03F, 0x00008002},
	{0x033, 0x00000026},
	{0x03F, 0x00000003},
	{0x033, 0x00000027},
	{0x03F, 0x00000003},
	{0x033, 0x00000028},
	{0x03F, 0x00050002},
	{0x033, 0x00000029},
	{0x03F, 0x00060032},
	{0x033, 0x0000002A},
	{0x03F, 0x00050042},
	{0x033, 0x0000002B},
	{0x03F, 0x00040042},
	{0x033, 0x0000002C},
	{0x03F, 0x00008001},
	{0x033, 0x0000002D},
	{0x03F, 0x00008002},
	{0x033, 0x0000002E},
	{0x03F, 0x00000003},
	{0x033, 0x0000002F},
	{0x03F, 0x00000003},
	{0x033, 0x00000030},
	{0x03F, 0x00050002},
	{0x033, 0x00000031},
	{0x03F, 0x00060032},
	{0x033, 0x00000032},
	{0x03F, 0x00050042},
	{0x033, 0x00000033},
	{0x03F, 0x00040042},
	{0x033, 0x00000034},
	{0x03F, 0x00008001},
	{0x033, 0x00000035},
	{0x03F, 0x00008002},
	{0x033, 0x00000036},
	{0x03F, 0x00000003},
	{0x033, 0x00000037},
	{0x03F, 0x00000003},
	{0x033, 0x00000060},
	{0x03F, 0x00050002},
	{0x033, 0x00000061},
	{0x03F, 0x00060032},
	{0x033, 0x00000062},
	{0x03F, 0x00050042},
	{0x033, 0x00000063},
	{0x03F, 0x00040042},
	{0x033, 0x00000064},
	{0x03F, 0x00008001},
	{0x033, 0x00000065},
	{0x03F, 0x00008002},
	{0x033, 0x00000066},
	{0x03F, 0x00000003},
	{0x033, 0x00000067},
	{0x03F, 0x00000003},
	{0x033, 0x00000068},
	{0x03F, 0x00050002},
	{0x033, 0x00000069},
	{0x03F, 0x00060032},
	{0x033, 0x0000006A},
	{0x03F, 0x00050042},
	{0x033, 0x0000006B},
	{0x03F, 0x00040042},
	{0x033, 0x0000006C},
	{0x03F, 0x00008001},
	{0x033, 0x0000006D},
	{0x03F, 0x00008002},
	{0x033, 0x0000006E},
	{0x03F, 0x00000003},
	{0x033, 0x0000006F},
	{0x03F, 0x00000003},
	{0x033, 0x00000070},
	{0x03F, 0x00050002},
	{0x033, 0x00000071},
	{0x03F, 0x00060032},
	{0x033, 0x00000072},
	{0x03F, 0x00050042},
	{0x033, 0x00000073},
	{0x03F, 0x00040042},
	{0x033, 0x00000074},
	{0x03F, 0x00008001},
	{0x033, 0x00000075},
	{0x03F, 0x00008002},
	{0x033, 0x00000076},
	{0x03F, 0x00000003},
	{0x033, 0x00000077},
	{0x03F, 0x00000003},
	{0x033, 0x00000078},
	{0x03F, 0x00050002},
	{0x033, 0x00000079},
	{0x03F, 0x00060032},
	{0x033, 0x0000007A},
	{0x03F, 0x00050042},
	{0x033, 0x0000007B},
	{0x03F, 0x00040042},
	{0x033, 0x0000007C},
	{0x03F, 0x00008001},
	{0x033, 0x0000007D},
	{0x03F, 0x00008002},
	{0x033, 0x0000007E},
	{0x03F, 0x00000003},
	{0x033, 0x0000007F},
	{0x03F, 0x00000003},
	{0x033, 0x000000A0},
	{0x03F, 0x00050002},
	{0x033, 0x000000A1},
	{0x03F, 0x00060032},
	{0x033, 0x000000A2},
	{0x03F, 0x00050042},
	{0x033, 0x000000A3},
	{0x03F, 0x00040042},
	{0x033, 0x000000A4},
	{0x03F, 0x00008001},
	{0x033, 0x000000A5},
	{0x03F, 0x00008002},
	{0x033, 0x000000A6},
	{0x03F, 0x00000003},
	{0x033, 0x000000A7},
	{0x03F, 0x00000003},
	{0x033, 0x000000A8},
	{0x03F, 0x00050002},
	{0x033, 0x000000A9},
	{0x03F, 0x00060032},
	{0x033, 0x000000AA},
	{0x03F, 0x00050042},
	{0x033, 0x000000AB},
	{0x03F, 0x00040042},
	{0x033, 0x000000AC},
	{0x03F, 0x00008001},
	{0x033, 0x000000AD},
	{0x03F, 0x00008002},
	{0x033, 0x000000AE},
	{0x03F, 0x00000003},
	{0x033, 0x000000AF},
	{0x03F, 0x00000003},
	{0x033, 0x000000B0},
	{0x03F, 0x00050002},
	{0x033, 0x000000B1},
	{0x03F, 0x00060032},
	{0x033, 0x000000B2},
	{0x03F, 0x00050042},
	{0x033, 0x000000B3},
	{0x03F, 0x00040042},
	{0x033, 0x000000B4},
	{0x03F, 0x00008001},
	{0x033, 0x000000B5},
	{0x03F, 0x00008002},
	{0x033, 0x000000B6},
	{0x03F, 0x00000003},
	{0x033, 0x000000B7},
	{0x03F, 0x00000003},
	{0x033, 0x000000E0},
	{0x03F, 0x00050002},
	{0x033, 0x000000E1},
	{0x03F, 0x00060032},
	{0x033, 0x000000E2},
	{0x03F, 0x00050042},
	{0x033, 0x000000E3},
	{0x03F, 0x00040042},
	{0x033, 0x000000E4},
	{0x03F, 0x00008001},
	{0x033, 0x000000E5},
	{0x03F, 0x00008002},
	{0x033, 0x000000E6},
	{0x03F, 0x00000003},
	{0x033, 0x000000E7},
	{0x03F, 0x00000003},
	{0x033, 0x000000E8},
	{0x03F, 0x00050002},
	{0x033, 0x000000E9},
	{0x03F, 0x00060032},
	{0x033, 0x000000EA},
	{0x03F, 0x00050042},
	{0x033, 0x000000EB},
	{0x03F, 0x00040042},
	{0x033, 0x000000EC},
	{0x03F, 0x00008001},
	{0x033, 0x000000ED},
	{0x03F, 0x00008002},
	{0x033, 0x000000EE},
	{0x03F, 0x00000003},
	{0x033, 0x000000EF},
	{0x03F, 0x00000003},
	{0x033, 0x000000F0},
	{0x03F, 0x00050002},
	{0x033, 0x000000F1},
	{0x03F, 0x00060032},
	{0x033, 0x000000F2},
	{0x03F, 0x00050042},
	{0x033, 0x000000F3},
	{0x03F, 0x00040042},
	{0x033, 0x000000F4},
	{0x03F, 0x00008001},
	{0x033, 0x000000F5},
	{0x03F, 0x00008002},
	{0x033, 0x000000F6},
	{0x03F, 0x00000003},
	{0x033, 0x000000F7},
	{0x03F, 0x00000003},
	{0x033, 0x000000F8},
	{0x03F, 0x00050002},
	{0x033, 0x000000F9},
	{0x03F, 0x00060032},
	{0x033, 0x000000FA},
	{0x03F, 0x00050042},
	{0x033, 0x000000FB},
	{0x03F, 0x00040042},
	{0x033, 0x000000FC},
	{0x03F, 0x00008001},
	{0x033, 0x000000FD},
	{0x03F, 0x00008002},
	{0x033, 0x000000FE},
	{0x03F, 0x00000003},
	{0x033, 0x000000FF},
	{0x03F, 0x00000003},
	{0x033, 0x00000120},
	{0x03F, 0x00050002},
	{0x033, 0x00000121},
	{0x03F, 0x00060032},
	{0x033, 0x00000122},
	{0x03F, 0x00050042},
	{0x033, 0x00000123},
	{0x03F, 0x00040042},
	{0x033, 0x00000124},
	{0x03F, 0x00008001},
	{0x033, 0x00000125},
	{0x03F, 0x00008002},
	{0x033, 0x00000126},
	{0x03F, 0x00000003},
	{0x033, 0x00000127},
	{0x03F, 0x00000003},
	{0x033, 0x00000128},
	{0x03F, 0x00050002},
	{0x033, 0x00000129},
	{0x03F, 0x00060032},
	{0x033, 0x0000012A},
	{0x03F, 0x00050042},
	{0x033, 0x0000012B},
	{0x03F, 0x00040042},
	{0x033, 0x0000012C},
	{0x03F, 0x00008001},
	{0x033, 0x0000012D},
	{0x03F, 0x00008002},
	{0x033, 0x0000012E},
	{0x03F, 0x00000003},
	{0x033, 0x0000012F},
	{0x03F, 0x00000003},
	{0x033, 0x00000130},
	{0x03F, 0x00050002},
	{0x033, 0x00000131},
	{0x03F, 0x00060032},
	{0x033, 0x00000132},
	{0x03F, 0x00050042},
	{0x033, 0x00000133},
	{0x03F, 0x00040042},
	{0x033, 0x00000134},
	{0x03F, 0x00008001},
	{0x033, 0x00000135},
	{0x03F, 0x00008002},
	{0x033, 0x00000136},
	{0x03F, 0x00000003},
	{0x033, 0x00000137},
	{0x03F, 0x00000003},
	{0x033, 0x00000160},
	{0x03F, 0x00050002},
	{0x033, 0x00000161},
	{0x03F, 0x00060032},
	{0x033, 0x00000162},
	{0x03F, 0x00050042},
	{0x033, 0x00000163},
	{0x03F, 0x00040042},
	{0x033, 0x00000164},
	{0x03F, 0x00008001},
	{0x033, 0x00000165},
	{0x03F, 0x00008002},
	{0x033, 0x00000166},
	{0x03F, 0x00000003},
	{0x033, 0x00000167},
	{0x03F, 0x00000003},
	{0x033, 0x00000168},
	{0x03F, 0x00050002},
	{0x033, 0x00000169},
	{0x03F, 0x00060032},
	{0x033, 0x0000016A},
	{0x03F, 0x00050042},
	{0x033, 0x0000016B},
	{0x03F, 0x00040042},
	{0x033, 0x0000016C},
	{0x03F, 0x00008001},
	{0x033, 0x0000016D},
	{0x03F, 0x00008002},
	{0x033, 0x0000016E},
	{0x03F, 0x00000003},
	{0x033, 0x0000016F},
	{0x03F, 0x00000003},
	{0x033, 0x00000170},
	{0x03F, 0x00050002},
	{0x033, 0x00000171},
	{0x03F, 0x00060032},
	{0x033, 0x00000172},
	{0x03F, 0x00050042},
	{0x033, 0x00000173},
	{0x03F, 0x00040042},
	{0x033, 0x00000174},
	{0x03F, 0x00008001},
	{0x033, 0x00000175},
	{0x03F, 0x00008002},
	{0x033, 0x00000176},
	{0x03F, 0x00000003},
	{0x033, 0x00000177},
	{0x03F, 0x00000003},
	{0x033, 0x00000178},
	{0x03F, 0x00050002},
	{0x033, 0x00000179},
	{0x03F, 0x00060032},
	{0x033, 0x0000017A},
	{0x03F, 0x00050042},
	{0x033, 0x0000017B},
	{0x03F, 0x00040042},
	{0x033, 0x0000017C},
	{0x03F, 0x00008001},
	{0x033, 0x0000017D},
	{0x03F, 0x00008002},
	{0x033, 0x0000017E},
	{0x03F, 0x00000003},
	{0x033, 0x0000017F},
	{0x03F, 0x00000003},
	{0x033, 0x000001A0},
	{0x03F, 0x00050002},
	{0x033, 0x000001A1},
	{0x03F, 0x00060032},
	{0x033, 0x000001A2},
	{0x03F, 0x00050042},
	{0x033, 0x000001A3},
	{0x03F, 0x00040042},
	{0x033, 0x000001A4},
	{0x03F, 0x00008001},
	{0x033, 0x000001A5},
	{0x03F, 0x00008002},
	{0x033, 0x000001A6},
	{0x03F, 0x00000003},
	{0x033, 0x000001A7},
	{0x03F, 0x00000003},
	{0x033, 0x000001A8},
	{0x03F, 0x00050002},
	{0x033, 0x000001A9},
	{0x03F, 0x00060032},
	{0x033, 0x000001AA},
	{0x03F, 0x00050042},
	{0x033, 0x000001AB},
	{0x03F, 0x00040042},
	{0x033, 0x000001AC},
	{0x03F, 0x00008001},
	{0x033, 0x000001AD},
	{0x03F, 0x00008002},
	{0x033, 0x000001AE},
	{0x03F, 0x00000003},
	{0x033, 0x000001AF},
	{0x03F, 0x00000003},
	{0x033, 0x000001B0},
	{0x03F, 0x00050002},
	{0x033, 0x000001B1},
	{0x03F, 0x00060032},
	{0x033, 0x000001B2},
	{0x03F, 0x00050042},
	{0x033, 0x000001B3},
	{0x03F, 0x00040042},
	{0x033, 0x000001B4},
	{0x03F, 0x00008001},
	{0x033, 0x000001B5},
	{0x03F, 0x00008002},
	{0x033, 0x000001B6},
	{0x03F, 0x00000003},
	{0x033, 0x000001B7},
	{0x03F, 0x00000003},
	{0x033, 0x000001E0},
	{0x03F, 0x00050002},
	{0x033, 0x000001E1},
	{0x03F, 0x00060032},
	{0x033, 0x000001E2},
	{0x03F, 0x00050042},
	{0x033, 0x000001E3},
	{0x03F, 0x00040042},
	{0x033, 0x000001E4},
	{0x03F, 0x00008001},
	{0x033, 0x000001E5},
	{0x03F, 0x00008002},
	{0x033, 0x000001E6},
	{0x03F, 0x00000003},
	{0x033, 0x000001E7},
	{0x03F, 0x00000003},
	{0x033, 0x000001E8},
	{0x03F, 0x00050002},
	{0x033, 0x000001E9},
	{0x03F, 0x00060032},
	{0x033, 0x000001EA},
	{0x03F, 0x00050042},
	{0x033, 0x000001EB},
	{0x03F, 0x00040042},
	{0x033, 0x000001EC},
	{0x03F, 0x00008001},
	{0x033, 0x000001ED},
	{0x03F, 0x00008002},
	{0x033, 0x000001EE},
	{0x03F, 0x00000003},
	{0x033, 0x000001EF},
	{0x03F, 0x00000003},
	{0x033, 0x000001F0},
	{0x03F, 0x00050002},
	{0x033, 0x000001F1},
	{0x03F, 0x00060032},
	{0x033, 0x000001F2},
	{0x03F, 0x00050042},
	{0x033, 0x000001F3},
	{0x03F, 0x00040042},
	{0x033, 0x000001F4},
	{0x03F, 0x00008001},
	{0x033, 0x000001F5},
	{0x03F, 0x00008002},
	{0x033, 0x000001F6},
	{0x03F, 0x00000003},
	{0x033, 0x000001F7},
	{0x03F, 0x00000003},
	{0x033, 0x000001F8},
	{0x03F, 0x00050002},
	{0x033, 0x000001F9},
	{0x03F, 0x00060032},
	{0x033, 0x000001FA},
	{0x03F, 0x00050042},
	{0x033, 0x000001FB},
	{0x03F, 0x00040042},
	{0x033, 0x000001FC},
	{0x03F, 0x00008001},
	{0x033, 0x000001FD},
	{0x03F, 0x00008002},
	{0x033, 0x000001FE},
	{0x03F, 0x00000003},
	{0x033, 0x000001FF},
	{0x03F, 0x00000003},
	{0x0EF, 0x00000000},
	{0x005, 0x00000001},
	{0x10005, 0x00000001},
	{0x100EE, 0x00000400},
	{0x10030, 0x00000000},
	{0x10030, 0x00001000},
	{0x10030, 0x00002000},
	{0x10030, 0x00003000},
	{0x10030, 0x00004000},
	{0x10030, 0x00005000},
	{0x10030, 0x00006003},
	{0x10030, 0x00007003},
	{0x10030, 0x00008000},
	{0x10030, 0x00009000},
	{0x10030, 0x0000A000},
	{0x10030, 0x0000B000},
	{0x10030, 0x0000C000},
	{0x10030, 0x0000D000},
	{0x10030, 0x0000E003},
	{0x10030, 0x0000F003},
	{0x10030, 0x00010000},
	{0x10030, 0x00011000},
	{0x10030, 0x00012000},
	{0x10030, 0x00013000},
	{0x10030, 0x00014000},
	{0x10030, 0x00015000},
	{0x10030, 0x00016003},
	{0x10030, 0x00017003},
	{0x10030, 0x00018000},
	{0x10030, 0x00019000},
	{0x10030, 0x0001A000},
	{0x10030, 0x0001B000},
	{0x10030, 0x0001C000},
	{0x10030, 0x0001D000},
	{0x10030, 0x0001E003},
	{0x10030, 0x0001F003},
	{0x10030, 0x00020000},
	{0x10030, 0x00021000},
	{0x10030, 0x00022000},
	{0x10030, 0x00023000},
	{0x10030, 0x00024000},
	{0x10030, 0x00025000},
	{0x10030, 0x00026003},
	{0x10030, 0x00027003},
	{0x10030, 0x00028000},
	{0x10030, 0x00029000},
	{0x10030, 0x0002A000},
	{0x10030, 0x0002B000},
	{0x10030, 0x0002C000},
	{0x10030, 0x0002D000},
	{0x10030, 0x0002E003},
	{0x10030, 0x0002F003},
	{0x10030, 0x00030000},
	{0x10030, 0x00031000},
	{0x10030, 0x00032000},
	{0x10030, 0x00033000},
	{0x10030, 0x00034000},
	{0x10030, 0x00035000},
	{0x10030, 0x00036003},
	{0x10030, 0x00037003},
	{0x10030, 0x00038000},
	{0x10030, 0x00039000},
	{0x10030, 0x0003A000},
	{0x10030, 0x0003B000},
	{0x10030, 0x0003C000},
	{0x10030, 0x0003D000},
	{0x10030, 0x0003E003},
	{0x10030, 0x0003F003},
	{0x10030, 0x00060000},
	{0x10030, 0x00061000},
	{0x10030, 0x00062000},
	{0x10030, 0x00063000},
	{0x10030, 0x00064000},
	{0x10030, 0x00065000},
	{0x10030, 0x00066000},
	{0x10030, 0x00067003},
	{0x10030, 0x00068000},
	{0x10030, 0x00069000},
	{0x10030, 0x0006A000},
	{0x10030, 0x0006B000},
	{0x10030, 0x0006C000},
	{0x10030, 0x0006D000},
	{0x10030, 0x0006E000},
	{0x10030, 0x0006F003},
	{0x10030, 0x00070000},
	{0x10030, 0x00071000},
	{0x10030, 0x00072000},
	{0x10030, 0x00073000},
	{0x10030, 0x00074000},
	{0x10030, 0x00075000},
	{0x10030, 0x00076000},
	{0x10030, 0x00077003},
	{0x10030, 0x00078000},
	{0x10030, 0x00079000},
	{0x10030, 0x0007A000},
	{0x10030, 0x0007B000},
	{0x10030, 0x0007C000},
	{0x10030, 0x0007D000},
	{0x10030, 0x0007E000},
	{0x10030, 0x0007F003},
	{0x100EE, 0x00000000},
	{0x0FE, 0x00000031},
};

static const struct rtw89_reg2_def rtw89_8852c_phy_radiob_regs[] = {
	{0xF0010000, 0x00000000},
	{0xF0020000, 0x00000001},
	{0xF0320000, 0x00000002},
	{0xF0330000, 0x00000003},
	{0xF0340000, 0x00000004},
	{0xF0350000, 0x00000005},
	{0xF0360000, 0x00000006},
	{0xF0010001, 0x00000007},
	{0xF0020001, 0x00000008},
	{0xF0320001, 0x00000009},
	{0xF0330001, 0x0000000A},
	{0xF0340001, 0x0000000B},
	{0xF0350001, 0x0000000C},
	{0xF0360001, 0x0000000D},
	{0xF03F0001, 0x0000000E},
	{0xF0400001, 0x0000000F},
	{0x005, 0x00000000},
	{0x10005, 0x00000000},
	{0x0B9, 0x00020440},
	{0x000, 0x00030001},
	{0x10000, 0x00030000},
	{0x018, 0x00011124},
	{0x10018, 0x00011124},
	{0x05F, 0x00000032},
	{0x097, 0x00043200},
	{0x0A6, 0x00066DB7},
	{0x0EF, 0x00004000},
	{0x033, 0x00000005},
	{0x03E, 0x00000000},
	{0x03F, 0x00010500},
	{0x033, 0x00000003},
	{0x03E, 0x00000000},
	{0x03F, 0x00028B00},
	{0x033, 0x00000002},
	{0x03E, 0x00000000},
	{0x03F, 0x0009AB00},
	{0x033, 0x0000000D},
	{0x03E, 0x00000000},
	{0x03F, 0x00010500},
	{0x033, 0x0000000B},
	{0x03E, 0x00000000},
	{0x03F, 0x00028B00},
	{0x033, 0x0000000A},
	{0x03E, 0x00000000},
	{0x03F, 0x0009AB00},
	{0x033, 0x00000015},
	{0x03E, 0x00000000},
	{0x03F, 0x00010500},
	{0x033, 0x00000013},
	{0x03E, 0x00000000},
	{0x03F, 0x00028B00},
	{0x033, 0x00000012},
	{0x03E, 0x00000000},
	{0x03F, 0x0009AB00},
	{0x0EF, 0x00000000},
	{0x000, 0x00033C01},
	{0x10000, 0x00033C00},
	{0x01A, 0x00040004},
	{0x0FE, 0x00000000},
	{0x096, 0x00015200},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0004D000},
	{0x0DA, 0x000D4009},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0004D000},
	{0x0DA, 0x000D4009},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0004D000},
	{0x0DA, 0x000D4009},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0004D000},
	{0x0DA, 0x000D4009},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0004D000},
	{0x0DA, 0x000D4009},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0004D000},
	{0x0DA, 0x000D4009},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0004D000},
	{0x0DA, 0x000D4009},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x067, 0x0000D300},
	{0x0DA, 0x000D4000},
	{0xA0000000, 0x00000000},
	{0x067, 0x0004D000},
	{0x0DA, 0x000D4009},
	{0xB0000000, 0x00000000},
	{0x057, 0x0000D589},
	{0x05A, 0x0007FFFF},
	{0x043, 0x00005000},
	{0x018, 0x00001001},
	{0x10018, 0x00001001},
	{0x002, 0x0000000D},
	{0x10002, 0x0000000D},
	{0x0EE, 0x00000000},
	{0x033, 0x0000000B},
	{0x03F, 0x0000000B},
	{0x033, 0x0000000C},
	{0x03F, 0x00000012},
	{0x033, 0x0000000D},
	{0x03F, 0x00000019},
	{0x0EE, 0x00000000},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1752},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1752},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1752},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1752},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1752},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1752},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1752},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x08F, 0x000D1352},
	{0xA0000000, 0x00000000},
	{0x08F, 0x000D1752},
	{0xB0000000, 0x00000000},
	{0x0EB, 0x00000000},
	{0x030, 0x000109B0},
	{0x030, 0x000189B0},
	{0x0EB, 0x00000000},
	{0x0EE, 0x00000010},
	{0x033, 0x00000006},
	{0x03F, 0x00000003},
	{0x033, 0x00000007},
	{0x03F, 0x00000003},
	{0x033, 0x00000008},
	{0x03F, 0x00000001},
	{0x0EE, 0x00000000},
	{0x0EF, 0x00001000},
	{0x033, 0x00000000},
	{0x03F, 0x00000015},
	{0x033, 0x00000001},
	{0x03F, 0x00000017},
	{0x0EF, 0x00000000},
	{0x0EF, 0x00008000},
	{0x033, 0x00000020},
	{0x03F, 0x00060001},
	{0x033, 0x00000021},
	{0x03F, 0x00060032},
	{0x033, 0x00000022},
	{0x03F, 0x00050042},
	{0x033, 0x00000023},
	{0x03F, 0x00040042},
	{0x033, 0x00000024},
	{0x03F, 0x00000001},
	{0x033, 0x00000025},
	{0x03F, 0x00000002},
	{0x033, 0x00000026},
	{0x03F, 0x00000003},
	{0x033, 0x00000027},
	{0x03F, 0x00000003},
	{0x033, 0x00000028},
	{0x03F, 0x00060001},
	{0x033, 0x00000029},
	{0x03F, 0x00060032},
	{0x033, 0x0000002A},
	{0x03F, 0x00050042},
	{0x033, 0x0000002B},
	{0x03F, 0x00040042},
	{0x033, 0x0000002C},
	{0x03F, 0x00000001},
	{0x033, 0x0000002D},
	{0x03F, 0x00000002},
	{0x033, 0x0000002E},
	{0x03F, 0x00000003},
	{0x033, 0x0000002F},
	{0x03F, 0x00000003},
	{0x033, 0x00000030},
	{0x03F, 0x00060001},
	{0x033, 0x00000031},
	{0x03F, 0x00060032},
	{0x033, 0x00000032},
	{0x03F, 0x00050042},
	{0x033, 0x00000033},
	{0x03F, 0x00040042},
	{0x033, 0x00000034},
	{0x03F, 0x00000001},
	{0x033, 0x00000035},
	{0x03F, 0x00000002},
	{0x033, 0x00000036},
	{0x03F, 0x00000003},
	{0x033, 0x00000037},
	{0x03F, 0x00000003},
	{0x033, 0x00000060},
	{0x03F, 0x00060001},
	{0x033, 0x00000061},
	{0x03F, 0x00060032},
	{0x033, 0x00000062},
	{0x03F, 0x00050042},
	{0x033, 0x00000063},
	{0x03F, 0x00040042},
	{0x033, 0x00000064},
	{0x03F, 0x00000001},
	{0x033, 0x00000065},
	{0x03F, 0x00000002},
	{0x033, 0x00000066},
	{0x03F, 0x00000003},
	{0x033, 0x00000067},
	{0x03F, 0x00000003},
	{0x033, 0x00000068},
	{0x03F, 0x00060001},
	{0x033, 0x00000069},
	{0x03F, 0x00060032},
	{0x033, 0x0000006A},
	{0x03F, 0x00050042},
	{0x033, 0x0000006B},
	{0x03F, 0x00040042},
	{0x033, 0x0000006C},
	{0x03F, 0x00000001},
	{0x033, 0x0000006D},
	{0x03F, 0x00000002},
	{0x033, 0x0000006E},
	{0x03F, 0x00000003},
	{0x033, 0x0000006F},
	{0x03F, 0x00000003},
	{0x033, 0x00000070},
	{0x03F, 0x00060001},
	{0x033, 0x00000071},
	{0x03F, 0x00060032},
	{0x033, 0x00000072},
	{0x03F, 0x00050042},
	{0x033, 0x00000073},
	{0x03F, 0x00040042},
	{0x033, 0x00000074},
	{0x03F, 0x00000001},
	{0x033, 0x00000075},
	{0x03F, 0x00000002},
	{0x033, 0x00000076},
	{0x03F, 0x00000003},
	{0x033, 0x00000077},
	{0x03F, 0x00000003},
	{0x033, 0x00000078},
	{0x03F, 0x00060001},
	{0x033, 0x00000079},
	{0x03F, 0x00060032},
	{0x033, 0x0000007A},
	{0x03F, 0x00050042},
	{0x033, 0x0000007B},
	{0x03F, 0x00040042},
	{0x033, 0x0000007C},
	{0x03F, 0x00000001},
	{0x033, 0x0000007D},
	{0x03F, 0x00000002},
	{0x033, 0x0000007E},
	{0x03F, 0x00000003},
	{0x033, 0x0000007F},
	{0x03F, 0x00000003},
	{0x033, 0x000000A0},
	{0x03F, 0x00060001},
	{0x033, 0x000000A1},
	{0x03F, 0x00060032},
	{0x033, 0x000000A2},
	{0x03F, 0x00050042},
	{0x033, 0x000000A3},
	{0x03F, 0x00040042},
	{0x033, 0x000000A4},
	{0x03F, 0x00000001},
	{0x033, 0x000000A5},
	{0x03F, 0x00000002},
	{0x033, 0x000000A6},
	{0x03F, 0x00000003},
	{0x033, 0x000000A7},
	{0x03F, 0x00000003},
	{0x033, 0x000000A8},
	{0x03F, 0x00060001},
	{0x033, 0x000000A9},
	{0x03F, 0x00060032},
	{0x033, 0x000000AA},
	{0x03F, 0x00050042},
	{0x033, 0x000000AB},
	{0x03F, 0x00040042},
	{0x033, 0x000000AC},
	{0x03F, 0x00000001},
	{0x033, 0x000000AD},
	{0x03F, 0x00000002},
	{0x033, 0x000000AE},
	{0x03F, 0x00000003},
	{0x033, 0x000000AF},
	{0x03F, 0x00000003},
	{0x033, 0x000000B0},
	{0x03F, 0x00060001},
	{0x033, 0x000000B1},
	{0x03F, 0x00060032},
	{0x033, 0x000000B2},
	{0x03F, 0x00050042},
	{0x033, 0x000000B3},
	{0x03F, 0x00040042},
	{0x033, 0x000000B4},
	{0x03F, 0x00000001},
	{0x033, 0x000000B5},
	{0x03F, 0x00000002},
	{0x033, 0x000000B6},
	{0x03F, 0x00000003},
	{0x033, 0x000000B7},
	{0x03F, 0x00000003},
	{0x033, 0x000000E0},
	{0x03F, 0x00060001},
	{0x033, 0x000000E1},
	{0x03F, 0x00060032},
	{0x033, 0x000000E2},
	{0x03F, 0x00050042},
	{0x033, 0x000000E3},
	{0x03F, 0x00040042},
	{0x033, 0x000000E4},
	{0x03F, 0x00000001},
	{0x033, 0x000000E5},
	{0x03F, 0x00000002},
	{0x033, 0x000000E6},
	{0x03F, 0x00000003},
	{0x033, 0x000000E7},
	{0x03F, 0x00000003},
	{0x033, 0x000000E8},
	{0x03F, 0x00060001},
	{0x033, 0x000000E9},
	{0x03F, 0x00060032},
	{0x033, 0x000000EA},
	{0x03F, 0x00050042},
	{0x033, 0x000000EB},
	{0x03F, 0x00040042},
	{0x033, 0x000000EC},
	{0x03F, 0x00000001},
	{0x033, 0x000000ED},
	{0x03F, 0x00000002},
	{0x033, 0x000000EE},
	{0x03F, 0x00000003},
	{0x033, 0x000000EF},
	{0x03F, 0x00000003},
	{0x033, 0x000000F0},
	{0x03F, 0x00060001},
	{0x033, 0x000000F1},
	{0x03F, 0x00060032},
	{0x033, 0x000000F2},
	{0x03F, 0x00050042},
	{0x033, 0x000000F3},
	{0x03F, 0x00040042},
	{0x033, 0x000000F4},
	{0x03F, 0x00000001},
	{0x033, 0x000000F5},
	{0x03F, 0x00000002},
	{0x033, 0x000000F6},
	{0x03F, 0x00000003},
	{0x033, 0x000000F7},
	{0x03F, 0x00000003},
	{0x033, 0x000000F8},
	{0x03F, 0x00060001},
	{0x033, 0x000000F9},
	{0x03F, 0x00060032},
	{0x033, 0x000000FA},
	{0x03F, 0x00050042},
	{0x033, 0x000000FB},
	{0x03F, 0x00040042},
	{0x033, 0x000000FC},
	{0x03F, 0x00000001},
	{0x033, 0x000000FD},
	{0x03F, 0x00000002},
	{0x033, 0x000000FE},
	{0x03F, 0x00000003},
	{0x033, 0x000000FF},
	{0x03F, 0x00000003},
	{0x033, 0x00000120},
	{0x03F, 0x00060001},
	{0x033, 0x00000121},
	{0x03F, 0x00060032},
	{0x033, 0x00000122},
	{0x03F, 0x00050042},
	{0x033, 0x00000123},
	{0x03F, 0x00040042},
	{0x033, 0x00000124},
	{0x03F, 0x00000001},
	{0x033, 0x00000125},
	{0x03F, 0x00000002},
	{0x033, 0x00000126},
	{0x03F, 0x00000003},
	{0x033, 0x00000127},
	{0x03F, 0x00000003},
	{0x033, 0x00000128},
	{0x03F, 0x00060001},
	{0x033, 0x00000129},
	{0x03F, 0x00060032},
	{0x033, 0x0000012A},
	{0x03F, 0x00050042},
	{0x033, 0x0000012B},
	{0x03F, 0x00040042},
	{0x033, 0x0000012C},
	{0x03F, 0x00000001},
	{0x033, 0x0000012D},
	{0x03F, 0x00000002},
	{0x033, 0x0000012E},
	{0x03F, 0x00000003},
	{0x033, 0x0000012F},
	{0x03F, 0x00000003},
	{0x033, 0x00000130},
	{0x03F, 0x00060001},
	{0x033, 0x00000131},
	{0x03F, 0x00060032},
	{0x033, 0x00000132},
	{0x03F, 0x00050042},
	{0x033, 0x00000133},
	{0x03F, 0x00040042},
	{0x033, 0x00000134},
	{0x03F, 0x00000001},
	{0x033, 0x00000135},
	{0x03F, 0x00000002},
	{0x033, 0x00000136},
	{0x03F, 0x00000003},
	{0x033, 0x00000137},
	{0x03F, 0x00000003},
	{0x033, 0x00000160},
	{0x03F, 0x00060001},
	{0x033, 0x00000161},
	{0x03F, 0x00060032},
	{0x033, 0x00000162},
	{0x03F, 0x00050042},
	{0x033, 0x00000163},
	{0x03F, 0x00040042},
	{0x033, 0x00000164},
	{0x03F, 0x00000001},
	{0x033, 0x00000165},
	{0x03F, 0x00000002},
	{0x033, 0x00000166},
	{0x03F, 0x00000003},
	{0x033, 0x00000167},
	{0x03F, 0x00000003},
	{0x033, 0x00000168},
	{0x03F, 0x00060001},
	{0x033, 0x00000169},
	{0x03F, 0x00060032},
	{0x033, 0x0000016A},
	{0x03F, 0x00050042},
	{0x033, 0x0000016B},
	{0x03F, 0x00040042},
	{0x033, 0x0000016C},
	{0x03F, 0x00000001},
	{0x033, 0x0000016D},
	{0x03F, 0x00000002},
	{0x033, 0x0000016E},
	{0x03F, 0x00000003},
	{0x033, 0x0000016F},
	{0x03F, 0x00000003},
	{0x033, 0x00000170},
	{0x03F, 0x00060001},
	{0x033, 0x00000171},
	{0x03F, 0x00060032},
	{0x033, 0x00000172},
	{0x03F, 0x00050042},
	{0x033, 0x00000173},
	{0x03F, 0x00040042},
	{0x033, 0x00000174},
	{0x03F, 0x00000001},
	{0x033, 0x00000175},
	{0x03F, 0x00000002},
	{0x033, 0x00000176},
	{0x03F, 0x00000003},
	{0x033, 0x00000177},
	{0x03F, 0x00000003},
	{0x033, 0x00000178},
	{0x03F, 0x00060001},
	{0x033, 0x00000179},
	{0x03F, 0x00060032},
	{0x033, 0x0000017A},
	{0x03F, 0x00050042},
	{0x033, 0x0000017B},
	{0x03F, 0x00040042},
	{0x033, 0x0000017C},
	{0x03F, 0x00000001},
	{0x033, 0x0000017D},
	{0x03F, 0x00000002},
	{0x033, 0x0000017E},
	{0x03F, 0x00000003},
	{0x033, 0x0000017F},
	{0x03F, 0x00000003},
	{0x033, 0x000001A0},
	{0x03F, 0x00060001},
	{0x033, 0x000001A1},
	{0x03F, 0x00060032},
	{0x033, 0x000001A2},
	{0x03F, 0x00050042},
	{0x033, 0x000001A3},
	{0x03F, 0x00040042},
	{0x033, 0x000001A4},
	{0x03F, 0x00000001},
	{0x033, 0x000001A5},
	{0x03F, 0x00000002},
	{0x033, 0x000001A6},
	{0x03F, 0x00000003},
	{0x033, 0x000001A7},
	{0x03F, 0x00000003},
	{0x033, 0x000001A8},
	{0x03F, 0x00060001},
	{0x033, 0x000001A9},
	{0x03F, 0x00060032},
	{0x033, 0x000001AA},
	{0x03F, 0x00050042},
	{0x033, 0x000001AB},
	{0x03F, 0x00040042},
	{0x033, 0x000001AC},
	{0x03F, 0x00000001},
	{0x033, 0x000001AD},
	{0x03F, 0x00000002},
	{0x033, 0x000001AE},
	{0x03F, 0x00000003},
	{0x033, 0x000001AF},
	{0x03F, 0x00000003},
	{0x033, 0x000001B0},
	{0x03F, 0x00060001},
	{0x033, 0x000001B1},
	{0x03F, 0x00060032},
	{0x033, 0x000001B2},
	{0x03F, 0x00050042},
	{0x033, 0x000001B3},
	{0x03F, 0x00040042},
	{0x033, 0x000001B4},
	{0x03F, 0x00000001},
	{0x033, 0x000001B5},
	{0x03F, 0x00000002},
	{0x033, 0x000001B6},
	{0x03F, 0x00000003},
	{0x033, 0x000001B7},
	{0x03F, 0x00000003},
	{0x033, 0x000001E0},
	{0x03F, 0x00060001},
	{0x033, 0x000001E1},
	{0x03F, 0x00060032},
	{0x033, 0x000001E2},
	{0x03F, 0x00050042},
	{0x033, 0x000001E3},
	{0x03F, 0x00040042},
	{0x033, 0x000001E4},
	{0x03F, 0x00000001},
	{0x033, 0x000001E5},
	{0x03F, 0x00000002},
	{0x033, 0x000001E6},
	{0x03F, 0x00000003},
	{0x033, 0x000001E7},
	{0x03F, 0x00000003},
	{0x033, 0x000001E8},
	{0x03F, 0x00060001},
	{0x033, 0x000001E9},
	{0x03F, 0x00060032},
	{0x033, 0x000001EA},
	{0x03F, 0x00050042},
	{0x033, 0x000001EB},
	{0x03F, 0x00040042},
	{0x033, 0x000001EC},
	{0x03F, 0x00000001},
	{0x033, 0x000001ED},
	{0x03F, 0x00000002},
	{0x033, 0x000001EE},
	{0x03F, 0x00000003},
	{0x033, 0x000001EF},
	{0x03F, 0x00000003},
	{0x033, 0x000001F0},
	{0x03F, 0x00060001},
	{0x033, 0x000001F1},
	{0x03F, 0x00060032},
	{0x033, 0x000001F2},
	{0x03F, 0x00050042},
	{0x033, 0x000001F3},
	{0x03F, 0x00040042},
	{0x033, 0x000001F4},
	{0x03F, 0x00000001},
	{0x033, 0x000001F5},
	{0x03F, 0x00000002},
	{0x033, 0x000001F6},
	{0x03F, 0x00000003},
	{0x033, 0x000001F7},
	{0x03F, 0x00000003},
	{0x033, 0x000001F8},
	{0x03F, 0x00060001},
	{0x033, 0x000001F9},
	{0x03F, 0x00060032},
	{0x033, 0x000001FA},
	{0x03F, 0x00050042},
	{0x033, 0x000001FB},
	{0x03F, 0x00040042},
	{0x033, 0x000001FC},
	{0x03F, 0x00000001},
	{0x033, 0x000001FD},
	{0x03F, 0x00000002},
	{0x033, 0x000001FE},
	{0x03F, 0x00000003},
	{0x033, 0x000001FF},
	{0x03F, 0x00000003},
	{0x0EF, 0x00000000},
	{0x0EF, 0x00000100},
	{0x033, 0x00000001},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000002},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000003},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000004},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000005},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000006},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000007},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000008},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000009},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000000A},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000000B},
	{0x03F, 0x0000AFFF},
	{0x033, 0x0000000C},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000000D},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000000E},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000000F},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000010},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000011},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000012},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000013},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000014},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000015},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000E3FF},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000E3FF},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000E3FF},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000E3FF},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000E3FF},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000E3FF},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000E3FF},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000EFFF},
	{0xA0000000, 0x00000000},
	{0x03F, 0x0000E3FF},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000016},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000017},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000018},
	{0x03F, 0x0000FBFF},
	{0x033, 0x00000019},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000001A},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000001B},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000001C},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000001D},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000001E},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000001F},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000020},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000021},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000022},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000023},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000024},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000025},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000026},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000027},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000028},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000029},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000002A},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000002B},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000002C},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000002D},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000002E},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000002F},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000030},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000031},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000032},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000033},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000034},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000035},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000036},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000037},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000038},
	{0x03F, 0x0000EFFF},
	{0x033, 0x00000039},
	{0x03F, 0x0000EFFF},
	{0x033, 0x0000003A},
	{0x03F, 0x0000EFFF},
	{0x0EF, 0x00000000},
	{0x0EF, 0x00000040},
	{0x033, 0x00000000},
	{0x03F, 0x00004344},
	{0x033, 0x00000001},
	{0x03F, 0x00004344},
	{0x033, 0x00000002},
	{0x03F, 0x00004344},
	{0x033, 0x00000003},
	{0x03F, 0x00004344},
	{0x033, 0x00000004},
	{0x03F, 0x00004344},
	{0x033, 0x00000005},
	{0x03F, 0x00004344},
	{0x033, 0x00000006},
	{0x03F, 0x00004324},
	{0x033, 0x00000007},
	{0x03F, 0x00004344},
	{0x033, 0x00000008},
	{0x03F, 0x00004344},
	{0x033, 0x00000009},
	{0x03F, 0x00004344},
	{0x033, 0x0000000A},
	{0x03F, 0x00004344},
	{0x033, 0x0000000B},
	{0x03F, 0x00004344},
	{0x033, 0x00000010},
	{0x03F, 0x00004344},
	{0x033, 0x00000011},
	{0x03F, 0x00004344},
	{0x033, 0x00000012},
	{0x03F, 0x00004344},
	{0x033, 0x00000013},
	{0x03F, 0x00004344},
	{0x033, 0x00000014},
	{0x03F, 0x00004344},
	{0x033, 0x00000015},
	{0x03F, 0x00004344},
	{0x033, 0x00000016},
	{0x03F, 0x00004344},
	{0x033, 0x00000017},
	{0x03F, 0x00004344},
	{0x033, 0x00000018},
	{0x03F, 0x00004344},
	{0x033, 0x00000019},
	{0x03F, 0x00004344},
	{0x033, 0x0000001A},
	{0x03F, 0x00004344},
	{0x033, 0x0000001B},
	{0x03F, 0x00004344},
	{0x033, 0x0000001C},
	{0x03F, 0x00004344},
	{0x033, 0x0000001D},
	{0x03F, 0x00004344},
	{0x033, 0x0000001E},
	{0x03F, 0x00004344},
	{0x033, 0x0000001F},
	{0x03F, 0x00004344},
	{0x0EF, 0x00000000},
	{0x0EF, 0x00000020},
	{0x033, 0x00000010},
	{0x03F, 0x00000200},
	{0x033, 0x00000011},
	{0x03F, 0x00000200},
	{0x033, 0x00000012},
	{0x03F, 0x00000200},
	{0x033, 0x00000013},
	{0x03F, 0x00000200},
	{0x033, 0x00000020},
	{0x03F, 0x00000200},
	{0x033, 0x00000021},
	{0x03F, 0x00000200},
	{0x033, 0x00000022},
	{0x03F, 0x00000200},
	{0x033, 0x00000023},
	{0x03F, 0x00000200},
	{0x0EF, 0x00000000},
	{0x0EF, 0x00000010},
	{0x030, 0x000084DC},
	{0x030, 0x000103C9},
	{0x030, 0x00018399},
	{0x030, 0x00020287},
	{0x030, 0x00028277},
	{0x030, 0x00030165},
	{0x030, 0x00038144},
	{0x030, 0x00040044},
	{0x030, 0x00048022},
	{0x030, 0x00050011},
	{0x030, 0x00058000},
	{0x030, 0x00060000},
	{0x030, 0x00068000},
	{0x030, 0x00070000},
	{0x0EF, 0x00000000},
	{0x0EF, 0x00000080},
	{0x033, 0x00000004},
	{0x03E, 0x00000013},
	{0x03F, 0x00022A58},
	{0x033, 0x00000005},
	{0x03E, 0x00000013},
	{0x03F, 0x00022A58},
	{0x033, 0x00000006},
	{0x03E, 0x00000014},
	{0x03F, 0x00023958},
	{0x033, 0x00000007},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x00000008},
	{0x03E, 0x00000013},
	{0x03F, 0x00022A58},
	{0x033, 0x00000009},
	{0x03E, 0x00000013},
	{0x03F, 0x00022A58},
	{0x033, 0x0000000A},
	{0x03E, 0x00000014},
	{0x03F, 0x00023958},
	{0x033, 0x0000000B},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x0000000C},
	{0x03E, 0x00000013},
	{0x03F, 0x00022A58},
	{0x033, 0x0000000D},
	{0x03E, 0x00000013},
	{0x03F, 0x00022A58},
	{0x033, 0x0000000E},
	{0x03E, 0x00000014},
	{0x03F, 0x00023958},
	{0x033, 0x0000000F},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x00000010},
	{0x03E, 0x00000013},
	{0x03F, 0x00022A58},
	{0x033, 0x00000011},
	{0x03E, 0x0000001B},
	{0x03F, 0x00022A58},
	{0x033, 0x00000012},
	{0x03E, 0x00000014},
	{0x03F, 0x00023958},
	{0x033, 0x00000013},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x00000014},
	{0x03E, 0x00000013},
	{0x03F, 0x00022A58},
	{0x033, 0x00000015},
	{0x03E, 0x0000001B},
	{0x03F, 0x00029858},
	{0x033, 0x00000016},
	{0x03E, 0x0000001C},
	{0x03F, 0x00023958},
	{0x033, 0x00000017},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x00000018},
	{0x03E, 0x00000013},
	{0x03F, 0x00029858},
	{0x033, 0x00000019},
	{0x03E, 0x0000001B},
	{0x03F, 0x00029858},
	{0x033, 0x0000001A},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x0000001B},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x0000001C},
	{0x03E, 0x00000014},
	{0x03F, 0x0002AC58},
	{0x033, 0x0000001D},
	{0x03E, 0x0000001B},
	{0x03F, 0x00029858},
	{0x033, 0x0000001E},
	{0x03E, 0x00000013},
	{0x03F, 0x00023A58},
	{0x033, 0x0000001F},
	{0x03E, 0x00000013},
	{0x03F, 0x00023A58},
	{0x033, 0x00000020},
	{0x03E, 0x00000014},
	{0x03F, 0x0002AC58},
	{0x033, 0x00000021},
	{0x03E, 0x0000001C},
	{0x03F, 0x0002AC58},
	{0x033, 0x00000022},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x00000023},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x00000024},
	{0x03E, 0x00000014},
	{0x03F, 0x0002AC58},
	{0x033, 0x00000025},
	{0x03E, 0x00000014},
	{0x03F, 0x0002AC58},
	{0x033, 0x00000026},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x00000027},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x00000028},
	{0x03E, 0x00000014},
	{0x03F, 0x0002AC58},
	{0x033, 0x00000029},
	{0x03E, 0x00000014},
	{0x03F, 0x0002AC58},
	{0x033, 0x0000002A},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x0000002B},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x0000002C},
	{0x03E, 0x00000014},
	{0x03F, 0x0002AC58},
	{0x033, 0x0000002D},
	{0x03E, 0x00000014},
	{0x03F, 0x0002AC58},
	{0x033, 0x0000002E},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x0000002F},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x00000030},
	{0x03E, 0x00000014},
	{0x03F, 0x0002AC58},
	{0x033, 0x00000031},
	{0x03E, 0x00000014},
	{0x03F, 0x0002AC58},
	{0x033, 0x00000032},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x00000033},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x00000034},
	{0x03E, 0x00000014},
	{0x03F, 0x0002AC58},
	{0x033, 0x00000035},
	{0x03E, 0x00000014},
	{0x03F, 0x0002AC58},
	{0x033, 0x00000036},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x00000037},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x00000038},
	{0x03E, 0x00000014},
	{0x03F, 0x0002AC58},
	{0x033, 0x00000039},
	{0x03E, 0x00000014},
	{0x03F, 0x0002AC58},
	{0x033, 0x0000003A},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x0000003B},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x0000003C},
	{0x03E, 0x00000014},
	{0x03F, 0x0002AC58},
	{0x033, 0x0000003D},
	{0x03E, 0x00000014},
	{0x03F, 0x0002AC58},
	{0x033, 0x0000003E},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x033, 0x0000003F},
	{0x03E, 0x00000014},
	{0x03F, 0x00023A58},
	{0x0EF, 0x00000000},
	{0x0EE, 0x00000800},
	{0x033, 0x00000000},
	{0x03F, 0x00000031},
	{0x033, 0x00000001},
	{0x03F, 0x00000023},
	{0x033, 0x00000002},
	{0x03F, 0x00000015},
	{0x033, 0x00000003},
	{0x03F, 0x00000007},
	{0x0EE, 0x00000000},
	{0x0EC, 0x00000400},
	{0x033, 0x00000003},
	{0x03F, 0x00000030},
	{0x033, 0x00000004},
	{0x03F, 0x00000021},
	{0x0EC, 0x00000000},
	{0x0DE, 0x00000000},
	{0x0EF, 0x00000000},
	{0x033, 0x00000000},
	{0x008, 0x00060280},
	{0x009, 0x00030400},
	{0x0EF, 0x00000000},
	{0x0A7, 0x00080308},
	{0x066, 0x00006000},
	{0x0EF, 0x00000400},
	{0x030, 0x000001FF},
	{0x030, 0x000081FF},
	{0x030, 0x000101FF},
	{0x030, 0x000181FF},
	{0x030, 0x000201FF},
	{0x030, 0x000281FF},
	{0x030, 0x0003017F},
	{0x030, 0x000380FB},
	{0x0EF, 0x00000000},
	{0x06E, 0x00077A18},
	{0x06D, 0x00000C31},
	{0x06A, 0x000E0F8A},
	{0x06B, 0x000018A0},
	{0x06F, 0x000F81FC},
	{0x05E, 0x0000001F},
	{0x0EF, 0x00000200},
	{0x030, 0x0003D407},
	{0x030, 0x00035A87},
	{0x030, 0x0002CF07},
	{0x030, 0x00024F07},
	{0x030, 0x0001CF07},
	{0x030, 0x00014F07},
	{0x030, 0x0000CF07},
	{0x030, 0x00004F07},
	{0x0EF, 0x00000000},
	{0x0EB, 0x00080000},
	{0x030, 0x00008038},
	{0x030, 0x00010038},
	{0x030, 0x00018038},
	{0x030, 0x00020038},
	{0x030, 0x00028038},
	{0x030, 0x00030038},
	{0x030, 0x0003803C},
	{0x030, 0x0004003C},
	{0x030, 0x0004803C},
	{0x030, 0x0005003C},
	{0x030, 0x0005803C},
	{0x030, 0x0006003C},
	{0x030, 0x0006803C},
	{0x030, 0x0007003C},
	{0x0EB, 0x00000000},
	{0x094, 0x000000FC},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000000},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000000},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000000},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000000},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000000},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000000},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000000},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x095, 0x00000008},
	{0xA0000000, 0x00000000},
	{0x095, 0x00000000},
	{0xB0000000, 0x00000000},
	{0x0EE, 0x00001000},
	{0x033, 0x00000020},
	{0x03F, 0x00000052},
	{0x033, 0x00000024},
	{0x03F, 0x0000005A},
	{0x033, 0x00000028},
	{0x03F, 0x0000009C},
	{0x033, 0x0000002C},
	{0x03F, 0x0000019C},
	{0x033, 0x00000030},
	{0x03F, 0x000001A4},
	{0x033, 0x00000034},
	{0x03F, 0x000001E7},
	{0x033, 0x00000038},
	{0x03F, 0x000002E7},
	{0x033, 0x0000003C},
	{0x03F, 0x000003E7},
	{0x033, 0x00000021},
	{0x03F, 0x00000052},
	{0x033, 0x00000025},
	{0x03F, 0x0000005A},
	{0x033, 0x00000029},
	{0x03F, 0x0000009C},
	{0x033, 0x0000002D},
	{0x03F, 0x0000019C},
	{0x033, 0x00000031},
	{0x03F, 0x000001A4},
	{0x033, 0x00000035},
	{0x03F, 0x000001E6},
	{0x033, 0x00000039},
	{0x03F, 0x000002E6},
	{0x033, 0x0000003D},
	{0x03F, 0x000003E6},
	{0x033, 0x00000022},
	{0x03F, 0x00000052},
	{0x033, 0x00000026},
	{0x03F, 0x0000005A},
	{0x033, 0x0000002A},
	{0x03F, 0x0000009C},
	{0x033, 0x0000002E},
	{0x03F, 0x0000019C},
	{0x033, 0x00000032},
	{0x03F, 0x000001A4},
	{0x033, 0x00000036},
	{0x03F, 0x000001E6},
	{0x033, 0x0000003A},
	{0x03F, 0x000002E6},
	{0x033, 0x0000003E},
	{0x03F, 0x000003E6},
	{0x033, 0x00000060},
	{0x03F, 0x00000052},
	{0x033, 0x00000064},
	{0x03F, 0x0000005A},
	{0x033, 0x00000068},
	{0x03F, 0x0000009C},
	{0x033, 0x0000006C},
	{0x03F, 0x0000019C},
	{0x033, 0x00000070},
	{0x03F, 0x000001A4},
	{0x033, 0x00000074},
	{0x03F, 0x000001E6},
	{0x033, 0x00000078},
	{0x03F, 0x000002E6},
	{0x033, 0x0000007C},
	{0x03F, 0x000003E6},
	{0x033, 0x00000061},
	{0x03F, 0x00000052},
	{0x033, 0x00000065},
	{0x03F, 0x0000005A},
	{0x033, 0x00000069},
	{0x03F, 0x0000009C},
	{0x033, 0x0000006D},
	{0x03F, 0x0000019C},
	{0x033, 0x00000071},
	{0x03F, 0x000001A4},
	{0x033, 0x00000075},
	{0x03F, 0x000001E6},
	{0x033, 0x00000079},
	{0x03F, 0x000002E6},
	{0x033, 0x0000007D},
	{0x03F, 0x000003E6},
	{0x033, 0x00000062},
	{0x03F, 0x00000052},
	{0x033, 0x00000066},
	{0x03F, 0x0000005A},
	{0x033, 0x0000006A},
	{0x03F, 0x0000009C},
	{0x033, 0x0000006E},
	{0x03F, 0x0000019C},
	{0x033, 0x00000072},
	{0x03F, 0x000001A4},
	{0x033, 0x00000076},
	{0x03F, 0x000001E6},
	{0x033, 0x0000007A},
	{0x03F, 0x000002E6},
	{0x033, 0x0000007E},
	{0x03F, 0x000003E6},
	{0x033, 0x00000063},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000052},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000052},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000052},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000052},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000052},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000052},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000052},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x00000152},
	{0xA0000000, 0x00000000},
	{0x03F, 0x00000052},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000067},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000005A},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000005A},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000005A},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000005A},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000005A},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000005A},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000005A},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000015A},
	{0xA0000000, 0x00000000},
	{0x03F, 0x0000005A},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000006B},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0xA0000000, 0x00000000},
	{0x03F, 0x0000009C},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000006F},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0xA0000000, 0x00000000},
	{0x03F, 0x0000019C},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000073},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0xA0000000, 0x00000000},
	{0x03F, 0x000001A4},
	{0xB0000000, 0x00000000},
	{0x033, 0x00000077},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x03F, 0x000002E6},
	{0xA0000000, 0x00000000},
	{0x03F, 0x000001E6},
	{0xB0000000, 0x00000000},
	{0x033, 0x0000007B},
	{0x03F, 0x000002E7},
	{0x033, 0x0000007F},
	{0x03F, 0x000003E7},
	{0x0EE, 0x00000000},
	{0x100EE, 0x00004000},
	{0x80010000, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000001EF},
	{0x10030, 0x000005E9},
	{0x10030, 0x000009E3},
	{0x10030, 0x00000DDD},
	{0x10030, 0x000011D7},
	{0x10030, 0x0000159F},
	{0x10030, 0x00001999},
	{0x10030, 0x00001D5F},
	{0x10030, 0x00002159},
	{0x10030, 0x0000251F},
	{0x10030, 0x00002919},
	{0x10030, 0x00002CDF},
	{0x10030, 0x000030D9},
	{0x10030, 0x0000349F},
	{0x10030, 0x00003899},
	{0x10030, 0x00003C5F},
	{0x10030, 0x00004059},
	{0x10030, 0x00004453},
	{0x10030, 0x000201ED},
	{0x10030, 0x000205AD},
	{0x10030, 0x000209A7},
	{0x10030, 0x00020DA1},
	{0x10030, 0x0002119B},
	{0x10030, 0x00021561},
	{0x10030, 0x0002195B},
	{0x10030, 0x00021D27},
	{0x10030, 0x00022121},
	{0x10030, 0x000224E9},
	{0x10030, 0x000228E3},
	{0x10030, 0x00022CA9},
	{0x10030, 0x000230A3},
	{0x10030, 0x00023469},
	{0x10030, 0x00023863},
	{0x10030, 0x00023C29},
	{0x10030, 0x00024023},
	{0x10030, 0x0002441D},
	{0x10030, 0x000281EF},
	{0x10030, 0x000285AF},
	{0x10030, 0x000289A9},
	{0x10030, 0x00028DA3},
	{0x10030, 0x0002919D},
	{0x10030, 0x00029563},
	{0x10030, 0x0002995D},
	{0x10030, 0x00029D25},
	{0x10030, 0x0002A11F},
	{0x10030, 0x0002A4E7},
	{0x10030, 0x0002A8E1},
	{0x10030, 0x0002ACA7},
	{0x10030, 0x0002B0A1},
	{0x10030, 0x0002B467},
	{0x10030, 0x0002B861},
	{0x10030, 0x0002BC27},
	{0x10030, 0x0002C021},
	{0x10030, 0x0002C41B},
	{0x10030, 0x000301EF},
	{0x10030, 0x000305AF},
	{0x10030, 0x000309A9},
	{0x10030, 0x00030DA3},
	{0x10030, 0x0003119D},
	{0x10030, 0x00031563},
	{0x10030, 0x0003195D},
	{0x10030, 0x00031D25},
	{0x10030, 0x0003211F},
	{0x10030, 0x000324E7},
	{0x10030, 0x000328E1},
	{0x10030, 0x00032CA7},
	{0x10030, 0x000330A1},
	{0x10030, 0x00033467},
	{0x10030, 0x00033861},
	{0x10030, 0x00033C27},
	{0x10030, 0x00034021},
	{0x10030, 0x0003441B},
	{0x10030, 0x000601EB},
	{0x10030, 0x000605AB},
	{0x10030, 0x000609A5},
	{0x10030, 0x00060D9F},
	{0x10030, 0x00061199},
	{0x10030, 0x00061593},
	{0x10030, 0x00061959},
	{0x10030, 0x00061D53},
	{0x10030, 0x0006211B},
	{0x10030, 0x00062515},
	{0x10030, 0x000628DD},
	{0x10030, 0x00062CD7},
	{0x10030, 0x0006309D},
	{0x10030, 0x00063497},
	{0x10030, 0x0006385D},
	{0x10030, 0x00063C57},
	{0x10030, 0x0006401D},
	{0x10030, 0x00064417},
	{0x10030, 0x000681E7},
	{0x10030, 0x000685A7},
	{0x10030, 0x000689A1},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955F},
	{0x10030, 0x00069959},
	{0x10030, 0x00069D21},
	{0x10030, 0x0006A11B},
	{0x10030, 0x0006A4E3},
	{0x10030, 0x0006A8DD},
	{0x10030, 0x0006ACA5},
	{0x10030, 0x0006B09F},
	{0x10030, 0x0006B465},
	{0x10030, 0x0006B85F},
	{0x10030, 0x0006BC25},
	{0x10030, 0x0006C01F},
	{0x10030, 0x0006C419},
	{0x10030, 0x000701E7},
	{0x10030, 0x000705A7},
	{0x10030, 0x000709A1},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071955},
	{0x10030, 0x00071D1D},
	{0x10030, 0x00072117},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072CA1},
	{0x10030, 0x0007309B},
	{0x10030, 0x00073461},
	{0x10030, 0x0007385B},
	{0x10030, 0x00073C21},
	{0x10030, 0x0007401B},
	{0x10030, 0x0007441B},
	{0x10030, 0x000781E9},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90020000, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000001EF},
	{0x10030, 0x000005E9},
	{0x10030, 0x000009E3},
	{0x10030, 0x00000DDD},
	{0x10030, 0x000011D7},
	{0x10030, 0x0000159F},
	{0x10030, 0x00001999},
	{0x10030, 0x00001D5F},
	{0x10030, 0x00002159},
	{0x10030, 0x0000251F},
	{0x10030, 0x00002919},
	{0x10030, 0x00002CDF},
	{0x10030, 0x000030D9},
	{0x10030, 0x0000349F},
	{0x10030, 0x00003899},
	{0x10030, 0x00003C5F},
	{0x10030, 0x00004059},
	{0x10030, 0x00004453},
	{0x10030, 0x000201ED},
	{0x10030, 0x000205AD},
	{0x10030, 0x000209A7},
	{0x10030, 0x00020DA1},
	{0x10030, 0x0002119B},
	{0x10030, 0x00021561},
	{0x10030, 0x0002195B},
	{0x10030, 0x00021D27},
	{0x10030, 0x00022121},
	{0x10030, 0x000224E9},
	{0x10030, 0x000228E3},
	{0x10030, 0x00022CA9},
	{0x10030, 0x000230A3},
	{0x10030, 0x00023469},
	{0x10030, 0x00023863},
	{0x10030, 0x00023C29},
	{0x10030, 0x00024023},
	{0x10030, 0x0002441D},
	{0x10030, 0x000281EF},
	{0x10030, 0x000285AF},
	{0x10030, 0x000289A9},
	{0x10030, 0x00028DA3},
	{0x10030, 0x0002919D},
	{0x10030, 0x00029563},
	{0x10030, 0x0002995D},
	{0x10030, 0x00029D25},
	{0x10030, 0x0002A11F},
	{0x10030, 0x0002A4E7},
	{0x10030, 0x0002A8E1},
	{0x10030, 0x0002ACA7},
	{0x10030, 0x0002B0A1},
	{0x10030, 0x0002B467},
	{0x10030, 0x0002B861},
	{0x10030, 0x0002BC27},
	{0x10030, 0x0002C021},
	{0x10030, 0x0002C41B},
	{0x10030, 0x000301EF},
	{0x10030, 0x000305AF},
	{0x10030, 0x000309A9},
	{0x10030, 0x00030DA3},
	{0x10030, 0x0003119D},
	{0x10030, 0x00031563},
	{0x10030, 0x0003195D},
	{0x10030, 0x00031D25},
	{0x10030, 0x0003211F},
	{0x10030, 0x000324E7},
	{0x10030, 0x000328E1},
	{0x10030, 0x00032CA7},
	{0x10030, 0x000330A1},
	{0x10030, 0x00033467},
	{0x10030, 0x00033861},
	{0x10030, 0x00033C27},
	{0x10030, 0x00034021},
	{0x10030, 0x0003441B},
	{0x10030, 0x000601EB},
	{0x10030, 0x000605AB},
	{0x10030, 0x000609A5},
	{0x10030, 0x00060D9F},
	{0x10030, 0x00061199},
	{0x10030, 0x00061593},
	{0x10030, 0x00061959},
	{0x10030, 0x00061D53},
	{0x10030, 0x0006211B},
	{0x10030, 0x00062515},
	{0x10030, 0x000628DD},
	{0x10030, 0x00062CD7},
	{0x10030, 0x0006309D},
	{0x10030, 0x00063497},
	{0x10030, 0x0006385D},
	{0x10030, 0x00063C57},
	{0x10030, 0x0006401D},
	{0x10030, 0x00064417},
	{0x10030, 0x000681E7},
	{0x10030, 0x000685A7},
	{0x10030, 0x000689A1},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955F},
	{0x10030, 0x00069959},
	{0x10030, 0x00069D21},
	{0x10030, 0x0006A11B},
	{0x10030, 0x0006A4E3},
	{0x10030, 0x0006A8DD},
	{0x10030, 0x0006ACA5},
	{0x10030, 0x0006B09F},
	{0x10030, 0x0006B465},
	{0x10030, 0x0006B85F},
	{0x10030, 0x0006BC25},
	{0x10030, 0x0006C01F},
	{0x10030, 0x0006C419},
	{0x10030, 0x000701E7},
	{0x10030, 0x000705A7},
	{0x10030, 0x000709A1},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071955},
	{0x10030, 0x00071D1D},
	{0x10030, 0x00072117},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072CA1},
	{0x10030, 0x0007309B},
	{0x10030, 0x00073461},
	{0x10030, 0x0007385B},
	{0x10030, 0x00073C21},
	{0x10030, 0x0007401B},
	{0x10030, 0x0007441B},
	{0x10030, 0x000781E9},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90320000, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000001EF},
	{0x10030, 0x000005E9},
	{0x10030, 0x000009E3},
	{0x10030, 0x00000DDD},
	{0x10030, 0x000011D7},
	{0x10030, 0x0000159F},
	{0x10030, 0x00001999},
	{0x10030, 0x00001D5F},
	{0x10030, 0x00002159},
	{0x10030, 0x0000251F},
	{0x10030, 0x00002919},
	{0x10030, 0x00002CDF},
	{0x10030, 0x000030D9},
	{0x10030, 0x0000349F},
	{0x10030, 0x00003899},
	{0x10030, 0x00003C5F},
	{0x10030, 0x00004059},
	{0x10030, 0x00004453},
	{0x10030, 0x000201ED},
	{0x10030, 0x000205AD},
	{0x10030, 0x000209A7},
	{0x10030, 0x00020DA1},
	{0x10030, 0x0002119B},
	{0x10030, 0x00021561},
	{0x10030, 0x0002195B},
	{0x10030, 0x00021D27},
	{0x10030, 0x00022121},
	{0x10030, 0x000224E9},
	{0x10030, 0x000228E3},
	{0x10030, 0x00022CA9},
	{0x10030, 0x000230A3},
	{0x10030, 0x00023469},
	{0x10030, 0x00023863},
	{0x10030, 0x00023C29},
	{0x10030, 0x00024023},
	{0x10030, 0x0002441D},
	{0x10030, 0x000281EF},
	{0x10030, 0x000285AF},
	{0x10030, 0x000289A9},
	{0x10030, 0x00028DA3},
	{0x10030, 0x0002919D},
	{0x10030, 0x00029563},
	{0x10030, 0x0002995D},
	{0x10030, 0x00029D25},
	{0x10030, 0x0002A11F},
	{0x10030, 0x0002A4E7},
	{0x10030, 0x0002A8E1},
	{0x10030, 0x0002ACA7},
	{0x10030, 0x0002B0A1},
	{0x10030, 0x0002B467},
	{0x10030, 0x0002B861},
	{0x10030, 0x0002BC27},
	{0x10030, 0x0002C021},
	{0x10030, 0x0002C41B},
	{0x10030, 0x000301EF},
	{0x10030, 0x000305AF},
	{0x10030, 0x000309A9},
	{0x10030, 0x00030DA3},
	{0x10030, 0x0003119D},
	{0x10030, 0x00031563},
	{0x10030, 0x0003195D},
	{0x10030, 0x00031D25},
	{0x10030, 0x0003211F},
	{0x10030, 0x000324E7},
	{0x10030, 0x000328E1},
	{0x10030, 0x00032CA7},
	{0x10030, 0x000330A1},
	{0x10030, 0x00033467},
	{0x10030, 0x00033861},
	{0x10030, 0x00033C27},
	{0x10030, 0x00034021},
	{0x10030, 0x0003441B},
	{0x10030, 0x000601EB},
	{0x10030, 0x000605AB},
	{0x10030, 0x000609A5},
	{0x10030, 0x00060D9F},
	{0x10030, 0x00061199},
	{0x10030, 0x00061593},
	{0x10030, 0x00061959},
	{0x10030, 0x00061D53},
	{0x10030, 0x0006211B},
	{0x10030, 0x00062515},
	{0x10030, 0x000628DD},
	{0x10030, 0x00062CD7},
	{0x10030, 0x0006309D},
	{0x10030, 0x00063497},
	{0x10030, 0x0006385D},
	{0x10030, 0x00063C57},
	{0x10030, 0x0006401D},
	{0x10030, 0x00064417},
	{0x10030, 0x000681E7},
	{0x10030, 0x000685A7},
	{0x10030, 0x000689A1},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955F},
	{0x10030, 0x00069959},
	{0x10030, 0x00069D21},
	{0x10030, 0x0006A11B},
	{0x10030, 0x0006A4E3},
	{0x10030, 0x0006A8DD},
	{0x10030, 0x0006ACA5},
	{0x10030, 0x0006B09F},
	{0x10030, 0x0006B465},
	{0x10030, 0x0006B85F},
	{0x10030, 0x0006BC25},
	{0x10030, 0x0006C01F},
	{0x10030, 0x0006C419},
	{0x10030, 0x000701E7},
	{0x10030, 0x000705A7},
	{0x10030, 0x000709A1},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071955},
	{0x10030, 0x00071D1D},
	{0x10030, 0x00072117},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072CA1},
	{0x10030, 0x0007309B},
	{0x10030, 0x00073461},
	{0x10030, 0x0007385B},
	{0x10030, 0x00073C21},
	{0x10030, 0x0007401B},
	{0x10030, 0x0007441B},
	{0x10030, 0x000781E9},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90330000, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90340000, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90350000, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90360000, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90010001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000001EF},
	{0x10030, 0x000005E9},
	{0x10030, 0x000009E3},
	{0x10030, 0x00000DDD},
	{0x10030, 0x000011D7},
	{0x10030, 0x0000159F},
	{0x10030, 0x00001999},
	{0x10030, 0x00001D5F},
	{0x10030, 0x00002159},
	{0x10030, 0x0000251F},
	{0x10030, 0x00002919},
	{0x10030, 0x00002CDF},
	{0x10030, 0x000030D9},
	{0x10030, 0x0000349F},
	{0x10030, 0x00003899},
	{0x10030, 0x00003C5F},
	{0x10030, 0x00004059},
	{0x10030, 0x00004453},
	{0x10030, 0x000201ED},
	{0x10030, 0x000205AD},
	{0x10030, 0x000209A7},
	{0x10030, 0x00020DA1},
	{0x10030, 0x0002119B},
	{0x10030, 0x00021561},
	{0x10030, 0x0002195B},
	{0x10030, 0x00021D27},
	{0x10030, 0x00022121},
	{0x10030, 0x000224E9},
	{0x10030, 0x000228E3},
	{0x10030, 0x00022CA9},
	{0x10030, 0x000230A3},
	{0x10030, 0x00023469},
	{0x10030, 0x00023863},
	{0x10030, 0x00023C29},
	{0x10030, 0x00024023},
	{0x10030, 0x0002441D},
	{0x10030, 0x000281EF},
	{0x10030, 0x000285AF},
	{0x10030, 0x000289A9},
	{0x10030, 0x00028DA3},
	{0x10030, 0x0002919D},
	{0x10030, 0x00029563},
	{0x10030, 0x0002995D},
	{0x10030, 0x00029D25},
	{0x10030, 0x0002A11F},
	{0x10030, 0x0002A4E7},
	{0x10030, 0x0002A8E1},
	{0x10030, 0x0002ACA7},
	{0x10030, 0x0002B0A1},
	{0x10030, 0x0002B467},
	{0x10030, 0x0002B861},
	{0x10030, 0x0002BC27},
	{0x10030, 0x0002C021},
	{0x10030, 0x0002C41B},
	{0x10030, 0x000301EF},
	{0x10030, 0x000305AF},
	{0x10030, 0x000309A9},
	{0x10030, 0x00030DA3},
	{0x10030, 0x0003119D},
	{0x10030, 0x00031563},
	{0x10030, 0x0003195D},
	{0x10030, 0x00031D25},
	{0x10030, 0x0003211F},
	{0x10030, 0x000324E7},
	{0x10030, 0x000328E1},
	{0x10030, 0x00032CA7},
	{0x10030, 0x000330A1},
	{0x10030, 0x00033467},
	{0x10030, 0x00033861},
	{0x10030, 0x00033C27},
	{0x10030, 0x00034021},
	{0x10030, 0x0003441B},
	{0x10030, 0x000601EB},
	{0x10030, 0x000605AB},
	{0x10030, 0x000609A5},
	{0x10030, 0x00060D9F},
	{0x10030, 0x00061199},
	{0x10030, 0x00061593},
	{0x10030, 0x00061959},
	{0x10030, 0x00061D53},
	{0x10030, 0x0006211B},
	{0x10030, 0x00062515},
	{0x10030, 0x000628DD},
	{0x10030, 0x00062CD7},
	{0x10030, 0x0006309D},
	{0x10030, 0x00063497},
	{0x10030, 0x0006385D},
	{0x10030, 0x00063C57},
	{0x10030, 0x0006401D},
	{0x10030, 0x00064417},
	{0x10030, 0x000681E7},
	{0x10030, 0x000685A7},
	{0x10030, 0x000689A1},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955F},
	{0x10030, 0x00069959},
	{0x10030, 0x00069D21},
	{0x10030, 0x0006A11B},
	{0x10030, 0x0006A4E3},
	{0x10030, 0x0006A8DD},
	{0x10030, 0x0006ACA5},
	{0x10030, 0x0006B09F},
	{0x10030, 0x0006B465},
	{0x10030, 0x0006B85F},
	{0x10030, 0x0006BC25},
	{0x10030, 0x0006C01F},
	{0x10030, 0x0006C419},
	{0x10030, 0x000701E7},
	{0x10030, 0x000705A7},
	{0x10030, 0x000709A1},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071955},
	{0x10030, 0x00071D1D},
	{0x10030, 0x00072117},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072CA1},
	{0x10030, 0x0007309B},
	{0x10030, 0x00073461},
	{0x10030, 0x0007385B},
	{0x10030, 0x00073C21},
	{0x10030, 0x0007401B},
	{0x10030, 0x0007441B},
	{0x10030, 0x000781EF},
	{0x10030, 0x000785E9},
	{0x10030, 0x000789E3},
	{0x10030, 0x00078DA3},
	{0x10030, 0x00079161},
	{0x10030, 0x0007955B},
	{0x10030, 0x00079921},
	{0x10030, 0x00079D1B},
	{0x10030, 0x0007A0E1},
	{0x10030, 0x0007A4DB},
	{0x10030, 0x0007A8A1},
	{0x10030, 0x0007AC9B},
	{0x10030, 0x0007B061},
	{0x10030, 0x0007B45B},
	{0x10030, 0x0007B821},
	{0x10030, 0x0007BC1B},
	{0x10030, 0x0007C015},
	{0x10030, 0x0007C40F},
	{0x90020001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000001EF},
	{0x10030, 0x000005E9},
	{0x10030, 0x000009E3},
	{0x10030, 0x00000DDD},
	{0x10030, 0x000011D7},
	{0x10030, 0x0000159F},
	{0x10030, 0x00001999},
	{0x10030, 0x00001D5F},
	{0x10030, 0x00002159},
	{0x10030, 0x0000251F},
	{0x10030, 0x00002919},
	{0x10030, 0x00002CDF},
	{0x10030, 0x000030D9},
	{0x10030, 0x0000349F},
	{0x10030, 0x00003899},
	{0x10030, 0x00003C5F},
	{0x10030, 0x00004059},
	{0x10030, 0x00004453},
	{0x10030, 0x000201ED},
	{0x10030, 0x000205AD},
	{0x10030, 0x000209A7},
	{0x10030, 0x00020DA1},
	{0x10030, 0x0002119B},
	{0x10030, 0x00021561},
	{0x10030, 0x0002195B},
	{0x10030, 0x00021D27},
	{0x10030, 0x00022121},
	{0x10030, 0x000224E9},
	{0x10030, 0x000228E3},
	{0x10030, 0x00022CA9},
	{0x10030, 0x000230A3},
	{0x10030, 0x00023469},
	{0x10030, 0x00023863},
	{0x10030, 0x00023C29},
	{0x10030, 0x00024023},
	{0x10030, 0x0002441D},
	{0x10030, 0x000281EF},
	{0x10030, 0x000285AF},
	{0x10030, 0x000289A9},
	{0x10030, 0x00028DA3},
	{0x10030, 0x0002919D},
	{0x10030, 0x00029563},
	{0x10030, 0x0002995D},
	{0x10030, 0x00029D25},
	{0x10030, 0x0002A11F},
	{0x10030, 0x0002A4E7},
	{0x10030, 0x0002A8E1},
	{0x10030, 0x0002ACA7},
	{0x10030, 0x0002B0A1},
	{0x10030, 0x0002B467},
	{0x10030, 0x0002B861},
	{0x10030, 0x0002BC27},
	{0x10030, 0x0002C021},
	{0x10030, 0x0002C41B},
	{0x10030, 0x000301EF},
	{0x10030, 0x000305AF},
	{0x10030, 0x000309A9},
	{0x10030, 0x00030DA3},
	{0x10030, 0x0003119D},
	{0x10030, 0x00031563},
	{0x10030, 0x0003195D},
	{0x10030, 0x00031D25},
	{0x10030, 0x0003211F},
	{0x10030, 0x000324E7},
	{0x10030, 0x000328E1},
	{0x10030, 0x00032CA7},
	{0x10030, 0x000330A1},
	{0x10030, 0x00033467},
	{0x10030, 0x00033861},
	{0x10030, 0x00033C27},
	{0x10030, 0x00034021},
	{0x10030, 0x0003441B},
	{0x10030, 0x000601EB},
	{0x10030, 0x000605AB},
	{0x10030, 0x000609A5},
	{0x10030, 0x00060D9F},
	{0x10030, 0x00061199},
	{0x10030, 0x00061593},
	{0x10030, 0x00061959},
	{0x10030, 0x00061D53},
	{0x10030, 0x0006211B},
	{0x10030, 0x00062515},
	{0x10030, 0x000628DD},
	{0x10030, 0x00062CD7},
	{0x10030, 0x0006309D},
	{0x10030, 0x00063497},
	{0x10030, 0x0006385D},
	{0x10030, 0x00063C57},
	{0x10030, 0x0006401D},
	{0x10030, 0x00064417},
	{0x10030, 0x000681E7},
	{0x10030, 0x000685A7},
	{0x10030, 0x000689A1},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955F},
	{0x10030, 0x00069959},
	{0x10030, 0x00069D21},
	{0x10030, 0x0006A11B},
	{0x10030, 0x0006A4E3},
	{0x10030, 0x0006A8DD},
	{0x10030, 0x0006ACA5},
	{0x10030, 0x0006B09F},
	{0x10030, 0x0006B465},
	{0x10030, 0x0006B85F},
	{0x10030, 0x0006BC25},
	{0x10030, 0x0006C01F},
	{0x10030, 0x0006C419},
	{0x10030, 0x000701E7},
	{0x10030, 0x000705A7},
	{0x10030, 0x000709A1},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071955},
	{0x10030, 0x00071D1D},
	{0x10030, 0x00072117},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072CA1},
	{0x10030, 0x0007309B},
	{0x10030, 0x00073461},
	{0x10030, 0x0007385B},
	{0x10030, 0x00073C21},
	{0x10030, 0x0007401B},
	{0x10030, 0x0007441B},
	{0x10030, 0x000781EF},
	{0x10030, 0x000785E9},
	{0x10030, 0x000789E3},
	{0x10030, 0x00078DA3},
	{0x10030, 0x00079161},
	{0x10030, 0x0007955B},
	{0x10030, 0x00079921},
	{0x10030, 0x00079D1B},
	{0x10030, 0x0007A0E1},
	{0x10030, 0x0007A4DB},
	{0x10030, 0x0007A8A1},
	{0x10030, 0x0007AC9B},
	{0x10030, 0x0007B061},
	{0x10030, 0x0007B45B},
	{0x10030, 0x0007B821},
	{0x10030, 0x0007BC1B},
	{0x10030, 0x0007C015},
	{0x10030, 0x0007C40F},
	{0x90320001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000001EF},
	{0x10030, 0x000005E9},
	{0x10030, 0x000009E3},
	{0x10030, 0x00000DDD},
	{0x10030, 0x000011D7},
	{0x10030, 0x0000159F},
	{0x10030, 0x00001999},
	{0x10030, 0x00001D5F},
	{0x10030, 0x00002159},
	{0x10030, 0x0000251F},
	{0x10030, 0x00002919},
	{0x10030, 0x00002CDF},
	{0x10030, 0x000030D9},
	{0x10030, 0x0000349F},
	{0x10030, 0x00003899},
	{0x10030, 0x00003C5F},
	{0x10030, 0x00004059},
	{0x10030, 0x00004453},
	{0x10030, 0x000201ED},
	{0x10030, 0x000205AD},
	{0x10030, 0x000209A7},
	{0x10030, 0x00020DA1},
	{0x10030, 0x0002119B},
	{0x10030, 0x00021561},
	{0x10030, 0x0002195B},
	{0x10030, 0x00021D27},
	{0x10030, 0x00022121},
	{0x10030, 0x000224E9},
	{0x10030, 0x000228E3},
	{0x10030, 0x00022CA9},
	{0x10030, 0x000230A3},
	{0x10030, 0x00023469},
	{0x10030, 0x00023863},
	{0x10030, 0x00023C29},
	{0x10030, 0x00024023},
	{0x10030, 0x0002441D},
	{0x10030, 0x000281EF},
	{0x10030, 0x000285AF},
	{0x10030, 0x000289A9},
	{0x10030, 0x00028DA3},
	{0x10030, 0x0002919D},
	{0x10030, 0x00029563},
	{0x10030, 0x0002995D},
	{0x10030, 0x00029D25},
	{0x10030, 0x0002A11F},
	{0x10030, 0x0002A4E7},
	{0x10030, 0x0002A8E1},
	{0x10030, 0x0002ACA7},
	{0x10030, 0x0002B0A1},
	{0x10030, 0x0002B467},
	{0x10030, 0x0002B861},
	{0x10030, 0x0002BC27},
	{0x10030, 0x0002C021},
	{0x10030, 0x0002C41B},
	{0x10030, 0x000301EF},
	{0x10030, 0x000305AF},
	{0x10030, 0x000309A9},
	{0x10030, 0x00030DA3},
	{0x10030, 0x0003119D},
	{0x10030, 0x00031563},
	{0x10030, 0x0003195D},
	{0x10030, 0x00031D25},
	{0x10030, 0x0003211F},
	{0x10030, 0x000324E7},
	{0x10030, 0x000328E1},
	{0x10030, 0x00032CA7},
	{0x10030, 0x000330A1},
	{0x10030, 0x00033467},
	{0x10030, 0x00033861},
	{0x10030, 0x00033C27},
	{0x10030, 0x00034021},
	{0x10030, 0x0003441B},
	{0x10030, 0x000601EB},
	{0x10030, 0x000605AB},
	{0x10030, 0x000609A5},
	{0x10030, 0x00060D9F},
	{0x10030, 0x00061199},
	{0x10030, 0x00061593},
	{0x10030, 0x00061959},
	{0x10030, 0x00061D53},
	{0x10030, 0x0006211B},
	{0x10030, 0x00062515},
	{0x10030, 0x000628DD},
	{0x10030, 0x00062CD7},
	{0x10030, 0x0006309D},
	{0x10030, 0x00063497},
	{0x10030, 0x0006385D},
	{0x10030, 0x00063C57},
	{0x10030, 0x0006401D},
	{0x10030, 0x00064417},
	{0x10030, 0x000681E7},
	{0x10030, 0x000685A7},
	{0x10030, 0x000689A1},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955F},
	{0x10030, 0x00069959},
	{0x10030, 0x00069D21},
	{0x10030, 0x0006A11B},
	{0x10030, 0x0006A4E3},
	{0x10030, 0x0006A8DD},
	{0x10030, 0x0006ACA5},
	{0x10030, 0x0006B09F},
	{0x10030, 0x0006B465},
	{0x10030, 0x0006B85F},
	{0x10030, 0x0006BC25},
	{0x10030, 0x0006C01F},
	{0x10030, 0x0006C419},
	{0x10030, 0x000701E7},
	{0x10030, 0x000705A7},
	{0x10030, 0x000709A1},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071955},
	{0x10030, 0x00071D1D},
	{0x10030, 0x00072117},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072CA1},
	{0x10030, 0x0007309B},
	{0x10030, 0x00073461},
	{0x10030, 0x0007385B},
	{0x10030, 0x00073C21},
	{0x10030, 0x0007401B},
	{0x10030, 0x0007441B},
	{0x10030, 0x000781EF},
	{0x10030, 0x000785E9},
	{0x10030, 0x000789E3},
	{0x10030, 0x00078DA3},
	{0x10030, 0x00079161},
	{0x10030, 0x0007955B},
	{0x10030, 0x00079921},
	{0x10030, 0x00079D1B},
	{0x10030, 0x0007A0E1},
	{0x10030, 0x0007A4DB},
	{0x10030, 0x0007A8A1},
	{0x10030, 0x0007AC9B},
	{0x10030, 0x0007B061},
	{0x10030, 0x0007B45B},
	{0x10030, 0x0007B821},
	{0x10030, 0x0007BC1B},
	{0x10030, 0x0007C015},
	{0x10030, 0x0007C40F},
	{0x90330001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90340001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90350001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90360001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x903f0001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x90400001, 0x00000000}, {0x40000000, 0x00000000},
	{0x10030, 0x000201DF},
	{0x10030, 0x000205D9},
	{0x10030, 0x000209D3},
	{0x10030, 0x00020D99},
	{0x10030, 0x00021193},
	{0x10030, 0x0002155F},
	{0x10030, 0x00021959},
	{0x10030, 0x00021D21},
	{0x10030, 0x00022119},
	{0x10030, 0x000224DF},
	{0x10030, 0x000228D9},
	{0x10030, 0x00022C9F},
	{0x10030, 0x00023099},
	{0x10030, 0x0002345F},
	{0x10030, 0x00023859},
	{0x10030, 0x00023C1F},
	{0x10030, 0x00024019},
	{0x10030, 0x00024413},
	{0x10030, 0x000281CD},
	{0x10030, 0x000285DB},
	{0x10030, 0x000289D5},
	{0x10030, 0x00028D9B},
	{0x10030, 0x0002918D},
	{0x10030, 0x00029555},
	{0x10030, 0x00029957},
	{0x10030, 0x00029D1F},
	{0x10030, 0x0002A119},
	{0x10030, 0x0002A4DF},
	{0x10030, 0x0002A8D9},
	{0x10030, 0x0002AC9F},
	{0x10030, 0x0002B099},
	{0x10030, 0x0002B45F},
	{0x10030, 0x0002B859},
	{0x10030, 0x0002BC1F},
	{0x10030, 0x0002C019},
	{0x10030, 0x0002C413},
	{0x10030, 0x000301D9},
	{0x10030, 0x000305DB},
	{0x10030, 0x000309D5},
	{0x10030, 0x00030D9B},
	{0x10030, 0x00031195},
	{0x10030, 0x0003155D},
	{0x10030, 0x00031955},
	{0x10030, 0x00031D1D},
	{0x10030, 0x00032119},
	{0x10030, 0x000324DF},
	{0x10030, 0x000328D9},
	{0x10030, 0x00032C9F},
	{0x10030, 0x00033099},
	{0x10030, 0x0003345F},
	{0x10030, 0x00033859},
	{0x10030, 0x00033C1F},
	{0x10030, 0x00034019},
	{0x10030, 0x00034413},
	{0x10030, 0x000601E1},
	{0x10030, 0x000605DB},
	{0x10030, 0x000609D5},
	{0x10030, 0x00060D9B},
	{0x10030, 0x00061195},
	{0x10030, 0x0006155B},
	{0x10030, 0x00061957},
	{0x10030, 0x00061D1F},
	{0x10030, 0x00062119},
	{0x10030, 0x000624DF},
	{0x10030, 0x000628D9},
	{0x10030, 0x00062C9F},
	{0x10030, 0x00063099},
	{0x10030, 0x0006345F},
	{0x10030, 0x00063859},
	{0x10030, 0x00063C1F},
	{0x10030, 0x00064019},
	{0x10030, 0x00064413},
	{0x10030, 0x000681E1},
	{0x10030, 0x000685DB},
	{0x10030, 0x000689D5},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955B},
	{0x10030, 0x00069957},
	{0x10030, 0x00069D1F},
	{0x10030, 0x0006A119},
	{0x10030, 0x0006A4DF},
	{0x10030, 0x0006A8D9},
	{0x10030, 0x0006AC9F},
	{0x10030, 0x0006B099},
	{0x10030, 0x0006B45F},
	{0x10030, 0x0006B859},
	{0x10030, 0x0006BC1F},
	{0x10030, 0x0006C019},
	{0x10030, 0x0006C413},
	{0x10030, 0x000701E1},
	{0x10030, 0x000705DB},
	{0x10030, 0x000709D5},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071957},
	{0x10030, 0x00071D1F},
	{0x10030, 0x00072119},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072C9F},
	{0x10030, 0x00073099},
	{0x10030, 0x0007345F},
	{0x10030, 0x00073859},
	{0x10030, 0x00073C1F},
	{0x10030, 0x00074019},
	{0x10030, 0x00074413},
	{0x10030, 0x000781DF},
	{0x10030, 0x000785D9},
	{0x10030, 0x000789D3},
	{0x10030, 0x00078D99},
	{0x10030, 0x00079193},
	{0x10030, 0x0007955F},
	{0x10030, 0x00079959},
	{0x10030, 0x00079D21},
	{0x10030, 0x0007A115},
	{0x10030, 0x0007A4DF},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007AC9F},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B45F},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC1F},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0x10030, 0x00000000},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0xA0000000, 0x00000000},
	{0x10030, 0x000001EF},
	{0x10030, 0x000005E9},
	{0x10030, 0x000009E3},
	{0x10030, 0x00000DDD},
	{0x10030, 0x000011D7},
	{0x10030, 0x0000159F},
	{0x10030, 0x00001999},
	{0x10030, 0x00001D5F},
	{0x10030, 0x00002159},
	{0x10030, 0x0000251F},
	{0x10030, 0x00002919},
	{0x10030, 0x00002CDF},
	{0x10030, 0x000030D9},
	{0x10030, 0x0000349F},
	{0x10030, 0x00003899},
	{0x10030, 0x00003C5F},
	{0x10030, 0x00004059},
	{0x10030, 0x00004453},
	{0x10030, 0x000201ED},
	{0x10030, 0x000205AD},
	{0x10030, 0x000209A7},
	{0x10030, 0x00020DA1},
	{0x10030, 0x0002119B},
	{0x10030, 0x00021561},
	{0x10030, 0x0002195B},
	{0x10030, 0x00021D27},
	{0x10030, 0x00022121},
	{0x10030, 0x000224E9},
	{0x10030, 0x000228E3},
	{0x10030, 0x00022CA9},
	{0x10030, 0x000230A3},
	{0x10030, 0x00023469},
	{0x10030, 0x00023863},
	{0x10030, 0x00023C29},
	{0x10030, 0x00024023},
	{0x10030, 0x0002441D},
	{0x10030, 0x000281EF},
	{0x10030, 0x000285AF},
	{0x10030, 0x000289A9},
	{0x10030, 0x00028DA3},
	{0x10030, 0x0002919D},
	{0x10030, 0x00029563},
	{0x10030, 0x0002995D},
	{0x10030, 0x00029D25},
	{0x10030, 0x0002A11F},
	{0x10030, 0x0002A4E7},
	{0x10030, 0x0002A8E1},
	{0x10030, 0x0002ACA7},
	{0x10030, 0x0002B0A1},
	{0x10030, 0x0002B467},
	{0x10030, 0x0002B861},
	{0x10030, 0x0002BC27},
	{0x10030, 0x0002C021},
	{0x10030, 0x0002C41B},
	{0x10030, 0x000301EF},
	{0x10030, 0x000305AF},
	{0x10030, 0x000309A9},
	{0x10030, 0x00030DA3},
	{0x10030, 0x0003119D},
	{0x10030, 0x00031563},
	{0x10030, 0x0003195D},
	{0x10030, 0x00031D25},
	{0x10030, 0x0003211F},
	{0x10030, 0x000324E7},
	{0x10030, 0x000328E1},
	{0x10030, 0x00032CA7},
	{0x10030, 0x000330A1},
	{0x10030, 0x00033467},
	{0x10030, 0x00033861},
	{0x10030, 0x00033C27},
	{0x10030, 0x00034021},
	{0x10030, 0x0003441B},
	{0x10030, 0x000601EB},
	{0x10030, 0x000605AB},
	{0x10030, 0x000609A5},
	{0x10030, 0x00060D9F},
	{0x10030, 0x00061199},
	{0x10030, 0x00061593},
	{0x10030, 0x00061959},
	{0x10030, 0x00061D53},
	{0x10030, 0x0006211B},
	{0x10030, 0x00062515},
	{0x10030, 0x000628DD},
	{0x10030, 0x00062CD7},
	{0x10030, 0x0006309D},
	{0x10030, 0x00063497},
	{0x10030, 0x0006385D},
	{0x10030, 0x00063C57},
	{0x10030, 0x0006401D},
	{0x10030, 0x00064417},
	{0x10030, 0x000681E7},
	{0x10030, 0x000685A7},
	{0x10030, 0x000689A1},
	{0x10030, 0x00068D9B},
	{0x10030, 0x00069195},
	{0x10030, 0x0006955F},
	{0x10030, 0x00069959},
	{0x10030, 0x00069D21},
	{0x10030, 0x0006A11B},
	{0x10030, 0x0006A4E3},
	{0x10030, 0x0006A8DD},
	{0x10030, 0x0006ACA5},
	{0x10030, 0x0006B09F},
	{0x10030, 0x0006B465},
	{0x10030, 0x0006B85F},
	{0x10030, 0x0006BC25},
	{0x10030, 0x0006C01F},
	{0x10030, 0x0006C419},
	{0x10030, 0x000701E7},
	{0x10030, 0x000705A7},
	{0x10030, 0x000709A1},
	{0x10030, 0x00070D9B},
	{0x10030, 0x00071195},
	{0x10030, 0x0007155B},
	{0x10030, 0x00071955},
	{0x10030, 0x00071D1D},
	{0x10030, 0x00072117},
	{0x10030, 0x000724DF},
	{0x10030, 0x000728D9},
	{0x10030, 0x00072CA1},
	{0x10030, 0x0007309B},
	{0x10030, 0x00073461},
	{0x10030, 0x0007385B},
	{0x10030, 0x00073C21},
	{0x10030, 0x0007401B},
	{0x10030, 0x0007441B},
	{0x10030, 0x000781E9},
	{0x10030, 0x000785A9},
	{0x10030, 0x000789A3},
	{0x10030, 0x00078D9D},
	{0x10030, 0x00079197},
	{0x10030, 0x00079591},
	{0x10030, 0x00079957},
	{0x10030, 0x00079D51},
	{0x10030, 0x0007A119},
	{0x10030, 0x0007A513},
	{0x10030, 0x0007A8D9},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B099},
	{0x10030, 0x0007B493},
	{0x10030, 0x0007B859},
	{0x10030, 0x0007BC53},
	{0x10030, 0x0007C019},
	{0x10030, 0x0007C413},
	{0xB0000000, 0x00000000},
	{0x100EE, 0x00000000},
	{0x100EE, 0x00002000},
	{0x10030, 0x000000FC},
	{0x10030, 0x000004F9},
	{0x10030, 0x000008F6},
	{0x10030, 0x00000CF3},
	{0x10030, 0x000010F0},
	{0x10030, 0x000014ED},
	{0x10030, 0x000018AC},
	{0x10030, 0x00001CA9},
	{0x10030, 0x00002069},
	{0x10030, 0x00002466},
	{0x10030, 0x00002829},
	{0x10030, 0x00002C26},
	{0x10030, 0x00003023},
	{0x10030, 0x00003420},
	{0x10030, 0x0000381D},
	{0x10030, 0x00003C1A},
	{0x10030, 0x00004017},
	{0x100EE, 0x00000000},
	{0x100EE, 0x00002000},
	{0x10030, 0x000780F4},
	{0x10030, 0x000784F1},
	{0x10030, 0x000788EE},
	{0x10030, 0x00078CEB},
	{0x10030, 0x000790E8},
	{0x10030, 0x000794E5},
	{0x10030, 0x000798E2},
	{0x10030, 0x00079CDF},
	{0x10030, 0x0007A0DC},
	{0x10030, 0x0007A4D9},
	{0x10030, 0x0007A8D6},
	{0x10030, 0x0007ACD3},
	{0x10030, 0x0007B0D0},
	{0x10030, 0x0007B4CD},
	{0x10030, 0x0007B8CA},
	{0x10030, 0x0007BC07},
	{0x10030, 0x0007C004},
	{0x100EE, 0x00000000},
	{0x0EF, 0x00002000},
	{0x033, 0x00000008},
	{0x03F, 0x00000004},
	{0x033, 0x00000009},
	{0x03F, 0x00000003},
	{0x033, 0x0000000A},
	{0x03F, 0x00000003},
	{0x033, 0x0000000B},
	{0x03F, 0x00000002},
	{0x033, 0x0000000C},
	{0x03F, 0x00000002},
	{0x033, 0x0000000D},
	{0x03F, 0x00000002},
	{0x033, 0x0000000E},
	{0x03F, 0x00000002},
	{0x033, 0x0000000F},
	{0x03F, 0x00000002},
	{0x0EF, 0x00000000},
	{0x0EB, 0x00040000},
	{0x030, 0x000109B7},
	{0x0EB, 0x00000000},
	{0x0EF, 0x00008000},
	{0x033, 0x00000020},
	{0x03F, 0x00050002},
	{0x033, 0x00000021},
	{0x03F, 0x00060032},
	{0x033, 0x00000022},
	{0x03F, 0x00050042},
	{0x033, 0x00000023},
	{0x03F, 0x00040042},
	{0x033, 0x00000024},
	{0x03F, 0x00008001},
	{0x033, 0x00000025},
	{0x03F, 0x00008002},
	{0x033, 0x00000026},
	{0x03F, 0x00000003},
	{0x033, 0x00000027},
	{0x03F, 0x00000003},
	{0x033, 0x00000028},
	{0x03F, 0x00050002},
	{0x033, 0x00000029},
	{0x03F, 0x00060032},
	{0x033, 0x0000002A},
	{0x03F, 0x00050042},
	{0x033, 0x0000002B},
	{0x03F, 0x00040042},
	{0x033, 0x0000002C},
	{0x03F, 0x00008001},
	{0x033, 0x0000002D},
	{0x03F, 0x00008002},
	{0x033, 0x0000002E},
	{0x03F, 0x00000003},
	{0x033, 0x0000002F},
	{0x03F, 0x00000003},
	{0x033, 0x00000030},
	{0x03F, 0x00050002},
	{0x033, 0x00000031},
	{0x03F, 0x00060032},
	{0x033, 0x00000032},
	{0x03F, 0x00050042},
	{0x033, 0x00000033},
	{0x03F, 0x00040042},
	{0x033, 0x00000034},
	{0x03F, 0x00008001},
	{0x033, 0x00000035},
	{0x03F, 0x00008002},
	{0x033, 0x00000036},
	{0x03F, 0x00000003},
	{0x033, 0x00000037},
	{0x03F, 0x00000003},
	{0x033, 0x00000060},
	{0x03F, 0x00050002},
	{0x033, 0x00000061},
	{0x03F, 0x00060032},
	{0x033, 0x00000062},
	{0x03F, 0x00050042},
	{0x033, 0x00000063},
	{0x03F, 0x00040042},
	{0x033, 0x00000064},
	{0x03F, 0x00008001},
	{0x033, 0x00000065},
	{0x03F, 0x00008002},
	{0x033, 0x00000066},
	{0x03F, 0x00000003},
	{0x033, 0x00000067},
	{0x03F, 0x00000003},
	{0x033, 0x00000068},
	{0x03F, 0x00050002},
	{0x033, 0x00000069},
	{0x03F, 0x00060032},
	{0x033, 0x0000006A},
	{0x03F, 0x00050042},
	{0x033, 0x0000006B},
	{0x03F, 0x00040042},
	{0x033, 0x0000006C},
	{0x03F, 0x00008001},
	{0x033, 0x0000006D},
	{0x03F, 0x00008002},
	{0x033, 0x0000006E},
	{0x03F, 0x00000003},
	{0x033, 0x0000006F},
	{0x03F, 0x00000003},
	{0x033, 0x00000070},
	{0x03F, 0x00050002},
	{0x033, 0x00000071},
	{0x03F, 0x00060032},
	{0x033, 0x00000072},
	{0x03F, 0x00050042},
	{0x033, 0x00000073},
	{0x03F, 0x00040042},
	{0x033, 0x00000074},
	{0x03F, 0x00008001},
	{0x033, 0x00000075},
	{0x03F, 0x00008002},
	{0x033, 0x00000076},
	{0x03F, 0x00000003},
	{0x033, 0x00000077},
	{0x03F, 0x00000003},
	{0x033, 0x00000078},
	{0x03F, 0x00050002},
	{0x033, 0x00000079},
	{0x03F, 0x00060032},
	{0x033, 0x0000007A},
	{0x03F, 0x00050042},
	{0x033, 0x0000007B},
	{0x03F, 0x00040042},
	{0x033, 0x0000007C},
	{0x03F, 0x00008001},
	{0x033, 0x0000007D},
	{0x03F, 0x00008002},
	{0x033, 0x0000007E},
	{0x03F, 0x00000003},
	{0x033, 0x0000007F},
	{0x03F, 0x00000003},
	{0x033, 0x000000A0},
	{0x03F, 0x00050002},
	{0x033, 0x000000A1},
	{0x03F, 0x00060032},
	{0x033, 0x000000A2},
	{0x03F, 0x00050042},
	{0x033, 0x000000A3},
	{0x03F, 0x00040042},
	{0x033, 0x000000A4},
	{0x03F, 0x00008001},
	{0x033, 0x000000A5},
	{0x03F, 0x00008002},
	{0x033, 0x000000A6},
	{0x03F, 0x00000003},
	{0x033, 0x000000A7},
	{0x03F, 0x00000003},
	{0x033, 0x000000A8},
	{0x03F, 0x00050002},
	{0x033, 0x000000A9},
	{0x03F, 0x00060032},
	{0x033, 0x000000AA},
	{0x03F, 0x00050042},
	{0x033, 0x000000AB},
	{0x03F, 0x00040042},
	{0x033, 0x000000AC},
	{0x03F, 0x00008001},
	{0x033, 0x000000AD},
	{0x03F, 0x00008002},
	{0x033, 0x000000AE},
	{0x03F, 0x00000003},
	{0x033, 0x000000AF},
	{0x03F, 0x00000003},
	{0x033, 0x000000B0},
	{0x03F, 0x00050002},
	{0x033, 0x000000B1},
	{0x03F, 0x00060032},
	{0x033, 0x000000B2},
	{0x03F, 0x00050042},
	{0x033, 0x000000B3},
	{0x03F, 0x00040042},
	{0x033, 0x000000B4},
	{0x03F, 0x00008001},
	{0x033, 0x000000B5},
	{0x03F, 0x00008002},
	{0x033, 0x000000B6},
	{0x03F, 0x00000003},
	{0x033, 0x000000B7},
	{0x03F, 0x00000003},
	{0x033, 0x000000E0},
	{0x03F, 0x00050002},
	{0x033, 0x000000E1},
	{0x03F, 0x00060032},
	{0x033, 0x000000E2},
	{0x03F, 0x00050042},
	{0x033, 0x000000E3},
	{0x03F, 0x00040042},
	{0x033, 0x000000E4},
	{0x03F, 0x00008001},
	{0x033, 0x000000E5},
	{0x03F, 0x00008002},
	{0x033, 0x000000E6},
	{0x03F, 0x00000003},
	{0x033, 0x000000E7},
	{0x03F, 0x00000003},
	{0x033, 0x000000E8},
	{0x03F, 0x00050002},
	{0x033, 0x000000E9},
	{0x03F, 0x00060032},
	{0x033, 0x000000EA},
	{0x03F, 0x00050042},
	{0x033, 0x000000EB},
	{0x03F, 0x00040042},
	{0x033, 0x000000EC},
	{0x03F, 0x00008001},
	{0x033, 0x000000ED},
	{0x03F, 0x00008002},
	{0x033, 0x000000EE},
	{0x03F, 0x00000003},
	{0x033, 0x000000EF},
	{0x03F, 0x00000003},
	{0x033, 0x000000F0},
	{0x03F, 0x00050002},
	{0x033, 0x000000F1},
	{0x03F, 0x00060032},
	{0x033, 0x000000F2},
	{0x03F, 0x00050042},
	{0x033, 0x000000F3},
	{0x03F, 0x00040042},
	{0x033, 0x000000F4},
	{0x03F, 0x00008001},
	{0x033, 0x000000F5},
	{0x03F, 0x00008002},
	{0x033, 0x000000F6},
	{0x03F, 0x00000003},
	{0x033, 0x000000F7},
	{0x03F, 0x00000003},
	{0x033, 0x000000F8},
	{0x03F, 0x00050002},
	{0x033, 0x000000F9},
	{0x03F, 0x00060032},
	{0x033, 0x000000FA},
	{0x03F, 0x00050042},
	{0x033, 0x000000FB},
	{0x03F, 0x00040042},
	{0x033, 0x000000FC},
	{0x03F, 0x00008001},
	{0x033, 0x000000FD},
	{0x03F, 0x00008002},
	{0x033, 0x000000FE},
	{0x03F, 0x00000003},
	{0x033, 0x000000FF},
	{0x03F, 0x00000003},
	{0x033, 0x00000120},
	{0x03F, 0x00050002},
	{0x033, 0x00000121},
	{0x03F, 0x00060032},
	{0x033, 0x00000122},
	{0x03F, 0x00050042},
	{0x033, 0x00000123},
	{0x03F, 0x00040042},
	{0x033, 0x00000124},
	{0x03F, 0x00008001},
	{0x033, 0x00000125},
	{0x03F, 0x00008002},
	{0x033, 0x00000126},
	{0x03F, 0x00000003},
	{0x033, 0x00000127},
	{0x03F, 0x00000003},
	{0x033, 0x00000128},
	{0x03F, 0x00050002},
	{0x033, 0x00000129},
	{0x03F, 0x00060032},
	{0x033, 0x0000012A},
	{0x03F, 0x00050042},
	{0x033, 0x0000012B},
	{0x03F, 0x00040042},
	{0x033, 0x0000012C},
	{0x03F, 0x00008001},
	{0x033, 0x0000012D},
	{0x03F, 0x00008002},
	{0x033, 0x0000012E},
	{0x03F, 0x00000003},
	{0x033, 0x0000012F},
	{0x03F, 0x00000003},
	{0x033, 0x00000130},
	{0x03F, 0x00050002},
	{0x033, 0x00000131},
	{0x03F, 0x00060032},
	{0x033, 0x00000132},
	{0x03F, 0x00050042},
	{0x033, 0x00000133},
	{0x03F, 0x00040042},
	{0x033, 0x00000134},
	{0x03F, 0x00008001},
	{0x033, 0x00000135},
	{0x03F, 0x00008002},
	{0x033, 0x00000136},
	{0x03F, 0x00000003},
	{0x033, 0x00000137},
	{0x03F, 0x00000003},
	{0x033, 0x00000160},
	{0x03F, 0x00050002},
	{0x033, 0x00000161},
	{0x03F, 0x00060032},
	{0x033, 0x00000162},
	{0x03F, 0x00050042},
	{0x033, 0x00000163},
	{0x03F, 0x00040042},
	{0x033, 0x00000164},
	{0x03F, 0x00008001},
	{0x033, 0x00000165},
	{0x03F, 0x00008002},
	{0x033, 0x00000166},
	{0x03F, 0x00000003},
	{0x033, 0x00000167},
	{0x03F, 0x00000003},
	{0x033, 0x00000168},
	{0x03F, 0x00050002},
	{0x033, 0x00000169},
	{0x03F, 0x00060032},
	{0x033, 0x0000016A},
	{0x03F, 0x00050042},
	{0x033, 0x0000016B},
	{0x03F, 0x00040042},
	{0x033, 0x0000016C},
	{0x03F, 0x00008001},
	{0x033, 0x0000016D},
	{0x03F, 0x00008002},
	{0x033, 0x0000016E},
	{0x03F, 0x00000003},
	{0x033, 0x0000016F},
	{0x03F, 0x00000003},
	{0x033, 0x00000170},
	{0x03F, 0x00050002},
	{0x033, 0x00000171},
	{0x03F, 0x00060032},
	{0x033, 0x00000172},
	{0x03F, 0x00050042},
	{0x033, 0x00000173},
	{0x03F, 0x00040042},
	{0x033, 0x00000174},
	{0x03F, 0x00008001},
	{0x033, 0x00000175},
	{0x03F, 0x00008002},
	{0x033, 0x00000176},
	{0x03F, 0x00000003},
	{0x033, 0x00000177},
	{0x03F, 0x00000003},
	{0x033, 0x00000178},
	{0x03F, 0x00050002},
	{0x033, 0x00000179},
	{0x03F, 0x00060032},
	{0x033, 0x0000017A},
	{0x03F, 0x00050042},
	{0x033, 0x0000017B},
	{0x03F, 0x00040042},
	{0x033, 0x0000017C},
	{0x03F, 0x00008001},
	{0x033, 0x0000017D},
	{0x03F, 0x00008002},
	{0x033, 0x0000017E},
	{0x03F, 0x00000003},
	{0x033, 0x0000017F},
	{0x03F, 0x00000003},
	{0x033, 0x000001A0},
	{0x03F, 0x00050002},
	{0x033, 0x000001A1},
	{0x03F, 0x00060032},
	{0x033, 0x000001A2},
	{0x03F, 0x00050042},
	{0x033, 0x000001A3},
	{0x03F, 0x00040042},
	{0x033, 0x000001A4},
	{0x03F, 0x00008001},
	{0x033, 0x000001A5},
	{0x03F, 0x00008002},
	{0x033, 0x000001A6},
	{0x03F, 0x00000003},
	{0x033, 0x000001A7},
	{0x03F, 0x00000003},
	{0x033, 0x000001A8},
	{0x03F, 0x00050002},
	{0x033, 0x000001A9},
	{0x03F, 0x00060032},
	{0x033, 0x000001AA},
	{0x03F, 0x00050042},
	{0x033, 0x000001AB},
	{0x03F, 0x00040042},
	{0x033, 0x000001AC},
	{0x03F, 0x00008001},
	{0x033, 0x000001AD},
	{0x03F, 0x00008002},
	{0x033, 0x000001AE},
	{0x03F, 0x00000003},
	{0x033, 0x000001AF},
	{0x03F, 0x00000003},
	{0x033, 0x000001B0},
	{0x03F, 0x00050002},
	{0x033, 0x000001B1},
	{0x03F, 0x00060032},
	{0x033, 0x000001B2},
	{0x03F, 0x00050042},
	{0x033, 0x000001B3},
	{0x03F, 0x00040042},
	{0x033, 0x000001B4},
	{0x03F, 0x00008001},
	{0x033, 0x000001B5},
	{0x03F, 0x00008002},
	{0x033, 0x000001B6},
	{0x03F, 0x00000003},
	{0x033, 0x000001B7},
	{0x03F, 0x00000003},
	{0x033, 0x000001E0},
	{0x03F, 0x00050002},
	{0x033, 0x000001E1},
	{0x03F, 0x00060032},
	{0x033, 0x000001E2},
	{0x03F, 0x00050042},
	{0x033, 0x000001E3},
	{0x03F, 0x00040042},
	{0x033, 0x000001E4},
	{0x03F, 0x00008001},
	{0x033, 0x000001E5},
	{0x03F, 0x00008002},
	{0x033, 0x000001E6},
	{0x03F, 0x00000003},
	{0x033, 0x000001E7},
	{0x03F, 0x00000003},
	{0x033, 0x000001E8},
	{0x03F, 0x00050002},
	{0x033, 0x000001E9},
	{0x03F, 0x00060032},
	{0x033, 0x000001EA},
	{0x03F, 0x00050042},
	{0x033, 0x000001EB},
	{0x03F, 0x00040042},
	{0x033, 0x000001EC},
	{0x03F, 0x00008001},
	{0x033, 0x000001ED},
	{0x03F, 0x00008002},
	{0x033, 0x000001EE},
	{0x03F, 0x00000003},
	{0x033, 0x000001EF},
	{0x03F, 0x00000003},
	{0x033, 0x000001F0},
	{0x03F, 0x00050002},
	{0x033, 0x000001F1},
	{0x03F, 0x00060032},
	{0x033, 0x000001F2},
	{0x03F, 0x00050042},
	{0x033, 0x000001F3},
	{0x03F, 0x00040042},
	{0x033, 0x000001F4},
	{0x03F, 0x00008001},
	{0x033, 0x000001F5},
	{0x03F, 0x00008002},
	{0x033, 0x000001F6},
	{0x03F, 0x00000003},
	{0x033, 0x000001F7},
	{0x03F, 0x00000003},
	{0x033, 0x000001F8},
	{0x03F, 0x00050002},
	{0x033, 0x000001F9},
	{0x03F, 0x00060032},
	{0x033, 0x000001FA},
	{0x03F, 0x00050042},
	{0x033, 0x000001FB},
	{0x03F, 0x00040042},
	{0x033, 0x000001FC},
	{0x03F, 0x00008001},
	{0x033, 0x000001FD},
	{0x03F, 0x00008002},
	{0x033, 0x000001FE},
	{0x03F, 0x00000003},
	{0x033, 0x000001FF},
	{0x03F, 0x00000003},
	{0x0EF, 0x00000000},
	{0x005, 0x00000001},
	{0x10005, 0x00000001},
	{0x100EE, 0x00000400},
	{0x10030, 0x00000000},
	{0x10030, 0x00001000},
	{0x10030, 0x00002000},
	{0x10030, 0x00003000},
	{0x10030, 0x00004000},
	{0x10030, 0x00005000},
	{0x10030, 0x00006003},
	{0x10030, 0x00007003},
	{0x10030, 0x00008000},
	{0x10030, 0x00009000},
	{0x10030, 0x0000A000},
	{0x10030, 0x0000B000},
	{0x10030, 0x0000C000},
	{0x10030, 0x0000D000},
	{0x10030, 0x0000E003},
	{0x10030, 0x0000F003},
	{0x10030, 0x00010000},
	{0x10030, 0x00011000},
	{0x10030, 0x00012000},
	{0x10030, 0x00013000},
	{0x10030, 0x00014000},
	{0x10030, 0x00015000},
	{0x10030, 0x00016003},
	{0x10030, 0x00017003},
	{0x10030, 0x00018000},
	{0x10030, 0x00019000},
	{0x10030, 0x0001A000},
	{0x10030, 0x0001B000},
	{0x10030, 0x0001C000},
	{0x10030, 0x0001D000},
	{0x10030, 0x0001E003},
	{0x10030, 0x0001F003},
	{0x10030, 0x00020000},
	{0x10030, 0x00021000},
	{0x10030, 0x00022000},
	{0x10030, 0x00023000},
	{0x10030, 0x00024000},
	{0x10030, 0x00025000},
	{0x10030, 0x00026003},
	{0x10030, 0x00027003},
	{0x10030, 0x00028000},
	{0x10030, 0x00029000},
	{0x10030, 0x0002A000},
	{0x10030, 0x0002B000},
	{0x10030, 0x0002C000},
	{0x10030, 0x0002D000},
	{0x10030, 0x0002E003},
	{0x10030, 0x0002F003},
	{0x10030, 0x00030000},
	{0x10030, 0x00031000},
	{0x10030, 0x00032000},
	{0x10030, 0x00033000},
	{0x10030, 0x00034000},
	{0x10030, 0x00035000},
	{0x10030, 0x00036003},
	{0x10030, 0x00037003},
	{0x10030, 0x00038000},
	{0x10030, 0x00039000},
	{0x10030, 0x0003A000},
	{0x10030, 0x0003B000},
	{0x10030, 0x0003C000},
	{0x10030, 0x0003D000},
	{0x10030, 0x0003E003},
	{0x10030, 0x0003F003},
	{0x10030, 0x00060000},
	{0x10030, 0x00061000},
	{0x10030, 0x00062000},
	{0x10030, 0x00063000},
	{0x10030, 0x00064000},
	{0x10030, 0x00065000},
	{0x10030, 0x00066000},
	{0x10030, 0x00067003},
	{0x10030, 0x00068000},
	{0x10030, 0x00069000},
	{0x10030, 0x0006A000},
	{0x10030, 0x0006B000},
	{0x10030, 0x0006C000},
	{0x10030, 0x0006D000},
	{0x10030, 0x0006E000},
	{0x10030, 0x0006F003},
	{0x10030, 0x00070000},
	{0x10030, 0x00071000},
	{0x10030, 0x00072000},
	{0x10030, 0x00073000},
	{0x10030, 0x00074000},
	{0x10030, 0x00075000},
	{0x10030, 0x00076000},
	{0x10030, 0x00077003},
	{0x10030, 0x00078000},
	{0x10030, 0x00079000},
	{0x10030, 0x0007A000},
	{0x10030, 0x0007B000},
	{0x10030, 0x0007C000},
	{0x10030, 0x0007D000},
	{0x10030, 0x0007E000},
	{0x10030, 0x0007F003},
	{0x0ED, 0x00000010},
	{0x033, 0x00000001},
	{0x03F, 0x0000000A},
	{0x033, 0x00000002},
	{0x03F, 0x0000000A},
	{0x033, 0x00000003},
	{0x03F, 0x0000000A},
	{0x033, 0x00000005},
	{0x03F, 0x0000000A},
	{0x033, 0x00000006},
	{0x03F, 0x0000000A},
	{0x033, 0x00000007},
	{0x03F, 0x0000000A},
	{0x0ED, 0x00000000},
	{0x100EE, 0x00000000},
	{0x0FE, 0x00000031},
};

static const struct rtw89_reg2_def rtw89_8852c_phy_nctl_regs[] = {
	{0x8008, 0x00000000},
	{0x8000, 0x00000008},
	{0x8004, 0xf0862966},
	{0x800c, 0x78000000},
	{0x8010, 0x88015000},
	{0x8014, 0x80010100},
	{0x8018, 0x10010100},
	{0x801c, 0xa210bc00},
	{0x8020, 0x000403e0},
	{0x8024, 0x00072160},
	{0x8028, 0x00180e00},
	{0x8030, 0x400000c0},
	{0x8034, 0x11000830},
	{0x8038, 0x00000009},
	{0x803c, 0x00000008},
	{0x8040, 0x00000046},
	{0x8044, 0x0010001f},
	{0x8048, 0xf0000003},
	{0x804c, 0x62ac6162},
	{0x8050, 0xf2acf162},
	{0x8054, 0x62ac6162},
	{0x8058, 0xf2acf162},
	{0x805c, 0x150c0b02},
	{0x8060, 0x150c0b02},
	{0x8064, 0x2aa00047},
	{0x8074, 0x80000000},
	{0x807c, 0x000000ee},
	{0x8088, 0x80000000},
	{0x808c, 0x00000000},
	{0x80b0, 0x00000000},
	{0x80d0, 0x00000000},
	{0x80ec, 0x00000002},
	{0x8098, 0x0000ff00},
	{0x8070, 0x00e80000},
	{0x80b0, 0xffe00fff},
	{0x809c, 0x0000001f},
	{0x80b8, 0x00001000},
	{0x80bc, 0x0005001d},
	{0x810c, 0x33112211},
	{0x8110, 0x33112211},
	{0x8114, 0x00000000},
	{0x8120, 0x10010000},
	{0x8124, 0x00000000},
	{0x8128, 0x00000200},
	{0x812c, 0x0000c000},
	{0x8138, 0x40000000},
	{0x813c, 0x40000000},
	{0x8140, 0x00000000},
	{0x8144, 0x0b040b03},
	{0x8148, 0x0a040b04},
	{0x814c, 0x0a040b04},
	{0x8150, 0xe4e40000},
	{0x8158, 0xffffffff},
	{0x815c, 0xffffffff},
	{0x8160, 0xffffffff},
	{0x8164, 0xffffffff},
	{0x8168, 0xffffffff},
	{0x816c, 0x1fffffff},
	{0x81cc, 0x00000000},
	{0x81dc, 0x00000002},
	{0x81e0, 0x00000000},
	{0x81e4, 0x00000001},
	{0x81a0, 0x00000000},
	{0x81ac, 0x3fc20400},
	{0x81b0, 0x3f914100},
	{0x81bc, 0x0000005b},
	{0x81c0, 0x0000005b},
	{0x81b4, 0x01e0f078},
	{0x81b8, 0x01e0f078},
	{0x81f0, 0x0000f078},
	{0x820c, 0x33112211},
	{0x8210, 0x33112211},
	{0x8214, 0x00000000},
	{0x8220, 0x10010000},
	{0x8224, 0x00000000},
	{0x8228, 0x00000200},
	{0x822c, 0x0000d000},
	{0x8238, 0x40000000},
	{0x823c, 0x40000000},
	{0x8240, 0x00000000},
	{0x8244, 0x0b040b03},
	{0x8248, 0x0a040b04},
	{0x824c, 0x0a040b04},
	{0x8250, 0xe4e40000},
	{0x8258, 0xffffffff},
	{0x825c, 0xffffffff},
	{0x8260, 0xffffffff},
	{0x8264, 0xffffffff},
	{0x8268, 0xffffffff},
	{0x826c, 0x1fffffff},
	{0x82cc, 0x00000000},
	{0x82dc, 0x00000002},
	{0x82e0, 0x00100000},
	{0x82e4, 0x00000001},
	{0x82a0, 0x00000000},
	{0x82ac, 0x3fc20400},
	{0x82b0, 0x3f914100},
	{0x82bc, 0x0000005b},
	{0x82c0, 0x0000005b},
	{0x82b4, 0x01e0f078},
	{0x82b8, 0x01e0f078},
	{0x82f0, 0x0000f078},
	{0x81d8, 0x00000001},
	{0x82d8, 0x00000001},
	{0x9500, 0x00000000},
	{0x9504, 0x00000000},
	{0x9508, 0x00000000},
	{0x950c, 0x00000000},
	{0x9510, 0x00000000},
	{0x9514, 0x00000000},
	{0x9518, 0x00000000},
	{0x951c, 0x00000000},
	{0x9520, 0x00000000},
	{0x9524, 0x00000000},
	{0x9528, 0x00000000},
	{0x952c, 0x00000000},
	{0x9530, 0x00000000},
	{0x9534, 0x00000000},
	{0x9538, 0x00000000},
	{0x953c, 0x00000000},
	{0x9540, 0x04000000},
	{0x9544, 0x00000000},
	{0x9548, 0x00000000},
	{0x954c, 0x00000000},
	{0x9550, 0x00000000},
	{0x9554, 0x00000000},
	{0x9558, 0x00000000},
	{0x955c, 0x00000000},
	{0x9560, 0x00000000},
	{0x9564, 0x00000000},
	{0x9568, 0x00000000},
	{0x956c, 0x00000000},
	{0x9570, 0x00000000},
	{0x9574, 0x00000000},
	{0x9578, 0x00000000},
	{0x957c, 0x00000000},
	{0x9580, 0x00000000},
	{0x9584, 0x04000000},
	{0x9588, 0x00000000},
	{0x958c, 0x00000000},
	{0x9590, 0x00000000},
	{0x9594, 0x00000000},
	{0x9598, 0x00000000},
	{0x959c, 0x00000000},
	{0x95a0, 0x00000000},
	{0x95a4, 0x00000000},
	{0x95a8, 0x00000000},
	{0x95ac, 0x00000000},
	{0x95b0, 0x00000000},
	{0x95b4, 0x00000000},
	{0x95b8, 0x00000000},
	{0x95bc, 0x00000000},
	{0x95c0, 0x00000000},
	{0x95c4, 0x00000000},
	{0x95c8, 0x04000000},
	{0x95cc, 0x00000000},
	{0x95d0, 0x00000000},
	{0x95d4, 0x00000000},
	{0x95d8, 0x00000000},
	{0x95dc, 0x00000000},
	{0x95e0, 0x00000000},
	{0x95e4, 0x00000000},
	{0x95e8, 0x00000000},
	{0x95ec, 0x00000000},
	{0x95f0, 0x00000000},
	{0x95f4, 0x00000000},
	{0x95f8, 0x00000000},
	{0x95fc, 0x00000000},
	{0x9600, 0x00000000},
	{0x9604, 0x00000000},
	{0x9608, 0x00000000},
	{0x960c, 0x04000000},
	{0x9610, 0x00000000},
	{0x9614, 0x00000000},
	{0x9618, 0x00000000},
	{0x961c, 0x00000000},
	{0x9620, 0x00000000},
	{0x9624, 0x00000000},
	{0x9628, 0x00000000},
	{0x962c, 0x00000000},
	{0x9630, 0x00000000},
	{0x9634, 0x00000000},
	{0x9638, 0x00000000},
	{0x963c, 0x00000000},
	{0x9640, 0x00000000},
	{0x9644, 0x00000000},
	{0x9648, 0x00000000},
	{0x964c, 0x00000000},
	{0x9650, 0x04000000},
	{0x9654, 0x00000000},
	{0x9658, 0x00000000},
	{0x965c, 0x00000000},
	{0x9660, 0x00000000},
	{0x9664, 0x00000000},
	{0x9668, 0x00000000},
	{0x966c, 0x00000000},
	{0x9670, 0x00000000},
	{0x9674, 0x00000000},
	{0x9678, 0x00000000},
	{0x967c, 0x00000000},
	{0x9680, 0x00000000},
	{0x9684, 0x00000000},
	{0x9688, 0x00000000},
	{0x968c, 0x00000000},
	{0x9690, 0x00000000},
	{0x9694, 0x04000000},
	{0x9698, 0x00000000},
	{0x969c, 0x00000000},
	{0x96a0, 0x00000000},
	{0x96a4, 0x00000000},
	{0x96a8, 0x00000000},
	{0x96ac, 0x00000000},
	{0x96b0, 0x00000000},
	{0x96b4, 0x00000000},
	{0x96b8, 0x00000000},
	{0x96bc, 0x00000000},
	{0x96c0, 0x00000000},
	{0x96c4, 0x00000000},
	{0x96c8, 0x00000000},
	{0x96cc, 0x00000000},
	{0x96d0, 0x00000000},
	{0x96d4, 0x00000000},
	{0x96d8, 0x04000000},
	{0x96dc, 0x00000000},
	{0x96e0, 0x00000000},
	{0x96e4, 0x00000000},
	{0x96e8, 0x00000000},
	{0x96ec, 0x00000000},
	{0x96f0, 0x00000000},
	{0x96f4, 0x00000000},
	{0x96f8, 0x00000000},
	{0x96fc, 0x00000000},
	{0x9700, 0x00000000},
	{0x9704, 0x00000000},
	{0x9708, 0x00000000},
	{0x970c, 0x00000000},
	{0x9710, 0x00000000},
	{0x9714, 0x00000000},
	{0x9718, 0x00000000},
	{0x971c, 0x04000000},
	{0x9720, 0x00000000},
	{0x9724, 0x00000000},
	{0x9728, 0x00000000},
	{0x972c, 0x00000000},
	{0x9730, 0x00000000},
	{0x9734, 0x00000000},
	{0x9738, 0x00000000},
	{0x973c, 0x00000000},
	{0x9740, 0x00000000},
	{0x9744, 0x00000000},
	{0x9748, 0x00000000},
	{0x974c, 0x00000000},
	{0x9750, 0x00000000},
	{0x9754, 0x00000000},
	{0x9758, 0x00000000},
	{0x975c, 0x00000000},
	{0x9760, 0x04000000},
	{0x9764, 0x00000000},
	{0x9768, 0x00000000},
	{0x976c, 0x00000000},
	{0x9770, 0x00000000},
	{0x9774, 0x00000000},
	{0x9778, 0x00000000},
	{0x977c, 0x00000000},
	{0x9780, 0x00000000},
	{0x9784, 0x00000000},
	{0x9788, 0x00000000},
	{0x978c, 0x00000000},
	{0x9790, 0x00000000},
	{0x9794, 0x00000000},
	{0x9798, 0x00000000},
	{0x979c, 0x00000000},
	{0x97a0, 0x00000000},
	{0x97a4, 0x04000000},
	{0x97a8, 0x00000000},
	{0x97ac, 0x00000000},
	{0x97b0, 0x00000000},
	{0x97b4, 0x00000000},
	{0x97b8, 0x00000000},
	{0x97bc, 0x00000000},
	{0x97c0, 0x00000000},
	{0x97c4, 0x00000000},
	{0x97c8, 0x00000000},
	{0x97cc, 0x00000000},
	{0x97d0, 0x00000000},
	{0x97d4, 0x00000000},
	{0x97d8, 0x00000000},
	{0x97dc, 0x00000000},
	{0x97e0, 0x00000000},
	{0x97e4, 0x00000000},
	{0x97e8, 0x04000000},
	{0x97ec, 0x00000000},
	{0x97f0, 0x00000000},
	{0x97f4, 0x00000000},
	{0x97f8, 0x00000000},
	{0x97fc, 0x00000000},
	{0x9800, 0x00000000},
	{0x9804, 0x00000000},
	{0x9808, 0x00000000},
	{0x980c, 0x00000000},
	{0x9810, 0x00000000},
	{0x9814, 0x00000000},
	{0x9818, 0x00000000},
	{0x981c, 0x00000000},
	{0x9820, 0x00000000},
	{0x9824, 0x00000000},
	{0x9828, 0x00000000},
	{0x982c, 0x04000000},
	{0x9830, 0x00000000},
	{0x9834, 0x00000000},
	{0x9838, 0x00000000},
	{0x983c, 0x00000000},
	{0x9840, 0x00000000},
	{0x9844, 0x00000000},
	{0x9848, 0x00000000},
	{0x984c, 0x00000000},
	{0x9850, 0x00000000},
	{0x9854, 0x00000000},
	{0x9858, 0x00000000},
	{0x985c, 0x00000000},
	{0x9860, 0x00000000},
	{0x9864, 0x00000000},
	{0x9868, 0x00000000},
	{0x986c, 0x00000000},
	{0x9870, 0x04000000},
	{0x9874, 0x00000000},
	{0x9878, 0x00000000},
	{0x987c, 0x00000000},
	{0x9880, 0x00000000},
	{0x9884, 0x00000000},
	{0x9888, 0x00000000},
	{0x988c, 0x00000000},
	{0x9890, 0x00000000},
	{0x9894, 0x00000000},
	{0x9898, 0x00000000},
	{0x989c, 0x00000000},
	{0x98a0, 0x00000000},
	{0x98a4, 0x00000000},
	{0x98a8, 0x00000000},
	{0x98ac, 0x00000000},
	{0x98b0, 0x00000000},
	{0x98b4, 0x04000000},
	{0x98b8, 0x00000000},
	{0x98bc, 0x00000000},
	{0x98c0, 0x00000000},
	{0x98c4, 0x00000000},
	{0x98c8, 0x00000000},
	{0x98cc, 0x00000000},
	{0x98d0, 0x00000000},
	{0x98d4, 0x00000000},
	{0x98d8, 0x00000000},
	{0x98dc, 0x00000000},
	{0x98e0, 0x00000000},
	{0x98e4, 0x00000000},
	{0x98e8, 0x00000000},
	{0x98ec, 0x00000000},
	{0x98f0, 0x00000000},
	{0x98f4, 0x00000000},
	{0x98f8, 0x04000000},
	{0x98fc, 0x00000000},
	{0x9900, 0x00000000},
	{0x9904, 0x00000000},
	{0x9908, 0x00000000},
	{0x990c, 0x00000000},
	{0x9910, 0x00000000},
	{0x9914, 0x00000000},
	{0x9918, 0x00000000},
	{0x991c, 0x00000000},
	{0x9920, 0x00000000},
	{0x9924, 0x00000000},
	{0x9928, 0x00000000},
	{0x992c, 0x00000000},
	{0x9930, 0x00000000},
	{0x9934, 0x00000000},
	{0x9938, 0x00000000},
	{0x993c, 0x04000000},
	{0x9940, 0x00000000},
	{0x9944, 0x00000000},
	{0x9948, 0x00000000},
	{0x994c, 0x00000000},
	{0x9950, 0x00000000},
	{0x9954, 0x00000000},
	{0x9958, 0x00000000},
	{0x995c, 0x00000000},
	{0x9960, 0x00000000},
	{0x9964, 0x00000000},
	{0x9968, 0x00000000},
	{0x996c, 0x00000000},
	{0x9970, 0x00000000},
	{0x9974, 0x00000000},
	{0x9978, 0x00000000},
	{0x997c, 0x00000000},
	{0x9980, 0x04000000},
	{0x9984, 0x00000000},
	{0x9988, 0x00000000},
	{0x998c, 0x00000000},
	{0x9990, 0x00000000},
	{0x9994, 0x00000000},
	{0x9998, 0x00000000},
	{0x999c, 0x00000000},
	{0x99a0, 0x00000000},
	{0x99a4, 0x00000000},
	{0x99a8, 0x00000000},
	{0x99ac, 0x00000000},
	{0x99b0, 0x00000000},
	{0x99b4, 0x00000000},
	{0x99b8, 0x00000000},
	{0x99bc, 0x00000000},
	{0x99c0, 0x00000000},
	{0x99c4, 0x04000000},
	{0x99c8, 0x00000000},
	{0x99cc, 0x00000000},
	{0x99d0, 0x00000000},
	{0x99d4, 0x00000000},
	{0x99d8, 0x00000000},
	{0x99dc, 0x00000000},
	{0x99e0, 0x00000000},
	{0x99e4, 0x00000000},
	{0x99e8, 0x00000000},
	{0x99ec, 0x00000000},
	{0x99f0, 0x00000000},
	{0x99f4, 0x00000000},
	{0x99f8, 0x00000000},
	{0x99fc, 0x00000000},
	{0x9a00, 0x00000000},
	{0x9a04, 0x00000000},
	{0x9a08, 0x04000000},
	{0x9a0c, 0x00000000},
	{0x9a10, 0x00000000},
	{0x9a14, 0x00000000},
	{0x9a18, 0x00000000},
	{0x9a1c, 0x00000000},
	{0x9a20, 0x00000000},
	{0x9a24, 0x00000000},
	{0x9a28, 0x00000000},
	{0x9a2c, 0x00000000},
	{0x9a30, 0x00000000},
	{0x9a34, 0x00000000},
	{0x9a38, 0x00000000},
	{0x9a3c, 0x00000000},
	{0x9a40, 0x00000000},
	{0x9a44, 0x00000000},
	{0x9a48, 0x00000000},
	{0x9a4c, 0x04000000},
	{0x9a50, 0x00000000},
	{0x9a54, 0x00000000},
	{0x9a58, 0x00000000},
	{0x9a5c, 0x00000000},
	{0x9a60, 0x00000000},
	{0x9a64, 0x00000000},
	{0x9a68, 0x00000000},
	{0x9a6c, 0x00000000},
	{0x9a70, 0x00000000},
	{0x9a74, 0x00000000},
	{0x9a78, 0x00000000},
	{0x9a7c, 0x00000000},
	{0x9a80, 0x00000000},
	{0x9a84, 0x00000000},
	{0x9a88, 0x00000000},
	{0x9a8c, 0x00000000},
	{0x9a90, 0x04000000},
	{0x9a94, 0x00000000},
	{0x9a98, 0x00000000},
	{0x9a9c, 0x00000000},
	{0x9aa0, 0x00000000},
	{0x9aa4, 0x00000000},
	{0x9aa8, 0x00000000},
	{0x9aac, 0x00000000},
	{0x9ab0, 0x00000000},
	{0x9ab4, 0x00000000},
	{0x9ab8, 0x00000000},
	{0x9abc, 0x00000000},
	{0x9ac0, 0x00000000},
	{0x9ac4, 0x00000000},
	{0x9ac8, 0x00000000},
	{0x9acc, 0x00000000},
	{0x9ad0, 0x00000000},
	{0x9ad4, 0x04000000},
	{0x9ad8, 0x00000000},
	{0x9adc, 0x00000000},
	{0x9ae0, 0x00000000},
	{0x9ae4, 0x00000000},
	{0x9ae8, 0x00000000},
	{0x9aec, 0x00000000},
	{0x9af0, 0x00000000},
	{0x9af4, 0x00000000},
	{0x9af8, 0x00000000},
	{0x9afc, 0x00000000},
	{0x9b00, 0x00000000},
	{0x9b04, 0x00000000},
	{0x9b08, 0x00000000},
	{0x9b0c, 0x00000000},
	{0x9b10, 0x00000000},
	{0x9b14, 0x00000000},
	{0x9b18, 0x04000000},
	{0x9b1c, 0x00000000},
	{0x9b20, 0x00000000},
	{0x9b24, 0x00000000},
	{0x9b28, 0x00000000},
	{0x9b2c, 0x00000000},
	{0x9b30, 0x00000000},
	{0x9b34, 0x00000000},
	{0x9b38, 0x00000000},
	{0x9b3c, 0x00000000},
	{0x9b40, 0x00000000},
	{0x9b44, 0x00000000},
	{0x9b48, 0x00000000},
	{0x9b4c, 0x00000000},
	{0x9b50, 0x00000000},
	{0x9b54, 0x00000000},
	{0x9b58, 0x00000000},
	{0x9b5c, 0x04000000},
	{0x9d00, 0x00000000},
	{0x9d04, 0x00000000},
	{0x9d08, 0x00000000},
	{0x9d0c, 0x00000000},
	{0x9d10, 0x00000000},
	{0x9d14, 0x00000000},
	{0x9d18, 0x00000000},
	{0x9d1c, 0x00000000},
	{0x9d20, 0x00000000},
	{0x9d24, 0x00000000},
	{0x9d28, 0x00000000},
	{0x9d2c, 0x00000000},
	{0x9d30, 0x00000000},
	{0x9d34, 0x00000000},
	{0x9d38, 0x00000000},
	{0x9d3c, 0x00000000},
	{0x9d40, 0x04000000},
	{0x9d44, 0x00000000},
	{0x9d48, 0x00000000},
	{0x9d4c, 0x00000000},
	{0x9d50, 0x00000000},
	{0x9d54, 0x00000000},
	{0x9d58, 0x00000000},
	{0x9d5c, 0x00000000},
	{0x9d60, 0x00000000},
	{0x9d64, 0x00000000},
	{0x9d68, 0x00000000},
	{0x9d6c, 0x00000000},
	{0x9d70, 0x00000000},
	{0x9d74, 0x00000000},
	{0x9d78, 0x00000000},
	{0x9d7c, 0x00000000},
	{0x9d80, 0x00000000},
	{0x9d84, 0x04000000},
	{0x9d88, 0x00000000},
	{0x9d8c, 0x00000000},
	{0x9d90, 0x00000000},
	{0x9d94, 0x00000000},
	{0x9d98, 0x00000000},
	{0x9d9c, 0x00000000},
	{0x9da0, 0x00000000},
	{0x9da4, 0x00000000},
	{0x9da8, 0x00000000},
	{0x9dac, 0x00000000},
	{0x9db0, 0x00000000},
	{0x9db4, 0x00000000},
	{0x9db8, 0x00000000},
	{0x9dbc, 0x00000000},
	{0x9dc0, 0x00000000},
	{0x9dc4, 0x00000000},
	{0x9dc8, 0x04000000},
	{0x9dcc, 0x00000000},
	{0x9dd0, 0x00000000},
	{0x9dd4, 0x00000000},
	{0x9dd8, 0x00000000},
	{0x9ddc, 0x00000000},
	{0x9de0, 0x00000000},
	{0x9de4, 0x00000000},
	{0x9de8, 0x00000000},
	{0x9dec, 0x00000000},
	{0x9df0, 0x00000000},
	{0x9df4, 0x00000000},
	{0x9df8, 0x00000000},
	{0x9dfc, 0x00000000},
	{0x9e00, 0x00000000},
	{0x9e04, 0x00000000},
	{0x9e08, 0x00000000},
	{0x9e0c, 0x04000000},
	{0x9e10, 0x00000000},
	{0x9e14, 0x00000000},
	{0x9e18, 0x00000000},
	{0x9e1c, 0x00000000},
	{0x9e20, 0x00000000},
	{0x9e24, 0x00000000},
	{0x9e28, 0x00000000},
	{0x9e2c, 0x00000000},
	{0x9e30, 0x00000000},
	{0x9e34, 0x00000000},
	{0x9e38, 0x00000000},
	{0x9e3c, 0x00000000},
	{0x9e40, 0x00000000},
	{0x9e44, 0x00000000},
	{0x9e48, 0x00000000},
	{0x9e4c, 0x00000000},
	{0x9e50, 0x04000000},
	{0x9e54, 0x00000000},
	{0x9e58, 0x00000000},
	{0x9e5c, 0x00000000},
	{0x9e60, 0x00000000},
	{0x9e64, 0x00000000},
	{0x9e68, 0x00000000},
	{0x9e6c, 0x00000000},
	{0x9e70, 0x00000000},
	{0x9e74, 0x00000000},
	{0x9e78, 0x00000000},
	{0x9e7c, 0x00000000},
	{0x9e80, 0x00000000},
	{0x9e84, 0x00000000},
	{0x9e88, 0x00000000},
	{0x9e8c, 0x00000000},
	{0x9e90, 0x00000000},
	{0x9e94, 0x04000000},
	{0x9e98, 0x00000000},
	{0x9e9c, 0x00000000},
	{0x9ea0, 0x00000000},
	{0x9ea4, 0x00000000},
	{0x9ea8, 0x00000000},
	{0x9eac, 0x00000000},
	{0x9eb0, 0x00000000},
	{0x9eb4, 0x00000000},
	{0x9eb8, 0x00000000},
	{0x9ebc, 0x00000000},
	{0x9ec0, 0x00000000},
	{0x9ec4, 0x00000000},
	{0x9ec8, 0x00000000},
	{0x9ecc, 0x00000000},
	{0x9ed0, 0x00000000},
	{0x9ed4, 0x00000000},
	{0x9ed8, 0x04000000},
	{0x9edc, 0x00000000},
	{0x9ee0, 0x00000000},
	{0x9ee4, 0x00000000},
	{0x9ee8, 0x00000000},
	{0x9eec, 0x00000000},
	{0x9ef0, 0x00000000},
	{0x9ef4, 0x00000000},
	{0x9ef8, 0x00000000},
	{0x9efc, 0x00000000},
	{0x9f00, 0x00000000},
	{0x9f04, 0x00000000},
	{0x9f08, 0x00000000},
	{0x9f0c, 0x00000000},
	{0x9f10, 0x00000000},
	{0x9f14, 0x00000000},
	{0x9f18, 0x00000000},
	{0x9f1c, 0x04000000},
	{0x9f20, 0x00000000},
	{0x9f24, 0x00000000},
	{0x9f28, 0x00000000},
	{0x9f2c, 0x00000000},
	{0x9f30, 0x00000000},
	{0x9f34, 0x00000000},
	{0x9f38, 0x00000000},
	{0x9f3c, 0x00000000},
	{0x9f40, 0x00000000},
	{0x9f44, 0x00000000},
	{0x9f48, 0x00000000},
	{0x9f4c, 0x00000000},
	{0x9f50, 0x00000000},
	{0x9f54, 0x00000000},
	{0x9f58, 0x00000000},
	{0x9f5c, 0x00000000},
	{0x9f60, 0x04000000},
	{0x9f64, 0x00000000},
	{0x9f68, 0x00000000},
	{0x9f6c, 0x00000000},
	{0x9f70, 0x00000000},
	{0x9f74, 0x00000000},
	{0x9f78, 0x00000000},
	{0x9f7c, 0x00000000},
	{0x9f80, 0x00000000},
	{0x9f84, 0x00000000},
	{0x9f88, 0x00000000},
	{0x9f8c, 0x00000000},
	{0x9f90, 0x00000000},
	{0x9f94, 0x00000000},
	{0x9f98, 0x00000000},
	{0x9f9c, 0x00000000},
	{0x9fa0, 0x00000000},
	{0x9fa4, 0x04000000},
	{0x9fa8, 0x00000000},
	{0x9fac, 0x00000000},
	{0x9fb0, 0x00000000},
	{0x9fb4, 0x00000000},
	{0x9fb8, 0x00000000},
	{0x9fbc, 0x00000000},
	{0x9fc0, 0x00000000},
	{0x9fc4, 0x00000000},
	{0x9fc8, 0x00000000},
	{0x9fcc, 0x00000000},
	{0x9fd0, 0x00000000},
	{0x9fd4, 0x00000000},
	{0x9fd8, 0x00000000},
	{0x9fdc, 0x00000000},
	{0x9fe0, 0x00000000},
	{0x9fe4, 0x00000000},
	{0x9fe8, 0x04000000},
	{0x9fec, 0x00000000},
	{0x9ff0, 0x00000000},
	{0x9ff4, 0x00000000},
	{0x9ff8, 0x00000000},
	{0x9ffc, 0x00000000},
	{0xa000, 0x00000000},
	{0xa004, 0x00000000},
	{0xa008, 0x00000000},
	{0xa00c, 0x00000000},
	{0xa010, 0x00000000},
	{0xa014, 0x00000000},
	{0xa018, 0x00000000},
	{0xa01c, 0x00000000},
	{0xa020, 0x00000000},
	{0xa024, 0x00000000},
	{0xa028, 0x00000000},
	{0xa02c, 0x04000000},
	{0xa030, 0x00000000},
	{0xa034, 0x00000000},
	{0xa038, 0x00000000},
	{0xa03c, 0x00000000},
	{0xa040, 0x00000000},
	{0xa044, 0x00000000},
	{0xa048, 0x00000000},
	{0xa04c, 0x00000000},
	{0xa050, 0x00000000},
	{0xa054, 0x00000000},
	{0xa058, 0x00000000},
	{0xa05c, 0x00000000},
	{0xa060, 0x00000000},
	{0xa064, 0x00000000},
	{0xa068, 0x00000000},
	{0xa06c, 0x00000000},
	{0xa070, 0x04000000},
	{0xa074, 0x00000000},
	{0xa078, 0x00000000},
	{0xa07c, 0x00000000},
	{0xa080, 0x00000000},
	{0xa084, 0x00000000},
	{0xa088, 0x00000000},
	{0xa08c, 0x00000000},
	{0xa090, 0x00000000},
	{0xa094, 0x00000000},
	{0xa098, 0x00000000},
	{0xa09c, 0x00000000},
	{0xa0a0, 0x00000000},
	{0xa0a4, 0x00000000},
	{0xa0a8, 0x00000000},
	{0xa0ac, 0x00000000},
	{0xa0b0, 0x00000000},
	{0xa0b4, 0x04000000},
	{0xa0b8, 0x00000000},
	{0xa0bc, 0x00000000},
	{0xa0c0, 0x00000000},
	{0xa0c4, 0x00000000},
	{0xa0c8, 0x00000000},
	{0xa0cc, 0x00000000},
	{0xa0d0, 0x00000000},
	{0xa0d4, 0x00000000},
	{0xa0d8, 0x00000000},
	{0xa0dc, 0x00000000},
	{0xa0e0, 0x00000000},
	{0xa0e4, 0x00000000},
	{0xa0e8, 0x00000000},
	{0xa0ec, 0x00000000},
	{0xa0f0, 0x00000000},
	{0xa0f4, 0x00000000},
	{0xa0f8, 0x04000000},
	{0xa0fc, 0x00000000},
	{0xa100, 0x00000000},
	{0xa104, 0x00000000},
	{0xa108, 0x00000000},
	{0xa10c, 0x00000000},
	{0xa110, 0x00000000},
	{0xa114, 0x00000000},
	{0xa118, 0x00000000},
	{0xa11c, 0x00000000},
	{0xa120, 0x00000000},
	{0xa124, 0x00000000},
	{0xa128, 0x00000000},
	{0xa12c, 0x00000000},
	{0xa130, 0x00000000},
	{0xa134, 0x00000000},
	{0xa138, 0x00000000},
	{0xa13c, 0x04000000},
	{0xa140, 0x00000000},
	{0xa144, 0x00000000},
	{0xa148, 0x00000000},
	{0xa14c, 0x00000000},
	{0xa150, 0x00000000},
	{0xa154, 0x00000000},
	{0xa158, 0x00000000},
	{0xa15c, 0x00000000},
	{0xa160, 0x00000000},
	{0xa164, 0x00000000},
	{0xa168, 0x00000000},
	{0xa16c, 0x00000000},
	{0xa170, 0x00000000},
	{0xa174, 0x00000000},
	{0xa178, 0x00000000},
	{0xa17c, 0x00000000},
	{0xa180, 0x04000000},
	{0xa184, 0x00000000},
	{0xa188, 0x00000000},
	{0xa18c, 0x00000000},
	{0xa190, 0x00000000},
	{0xa194, 0x00000000},
	{0xa198, 0x00000000},
	{0xa19c, 0x00000000},
	{0xa1a0, 0x00000000},
	{0xa1a4, 0x00000000},
	{0xa1a8, 0x00000000},
	{0xa1ac, 0x00000000},
	{0xa1b0, 0x00000000},
	{0xa1b4, 0x00000000},
	{0xa1b8, 0x00000000},
	{0xa1bc, 0x00000000},
	{0xa1c0, 0x00000000},
	{0xa1c4, 0x04000000},
	{0xa1c8, 0x00000000},
	{0xa1cc, 0x00000000},
	{0xa1d0, 0x00000000},
	{0xa1d4, 0x00000000},
	{0xa1d8, 0x00000000},
	{0xa1dc, 0x00000000},
	{0xa1e0, 0x00000000},
	{0xa1e4, 0x00000000},
	{0xa1e8, 0x00000000},
	{0xa1ec, 0x00000000},
	{0xa1f0, 0x00000000},
	{0xa1f4, 0x00000000},
	{0xa1f8, 0x00000000},
	{0xa1fc, 0x00000000},
	{0xa200, 0x00000000},
	{0xa204, 0x00000000},
	{0xa208, 0x04000000},
	{0xa20c, 0x00000000},
	{0xa210, 0x00000000},
	{0xa214, 0x00000000},
	{0xa218, 0x00000000},
	{0xa21c, 0x00000000},
	{0xa220, 0x00000000},
	{0xa224, 0x00000000},
	{0xa228, 0x00000000},
	{0xa22c, 0x00000000},
	{0xa230, 0x00000000},
	{0xa234, 0x00000000},
	{0xa238, 0x00000000},
	{0xa23c, 0x00000000},
	{0xa240, 0x00000000},
	{0xa244, 0x00000000},
	{0xa248, 0x00000000},
	{0xa24c, 0x04000000},
	{0xa250, 0x00000000},
	{0xa254, 0x00000000},
	{0xa258, 0x00000000},
	{0xa25c, 0x00000000},
	{0xa260, 0x00000000},
	{0xa264, 0x00000000},
	{0xa268, 0x00000000},
	{0xa26c, 0x00000000},
	{0xa270, 0x00000000},
	{0xa274, 0x00000000},
	{0xa278, 0x00000000},
	{0xa27c, 0x00000000},
	{0xa280, 0x00000000},
	{0xa284, 0x00000000},
	{0xa288, 0x00000000},
	{0xa28c, 0x00000000},
	{0xa290, 0x04000000},
	{0xa294, 0x00000000},
	{0xa298, 0x00000000},
	{0xa29c, 0x00000000},
	{0xa2a0, 0x00000000},
	{0xa2a4, 0x00000000},
	{0xa2a8, 0x00000000},
	{0xa2ac, 0x00000000},
	{0xa2b0, 0x00000000},
	{0xa2b4, 0x00000000},
	{0xa2b8, 0x00000000},
	{0xa2bc, 0x00000000},
	{0xa2c0, 0x00000000},
	{0xa2c4, 0x00000000},
	{0xa2c8, 0x00000000},
	{0xa2cc, 0x00000000},
	{0xa2d0, 0x00000000},
	{0xa2d4, 0x04000000},
	{0xa2d8, 0x00000000},
	{0xa2dc, 0x00000000},
	{0xa2e0, 0x00000000},
	{0xa2e4, 0x00000000},
	{0xa2e8, 0x00000000},
	{0xa2ec, 0x00000000},
	{0xa2f0, 0x00000000},
	{0xa2f4, 0x00000000},
	{0xa2f8, 0x00000000},
	{0xa2fc, 0x00000000},
	{0xa300, 0x00000000},
	{0xa304, 0x00000000},
	{0xa308, 0x00000000},
	{0xa30c, 0x00000000},
	{0xa310, 0x00000000},
	{0xa314, 0x00000000},
	{0xa318, 0x04000000},
	{0xa31c, 0x00000000},
	{0xa320, 0x00000000},
	{0xa324, 0x00000000},
	{0xa328, 0x00000000},
	{0xa32c, 0x00000000},
	{0xa330, 0x00000000},
	{0xa334, 0x00000000},
	{0xa338, 0x00000000},
	{0xa33c, 0x00000000},
	{0xa340, 0x00000000},
	{0xa344, 0x00000000},
	{0xa348, 0x00000000},
	{0xa34c, 0x00000000},
	{0xa350, 0x00000000},
	{0xa354, 0x00000000},
	{0xa358, 0x00000000},
	{0xa35c, 0x04000000},
	{0x81d8, 0x00000000},
	{0x82d8, 0x00000000},
	{0xb104, 0x2b251f19},
	{0xb108, 0x433d3731},
	{0xb10c, 0x5b554f49},
	{0xb110, 0x736d6761},
	{0xb114, 0x7f7f7f79},
	{0xb118, 0x120f7f7f},
	{0xb11c, 0x1e1b1815},
	{0xb120, 0x2a272421},
	{0xb124, 0x3633302d},
	{0xb128, 0x3f3f3c39},
	{0xb12c, 0x3f3f3f3f},
	{0x8088, 0x00000110},
	{0x8000, 0x00000008},
	{0x8080, 0x00000005},
	{0x8500, 0x80000008},
	{0x8504, 0x43000004},
	{0x8508, 0x4b044a00},
	{0x850c, 0x40098604},
	{0x8510, 0x0004e024},
	{0x8514, 0x87044b05},
	{0x8518, 0xe024400b},
	{0x851c, 0x4b000004},
	{0x8520, 0x21e07410},
	{0x8524, 0x16580000},
	{0x8528, 0x00047430},
	{0x852c, 0x00074380},
	{0x8530, 0x00044c00},
	{0x8534, 0x00074300},
	{0x8538, 0x00045603},
	{0x853c, 0x42fe5700},
	{0x8540, 0x42004000},
	{0x8544, 0x30005055},
	{0x8548, 0xa512b41c},
	{0x854c, 0xf02fe66f},
	{0x8550, 0xf22ff12f},
	{0x8554, 0xf42ff32f},
	{0x8558, 0xf62ff52f},
	{0x855c, 0xf82ff72f},
	{0x8560, 0xfa2ff92f},
	{0x8564, 0xfc2ffb2f},
	{0x8568, 0xfe2ffd2f},
	{0x856c, 0xe66fff2f},
	{0x8570, 0xf12ef02e},
	{0x8574, 0xf32ef22e},
	{0x8578, 0xf52ef42e},
	{0x857c, 0xff2ef62e},
	{0x8580, 0xa511000b},
	{0x8584, 0xf12cf02c},
	{0x8588, 0xf32cf22c},
	{0x858c, 0xf52cf42c},
	{0x8590, 0xf72cf62c},
	{0x8594, 0xf92cf82c},
	{0x8598, 0xfb2cfa2c},
	{0x859c, 0xfd2cfc2c},
	{0x85a0, 0xff2cfe2c},
	{0x85a4, 0xf12cf02c},
	{0x85a8, 0x0001f22c},
	{0x85ac, 0x30b330b3},
	{0x85b0, 0x310c3125},
	{0x85b4, 0x31253161},
	{0x85b8, 0x3081316f},
	{0x85bc, 0x317f3172},
	{0x85c0, 0x3192318c},
	{0x85c4, 0x32b832a6},
	{0x85c8, 0x31fd32c2},
	{0x85cc, 0x330732cc},
	{0x85d0, 0x33193343},
	{0x85d4, 0x331d3312},
	{0x85d8, 0x31663316},
	{0x85dc, 0x3365335b},
	{0x85e0, 0x3379336f},
	{0x85e4, 0x338d3383},
	{0x85e8, 0x33a13397},
	{0x85ec, 0x33b833ab},
	{0x85f0, 0x33d733c9},
	{0x85f4, 0x342333db},
	{0x85f8, 0x343c343b},
	{0x85fc, 0x3471346f},
	{0x8600, 0xe493347c},
	{0x8604, 0x20887410},
	{0x8608, 0x140f0200},
	{0x860c, 0x02002098},
	{0x8610, 0x20a8140f},
	{0x8614, 0x140f0200},
	{0x8618, 0xe4df7430},
	{0x861c, 0x74105b10},
	{0x8620, 0x000120a0},
	{0x8624, 0x140f140f},
	{0x8628, 0x56e15507},
	{0x862c, 0xe4c95c06},
	{0x8630, 0x20a87410},
	{0x8634, 0x140f0201},
	{0x8638, 0xe4c95517},
	{0x863c, 0x20a87410},
	{0x8640, 0x140f0200},
	{0x8644, 0x56c15517},
	{0x8648, 0xe4c95c02},
	{0x864c, 0x20a07410},
	{0x8650, 0x140f0000},
	{0x8654, 0x55071407},
	{0x8658, 0xe47ee4c9},
	{0x865c, 0x4686750a},
	{0x8660, 0xe159e4d3},
	{0x8664, 0xe4930001},
	{0x8668, 0x20a87410},
	{0x866c, 0x140f0200},
	{0x8670, 0x02002098},
	{0x8674, 0x2088140f},
	{0x8678, 0x140f0200},
	{0x867c, 0xe4df7430},
	{0x8680, 0x74105b10},
	{0x8684, 0x020120a8},
	{0x8688, 0x2080140f},
	{0x868c, 0x140f0000},
	{0x8690, 0x56615507},
	{0x8694, 0xe4c95c06},
	{0x8698, 0x20887410},
	{0x869c, 0x140f0200},
	{0x86a0, 0xe4c95517},
	{0x86a4, 0x20a87410},
	{0x86a8, 0x140f0200},
	{0x86ac, 0x56415517},
	{0x86b0, 0xe4c95c02},
	{0x86b4, 0x20807410},
	{0x86b8, 0x140f0000},
	{0x86bc, 0x55071407},
	{0x86c0, 0xe47ee4c9},
	{0x86c4, 0x468e7508},
	{0x86c8, 0xe159e4d3},
	{0x86cc, 0x5b10f025},
	{0x86d0, 0x20a87410},
	{0x86d4, 0x140f0201},
	{0x86d8, 0x00002090},
	{0x86dc, 0x5507140f},
	{0x86e0, 0x5c065661},
	{0x86e4, 0x7410e4c9},
	{0x86e8, 0x02002098},
	{0x86ec, 0x5517140f},
	{0x86f0, 0x7410e4c9},
	{0x86f4, 0x020020a8},
	{0x86f8, 0x5517140f},
	{0x86fc, 0x5c025641},
	{0x8700, 0x7410e4c9},
	{0x8704, 0x00002090},
	{0x8708, 0x5507140f},
	{0x870c, 0x7509e4c9},
	{0x8710, 0xe4d34696},
	{0x8714, 0x0001e159},
	{0x8718, 0x74105b10},
	{0x871c, 0x000020a0},
	{0x8720, 0x5507140f},
	{0x8724, 0xe4c95601},
	{0x8728, 0x20a87410},
	{0x872c, 0x140f0200},
	{0x8730, 0xe4c95517},
	{0x8734, 0x750ae47e},
	{0x8738, 0xe4d34686},
	{0x873c, 0x5500e159},
	{0x8740, 0x5501e4c5},
	{0x8744, 0xe4930001},
	{0x8748, 0x5b10e4df},
	{0x874c, 0x20807410},
	{0x8750, 0x140f0000},
	{0x8754, 0x02002098},
	{0x8758, 0xf205140f},
	{0x875c, 0x20a8f504},
	{0x8760, 0x140f0200},
	{0x8764, 0x56015507},
	{0x8768, 0x7410e4c9},
	{0x876c, 0x02002088},
	{0x8770, 0x5517140f},
	{0x8774, 0xe47ee4c9},
	{0x8778, 0x468e7508},
	{0x877c, 0xe159e4d3},
	{0x8780, 0x7410f512},
	{0x8784, 0x00002090},
	{0x8788, 0x5507140f},
	{0x878c, 0x7410e4c9},
	{0x8790, 0x02002098},
	{0x8794, 0x5517140f},
	{0x8798, 0x7509e4c9},
	{0x879c, 0xe4d34696},
	{0x87a0, 0x0001e159},
	{0x87a4, 0x46965b90},
	{0x87a8, 0xe4c55500},
	{0x87ac, 0x5b105501},
	{0x87b0, 0x79000001},
	{0x87b4, 0x57107420},
	{0x87b8, 0x140f5700},
	{0x87bc, 0x74309700},
	{0x87c0, 0xe4930001},
	{0x87c4, 0x0bbde4df},
	{0x87c8, 0x0001e662},
	{0x87cc, 0x5720e493},
	{0x87d0, 0x540054fd},
	{0x87d4, 0x70005700},
	{0x87d8, 0x70c0e4dd},
	{0x87dc, 0xe4a90001},
	{0x87e0, 0x0001e512},
	{0x87e4, 0x31abe493},
	{0x87e8, 0xe6620023},
	{0x87ec, 0x54ed0002},
	{0x87f0, 0x00230baa},
	{0x87f4, 0x0002e662},
	{0x87f8, 0xe486e52e},
	{0x87fc, 0xe4930001},
	{0x8800, 0x002231a1},
	{0x8804, 0x0002e662},
	{0x8808, 0x0baa54ec},
	{0x880c, 0xe6620022},
	{0x8810, 0xe52e0002},
	{0x8814, 0x0001e486},
	{0x8818, 0x0baae493},
	{0x881c, 0xe52e3194},
	{0x8820, 0x0001e486},
	{0x8824, 0x0babe493},
	{0x8828, 0x6d0f6c67},
	{0x882c, 0xe662e4df},
	{0x8830, 0x6c8bfb04},
	{0x8834, 0xe662e4df},
	{0x8838, 0x6c95fa04},
	{0x883c, 0xe662e4df},
	{0x8840, 0x0bacfb06},
	{0x8844, 0x6d0f6cb3},
	{0x8848, 0xe662e4df},
	{0x884c, 0xf904fa05},
	{0x8850, 0xe4df6ccb},
	{0x8854, 0xfb06e662},
	{0x8858, 0x6cdb0bad},
	{0x885c, 0xe4df6d0f},
	{0x8860, 0x6cf5e662},
	{0x8864, 0xe4df6d0f},
	{0x8868, 0x6c0be662},
	{0x886c, 0xe4df6d00},
	{0x8870, 0xfb04e662},
	{0x8874, 0xe4df6c25},
	{0x8878, 0xf8b7e662},
	{0x887c, 0xf904fa05},
	{0x8880, 0xe4df6c35},
	{0x8884, 0xfb04e662},
	{0x8888, 0xe4df6c4d},
	{0x888c, 0xf9bae662},
	{0x8890, 0x6c6bfa04},
	{0x8894, 0xe662e4df},
	{0x8898, 0x6c75fb04},
	{0x889c, 0xe662e4df},
	{0x88a0, 0xe4df6c99},
	{0x88a4, 0xfabce662},
	{0x88a8, 0x57200ba8},
	{0x88ac, 0x540054f0},
	{0x88b0, 0x7c355700},
	{0x88b4, 0x70007d00},
	{0x88b8, 0x6d0e6cc5},
	{0x88bc, 0xe662e4dd},
	{0x88c0, 0xe4dd6cf5},
	{0x88c4, 0x6c29e662},
	{0x88c8, 0xe4dd6d0f},
	{0x88cc, 0x0bb3e662},
	{0x88d0, 0x54ed5720},
	{0x88d4, 0x57005400},
	{0x88d8, 0x7d0f7ccb},
	{0x88dc, 0x6d006cd7},
	{0x88e0, 0xe662e4dd},
	{0x88e4, 0x6d016c0b},
	{0x88e8, 0xe662e4dd},
	{0x88ec, 0xe4dd6c3b},
	{0x88f0, 0x70c0e662},
	{0x88f4, 0xe486e52e},
	{0x88f8, 0xe4a90001},
	{0x88fc, 0x63424380},
	{0x8900, 0x43006887},
	{0x8904, 0x74100ba6},
	{0x8908, 0x000121e8},
	{0x890c, 0x6ec71658},
	{0x8910, 0xe5126f0e},
	{0x8914, 0x7410e667},
	{0x8918, 0x000321e8},
	{0x891c, 0x6eeb1658},
	{0x8920, 0xe667e512},
	{0x8924, 0x21e87410},
	{0x8928, 0x16580005},
	{0x892c, 0x6f0f6e13},
	{0x8930, 0xe667e512},
	{0x8934, 0x21e87410},
	{0x8938, 0x16580007},
	{0x893c, 0xe5126e3b},
	{0x8940, 0x7410e667},
	{0x8944, 0x000921e8},
	{0x8948, 0x6e671658},
	{0x894c, 0xe5126f0f},
	{0x8950, 0x7410e667},
	{0x8954, 0x000b21e8},
	{0x8958, 0x6e8b1658},
	{0x895c, 0xe667e512},
	{0x8960, 0x21e87410},
	{0x8964, 0x1658000d},
	{0x8968, 0x6f0f6eb3},
	{0x896c, 0xe667e512},
	{0x8970, 0xfe08ff09},
	{0x8974, 0x21e87410},
	{0x8978, 0x1658000e},
	{0x897c, 0xe5126ec7},
	{0x8980, 0x7410e667},
	{0x8984, 0x000f21e8},
	{0x8988, 0x6edb1658},
	{0x898c, 0xe5126f0f},
	{0x8990, 0x7410e667},
	{0x8994, 0x001021e8},
	{0x8998, 0x6eef1658},
	{0x899c, 0xe667e512},
	{0x89a0, 0xfe02ff03},
	{0x89a4, 0x7410e667},
	{0x89a8, 0x001321e8},
	{0x89ac, 0x6e111658},
	{0x89b0, 0xe5126f00},
	{0x89b4, 0xff03e667},
	{0x89b8, 0xe667fe02},
	{0x89bc, 0x21e87410},
	{0x89c0, 0x16580014},
	{0x89c4, 0xe5126e25},
	{0x89c8, 0xfc48e667},
	{0x89cc, 0xfe08ff09},
	{0x89d0, 0x21e87410},
	{0x89d4, 0x16580015},
	{0x89d8, 0xe5126e39},
	{0x89dc, 0x7410e667},
	{0x89e0, 0x001621e8},
	{0x89e4, 0x6e4d1658},
	{0x89e8, 0xe667e512},
	{0x89ec, 0x7410fd49},
	{0x89f0, 0x001821e8},
	{0x89f4, 0x6e751658},
	{0x89f8, 0xe667e512},
	{0x89fc, 0x21e87410},
	{0x8a00, 0x1658001a},
	{0x8a04, 0xe5126e99},
	{0x8a08, 0xfe44e667},
	{0x8a0c, 0x21e87410},
	{0x8a10, 0x1658001c},
	{0x8a14, 0xe5126ec5},
	{0x8a18, 0x7410e667},
	{0x8a1c, 0x001e21e8},
	{0x8a20, 0x6eed1658},
	{0x8a24, 0xe667e512},
	{0x8a28, 0x21e87410},
	{0x8a2c, 0x16580020},
	{0x8a30, 0x6f016e15},
	{0x8a34, 0xe667e512},
	{0x8a38, 0x21e87410},
	{0x8a3c, 0x16580022},
	{0x8a40, 0xe5126e39},
	{0x8a44, 0xe52ee667},
	{0x8a48, 0x0001e49c},
	{0x8a4c, 0x4380e4a9},
	{0x8a50, 0x68806340},
	{0x8a54, 0x0bac4300},
	{0x8a58, 0x00223241},
	{0x8a5c, 0x0002e667},
	{0x8a60, 0x0baa54ec},
	{0x8a64, 0xe6670022},
	{0x8a68, 0xe52e0002},
	{0x8a6c, 0x0001e49c},
	{0x8a70, 0x4380e4a9},
	{0x8a74, 0x68816340},
	{0x8a78, 0x0baa4300},
	{0x8a7c, 0xe52e3230},
	{0x8a80, 0x0001e49c},
	{0x8a84, 0x4380e4a9},
	{0x8a88, 0x68826341},
	{0x8a8c, 0x0baa4300},
	{0x8a90, 0xe52e3221},
	{0x8a94, 0x0001e49c},
	{0x8a98, 0x42fc0004},
	{0x8a9c, 0x60010007},
	{0x8aa0, 0x42000004},
	{0x8aa4, 0x62200007},
	{0x8aa8, 0x00046200},
	{0x8aac, 0x5b405501},
	{0x8ab0, 0x00076605},
	{0x8ab4, 0x63006200},
	{0x8ab8, 0x0004e54f},
	{0x8abc, 0x0a010900},
	{0x8ac0, 0x0d000b40},
	{0x8ac4, 0x00320e01},
	{0x8ac8, 0x95090004},
	{0x8acc, 0x790442fb},
	{0x8ad0, 0x43804200},
	{0x8ad4, 0x4d010007},
	{0x8ad8, 0x43000004},
	{0x8adc, 0x05620007},
	{0x8ae0, 0x961d05a3},
	{0x8ae4, 0x0004e54f},
	{0x8ae8, 0x0007e4c5},
	{0x8aec, 0x07a306a2},
	{0x8af0, 0x0004e54f},
	{0x8af4, 0xe53fe4c5},
	{0x8af8, 0xe5470002},
	{0x8afc, 0x00074380},
	{0x8b00, 0x00044d00},
	{0x8b04, 0x42fe4300},
	{0x8b08, 0x42007900},
	{0x8b0c, 0x00040001},
	{0x8b10, 0x000742fc},
	{0x8b14, 0x00046003},
	{0x8b18, 0x32d24200},
	{0x8b1c, 0x06a20007},
	{0x8b20, 0x32fc07a3},
	{0x8b24, 0xe32ee320},
	{0x8b28, 0x0001e333},
	{0x8b2c, 0xe333e320},
	{0x8b30, 0xe3270001},
	{0x8b34, 0xe333e32e},
	{0x8b38, 0xe3270001},
	{0x8b3c, 0x0001e333},
	{0x8b40, 0x42fc0004},
	{0x8b44, 0x60030007},
	{0x8b48, 0x42000004},
	{0x8b4c, 0x00040001},
	{0x8b50, 0x000742fc},
	{0x8b54, 0x00046001},
	{0x8b58, 0x00014200},
	{0x8b5c, 0x62200007},
	{0x8b60, 0xe5476200},
	{0x8b64, 0x00070001},
	{0x8b68, 0x00046300},
	{0x8b6c, 0x0a000900},
	{0x8b70, 0x00320e01},
	{0x8b74, 0x06a20007},
	{0x8b78, 0xe559e54f},
	{0x8b7c, 0x42fe0002},
	{0x8b80, 0x42007900},
	{0x8b84, 0x00050001},
	{0x8b88, 0x00077700},
	{0x8b8c, 0x00045200},
	{0x8b90, 0x000742fe},
	{0x8b94, 0x00046000},
	{0x8b98, 0x43804200},
	{0x8b9c, 0x61006000},
	{0x8ba0, 0x63106201},
	{0x8ba4, 0x00056804},
	{0x8ba8, 0x55004100},
	{0x8bac, 0x5c020007},
	{0x8bb0, 0x43000004},
	{0x8bb4, 0x00050001},
	{0x8bb8, 0xe3c96c06},
	{0x8bbc, 0xe3b8e3db},
	{0x8bc0, 0xe423e567},
	{0x8bc4, 0xe43ce56f},
	{0x8bc8, 0xe3b80001},
	{0x8bcc, 0x6c060005},
	{0x8bd0, 0xe5e6e3c9},
	{0x8bd4, 0xe423e567},
	{0x8bd8, 0xe43ce56f},
	{0x8bdc, 0x00050001},
	{0x8be0, 0xe3c96c00},
	{0x8be4, 0xe3b8e3db},
	{0x8be8, 0xe423e582},
	{0x8bec, 0xe43ce58a},
	{0x8bf0, 0xe3b80001},
	{0x8bf4, 0x6c000005},
	{0x8bf8, 0xe5e6e3c9},
	{0x8bfc, 0xe423e582},
	{0x8c00, 0xe43ce58a},
	{0x8c04, 0x00050001},
	{0x8c08, 0xe3c96c04},
	{0x8c0c, 0xe3b8e3db},
	{0x8c10, 0xe423e59d},
	{0x8c14, 0xe43ce5a5},
	{0x8c18, 0xe3b80001},
	{0x8c1c, 0x6c040005},
	{0x8c20, 0xe5e6e3c9},
	{0x8c24, 0xe423e59d},
	{0x8c28, 0xe43ce5a5},
	{0x8c2c, 0x00050001},
	{0x8c30, 0xe3c96c02},
	{0x8c34, 0xe3b8e3db},
	{0x8c38, 0xe423e5b8},
	{0x8c3c, 0xe43ce5c0},
	{0x8c40, 0xe3b80001},
	{0x8c44, 0x6c020005},
	{0x8c48, 0xe5e6e3c9},
	{0x8c4c, 0xe423e5b8},
	{0x8c50, 0xe43ce5c0},
	{0x8c54, 0x00040001},
	{0x8c58, 0x60084380},
	{0x8c5c, 0x6200610a},
	{0x8c60, 0x000663ce},
	{0x8c64, 0x7f006080},
	{0x8c68, 0x43000004},
	{0x8c6c, 0x0001e618},
	{0x8c70, 0x55000007},
	{0x8c74, 0x74200004},
	{0x8c78, 0x77117901},
	{0x8c7c, 0x57005710},
	{0x8c80, 0x7430140f},
	{0x8c84, 0x43800004},
	{0x8c88, 0x72000007},
	{0x8c8c, 0x43000004},
	{0x8c90, 0x00040001},
	{0x8c94, 0x00057420},
	{0x8c98, 0x7e067700},
	{0x8c9c, 0x73807388},
	{0x8ca0, 0x140f8f00},
	{0x8ca4, 0x74300004},
	{0x8ca8, 0x73000005},
	{0x8cac, 0xe5d30001},
	{0x8cb0, 0x73000005},
	{0x8cb4, 0x00040001},
	{0x8cb8, 0xb1034380},
	{0x8cbc, 0x7cdb0006},
	{0x8cc0, 0x00079103},
	{0x8cc4, 0x000440db},
	{0x8cc8, 0xe5d34300},
	{0x8ccc, 0x73800005},
	{0x8cd0, 0x5d010006},
	{0x8cd4, 0x62006002},
	{0x8cd8, 0x0005e5f7},
	{0x8cdc, 0x00077300},
	{0x8ce0, 0x75787608},
	{0x8ce4, 0x43800004},
	{0x8ce8, 0x5e010007},
	{0x8cec, 0x140a5e00},
	{0x8cf0, 0x63800006},
	{0x8cf4, 0x00077f00},
	{0x8cf8, 0x4e204c3f},
	{0x8cfc, 0x73047280},
	{0x8d00, 0x140a7300},
	{0x8d04, 0x00044d20},
	{0x8d08, 0x00064300},
	{0x8d0c, 0x00077402},
	{0x8d10, 0x40004001},
	{0x8d14, 0x0006ab00},
	{0x8d18, 0x00077404},
	{0x8d1c, 0x40004001},
	{0x8d20, 0x140aab00},
	{0x8d24, 0x43800004},
	{0x8d28, 0x52800007},
	{0x8d2c, 0x140a5200},
	{0x8d30, 0x4d004c00},
	{0x8d34, 0x00064e00},
	{0x8d38, 0x63006080},
	{0x8d3c, 0x43000004},
	{0x8d40, 0x76000007},
	{0x8d44, 0x00040001},
	{0x8d48, 0xb1034380},
	{0x8d4c, 0x7cdb0006},
	{0x8d50, 0x00079103},
	{0x8d54, 0x000440db},
	{0x8d58, 0xe5d34300},
	{0x8d5c, 0xe5f77e03},
	{0x8d60, 0x43800004},
	{0x8d64, 0x0006b103},
	{0x8d68, 0x91037c5b},
	{0x8d6c, 0x405b0007},
	{0x8d70, 0x43000004},
	{0x8d74, 0x00010001},
	{0x8d78, 0x43800004},
	{0x8d7c, 0x4e200007},
	{0x8d80, 0x63800006},
	{0x8d84, 0x5f807cdb},
	{0x8d88, 0x43000004},
	{0x8d8c, 0x76080007},
	{0x8d90, 0x00057560},
	{0x8d94, 0x00047380},
	{0x8d98, 0x0005420e},
	{0x8d9c, 0x92006c01},
	{0x8da0, 0x6c001432},
	{0x8da4, 0x42000004},
	{0x8da8, 0x43800004},
	{0x8dac, 0x5f000006},
	{0x8db0, 0x73010007},
	{0x8db4, 0x00047300},
	{0x8db8, 0x0007420f},
	{0x8dbc, 0x52005280},
	{0x8dc0, 0x0004140a},
	{0x8dc4, 0x00064200},
	{0x8dc8, 0x7c5b6300},
	{0x8dcc, 0x4e000007},
	{0x8dd0, 0x43000004},
	{0x8dd4, 0x73000005},
	{0x8dd8, 0x76000007},
	{0x8ddc, 0xe5fb0001},
	{0x8de0, 0x00040001},
	{0x8de4, 0x60004380},
	{0x8de8, 0x62016100},
	{0x8dec, 0x00066310},
	{0x8df0, 0x00046000},
	{0x8df4, 0x00014300},
	{0x8df8, 0x0001e618},
	{0x8dfc, 0x4e004f02},
	{0x8e00, 0x52015302},
	{0x8e04, 0x140f0001},
	{0x8e08, 0x00019700},
	{0x8e0c, 0x8a084380},
	{0x8e10, 0x7800aa09},
	{0x8e14, 0x7a007900},
	{0x8e18, 0x43007b40},
	{0x8e1c, 0x65010001},
	{0x8e20, 0x67013489},
	{0x8e24, 0x43803489},
	{0x8e28, 0xaa058a04},
	{0x8e2c, 0x00014300},
	{0x8e30, 0x34966500},
	{0x8e34, 0x34966700},
	{0x8e38, 0x8a084380},
	{0x8e3c, 0x7c00aa09},
	{0x8e40, 0x7e007d00},
	{0x8e44, 0x43007f40},
	{0x8e48, 0x64010001},
	{0x8e4c, 0x6601349f},
	{0x8e50, 0x4380349f},
	{0x8e54, 0xaa058a04},
	{0x8e58, 0x00014300},
	{0x8e5c, 0x34ac6400},
	{0x8e60, 0x34ac6600},
	{0x8e64, 0x7b484380},
	{0x8e68, 0x79007a90},
	{0x8e6c, 0x43007802},
	{0x8e70, 0x34c95503},
	{0x8e74, 0x7b384380},
	{0x8e78, 0x43007a80},
	{0x8e7c, 0x34c95513},
	{0x8e80, 0x7b404380},
	{0x8e84, 0x43007a00},
	{0x8e88, 0x74015523},
	{0x8e8c, 0x8e007400},
	{0x8e90, 0x00070001},
	{0x8e94, 0x00045230},
	{0x8e98, 0x74307431},
	{0x8e9c, 0x00078e00},
	{0x8ea0, 0x00045220},
	{0x8ea4, 0x57020001},
	{0x8ea8, 0x8e005700},
	{0x8eac, 0x42ef0001},
	{0x8eb0, 0x56005610},
	{0x8eb4, 0x8c004200},
	{0x8eb8, 0x5b500001},
	{0x8ebc, 0x5b2034e0},
	{0x8ec0, 0x4e004f78},
	{0x8ec4, 0x52015388},
	{0x8ec8, 0x4e004f78},
	{0x8ecc, 0x52015388},
	{0x8ed0, 0x5480e4f2},
	{0x8ed4, 0x54815400},
	{0x8ed8, 0x54825400},
	{0x8edc, 0xe4fd5400},
	{0x8ee0, 0x3010bf1d},
	{0x8ee4, 0xe4bae4b2},
	{0x8ee8, 0xe4d3e4c0},
	{0x8eec, 0x5523e65b},
	{0x8ef0, 0x5525e4c9},
	{0x8ef4, 0xe65be4d3},
	{0x8ef8, 0x54bf0001},
	{0x8efc, 0x54a354c0},
	{0x8f00, 0x54a454c1},
	{0x8f04, 0xbf074c18},
	{0x8f08, 0x54a454c2},
	{0x8f0c, 0x54c1bf04},
	{0x8f10, 0xbf0154a3},
	{0x8f14, 0x54dfe66c},
	{0x8f18, 0x54bf0001},
	{0x8f1c, 0x050a54e5},
	{0x8f20, 0x000154df},
	{0x8f24, 0x7b801657},
	{0x8f28, 0x43807430},
	{0x8f2c, 0x7e007f40},
	{0x8f30, 0x7c027d00},
	{0x8f34, 0x5b404300},
	{0x8f38, 0x5c015501},
	{0x8f3c, 0x5480e4d7},
	{0x8f40, 0x54815400},
	{0x8f44, 0x54825400},
	{0x8f48, 0x7b005400},
	{0x8f4c, 0xe4fd7410},
	{0x8f50, 0x3010bfe5},
	{0x8f54, 0x56005610},
	{0x8f58, 0x00018c00},
	{0x8f5c, 0x57005704},
	{0x8f60, 0x57088e00},
	{0x8f64, 0x8e005700},
	{0x8f68, 0x57805781},
	{0x8f6c, 0x43808e00},
	{0x8f70, 0x5c010007},
	{0x8f74, 0x14035c00},
	{0x8f78, 0x43000004},
	{0x8f7c, 0x427f0001},
	{0x8f80, 0x62800007},
	{0x8f84, 0x92006200},
	{0x8f88, 0x42000004},
	{0x8f8c, 0x427f0001},
	{0x8f90, 0x63940007},
	{0x8f94, 0x92006314},
	{0x8f98, 0x42000004},
	{0x8f9c, 0x00040001},
	{0x8fa0, 0x790142fe},
	{0x8fa4, 0x74204200},
	{0x8fa8, 0x5710140f},
	{0x8fac, 0x141f5700},
	{0x8fb0, 0x00040001},
	{0x8fb4, 0x790142fe},
	{0x8fb8, 0x74204200},
	{0x8fbc, 0x42bf140f},
	{0x8fc0, 0x62400007},
	{0x8fc4, 0x141f6200},
	{0x8fc8, 0x42000004},
	{0x8fcc, 0x00060001},
	{0x8fd0, 0x60035d06},
	{0x8fd4, 0x62016104},
	{0x8fd8, 0x73100005},
	{0x8fdc, 0x00040001},
	{0x8fe0, 0x00074380},
	{0x8fe4, 0x5e005e01},
	{0x8fe8, 0xb103140a},
	{0x8fec, 0x7f070006},
	{0x8ff0, 0x00079103},
	{0x8ff4, 0x00064307},
	{0x8ff8, 0x5d025c00},
	{0x8ffc, 0x00045e03},
	{0x9000, 0x00014300},
	{0x9004, 0x5d040006},
	{0x9008, 0x61046000},
	{0x900c, 0x00056201},
	{0x9010, 0x00017310},
	{0x9014, 0x43800004},
	{0x9018, 0x5e010007},
	{0x901c, 0x140a5e00},
	{0x9020, 0x0006b103},
	{0x9024, 0x91037fc6},
	{0x9028, 0x43c60007},
	{0x902c, 0x5c000006},
	{0x9030, 0x5e035d02},
	{0x9034, 0x43000004},
	{0x9038, 0x00060001},
	{0x903c, 0x60005d04},
	{0x9040, 0x62016104},
	{0x9044, 0x73100005},
	{0x9048, 0x00040001},
	{0x904c, 0x00074380},
	{0x9050, 0x5e005e01},
	{0x9054, 0xb103140a},
	{0x9058, 0x7fc60006},
	{0x905c, 0x00079103},
	{0x9060, 0x000643c6},
	{0x9064, 0x5d025c00},
	{0x9068, 0x00045e03},
	{0x906c, 0x00014300},
	{0x9070, 0x5d000006},
	{0x9074, 0x61006002},
	{0x9078, 0x00056201},
	{0x907c, 0x00017300},
	{0x9080, 0x43800004},
	{0x9084, 0x5e010007},
	{0x9088, 0x140a5e00},
	{0x908c, 0x0006b103},
	{0x9090, 0x91037fc0},
	{0x9094, 0x43c00007},
	{0x9098, 0x5c000006},
	{0x909c, 0x5e035d02},
	{0x90a0, 0x43000004},
	{0x90a4, 0x00050001},
	{0x90a8, 0x00047e02},
	{0x90ac, 0x000542f7},
	{0x90b0, 0x00046c08},
	{0x90b4, 0x00054270},
	{0x90b8, 0x73807381},
	{0x90bc, 0x00049300},
	{0x90c0, 0x000542f7},
	{0x90c4, 0x00046c00},
	{0x90c8, 0x00014200},
	{0x90cc, 0x43800004},
	{0x90d0, 0x73040007},
	{0x90d4, 0x14057300},
	{0x90d8, 0x00047240},
	{0x90dc, 0x00064300},
	{0x90e0, 0x00077404},
	{0x90e4, 0x40004001},
	{0x90e8, 0x140fab00},
	{0x90ec, 0xe64f0001},
	{0x90f0, 0xe656e5fb},
	{0x90f4, 0x00040001},
	{0x90f8, 0x00047410},
	{0x90fc, 0x42f04380},
	{0x9100, 0x62080007},
	{0x9104, 0x24206301},
	{0x9108, 0x14c80000},
	{0x910c, 0x00002428},
	{0x9110, 0x1a4215f4},
	{0x9114, 0x6300000b},
	{0x9118, 0x42000004},
	{0x911c, 0x74304300},
	{0x9120, 0x4380140f},
	{0x9124, 0x73080007},
	{0x9128, 0x00047300},
	{0x912c, 0x00014300},
	{0x9130, 0x4bf00007},
	{0x9134, 0x490b4a8f},
	{0x9138, 0x4a8e48f1},
	{0x913c, 0x48a5490a},
	{0x9140, 0x49094a8d},
	{0x9144, 0x4a8c487d},
	{0x9148, 0x48754908},
	{0x914c, 0x49074a8b},
	{0x9150, 0x4a8a4889},
	{0x9154, 0x48b74906},
	{0x9158, 0x49054a89},
	{0x915c, 0x4a8848fc},
	{0x9160, 0x48564905},
	{0x9164, 0x49044a87},
	{0x9168, 0x4a8648c1},
	{0x916c, 0x483d4904},
	{0x9170, 0x49034a85},
	{0x9174, 0x4a8448c7},
	{0x9178, 0x485e4903},
	{0x917c, 0x49024a83},
	{0x9180, 0x4a8248ac},
	{0x9184, 0x48624902},
	{0x9188, 0x49024a81},
	{0x918c, 0x4a804820},
	{0x9190, 0x48004900},
	{0x9194, 0x49014a90},
	{0x9198, 0x4a10481f},
	{0x919c, 0x00060001},
	{0x91a0, 0x5f005f80},
	{0x91a4, 0x00059900},
	{0x91a8, 0x00017300},
	{0x91ac, 0x63800006},
	{0x91b0, 0x98006300},
	{0x91b4, 0x549f0001},
	{0x91b8, 0x5c015400},
	{0x91bc, 0x540054df},
	{0x91c0, 0x00015c02},
	{0x91c4, 0x07145c01},
	{0x91c8, 0x5c025400},
	{0x91cc, 0x5c020001},
	{0x91d0, 0x54000714},
	{0x91d4, 0x00015c01},
	{0x91d8, 0x4c184c98},
	{0x91dc, 0x00080001},
	{0x91e0, 0x5c020004},
	{0x91e4, 0x09017430},
	{0x91e8, 0x0ba60c01},
	{0x91ec, 0x77800005},
	{0x91f0, 0x52200007},
	{0x91f4, 0x43800004},
	{0x91f8, 0x610a6008},
	{0x91fc, 0x63c26200},
	{0x9200, 0x5c000007},
	{0x9204, 0x43000004},
	{0x9208, 0x00000001},
	{0x8080, 0x00000004},
	{0x8080, 0x00000000},
	{0x8088, 0x00000000},
};

static const struct rtw89_txpwr_byrate_cfg rtw89_8852c_txpwr_byrate[] = {
	{ 0, 0, 0, 0, 4, 0x50505050, },
	{ 0, 0, 1, 0, 4, 0x50505050, },
	{ 0, 0, 1, 4, 4, 0x484c5050, },
	{ 0, 0, 2, 0, 4, 0x50505050, },
	{ 0, 0, 2, 4, 4, 0x44484c50, },
	{ 0, 0, 2, 8, 4, 0x34383c40, },
	{ 0, 0, 3, 0, 4, 0x50505050, },
	{ 0, 1, 2, 0, 4, 0x50505050, },
	{ 0, 1, 2, 4, 4, 0x44484c50, },
	{ 0, 1, 2, 8, 4, 0x34383c40, },
	{ 0, 1, 3, 0, 4, 0x50505050, },
	{ 0, 0, 4, 1, 4, 0x00000000, },
	{ 0, 0, 4, 0, 1, 0x00000000, },
	{ 1, 0, 1, 0, 4, 0x48484848, },
	{ 1, 0, 1, 4, 4, 0x40444848, },
	{ 1, 0, 2, 0, 4, 0x48484848, },
	{ 1, 0, 2, 4, 4, 0x3c404448, },
	{ 1, 0, 2, 8, 4, 0x2c303438, },
	{ 1, 0, 3, 0, 4, 0x48484848, },
	{ 1, 1, 2, 0, 4, 0x48484848, },
	{ 1, 1, 2, 4, 4, 0x3c404448, },
	{ 1, 1, 2, 8, 4, 0x2c303438, },
	{ 1, 1, 3, 0, 4, 0x48484848, },
	{ 1, 0, 4, 0, 4, 0x00000000, },
	{ 2, 0, 1, 0, 4, 0x40404040, },
	{ 2, 0, 1, 4, 4, 0x383c4040, },
	{ 2, 0, 2, 0, 4, 0x40404040, },
	{ 2, 0, 2, 4, 4, 0x34383c40, },
	{ 2, 0, 2, 8, 4, 0x24282c30, },
	{ 2, 0, 3, 0, 4, 0x40404040, },
	{ 2, 1, 2, 0, 4, 0x40404040, },
	{ 2, 1, 2, 4, 4, 0x34383c40, },
	{ 2, 1, 2, 8, 4, 0x24282c30, },
	{ 2, 1, 3, 0, 4, 0x40404040, },
	{ 2, 0, 4, 0, 4, 0x00000000, },
};

static const s8 _txpwr_track_delta_swingidx_6gb_n[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5,
	 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10},
	{0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5,
	 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10},
	{0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5,
	 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10},
	{0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5,
	 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10},
};

static const s8 _txpwr_track_delta_swingidx_6gb_p[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10, 11,
	 11, 12, 12, 13, 14, 14, 15, 15, 16, 17, 17, 18},
	{0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 12, 13, 13, 14, 15, 15, 16, 16},
	{0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 12, 13, 13, 14, 15, 15, 16, 16},
	{0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 12, 13, 13, 14, 15, 15, 16, 16},
};

static const s8 _txpwr_track_delta_swingidx_6ga_n[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
	 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6},
	{0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
	 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6},
	{0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
	 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6},
	{0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
	 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6},
};

static const s8 _txpwr_track_delta_swingidx_6ga_p[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};

static const s8 _txpwr_track_delta_swingidx_5gb_n[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5,
	 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10},
	{0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4,
	 5, 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8},
	{0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 6, 7,
	 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12, 12},
};

static const s8 _txpwr_track_delta_swingidx_5gb_p[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 16},
	{0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 16},
	{0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 16},
};

static const s8 _txpwr_track_delta_swingidx_5ga_n[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
	 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6},
	{0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2,
	 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3},
	{0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4,
	 5, 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8},
};

static const s8 _txpwr_track_delta_swingidx_5ga_p[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8,
	 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8,
	 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8,
	 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14},
};

static const s8 _txpwr_track_delta_swingidx_2gb_n[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1,
	 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
};

static const s8 _txpwr_track_delta_swingidx_2gb_p[] = {
	0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2
};

static const s8 _txpwr_track_delta_swingidx_2ga_n[] = {
	0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -2,
	 -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3
};

static const s8 _txpwr_track_delta_swingidx_2ga_p[] = {
	0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3,
	 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5
};

static const s8 _txpwr_track_delta_swingidx_2g_cck_b_n[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1,
	 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
};

static const s8 _txpwr_track_delta_swingidx_2g_cck_b_p[] = {
	0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2
};

static const s8 _txpwr_track_delta_swingidx_2g_cck_a_n[] = {
	0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -2,
	 -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3
};

static const s8 _txpwr_track_delta_swingidx_2g_cck_a_p[] = {
	0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3,
	 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5
};

const u8 rtw89_8852c_tx_shape[RTW89_BAND_MAX][RTW89_RS_TX_SHAPE_NUM]
			     [RTW89_REGD_NUM] = {
	[0][0][RTW89_ACMA] = 0,
	[0][0][RTW89_ETSI] = 0,
	[0][0][RTW89_FCC] = 1,
	[0][0][RTW89_IC] = 1,
	[0][0][RTW89_MKK] = 0,
	[0][1][RTW89_ACMA] = 0,
	[0][1][RTW89_ETSI] = 0,
	[0][1][RTW89_FCC] = 3,
	[0][1][RTW89_IC] = 3,
	[0][1][RTW89_MKK] = 0,
	[1][1][RTW89_ACMA] = 0,
	[1][1][RTW89_ETSI] = 0,
	[1][1][RTW89_FCC] = 3,
	[1][1][RTW89_IC] = 3,
	[1][1][RTW89_MKK] = 0,
	[2][1][RTW89_FCC] = 1,
};

const s8 rtw89_8852c_txpwr_lmt_2g[RTW89_2G_BW_NUM][RTW89_NTX_NUM]
				 [RTW89_RS_LMT_NUM][RTW89_BF_NUM]
				 [RTW89_REGD_NUM][RTW89_2G_CH_NUM] = {
	[0][0][0][0][RTW89_WW][0] = 60,
	[0][0][0][0][RTW89_WW][1] = 60,
	[0][0][0][0][RTW89_WW][2] = 60,
	[0][0][0][0][RTW89_WW][3] = 60,
	[0][0][0][0][RTW89_WW][4] = 60,
	[0][0][0][0][RTW89_WW][5] = 60,
	[0][0][0][0][RTW89_WW][6] = 60,
	[0][0][0][0][RTW89_WW][7] = 60,
	[0][0][0][0][RTW89_WW][8] = 60,
	[0][0][0][0][RTW89_WW][9] = 60,
	[0][0][0][0][RTW89_WW][10] = 60,
	[0][0][0][0][RTW89_WW][11] = 60,
	[0][0][0][0][RTW89_WW][12] = 48,
	[0][0][0][0][RTW89_WW][13] = 72,
	[0][1][0][0][RTW89_WW][0] = 48,
	[0][1][0][0][RTW89_WW][1] = 48,
	[0][1][0][0][RTW89_WW][2] = 48,
	[0][1][0][0][RTW89_WW][3] = 48,
	[0][1][0][0][RTW89_WW][4] = 48,
	[0][1][0][0][RTW89_WW][5] = 48,
	[0][1][0][0][RTW89_WW][6] = 48,
	[0][1][0][0][RTW89_WW][7] = 48,
	[0][1][0][0][RTW89_WW][8] = 48,
	[0][1][0][0][RTW89_WW][9] = 48,
	[0][1][0][0][RTW89_WW][10] = 48,
	[0][1][0][0][RTW89_WW][11] = 46,
	[0][1][0][0][RTW89_WW][12] = 34,
	[0][1][0][0][RTW89_WW][13] = 60,
	[1][0][0][0][RTW89_WW][0] = 0,
	[1][0][0][0][RTW89_WW][1] = 0,
	[1][0][0][0][RTW89_WW][2] = 42,
	[1][0][0][0][RTW89_WW][3] = 42,
	[1][0][0][0][RTW89_WW][4] = 42,
	[1][0][0][0][RTW89_WW][5] = 58,
	[1][0][0][0][RTW89_WW][6] = 42,
	[1][0][0][0][RTW89_WW][7] = 42,
	[1][0][0][0][RTW89_WW][8] = 42,
	[1][0][0][0][RTW89_WW][9] = 34,
	[1][0][0][0][RTW89_WW][10] = 22,
	[1][0][0][0][RTW89_WW][11] = 0,
	[1][0][0][0][RTW89_WW][12] = 0,
	[1][0][0][0][RTW89_WW][13] = 0,
	[1][1][0][0][RTW89_WW][0] = 0,
	[1][1][0][0][RTW89_WW][1] = 0,
	[1][1][0][0][RTW89_WW][2] = 38,
	[1][1][0][0][RTW89_WW][3] = 38,
	[1][1][0][0][RTW89_WW][4] = 38,
	[1][1][0][0][RTW89_WW][5] = 48,
	[1][1][0][0][RTW89_WW][6] = 26,
	[1][1][0][0][RTW89_WW][7] = 26,
	[1][1][0][0][RTW89_WW][8] = 26,
	[1][1][0][0][RTW89_WW][9] = 22,
	[1][1][0][0][RTW89_WW][10] = 22,
	[1][1][0][0][RTW89_WW][11] = 0,
	[1][1][0][0][RTW89_WW][12] = 0,
	[1][1][0][0][RTW89_WW][13] = 0,
	[0][0][1][0][RTW89_WW][0] = 60,
	[0][0][1][0][RTW89_WW][1] = 60,
	[0][0][1][0][RTW89_WW][2] = 60,
	[0][0][1][0][RTW89_WW][3] = 60,
	[0][0][1][0][RTW89_WW][4] = 60,
	[0][0][1][0][RTW89_WW][5] = 60,
	[0][0][1][0][RTW89_WW][6] = 60,
	[0][0][1][0][RTW89_WW][7] = 60,
	[0][0][1][0][RTW89_WW][8] = 60,
	[0][0][1][0][RTW89_WW][9] = 60,
	[0][0][1][0][RTW89_WW][10] = 60,
	[0][0][1][0][RTW89_WW][11] = 46,
	[0][0][1][0][RTW89_WW][12] = 42,
	[0][0][1][0][RTW89_WW][13] = 0,
	[0][1][1][0][RTW89_WW][0] = 48,
	[0][1][1][0][RTW89_WW][1] = 48,
	[0][1][1][0][RTW89_WW][2] = 48,
	[0][1][1][0][RTW89_WW][3] = 48,
	[0][1][1][0][RTW89_WW][4] = 48,
	[0][1][1][0][RTW89_WW][5] = 48,
	[0][1][1][0][RTW89_WW][6] = 48,
	[0][1][1][0][RTW89_WW][7] = 48,
	[0][1][1][0][RTW89_WW][8] = 48,
	[0][1][1][0][RTW89_WW][9] = 48,
	[0][1][1][0][RTW89_WW][10] = 48,
	[0][1][1][0][RTW89_WW][11] = 38,
	[0][1][1][0][RTW89_WW][12] = 34,
	[0][1][1][0][RTW89_WW][13] = 0,
	[0][0][2][0][RTW89_WW][0] = 60,
	[0][0][2][0][RTW89_WW][1] = 60,
	[0][0][2][0][RTW89_WW][2] = 60,
	[0][0][2][0][RTW89_WW][3] = 60,
	[0][0][2][0][RTW89_WW][4] = 60,
	[0][0][2][0][RTW89_WW][5] = 60,
	[0][0][2][0][RTW89_WW][6] = 60,
	[0][0][2][0][RTW89_WW][7] = 60,
	[0][0][2][0][RTW89_WW][8] = 60,
	[0][0][2][0][RTW89_WW][9] = 60,
	[0][0][2][0][RTW89_WW][10] = 60,
	[0][0][2][0][RTW89_WW][11] = 46,
	[0][0][2][0][RTW89_WW][12] = 42,
	[0][0][2][0][RTW89_WW][13] = 0,
	[0][1][2][0][RTW89_WW][0] = 48,
	[0][1][2][0][RTW89_WW][1] = 48,
	[0][1][2][0][RTW89_WW][2] = 48,
	[0][1][2][0][RTW89_WW][3] = 48,
	[0][1][2][0][RTW89_WW][4] = 48,
	[0][1][2][0][RTW89_WW][5] = 48,
	[0][1][2][0][RTW89_WW][6] = 48,
	[0][1][2][0][RTW89_WW][7] = 48,
	[0][1][2][0][RTW89_WW][8] = 48,
	[0][1][2][0][RTW89_WW][9] = 48,
	[0][1][2][0][RTW89_WW][10] = 48,
	[0][1][2][0][RTW89_WW][11] = 38,
	[0][1][2][0][RTW89_WW][12] = 34,
	[0][1][2][0][RTW89_WW][13] = 0,
	[0][1][2][1][RTW89_WW][0] = 36,
	[0][1][2][1][RTW89_WW][1] = 36,
	[0][1][2][1][RTW89_WW][2] = 36,
	[0][1][2][1][RTW89_WW][3] = 36,
	[0][1][2][1][RTW89_WW][4] = 36,
	[0][1][2][1][RTW89_WW][5] = 36,
	[0][1][2][1][RTW89_WW][6] = 36,
	[0][1][2][1][RTW89_WW][7] = 36,
	[0][1][2][1][RTW89_WW][8] = 36,
	[0][1][2][1][RTW89_WW][9] = 36,
	[0][1][2][1][RTW89_WW][10] = 36,
	[0][1][2][1][RTW89_WW][11] = 36,
	[0][1][2][1][RTW89_WW][12] = 34,
	[0][1][2][1][RTW89_WW][13] = 0,
	[1][0][2][0][RTW89_WW][0] = 0,
	[1][0][2][0][RTW89_WW][1] = 0,
	[1][0][2][0][RTW89_WW][2] = 60,
	[1][0][2][0][RTW89_WW][3] = 60,
	[1][0][2][0][RTW89_WW][4] = 60,
	[1][0][2][0][RTW89_WW][5] = 60,
	[1][0][2][0][RTW89_WW][6] = 60,
	[1][0][2][0][RTW89_WW][7] = 60,
	[1][0][2][0][RTW89_WW][8] = 60,
	[1][0][2][0][RTW89_WW][9] = 60,
	[1][0][2][0][RTW89_WW][10] = 58,
	[1][0][2][0][RTW89_WW][11] = 0,
	[1][0][2][0][RTW89_WW][12] = 0,
	[1][0][2][0][RTW89_WW][13] = 0,
	[1][1][2][0][RTW89_WW][0] = 0,
	[1][1][2][0][RTW89_WW][1] = 0,
	[1][1][2][0][RTW89_WW][2] = 46,
	[1][1][2][0][RTW89_WW][3] = 46,
	[1][1][2][0][RTW89_WW][4] = 48,
	[1][1][2][0][RTW89_WW][5] = 48,
	[1][1][2][0][RTW89_WW][6] = 48,
	[1][1][2][0][RTW89_WW][7] = 46,
	[1][1][2][0][RTW89_WW][8] = 46,
	[1][1][2][0][RTW89_WW][9] = 34,
	[1][1][2][0][RTW89_WW][10] = 30,
	[1][1][2][0][RTW89_WW][11] = 0,
	[1][1][2][0][RTW89_WW][12] = 0,
	[1][1][2][0][RTW89_WW][13] = 0,
	[1][1][2][1][RTW89_WW][0] = 0,
	[1][1][2][1][RTW89_WW][1] = 0,
	[1][1][2][1][RTW89_WW][2] = 36,
	[1][1][2][1][RTW89_WW][3] = 36,
	[1][1][2][1][RTW89_WW][4] = 36,
	[1][1][2][1][RTW89_WW][5] = 36,
	[1][1][2][1][RTW89_WW][6] = 36,
	[1][1][2][1][RTW89_WW][7] = 36,
	[1][1][2][1][RTW89_WW][8] = 36,
	[1][1][2][1][RTW89_WW][9] = 34,
	[1][1][2][1][RTW89_WW][10] = 30,
	[1][1][2][1][RTW89_WW][11] = 0,
	[1][1][2][1][RTW89_WW][12] = 0,
	[1][1][2][1][RTW89_WW][13] = 0,
	[0][0][0][0][RTW89_FCC][0] = 70,
	[0][0][0][0][RTW89_ETSI][0] = 60,
	[0][0][0][0][RTW89_MKK][0] = 68,
	[0][0][0][0][RTW89_IC][0] = 74,
	[0][0][0][0][RTW89_ACMA][0] = 60,
	[0][0][0][0][RTW89_FCC][1] = 70,
	[0][0][0][0][RTW89_ETSI][1] = 60,
	[0][0][0][0][RTW89_MKK][1] = 68,
	[0][0][0][0][RTW89_IC][1] = 74,
	[0][0][0][0][RTW89_ACMA][1] = 60,
	[0][0][0][0][RTW89_FCC][2] = 70,
	[0][0][0][0][RTW89_ETSI][2] = 60,
	[0][0][0][0][RTW89_MKK][2] = 68,
	[0][0][0][0][RTW89_IC][2] = 74,
	[0][0][0][0][RTW89_ACMA][2] = 60,
	[0][0][0][0][RTW89_FCC][3] = 70,
	[0][0][0][0][RTW89_ETSI][3] = 60,
	[0][0][0][0][RTW89_MKK][3] = 68,
	[0][0][0][0][RTW89_IC][3] = 74,
	[0][0][0][0][RTW89_ACMA][3] = 60,
	[0][0][0][0][RTW89_FCC][4] = 70,
	[0][0][0][0][RTW89_ETSI][4] = 60,
	[0][0][0][0][RTW89_MKK][4] = 68,
	[0][0][0][0][RTW89_IC][4] = 74,
	[0][0][0][0][RTW89_ACMA][4] = 60,
	[0][0][0][0][RTW89_FCC][5] = 70,
	[0][0][0][0][RTW89_ETSI][5] = 60,
	[0][0][0][0][RTW89_MKK][5] = 68,
	[0][0][0][0][RTW89_IC][5] = 74,
	[0][0][0][0][RTW89_ACMA][5] = 60,
	[0][0][0][0][RTW89_FCC][6] = 70,
	[0][0][0][0][RTW89_ETSI][6] = 60,
	[0][0][0][0][RTW89_MKK][6] = 68,
	[0][0][0][0][RTW89_IC][6] = 74,
	[0][0][0][0][RTW89_ACMA][6] = 60,
	[0][0][0][0][RTW89_FCC][7] = 70,
	[0][0][0][0][RTW89_ETSI][7] = 60,
	[0][0][0][0][RTW89_MKK][7] = 68,
	[0][0][0][0][RTW89_IC][7] = 74,
	[0][0][0][0][RTW89_ACMA][7] = 60,
	[0][0][0][0][RTW89_FCC][8] = 70,
	[0][0][0][0][RTW89_ETSI][8] = 60,
	[0][0][0][0][RTW89_MKK][8] = 68,
	[0][0][0][0][RTW89_IC][8] = 74,
	[0][0][0][0][RTW89_ACMA][8] = 60,
	[0][0][0][0][RTW89_FCC][9] = 70,
	[0][0][0][0][RTW89_ETSI][9] = 60,
	[0][0][0][0][RTW89_MKK][9] = 68,
	[0][0][0][0][RTW89_IC][9] = 74,
	[0][0][0][0][RTW89_ACMA][9] = 60,
	[0][0][0][0][RTW89_FCC][10] = 70,
	[0][0][0][0][RTW89_ETSI][10] = 60,
	[0][0][0][0][RTW89_MKK][10] = 68,
	[0][0][0][0][RTW89_IC][10] = 74,
	[0][0][0][0][RTW89_ACMA][10] = 60,
	[0][0][0][0][RTW89_FCC][11] = 62,
	[0][0][0][0][RTW89_ETSI][11] = 60,
	[0][0][0][0][RTW89_MKK][11] = 68,
	[0][0][0][0][RTW89_IC][11] = 72,
	[0][0][0][0][RTW89_ACMA][11] = 60,
	[0][0][0][0][RTW89_FCC][12] = 48,
	[0][0][0][0][RTW89_ETSI][12] = 60,
	[0][0][0][0][RTW89_MKK][12] = 68,
	[0][0][0][0][RTW89_IC][12] = 58,
	[0][0][0][0][RTW89_ACMA][12] = 60,
	[0][0][0][0][RTW89_FCC][13] = 127,
	[0][0][0][0][RTW89_ETSI][13] = 127,
	[0][0][0][0][RTW89_MKK][13] = 72,
	[0][0][0][0][RTW89_IC][13] = 127,
	[0][0][0][0][RTW89_ACMA][13] = 127,
	[0][1][0][0][RTW89_FCC][0] = 66,
	[0][1][0][0][RTW89_ETSI][0] = 48,
	[0][1][0][0][RTW89_MKK][0] = 58,
	[0][1][0][0][RTW89_IC][0] = 74,
	[0][1][0][0][RTW89_ACMA][0] = 48,
	[0][1][0][0][RTW89_FCC][1] = 66,
	[0][1][0][0][RTW89_ETSI][1] = 48,
	[0][1][0][0][RTW89_MKK][1] = 58,
	[0][1][0][0][RTW89_IC][1] = 74,
	[0][1][0][0][RTW89_ACMA][1] = 48,
	[0][1][0][0][RTW89_FCC][2] = 66,
	[0][1][0][0][RTW89_ETSI][2] = 48,
	[0][1][0][0][RTW89_MKK][2] = 58,
	[0][1][0][0][RTW89_IC][2] = 74,
	[0][1][0][0][RTW89_ACMA][2] = 48,
	[0][1][0][0][RTW89_FCC][3] = 66,
	[0][1][0][0][RTW89_ETSI][3] = 48,
	[0][1][0][0][RTW89_MKK][3] = 58,
	[0][1][0][0][RTW89_IC][3] = 74,
	[0][1][0][0][RTW89_ACMA][3] = 48,
	[0][1][0][0][RTW89_FCC][4] = 66,
	[0][1][0][0][RTW89_ETSI][4] = 48,
	[0][1][0][0][RTW89_MKK][4] = 58,
	[0][1][0][0][RTW89_IC][4] = 74,
	[0][1][0][0][RTW89_ACMA][4] = 48,
	[0][1][0][0][RTW89_FCC][5] = 66,
	[0][1][0][0][RTW89_ETSI][5] = 48,
	[0][1][0][0][RTW89_MKK][5] = 58,
	[0][1][0][0][RTW89_IC][5] = 74,
	[0][1][0][0][RTW89_ACMA][5] = 48,
	[0][1][0][0][RTW89_FCC][6] = 66,
	[0][1][0][0][RTW89_ETSI][6] = 48,
	[0][1][0][0][RTW89_MKK][6] = 58,
	[0][1][0][0][RTW89_IC][6] = 74,
	[0][1][0][0][RTW89_ACMA][6] = 48,
	[0][1][0][0][RTW89_FCC][7] = 66,
	[0][1][0][0][RTW89_ETSI][7] = 48,
	[0][1][0][0][RTW89_MKK][7] = 58,
	[0][1][0][0][RTW89_IC][7] = 74,
	[0][1][0][0][RTW89_ACMA][7] = 48,
	[0][1][0][0][RTW89_FCC][8] = 66,
	[0][1][0][0][RTW89_ETSI][8] = 48,
	[0][1][0][0][RTW89_MKK][8] = 58,
	[0][1][0][0][RTW89_IC][8] = 74,
	[0][1][0][0][RTW89_ACMA][8] = 48,
	[0][1][0][0][RTW89_FCC][9] = 66,
	[0][1][0][0][RTW89_ETSI][9] = 48,
	[0][1][0][0][RTW89_MKK][9] = 58,
	[0][1][0][0][RTW89_IC][9] = 74,
	[0][1][0][0][RTW89_ACMA][9] = 48,
	[0][1][0][0][RTW89_FCC][10] = 66,
	[0][1][0][0][RTW89_ETSI][10] = 48,
	[0][1][0][0][RTW89_MKK][10] = 58,
	[0][1][0][0][RTW89_IC][10] = 74,
	[0][1][0][0][RTW89_ACMA][10] = 48,
	[0][1][0][0][RTW89_FCC][11] = 46,
	[0][1][0][0][RTW89_ETSI][11] = 48,
	[0][1][0][0][RTW89_MKK][11] = 58,
	[0][1][0][0][RTW89_IC][11] = 56,
	[0][1][0][0][RTW89_ACMA][11] = 48,
	[0][1][0][0][RTW89_FCC][12] = 34,
	[0][1][0][0][RTW89_ETSI][12] = 48,
	[0][1][0][0][RTW89_MKK][12] = 58,
	[0][1][0][0][RTW89_IC][12] = 44,
	[0][1][0][0][RTW89_ACMA][12] = 48,
	[0][1][0][0][RTW89_FCC][13] = 127,
	[0][1][0][0][RTW89_ETSI][13] = 127,
	[0][1][0][0][RTW89_MKK][13] = 60,
	[0][1][0][0][RTW89_IC][13] = 127,
	[0][1][0][0][RTW89_ACMA][13] = 127,
	[1][0][0][0][RTW89_FCC][0] = 127,
	[1][0][0][0][RTW89_ETSI][0] = 127,
	[1][0][0][0][RTW89_MKK][0] = 127,
	[1][0][0][0][RTW89_IC][0] = 127,
	[1][0][0][0][RTW89_ACMA][0] = 127,
	[1][0][0][0][RTW89_FCC][1] = 127,
	[1][0][0][0][RTW89_ETSI][1] = 127,
	[1][0][0][0][RTW89_MKK][1] = 127,
	[1][0][0][0][RTW89_IC][1] = 127,
	[1][0][0][0][RTW89_ACMA][1] = 127,
	[1][0][0][0][RTW89_FCC][2] = 42,
	[1][0][0][0][RTW89_ETSI][2] = 60,
	[1][0][0][0][RTW89_MKK][2] = 66,
	[1][0][0][0][RTW89_IC][2] = 52,
	[1][0][0][0][RTW89_ACMA][2] = 60,
	[1][0][0][0][RTW89_FCC][3] = 42,
	[1][0][0][0][RTW89_ETSI][3] = 60,
	[1][0][0][0][RTW89_MKK][3] = 66,
	[1][0][0][0][RTW89_IC][3] = 52,
	[1][0][0][0][RTW89_ACMA][3] = 60,
	[1][0][0][0][RTW89_FCC][4] = 42,
	[1][0][0][0][RTW89_ETSI][4] = 60,
	[1][0][0][0][RTW89_MKK][4] = 66,
	[1][0][0][0][RTW89_IC][4] = 52,
	[1][0][0][0][RTW89_ACMA][4] = 60,
	[1][0][0][0][RTW89_FCC][5] = 58,
	[1][0][0][0][RTW89_ETSI][5] = 60,
	[1][0][0][0][RTW89_MKK][5] = 66,
	[1][0][0][0][RTW89_IC][5] = 68,
	[1][0][0][0][RTW89_ACMA][5] = 60,
	[1][0][0][0][RTW89_FCC][6] = 42,
	[1][0][0][0][RTW89_ETSI][6] = 60,
	[1][0][0][0][RTW89_MKK][6] = 66,
	[1][0][0][0][RTW89_IC][6] = 52,
	[1][0][0][0][RTW89_ACMA][6] = 60,
	[1][0][0][0][RTW89_FCC][7] = 42,
	[1][0][0][0][RTW89_ETSI][7] = 60,
	[1][0][0][0][RTW89_MKK][7] = 66,
	[1][0][0][0][RTW89_IC][7] = 52,
	[1][0][0][0][RTW89_ACMA][7] = 60,
	[1][0][0][0][RTW89_FCC][8] = 42,
	[1][0][0][0][RTW89_ETSI][8] = 60,
	[1][0][0][0][RTW89_MKK][8] = 66,
	[1][0][0][0][RTW89_IC][8] = 52,
	[1][0][0][0][RTW89_ACMA][8] = 60,
	[1][0][0][0][RTW89_FCC][9] = 34,
	[1][0][0][0][RTW89_ETSI][9] = 60,
	[1][0][0][0][RTW89_MKK][9] = 66,
	[1][0][0][0][RTW89_IC][9] = 44,
	[1][0][0][0][RTW89_ACMA][9] = 60,
	[1][0][0][0][RTW89_FCC][10] = 22,
	[1][0][0][0][RTW89_ETSI][10] = 60,
	[1][0][0][0][RTW89_MKK][10] = 66,
	[1][0][0][0][RTW89_IC][10] = 32,
	[1][0][0][0][RTW89_ACMA][10] = 60,
	[1][0][0][0][RTW89_FCC][11] = 127,
	[1][0][0][0][RTW89_ETSI][11] = 127,
	[1][0][0][0][RTW89_MKK][11] = 127,
	[1][0][0][0][RTW89_IC][11] = 127,
	[1][0][0][0][RTW89_ACMA][11] = 127,
	[1][0][0][0][RTW89_FCC][12] = 127,
	[1][0][0][0][RTW89_ETSI][12] = 127,
	[1][0][0][0][RTW89_MKK][12] = 127,
	[1][0][0][0][RTW89_IC][12] = 127,
	[1][0][0][0][RTW89_ACMA][12] = 127,
	[1][0][0][0][RTW89_FCC][13] = 127,
	[1][0][0][0][RTW89_ETSI][13] = 127,
	[1][0][0][0][RTW89_MKK][13] = 127,
	[1][0][0][0][RTW89_IC][13] = 127,
	[1][0][0][0][RTW89_ACMA][13] = 127,
	[1][1][0][0][RTW89_FCC][0] = 127,
	[1][1][0][0][RTW89_ETSI][0] = 127,
	[1][1][0][0][RTW89_MKK][0] = 127,
	[1][1][0][0][RTW89_IC][0] = 127,
	[1][1][0][0][RTW89_ACMA][0] = 127,
	[1][1][0][0][RTW89_FCC][1] = 127,
	[1][1][0][0][RTW89_ETSI][1] = 127,
	[1][1][0][0][RTW89_MKK][1] = 127,
	[1][1][0][0][RTW89_IC][1] = 127,
	[1][1][0][0][RTW89_ACMA][1] = 127,
	[1][1][0][0][RTW89_FCC][2] = 38,
	[1][1][0][0][RTW89_ETSI][2] = 48,
	[1][1][0][0][RTW89_MKK][2] = 58,
	[1][1][0][0][RTW89_IC][2] = 48,
	[1][1][0][0][RTW89_ACMA][2] = 48,
	[1][1][0][0][RTW89_FCC][3] = 38,
	[1][1][0][0][RTW89_ETSI][3] = 48,
	[1][1][0][0][RTW89_MKK][3] = 58,
	[1][1][0][0][RTW89_IC][3] = 48,
	[1][1][0][0][RTW89_ACMA][3] = 48,
	[1][1][0][0][RTW89_FCC][4] = 38,
	[1][1][0][0][RTW89_ETSI][4] = 48,
	[1][1][0][0][RTW89_MKK][4] = 58,
	[1][1][0][0][RTW89_IC][4] = 48,
	[1][1][0][0][RTW89_ACMA][4] = 48,
	[1][1][0][0][RTW89_FCC][5] = 54,
	[1][1][0][0][RTW89_ETSI][5] = 48,
	[1][1][0][0][RTW89_MKK][5] = 58,
	[1][1][0][0][RTW89_IC][5] = 64,
	[1][1][0][0][RTW89_ACMA][5] = 48,
	[1][1][0][0][RTW89_FCC][6] = 26,
	[1][1][0][0][RTW89_ETSI][6] = 48,
	[1][1][0][0][RTW89_MKK][6] = 58,
	[1][1][0][0][RTW89_IC][6] = 36,
	[1][1][0][0][RTW89_ACMA][6] = 48,
	[1][1][0][0][RTW89_FCC][7] = 26,
	[1][1][0][0][RTW89_ETSI][7] = 48,
	[1][1][0][0][RTW89_MKK][7] = 58,
	[1][1][0][0][RTW89_IC][7] = 36,
	[1][1][0][0][RTW89_ACMA][7] = 48,
	[1][1][0][0][RTW89_FCC][8] = 26,
	[1][1][0][0][RTW89_ETSI][8] = 48,
	[1][1][0][0][RTW89_MKK][8] = 58,
	[1][1][0][0][RTW89_IC][8] = 36,
	[1][1][0][0][RTW89_ACMA][8] = 48,
	[1][1][0][0][RTW89_FCC][9] = 22,
	[1][1][0][0][RTW89_ETSI][9] = 48,
	[1][1][0][0][RTW89_MKK][9] = 58,
	[1][1][0][0][RTW89_IC][9] = 32,
	[1][1][0][0][RTW89_ACMA][9] = 48,
	[1][1][0][0][RTW89_FCC][10] = 22,
	[1][1][0][0][RTW89_ETSI][10] = 48,
	[1][1][0][0][RTW89_MKK][10] = 56,
	[1][1][0][0][RTW89_IC][10] = 32,
	[1][1][0][0][RTW89_ACMA][10] = 48,
	[1][1][0][0][RTW89_FCC][11] = 127,
	[1][1][0][0][RTW89_ETSI][11] = 127,
	[1][1][0][0][RTW89_MKK][11] = 127,
	[1][1][0][0][RTW89_IC][11] = 127,
	[1][1][0][0][RTW89_ACMA][11] = 127,
	[1][1][0][0][RTW89_FCC][12] = 127,
	[1][1][0][0][RTW89_ETSI][12] = 127,
	[1][1][0][0][RTW89_MKK][12] = 127,
	[1][1][0][0][RTW89_IC][12] = 127,
	[1][1][0][0][RTW89_ACMA][12] = 127,
	[1][1][0][0][RTW89_FCC][13] = 127,
	[1][1][0][0][RTW89_ETSI][13] = 127,
	[1][1][0][0][RTW89_MKK][13] = 127,
	[1][1][0][0][RTW89_IC][13] = 127,
	[1][1][0][0][RTW89_ACMA][13] = 127,
	[0][0][1][0][RTW89_FCC][0] = 68,
	[0][0][1][0][RTW89_ETSI][0] = 60,
	[0][0][1][0][RTW89_MKK][0] = 76,
	[0][0][1][0][RTW89_IC][0] = 78,
	[0][0][1][0][RTW89_ACMA][0] = 60,
	[0][0][1][0][RTW89_FCC][1] = 68,
	[0][0][1][0][RTW89_ETSI][1] = 60,
	[0][0][1][0][RTW89_MKK][1] = 78,
	[0][0][1][0][RTW89_IC][1] = 78,
	[0][0][1][0][RTW89_ACMA][1] = 60,
	[0][0][1][0][RTW89_FCC][2] = 70,
	[0][0][1][0][RTW89_ETSI][2] = 60,
	[0][0][1][0][RTW89_MKK][2] = 78,
	[0][0][1][0][RTW89_IC][2] = 78,
	[0][0][1][0][RTW89_ACMA][2] = 60,
	[0][0][1][0][RTW89_FCC][3] = 70,
	[0][0][1][0][RTW89_ETSI][3] = 60,
	[0][0][1][0][RTW89_MKK][3] = 78,
	[0][0][1][0][RTW89_IC][3] = 78,
	[0][0][1][0][RTW89_ACMA][3] = 60,
	[0][0][1][0][RTW89_FCC][4] = 70,
	[0][0][1][0][RTW89_ETSI][4] = 60,
	[0][0][1][0][RTW89_MKK][4] = 78,
	[0][0][1][0][RTW89_IC][4] = 78,
	[0][0][1][0][RTW89_ACMA][4] = 60,
	[0][0][1][0][RTW89_FCC][5] = 70,
	[0][0][1][0][RTW89_ETSI][5] = 60,
	[0][0][1][0][RTW89_MKK][5] = 78,
	[0][0][1][0][RTW89_IC][5] = 78,
	[0][0][1][0][RTW89_ACMA][5] = 60,
	[0][0][1][0][RTW89_FCC][6] = 70,
	[0][0][1][0][RTW89_ETSI][6] = 60,
	[0][0][1][0][RTW89_MKK][6] = 76,
	[0][0][1][0][RTW89_IC][6] = 78,
	[0][0][1][0][RTW89_ACMA][6] = 60,
	[0][0][1][0][RTW89_FCC][7] = 70,
	[0][0][1][0][RTW89_ETSI][7] = 60,
	[0][0][1][0][RTW89_MKK][7] = 78,
	[0][0][1][0][RTW89_IC][7] = 78,
	[0][0][1][0][RTW89_ACMA][7] = 60,
	[0][0][1][0][RTW89_FCC][8] = 70,
	[0][0][1][0][RTW89_ETSI][8] = 60,
	[0][0][1][0][RTW89_MKK][8] = 78,
	[0][0][1][0][RTW89_IC][8] = 78,
	[0][0][1][0][RTW89_ACMA][8] = 60,
	[0][0][1][0][RTW89_FCC][9] = 66,
	[0][0][1][0][RTW89_ETSI][9] = 60,
	[0][0][1][0][RTW89_MKK][9] = 78,
	[0][0][1][0][RTW89_IC][9] = 76,
	[0][0][1][0][RTW89_ACMA][9] = 60,
	[0][0][1][0][RTW89_FCC][10] = 66,
	[0][0][1][0][RTW89_ETSI][10] = 60,
	[0][0][1][0][RTW89_MKK][10] = 78,
	[0][0][1][0][RTW89_IC][10] = 76,
	[0][0][1][0][RTW89_ACMA][10] = 60,
	[0][0][1][0][RTW89_FCC][11] = 46,
	[0][0][1][0][RTW89_ETSI][11] = 60,
	[0][0][1][0][RTW89_MKK][11] = 78,
	[0][0][1][0][RTW89_IC][11] = 56,
	[0][0][1][0][RTW89_ACMA][11] = 60,
	[0][0][1][0][RTW89_FCC][12] = 42,
	[0][0][1][0][RTW89_ETSI][12] = 60,
	[0][0][1][0][RTW89_MKK][12] = 78,
	[0][0][1][0][RTW89_IC][12] = 52,
	[0][0][1][0][RTW89_ACMA][12] = 60,
	[0][0][1][0][RTW89_FCC][13] = 127,
	[0][0][1][0][RTW89_ETSI][13] = 127,
	[0][0][1][0][RTW89_MKK][13] = 127,
	[0][0][1][0][RTW89_IC][13] = 127,
	[0][0][1][0][RTW89_ACMA][13] = 127,
	[0][1][1][0][RTW89_FCC][0] = 54,
	[0][1][1][0][RTW89_ETSI][0] = 48,
	[0][1][1][0][RTW89_MKK][0] = 66,
	[0][1][1][0][RTW89_IC][0] = 64,
	[0][1][1][0][RTW89_ACMA][0] = 48,
	[0][1][1][0][RTW89_FCC][1] = 54,
	[0][1][1][0][RTW89_ETSI][1] = 48,
	[0][1][1][0][RTW89_MKK][1] = 66,
	[0][1][1][0][RTW89_IC][1] = 64,
	[0][1][1][0][RTW89_ACMA][1] = 48,
	[0][1][1][0][RTW89_FCC][2] = 58,
	[0][1][1][0][RTW89_ETSI][2] = 48,
	[0][1][1][0][RTW89_MKK][2] = 66,
	[0][1][1][0][RTW89_IC][2] = 68,
	[0][1][1][0][RTW89_ACMA][2] = 48,
	[0][1][1][0][RTW89_FCC][3] = 62,
	[0][1][1][0][RTW89_ETSI][3] = 48,
	[0][1][1][0][RTW89_MKK][3] = 66,
	[0][1][1][0][RTW89_IC][3] = 72,
	[0][1][1][0][RTW89_ACMA][3] = 48,
	[0][1][1][0][RTW89_FCC][4] = 70,
	[0][1][1][0][RTW89_ETSI][4] = 48,
	[0][1][1][0][RTW89_MKK][4] = 66,
	[0][1][1][0][RTW89_IC][4] = 78,
	[0][1][1][0][RTW89_ACMA][4] = 48,
	[0][1][1][0][RTW89_FCC][5] = 70,
	[0][1][1][0][RTW89_ETSI][5] = 48,
	[0][1][1][0][RTW89_MKK][5] = 66,
	[0][1][1][0][RTW89_IC][5] = 78,
	[0][1][1][0][RTW89_ACMA][5] = 48,
	[0][1][1][0][RTW89_FCC][6] = 70,
	[0][1][1][0][RTW89_ETSI][6] = 48,
	[0][1][1][0][RTW89_MKK][6] = 66,
	[0][1][1][0][RTW89_IC][6] = 78,
	[0][1][1][0][RTW89_ACMA][6] = 48,
	[0][1][1][0][RTW89_FCC][7] = 62,
	[0][1][1][0][RTW89_ETSI][7] = 48,
	[0][1][1][0][RTW89_MKK][7] = 66,
	[0][1][1][0][RTW89_IC][7] = 72,
	[0][1][1][0][RTW89_ACMA][7] = 48,
	[0][1][1][0][RTW89_FCC][8] = 58,
	[0][1][1][0][RTW89_ETSI][8] = 48,
	[0][1][1][0][RTW89_MKK][8] = 66,
	[0][1][1][0][RTW89_IC][8] = 68,
	[0][1][1][0][RTW89_ACMA][8] = 48,
	[0][1][1][0][RTW89_FCC][9] = 54,
	[0][1][1][0][RTW89_ETSI][9] = 48,
	[0][1][1][0][RTW89_MKK][9] = 66,
	[0][1][1][0][RTW89_IC][9] = 64,
	[0][1][1][0][RTW89_ACMA][9] = 48,
	[0][1][1][0][RTW89_FCC][10] = 54,
	[0][1][1][0][RTW89_ETSI][10] = 48,
	[0][1][1][0][RTW89_MKK][10] = 66,
	[0][1][1][0][RTW89_IC][10] = 64,
	[0][1][1][0][RTW89_ACMA][10] = 48,
	[0][1][1][0][RTW89_FCC][11] = 38,
	[0][1][1][0][RTW89_ETSI][11] = 48,
	[0][1][1][0][RTW89_MKK][11] = 66,
	[0][1][1][0][RTW89_IC][11] = 48,
	[0][1][1][0][RTW89_ACMA][11] = 48,
	[0][1][1][0][RTW89_FCC][12] = 34,
	[0][1][1][0][RTW89_ETSI][12] = 48,
	[0][1][1][0][RTW89_MKK][12] = 66,
	[0][1][1][0][RTW89_IC][12] = 44,
	[0][1][1][0][RTW89_ACMA][12] = 48,
	[0][1][1][0][RTW89_FCC][13] = 127,
	[0][1][1][0][RTW89_ETSI][13] = 127,
	[0][1][1][0][RTW89_MKK][13] = 127,
	[0][1][1][0][RTW89_IC][13] = 127,
	[0][1][1][0][RTW89_ACMA][13] = 127,
	[0][0][2][0][RTW89_FCC][0] = 68,
	[0][0][2][0][RTW89_ETSI][0] = 60,
	[0][0][2][0][RTW89_MKK][0] = 78,
	[0][0][2][0][RTW89_IC][0] = 78,
	[0][0][2][0][RTW89_ACMA][0] = 60,
	[0][0][2][0][RTW89_FCC][1] = 68,
	[0][0][2][0][RTW89_ETSI][1] = 60,
	[0][0][2][0][RTW89_MKK][1] = 78,
	[0][0][2][0][RTW89_IC][1] = 78,
	[0][0][2][0][RTW89_ACMA][1] = 60,
	[0][0][2][0][RTW89_FCC][2] = 70,
	[0][0][2][0][RTW89_ETSI][2] = 60,
	[0][0][2][0][RTW89_MKK][2] = 78,
	[0][0][2][0][RTW89_IC][2] = 78,
	[0][0][2][0][RTW89_ACMA][2] = 60,
	[0][0][2][0][RTW89_FCC][3] = 70,
	[0][0][2][0][RTW89_ETSI][3] = 60,
	[0][0][2][0][RTW89_MKK][3] = 78,
	[0][0][2][0][RTW89_IC][3] = 78,
	[0][0][2][0][RTW89_ACMA][3] = 60,
	[0][0][2][0][RTW89_FCC][4] = 70,
	[0][0][2][0][RTW89_ETSI][4] = 60,
	[0][0][2][0][RTW89_MKK][4] = 78,
	[0][0][2][0][RTW89_IC][4] = 78,
	[0][0][2][0][RTW89_ACMA][4] = 60,
	[0][0][2][0][RTW89_FCC][5] = 70,
	[0][0][2][0][RTW89_ETSI][5] = 60,
	[0][0][2][0][RTW89_MKK][5] = 78,
	[0][0][2][0][RTW89_IC][5] = 78,
	[0][0][2][0][RTW89_ACMA][5] = 60,
	[0][0][2][0][RTW89_FCC][6] = 70,
	[0][0][2][0][RTW89_ETSI][6] = 60,
	[0][0][2][0][RTW89_MKK][6] = 78,
	[0][0][2][0][RTW89_IC][6] = 78,
	[0][0][2][0][RTW89_ACMA][6] = 60,
	[0][0][2][0][RTW89_FCC][7] = 70,
	[0][0][2][0][RTW89_ETSI][7] = 60,
	[0][0][2][0][RTW89_MKK][7] = 78,
	[0][0][2][0][RTW89_IC][7] = 78,
	[0][0][2][0][RTW89_ACMA][7] = 60,
	[0][0][2][0][RTW89_FCC][8] = 68,
	[0][0][2][0][RTW89_ETSI][8] = 60,
	[0][0][2][0][RTW89_MKK][8] = 78,
	[0][0][2][0][RTW89_IC][8] = 78,
	[0][0][2][0][RTW89_ACMA][8] = 60,
	[0][0][2][0][RTW89_FCC][9] = 64,
	[0][0][2][0][RTW89_ETSI][9] = 60,
	[0][0][2][0][RTW89_MKK][9] = 78,
	[0][0][2][0][RTW89_IC][9] = 74,
	[0][0][2][0][RTW89_ACMA][9] = 60,
	[0][0][2][0][RTW89_FCC][10] = 64,
	[0][0][2][0][RTW89_ETSI][10] = 60,
	[0][0][2][0][RTW89_MKK][10] = 78,
	[0][0][2][0][RTW89_IC][10] = 74,
	[0][0][2][0][RTW89_ACMA][10] = 60,
	[0][0][2][0][RTW89_FCC][11] = 46,
	[0][0][2][0][RTW89_ETSI][11] = 60,
	[0][0][2][0][RTW89_MKK][11] = 78,
	[0][0][2][0][RTW89_IC][11] = 56,
	[0][0][2][0][RTW89_ACMA][11] = 60,
	[0][0][2][0][RTW89_FCC][12] = 42,
	[0][0][2][0][RTW89_ETSI][12] = 60,
	[0][0][2][0][RTW89_MKK][12] = 78,
	[0][0][2][0][RTW89_IC][12] = 52,
	[0][0][2][0][RTW89_ACMA][12] = 60,
	[0][0][2][0][RTW89_FCC][13] = 127,
	[0][0][2][0][RTW89_ETSI][13] = 127,
	[0][0][2][0][RTW89_MKK][13] = 127,
	[0][0][2][0][RTW89_IC][13] = 127,
	[0][0][2][0][RTW89_ACMA][13] = 127,
	[0][1][2][0][RTW89_FCC][0] = 50,
	[0][1][2][0][RTW89_ETSI][0] = 48,
	[0][1][2][0][RTW89_MKK][0] = 68,
	[0][1][2][0][RTW89_IC][0] = 60,
	[0][1][2][0][RTW89_ACMA][0] = 48,
	[0][1][2][0][RTW89_FCC][1] = 50,
	[0][1][2][0][RTW89_ETSI][1] = 48,
	[0][1][2][0][RTW89_MKK][1] = 68,
	[0][1][2][0][RTW89_IC][1] = 60,
	[0][1][2][0][RTW89_ACMA][1] = 48,
	[0][1][2][0][RTW89_FCC][2] = 54,
	[0][1][2][0][RTW89_ETSI][2] = 48,
	[0][1][2][0][RTW89_MKK][2] = 68,
	[0][1][2][0][RTW89_IC][2] = 64,
	[0][1][2][0][RTW89_ACMA][2] = 48,
	[0][1][2][0][RTW89_FCC][3] = 58,
	[0][1][2][0][RTW89_ETSI][3] = 48,
	[0][1][2][0][RTW89_MKK][3] = 68,
	[0][1][2][0][RTW89_IC][3] = 68,
	[0][1][2][0][RTW89_ACMA][3] = 48,
	[0][1][2][0][RTW89_FCC][4] = 64,
	[0][1][2][0][RTW89_ETSI][4] = 48,
	[0][1][2][0][RTW89_MKK][4] = 68,
	[0][1][2][0][RTW89_IC][4] = 74,
	[0][1][2][0][RTW89_ACMA][4] = 48,
	[0][1][2][0][RTW89_FCC][5] = 70,
	[0][1][2][0][RTW89_ETSI][5] = 48,
	[0][1][2][0][RTW89_MKK][5] = 68,
	[0][1][2][0][RTW89_IC][5] = 78,
	[0][1][2][0][RTW89_ACMA][5] = 48,
	[0][1][2][0][RTW89_FCC][6] = 66,
	[0][1][2][0][RTW89_ETSI][6] = 48,
	[0][1][2][0][RTW89_MKK][6] = 68,
	[0][1][2][0][RTW89_IC][6] = 76,
	[0][1][2][0][RTW89_ACMA][6] = 48,
	[0][1][2][0][RTW89_FCC][7] = 58,
	[0][1][2][0][RTW89_ETSI][7] = 48,
	[0][1][2][0][RTW89_MKK][7] = 68,
	[0][1][2][0][RTW89_IC][7] = 68,
	[0][1][2][0][RTW89_ACMA][7] = 48,
	[0][1][2][0][RTW89_FCC][8] = 54,
	[0][1][2][0][RTW89_ETSI][8] = 48,
	[0][1][2][0][RTW89_MKK][8] = 68,
	[0][1][2][0][RTW89_IC][8] = 64,
	[0][1][2][0][RTW89_ACMA][8] = 48,
	[0][1][2][0][RTW89_FCC][9] = 50,
	[0][1][2][0][RTW89_ETSI][9] = 48,
	[0][1][2][0][RTW89_MKK][9] = 68,
	[0][1][2][0][RTW89_IC][9] = 60,
	[0][1][2][0][RTW89_ACMA][9] = 48,
	[0][1][2][0][RTW89_FCC][10] = 50,
	[0][1][2][0][RTW89_ETSI][10] = 48,
	[0][1][2][0][RTW89_MKK][10] = 68,
	[0][1][2][0][RTW89_IC][10] = 60,
	[0][1][2][0][RTW89_ACMA][10] = 48,
	[0][1][2][0][RTW89_FCC][11] = 38,
	[0][1][2][0][RTW89_ETSI][11] = 48,
	[0][1][2][0][RTW89_MKK][11] = 68,
	[0][1][2][0][RTW89_IC][11] = 48,
	[0][1][2][0][RTW89_ACMA][11] = 48,
	[0][1][2][0][RTW89_FCC][12] = 34,
	[0][1][2][0][RTW89_ETSI][12] = 48,
	[0][1][2][0][RTW89_MKK][12] = 68,
	[0][1][2][0][RTW89_IC][12] = 44,
	[0][1][2][0][RTW89_ACMA][12] = 48,
	[0][1][2][0][RTW89_FCC][13] = 127,
	[0][1][2][0][RTW89_ETSI][13] = 127,
	[0][1][2][0][RTW89_MKK][13] = 127,
	[0][1][2][0][RTW89_IC][13] = 127,
	[0][1][2][0][RTW89_ACMA][13] = 127,
	[0][1][2][1][RTW89_FCC][0] = 50,
	[0][1][2][1][RTW89_ETSI][0] = 36,
	[0][1][2][1][RTW89_MKK][0] = 68,
	[0][1][2][1][RTW89_IC][0] = 60,
	[0][1][2][1][RTW89_ACMA][0] = 36,
	[0][1][2][1][RTW89_FCC][1] = 50,
	[0][1][2][1][RTW89_ETSI][1] = 36,
	[0][1][2][1][RTW89_MKK][1] = 68,
	[0][1][2][1][RTW89_IC][1] = 60,
	[0][1][2][1][RTW89_ACMA][1] = 36,
	[0][1][2][1][RTW89_FCC][2] = 54,
	[0][1][2][1][RTW89_ETSI][2] = 36,
	[0][1][2][1][RTW89_MKK][2] = 68,
	[0][1][2][1][RTW89_IC][2] = 64,
	[0][1][2][1][RTW89_ACMA][2] = 36,
	[0][1][2][1][RTW89_FCC][3] = 58,
	[0][1][2][1][RTW89_ETSI][3] = 36,
	[0][1][2][1][RTW89_MKK][3] = 68,
	[0][1][2][1][RTW89_IC][3] = 68,
	[0][1][2][1][RTW89_ACMA][3] = 36,
	[0][1][2][1][RTW89_FCC][4] = 64,
	[0][1][2][1][RTW89_ETSI][4] = 36,
	[0][1][2][1][RTW89_MKK][4] = 68,
	[0][1][2][1][RTW89_IC][4] = 74,
	[0][1][2][1][RTW89_ACMA][4] = 36,
	[0][1][2][1][RTW89_FCC][5] = 70,
	[0][1][2][1][RTW89_ETSI][5] = 36,
	[0][1][2][1][RTW89_MKK][5] = 68,
	[0][1][2][1][RTW89_IC][5] = 78,
	[0][1][2][1][RTW89_ACMA][5] = 36,
	[0][1][2][1][RTW89_FCC][6] = 66,
	[0][1][2][1][RTW89_ETSI][6] = 36,
	[0][1][2][1][RTW89_MKK][6] = 68,
	[0][1][2][1][RTW89_IC][6] = 76,
	[0][1][2][1][RTW89_ACMA][6] = 36,
	[0][1][2][1][RTW89_FCC][7] = 58,
	[0][1][2][1][RTW89_ETSI][7] = 36,
	[0][1][2][1][RTW89_MKK][7] = 68,
	[0][1][2][1][RTW89_IC][7] = 68,
	[0][1][2][1][RTW89_ACMA][7] = 36,
	[0][1][2][1][RTW89_FCC][8] = 54,
	[0][1][2][1][RTW89_ETSI][8] = 36,
	[0][1][2][1][RTW89_MKK][8] = 68,
	[0][1][2][1][RTW89_IC][8] = 64,
	[0][1][2][1][RTW89_ACMA][8] = 36,
	[0][1][2][1][RTW89_FCC][9] = 50,
	[0][1][2][1][RTW89_ETSI][9] = 36,
	[0][1][2][1][RTW89_MKK][9] = 68,
	[0][1][2][1][RTW89_IC][9] = 60,
	[0][1][2][1][RTW89_ACMA][9] = 36,
	[0][1][2][1][RTW89_FCC][10] = 50,
	[0][1][2][1][RTW89_ETSI][10] = 36,
	[0][1][2][1][RTW89_MKK][10] = 68,
	[0][1][2][1][RTW89_IC][10] = 60,
	[0][1][2][1][RTW89_ACMA][10] = 36,
	[0][1][2][1][RTW89_FCC][11] = 38,
	[0][1][2][1][RTW89_ETSI][11] = 36,
	[0][1][2][1][RTW89_MKK][11] = 68,
	[0][1][2][1][RTW89_IC][11] = 48,
	[0][1][2][1][RTW89_ACMA][11] = 36,
	[0][1][2][1][RTW89_FCC][12] = 34,
	[0][1][2][1][RTW89_ETSI][12] = 36,
	[0][1][2][1][RTW89_MKK][12] = 68,
	[0][1][2][1][RTW89_IC][12] = 44,
	[0][1][2][1][RTW89_ACMA][12] = 36,
	[0][1][2][1][RTW89_FCC][13] = 127,
	[0][1][2][1][RTW89_ETSI][13] = 127,
	[0][1][2][1][RTW89_MKK][13] = 127,
	[0][1][2][1][RTW89_IC][13] = 127,
	[0][1][2][1][RTW89_ACMA][13] = 127,
	[1][0][2][0][RTW89_FCC][0] = 127,
	[1][0][2][0][RTW89_ETSI][0] = 127,
	[1][0][2][0][RTW89_MKK][0] = 127,
	[1][0][2][0][RTW89_IC][0] = 127,
	[1][0][2][0][RTW89_ACMA][0] = 127,
	[1][0][2][0][RTW89_FCC][1] = 127,
	[1][0][2][0][RTW89_ETSI][1] = 127,
	[1][0][2][0][RTW89_MKK][1] = 127,
	[1][0][2][0][RTW89_IC][1] = 127,
	[1][0][2][0][RTW89_ACMA][1] = 127,
	[1][0][2][0][RTW89_FCC][2] = 62,
	[1][0][2][0][RTW89_ETSI][2] = 60,
	[1][0][2][0][RTW89_MKK][2] = 74,
	[1][0][2][0][RTW89_IC][2] = 72,
	[1][0][2][0][RTW89_ACMA][2] = 60,
	[1][0][2][0][RTW89_FCC][3] = 62,
	[1][0][2][0][RTW89_ETSI][3] = 60,
	[1][0][2][0][RTW89_MKK][3] = 74,
	[1][0][2][0][RTW89_IC][3] = 72,
	[1][0][2][0][RTW89_ACMA][3] = 60,
	[1][0][2][0][RTW89_FCC][4] = 64,
	[1][0][2][0][RTW89_ETSI][4] = 60,
	[1][0][2][0][RTW89_MKK][4] = 74,
	[1][0][2][0][RTW89_IC][4] = 74,
	[1][0][2][0][RTW89_ACMA][4] = 60,
	[1][0][2][0][RTW89_FCC][5] = 64,
	[1][0][2][0][RTW89_ETSI][5] = 60,
	[1][0][2][0][RTW89_MKK][5] = 74,
	[1][0][2][0][RTW89_IC][5] = 74,
	[1][0][2][0][RTW89_ACMA][5] = 60,
	[1][0][2][0][RTW89_FCC][6] = 64,
	[1][0][2][0][RTW89_ETSI][6] = 60,
	[1][0][2][0][RTW89_MKK][6] = 74,
	[1][0][2][0][RTW89_IC][6] = 74,
	[1][0][2][0][RTW89_ACMA][6] = 60,
	[1][0][2][0][RTW89_FCC][7] = 60,
	[1][0][2][0][RTW89_ETSI][7] = 60,
	[1][0][2][0][RTW89_MKK][7] = 74,
	[1][0][2][0][RTW89_IC][7] = 70,
	[1][0][2][0][RTW89_ACMA][7] = 60,
	[1][0][2][0][RTW89_FCC][8] = 60,
	[1][0][2][0][RTW89_ETSI][8] = 60,
	[1][0][2][0][RTW89_MKK][8] = 74,
	[1][0][2][0][RTW89_IC][8] = 70,
	[1][0][2][0][RTW89_ACMA][8] = 60,
	[1][0][2][0][RTW89_FCC][9] = 60,
	[1][0][2][0][RTW89_ETSI][9] = 60,
	[1][0][2][0][RTW89_MKK][9] = 74,
	[1][0][2][0][RTW89_IC][9] = 70,
	[1][0][2][0][RTW89_ACMA][9] = 60,
	[1][0][2][0][RTW89_FCC][10] = 58,
	[1][0][2][0][RTW89_ETSI][10] = 60,
	[1][0][2][0][RTW89_MKK][10] = 74,
	[1][0][2][0][RTW89_IC][10] = 68,
	[1][0][2][0][RTW89_ACMA][10] = 60,
	[1][0][2][0][RTW89_FCC][11] = 127,
	[1][0][2][0][RTW89_ETSI][11] = 127,
	[1][0][2][0][RTW89_MKK][11] = 127,
	[1][0][2][0][RTW89_IC][11] = 127,
	[1][0][2][0][RTW89_ACMA][11] = 127,
	[1][0][2][0][RTW89_FCC][12] = 127,
	[1][0][2][0][RTW89_ETSI][12] = 127,
	[1][0][2][0][RTW89_MKK][12] = 127,
	[1][0][2][0][RTW89_IC][12] = 127,
	[1][0][2][0][RTW89_ACMA][12] = 127,
	[1][0][2][0][RTW89_FCC][13] = 127,
	[1][0][2][0][RTW89_ETSI][13] = 127,
	[1][0][2][0][RTW89_MKK][13] = 127,
	[1][0][2][0][RTW89_IC][13] = 127,
	[1][0][2][0][RTW89_ACMA][13] = 127,
	[1][1][2][0][RTW89_FCC][0] = 127,
	[1][1][2][0][RTW89_ETSI][0] = 127,
	[1][1][2][0][RTW89_MKK][0] = 127,
	[1][1][2][0][RTW89_IC][0] = 127,
	[1][1][2][0][RTW89_ACMA][0] = 127,
	[1][1][2][0][RTW89_FCC][1] = 127,
	[1][1][2][0][RTW89_ETSI][1] = 127,
	[1][1][2][0][RTW89_MKK][1] = 127,
	[1][1][2][0][RTW89_IC][1] = 127,
	[1][1][2][0][RTW89_ACMA][1] = 127,
	[1][1][2][0][RTW89_FCC][2] = 46,
	[1][1][2][0][RTW89_ETSI][2] = 48,
	[1][1][2][0][RTW89_MKK][2] = 68,
	[1][1][2][0][RTW89_IC][2] = 56,
	[1][1][2][0][RTW89_ACMA][2] = 48,
	[1][1][2][0][RTW89_FCC][3] = 46,
	[1][1][2][0][RTW89_ETSI][3] = 48,
	[1][1][2][0][RTW89_MKK][3] = 68,
	[1][1][2][0][RTW89_IC][3] = 56,
	[1][1][2][0][RTW89_ACMA][3] = 48,
	[1][1][2][0][RTW89_FCC][4] = 50,
	[1][1][2][0][RTW89_ETSI][4] = 48,
	[1][1][2][0][RTW89_MKK][4] = 68,
	[1][1][2][0][RTW89_IC][4] = 60,
	[1][1][2][0][RTW89_ACMA][4] = 48,
	[1][1][2][0][RTW89_FCC][5] = 58,
	[1][1][2][0][RTW89_ETSI][5] = 48,
	[1][1][2][0][RTW89_MKK][5] = 68,
	[1][1][2][0][RTW89_IC][5] = 68,
	[1][1][2][0][RTW89_ACMA][5] = 48,
	[1][1][2][0][RTW89_FCC][6] = 50,
	[1][1][2][0][RTW89_ETSI][6] = 48,
	[1][1][2][0][RTW89_MKK][6] = 68,
	[1][1][2][0][RTW89_IC][6] = 60,
	[1][1][2][0][RTW89_ACMA][6] = 48,
	[1][1][2][0][RTW89_FCC][7] = 46,
	[1][1][2][0][RTW89_ETSI][7] = 48,
	[1][1][2][0][RTW89_MKK][7] = 68,
	[1][1][2][0][RTW89_IC][7] = 56,
	[1][1][2][0][RTW89_ACMA][7] = 48,
	[1][1][2][0][RTW89_FCC][8] = 46,
	[1][1][2][0][RTW89_ETSI][8] = 48,
	[1][1][2][0][RTW89_MKK][8] = 68,
	[1][1][2][0][RTW89_IC][8] = 56,
	[1][1][2][0][RTW89_ACMA][8] = 48,
	[1][1][2][0][RTW89_FCC][9] = 34,
	[1][1][2][0][RTW89_ETSI][9] = 48,
	[1][1][2][0][RTW89_MKK][9] = 68,
	[1][1][2][0][RTW89_IC][9] = 44,
	[1][1][2][0][RTW89_ACMA][9] = 48,
	[1][1][2][0][RTW89_FCC][10] = 30,
	[1][1][2][0][RTW89_ETSI][10] = 48,
	[1][1][2][0][RTW89_MKK][10] = 68,
	[1][1][2][0][RTW89_IC][10] = 40,
	[1][1][2][0][RTW89_ACMA][10] = 48,
	[1][1][2][0][RTW89_FCC][11] = 127,
	[1][1][2][0][RTW89_ETSI][11] = 127,
	[1][1][2][0][RTW89_MKK][11] = 127,
	[1][1][2][0][RTW89_IC][11] = 127,
	[1][1][2][0][RTW89_ACMA][11] = 127,
	[1][1][2][0][RTW89_FCC][12] = 127,
	[1][1][2][0][RTW89_ETSI][12] = 127,
	[1][1][2][0][RTW89_MKK][12] = 127,
	[1][1][2][0][RTW89_IC][12] = 127,
	[1][1][2][0][RTW89_ACMA][12] = 127,
	[1][1][2][0][RTW89_FCC][13] = 127,
	[1][1][2][0][RTW89_ETSI][13] = 127,
	[1][1][2][0][RTW89_MKK][13] = 127,
	[1][1][2][0][RTW89_IC][13] = 127,
	[1][1][2][0][RTW89_ACMA][13] = 127,
	[1][1][2][1][RTW89_FCC][0] = 127,
	[1][1][2][1][RTW89_ETSI][0] = 127,
	[1][1][2][1][RTW89_MKK][0] = 127,
	[1][1][2][1][RTW89_IC][0] = 127,
	[1][1][2][1][RTW89_ACMA][0] = 127,
	[1][1][2][1][RTW89_FCC][1] = 127,
	[1][1][2][1][RTW89_ETSI][1] = 127,
	[1][1][2][1][RTW89_MKK][1] = 127,
	[1][1][2][1][RTW89_IC][1] = 127,
	[1][1][2][1][RTW89_ACMA][1] = 127,
	[1][1][2][1][RTW89_FCC][2] = 46,
	[1][1][2][1][RTW89_ETSI][2] = 36,
	[1][1][2][1][RTW89_MKK][2] = 68,
	[1][1][2][1][RTW89_IC][2] = 56,
	[1][1][2][1][RTW89_ACMA][2] = 36,
	[1][1][2][1][RTW89_FCC][3] = 46,
	[1][1][2][1][RTW89_ETSI][3] = 36,
	[1][1][2][1][RTW89_MKK][3] = 68,
	[1][1][2][1][RTW89_IC][3] = 56,
	[1][1][2][1][RTW89_ACMA][3] = 36,
	[1][1][2][1][RTW89_FCC][4] = 50,
	[1][1][2][1][RTW89_ETSI][4] = 36,
	[1][1][2][1][RTW89_MKK][4] = 68,
	[1][1][2][1][RTW89_IC][4] = 60,
	[1][1][2][1][RTW89_ACMA][4] = 36,
	[1][1][2][1][RTW89_FCC][5] = 58,
	[1][1][2][1][RTW89_ETSI][5] = 36,
	[1][1][2][1][RTW89_MKK][5] = 68,
	[1][1][2][1][RTW89_IC][5] = 68,
	[1][1][2][1][RTW89_ACMA][5] = 36,
	[1][1][2][1][RTW89_FCC][6] = 50,
	[1][1][2][1][RTW89_ETSI][6] = 36,
	[1][1][2][1][RTW89_MKK][6] = 68,
	[1][1][2][1][RTW89_IC][6] = 60,
	[1][1][2][1][RTW89_ACMA][6] = 36,
	[1][1][2][1][RTW89_FCC][7] = 46,
	[1][1][2][1][RTW89_ETSI][7] = 36,
	[1][1][2][1][RTW89_MKK][7] = 68,
	[1][1][2][1][RTW89_IC][7] = 56,
	[1][1][2][1][RTW89_ACMA][7] = 36,
	[1][1][2][1][RTW89_FCC][8] = 46,
	[1][1][2][1][RTW89_ETSI][8] = 36,
	[1][1][2][1][RTW89_MKK][8] = 68,
	[1][1][2][1][RTW89_IC][8] = 56,
	[1][1][2][1][RTW89_ACMA][8] = 36,
	[1][1][2][1][RTW89_FCC][9] = 34,
	[1][1][2][1][RTW89_ETSI][9] = 36,
	[1][1][2][1][RTW89_MKK][9] = 68,
	[1][1][2][1][RTW89_IC][9] = 44,
	[1][1][2][1][RTW89_ACMA][9] = 36,
	[1][1][2][1][RTW89_FCC][10] = 30,
	[1][1][2][1][RTW89_ETSI][10] = 36,
	[1][1][2][1][RTW89_MKK][10] = 68,
	[1][1][2][1][RTW89_IC][10] = 40,
	[1][1][2][1][RTW89_ACMA][10] = 36,
	[1][1][2][1][RTW89_FCC][11] = 127,
	[1][1][2][1][RTW89_ETSI][11] = 127,
	[1][1][2][1][RTW89_MKK][11] = 127,
	[1][1][2][1][RTW89_IC][11] = 127,
	[1][1][2][1][RTW89_ACMA][11] = 127,
	[1][1][2][1][RTW89_FCC][12] = 127,
	[1][1][2][1][RTW89_ETSI][12] = 127,
	[1][1][2][1][RTW89_MKK][12] = 127,
	[1][1][2][1][RTW89_IC][12] = 127,
	[1][1][2][1][RTW89_ACMA][12] = 127,
	[1][1][2][1][RTW89_FCC][13] = 127,
	[1][1][2][1][RTW89_ETSI][13] = 127,
	[1][1][2][1][RTW89_MKK][13] = 127,
	[1][1][2][1][RTW89_IC][13] = 127,
	[1][1][2][1][RTW89_ACMA][13] = 127,
};

const s8 rtw89_8852c_txpwr_lmt_5g[RTW89_5G_BW_NUM][RTW89_NTX_NUM]
				 [RTW89_RS_LMT_NUM][RTW89_BF_NUM]
				 [RTW89_REGD_NUM][RTW89_5G_CH_NUM] = {
	[0][0][1][0][RTW89_WW][0] = 60,
	[0][0][1][0][RTW89_WW][2] = 60,
	[0][0][1][0][RTW89_WW][4] = 60,
	[0][0][1][0][RTW89_WW][6] = 60,
	[0][0][1][0][RTW89_WW][8] = 60,
	[0][0][1][0][RTW89_WW][10] = 60,
	[0][0][1][0][RTW89_WW][12] = 60,
	[0][0][1][0][RTW89_WW][14] = 60,
	[0][0][1][0][RTW89_WW][15] = 60,
	[0][0][1][0][RTW89_WW][17] = 60,
	[0][0][1][0][RTW89_WW][19] = 60,
	[0][0][1][0][RTW89_WW][21] = 60,
	[0][0][1][0][RTW89_WW][23] = 60,
	[0][0][1][0][RTW89_WW][25] = 66,
	[0][0][1][0][RTW89_WW][27] = 66,
	[0][0][1][0][RTW89_WW][29] = 66,
	[0][0][1][0][RTW89_WW][31] = 60,
	[0][0][1][0][RTW89_WW][33] = 60,
	[0][0][1][0][RTW89_WW][35] = 60,
	[0][0][1][0][RTW89_WW][37] = 70,
	[0][0][1][0][RTW89_WW][38] = 30,
	[0][0][1][0][RTW89_WW][40] = 30,
	[0][0][1][0][RTW89_WW][42] = 30,
	[0][0][1][0][RTW89_WW][44] = 30,
	[0][0][1][0][RTW89_WW][46] = 30,
	[0][0][1][0][RTW89_WW][48] = 70,
	[0][0][1][0][RTW89_WW][50] = 70,
	[0][0][1][0][RTW89_WW][52] = 70,
	[0][1][1][0][RTW89_WW][0] = 42,
	[0][1][1][0][RTW89_WW][2] = 42,
	[0][1][1][0][RTW89_WW][4] = 42,
	[0][1][1][0][RTW89_WW][6] = 42,
	[0][1][1][0][RTW89_WW][8] = 48,
	[0][1][1][0][RTW89_WW][10] = 48,
	[0][1][1][0][RTW89_WW][12] = 48,
	[0][1][1][0][RTW89_WW][14] = 48,
	[0][1][1][0][RTW89_WW][15] = 48,
	[0][1][1][0][RTW89_WW][17] = 48,
	[0][1][1][0][RTW89_WW][19] = 48,
	[0][1][1][0][RTW89_WW][21] = 48,
	[0][1][1][0][RTW89_WW][23] = 48,
	[0][1][1][0][RTW89_WW][25] = 54,
	[0][1][1][0][RTW89_WW][27] = 54,
	[0][1][1][0][RTW89_WW][29] = 54,
	[0][1][1][0][RTW89_WW][31] = 48,
	[0][1][1][0][RTW89_WW][33] = 48,
	[0][1][1][0][RTW89_WW][35] = 48,
	[0][1][1][0][RTW89_WW][37] = 60,
	[0][1][1][0][RTW89_WW][38] = 18,
	[0][1][1][0][RTW89_WW][40] = 16,
	[0][1][1][0][RTW89_WW][42] = 18,
	[0][1][1][0][RTW89_WW][44] = 16,
	[0][1][1][0][RTW89_WW][46] = 18,
	[0][1][1][0][RTW89_WW][48] = 48,
	[0][1][1][0][RTW89_WW][50] = 48,
	[0][1][1][0][RTW89_WW][52] = 48,
	[0][0][2][0][RTW89_WW][0] = 62,
	[0][0][2][0][RTW89_WW][2] = 62,
	[0][0][2][0][RTW89_WW][4] = 62,
	[0][0][2][0][RTW89_WW][6] = 60,
	[0][0][2][0][RTW89_WW][8] = 58,
	[0][0][2][0][RTW89_WW][10] = 62,
	[0][0][2][0][RTW89_WW][12] = 62,
	[0][0][2][0][RTW89_WW][14] = 62,
	[0][0][2][0][RTW89_WW][15] = 62,
	[0][0][2][0][RTW89_WW][17] = 62,
	[0][0][2][0][RTW89_WW][19] = 62,
	[0][0][2][0][RTW89_WW][21] = 62,
	[0][0][2][0][RTW89_WW][23] = 62,
	[0][0][2][0][RTW89_WW][25] = 66,
	[0][0][2][0][RTW89_WW][27] = 66,
	[0][0][2][0][RTW89_WW][29] = 66,
	[0][0][2][0][RTW89_WW][31] = 62,
	[0][0][2][0][RTW89_WW][33] = 62,
	[0][0][2][0][RTW89_WW][35] = 62,
	[0][0][2][0][RTW89_WW][37] = 70,
	[0][0][2][0][RTW89_WW][38] = 30,
	[0][0][2][0][RTW89_WW][40] = 30,
	[0][0][2][0][RTW89_WW][42] = 30,
	[0][0][2][0][RTW89_WW][44] = 30,
	[0][0][2][0][RTW89_WW][46] = 30,
	[0][0][2][0][RTW89_WW][48] = 70,
	[0][0][2][0][RTW89_WW][50] = 70,
	[0][0][2][0][RTW89_WW][52] = 70,
	[0][1][2][0][RTW89_WW][0] = 44,
	[0][1][2][0][RTW89_WW][2] = 44,
	[0][1][2][0][RTW89_WW][4] = 44,
	[0][1][2][0][RTW89_WW][6] = 44,
	[0][1][2][0][RTW89_WW][8] = 42,
	[0][1][2][0][RTW89_WW][10] = 50,
	[0][1][2][0][RTW89_WW][12] = 50,
	[0][1][2][0][RTW89_WW][14] = 50,
	[0][1][2][0][RTW89_WW][15] = 50,
	[0][1][2][0][RTW89_WW][17] = 50,
	[0][1][2][0][RTW89_WW][19] = 50,
	[0][1][2][0][RTW89_WW][21] = 50,
	[0][1][2][0][RTW89_WW][23] = 50,
	[0][1][2][0][RTW89_WW][25] = 54,
	[0][1][2][0][RTW89_WW][27] = 54,
	[0][1][2][0][RTW89_WW][29] = 54,
	[0][1][2][0][RTW89_WW][31] = 50,
	[0][1][2][0][RTW89_WW][33] = 50,
	[0][1][2][0][RTW89_WW][35] = 50,
	[0][1][2][0][RTW89_WW][37] = 62,
	[0][1][2][0][RTW89_WW][38] = 18,
	[0][1][2][0][RTW89_WW][40] = 18,
	[0][1][2][0][RTW89_WW][42] = 18,
	[0][1][2][0][RTW89_WW][44] = 18,
	[0][1][2][0][RTW89_WW][46] = 18,
	[0][1][2][0][RTW89_WW][48] = 50,
	[0][1][2][0][RTW89_WW][50] = 50,
	[0][1][2][0][RTW89_WW][52] = 50,
	[0][1][2][1][RTW89_WW][0] = 38,
	[0][1][2][1][RTW89_WW][2] = 38,
	[0][1][2][1][RTW89_WW][4] = 38,
	[0][1][2][1][RTW89_WW][6] = 38,
	[0][1][2][1][RTW89_WW][8] = 38,
	[0][1][2][1][RTW89_WW][10] = 38,
	[0][1][2][1][RTW89_WW][12] = 38,
	[0][1][2][1][RTW89_WW][14] = 38,
	[0][1][2][1][RTW89_WW][15] = 38,
	[0][1][2][1][RTW89_WW][17] = 38,
	[0][1][2][1][RTW89_WW][19] = 38,
	[0][1][2][1][RTW89_WW][21] = 38,
	[0][1][2][1][RTW89_WW][23] = 38,
	[0][1][2][1][RTW89_WW][25] = 40,
	[0][1][2][1][RTW89_WW][27] = 40,
	[0][1][2][1][RTW89_WW][29] = 40,
	[0][1][2][1][RTW89_WW][31] = 38,
	[0][1][2][1][RTW89_WW][33] = 38,
	[0][1][2][1][RTW89_WW][35] = 38,
	[0][1][2][1][RTW89_WW][37] = 60,
	[0][1][2][1][RTW89_WW][38] = 6,
	[0][1][2][1][RTW89_WW][40] = 6,
	[0][1][2][1][RTW89_WW][42] = 6,
	[0][1][2][1][RTW89_WW][44] = 6,
	[0][1][2][1][RTW89_WW][46] = 6,
	[0][1][2][1][RTW89_WW][48] = 50,
	[0][1][2][1][RTW89_WW][50] = 50,
	[0][1][2][1][RTW89_WW][52] = 50,
	[1][0][2][0][RTW89_WW][1] = 58,
	[1][0][2][0][RTW89_WW][5] = 66,
	[1][0][2][0][RTW89_WW][9] = 66,
	[1][0][2][0][RTW89_WW][13] = 58,
	[1][0][2][0][RTW89_WW][16] = 56,
	[1][0][2][0][RTW89_WW][20] = 66,
	[1][0][2][0][RTW89_WW][24] = 66,
	[1][0][2][0][RTW89_WW][28] = 66,
	[1][0][2][0][RTW89_WW][32] = 66,
	[1][0][2][0][RTW89_WW][36] = 66,
	[1][0][2][0][RTW89_WW][39] = 30,
	[1][0][2][0][RTW89_WW][43] = 30,
	[1][0][2][0][RTW89_WW][47] = 68,
	[1][0][2][0][RTW89_WW][51] = 68,
	[1][1][2][0][RTW89_WW][1] = 48,
	[1][1][2][0][RTW89_WW][5] = 52,
	[1][1][2][0][RTW89_WW][9] = 52,
	[1][1][2][0][RTW89_WW][13] = 52,
	[1][1][2][0][RTW89_WW][16] = 48,
	[1][1][2][0][RTW89_WW][20] = 54,
	[1][1][2][0][RTW89_WW][24] = 54,
	[1][1][2][0][RTW89_WW][28] = 54,
	[1][1][2][0][RTW89_WW][32] = 54,
	[1][1][2][0][RTW89_WW][36] = 66,
	[1][1][2][0][RTW89_WW][39] = 18,
	[1][1][2][0][RTW89_WW][43] = 18,
	[1][1][2][0][RTW89_WW][47] = 60,
	[1][1][2][0][RTW89_WW][51] = 58,
	[1][1][2][1][RTW89_WW][1] = 40,
	[1][1][2][1][RTW89_WW][5] = 40,
	[1][1][2][1][RTW89_WW][9] = 40,
	[1][1][2][1][RTW89_WW][13] = 40,
	[1][1][2][1][RTW89_WW][16] = 40,
	[1][1][2][1][RTW89_WW][20] = 40,
	[1][1][2][1][RTW89_WW][24] = 40,
	[1][1][2][1][RTW89_WW][28] = 40,
	[1][1][2][1][RTW89_WW][32] = 40,
	[1][1][2][1][RTW89_WW][36] = 60,
	[1][1][2][1][RTW89_WW][39] = 6,
	[1][1][2][1][RTW89_WW][43] = 6,
	[1][1][2][1][RTW89_WW][47] = 60,
	[1][1][2][1][RTW89_WW][51] = 58,
	[2][0][2][0][RTW89_WW][3] = 56,
	[2][0][2][0][RTW89_WW][11] = 58,
	[2][0][2][0][RTW89_WW][18] = 54,
	[2][0][2][0][RTW89_WW][26] = 60,
	[2][0][2][0][RTW89_WW][34] = 60,
	[2][0][2][0][RTW89_WW][41] = 30,
	[2][0][2][0][RTW89_WW][49] = 56,
	[2][1][2][0][RTW89_WW][3] = 48,
	[2][1][2][0][RTW89_WW][11] = 52,
	[2][1][2][0][RTW89_WW][18] = 48,
	[2][1][2][0][RTW89_WW][26] = 54,
	[2][1][2][0][RTW89_WW][34] = 60,
	[2][1][2][0][RTW89_WW][41] = 18,
	[2][1][2][0][RTW89_WW][49] = 50,
	[2][1][2][1][RTW89_WW][3] = 40,
	[2][1][2][1][RTW89_WW][11] = 40,
	[2][1][2][1][RTW89_WW][18] = 40,
	[2][1][2][1][RTW89_WW][26] = 42,
	[2][1][2][1][RTW89_WW][34] = 60,
	[2][1][2][1][RTW89_WW][41] = 6,
	[2][1][2][1][RTW89_WW][49] = 50,
	[3][0][2][0][RTW89_WW][7] = 38,
	[3][0][2][0][RTW89_WW][22] = 50,
	[3][0][2][0][RTW89_WW][45] = 0,
	[3][1][2][0][RTW89_WW][7] = 26,
	[3][1][2][0][RTW89_WW][22] = 42,
	[3][1][2][0][RTW89_WW][45] = 0,
	[3][1][2][1][RTW89_WW][7] = 14,
	[3][1][2][1][RTW89_WW][22] = 30,
	[3][1][2][1][RTW89_WW][45] = 0,
	[0][0][1][0][RTW89_FCC][0] = 70,
	[0][0][1][0][RTW89_ETSI][0] = 66,
	[0][0][1][0][RTW89_MKK][0] = 66,
	[0][0][1][0][RTW89_IC][0] = 62,
	[0][0][1][0][RTW89_ACMA][0] = 60,
	[0][0][1][0][RTW89_FCC][2] = 70,
	[0][0][1][0][RTW89_ETSI][2] = 66,
	[0][0][1][0][RTW89_MKK][2] = 66,
	[0][0][1][0][RTW89_IC][2] = 62,
	[0][0][1][0][RTW89_ACMA][2] = 60,
	[0][0][1][0][RTW89_FCC][4] = 70,
	[0][0][1][0][RTW89_ETSI][4] = 66,
	[0][0][1][0][RTW89_MKK][4] = 66,
	[0][0][1][0][RTW89_IC][4] = 62,
	[0][0][1][0][RTW89_ACMA][4] = 60,
	[0][0][1][0][RTW89_FCC][6] = 70,
	[0][0][1][0][RTW89_ETSI][6] = 66,
	[0][0][1][0][RTW89_MKK][6] = 66,
	[0][0][1][0][RTW89_IC][6] = 62,
	[0][0][1][0][RTW89_ACMA][6] = 60,
	[0][0][1][0][RTW89_FCC][8] = 70,
	[0][0][1][0][RTW89_ETSI][8] = 66,
	[0][0][1][0][RTW89_MKK][8] = 66,
	[0][0][1][0][RTW89_IC][8] = 66,
	[0][0][1][0][RTW89_ACMA][8] = 60,
	[0][0][1][0][RTW89_FCC][10] = 70,
	[0][0][1][0][RTW89_ETSI][10] = 66,
	[0][0][1][0][RTW89_MKK][10] = 66,
	[0][0][1][0][RTW89_IC][10] = 66,
	[0][0][1][0][RTW89_ACMA][10] = 60,
	[0][0][1][0][RTW89_FCC][12] = 70,
	[0][0][1][0][RTW89_ETSI][12] = 66,
	[0][0][1][0][RTW89_MKK][12] = 66,
	[0][0][1][0][RTW89_IC][12] = 66,
	[0][0][1][0][RTW89_ACMA][12] = 60,
	[0][0][1][0][RTW89_FCC][14] = 70,
	[0][0][1][0][RTW89_ETSI][14] = 66,
	[0][0][1][0][RTW89_MKK][14] = 66,
	[0][0][1][0][RTW89_IC][14] = 66,
	[0][0][1][0][RTW89_ACMA][14] = 60,
	[0][0][1][0][RTW89_FCC][15] = 68,
	[0][0][1][0][RTW89_ETSI][15] = 66,
	[0][0][1][0][RTW89_MKK][15] = 70,
	[0][0][1][0][RTW89_IC][15] = 70,
	[0][0][1][0][RTW89_ACMA][15] = 60,
	[0][0][1][0][RTW89_FCC][17] = 70,
	[0][0][1][0][RTW89_ETSI][17] = 66,
	[0][0][1][0][RTW89_MKK][17] = 70,
	[0][0][1][0][RTW89_IC][17] = 70,
	[0][0][1][0][RTW89_ACMA][17] = 60,
	[0][0][1][0][RTW89_FCC][19] = 70,
	[0][0][1][0][RTW89_ETSI][19] = 66,
	[0][0][1][0][RTW89_MKK][19] = 70,
	[0][0][1][0][RTW89_IC][19] = 70,
	[0][0][1][0][RTW89_ACMA][19] = 60,
	[0][0][1][0][RTW89_FCC][21] = 70,
	[0][0][1][0][RTW89_ETSI][21] = 66,
	[0][0][1][0][RTW89_MKK][21] = 70,
	[0][0][1][0][RTW89_IC][21] = 70,
	[0][0][1][0][RTW89_ACMA][21] = 60,
	[0][0][1][0][RTW89_FCC][23] = 70,
	[0][0][1][0][RTW89_ETSI][23] = 66,
	[0][0][1][0][RTW89_MKK][23] = 70,
	[0][0][1][0][RTW89_IC][23] = 70,
	[0][0][1][0][RTW89_ACMA][23] = 60,
	[0][0][1][0][RTW89_FCC][25] = 70,
	[0][0][1][0][RTW89_ETSI][25] = 66,
	[0][0][1][0][RTW89_MKK][25] = 70,
	[0][0][1][0][RTW89_IC][25] = 127,
	[0][0][1][0][RTW89_ACMA][25] = 127,
	[0][0][1][0][RTW89_FCC][27] = 70,
	[0][0][1][0][RTW89_ETSI][27] = 66,
	[0][0][1][0][RTW89_MKK][27] = 70,
	[0][0][1][0][RTW89_IC][27] = 127,
	[0][0][1][0][RTW89_ACMA][27] = 127,
	[0][0][1][0][RTW89_FCC][29] = 70,
	[0][0][1][0][RTW89_ETSI][29] = 66,
	[0][0][1][0][RTW89_MKK][29] = 70,
	[0][0][1][0][RTW89_IC][29] = 127,
	[0][0][1][0][RTW89_ACMA][29] = 127,
	[0][0][1][0][RTW89_FCC][31] = 70,
	[0][0][1][0][RTW89_ETSI][31] = 66,
	[0][0][1][0][RTW89_MKK][31] = 70,
	[0][0][1][0][RTW89_IC][31] = 70,
	[0][0][1][0][RTW89_ACMA][31] = 60,
	[0][0][1][0][RTW89_FCC][33] = 70,
	[0][0][1][0][RTW89_ETSI][33] = 66,
	[0][0][1][0][RTW89_MKK][33] = 70,
	[0][0][1][0][RTW89_IC][33] = 70,
	[0][0][1][0][RTW89_ACMA][33] = 60,
	[0][0][1][0][RTW89_FCC][35] = 62,
	[0][0][1][0][RTW89_ETSI][35] = 66,
	[0][0][1][0][RTW89_MKK][35] = 70,
	[0][0][1][0][RTW89_IC][35] = 70,
	[0][0][1][0][RTW89_ACMA][35] = 60,
	[0][0][1][0][RTW89_FCC][37] = 70,
	[0][0][1][0][RTW89_ETSI][37] = 127,
	[0][0][1][0][RTW89_MKK][37] = 70,
	[0][0][1][0][RTW89_IC][37] = 70,
	[0][0][1][0][RTW89_ACMA][37] = 70,
	[0][0][1][0][RTW89_FCC][38] = 70,
	[0][0][1][0][RTW89_ETSI][38] = 30,
	[0][0][1][0][RTW89_MKK][38] = 127,
	[0][0][1][0][RTW89_IC][38] = 70,
	[0][0][1][0][RTW89_ACMA][38] = 70,
	[0][0][1][0][RTW89_FCC][40] = 70,
	[0][0][1][0][RTW89_ETSI][40] = 30,
	[0][0][1][0][RTW89_MKK][40] = 127,
	[0][0][1][0][RTW89_IC][40] = 70,
	[0][0][1][0][RTW89_ACMA][40] = 70,
	[0][0][1][0][RTW89_FCC][42] = 70,
	[0][0][1][0][RTW89_ETSI][42] = 30,
	[0][0][1][0][RTW89_MKK][42] = 127,
	[0][0][1][0][RTW89_IC][42] = 70,
	[0][0][1][0][RTW89_ACMA][42] = 70,
	[0][0][1][0][RTW89_FCC][44] = 70,
	[0][0][1][0][RTW89_ETSI][44] = 30,
	[0][0][1][0][RTW89_MKK][44] = 127,
	[0][0][1][0][RTW89_IC][44] = 70,
	[0][0][1][0][RTW89_ACMA][44] = 70,
	[0][0][1][0][RTW89_FCC][46] = 70,
	[0][0][1][0][RTW89_ETSI][46] = 30,
	[0][0][1][0][RTW89_MKK][46] = 127,
	[0][0][1][0][RTW89_IC][46] = 70,
	[0][0][1][0][RTW89_ACMA][46] = 70,
	[0][0][1][0][RTW89_FCC][48] = 70,
	[0][0][1][0][RTW89_ETSI][48] = 127,
	[0][0][1][0][RTW89_MKK][48] = 127,
	[0][0][1][0][RTW89_IC][48] = 127,
	[0][0][1][0][RTW89_ACMA][48] = 127,
	[0][0][1][0][RTW89_FCC][50] = 70,
	[0][0][1][0][RTW89_ETSI][50] = 127,
	[0][0][1][0][RTW89_MKK][50] = 127,
	[0][0][1][0][RTW89_IC][50] = 127,
	[0][0][1][0][RTW89_ACMA][50] = 127,
	[0][0][1][0][RTW89_FCC][52] = 70,
	[0][0][1][0][RTW89_ETSI][52] = 127,
	[0][0][1][0][RTW89_MKK][52] = 127,
	[0][0][1][0][RTW89_IC][52] = 127,
	[0][0][1][0][RTW89_ACMA][52] = 127,
	[0][1][1][0][RTW89_FCC][0] = 60,
	[0][1][1][0][RTW89_ETSI][0] = 54,
	[0][1][1][0][RTW89_MKK][0] = 54,
	[0][1][1][0][RTW89_IC][0] = 42,
	[0][1][1][0][RTW89_ACMA][0] = 48,
	[0][1][1][0][RTW89_FCC][2] = 60,
	[0][1][1][0][RTW89_ETSI][2] = 54,
	[0][1][1][0][RTW89_MKK][2] = 54,
	[0][1][1][0][RTW89_IC][2] = 42,
	[0][1][1][0][RTW89_ACMA][2] = 48,
	[0][1][1][0][RTW89_FCC][4] = 60,
	[0][1][1][0][RTW89_ETSI][4] = 54,
	[0][1][1][0][RTW89_MKK][4] = 54,
	[0][1][1][0][RTW89_IC][4] = 42,
	[0][1][1][0][RTW89_ACMA][4] = 48,
	[0][1][1][0][RTW89_FCC][6] = 60,
	[0][1][1][0][RTW89_ETSI][6] = 54,
	[0][1][1][0][RTW89_MKK][6] = 54,
	[0][1][1][0][RTW89_IC][6] = 42,
	[0][1][1][0][RTW89_ACMA][6] = 48,
	[0][1][1][0][RTW89_FCC][8] = 60,
	[0][1][1][0][RTW89_ETSI][8] = 54,
	[0][1][1][0][RTW89_MKK][8] = 52,
	[0][1][1][0][RTW89_IC][8] = 54,
	[0][1][1][0][RTW89_ACMA][8] = 48,
	[0][1][1][0][RTW89_FCC][10] = 60,
	[0][1][1][0][RTW89_ETSI][10] = 54,
	[0][1][1][0][RTW89_MKK][10] = 54,
	[0][1][1][0][RTW89_IC][10] = 54,
	[0][1][1][0][RTW89_ACMA][10] = 48,
	[0][1][1][0][RTW89_FCC][12] = 60,
	[0][1][1][0][RTW89_ETSI][12] = 54,
	[0][1][1][0][RTW89_MKK][12] = 54,
	[0][1][1][0][RTW89_IC][12] = 54,
	[0][1][1][0][RTW89_ACMA][12] = 48,
	[0][1][1][0][RTW89_FCC][14] = 60,
	[0][1][1][0][RTW89_ETSI][14] = 54,
	[0][1][1][0][RTW89_MKK][14] = 54,
	[0][1][1][0][RTW89_IC][14] = 54,
	[0][1][1][0][RTW89_ACMA][14] = 48,
	[0][1][1][0][RTW89_FCC][15] = 58,
	[0][1][1][0][RTW89_ETSI][15] = 54,
	[0][1][1][0][RTW89_MKK][15] = 70,
	[0][1][1][0][RTW89_IC][15] = 68,
	[0][1][1][0][RTW89_ACMA][15] = 48,
	[0][1][1][0][RTW89_FCC][17] = 60,
	[0][1][1][0][RTW89_ETSI][17] = 54,
	[0][1][1][0][RTW89_MKK][17] = 70,
	[0][1][1][0][RTW89_IC][17] = 70,
	[0][1][1][0][RTW89_ACMA][17] = 48,
	[0][1][1][0][RTW89_FCC][19] = 60,
	[0][1][1][0][RTW89_ETSI][19] = 54,
	[0][1][1][0][RTW89_MKK][19] = 70,
	[0][1][1][0][RTW89_IC][19] = 70,
	[0][1][1][0][RTW89_ACMA][19] = 48,
	[0][1][1][0][RTW89_FCC][21] = 60,
	[0][1][1][0][RTW89_ETSI][21] = 54,
	[0][1][1][0][RTW89_MKK][21] = 70,
	[0][1][1][0][RTW89_IC][21] = 70,
	[0][1][1][0][RTW89_ACMA][21] = 48,
	[0][1][1][0][RTW89_FCC][23] = 60,
	[0][1][1][0][RTW89_ETSI][23] = 54,
	[0][1][1][0][RTW89_MKK][23] = 70,
	[0][1][1][0][RTW89_IC][23] = 70,
	[0][1][1][0][RTW89_ACMA][23] = 48,
	[0][1][1][0][RTW89_FCC][25] = 60,
	[0][1][1][0][RTW89_ETSI][25] = 54,
	[0][1][1][0][RTW89_MKK][25] = 70,
	[0][1][1][0][RTW89_IC][25] = 127,
	[0][1][1][0][RTW89_ACMA][25] = 127,
	[0][1][1][0][RTW89_FCC][27] = 60,
	[0][1][1][0][RTW89_ETSI][27] = 54,
	[0][1][1][0][RTW89_MKK][27] = 70,
	[0][1][1][0][RTW89_IC][27] = 127,
	[0][1][1][0][RTW89_ACMA][27] = 127,
	[0][1][1][0][RTW89_FCC][29] = 60,
	[0][1][1][0][RTW89_ETSI][29] = 54,
	[0][1][1][0][RTW89_MKK][29] = 70,
	[0][1][1][0][RTW89_IC][29] = 127,
	[0][1][1][0][RTW89_ACMA][29] = 127,
	[0][1][1][0][RTW89_FCC][31] = 60,
	[0][1][1][0][RTW89_ETSI][31] = 54,
	[0][1][1][0][RTW89_MKK][31] = 70,
	[0][1][1][0][RTW89_IC][31] = 70,
	[0][1][1][0][RTW89_ACMA][31] = 48,
	[0][1][1][0][RTW89_FCC][33] = 60,
	[0][1][1][0][RTW89_ETSI][33] = 54,
	[0][1][1][0][RTW89_MKK][33] = 70,
	[0][1][1][0][RTW89_IC][33] = 70,
	[0][1][1][0][RTW89_ACMA][33] = 48,
	[0][1][1][0][RTW89_FCC][35] = 58,
	[0][1][1][0][RTW89_ETSI][35] = 54,
	[0][1][1][0][RTW89_MKK][35] = 70,
	[0][1][1][0][RTW89_IC][35] = 68,
	[0][1][1][0][RTW89_ACMA][35] = 48,
	[0][1][1][0][RTW89_FCC][37] = 60,
	[0][1][1][0][RTW89_ETSI][37] = 127,
	[0][1][1][0][RTW89_MKK][37] = 70,
	[0][1][1][0][RTW89_IC][37] = 70,
	[0][1][1][0][RTW89_ACMA][37] = 70,
	[0][1][1][0][RTW89_FCC][38] = 70,
	[0][1][1][0][RTW89_ETSI][38] = 18,
	[0][1][1][0][RTW89_MKK][38] = 127,
	[0][1][1][0][RTW89_IC][38] = 70,
	[0][1][1][0][RTW89_ACMA][38] = 70,
	[0][1][1][0][RTW89_FCC][40] = 70,
	[0][1][1][0][RTW89_ETSI][40] = 18,
	[0][1][1][0][RTW89_MKK][40] = 127,
	[0][1][1][0][RTW89_IC][40] = 70,
	[0][1][1][0][RTW89_ACMA][40] = 16,
	[0][1][1][0][RTW89_FCC][42] = 70,
	[0][1][1][0][RTW89_ETSI][42] = 18,
	[0][1][1][0][RTW89_MKK][42] = 127,
	[0][1][1][0][RTW89_IC][42] = 70,
	[0][1][1][0][RTW89_ACMA][42] = 70,
	[0][1][1][0][RTW89_FCC][44] = 70,
	[0][1][1][0][RTW89_ETSI][44] = 18,
	[0][1][1][0][RTW89_MKK][44] = 127,
	[0][1][1][0][RTW89_IC][44] = 70,
	[0][1][1][0][RTW89_ACMA][44] = 16,
	[0][1][1][0][RTW89_FCC][46] = 70,
	[0][1][1][0][RTW89_ETSI][46] = 18,
	[0][1][1][0][RTW89_MKK][46] = 127,
	[0][1][1][0][RTW89_IC][46] = 70,
	[0][1][1][0][RTW89_ACMA][46] = 70,
	[0][1][1][0][RTW89_FCC][48] = 48,
	[0][1][1][0][RTW89_ETSI][48] = 127,
	[0][1][1][0][RTW89_MKK][48] = 127,
	[0][1][1][0][RTW89_IC][48] = 127,
	[0][1][1][0][RTW89_ACMA][48] = 127,
	[0][1][1][0][RTW89_FCC][50] = 48,
	[0][1][1][0][RTW89_ETSI][50] = 127,
	[0][1][1][0][RTW89_MKK][50] = 127,
	[0][1][1][0][RTW89_IC][50] = 127,
	[0][1][1][0][RTW89_ACMA][50] = 127,
	[0][1][1][0][RTW89_FCC][52] = 48,
	[0][1][1][0][RTW89_ETSI][52] = 127,
	[0][1][1][0][RTW89_MKK][52] = 127,
	[0][1][1][0][RTW89_IC][52] = 127,
	[0][1][1][0][RTW89_ACMA][52] = 127,
	[0][0][2][0][RTW89_FCC][0] = 70,
	[0][0][2][0][RTW89_ETSI][0] = 66,
	[0][0][2][0][RTW89_MKK][0] = 68,
	[0][0][2][0][RTW89_IC][0] = 66,
	[0][0][2][0][RTW89_ACMA][0] = 62,
	[0][0][2][0][RTW89_FCC][2] = 70,
	[0][0][2][0][RTW89_ETSI][2] = 66,
	[0][0][2][0][RTW89_MKK][2] = 68,
	[0][0][2][0][RTW89_IC][2] = 66,
	[0][0][2][0][RTW89_ACMA][2] = 62,
	[0][0][2][0][RTW89_FCC][4] = 70,
	[0][0][2][0][RTW89_ETSI][4] = 66,
	[0][0][2][0][RTW89_MKK][4] = 68,
	[0][0][2][0][RTW89_IC][4] = 66,
	[0][0][2][0][RTW89_ACMA][4] = 62,
	[0][0][2][0][RTW89_FCC][6] = 70,
	[0][0][2][0][RTW89_ETSI][6] = 66,
	[0][0][2][0][RTW89_MKK][6] = 60,
	[0][0][2][0][RTW89_IC][6] = 66,
	[0][0][2][0][RTW89_ACMA][6] = 62,
	[0][0][2][0][RTW89_FCC][8] = 70,
	[0][0][2][0][RTW89_ETSI][8] = 66,
	[0][0][2][0][RTW89_MKK][8] = 58,
	[0][0][2][0][RTW89_IC][8] = 66,
	[0][0][2][0][RTW89_ACMA][8] = 62,
	[0][0][2][0][RTW89_FCC][10] = 70,
	[0][0][2][0][RTW89_ETSI][10] = 66,
	[0][0][2][0][RTW89_MKK][10] = 70,
	[0][0][2][0][RTW89_IC][10] = 66,
	[0][0][2][0][RTW89_ACMA][10] = 62,
	[0][0][2][0][RTW89_FCC][12] = 70,
	[0][0][2][0][RTW89_ETSI][12] = 66,
	[0][0][2][0][RTW89_MKK][12] = 70,
	[0][0][2][0][RTW89_IC][12] = 66,
	[0][0][2][0][RTW89_ACMA][12] = 62,
	[0][0][2][0][RTW89_FCC][14] = 70,
	[0][0][2][0][RTW89_ETSI][14] = 66,
	[0][0][2][0][RTW89_MKK][14] = 70,
	[0][0][2][0][RTW89_IC][14] = 66,
	[0][0][2][0][RTW89_ACMA][14] = 62,
	[0][0][2][0][RTW89_FCC][15] = 66,
	[0][0][2][0][RTW89_ETSI][15] = 66,
	[0][0][2][0][RTW89_MKK][15] = 70,
	[0][0][2][0][RTW89_IC][15] = 70,
	[0][0][2][0][RTW89_ACMA][15] = 62,
	[0][0][2][0][RTW89_FCC][17] = 70,
	[0][0][2][0][RTW89_ETSI][17] = 66,
	[0][0][2][0][RTW89_MKK][17] = 70,
	[0][0][2][0][RTW89_IC][17] = 70,
	[0][0][2][0][RTW89_ACMA][17] = 62,
	[0][0][2][0][RTW89_FCC][19] = 70,
	[0][0][2][0][RTW89_ETSI][19] = 66,
	[0][0][2][0][RTW89_MKK][19] = 70,
	[0][0][2][0][RTW89_IC][19] = 70,
	[0][0][2][0][RTW89_ACMA][19] = 62,
	[0][0][2][0][RTW89_FCC][21] = 70,
	[0][0][2][0][RTW89_ETSI][21] = 66,
	[0][0][2][0][RTW89_MKK][21] = 70,
	[0][0][2][0][RTW89_IC][21] = 70,
	[0][0][2][0][RTW89_ACMA][21] = 62,
	[0][0][2][0][RTW89_FCC][23] = 70,
	[0][0][2][0][RTW89_ETSI][23] = 66,
	[0][0][2][0][RTW89_MKK][23] = 70,
	[0][0][2][0][RTW89_IC][23] = 70,
	[0][0][2][0][RTW89_ACMA][23] = 62,
	[0][0][2][0][RTW89_FCC][25] = 70,
	[0][0][2][0][RTW89_ETSI][25] = 66,
	[0][0][2][0][RTW89_MKK][25] = 70,
	[0][0][2][0][RTW89_IC][25] = 127,
	[0][0][2][0][RTW89_ACMA][25] = 127,
	[0][0][2][0][RTW89_FCC][27] = 70,
	[0][0][2][0][RTW89_ETSI][27] = 66,
	[0][0][2][0][RTW89_MKK][27] = 70,
	[0][0][2][0][RTW89_IC][27] = 127,
	[0][0][2][0][RTW89_ACMA][27] = 127,
	[0][0][2][0][RTW89_FCC][29] = 70,
	[0][0][2][0][RTW89_ETSI][29] = 66,
	[0][0][2][0][RTW89_MKK][29] = 70,
	[0][0][2][0][RTW89_IC][29] = 127,
	[0][0][2][0][RTW89_ACMA][29] = 127,
	[0][0][2][0][RTW89_FCC][31] = 70,
	[0][0][2][0][RTW89_ETSI][31] = 66,
	[0][0][2][0][RTW89_MKK][31] = 70,
	[0][0][2][0][RTW89_IC][31] = 70,
	[0][0][2][0][RTW89_ACMA][31] = 62,
	[0][0][2][0][RTW89_FCC][33] = 70,
	[0][0][2][0][RTW89_ETSI][33] = 66,
	[0][0][2][0][RTW89_MKK][33] = 70,
	[0][0][2][0][RTW89_IC][33] = 70,
	[0][0][2][0][RTW89_ACMA][33] = 62,
	[0][0][2][0][RTW89_FCC][35] = 62,
	[0][0][2][0][RTW89_ETSI][35] = 66,
	[0][0][2][0][RTW89_MKK][35] = 70,
	[0][0][2][0][RTW89_IC][35] = 70,
	[0][0][2][0][RTW89_ACMA][35] = 62,
	[0][0][2][0][RTW89_FCC][37] = 70,
	[0][0][2][0][RTW89_ETSI][37] = 127,
	[0][0][2][0][RTW89_MKK][37] = 70,
	[0][0][2][0][RTW89_IC][37] = 70,
	[0][0][2][0][RTW89_ACMA][37] = 70,
	[0][0][2][0][RTW89_FCC][38] = 70,
	[0][0][2][0][RTW89_ETSI][38] = 30,
	[0][0][2][0][RTW89_MKK][38] = 127,
	[0][0][2][0][RTW89_IC][38] = 70,
	[0][0][2][0][RTW89_ACMA][38] = 70,
	[0][0][2][0][RTW89_FCC][40] = 70,
	[0][0][2][0][RTW89_ETSI][40] = 30,
	[0][0][2][0][RTW89_MKK][40] = 127,
	[0][0][2][0][RTW89_IC][40] = 70,
	[0][0][2][0][RTW89_ACMA][40] = 70,
	[0][0][2][0][RTW89_FCC][42] = 70,
	[0][0][2][0][RTW89_ETSI][42] = 30,
	[0][0][2][0][RTW89_MKK][42] = 127,
	[0][0][2][0][RTW89_IC][42] = 70,
	[0][0][2][0][RTW89_ACMA][42] = 70,
	[0][0][2][0][RTW89_FCC][44] = 70,
	[0][0][2][0][RTW89_ETSI][44] = 30,
	[0][0][2][0][RTW89_MKK][44] = 127,
	[0][0][2][0][RTW89_IC][44] = 70,
	[0][0][2][0][RTW89_ACMA][44] = 70,
	[0][0][2][0][RTW89_FCC][46] = 70,
	[0][0][2][0][RTW89_ETSI][46] = 30,
	[0][0][2][0][RTW89_MKK][46] = 127,
	[0][0][2][0][RTW89_IC][46] = 70,
	[0][0][2][0][RTW89_ACMA][46] = 70,
	[0][0][2][0][RTW89_FCC][48] = 70,
	[0][0][2][0][RTW89_ETSI][48] = 127,
	[0][0][2][0][RTW89_MKK][48] = 127,
	[0][0][2][0][RTW89_IC][48] = 127,
	[0][0][2][0][RTW89_ACMA][48] = 127,
	[0][0][2][0][RTW89_FCC][50] = 70,
	[0][0][2][0][RTW89_ETSI][50] = 127,
	[0][0][2][0][RTW89_MKK][50] = 127,
	[0][0][2][0][RTW89_IC][50] = 127,
	[0][0][2][0][RTW89_ACMA][50] = 127,
	[0][0][2][0][RTW89_FCC][52] = 70,
	[0][0][2][0][RTW89_ETSI][52] = 127,
	[0][0][2][0][RTW89_MKK][52] = 127,
	[0][0][2][0][RTW89_IC][52] = 127,
	[0][0][2][0][RTW89_ACMA][52] = 127,
	[0][1][2][0][RTW89_FCC][0] = 62,
	[0][1][2][0][RTW89_ETSI][0] = 54,
	[0][1][2][0][RTW89_MKK][0] = 54,
	[0][1][2][0][RTW89_IC][0] = 44,
	[0][1][2][0][RTW89_ACMA][0] = 50,
	[0][1][2][0][RTW89_FCC][2] = 62,
	[0][1][2][0][RTW89_ETSI][2] = 54,
	[0][1][2][0][RTW89_MKK][2] = 54,
	[0][1][2][0][RTW89_IC][2] = 44,
	[0][1][2][0][RTW89_ACMA][2] = 50,
	[0][1][2][0][RTW89_FCC][4] = 62,
	[0][1][2][0][RTW89_ETSI][4] = 54,
	[0][1][2][0][RTW89_MKK][4] = 54,
	[0][1][2][0][RTW89_IC][4] = 44,
	[0][1][2][0][RTW89_ACMA][4] = 50,
	[0][1][2][0][RTW89_FCC][6] = 62,
	[0][1][2][0][RTW89_ETSI][6] = 54,
	[0][1][2][0][RTW89_MKK][6] = 50,
	[0][1][2][0][RTW89_IC][6] = 44,
	[0][1][2][0][RTW89_ACMA][6] = 50,
	[0][1][2][0][RTW89_FCC][8] = 62,
	[0][1][2][0][RTW89_ETSI][8] = 54,
	[0][1][2][0][RTW89_MKK][8] = 42,
	[0][1][2][0][RTW89_IC][8] = 54,
	[0][1][2][0][RTW89_ACMA][8] = 50,
	[0][1][2][0][RTW89_FCC][10] = 62,
	[0][1][2][0][RTW89_ETSI][10] = 54,
	[0][1][2][0][RTW89_MKK][10] = 54,
	[0][1][2][0][RTW89_IC][10] = 54,
	[0][1][2][0][RTW89_ACMA][10] = 50,
	[0][1][2][0][RTW89_FCC][12] = 62,
	[0][1][2][0][RTW89_ETSI][12] = 54,
	[0][1][2][0][RTW89_MKK][12] = 54,
	[0][1][2][0][RTW89_IC][12] = 54,
	[0][1][2][0][RTW89_ACMA][12] = 50,
	[0][1][2][0][RTW89_FCC][14] = 62,
	[0][1][2][0][RTW89_ETSI][14] = 54,
	[0][1][2][0][RTW89_MKK][14] = 54,
	[0][1][2][0][RTW89_IC][14] = 54,
	[0][1][2][0][RTW89_ACMA][14] = 50,
	[0][1][2][0][RTW89_FCC][15] = 60,
	[0][1][2][0][RTW89_ETSI][15] = 54,
	[0][1][2][0][RTW89_MKK][15] = 68,
	[0][1][2][0][RTW89_IC][15] = 70,
	[0][1][2][0][RTW89_ACMA][15] = 50,
	[0][1][2][0][RTW89_FCC][17] = 62,
	[0][1][2][0][RTW89_ETSI][17] = 54,
	[0][1][2][0][RTW89_MKK][17] = 68,
	[0][1][2][0][RTW89_IC][17] = 70,
	[0][1][2][0][RTW89_ACMA][17] = 50,
	[0][1][2][0][RTW89_FCC][19] = 62,
	[0][1][2][0][RTW89_ETSI][19] = 54,
	[0][1][2][0][RTW89_MKK][19] = 68,
	[0][1][2][0][RTW89_IC][19] = 70,
	[0][1][2][0][RTW89_ACMA][19] = 50,
	[0][1][2][0][RTW89_FCC][21] = 62,
	[0][1][2][0][RTW89_ETSI][21] = 54,
	[0][1][2][0][RTW89_MKK][21] = 68,
	[0][1][2][0][RTW89_IC][21] = 70,
	[0][1][2][0][RTW89_ACMA][21] = 50,
	[0][1][2][0][RTW89_FCC][23] = 62,
	[0][1][2][0][RTW89_ETSI][23] = 54,
	[0][1][2][0][RTW89_MKK][23] = 68,
	[0][1][2][0][RTW89_IC][23] = 70,
	[0][1][2][0][RTW89_ACMA][23] = 50,
	[0][1][2][0][RTW89_FCC][25] = 62,
	[0][1][2][0][RTW89_ETSI][25] = 54,
	[0][1][2][0][RTW89_MKK][25] = 68,
	[0][1][2][0][RTW89_IC][25] = 127,
	[0][1][2][0][RTW89_ACMA][25] = 127,
	[0][1][2][0][RTW89_FCC][27] = 62,
	[0][1][2][0][RTW89_ETSI][27] = 54,
	[0][1][2][0][RTW89_MKK][27] = 68,
	[0][1][2][0][RTW89_IC][27] = 127,
	[0][1][2][0][RTW89_ACMA][27] = 127,
	[0][1][2][0][RTW89_FCC][29] = 62,
	[0][1][2][0][RTW89_ETSI][29] = 54,
	[0][1][2][0][RTW89_MKK][29] = 68,
	[0][1][2][0][RTW89_IC][29] = 127,
	[0][1][2][0][RTW89_ACMA][29] = 127,
	[0][1][2][0][RTW89_FCC][31] = 62,
	[0][1][2][0][RTW89_ETSI][31] = 54,
	[0][1][2][0][RTW89_MKK][31] = 68,
	[0][1][2][0][RTW89_IC][31] = 70,
	[0][1][2][0][RTW89_ACMA][31] = 50,
	[0][1][2][0][RTW89_FCC][33] = 62,
	[0][1][2][0][RTW89_ETSI][33] = 54,
	[0][1][2][0][RTW89_MKK][33] = 68,
	[0][1][2][0][RTW89_IC][33] = 70,
	[0][1][2][0][RTW89_ACMA][33] = 50,
	[0][1][2][0][RTW89_FCC][35] = 58,
	[0][1][2][0][RTW89_ETSI][35] = 54,
	[0][1][2][0][RTW89_MKK][35] = 68,
	[0][1][2][0][RTW89_IC][35] = 68,
	[0][1][2][0][RTW89_ACMA][35] = 50,
	[0][1][2][0][RTW89_FCC][37] = 62,
	[0][1][2][0][RTW89_ETSI][37] = 127,
	[0][1][2][0][RTW89_MKK][37] = 68,
	[0][1][2][0][RTW89_IC][37] = 70,
	[0][1][2][0][RTW89_ACMA][37] = 70,
	[0][1][2][0][RTW89_FCC][38] = 70,
	[0][1][2][0][RTW89_ETSI][38] = 18,
	[0][1][2][0][RTW89_MKK][38] = 127,
	[0][1][2][0][RTW89_IC][38] = 70,
	[0][1][2][0][RTW89_ACMA][38] = 70,
	[0][1][2][0][RTW89_FCC][40] = 70,
	[0][1][2][0][RTW89_ETSI][40] = 18,
	[0][1][2][0][RTW89_MKK][40] = 127,
	[0][1][2][0][RTW89_IC][40] = 70,
	[0][1][2][0][RTW89_ACMA][40] = 70,
	[0][1][2][0][RTW89_FCC][42] = 70,
	[0][1][2][0][RTW89_ETSI][42] = 18,
	[0][1][2][0][RTW89_MKK][42] = 127,
	[0][1][2][0][RTW89_IC][42] = 70,
	[0][1][2][0][RTW89_ACMA][42] = 70,
	[0][1][2][0][RTW89_FCC][44] = 70,
	[0][1][2][0][RTW89_ETSI][44] = 18,
	[0][1][2][0][RTW89_MKK][44] = 127,
	[0][1][2][0][RTW89_IC][44] = 70,
	[0][1][2][0][RTW89_ACMA][44] = 70,
	[0][1][2][0][RTW89_FCC][46] = 70,
	[0][1][2][0][RTW89_ETSI][46] = 18,
	[0][1][2][0][RTW89_MKK][46] = 127,
	[0][1][2][0][RTW89_IC][46] = 70,
	[0][1][2][0][RTW89_ACMA][46] = 70,
	[0][1][2][0][RTW89_FCC][48] = 50,
	[0][1][2][0][RTW89_ETSI][48] = 127,
	[0][1][2][0][RTW89_MKK][48] = 127,
	[0][1][2][0][RTW89_IC][48] = 127,
	[0][1][2][0][RTW89_ACMA][48] = 127,
	[0][1][2][0][RTW89_FCC][50] = 50,
	[0][1][2][0][RTW89_ETSI][50] = 127,
	[0][1][2][0][RTW89_MKK][50] = 127,
	[0][1][2][0][RTW89_IC][50] = 127,
	[0][1][2][0][RTW89_ACMA][50] = 127,
	[0][1][2][0][RTW89_FCC][52] = 50,
	[0][1][2][0][RTW89_ETSI][52] = 127,
	[0][1][2][0][RTW89_MKK][52] = 127,
	[0][1][2][0][RTW89_IC][52] = 127,
	[0][1][2][0][RTW89_ACMA][52] = 127,
	[0][1][2][1][RTW89_FCC][0] = 60,
	[0][1][2][1][RTW89_ETSI][0] = 40,
	[0][1][2][1][RTW89_MKK][0] = 54,
	[0][1][2][1][RTW89_IC][0] = 42,
	[0][1][2][1][RTW89_ACMA][0] = 38,
	[0][1][2][1][RTW89_FCC][2] = 60,
	[0][1][2][1][RTW89_ETSI][2] = 40,
	[0][1][2][1][RTW89_MKK][2] = 54,
	[0][1][2][1][RTW89_IC][2] = 42,
	[0][1][2][1][RTW89_ACMA][2] = 38,
	[0][1][2][1][RTW89_FCC][4] = 60,
	[0][1][2][1][RTW89_ETSI][4] = 40,
	[0][1][2][1][RTW89_MKK][4] = 54,
	[0][1][2][1][RTW89_IC][4] = 42,
	[0][1][2][1][RTW89_ACMA][4] = 38,
	[0][1][2][1][RTW89_FCC][6] = 60,
	[0][1][2][1][RTW89_ETSI][6] = 40,
	[0][1][2][1][RTW89_MKK][6] = 50,
	[0][1][2][1][RTW89_IC][6] = 42,
	[0][1][2][1][RTW89_ACMA][6] = 38,
	[0][1][2][1][RTW89_FCC][8] = 60,
	[0][1][2][1][RTW89_ETSI][8] = 40,
	[0][1][2][1][RTW89_MKK][8] = 42,
	[0][1][2][1][RTW89_IC][8] = 42,
	[0][1][2][1][RTW89_ACMA][8] = 38,
	[0][1][2][1][RTW89_FCC][10] = 60,
	[0][1][2][1][RTW89_ETSI][10] = 40,
	[0][1][2][1][RTW89_MKK][10] = 66,
	[0][1][2][1][RTW89_IC][10] = 42,
	[0][1][2][1][RTW89_ACMA][10] = 38,
	[0][1][2][1][RTW89_FCC][12] = 60,
	[0][1][2][1][RTW89_ETSI][12] = 40,
	[0][1][2][1][RTW89_MKK][12] = 66,
	[0][1][2][1][RTW89_IC][12] = 42,
	[0][1][2][1][RTW89_ACMA][12] = 38,
	[0][1][2][1][RTW89_FCC][14] = 60,
	[0][1][2][1][RTW89_ETSI][14] = 40,
	[0][1][2][1][RTW89_MKK][14] = 66,
	[0][1][2][1][RTW89_IC][14] = 42,
	[0][1][2][1][RTW89_ACMA][14] = 38,
	[0][1][2][1][RTW89_FCC][15] = 60,
	[0][1][2][1][RTW89_ETSI][15] = 40,
	[0][1][2][1][RTW89_MKK][15] = 68,
	[0][1][2][1][RTW89_IC][15] = 70,
	[0][1][2][1][RTW89_ACMA][15] = 38,
	[0][1][2][1][RTW89_FCC][17] = 60,
	[0][1][2][1][RTW89_ETSI][17] = 40,
	[0][1][2][1][RTW89_MKK][17] = 68,
	[0][1][2][1][RTW89_IC][17] = 70,
	[0][1][2][1][RTW89_ACMA][17] = 38,
	[0][1][2][1][RTW89_FCC][19] = 60,
	[0][1][2][1][RTW89_ETSI][19] = 40,
	[0][1][2][1][RTW89_MKK][19] = 68,
	[0][1][2][1][RTW89_IC][19] = 70,
	[0][1][2][1][RTW89_ACMA][19] = 38,
	[0][1][2][1][RTW89_FCC][21] = 60,
	[0][1][2][1][RTW89_ETSI][21] = 40,
	[0][1][2][1][RTW89_MKK][21] = 68,
	[0][1][2][1][RTW89_IC][21] = 70,
	[0][1][2][1][RTW89_ACMA][21] = 38,
	[0][1][2][1][RTW89_FCC][23] = 60,
	[0][1][2][1][RTW89_ETSI][23] = 40,
	[0][1][2][1][RTW89_MKK][23] = 68,
	[0][1][2][1][RTW89_IC][23] = 70,
	[0][1][2][1][RTW89_ACMA][23] = 38,
	[0][1][2][1][RTW89_FCC][25] = 58,
	[0][1][2][1][RTW89_ETSI][25] = 40,
	[0][1][2][1][RTW89_MKK][25] = 68,
	[0][1][2][1][RTW89_IC][25] = 127,
	[0][1][2][1][RTW89_ACMA][25] = 127,
	[0][1][2][1][RTW89_FCC][27] = 58,
	[0][1][2][1][RTW89_ETSI][27] = 40,
	[0][1][2][1][RTW89_MKK][27] = 68,
	[0][1][2][1][RTW89_IC][27] = 127,
	[0][1][2][1][RTW89_ACMA][27] = 127,
	[0][1][2][1][RTW89_FCC][29] = 58,
	[0][1][2][1][RTW89_ETSI][29] = 40,
	[0][1][2][1][RTW89_MKK][29] = 68,
	[0][1][2][1][RTW89_IC][29] = 127,
	[0][1][2][1][RTW89_ACMA][29] = 127,
	[0][1][2][1][RTW89_FCC][31] = 58,
	[0][1][2][1][RTW89_ETSI][31] = 40,
	[0][1][2][1][RTW89_MKK][31] = 68,
	[0][1][2][1][RTW89_IC][31] = 68,
	[0][1][2][1][RTW89_ACMA][31] = 38,
	[0][1][2][1][RTW89_FCC][33] = 58,
	[0][1][2][1][RTW89_ETSI][33] = 40,
	[0][1][2][1][RTW89_MKK][33] = 68,
	[0][1][2][1][RTW89_IC][33] = 68,
	[0][1][2][1][RTW89_ACMA][33] = 38,
	[0][1][2][1][RTW89_FCC][35] = 58,
	[0][1][2][1][RTW89_ETSI][35] = 40,
	[0][1][2][1][RTW89_MKK][35] = 68,
	[0][1][2][1][RTW89_IC][35] = 68,
	[0][1][2][1][RTW89_ACMA][35] = 38,
	[0][1][2][1][RTW89_FCC][37] = 60,
	[0][1][2][1][RTW89_ETSI][37] = 127,
	[0][1][2][1][RTW89_MKK][37] = 68,
	[0][1][2][1][RTW89_IC][37] = 70,
	[0][1][2][1][RTW89_ACMA][37] = 70,
	[0][1][2][1][RTW89_FCC][38] = 70,
	[0][1][2][1][RTW89_ETSI][38] = 6,
	[0][1][2][1][RTW89_MKK][38] = 127,
	[0][1][2][1][RTW89_IC][38] = 70,
	[0][1][2][1][RTW89_ACMA][38] = 70,
	[0][1][2][1][RTW89_FCC][40] = 70,
	[0][1][2][1][RTW89_ETSI][40] = 6,
	[0][1][2][1][RTW89_MKK][40] = 127,
	[0][1][2][1][RTW89_IC][40] = 70,
	[0][1][2][1][RTW89_ACMA][40] = 70,
	[0][1][2][1][RTW89_FCC][42] = 70,
	[0][1][2][1][RTW89_ETSI][42] = 6,
	[0][1][2][1][RTW89_MKK][42] = 127,
	[0][1][2][1][RTW89_IC][42] = 70,
	[0][1][2][1][RTW89_ACMA][42] = 70,
	[0][1][2][1][RTW89_FCC][44] = 70,
	[0][1][2][1][RTW89_ETSI][44] = 6,
	[0][1][2][1][RTW89_MKK][44] = 127,
	[0][1][2][1][RTW89_IC][44] = 70,
	[0][1][2][1][RTW89_ACMA][44] = 70,
	[0][1][2][1][RTW89_FCC][46] = 70,
	[0][1][2][1][RTW89_ETSI][46] = 6,
	[0][1][2][1][RTW89_MKK][46] = 127,
	[0][1][2][1][RTW89_IC][46] = 70,
	[0][1][2][1][RTW89_ACMA][46] = 70,
	[0][1][2][1][RTW89_FCC][48] = 50,
	[0][1][2][1][RTW89_ETSI][48] = 127,
	[0][1][2][1][RTW89_MKK][48] = 127,
	[0][1][2][1][RTW89_IC][48] = 127,
	[0][1][2][1][RTW89_ACMA][48] = 127,
	[0][1][2][1][RTW89_FCC][50] = 50,
	[0][1][2][1][RTW89_ETSI][50] = 127,
	[0][1][2][1][RTW89_MKK][50] = 127,
	[0][1][2][1][RTW89_IC][50] = 127,
	[0][1][2][1][RTW89_ACMA][50] = 127,
	[0][1][2][1][RTW89_FCC][52] = 50,
	[0][1][2][1][RTW89_ETSI][52] = 127,
	[0][1][2][1][RTW89_MKK][52] = 127,
	[0][1][2][1][RTW89_IC][52] = 127,
	[0][1][2][1][RTW89_ACMA][52] = 127,
	[1][0][2][0][RTW89_FCC][1] = 58,
	[1][0][2][0][RTW89_ETSI][1] = 66,
	[1][0][2][0][RTW89_MKK][1] = 66,
	[1][0][2][0][RTW89_IC][1] = 66,
	[1][0][2][0][RTW89_ACMA][1] = 66,
	[1][0][2][0][RTW89_FCC][5] = 68,
	[1][0][2][0][RTW89_ETSI][5] = 66,
	[1][0][2][0][RTW89_MKK][5] = 66,
	[1][0][2][0][RTW89_IC][5] = 66,
	[1][0][2][0][RTW89_ACMA][5] = 66,
	[1][0][2][0][RTW89_FCC][9] = 68,
	[1][0][2][0][RTW89_ETSI][9] = 66,
	[1][0][2][0][RTW89_MKK][9] = 66,
	[1][0][2][0][RTW89_IC][9] = 66,
	[1][0][2][0][RTW89_ACMA][9] = 66,
	[1][0][2][0][RTW89_FCC][13] = 58,
	[1][0][2][0][RTW89_ETSI][13] = 66,
	[1][0][2][0][RTW89_MKK][13] = 66,
	[1][0][2][0][RTW89_IC][13] = 66,
	[1][0][2][0][RTW89_ACMA][13] = 66,
	[1][0][2][0][RTW89_FCC][16] = 56,
	[1][0][2][0][RTW89_ETSI][16] = 66,
	[1][0][2][0][RTW89_MKK][16] = 66,
	[1][0][2][0][RTW89_IC][16] = 66,
	[1][0][2][0][RTW89_ACMA][16] = 66,
	[1][0][2][0][RTW89_FCC][20] = 68,
	[1][0][2][0][RTW89_ETSI][20] = 66,
	[1][0][2][0][RTW89_MKK][20] = 66,
	[1][0][2][0][RTW89_IC][20] = 66,
	[1][0][2][0][RTW89_ACMA][20] = 66,
	[1][0][2][0][RTW89_FCC][24] = 68,
	[1][0][2][0][RTW89_ETSI][24] = 66,
	[1][0][2][0][RTW89_MKK][24] = 66,
	[1][0][2][0][RTW89_IC][24] = 127,
	[1][0][2][0][RTW89_ACMA][24] = 127,
	[1][0][2][0][RTW89_FCC][28] = 68,
	[1][0][2][0][RTW89_ETSI][28] = 66,
	[1][0][2][0][RTW89_MKK][28] = 66,
	[1][0][2][0][RTW89_IC][28] = 127,
	[1][0][2][0][RTW89_ACMA][28] = 127,
	[1][0][2][0][RTW89_FCC][32] = 68,
	[1][0][2][0][RTW89_ETSI][32] = 66,
	[1][0][2][0][RTW89_MKK][32] = 66,
	[1][0][2][0][RTW89_IC][32] = 66,
	[1][0][2][0][RTW89_ACMA][32] = 66,
	[1][0][2][0][RTW89_FCC][36] = 68,
	[1][0][2][0][RTW89_ETSI][36] = 127,
	[1][0][2][0][RTW89_MKK][36] = 66,
	[1][0][2][0][RTW89_IC][36] = 66,
	[1][0][2][0][RTW89_ACMA][36] = 66,
	[1][0][2][0][RTW89_FCC][39] = 68,
	[1][0][2][0][RTW89_ETSI][39] = 30,
	[1][0][2][0][RTW89_MKK][39] = 127,
	[1][0][2][0][RTW89_IC][39] = 66,
	[1][0][2][0][RTW89_ACMA][39] = 66,
	[1][0][2][0][RTW89_FCC][43] = 68,
	[1][0][2][0][RTW89_ETSI][43] = 30,
	[1][0][2][0][RTW89_MKK][43] = 127,
	[1][0][2][0][RTW89_IC][43] = 66,
	[1][0][2][0][RTW89_ACMA][43] = 66,
	[1][0][2][0][RTW89_FCC][47] = 68,
	[1][0][2][0][RTW89_ETSI][47] = 127,
	[1][0][2][0][RTW89_MKK][47] = 127,
	[1][0][2][0][RTW89_IC][47] = 127,
	[1][0][2][0][RTW89_ACMA][47] = 127,
	[1][0][2][0][RTW89_FCC][51] = 68,
	[1][0][2][0][RTW89_ETSI][51] = 127,
	[1][0][2][0][RTW89_MKK][51] = 127,
	[1][0][2][0][RTW89_IC][51] = 127,
	[1][0][2][0][RTW89_ACMA][51] = 127,
	[1][1][2][0][RTW89_FCC][1] = 54,
	[1][1][2][0][RTW89_ETSI][1] = 54,
	[1][1][2][0][RTW89_MKK][1] = 48,
	[1][1][2][0][RTW89_IC][1] = 60,
	[1][1][2][0][RTW89_ACMA][1] = 60,
	[1][1][2][0][RTW89_FCC][5] = 68,
	[1][1][2][0][RTW89_ETSI][5] = 54,
	[1][1][2][0][RTW89_MKK][5] = 52,
	[1][1][2][0][RTW89_IC][5] = 60,
	[1][1][2][0][RTW89_ACMA][5] = 60,
	[1][1][2][0][RTW89_FCC][9] = 68,
	[1][1][2][0][RTW89_ETSI][9] = 54,
	[1][1][2][0][RTW89_MKK][9] = 52,
	[1][1][2][0][RTW89_IC][9] = 60,
	[1][1][2][0][RTW89_ACMA][9] = 60,
	[1][1][2][0][RTW89_FCC][13] = 54,
	[1][1][2][0][RTW89_ETSI][13] = 54,
	[1][1][2][0][RTW89_MKK][13] = 52,
	[1][1][2][0][RTW89_IC][13] = 60,
	[1][1][2][0][RTW89_ACMA][13] = 60,
	[1][1][2][0][RTW89_FCC][16] = 48,
	[1][1][2][0][RTW89_ETSI][16] = 54,
	[1][1][2][0][RTW89_MKK][16] = 66,
	[1][1][2][0][RTW89_IC][16] = 58,
	[1][1][2][0][RTW89_ACMA][16] = 60,
	[1][1][2][0][RTW89_FCC][20] = 68,
	[1][1][2][0][RTW89_ETSI][20] = 54,
	[1][1][2][0][RTW89_MKK][20] = 66,
	[1][1][2][0][RTW89_IC][20] = 66,
	[1][1][2][0][RTW89_ACMA][20] = 60,
	[1][1][2][0][RTW89_FCC][24] = 68,
	[1][1][2][0][RTW89_ETSI][24] = 54,
	[1][1][2][0][RTW89_MKK][24] = 66,
	[1][1][2][0][RTW89_IC][24] = 127,
	[1][1][2][0][RTW89_ACMA][24] = 127,
	[1][1][2][0][RTW89_FCC][28] = 68,
	[1][1][2][0][RTW89_ETSI][28] = 54,
	[1][1][2][0][RTW89_MKK][28] = 66,
	[1][1][2][0][RTW89_IC][28] = 127,
	[1][1][2][0][RTW89_ACMA][28] = 127,
	[1][1][2][0][RTW89_FCC][32] = 60,
	[1][1][2][0][RTW89_ETSI][32] = 54,
	[1][1][2][0][RTW89_MKK][32] = 66,
	[1][1][2][0][RTW89_IC][32] = 66,
	[1][1][2][0][RTW89_ACMA][32] = 54,
	[1][1][2][0][RTW89_FCC][36] = 68,
	[1][1][2][0][RTW89_ETSI][36] = 127,
	[1][1][2][0][RTW89_MKK][36] = 66,
	[1][1][2][0][RTW89_IC][36] = 66,
	[1][1][2][0][RTW89_ACMA][36] = 66,
	[1][1][2][0][RTW89_FCC][39] = 68,
	[1][1][2][0][RTW89_ETSI][39] = 18,
	[1][1][2][0][RTW89_MKK][39] = 127,
	[1][1][2][0][RTW89_IC][39] = 66,
	[1][1][2][0][RTW89_ACMA][39] = 66,
	[1][1][2][0][RTW89_FCC][43] = 68,
	[1][1][2][0][RTW89_ETSI][43] = 18,
	[1][1][2][0][RTW89_MKK][43] = 127,
	[1][1][2][0][RTW89_IC][43] = 66,
	[1][1][2][0][RTW89_ACMA][43] = 66,
	[1][1][2][0][RTW89_FCC][47] = 60,
	[1][1][2][0][RTW89_ETSI][47] = 127,
	[1][1][2][0][RTW89_MKK][47] = 127,
	[1][1][2][0][RTW89_IC][47] = 127,
	[1][1][2][0][RTW89_ACMA][47] = 127,
	[1][1][2][0][RTW89_FCC][51] = 58,
	[1][1][2][0][RTW89_ETSI][51] = 127,
	[1][1][2][0][RTW89_MKK][51] = 127,
	[1][1][2][0][RTW89_IC][51] = 127,
	[1][1][2][0][RTW89_ACMA][51] = 127,
	[1][1][2][1][RTW89_FCC][1] = 54,
	[1][1][2][1][RTW89_ETSI][1] = 40,
	[1][1][2][1][RTW89_MKK][1] = 48,
	[1][1][2][1][RTW89_IC][1] = 48,
	[1][1][2][1][RTW89_ACMA][1] = 48,
	[1][1][2][1][RTW89_FCC][5] = 60,
	[1][1][2][1][RTW89_ETSI][5] = 40,
	[1][1][2][1][RTW89_MKK][5] = 52,
	[1][1][2][1][RTW89_IC][5] = 48,
	[1][1][2][1][RTW89_ACMA][5] = 48,
	[1][1][2][1][RTW89_FCC][9] = 60,
	[1][1][2][1][RTW89_ETSI][9] = 40,
	[1][1][2][1][RTW89_MKK][9] = 52,
	[1][1][2][1][RTW89_IC][9] = 48,
	[1][1][2][1][RTW89_ACMA][9] = 48,
	[1][1][2][1][RTW89_FCC][13] = 54,
	[1][1][2][1][RTW89_ETSI][13] = 40,
	[1][1][2][1][RTW89_MKK][13] = 52,
	[1][1][2][1][RTW89_IC][13] = 48,
	[1][1][2][1][RTW89_ACMA][13] = 48,
	[1][1][2][1][RTW89_FCC][16] = 48,
	[1][1][2][1][RTW89_ETSI][16] = 40,
	[1][1][2][1][RTW89_MKK][16] = 66,
	[1][1][2][1][RTW89_IC][16] = 58,
	[1][1][2][1][RTW89_ACMA][16] = 48,
	[1][1][2][1][RTW89_FCC][20] = 60,
	[1][1][2][1][RTW89_ETSI][20] = 40,
	[1][1][2][1][RTW89_MKK][20] = 66,
	[1][1][2][1][RTW89_IC][20] = 66,
	[1][1][2][1][RTW89_ACMA][20] = 48,
	[1][1][2][1][RTW89_FCC][24] = 60,
	[1][1][2][1][RTW89_ETSI][24] = 40,
	[1][1][2][1][RTW89_MKK][24] = 66,
	[1][1][2][1][RTW89_IC][24] = 127,
	[1][1][2][1][RTW89_ACMA][24] = 127,
	[1][1][2][1][RTW89_FCC][28] = 60,
	[1][1][2][1][RTW89_ETSI][28] = 40,
	[1][1][2][1][RTW89_MKK][28] = 66,
	[1][1][2][1][RTW89_IC][28] = 127,
	[1][1][2][1][RTW89_ACMA][28] = 127,
	[1][1][2][1][RTW89_FCC][32] = 60,
	[1][1][2][1][RTW89_ETSI][32] = 40,
	[1][1][2][1][RTW89_MKK][32] = 66,
	[1][1][2][1][RTW89_IC][32] = 66,
	[1][1][2][1][RTW89_ACMA][32] = 42,
	[1][1][2][1][RTW89_FCC][36] = 60,
	[1][1][2][1][RTW89_ETSI][36] = 127,
	[1][1][2][1][RTW89_MKK][36] = 66,
	[1][1][2][1][RTW89_IC][36] = 66,
	[1][1][2][1][RTW89_ACMA][36] = 66,
	[1][1][2][1][RTW89_FCC][39] = 68,
	[1][1][2][1][RTW89_ETSI][39] = 6,
	[1][1][2][1][RTW89_MKK][39] = 127,
	[1][1][2][1][RTW89_IC][39] = 66,
	[1][1][2][1][RTW89_ACMA][39] = 66,
	[1][1][2][1][RTW89_FCC][43] = 68,
	[1][1][2][1][RTW89_ETSI][43] = 6,
	[1][1][2][1][RTW89_MKK][43] = 127,
	[1][1][2][1][RTW89_IC][43] = 66,
	[1][1][2][1][RTW89_ACMA][43] = 66,
	[1][1][2][1][RTW89_FCC][47] = 60,
	[1][1][2][1][RTW89_ETSI][47] = 127,
	[1][1][2][1][RTW89_MKK][47] = 127,
	[1][1][2][1][RTW89_IC][47] = 127,
	[1][1][2][1][RTW89_ACMA][47] = 127,
	[1][1][2][1][RTW89_FCC][51] = 58,
	[1][1][2][1][RTW89_ETSI][51] = 127,
	[1][1][2][1][RTW89_MKK][51] = 127,
	[1][1][2][1][RTW89_IC][51] = 127,
	[1][1][2][1][RTW89_ACMA][51] = 127,
	[2][0][2][0][RTW89_FCC][3] = 56,
	[2][0][2][0][RTW89_ETSI][3] = 60,
	[2][0][2][0][RTW89_MKK][3] = 60,
	[2][0][2][0][RTW89_IC][3] = 60,
	[2][0][2][0][RTW89_ACMA][3] = 60,
	[2][0][2][0][RTW89_FCC][11] = 58,
	[2][0][2][0][RTW89_ETSI][11] = 60,
	[2][0][2][0][RTW89_MKK][11] = 60,
	[2][0][2][0][RTW89_IC][11] = 60,
	[2][0][2][0][RTW89_ACMA][11] = 60,
	[2][0][2][0][RTW89_FCC][18] = 54,
	[2][0][2][0][RTW89_ETSI][18] = 60,
	[2][0][2][0][RTW89_MKK][18] = 60,
	[2][0][2][0][RTW89_IC][18] = 60,
	[2][0][2][0][RTW89_ACMA][18] = 60,
	[2][0][2][0][RTW89_FCC][26] = 62,
	[2][0][2][0][RTW89_ETSI][26] = 60,
	[2][0][2][0][RTW89_MKK][26] = 60,
	[2][0][2][0][RTW89_IC][26] = 127,
	[2][0][2][0][RTW89_ACMA][26] = 127,
	[2][0][2][0][RTW89_FCC][34] = 62,
	[2][0][2][0][RTW89_ETSI][34] = 127,
	[2][0][2][0][RTW89_MKK][34] = 60,
	[2][0][2][0][RTW89_IC][34] = 60,
	[2][0][2][0][RTW89_ACMA][34] = 60,
	[2][0][2][0][RTW89_FCC][41] = 62,
	[2][0][2][0][RTW89_ETSI][41] = 30,
	[2][0][2][0][RTW89_MKK][41] = 127,
	[2][0][2][0][RTW89_IC][41] = 60,
	[2][0][2][0][RTW89_ACMA][41] = 60,
	[2][0][2][0][RTW89_FCC][49] = 56,
	[2][0][2][0][RTW89_ETSI][49] = 127,
	[2][0][2][0][RTW89_MKK][49] = 127,
	[2][0][2][0][RTW89_IC][49] = 127,
	[2][0][2][0][RTW89_ACMA][49] = 127,
	[2][1][2][0][RTW89_FCC][3] = 48,
	[2][1][2][0][RTW89_ETSI][3] = 54,
	[2][1][2][0][RTW89_MKK][3] = 56,
	[2][1][2][0][RTW89_IC][3] = 52,
	[2][1][2][0][RTW89_ACMA][3] = 52,
	[2][1][2][0][RTW89_FCC][11] = 54,
	[2][1][2][0][RTW89_ETSI][11] = 54,
	[2][1][2][0][RTW89_MKK][11] = 54,
	[2][1][2][0][RTW89_IC][11] = 52,
	[2][1][2][0][RTW89_ACMA][11] = 52,
	[2][1][2][0][RTW89_FCC][18] = 48,
	[2][1][2][0][RTW89_ETSI][18] = 54,
	[2][1][2][0][RTW89_MKK][18] = 60,
	[2][1][2][0][RTW89_IC][18] = 58,
	[2][1][2][0][RTW89_ACMA][18] = 52,
	[2][1][2][0][RTW89_FCC][26] = 62,
	[2][1][2][0][RTW89_ETSI][26] = 54,
	[2][1][2][0][RTW89_MKK][26] = 56,
	[2][1][2][0][RTW89_IC][26] = 127,
	[2][1][2][0][RTW89_ACMA][26] = 127,
	[2][1][2][0][RTW89_FCC][34] = 62,
	[2][1][2][0][RTW89_ETSI][34] = 127,
	[2][1][2][0][RTW89_MKK][34] = 60,
	[2][1][2][0][RTW89_IC][34] = 60,
	[2][1][2][0][RTW89_ACMA][34] = 60,
	[2][1][2][0][RTW89_FCC][41] = 62,
	[2][1][2][0][RTW89_ETSI][41] = 18,
	[2][1][2][0][RTW89_MKK][41] = 127,
	[2][1][2][0][RTW89_IC][41] = 60,
	[2][1][2][0][RTW89_ACMA][41] = 60,
	[2][1][2][0][RTW89_FCC][49] = 50,
	[2][1][2][0][RTW89_ETSI][49] = 127,
	[2][1][2][0][RTW89_MKK][49] = 127,
	[2][1][2][0][RTW89_IC][49] = 127,
	[2][1][2][0][RTW89_ACMA][49] = 127,
	[2][1][2][1][RTW89_FCC][3] = 48,
	[2][1][2][1][RTW89_ETSI][3] = 40,
	[2][1][2][1][RTW89_MKK][3] = 56,
	[2][1][2][1][RTW89_IC][3] = 40,
	[2][1][2][1][RTW89_ACMA][3] = 40,
	[2][1][2][1][RTW89_FCC][11] = 54,
	[2][1][2][1][RTW89_ETSI][11] = 40,
	[2][1][2][1][RTW89_MKK][11] = 54,
	[2][1][2][1][RTW89_IC][11] = 40,
	[2][1][2][1][RTW89_ACMA][11] = 40,
	[2][1][2][1][RTW89_FCC][18] = 48,
	[2][1][2][1][RTW89_ETSI][18] = 40,
	[2][1][2][1][RTW89_MKK][18] = 60,
	[2][1][2][1][RTW89_IC][18] = 58,
	[2][1][2][1][RTW89_ACMA][18] = 40,
	[2][1][2][1][RTW89_FCC][26] = 60,
	[2][1][2][1][RTW89_ETSI][26] = 42,
	[2][1][2][1][RTW89_MKK][26] = 56,
	[2][1][2][1][RTW89_IC][26] = 127,
	[2][1][2][1][RTW89_ACMA][26] = 127,
	[2][1][2][1][RTW89_FCC][34] = 60,
	[2][1][2][1][RTW89_ETSI][34] = 127,
	[2][1][2][1][RTW89_MKK][34] = 60,
	[2][1][2][1][RTW89_IC][34] = 60,
	[2][1][2][1][RTW89_ACMA][34] = 60,
	[2][1][2][1][RTW89_FCC][41] = 62,
	[2][1][2][1][RTW89_ETSI][41] = 6,
	[2][1][2][1][RTW89_MKK][41] = 127,
	[2][1][2][1][RTW89_IC][41] = 60,
	[2][1][2][1][RTW89_ACMA][41] = 60,
	[2][1][2][1][RTW89_FCC][49] = 50,
	[2][1][2][1][RTW89_ETSI][49] = 127,
	[2][1][2][1][RTW89_MKK][49] = 127,
	[2][1][2][1][RTW89_IC][49] = 127,
	[2][1][2][1][RTW89_ACMA][49] = 127,
	[3][0][2][0][RTW89_FCC][7] = 38,
	[3][0][2][0][RTW89_ETSI][7] = 50,
	[3][0][2][0][RTW89_MKK][7] = 50,
	[3][0][2][0][RTW89_IC][7] = 50,
	[3][0][2][0][RTW89_ACMA][7] = 50,
	[3][0][2][0][RTW89_FCC][22] = 52,
	[3][0][2][0][RTW89_ETSI][22] = 50,
	[3][0][2][0][RTW89_MKK][22] = 50,
	[3][0][2][0][RTW89_IC][22] = 50,
	[3][0][2][0][RTW89_ACMA][22] = 50,
	[3][0][2][0][RTW89_FCC][45] = 127,
	[3][0][2][0][RTW89_ETSI][45] = 127,
	[3][0][2][0][RTW89_MKK][45] = 127,
	[3][0][2][0][RTW89_IC][45] = 127,
	[3][0][2][0][RTW89_ACMA][45] = 127,
	[3][1][2][0][RTW89_FCC][7] = 26,
	[3][1][2][0][RTW89_ETSI][7] = 50,
	[3][1][2][0][RTW89_MKK][7] = 36,
	[3][1][2][0][RTW89_IC][7] = 44,
	[3][1][2][0][RTW89_ACMA][7] = 44,
	[3][1][2][0][RTW89_FCC][22] = 42,
	[3][1][2][0][RTW89_ETSI][22] = 50,
	[3][1][2][0][RTW89_MKK][22] = 48,
	[3][1][2][0][RTW89_IC][22] = 44,
	[3][1][2][0][RTW89_ACMA][22] = 44,
	[3][1][2][0][RTW89_FCC][45] = 127,
	[3][1][2][0][RTW89_ETSI][45] = 127,
	[3][1][2][0][RTW89_MKK][45] = 127,
	[3][1][2][0][RTW89_IC][45] = 127,
	[3][1][2][0][RTW89_ACMA][45] = 127,
	[3][1][2][1][RTW89_FCC][7] = 14,
	[3][1][2][1][RTW89_ETSI][7] = 42,
	[3][1][2][1][RTW89_MKK][7] = 36,
	[3][1][2][1][RTW89_IC][7] = 32,
	[3][1][2][1][RTW89_ACMA][7] = 32,
	[3][1][2][1][RTW89_FCC][22] = 30,
	[3][1][2][1][RTW89_ETSI][22] = 42,
	[3][1][2][1][RTW89_MKK][22] = 48,
	[3][1][2][1][RTW89_IC][22] = 32,
	[3][1][2][1][RTW89_ACMA][22] = 32,
	[3][1][2][1][RTW89_FCC][45] = 127,
	[3][1][2][1][RTW89_ETSI][45] = 127,
	[3][1][2][1][RTW89_MKK][45] = 127,
	[3][1][2][1][RTW89_IC][45] = 127,
	[3][1][2][1][RTW89_ACMA][45] = 127,
};

const s8 rtw89_8852c_txpwr_lmt_6g[RTW89_6G_BW_NUM][RTW89_NTX_NUM]
				 [RTW89_RS_LMT_NUM][RTW89_BF_NUM]
				 [RTW89_REGD_NUM][RTW89_6G_CH_NUM] = {
	[0][0][1][0][RTW89_WW][0] = 72,
	[0][0][1][0][RTW89_WW][2] = 72,
	[0][0][1][0][RTW89_WW][4] = 72,
	[0][0][1][0][RTW89_WW][6] = 72,
	[0][0][1][0][RTW89_WW][8] = 72,
	[0][0][1][0][RTW89_WW][10] = 72,
	[0][0][1][0][RTW89_WW][12] = 72,
	[0][0][1][0][RTW89_WW][14] = 72,
	[0][0][1][0][RTW89_WW][15] = 72,
	[0][0][1][0][RTW89_WW][17] = 72,
	[0][0][1][0][RTW89_WW][19] = 72,
	[0][0][1][0][RTW89_WW][21] = 72,
	[0][0][1][0][RTW89_WW][23] = 72,
	[0][0][1][0][RTW89_WW][25] = 72,
	[0][0][1][0][RTW89_WW][27] = 72,
	[0][0][1][0][RTW89_WW][29] = 72,
	[0][0][1][0][RTW89_WW][30] = 72,
	[0][0][1][0][RTW89_WW][32] = 72,
	[0][0][1][0][RTW89_WW][34] = 72,
	[0][0][1][0][RTW89_WW][36] = 72,
	[0][0][1][0][RTW89_WW][38] = 72,
	[0][0][1][0][RTW89_WW][40] = 72,
	[0][0][1][0][RTW89_WW][42] = 72,
	[0][0][1][0][RTW89_WW][44] = 72,
	[0][0][1][0][RTW89_WW][45] = 72,
	[0][0][1][0][RTW89_WW][47] = 72,
	[0][0][1][0][RTW89_WW][49] = 72,
	[0][0][1][0][RTW89_WW][51] = 72,
	[0][0][1][0][RTW89_WW][53] = 72,
	[0][0][1][0][RTW89_WW][55] = 72,
	[0][0][1][0][RTW89_WW][57] = 72,
	[0][0][1][0][RTW89_WW][59] = 72,
	[0][0][1][0][RTW89_WW][60] = 72,
	[0][0][1][0][RTW89_WW][62] = 72,
	[0][0][1][0][RTW89_WW][64] = 72,
	[0][0][1][0][RTW89_WW][66] = 72,
	[0][0][1][0][RTW89_WW][68] = 72,
	[0][0][1][0][RTW89_WW][70] = 72,
	[0][0][1][0][RTW89_WW][72] = 72,
	[0][0][1][0][RTW89_WW][74] = 72,
	[0][0][1][0][RTW89_WW][75] = 72,
	[0][0][1][0][RTW89_WW][77] = 72,
	[0][0][1][0][RTW89_WW][79] = 72,
	[0][0][1][0][RTW89_WW][81] = 72,
	[0][0][1][0][RTW89_WW][83] = 72,
	[0][0][1][0][RTW89_WW][85] = 72,
	[0][0][1][0][RTW89_WW][87] = 72,
	[0][0][1][0][RTW89_WW][89] = 72,
	[0][0][1][0][RTW89_WW][90] = 72,
	[0][0][1][0][RTW89_WW][92] = 72,
	[0][0][1][0][RTW89_WW][94] = 72,
	[0][0][1][0][RTW89_WW][96] = 72,
	[0][0][1][0][RTW89_WW][98] = 72,
	[0][0][1][0][RTW89_WW][100] = 72,
	[0][0][1][0][RTW89_WW][102] = 72,
	[0][0][1][0][RTW89_WW][104] = 72,
	[0][0][1][0][RTW89_WW][105] = 72,
	[0][0][1][0][RTW89_WW][107] = 72,
	[0][0][1][0][RTW89_WW][109] = 72,
	[0][0][1][0][RTW89_WW][111] = 0,
	[0][0][1][0][RTW89_WW][113] = 0,
	[0][0][1][0][RTW89_WW][115] = 0,
	[0][0][1][0][RTW89_WW][117] = 0,
	[0][0][1][0][RTW89_WW][119] = 0,
	[0][1][1][0][RTW89_WW][0] = 60,
	[0][1][1][0][RTW89_WW][2] = 60,
	[0][1][1][0][RTW89_WW][4] = 60,
	[0][1][1][0][RTW89_WW][6] = 60,
	[0][1][1][0][RTW89_WW][8] = 60,
	[0][1][1][0][RTW89_WW][10] = 60,
	[0][1][1][0][RTW89_WW][12] = 60,
	[0][1][1][0][RTW89_WW][14] = 60,
	[0][1][1][0][RTW89_WW][15] = 60,
	[0][1][1][0][RTW89_WW][17] = 60,
	[0][1][1][0][RTW89_WW][19] = 60,
	[0][1][1][0][RTW89_WW][21] = 60,
	[0][1][1][0][RTW89_WW][23] = 60,
	[0][1][1][0][RTW89_WW][25] = 60,
	[0][1][1][0][RTW89_WW][27] = 60,
	[0][1][1][0][RTW89_WW][29] = 60,
	[0][1][1][0][RTW89_WW][30] = 60,
	[0][1][1][0][RTW89_WW][32] = 60,
	[0][1][1][0][RTW89_WW][34] = 60,
	[0][1][1][0][RTW89_WW][36] = 60,
	[0][1][1][0][RTW89_WW][38] = 60,
	[0][1][1][0][RTW89_WW][40] = 60,
	[0][1][1][0][RTW89_WW][42] = 60,
	[0][1][1][0][RTW89_WW][44] = 60,
	[0][1][1][0][RTW89_WW][45] = 60,
	[0][1][1][0][RTW89_WW][47] = 60,
	[0][1][1][0][RTW89_WW][49] = 60,
	[0][1][1][0][RTW89_WW][51] = 60,
	[0][1][1][0][RTW89_WW][53] = 60,
	[0][1][1][0][RTW89_WW][55] = 60,
	[0][1][1][0][RTW89_WW][57] = 60,
	[0][1][1][0][RTW89_WW][59] = 60,
	[0][1][1][0][RTW89_WW][60] = 60,
	[0][1][1][0][RTW89_WW][62] = 60,
	[0][1][1][0][RTW89_WW][64] = 60,
	[0][1][1][0][RTW89_WW][66] = 60,
	[0][1][1][0][RTW89_WW][68] = 60,
	[0][1][1][0][RTW89_WW][70] = 60,
	[0][1][1][0][RTW89_WW][72] = 60,
	[0][1][1][0][RTW89_WW][74] = 60,
	[0][1][1][0][RTW89_WW][75] = 60,
	[0][1][1][0][RTW89_WW][77] = 60,
	[0][1][1][0][RTW89_WW][79] = 60,
	[0][1][1][0][RTW89_WW][81] = 60,
	[0][1][1][0][RTW89_WW][83] = 60,
	[0][1][1][0][RTW89_WW][85] = 60,
	[0][1][1][0][RTW89_WW][87] = 60,
	[0][1][1][0][RTW89_WW][89] = 60,
	[0][1][1][0][RTW89_WW][90] = 60,
	[0][1][1][0][RTW89_WW][92] = 60,
	[0][1][1][0][RTW89_WW][94] = 60,
	[0][1][1][0][RTW89_WW][96] = 60,
	[0][1][1][0][RTW89_WW][98] = 60,
	[0][1][1][0][RTW89_WW][100] = 60,
	[0][1][1][0][RTW89_WW][102] = 60,
	[0][1][1][0][RTW89_WW][104] = 60,
	[0][1][1][0][RTW89_WW][105] = 60,
	[0][1][1][0][RTW89_WW][107] = 60,
	[0][1][1][0][RTW89_WW][109] = 60,
	[0][1][1][0][RTW89_WW][111] = 0,
	[0][1][1][0][RTW89_WW][113] = 0,
	[0][1][1][0][RTW89_WW][115] = 0,
	[0][1][1][0][RTW89_WW][117] = 0,
	[0][1][1][0][RTW89_WW][119] = 0,
	[0][0][2][0][RTW89_WW][0] = 72,
	[0][0][2][0][RTW89_WW][2] = 72,
	[0][0][2][0][RTW89_WW][4] = 72,
	[0][0][2][0][RTW89_WW][6] = 72,
	[0][0][2][0][RTW89_WW][8] = 72,
	[0][0][2][0][RTW89_WW][10] = 72,
	[0][0][2][0][RTW89_WW][12] = 72,
	[0][0][2][0][RTW89_WW][14] = 72,
	[0][0][2][0][RTW89_WW][15] = 72,
	[0][0][2][0][RTW89_WW][17] = 72,
	[0][0][2][0][RTW89_WW][19] = 72,
	[0][0][2][0][RTW89_WW][21] = 72,
	[0][0][2][0][RTW89_WW][23] = 72,
	[0][0][2][0][RTW89_WW][25] = 72,
	[0][0][2][0][RTW89_WW][27] = 72,
	[0][0][2][0][RTW89_WW][29] = 72,
	[0][0][2][0][RTW89_WW][30] = 72,
	[0][0][2][0][RTW89_WW][32] = 72,
	[0][0][2][0][RTW89_WW][34] = 72,
	[0][0][2][0][RTW89_WW][36] = 72,
	[0][0][2][0][RTW89_WW][38] = 72,
	[0][0][2][0][RTW89_WW][40] = 72,
	[0][0][2][0][RTW89_WW][42] = 72,
	[0][0][2][0][RTW89_WW][44] = 72,
	[0][0][2][0][RTW89_WW][45] = 72,
	[0][0][2][0][RTW89_WW][47] = 72,
	[0][0][2][0][RTW89_WW][49] = 72,
	[0][0][2][0][RTW89_WW][51] = 72,
	[0][0][2][0][RTW89_WW][53] = 72,
	[0][0][2][0][RTW89_WW][55] = 72,
	[0][0][2][0][RTW89_WW][57] = 72,
	[0][0][2][0][RTW89_WW][59] = 72,
	[0][0][2][0][RTW89_WW][60] = 72,
	[0][0][2][0][RTW89_WW][62] = 72,
	[0][0][2][0][RTW89_WW][64] = 72,
	[0][0][2][0][RTW89_WW][66] = 72,
	[0][0][2][0][RTW89_WW][68] = 72,
	[0][0][2][0][RTW89_WW][70] = 72,
	[0][0][2][0][RTW89_WW][72] = 72,
	[0][0][2][0][RTW89_WW][74] = 72,
	[0][0][2][0][RTW89_WW][75] = 72,
	[0][0][2][0][RTW89_WW][77] = 72,
	[0][0][2][0][RTW89_WW][79] = 72,
	[0][0][2][0][RTW89_WW][81] = 72,
	[0][0][2][0][RTW89_WW][83] = 72,
	[0][0][2][0][RTW89_WW][85] = 72,
	[0][0][2][0][RTW89_WW][87] = 72,
	[0][0][2][0][RTW89_WW][89] = 72,
	[0][0][2][0][RTW89_WW][90] = 72,
	[0][0][2][0][RTW89_WW][92] = 72,
	[0][0][2][0][RTW89_WW][94] = 72,
	[0][0][2][0][RTW89_WW][96] = 72,
	[0][0][2][0][RTW89_WW][98] = 72,
	[0][0][2][0][RTW89_WW][100] = 72,
	[0][0][2][0][RTW89_WW][102] = 72,
	[0][0][2][0][RTW89_WW][104] = 72,
	[0][0][2][0][RTW89_WW][105] = 72,
	[0][0][2][0][RTW89_WW][107] = 72,
	[0][0][2][0][RTW89_WW][109] = 72,
	[0][0][2][0][RTW89_WW][111] = 0,
	[0][0][2][0][RTW89_WW][113] = 0,
	[0][0][2][0][RTW89_WW][115] = 0,
	[0][0][2][0][RTW89_WW][117] = 0,
	[0][0][2][0][RTW89_WW][119] = 0,
	[0][1][2][0][RTW89_WW][0] = 60,
	[0][1][2][0][RTW89_WW][2] = 60,
	[0][1][2][0][RTW89_WW][4] = 60,
	[0][1][2][0][RTW89_WW][6] = 60,
	[0][1][2][0][RTW89_WW][8] = 60,
	[0][1][2][0][RTW89_WW][10] = 60,
	[0][1][2][0][RTW89_WW][12] = 60,
	[0][1][2][0][RTW89_WW][14] = 60,
	[0][1][2][0][RTW89_WW][15] = 60,
	[0][1][2][0][RTW89_WW][17] = 60,
	[0][1][2][0][RTW89_WW][19] = 60,
	[0][1][2][0][RTW89_WW][21] = 60,
	[0][1][2][0][RTW89_WW][23] = 60,
	[0][1][2][0][RTW89_WW][25] = 60,
	[0][1][2][0][RTW89_WW][27] = 60,
	[0][1][2][0][RTW89_WW][29] = 60,
	[0][1][2][0][RTW89_WW][30] = 60,
	[0][1][2][0][RTW89_WW][32] = 60,
	[0][1][2][0][RTW89_WW][34] = 60,
	[0][1][2][0][RTW89_WW][36] = 60,
	[0][1][2][0][RTW89_WW][38] = 60,
	[0][1][2][0][RTW89_WW][40] = 60,
	[0][1][2][0][RTW89_WW][42] = 60,
	[0][1][2][0][RTW89_WW][44] = 60,
	[0][1][2][0][RTW89_WW][45] = 60,
	[0][1][2][0][RTW89_WW][47] = 60,
	[0][1][2][0][RTW89_WW][49] = 60,
	[0][1][2][0][RTW89_WW][51] = 60,
	[0][1][2][0][RTW89_WW][53] = 60,
	[0][1][2][0][RTW89_WW][55] = 60,
	[0][1][2][0][RTW89_WW][57] = 60,
	[0][1][2][0][RTW89_WW][59] = 60,
	[0][1][2][0][RTW89_WW][60] = 60,
	[0][1][2][0][RTW89_WW][62] = 60,
	[0][1][2][0][RTW89_WW][64] = 60,
	[0][1][2][0][RTW89_WW][66] = 60,
	[0][1][2][0][RTW89_WW][68] = 60,
	[0][1][2][0][RTW89_WW][70] = 60,
	[0][1][2][0][RTW89_WW][72] = 60,
	[0][1][2][0][RTW89_WW][74] = 60,
	[0][1][2][0][RTW89_WW][75] = 60,
	[0][1][2][0][RTW89_WW][77] = 60,
	[0][1][2][0][RTW89_WW][79] = 60,
	[0][1][2][0][RTW89_WW][81] = 60,
	[0][1][2][0][RTW89_WW][83] = 60,
	[0][1][2][0][RTW89_WW][85] = 60,
	[0][1][2][0][RTW89_WW][87] = 60,
	[0][1][2][0][RTW89_WW][89] = 60,
	[0][1][2][0][RTW89_WW][90] = 60,
	[0][1][2][0][RTW89_WW][92] = 60,
	[0][1][2][0][RTW89_WW][94] = 60,
	[0][1][2][0][RTW89_WW][96] = 60,
	[0][1][2][0][RTW89_WW][98] = 60,
	[0][1][2][0][RTW89_WW][100] = 60,
	[0][1][2][0][RTW89_WW][102] = 60,
	[0][1][2][0][RTW89_WW][104] = 60,
	[0][1][2][0][RTW89_WW][105] = 60,
	[0][1][2][0][RTW89_WW][107] = 60,
	[0][1][2][0][RTW89_WW][109] = 60,
	[0][1][2][0][RTW89_WW][111] = 0,
	[0][1][2][0][RTW89_WW][113] = 0,
	[0][1][2][0][RTW89_WW][115] = 0,
	[0][1][2][0][RTW89_WW][117] = 0,
	[0][1][2][0][RTW89_WW][119] = 0,
	[0][1][2][1][RTW89_WW][0] = 48,
	[0][1][2][1][RTW89_WW][2] = 48,
	[0][1][2][1][RTW89_WW][4] = 48,
	[0][1][2][1][RTW89_WW][6] = 48,
	[0][1][2][1][RTW89_WW][8] = 48,
	[0][1][2][1][RTW89_WW][10] = 48,
	[0][1][2][1][RTW89_WW][12] = 48,
	[0][1][2][1][RTW89_WW][14] = 48,
	[0][1][2][1][RTW89_WW][15] = 48,
	[0][1][2][1][RTW89_WW][17] = 48,
	[0][1][2][1][RTW89_WW][19] = 48,
	[0][1][2][1][RTW89_WW][21] = 48,
	[0][1][2][1][RTW89_WW][23] = 48,
	[0][1][2][1][RTW89_WW][25] = 48,
	[0][1][2][1][RTW89_WW][27] = 48,
	[0][1][2][1][RTW89_WW][29] = 48,
	[0][1][2][1][RTW89_WW][30] = 48,
	[0][1][2][1][RTW89_WW][32] = 48,
	[0][1][2][1][RTW89_WW][34] = 48,
	[0][1][2][1][RTW89_WW][36] = 48,
	[0][1][2][1][RTW89_WW][38] = 48,
	[0][1][2][1][RTW89_WW][40] = 48,
	[0][1][2][1][RTW89_WW][42] = 48,
	[0][1][2][1][RTW89_WW][44] = 48,
	[0][1][2][1][RTW89_WW][45] = 48,
	[0][1][2][1][RTW89_WW][47] = 48,
	[0][1][2][1][RTW89_WW][49] = 48,
	[0][1][2][1][RTW89_WW][51] = 48,
	[0][1][2][1][RTW89_WW][53] = 48,
	[0][1][2][1][RTW89_WW][55] = 48,
	[0][1][2][1][RTW89_WW][57] = 48,
	[0][1][2][1][RTW89_WW][59] = 48,
	[0][1][2][1][RTW89_WW][60] = 48,
	[0][1][2][1][RTW89_WW][62] = 48,
	[0][1][2][1][RTW89_WW][64] = 48,
	[0][1][2][1][RTW89_WW][66] = 48,
	[0][1][2][1][RTW89_WW][68] = 48,
	[0][1][2][1][RTW89_WW][70] = 48,
	[0][1][2][1][RTW89_WW][72] = 48,
	[0][1][2][1][RTW89_WW][74] = 48,
	[0][1][2][1][RTW89_WW][75] = 48,
	[0][1][2][1][RTW89_WW][77] = 48,
	[0][1][2][1][RTW89_WW][79] = 48,
	[0][1][2][1][RTW89_WW][81] = 48,
	[0][1][2][1][RTW89_WW][83] = 48,
	[0][1][2][1][RTW89_WW][85] = 48,
	[0][1][2][1][RTW89_WW][87] = 48,
	[0][1][2][1][RTW89_WW][89] = 48,
	[0][1][2][1][RTW89_WW][90] = 48,
	[0][1][2][1][RTW89_WW][92] = 48,
	[0][1][2][1][RTW89_WW][94] = 48,
	[0][1][2][1][RTW89_WW][96] = 48,
	[0][1][2][1][RTW89_WW][98] = 48,
	[0][1][2][1][RTW89_WW][100] = 48,
	[0][1][2][1][RTW89_WW][102] = 48,
	[0][1][2][1][RTW89_WW][104] = 48,
	[0][1][2][1][RTW89_WW][105] = 48,
	[0][1][2][1][RTW89_WW][107] = 48,
	[0][1][2][1][RTW89_WW][109] = 48,
	[0][1][2][1][RTW89_WW][111] = 0,
	[0][1][2][1][RTW89_WW][113] = 0,
	[0][1][2][1][RTW89_WW][115] = 0,
	[0][1][2][1][RTW89_WW][117] = 0,
	[0][1][2][1][RTW89_WW][119] = 0,
	[1][0][2][0][RTW89_WW][1] = 72,
	[1][0][2][0][RTW89_WW][5] = 72,
	[1][0][2][0][RTW89_WW][9] = 72,
	[1][0][2][0][RTW89_WW][13] = 72,
	[1][0][2][0][RTW89_WW][16] = 72,
	[1][0][2][0][RTW89_WW][20] = 72,
	[1][0][2][0][RTW89_WW][24] = 72,
	[1][0][2][0][RTW89_WW][28] = 72,
	[1][0][2][0][RTW89_WW][31] = 72,
	[1][0][2][0][RTW89_WW][35] = 72,
	[1][0][2][0][RTW89_WW][39] = 72,
	[1][0][2][0][RTW89_WW][43] = 72,
	[1][0][2][0][RTW89_WW][46] = 72,
	[1][0][2][0][RTW89_WW][50] = 72,
	[1][0][2][0][RTW89_WW][54] = 72,
	[1][0][2][0][RTW89_WW][58] = 72,
	[1][0][2][0][RTW89_WW][61] = 72,
	[1][0][2][0][RTW89_WW][65] = 72,
	[1][0][2][0][RTW89_WW][69] = 72,
	[1][0][2][0][RTW89_WW][73] = 72,
	[1][0][2][0][RTW89_WW][76] = 72,
	[1][0][2][0][RTW89_WW][80] = 72,
	[1][0][2][0][RTW89_WW][84] = 72,
	[1][0][2][0][RTW89_WW][88] = 72,
	[1][0][2][0][RTW89_WW][91] = 72,
	[1][0][2][0][RTW89_WW][95] = 72,
	[1][0][2][0][RTW89_WW][99] = 72,
	[1][0][2][0][RTW89_WW][103] = 72,
	[1][0][2][0][RTW89_WW][106] = 72,
	[1][0][2][0][RTW89_WW][110] = 0,
	[1][0][2][0][RTW89_WW][114] = 0,
	[1][0][2][0][RTW89_WW][118] = 0,
	[1][1][2][0][RTW89_WW][1] = 60,
	[1][1][2][0][RTW89_WW][5] = 60,
	[1][1][2][0][RTW89_WW][9] = 60,
	[1][1][2][0][RTW89_WW][13] = 60,
	[1][1][2][0][RTW89_WW][16] = 60,
	[1][1][2][0][RTW89_WW][20] = 60,
	[1][1][2][0][RTW89_WW][24] = 60,
	[1][1][2][0][RTW89_WW][28] = 60,
	[1][1][2][0][RTW89_WW][31] = 60,
	[1][1][2][0][RTW89_WW][35] = 60,
	[1][1][2][0][RTW89_WW][39] = 60,
	[1][1][2][0][RTW89_WW][43] = 60,
	[1][1][2][0][RTW89_WW][46] = 60,
	[1][1][2][0][RTW89_WW][50] = 60,
	[1][1][2][0][RTW89_WW][54] = 60,
	[1][1][2][0][RTW89_WW][58] = 60,
	[1][1][2][0][RTW89_WW][61] = 60,
	[1][1][2][0][RTW89_WW][65] = 60,
	[1][1][2][0][RTW89_WW][69] = 60,
	[1][1][2][0][RTW89_WW][73] = 60,
	[1][1][2][0][RTW89_WW][76] = 60,
	[1][1][2][0][RTW89_WW][80] = 60,
	[1][1][2][0][RTW89_WW][84] = 60,
	[1][1][2][0][RTW89_WW][88] = 60,
	[1][1][2][0][RTW89_WW][91] = 60,
	[1][1][2][0][RTW89_WW][95] = 60,
	[1][1][2][0][RTW89_WW][99] = 60,
	[1][1][2][0][RTW89_WW][103] = 60,
	[1][1][2][0][RTW89_WW][106] = 60,
	[1][1][2][0][RTW89_WW][110] = 0,
	[1][1][2][0][RTW89_WW][114] = 0,
	[1][1][2][0][RTW89_WW][118] = 0,
	[1][1][2][1][RTW89_WW][1] = 48,
	[1][1][2][1][RTW89_WW][5] = 48,
	[1][1][2][1][RTW89_WW][9] = 48,
	[1][1][2][1][RTW89_WW][13] = 48,
	[1][1][2][1][RTW89_WW][16] = 48,
	[1][1][2][1][RTW89_WW][20] = 48,
	[1][1][2][1][RTW89_WW][24] = 48,
	[1][1][2][1][RTW89_WW][28] = 48,
	[1][1][2][1][RTW89_WW][31] = 48,
	[1][1][2][1][RTW89_WW][35] = 48,
	[1][1][2][1][RTW89_WW][39] = 48,
	[1][1][2][1][RTW89_WW][43] = 48,
	[1][1][2][1][RTW89_WW][46] = 48,
	[1][1][2][1][RTW89_WW][50] = 48,
	[1][1][2][1][RTW89_WW][54] = 48,
	[1][1][2][1][RTW89_WW][58] = 48,
	[1][1][2][1][RTW89_WW][61] = 48,
	[1][1][2][1][RTW89_WW][65] = 48,
	[1][1][2][1][RTW89_WW][69] = 48,
	[1][1][2][1][RTW89_WW][73] = 48,
	[1][1][2][1][RTW89_WW][76] = 48,
	[1][1][2][1][RTW89_WW][80] = 48,
	[1][1][2][1][RTW89_WW][84] = 48,
	[1][1][2][1][RTW89_WW][88] = 48,
	[1][1][2][1][RTW89_WW][91] = 48,
	[1][1][2][1][RTW89_WW][95] = 48,
	[1][1][2][1][RTW89_WW][99] = 48,
	[1][1][2][1][RTW89_WW][103] = 48,
	[1][1][2][1][RTW89_WW][106] = 48,
	[1][1][2][1][RTW89_WW][110] = 0,
	[1][1][2][1][RTW89_WW][114] = 0,
	[1][1][2][1][RTW89_WW][118] = 0,
	[2][0][2][0][RTW89_WW][3] = 64,
	[2][0][2][0][RTW89_WW][11] = 64,
	[2][0][2][0][RTW89_WW][18] = 64,
	[2][0][2][0][RTW89_WW][26] = 64,
	[2][0][2][0][RTW89_WW][33] = 64,
	[2][0][2][0][RTW89_WW][41] = 64,
	[2][0][2][0][RTW89_WW][48] = 64,
	[2][0][2][0][RTW89_WW][56] = 64,
	[2][0][2][0][RTW89_WW][63] = 64,
	[2][0][2][0][RTW89_WW][71] = 64,
	[2][0][2][0][RTW89_WW][78] = 64,
	[2][0][2][0][RTW89_WW][86] = 64,
	[2][0][2][0][RTW89_WW][93] = 64,
	[2][0][2][0][RTW89_WW][101] = 64,
	[2][0][2][0][RTW89_WW][108] = 0,
	[2][0][2][0][RTW89_WW][116] = 0,
	[2][1][2][0][RTW89_WW][3] = 52,
	[2][1][2][0][RTW89_WW][11] = 52,
	[2][1][2][0][RTW89_WW][18] = 52,
	[2][1][2][0][RTW89_WW][26] = 52,
	[2][1][2][0][RTW89_WW][33] = 52,
	[2][1][2][0][RTW89_WW][41] = 52,
	[2][1][2][0][RTW89_WW][48] = 52,
	[2][1][2][0][RTW89_WW][56] = 52,
	[2][1][2][0][RTW89_WW][63] = 52,
	[2][1][2][0][RTW89_WW][71] = 52,
	[2][1][2][0][RTW89_WW][78] = 52,
	[2][1][2][0][RTW89_WW][86] = 52,
	[2][1][2][0][RTW89_WW][93] = 52,
	[2][1][2][0][RTW89_WW][101] = 52,
	[2][1][2][0][RTW89_WW][108] = 0,
	[2][1][2][0][RTW89_WW][116] = 0,
	[2][1][2][1][RTW89_WW][3] = 40,
	[2][1][2][1][RTW89_WW][11] = 40,
	[2][1][2][1][RTW89_WW][18] = 40,
	[2][1][2][1][RTW89_WW][26] = 40,
	[2][1][2][1][RTW89_WW][33] = 40,
	[2][1][2][1][RTW89_WW][41] = 40,
	[2][1][2][1][RTW89_WW][48] = 40,
	[2][1][2][1][RTW89_WW][56] = 40,
	[2][1][2][1][RTW89_WW][63] = 40,
	[2][1][2][1][RTW89_WW][71] = 40,
	[2][1][2][1][RTW89_WW][78] = 40,
	[2][1][2][1][RTW89_WW][86] = 40,
	[2][1][2][1][RTW89_WW][93] = 40,
	[2][1][2][1][RTW89_WW][101] = 40,
	[2][1][2][1][RTW89_WW][108] = 0,
	[2][1][2][1][RTW89_WW][116] = 0,
	[3][0][2][0][RTW89_WW][7] = 56,
	[3][0][2][0][RTW89_WW][22] = 56,
	[3][0][2][0][RTW89_WW][37] = 56,
	[3][0][2][0][RTW89_WW][52] = 56,
	[3][0][2][0][RTW89_WW][67] = 56,
	[3][0][2][0][RTW89_WW][82] = 56,
	[3][0][2][0][RTW89_WW][97] = 56,
	[3][0][2][0][RTW89_WW][112] = 0,
	[3][1][2][0][RTW89_WW][7] = 44,
	[3][1][2][0][RTW89_WW][22] = 44,
	[3][1][2][0][RTW89_WW][37] = 44,
	[3][1][2][0][RTW89_WW][52] = 44,
	[3][1][2][0][RTW89_WW][67] = 44,
	[3][1][2][0][RTW89_WW][82] = 44,
	[3][1][2][0][RTW89_WW][97] = 44,
	[3][1][2][0][RTW89_WW][112] = 0,
	[3][1][2][1][RTW89_WW][7] = 32,
	[3][1][2][1][RTW89_WW][22] = 32,
	[3][1][2][1][RTW89_WW][37] = 32,
	[3][1][2][1][RTW89_WW][52] = 32,
	[3][1][2][1][RTW89_WW][67] = 32,
	[3][1][2][1][RTW89_WW][82] = 32,
	[3][1][2][1][RTW89_WW][97] = 32,
	[3][1][2][1][RTW89_WW][112] = 0,
	[0][0][1][0][RTW89_FCC][0] = 72,
	[0][0][1][0][RTW89_FCC][2] = 72,
	[0][0][1][0][RTW89_FCC][4] = 72,
	[0][0][1][0][RTW89_FCC][6] = 72,
	[0][0][1][0][RTW89_FCC][8] = 72,
	[0][0][1][0][RTW89_FCC][10] = 72,
	[0][0][1][0][RTW89_FCC][12] = 72,
	[0][0][1][0][RTW89_FCC][14] = 72,
	[0][0][1][0][RTW89_FCC][15] = 72,
	[0][0][1][0][RTW89_FCC][17] = 72,
	[0][0][1][0][RTW89_FCC][19] = 72,
	[0][0][1][0][RTW89_FCC][21] = 72,
	[0][0][1][0][RTW89_FCC][23] = 72,
	[0][0][1][0][RTW89_FCC][25] = 72,
	[0][0][1][0][RTW89_FCC][27] = 72,
	[0][0][1][0][RTW89_FCC][29] = 72,
	[0][0][1][0][RTW89_FCC][30] = 72,
	[0][0][1][0][RTW89_FCC][32] = 72,
	[0][0][1][0][RTW89_FCC][34] = 72,
	[0][0][1][0][RTW89_FCC][36] = 72,
	[0][0][1][0][RTW89_FCC][38] = 72,
	[0][0][1][0][RTW89_FCC][40] = 72,
	[0][0][1][0][RTW89_FCC][42] = 72,
	[0][0][1][0][RTW89_FCC][44] = 72,
	[0][0][1][0][RTW89_FCC][45] = 72,
	[0][0][1][0][RTW89_FCC][47] = 72,
	[0][0][1][0][RTW89_FCC][49] = 72,
	[0][0][1][0][RTW89_FCC][51] = 72,
	[0][0][1][0][RTW89_FCC][53] = 72,
	[0][0][1][0][RTW89_FCC][55] = 72,
	[0][0][1][0][RTW89_FCC][57] = 72,
	[0][0][1][0][RTW89_FCC][59] = 72,
	[0][0][1][0][RTW89_FCC][60] = 72,
	[0][0][1][0][RTW89_FCC][62] = 72,
	[0][0][1][0][RTW89_FCC][64] = 72,
	[0][0][1][0][RTW89_FCC][66] = 72,
	[0][0][1][0][RTW89_FCC][68] = 72,
	[0][0][1][0][RTW89_FCC][70] = 72,
	[0][0][1][0][RTW89_FCC][72] = 72,
	[0][0][1][0][RTW89_FCC][74] = 72,
	[0][0][1][0][RTW89_FCC][75] = 72,
	[0][0][1][0][RTW89_FCC][77] = 72,
	[0][0][1][0][RTW89_FCC][79] = 72,
	[0][0][1][0][RTW89_FCC][81] = 72,
	[0][0][1][0][RTW89_FCC][83] = 72,
	[0][0][1][0][RTW89_FCC][85] = 72,
	[0][0][1][0][RTW89_FCC][87] = 72,
	[0][0][1][0][RTW89_FCC][89] = 72,
	[0][0][1][0][RTW89_FCC][90] = 72,
	[0][0][1][0][RTW89_FCC][92] = 72,
	[0][0][1][0][RTW89_FCC][94] = 72,
	[0][0][1][0][RTW89_FCC][96] = 72,
	[0][0][1][0][RTW89_FCC][98] = 72,
	[0][0][1][0][RTW89_FCC][100] = 72,
	[0][0][1][0][RTW89_FCC][102] = 72,
	[0][0][1][0][RTW89_FCC][104] = 72,
	[0][0][1][0][RTW89_FCC][105] = 72,
	[0][0][1][0][RTW89_FCC][107] = 72,
	[0][0][1][0][RTW89_FCC][109] = 72,
	[0][0][1][0][RTW89_FCC][111] = 127,
	[0][0][1][0][RTW89_FCC][113] = 127,
	[0][0][1][0][RTW89_FCC][115] = 127,
	[0][0][1][0][RTW89_FCC][117] = 127,
	[0][0][1][0][RTW89_FCC][119] = 127,
	[0][1][1][0][RTW89_FCC][0] = 60,
	[0][1][1][0][RTW89_FCC][2] = 60,
	[0][1][1][0][RTW89_FCC][4] = 60,
	[0][1][1][0][RTW89_FCC][6] = 60,
	[0][1][1][0][RTW89_FCC][8] = 60,
	[0][1][1][0][RTW89_FCC][10] = 60,
	[0][1][1][0][RTW89_FCC][12] = 60,
	[0][1][1][0][RTW89_FCC][14] = 60,
	[0][1][1][0][RTW89_FCC][15] = 60,
	[0][1][1][0][RTW89_FCC][17] = 60,
	[0][1][1][0][RTW89_FCC][19] = 60,
	[0][1][1][0][RTW89_FCC][21] = 60,
	[0][1][1][0][RTW89_FCC][23] = 60,
	[0][1][1][0][RTW89_FCC][25] = 60,
	[0][1][1][0][RTW89_FCC][27] = 60,
	[0][1][1][0][RTW89_FCC][29] = 60,
	[0][1][1][0][RTW89_FCC][30] = 60,
	[0][1][1][0][RTW89_FCC][32] = 60,
	[0][1][1][0][RTW89_FCC][34] = 60,
	[0][1][1][0][RTW89_FCC][36] = 60,
	[0][1][1][0][RTW89_FCC][38] = 60,
	[0][1][1][0][RTW89_FCC][40] = 60,
	[0][1][1][0][RTW89_FCC][42] = 60,
	[0][1][1][0][RTW89_FCC][44] = 60,
	[0][1][1][0][RTW89_FCC][45] = 60,
	[0][1][1][0][RTW89_FCC][47] = 60,
	[0][1][1][0][RTW89_FCC][49] = 60,
	[0][1][1][0][RTW89_FCC][51] = 60,
	[0][1][1][0][RTW89_FCC][53] = 60,
	[0][1][1][0][RTW89_FCC][55] = 60,
	[0][1][1][0][RTW89_FCC][57] = 60,
	[0][1][1][0][RTW89_FCC][59] = 60,
	[0][1][1][0][RTW89_FCC][60] = 60,
	[0][1][1][0][RTW89_FCC][62] = 60,
	[0][1][1][0][RTW89_FCC][64] = 60,
	[0][1][1][0][RTW89_FCC][66] = 60,
	[0][1][1][0][RTW89_FCC][68] = 60,
	[0][1][1][0][RTW89_FCC][70] = 60,
	[0][1][1][0][RTW89_FCC][72] = 60,
	[0][1][1][0][RTW89_FCC][74] = 60,
	[0][1][1][0][RTW89_FCC][75] = 60,
	[0][1][1][0][RTW89_FCC][77] = 60,
	[0][1][1][0][RTW89_FCC][79] = 60,
	[0][1][1][0][RTW89_FCC][81] = 60,
	[0][1][1][0][RTW89_FCC][83] = 60,
	[0][1][1][0][RTW89_FCC][85] = 60,
	[0][1][1][0][RTW89_FCC][87] = 60,
	[0][1][1][0][RTW89_FCC][89] = 60,
	[0][1][1][0][RTW89_FCC][90] = 60,
	[0][1][1][0][RTW89_FCC][92] = 60,
	[0][1][1][0][RTW89_FCC][94] = 60,
	[0][1][1][0][RTW89_FCC][96] = 60,
	[0][1][1][0][RTW89_FCC][98] = 60,
	[0][1][1][0][RTW89_FCC][100] = 60,
	[0][1][1][0][RTW89_FCC][102] = 60,
	[0][1][1][0][RTW89_FCC][104] = 60,
	[0][1][1][0][RTW89_FCC][105] = 60,
	[0][1][1][0][RTW89_FCC][107] = 60,
	[0][1][1][0][RTW89_FCC][109] = 60,
	[0][1][1][0][RTW89_FCC][111] = 127,
	[0][1][1][0][RTW89_FCC][113] = 127,
	[0][1][1][0][RTW89_FCC][115] = 127,
	[0][1][1][0][RTW89_FCC][117] = 127,
	[0][1][1][0][RTW89_FCC][119] = 127,
	[0][0][2][0][RTW89_FCC][0] = 72,
	[0][0][2][0][RTW89_FCC][2] = 72,
	[0][0][2][0][RTW89_FCC][4] = 72,
	[0][0][2][0][RTW89_FCC][6] = 72,
	[0][0][2][0][RTW89_FCC][8] = 72,
	[0][0][2][0][RTW89_FCC][10] = 72,
	[0][0][2][0][RTW89_FCC][12] = 72,
	[0][0][2][0][RTW89_FCC][14] = 72,
	[0][0][2][0][RTW89_FCC][15] = 72,
	[0][0][2][0][RTW89_FCC][17] = 72,
	[0][0][2][0][RTW89_FCC][19] = 72,
	[0][0][2][0][RTW89_FCC][21] = 72,
	[0][0][2][0][RTW89_FCC][23] = 72,
	[0][0][2][0][RTW89_FCC][25] = 72,
	[0][0][2][0][RTW89_FCC][27] = 72,
	[0][0][2][0][RTW89_FCC][29] = 72,
	[0][0][2][0][RTW89_FCC][30] = 72,
	[0][0][2][0][RTW89_FCC][32] = 72,
	[0][0][2][0][RTW89_FCC][34] = 72,
	[0][0][2][0][RTW89_FCC][36] = 72,
	[0][0][2][0][RTW89_FCC][38] = 72,
	[0][0][2][0][RTW89_FCC][40] = 72,
	[0][0][2][0][RTW89_FCC][42] = 72,
	[0][0][2][0][RTW89_FCC][44] = 72,
	[0][0][2][0][RTW89_FCC][45] = 72,
	[0][0][2][0][RTW89_FCC][47] = 72,
	[0][0][2][0][RTW89_FCC][49] = 72,
	[0][0][2][0][RTW89_FCC][51] = 72,
	[0][0][2][0][RTW89_FCC][53] = 72,
	[0][0][2][0][RTW89_FCC][55] = 72,
	[0][0][2][0][RTW89_FCC][57] = 72,
	[0][0][2][0][RTW89_FCC][59] = 72,
	[0][0][2][0][RTW89_FCC][60] = 72,
	[0][0][2][0][RTW89_FCC][62] = 72,
	[0][0][2][0][RTW89_FCC][64] = 72,
	[0][0][2][0][RTW89_FCC][66] = 72,
	[0][0][2][0][RTW89_FCC][68] = 72,
	[0][0][2][0][RTW89_FCC][70] = 72,
	[0][0][2][0][RTW89_FCC][72] = 72,
	[0][0][2][0][RTW89_FCC][74] = 72,
	[0][0][2][0][RTW89_FCC][75] = 72,
	[0][0][2][0][RTW89_FCC][77] = 72,
	[0][0][2][0][RTW89_FCC][79] = 72,
	[0][0][2][0][RTW89_FCC][81] = 72,
	[0][0][2][0][RTW89_FCC][83] = 72,
	[0][0][2][0][RTW89_FCC][85] = 72,
	[0][0][2][0][RTW89_FCC][87] = 72,
	[0][0][2][0][RTW89_FCC][89] = 72,
	[0][0][2][0][RTW89_FCC][90] = 72,
	[0][0][2][0][RTW89_FCC][92] = 72,
	[0][0][2][0][RTW89_FCC][94] = 72,
	[0][0][2][0][RTW89_FCC][96] = 72,
	[0][0][2][0][RTW89_FCC][98] = 72,
	[0][0][2][0][RTW89_FCC][100] = 72,
	[0][0][2][0][RTW89_FCC][102] = 72,
	[0][0][2][0][RTW89_FCC][104] = 72,
	[0][0][2][0][RTW89_FCC][105] = 72,
	[0][0][2][0][RTW89_FCC][107] = 72,
	[0][0][2][0][RTW89_FCC][109] = 72,
	[0][0][2][0][RTW89_FCC][111] = 127,
	[0][0][2][0][RTW89_FCC][113] = 127,
	[0][0][2][0][RTW89_FCC][115] = 127,
	[0][0][2][0][RTW89_FCC][117] = 127,
	[0][0][2][0][RTW89_FCC][119] = 127,
	[0][1][2][0][RTW89_FCC][0] = 60,
	[0][1][2][0][RTW89_FCC][2] = 60,
	[0][1][2][0][RTW89_FCC][4] = 60,
	[0][1][2][0][RTW89_FCC][6] = 60,
	[0][1][2][0][RTW89_FCC][8] = 60,
	[0][1][2][0][RTW89_FCC][10] = 60,
	[0][1][2][0][RTW89_FCC][12] = 60,
	[0][1][2][0][RTW89_FCC][14] = 60,
	[0][1][2][0][RTW89_FCC][15] = 60,
	[0][1][2][0][RTW89_FCC][17] = 60,
	[0][1][2][0][RTW89_FCC][19] = 60,
	[0][1][2][0][RTW89_FCC][21] = 60,
	[0][1][2][0][RTW89_FCC][23] = 60,
	[0][1][2][0][RTW89_FCC][25] = 60,
	[0][1][2][0][RTW89_FCC][27] = 60,
	[0][1][2][0][RTW89_FCC][29] = 60,
	[0][1][2][0][RTW89_FCC][30] = 60,
	[0][1][2][0][RTW89_FCC][32] = 60,
	[0][1][2][0][RTW89_FCC][34] = 60,
	[0][1][2][0][RTW89_FCC][36] = 60,
	[0][1][2][0][RTW89_FCC][38] = 60,
	[0][1][2][0][RTW89_FCC][40] = 60,
	[0][1][2][0][RTW89_FCC][42] = 60,
	[0][1][2][0][RTW89_FCC][44] = 60,
	[0][1][2][0][RTW89_FCC][45] = 60,
	[0][1][2][0][RTW89_FCC][47] = 60,
	[0][1][2][0][RTW89_FCC][49] = 60,
	[0][1][2][0][RTW89_FCC][51] = 60,
	[0][1][2][0][RTW89_FCC][53] = 60,
	[0][1][2][0][RTW89_FCC][55] = 60,
	[0][1][2][0][RTW89_FCC][57] = 60,
	[0][1][2][0][RTW89_FCC][59] = 60,
	[0][1][2][0][RTW89_FCC][60] = 60,
	[0][1][2][0][RTW89_FCC][62] = 60,
	[0][1][2][0][RTW89_FCC][64] = 60,
	[0][1][2][0][RTW89_FCC][66] = 60,
	[0][1][2][0][RTW89_FCC][68] = 60,
	[0][1][2][0][RTW89_FCC][70] = 60,
	[0][1][2][0][RTW89_FCC][72] = 60,
	[0][1][2][0][RTW89_FCC][74] = 60,
	[0][1][2][0][RTW89_FCC][75] = 60,
	[0][1][2][0][RTW89_FCC][77] = 60,
	[0][1][2][0][RTW89_FCC][79] = 60,
	[0][1][2][0][RTW89_FCC][81] = 60,
	[0][1][2][0][RTW89_FCC][83] = 60,
	[0][1][2][0][RTW89_FCC][85] = 60,
	[0][1][2][0][RTW89_FCC][87] = 60,
	[0][1][2][0][RTW89_FCC][89] = 60,
	[0][1][2][0][RTW89_FCC][90] = 60,
	[0][1][2][0][RTW89_FCC][92] = 60,
	[0][1][2][0][RTW89_FCC][94] = 60,
	[0][1][2][0][RTW89_FCC][96] = 60,
	[0][1][2][0][RTW89_FCC][98] = 60,
	[0][1][2][0][RTW89_FCC][100] = 60,
	[0][1][2][0][RTW89_FCC][102] = 60,
	[0][1][2][0][RTW89_FCC][104] = 60,
	[0][1][2][0][RTW89_FCC][105] = 60,
	[0][1][2][0][RTW89_FCC][107] = 60,
	[0][1][2][0][RTW89_FCC][109] = 60,
	[0][1][2][0][RTW89_FCC][111] = 127,
	[0][1][2][0][RTW89_FCC][113] = 127,
	[0][1][2][0][RTW89_FCC][115] = 127,
	[0][1][2][0][RTW89_FCC][117] = 127,
	[0][1][2][0][RTW89_FCC][119] = 127,
	[0][1][2][1][RTW89_FCC][0] = 48,
	[0][1][2][1][RTW89_FCC][2] = 48,
	[0][1][2][1][RTW89_FCC][4] = 48,
	[0][1][2][1][RTW89_FCC][6] = 48,
	[0][1][2][1][RTW89_FCC][8] = 48,
	[0][1][2][1][RTW89_FCC][10] = 48,
	[0][1][2][1][RTW89_FCC][12] = 48,
	[0][1][2][1][RTW89_FCC][14] = 48,
	[0][1][2][1][RTW89_FCC][15] = 48,
	[0][1][2][1][RTW89_FCC][17] = 48,
	[0][1][2][1][RTW89_FCC][19] = 48,
	[0][1][2][1][RTW89_FCC][21] = 48,
	[0][1][2][1][RTW89_FCC][23] = 48,
	[0][1][2][1][RTW89_FCC][25] = 48,
	[0][1][2][1][RTW89_FCC][27] = 48,
	[0][1][2][1][RTW89_FCC][29] = 48,
	[0][1][2][1][RTW89_FCC][30] = 48,
	[0][1][2][1][RTW89_FCC][32] = 48,
	[0][1][2][1][RTW89_FCC][34] = 48,
	[0][1][2][1][RTW89_FCC][36] = 48,
	[0][1][2][1][RTW89_FCC][38] = 48,
	[0][1][2][1][RTW89_FCC][40] = 48,
	[0][1][2][1][RTW89_FCC][42] = 48,
	[0][1][2][1][RTW89_FCC][44] = 48,
	[0][1][2][1][RTW89_FCC][45] = 48,
	[0][1][2][1][RTW89_FCC][47] = 48,
	[0][1][2][1][RTW89_FCC][49] = 48,
	[0][1][2][1][RTW89_FCC][51] = 48,
	[0][1][2][1][RTW89_FCC][53] = 48,
	[0][1][2][1][RTW89_FCC][55] = 48,
	[0][1][2][1][RTW89_FCC][57] = 48,
	[0][1][2][1][RTW89_FCC][59] = 48,
	[0][1][2][1][RTW89_FCC][60] = 48,
	[0][1][2][1][RTW89_FCC][62] = 48,
	[0][1][2][1][RTW89_FCC][64] = 48,
	[0][1][2][1][RTW89_FCC][66] = 48,
	[0][1][2][1][RTW89_FCC][68] = 48,
	[0][1][2][1][RTW89_FCC][70] = 48,
	[0][1][2][1][RTW89_FCC][72] = 48,
	[0][1][2][1][RTW89_FCC][74] = 48,
	[0][1][2][1][RTW89_FCC][75] = 48,
	[0][1][2][1][RTW89_FCC][77] = 48,
	[0][1][2][1][RTW89_FCC][79] = 48,
	[0][1][2][1][RTW89_FCC][81] = 48,
	[0][1][2][1][RTW89_FCC][83] = 48,
	[0][1][2][1][RTW89_FCC][85] = 48,
	[0][1][2][1][RTW89_FCC][87] = 48,
	[0][1][2][1][RTW89_FCC][89] = 48,
	[0][1][2][1][RTW89_FCC][90] = 48,
	[0][1][2][1][RTW89_FCC][92] = 48,
	[0][1][2][1][RTW89_FCC][94] = 48,
	[0][1][2][1][RTW89_FCC][96] = 48,
	[0][1][2][1][RTW89_FCC][98] = 48,
	[0][1][2][1][RTW89_FCC][100] = 48,
	[0][1][2][1][RTW89_FCC][102] = 48,
	[0][1][2][1][RTW89_FCC][104] = 48,
	[0][1][2][1][RTW89_FCC][105] = 48,
	[0][1][2][1][RTW89_FCC][107] = 48,
	[0][1][2][1][RTW89_FCC][109] = 48,
	[0][1][2][1][RTW89_FCC][111] = 127,
	[0][1][2][1][RTW89_FCC][113] = 127,
	[0][1][2][1][RTW89_FCC][115] = 127,
	[0][1][2][1][RTW89_FCC][117] = 127,
	[0][1][2][1][RTW89_FCC][119] = 127,
	[1][0][2][0][RTW89_FCC][1] = 72,
	[1][0][2][0][RTW89_FCC][5] = 72,
	[1][0][2][0][RTW89_FCC][9] = 72,
	[1][0][2][0][RTW89_FCC][13] = 72,
	[1][0][2][0][RTW89_FCC][16] = 72,
	[1][0][2][0][RTW89_FCC][20] = 72,
	[1][0][2][0][RTW89_FCC][24] = 72,
	[1][0][2][0][RTW89_FCC][28] = 72,
	[1][0][2][0][RTW89_FCC][31] = 72,
	[1][0][2][0][RTW89_FCC][35] = 72,
	[1][0][2][0][RTW89_FCC][39] = 72,
	[1][0][2][0][RTW89_FCC][43] = 72,
	[1][0][2][0][RTW89_FCC][46] = 72,
	[1][0][2][0][RTW89_FCC][50] = 72,
	[1][0][2][0][RTW89_FCC][54] = 72,
	[1][0][2][0][RTW89_FCC][58] = 72,
	[1][0][2][0][RTW89_FCC][61] = 72,
	[1][0][2][0][RTW89_FCC][65] = 72,
	[1][0][2][0][RTW89_FCC][69] = 72,
	[1][0][2][0][RTW89_FCC][73] = 72,
	[1][0][2][0][RTW89_FCC][76] = 72,
	[1][0][2][0][RTW89_FCC][80] = 72,
	[1][0][2][0][RTW89_FCC][84] = 72,
	[1][0][2][0][RTW89_FCC][88] = 72,
	[1][0][2][0][RTW89_FCC][91] = 72,
	[1][0][2][0][RTW89_FCC][95] = 72,
	[1][0][2][0][RTW89_FCC][99] = 72,
	[1][0][2][0][RTW89_FCC][103] = 72,
	[1][0][2][0][RTW89_FCC][106] = 72,
	[1][0][2][0][RTW89_FCC][110] = 127,
	[1][0][2][0][RTW89_FCC][114] = 127,
	[1][0][2][0][RTW89_FCC][118] = 127,
	[1][1][2][0][RTW89_FCC][1] = 60,
	[1][1][2][0][RTW89_FCC][5] = 60,
	[1][1][2][0][RTW89_FCC][9] = 60,
	[1][1][2][0][RTW89_FCC][13] = 60,
	[1][1][2][0][RTW89_FCC][16] = 60,
	[1][1][2][0][RTW89_FCC][20] = 60,
	[1][1][2][0][RTW89_FCC][24] = 60,
	[1][1][2][0][RTW89_FCC][28] = 60,
	[1][1][2][0][RTW89_FCC][31] = 60,
	[1][1][2][0][RTW89_FCC][35] = 60,
	[1][1][2][0][RTW89_FCC][39] = 60,
	[1][1][2][0][RTW89_FCC][43] = 60,
	[1][1][2][0][RTW89_FCC][46] = 60,
	[1][1][2][0][RTW89_FCC][50] = 60,
	[1][1][2][0][RTW89_FCC][54] = 60,
	[1][1][2][0][RTW89_FCC][58] = 60,
	[1][1][2][0][RTW89_FCC][61] = 60,
	[1][1][2][0][RTW89_FCC][65] = 60,
	[1][1][2][0][RTW89_FCC][69] = 60,
	[1][1][2][0][RTW89_FCC][73] = 60,
	[1][1][2][0][RTW89_FCC][76] = 60,
	[1][1][2][0][RTW89_FCC][80] = 60,
	[1][1][2][0][RTW89_FCC][84] = 60,
	[1][1][2][0][RTW89_FCC][88] = 60,
	[1][1][2][0][RTW89_FCC][91] = 60,
	[1][1][2][0][RTW89_FCC][95] = 60,
	[1][1][2][0][RTW89_FCC][99] = 60,
	[1][1][2][0][RTW89_FCC][103] = 60,
	[1][1][2][0][RTW89_FCC][106] = 60,
	[1][1][2][0][RTW89_FCC][110] = 127,
	[1][1][2][0][RTW89_FCC][114] = 127,
	[1][1][2][0][RTW89_FCC][118] = 127,
	[1][1][2][1][RTW89_FCC][1] = 48,
	[1][1][2][1][RTW89_FCC][5] = 48,
	[1][1][2][1][RTW89_FCC][9] = 48,
	[1][1][2][1][RTW89_FCC][13] = 48,
	[1][1][2][1][RTW89_FCC][16] = 48,
	[1][1][2][1][RTW89_FCC][20] = 48,
	[1][1][2][1][RTW89_FCC][24] = 48,
	[1][1][2][1][RTW89_FCC][28] = 48,
	[1][1][2][1][RTW89_FCC][31] = 48,
	[1][1][2][1][RTW89_FCC][35] = 48,
	[1][1][2][1][RTW89_FCC][39] = 48,
	[1][1][2][1][RTW89_FCC][43] = 48,
	[1][1][2][1][RTW89_FCC][46] = 48,
	[1][1][2][1][RTW89_FCC][50] = 48,
	[1][1][2][1][RTW89_FCC][54] = 48,
	[1][1][2][1][RTW89_FCC][58] = 48,
	[1][1][2][1][RTW89_FCC][61] = 48,
	[1][1][2][1][RTW89_FCC][65] = 48,
	[1][1][2][1][RTW89_FCC][69] = 48,
	[1][1][2][1][RTW89_FCC][73] = 48,
	[1][1][2][1][RTW89_FCC][76] = 48,
	[1][1][2][1][RTW89_FCC][80] = 48,
	[1][1][2][1][RTW89_FCC][84] = 48,
	[1][1][2][1][RTW89_FCC][88] = 48,
	[1][1][2][1][RTW89_FCC][91] = 48,
	[1][1][2][1][RTW89_FCC][95] = 48,
	[1][1][2][1][RTW89_FCC][99] = 48,
	[1][1][2][1][RTW89_FCC][103] = 48,
	[1][1][2][1][RTW89_FCC][106] = 48,
	[1][1][2][1][RTW89_FCC][110] = 127,
	[1][1][2][1][RTW89_FCC][114] = 127,
	[1][1][2][1][RTW89_FCC][118] = 127,
	[2][0][2][0][RTW89_FCC][3] = 64,
	[2][0][2][0][RTW89_FCC][11] = 64,
	[2][0][2][0][RTW89_FCC][18] = 64,
	[2][0][2][0][RTW89_FCC][26] = 64,
	[2][0][2][0][RTW89_FCC][33] = 64,
	[2][0][2][0][RTW89_FCC][41] = 64,
	[2][0][2][0][RTW89_FCC][48] = 64,
	[2][0][2][0][RTW89_FCC][56] = 64,
	[2][0][2][0][RTW89_FCC][63] = 64,
	[2][0][2][0][RTW89_FCC][71] = 64,
	[2][0][2][0][RTW89_FCC][78] = 64,
	[2][0][2][0][RTW89_FCC][86] = 64,
	[2][0][2][0][RTW89_FCC][93] = 64,
	[2][0][2][0][RTW89_FCC][101] = 64,
	[2][0][2][0][RTW89_FCC][108] = 127,
	[2][0][2][0][RTW89_FCC][116] = 127,
	[2][1][2][0][RTW89_FCC][3] = 52,
	[2][1][2][0][RTW89_FCC][11] = 52,
	[2][1][2][0][RTW89_FCC][18] = 52,
	[2][1][2][0][RTW89_FCC][26] = 52,
	[2][1][2][0][RTW89_FCC][33] = 52,
	[2][1][2][0][RTW89_FCC][41] = 52,
	[2][1][2][0][RTW89_FCC][48] = 52,
	[2][1][2][0][RTW89_FCC][56] = 52,
	[2][1][2][0][RTW89_FCC][63] = 52,
	[2][1][2][0][RTW89_FCC][71] = 52,
	[2][1][2][0][RTW89_FCC][78] = 52,
	[2][1][2][0][RTW89_FCC][86] = 52,
	[2][1][2][0][RTW89_FCC][93] = 52,
	[2][1][2][0][RTW89_FCC][101] = 52,
	[2][1][2][0][RTW89_FCC][108] = 127,
	[2][1][2][0][RTW89_FCC][116] = 127,
	[2][1][2][1][RTW89_FCC][3] = 40,
	[2][1][2][1][RTW89_FCC][11] = 40,
	[2][1][2][1][RTW89_FCC][18] = 40,
	[2][1][2][1][RTW89_FCC][26] = 40,
	[2][1][2][1][RTW89_FCC][33] = 40,
	[2][1][2][1][RTW89_FCC][41] = 40,
	[2][1][2][1][RTW89_FCC][48] = 40,
	[2][1][2][1][RTW89_FCC][56] = 40,
	[2][1][2][1][RTW89_FCC][63] = 40,
	[2][1][2][1][RTW89_FCC][71] = 40,
	[2][1][2][1][RTW89_FCC][78] = 40,
	[2][1][2][1][RTW89_FCC][86] = 40,
	[2][1][2][1][RTW89_FCC][93] = 40,
	[2][1][2][1][RTW89_FCC][101] = 40,
	[2][1][2][1][RTW89_FCC][108] = 127,
	[2][1][2][1][RTW89_FCC][116] = 127,
	[3][0][2][0][RTW89_FCC][7] = 56,
	[3][0][2][0][RTW89_FCC][22] = 56,
	[3][0][2][0][RTW89_FCC][37] = 56,
	[3][0][2][0][RTW89_FCC][52] = 56,
	[3][0][2][0][RTW89_FCC][67] = 56,
	[3][0][2][0][RTW89_FCC][82] = 56,
	[3][0][2][0][RTW89_FCC][97] = 56,
	[3][0][2][0][RTW89_FCC][112] = 127,
	[3][1][2][0][RTW89_FCC][7] = 44,
	[3][1][2][0][RTW89_FCC][22] = 44,
	[3][1][2][0][RTW89_FCC][37] = 44,
	[3][1][2][0][RTW89_FCC][52] = 44,
	[3][1][2][0][RTW89_FCC][67] = 44,
	[3][1][2][0][RTW89_FCC][82] = 44,
	[3][1][2][0][RTW89_FCC][97] = 44,
	[3][1][2][0][RTW89_FCC][112] = 127,
	[3][1][2][1][RTW89_FCC][7] = 32,
	[3][1][2][1][RTW89_FCC][22] = 32,
	[3][1][2][1][RTW89_FCC][37] = 32,
	[3][1][2][1][RTW89_FCC][52] = 32,
	[3][1][2][1][RTW89_FCC][67] = 32,
	[3][1][2][1][RTW89_FCC][82] = 32,
	[3][1][2][1][RTW89_FCC][97] = 32,
	[3][1][2][1][RTW89_FCC][112] = 127,
};

const s8 rtw89_8852c_txpwr_lmt_ru_2g[RTW89_RU_NUM][RTW89_NTX_NUM]
				    [RTW89_REGD_NUM][RTW89_2G_CH_NUM] = {
	[0][0][RTW89_WW][0] = 32,
	[0][0][RTW89_WW][1] = 32,
	[0][0][RTW89_WW][2] = 32,
	[0][0][RTW89_WW][3] = 32,
	[0][0][RTW89_WW][4] = 32,
	[0][0][RTW89_WW][5] = 32,
	[0][0][RTW89_WW][6] = 32,
	[0][0][RTW89_WW][7] = 32,
	[0][0][RTW89_WW][8] = 32,
	[0][0][RTW89_WW][9] = 32,
	[0][0][RTW89_WW][10] = 32,
	[0][0][RTW89_WW][11] = 32,
	[0][0][RTW89_WW][12] = 24,
	[0][0][RTW89_WW][13] = 0,
	[0][1][RTW89_WW][0] = 20,
	[0][1][RTW89_WW][1] = 22,
	[0][1][RTW89_WW][2] = 22,
	[0][1][RTW89_WW][3] = 22,
	[0][1][RTW89_WW][4] = 22,
	[0][1][RTW89_WW][5] = 22,
	[0][1][RTW89_WW][6] = 22,
	[0][1][RTW89_WW][7] = 22,
	[0][1][RTW89_WW][8] = 22,
	[0][1][RTW89_WW][9] = 22,
	[0][1][RTW89_WW][10] = 22,
	[0][1][RTW89_WW][11] = 22,
	[0][1][RTW89_WW][12] = 20,
	[0][1][RTW89_WW][13] = 0,
	[1][0][RTW89_WW][0] = 42,
	[1][0][RTW89_WW][1] = 44,
	[1][0][RTW89_WW][2] = 44,
	[1][0][RTW89_WW][3] = 44,
	[1][0][RTW89_WW][4] = 44,
	[1][0][RTW89_WW][5] = 44,
	[1][0][RTW89_WW][6] = 44,
	[1][0][RTW89_WW][7] = 44,
	[1][0][RTW89_WW][8] = 44,
	[1][0][RTW89_WW][9] = 44,
	[1][0][RTW89_WW][10] = 44,
	[1][0][RTW89_WW][11] = 42,
	[1][0][RTW89_WW][12] = 30,
	[1][0][RTW89_WW][13] = 0,
	[1][1][RTW89_WW][0] = 32,
	[1][1][RTW89_WW][1] = 32,
	[1][1][RTW89_WW][2] = 32,
	[1][1][RTW89_WW][3] = 32,
	[1][1][RTW89_WW][4] = 32,
	[1][1][RTW89_WW][5] = 32,
	[1][1][RTW89_WW][6] = 32,
	[1][1][RTW89_WW][7] = 32,
	[1][1][RTW89_WW][8] = 32,
	[1][1][RTW89_WW][9] = 32,
	[1][1][RTW89_WW][10] = 32,
	[1][1][RTW89_WW][11] = 30,
	[1][1][RTW89_WW][12] = 24,
	[1][1][RTW89_WW][13] = 0,
	[2][0][RTW89_WW][0] = 56,
	[2][0][RTW89_WW][1] = 56,
	[2][0][RTW89_WW][2] = 56,
	[2][0][RTW89_WW][3] = 56,
	[2][0][RTW89_WW][4] = 56,
	[2][0][RTW89_WW][5] = 56,
	[2][0][RTW89_WW][6] = 56,
	[2][0][RTW89_WW][7] = 56,
	[2][0][RTW89_WW][8] = 56,
	[2][0][RTW89_WW][9] = 56,
	[2][0][RTW89_WW][10] = 56,
	[2][0][RTW89_WW][11] = 42,
	[2][0][RTW89_WW][12] = 38,
	[2][0][RTW89_WW][13] = 0,
	[2][1][RTW89_WW][0] = 44,
	[2][1][RTW89_WW][1] = 44,
	[2][1][RTW89_WW][2] = 44,
	[2][1][RTW89_WW][3] = 44,
	[2][1][RTW89_WW][4] = 44,
	[2][1][RTW89_WW][5] = 44,
	[2][1][RTW89_WW][6] = 44,
	[2][1][RTW89_WW][7] = 44,
	[2][1][RTW89_WW][8] = 44,
	[2][1][RTW89_WW][9] = 44,
	[2][1][RTW89_WW][10] = 44,
	[2][1][RTW89_WW][11] = 30,
	[2][1][RTW89_WW][12] = 26,
	[2][1][RTW89_WW][13] = 0,
	[0][0][RTW89_FCC][0] = 60,
	[0][0][RTW89_ETSI][0] = 34,
	[0][0][RTW89_MKK][0] = 36,
	[0][0][RTW89_IC][0] = 68,
	[0][0][RTW89_ACMA][0] = 32,
	[0][0][RTW89_FCC][1] = 60,
	[0][0][RTW89_ETSI][1] = 38,
	[0][0][RTW89_MKK][1] = 40,
	[0][0][RTW89_IC][1] = 68,
	[0][0][RTW89_ACMA][1] = 32,
	[0][0][RTW89_FCC][2] = 64,
	[0][0][RTW89_ETSI][2] = 38,
	[0][0][RTW89_MKK][2] = 40,
	[0][0][RTW89_IC][2] = 72,
	[0][0][RTW89_ACMA][2] = 32,
	[0][0][RTW89_FCC][3] = 68,
	[0][0][RTW89_ETSI][3] = 38,
	[0][0][RTW89_MKK][3] = 40,
	[0][0][RTW89_IC][3] = 76,
	[0][0][RTW89_ACMA][3] = 32,
	[0][0][RTW89_FCC][4] = 68,
	[0][0][RTW89_ETSI][4] = 38,
	[0][0][RTW89_MKK][4] = 40,
	[0][0][RTW89_IC][4] = 76,
	[0][0][RTW89_ACMA][4] = 32,
	[0][0][RTW89_FCC][5] = 76,
	[0][0][RTW89_ETSI][5] = 38,
	[0][0][RTW89_MKK][5] = 40,
	[0][0][RTW89_IC][5] = 84,
	[0][0][RTW89_ACMA][5] = 32,
	[0][0][RTW89_FCC][6] = 66,
	[0][0][RTW89_ETSI][6] = 38,
	[0][0][RTW89_MKK][6] = 40,
	[0][0][RTW89_IC][6] = 74,
	[0][0][RTW89_ACMA][6] = 32,
	[0][0][RTW89_FCC][7] = 66,
	[0][0][RTW89_ETSI][7] = 38,
	[0][0][RTW89_MKK][7] = 40,
	[0][0][RTW89_IC][7] = 74,
	[0][0][RTW89_ACMA][7] = 32,
	[0][0][RTW89_FCC][8] = 62,
	[0][0][RTW89_ETSI][8] = 38,
	[0][0][RTW89_MKK][8] = 40,
	[0][0][RTW89_IC][8] = 70,
	[0][0][RTW89_ACMA][8] = 32,
	[0][0][RTW89_FCC][9] = 58,
	[0][0][RTW89_ETSI][9] = 38,
	[0][0][RTW89_MKK][9] = 40,
	[0][0][RTW89_IC][9] = 66,
	[0][0][RTW89_ACMA][9] = 32,
	[0][0][RTW89_FCC][10] = 58,
	[0][0][RTW89_ETSI][10] = 38,
	[0][0][RTW89_MKK][10] = 40,
	[0][0][RTW89_IC][10] = 66,
	[0][0][RTW89_ACMA][10] = 32,
	[0][0][RTW89_FCC][11] = 42,
	[0][0][RTW89_ETSI][11] = 38,
	[0][0][RTW89_MKK][11] = 40,
	[0][0][RTW89_IC][11] = 56,
	[0][0][RTW89_ACMA][11] = 32,
	[0][0][RTW89_FCC][12] = 24,
	[0][0][RTW89_ETSI][12] = 34,
	[0][0][RTW89_MKK][12] = 36,
	[0][0][RTW89_IC][12] = 32,
	[0][0][RTW89_ACMA][12] = 32,
	[0][0][RTW89_FCC][13] = 127,
	[0][0][RTW89_ETSI][13] = 127,
	[0][0][RTW89_MKK][13] = 127,
	[0][0][RTW89_IC][13] = 127,
	[0][0][RTW89_ACMA][13] = 127,
	[0][1][RTW89_FCC][0] = 46,
	[0][1][RTW89_ETSI][0] = 22,
	[0][1][RTW89_MKK][0] = 24,
	[0][1][RTW89_IC][0] = 62,
	[0][1][RTW89_ACMA][0] = 20,
	[0][1][RTW89_FCC][1] = 46,
	[0][1][RTW89_ETSI][1] = 24,
	[0][1][RTW89_MKK][1] = 30,
	[0][1][RTW89_IC][1] = 62,
	[0][1][RTW89_ACMA][1] = 22,
	[0][1][RTW89_FCC][2] = 50,
	[0][1][RTW89_ETSI][2] = 24,
	[0][1][RTW89_MKK][2] = 30,
	[0][1][RTW89_IC][2] = 66,
	[0][1][RTW89_ACMA][2] = 22,
	[0][1][RTW89_FCC][3] = 54,
	[0][1][RTW89_ETSI][3] = 24,
	[0][1][RTW89_MKK][3] = 30,
	[0][1][RTW89_IC][3] = 70,
	[0][1][RTW89_ACMA][3] = 22,
	[0][1][RTW89_FCC][4] = 58,
	[0][1][RTW89_ETSI][4] = 24,
	[0][1][RTW89_MKK][4] = 30,
	[0][1][RTW89_IC][4] = 74,
	[0][1][RTW89_ACMA][4] = 22,
	[0][1][RTW89_FCC][5] = 66,
	[0][1][RTW89_ETSI][5] = 24,
	[0][1][RTW89_MKK][5] = 30,
	[0][1][RTW89_IC][5] = 74,
	[0][1][RTW89_ACMA][5] = 22,
	[0][1][RTW89_FCC][6] = 58,
	[0][1][RTW89_ETSI][6] = 24,
	[0][1][RTW89_MKK][6] = 30,
	[0][1][RTW89_IC][6] = 72,
	[0][1][RTW89_ACMA][6] = 22,
	[0][1][RTW89_FCC][7] = 54,
	[0][1][RTW89_ETSI][7] = 24,
	[0][1][RTW89_MKK][7] = 30,
	[0][1][RTW89_IC][7] = 68,
	[0][1][RTW89_ACMA][7] = 22,
	[0][1][RTW89_FCC][8] = 50,
	[0][1][RTW89_ETSI][8] = 24,
	[0][1][RTW89_MKK][8] = 30,
	[0][1][RTW89_IC][8] = 64,
	[0][1][RTW89_ACMA][8] = 22,
	[0][1][RTW89_FCC][9] = 46,
	[0][1][RTW89_ETSI][9] = 24,
	[0][1][RTW89_MKK][9] = 30,
	[0][1][RTW89_IC][9] = 60,
	[0][1][RTW89_ACMA][9] = 22,
	[0][1][RTW89_FCC][10] = 46,
	[0][1][RTW89_ETSI][10] = 24,
	[0][1][RTW89_MKK][10] = 30,
	[0][1][RTW89_IC][10] = 60,
	[0][1][RTW89_ACMA][10] = 22,
	[0][1][RTW89_FCC][11] = 30,
	[0][1][RTW89_ETSI][11] = 24,
	[0][1][RTW89_MKK][11] = 30,
	[0][1][RTW89_IC][11] = 52,
	[0][1][RTW89_ACMA][11] = 22,
	[0][1][RTW89_FCC][12] = 22,
	[0][1][RTW89_ETSI][12] = 20,
	[0][1][RTW89_MKK][12] = 24,
	[0][1][RTW89_IC][12] = 30,
	[0][1][RTW89_ACMA][12] = 20,
	[0][1][RTW89_FCC][13] = 127,
	[0][1][RTW89_ETSI][13] = 127,
	[0][1][RTW89_MKK][13] = 127,
	[0][1][RTW89_IC][13] = 127,
	[0][1][RTW89_ACMA][13] = 127,
	[1][0][RTW89_FCC][0] = 64,
	[1][0][RTW89_ETSI][0] = 46,
	[1][0][RTW89_MKK][0] = 48,
	[1][0][RTW89_IC][0] = 78,
	[1][0][RTW89_ACMA][0] = 42,
	[1][0][RTW89_FCC][1] = 64,
	[1][0][RTW89_ETSI][1] = 46,
	[1][0][RTW89_MKK][1] = 48,
	[1][0][RTW89_IC][1] = 78,
	[1][0][RTW89_ACMA][1] = 44,
	[1][0][RTW89_FCC][2] = 68,
	[1][0][RTW89_ETSI][2] = 46,
	[1][0][RTW89_MKK][2] = 48,
	[1][0][RTW89_IC][2] = 82,
	[1][0][RTW89_ACMA][2] = 44,
	[1][0][RTW89_FCC][3] = 70,
	[1][0][RTW89_ETSI][3] = 46,
	[1][0][RTW89_MKK][3] = 48,
	[1][0][RTW89_IC][3] = 84,
	[1][0][RTW89_ACMA][3] = 44,
	[1][0][RTW89_FCC][4] = 70,
	[1][0][RTW89_ETSI][4] = 46,
	[1][0][RTW89_MKK][4] = 48,
	[1][0][RTW89_IC][4] = 84,
	[1][0][RTW89_ACMA][4] = 44,
	[1][0][RTW89_FCC][5] = 76,
	[1][0][RTW89_ETSI][5] = 46,
	[1][0][RTW89_MKK][5] = 48,
	[1][0][RTW89_IC][5] = 84,
	[1][0][RTW89_ACMA][5] = 44,
	[1][0][RTW89_FCC][6] = 64,
	[1][0][RTW89_ETSI][6] = 44,
	[1][0][RTW89_MKK][6] = 48,
	[1][0][RTW89_IC][6] = 78,
	[1][0][RTW89_ACMA][6] = 44,
	[1][0][RTW89_FCC][7] = 64,
	[1][0][RTW89_ETSI][7] = 46,
	[1][0][RTW89_MKK][7] = 48,
	[1][0][RTW89_IC][7] = 78,
	[1][0][RTW89_ACMA][7] = 44,
	[1][0][RTW89_FCC][8] = 64,
	[1][0][RTW89_ETSI][8] = 46,
	[1][0][RTW89_MKK][8] = 48,
	[1][0][RTW89_IC][8] = 78,
	[1][0][RTW89_ACMA][8] = 44,
	[1][0][RTW89_FCC][9] = 60,
	[1][0][RTW89_ETSI][9] = 46,
	[1][0][RTW89_MKK][9] = 48,
	[1][0][RTW89_IC][9] = 74,
	[1][0][RTW89_ACMA][9] = 44,
	[1][0][RTW89_FCC][10] = 60,
	[1][0][RTW89_ETSI][10] = 46,
	[1][0][RTW89_MKK][10] = 48,
	[1][0][RTW89_IC][10] = 74,
	[1][0][RTW89_ACMA][10] = 44,
	[1][0][RTW89_FCC][11] = 42,
	[1][0][RTW89_ETSI][11] = 46,
	[1][0][RTW89_MKK][11] = 48,
	[1][0][RTW89_IC][11] = 72,
	[1][0][RTW89_ACMA][11] = 44,
	[1][0][RTW89_FCC][12] = 30,
	[1][0][RTW89_ETSI][12] = 46,
	[1][0][RTW89_MKK][12] = 46,
	[1][0][RTW89_IC][12] = 38,
	[1][0][RTW89_ACMA][12] = 42,
	[1][0][RTW89_FCC][13] = 127,
	[1][0][RTW89_ETSI][13] = 127,
	[1][0][RTW89_MKK][13] = 127,
	[1][0][RTW89_IC][13] = 127,
	[1][0][RTW89_ACMA][13] = 127,
	[1][1][RTW89_FCC][0] = 46,
	[1][1][RTW89_ETSI][0] = 32,
	[1][1][RTW89_MKK][0] = 34,
	[1][1][RTW89_IC][0] = 66,
	[1][1][RTW89_ACMA][0] = 32,
	[1][1][RTW89_FCC][1] = 46,
	[1][1][RTW89_ETSI][1] = 34,
	[1][1][RTW89_MKK][1] = 34,
	[1][1][RTW89_IC][1] = 66,
	[1][1][RTW89_ACMA][1] = 32,
	[1][1][RTW89_FCC][2] = 50,
	[1][1][RTW89_ETSI][2] = 34,
	[1][1][RTW89_MKK][2] = 34,
	[1][1][RTW89_IC][2] = 70,
	[1][1][RTW89_ACMA][2] = 32,
	[1][1][RTW89_FCC][3] = 54,
	[1][1][RTW89_ETSI][3] = 34,
	[1][1][RTW89_MKK][3] = 34,
	[1][1][RTW89_IC][3] = 74,
	[1][1][RTW89_ACMA][3] = 32,
	[1][1][RTW89_FCC][4] = 58,
	[1][1][RTW89_ETSI][4] = 34,
	[1][1][RTW89_MKK][4] = 34,
	[1][1][RTW89_IC][4] = 74,
	[1][1][RTW89_ACMA][4] = 32,
	[1][1][RTW89_FCC][5] = 66,
	[1][1][RTW89_ETSI][5] = 34,
	[1][1][RTW89_MKK][5] = 34,
	[1][1][RTW89_IC][5] = 74,
	[1][1][RTW89_ACMA][5] = 32,
	[1][1][RTW89_FCC][6] = 58,
	[1][1][RTW89_ETSI][6] = 34,
	[1][1][RTW89_MKK][6] = 34,
	[1][1][RTW89_IC][6] = 74,
	[1][1][RTW89_ACMA][6] = 32,
	[1][1][RTW89_FCC][7] = 54,
	[1][1][RTW89_ETSI][7] = 34,
	[1][1][RTW89_MKK][7] = 34,
	[1][1][RTW89_IC][7] = 74,
	[1][1][RTW89_ACMA][7] = 32,
	[1][1][RTW89_FCC][8] = 50,
	[1][1][RTW89_ETSI][8] = 34,
	[1][1][RTW89_MKK][8] = 34,
	[1][1][RTW89_IC][8] = 70,
	[1][1][RTW89_ACMA][8] = 32,
	[1][1][RTW89_FCC][9] = 46,
	[1][1][RTW89_ETSI][9] = 34,
	[1][1][RTW89_MKK][9] = 34,
	[1][1][RTW89_IC][9] = 66,
	[1][1][RTW89_ACMA][9] = 32,
	[1][1][RTW89_FCC][10] = 46,
	[1][1][RTW89_ETSI][10] = 34,
	[1][1][RTW89_MKK][10] = 34,
	[1][1][RTW89_IC][10] = 66,
	[1][1][RTW89_ACMA][10] = 32,
	[1][1][RTW89_FCC][11] = 30,
	[1][1][RTW89_ETSI][11] = 34,
	[1][1][RTW89_MKK][11] = 34,
	[1][1][RTW89_IC][11] = 48,
	[1][1][RTW89_ACMA][11] = 32,
	[1][1][RTW89_FCC][12] = 24,
	[1][1][RTW89_ETSI][12] = 34,
	[1][1][RTW89_MKK][12] = 34,
	[1][1][RTW89_IC][12] = 32,
	[1][1][RTW89_ACMA][12] = 32,
	[1][1][RTW89_FCC][13] = 127,
	[1][1][RTW89_ETSI][13] = 127,
	[1][1][RTW89_MKK][13] = 127,
	[1][1][RTW89_IC][13] = 127,
	[1][1][RTW89_ACMA][13] = 127,
	[2][0][RTW89_FCC][0] = 64,
	[2][0][RTW89_ETSI][0] = 58,
	[2][0][RTW89_MKK][0] = 58,
	[2][0][RTW89_IC][0] = 78,
	[2][0][RTW89_ACMA][0] = 56,
	[2][0][RTW89_FCC][1] = 64,
	[2][0][RTW89_ETSI][1] = 58,
	[2][0][RTW89_MKK][1] = 58,
	[2][0][RTW89_IC][1] = 78,
	[2][0][RTW89_ACMA][1] = 56,
	[2][0][RTW89_FCC][2] = 66,
	[2][0][RTW89_ETSI][2] = 58,
	[2][0][RTW89_MKK][2] = 58,
	[2][0][RTW89_IC][2] = 80,
	[2][0][RTW89_ACMA][2] = 56,
	[2][0][RTW89_FCC][3] = 66,
	[2][0][RTW89_ETSI][3] = 58,
	[2][0][RTW89_MKK][3] = 58,
	[2][0][RTW89_IC][3] = 80,
	[2][0][RTW89_ACMA][3] = 56,
	[2][0][RTW89_FCC][4] = 66,
	[2][0][RTW89_ETSI][4] = 58,
	[2][0][RTW89_MKK][4] = 58,
	[2][0][RTW89_IC][4] = 80,
	[2][0][RTW89_ACMA][4] = 56,
	[2][0][RTW89_FCC][5] = 76,
	[2][0][RTW89_ETSI][5] = 58,
	[2][0][RTW89_MKK][5] = 58,
	[2][0][RTW89_IC][5] = 84,
	[2][0][RTW89_ACMA][5] = 56,
	[2][0][RTW89_FCC][6] = 62,
	[2][0][RTW89_ETSI][6] = 56,
	[2][0][RTW89_MKK][6] = 58,
	[2][0][RTW89_IC][6] = 76,
	[2][0][RTW89_ACMA][6] = 56,
	[2][0][RTW89_FCC][7] = 62,
	[2][0][RTW89_ETSI][7] = 58,
	[2][0][RTW89_MKK][7] = 58,
	[2][0][RTW89_IC][7] = 76,
	[2][0][RTW89_ACMA][7] = 56,
	[2][0][RTW89_FCC][8] = 62,
	[2][0][RTW89_ETSI][8] = 58,
	[2][0][RTW89_MKK][8] = 58,
	[2][0][RTW89_IC][8] = 76,
	[2][0][RTW89_ACMA][8] = 56,
	[2][0][RTW89_FCC][9] = 60,
	[2][0][RTW89_ETSI][9] = 58,
	[2][0][RTW89_MKK][9] = 58,
	[2][0][RTW89_IC][9] = 74,
	[2][0][RTW89_ACMA][9] = 56,
	[2][0][RTW89_FCC][10] = 60,
	[2][0][RTW89_ETSI][10] = 58,
	[2][0][RTW89_MKK][10] = 58,
	[2][0][RTW89_IC][10] = 74,
	[2][0][RTW89_ACMA][10] = 56,
	[2][0][RTW89_FCC][11] = 42,
	[2][0][RTW89_ETSI][11] = 58,
	[2][0][RTW89_MKK][11] = 58,
	[2][0][RTW89_IC][11] = 66,
	[2][0][RTW89_ACMA][11] = 56,
	[2][0][RTW89_FCC][12] = 38,
	[2][0][RTW89_ETSI][12] = 58,
	[2][0][RTW89_MKK][12] = 58,
	[2][0][RTW89_IC][12] = 56,
	[2][0][RTW89_ACMA][12] = 56,
	[2][0][RTW89_FCC][13] = 127,
	[2][0][RTW89_ETSI][13] = 127,
	[2][0][RTW89_MKK][13] = 127,
	[2][0][RTW89_IC][13] = 127,
	[2][0][RTW89_ACMA][13] = 127,
	[2][1][RTW89_FCC][0] = 46,
	[2][1][RTW89_ETSI][0] = 46,
	[2][1][RTW89_MKK][0] = 46,
	[2][1][RTW89_IC][0] = 70,
	[2][1][RTW89_ACMA][0] = 44,
	[2][1][RTW89_FCC][1] = 46,
	[2][1][RTW89_ETSI][1] = 46,
	[2][1][RTW89_MKK][1] = 46,
	[2][1][RTW89_IC][1] = 70,
	[2][1][RTW89_ACMA][1] = 44,
	[2][1][RTW89_FCC][2] = 50,
	[2][1][RTW89_ETSI][2] = 46,
	[2][1][RTW89_MKK][2] = 46,
	[2][1][RTW89_IC][2] = 74,
	[2][1][RTW89_ACMA][2] = 44,
	[2][1][RTW89_FCC][3] = 54,
	[2][1][RTW89_ETSI][3] = 46,
	[2][1][RTW89_MKK][3] = 46,
	[2][1][RTW89_IC][3] = 78,
	[2][1][RTW89_ACMA][3] = 44,
	[2][1][RTW89_FCC][4] = 56,
	[2][1][RTW89_ETSI][4] = 46,
	[2][1][RTW89_MKK][4] = 46,
	[2][1][RTW89_IC][4] = 80,
	[2][1][RTW89_ACMA][4] = 44,
	[2][1][RTW89_FCC][5] = 72,
	[2][1][RTW89_ETSI][5] = 46,
	[2][1][RTW89_MKK][5] = 46,
	[2][1][RTW89_IC][5] = 80,
	[2][1][RTW89_ACMA][5] = 44,
	[2][1][RTW89_FCC][6] = 54,
	[2][1][RTW89_ETSI][6] = 44,
	[2][1][RTW89_MKK][6] = 46,
	[2][1][RTW89_IC][6] = 78,
	[2][1][RTW89_ACMA][6] = 44,
	[2][1][RTW89_FCC][7] = 54,
	[2][1][RTW89_ETSI][7] = 46,
	[2][1][RTW89_MKK][7] = 46,
	[2][1][RTW89_IC][7] = 78,
	[2][1][RTW89_ACMA][7] = 44,
	[2][1][RTW89_FCC][8] = 50,
	[2][1][RTW89_ETSI][8] = 46,
	[2][1][RTW89_MKK][8] = 46,
	[2][1][RTW89_IC][8] = 74,
	[2][1][RTW89_ACMA][8] = 44,
	[2][1][RTW89_FCC][9] = 46,
	[2][1][RTW89_ETSI][9] = 46,
	[2][1][RTW89_MKK][9] = 46,
	[2][1][RTW89_IC][9] = 70,
	[2][1][RTW89_ACMA][9] = 44,
	[2][1][RTW89_FCC][10] = 46,
	[2][1][RTW89_ETSI][10] = 46,
	[2][1][RTW89_MKK][10] = 46,
	[2][1][RTW89_IC][10] = 70,
	[2][1][RTW89_ACMA][10] = 44,
	[2][1][RTW89_FCC][11] = 30,
	[2][1][RTW89_ETSI][11] = 46,
	[2][1][RTW89_MKK][11] = 46,
	[2][1][RTW89_IC][11] = 60,
	[2][1][RTW89_ACMA][11] = 44,
	[2][1][RTW89_FCC][12] = 26,
	[2][1][RTW89_ETSI][12] = 44,
	[2][1][RTW89_MKK][12] = 46,
	[2][1][RTW89_IC][12] = 44,
	[2][1][RTW89_ACMA][12] = 42,
	[2][1][RTW89_FCC][13] = 127,
	[2][1][RTW89_ETSI][13] = 127,
	[2][1][RTW89_MKK][13] = 127,
	[2][1][RTW89_IC][13] = 127,
	[2][1][RTW89_ACMA][13] = 127,
};

const s8 rtw89_8852c_txpwr_lmt_ru_5g[RTW89_RU_NUM][RTW89_NTX_NUM]
				    [RTW89_REGD_NUM][RTW89_5G_CH_NUM] = {
	[0][0][RTW89_WW][0] = 24,
	[0][0][RTW89_WW][2] = 24,
	[0][0][RTW89_WW][4] = 22,
	[0][0][RTW89_WW][6] = 22,
	[0][0][RTW89_WW][8] = 18,
	[0][0][RTW89_WW][10] = 18,
	[0][0][RTW89_WW][12] = 24,
	[0][0][RTW89_WW][14] = 24,
	[0][0][RTW89_WW][15] = 24,
	[0][0][RTW89_WW][17] = 24,
	[0][0][RTW89_WW][19] = 24,
	[0][0][RTW89_WW][21] = 24,
	[0][0][RTW89_WW][23] = 24,
	[0][0][RTW89_WW][25] = 30,
	[0][0][RTW89_WW][27] = 30,
	[0][0][RTW89_WW][29] = 30,
	[0][0][RTW89_WW][31] = 24,
	[0][0][RTW89_WW][33] = 24,
	[0][0][RTW89_WW][35] = 24,
	[0][0][RTW89_WW][37] = 44,
	[0][0][RTW89_WW][38] = 28,
	[0][0][RTW89_WW][40] = 28,
	[0][0][RTW89_WW][42] = 28,
	[0][0][RTW89_WW][44] = 28,
	[0][0][RTW89_WW][46] = 28,
	[0][0][RTW89_WW][48] = 24,
	[0][0][RTW89_WW][50] = 24,
	[0][0][RTW89_WW][52] = 24,
	[0][1][RTW89_WW][0] = 0,
	[0][1][RTW89_WW][2] = 4,
	[0][1][RTW89_WW][4] = 0,
	[0][1][RTW89_WW][6] = 0,
	[0][1][RTW89_WW][8] = 12,
	[0][1][RTW89_WW][10] = 12,
	[0][1][RTW89_WW][12] = 12,
	[0][1][RTW89_WW][14] = 12,
	[0][1][RTW89_WW][15] = 12,
	[0][1][RTW89_WW][17] = 12,
	[0][1][RTW89_WW][19] = 12,
	[0][1][RTW89_WW][21] = 12,
	[0][1][RTW89_WW][23] = 12,
	[0][1][RTW89_WW][25] = 18,
	[0][1][RTW89_WW][27] = 16,
	[0][1][RTW89_WW][29] = 16,
	[0][1][RTW89_WW][31] = 12,
	[0][1][RTW89_WW][33] = 12,
	[0][1][RTW89_WW][35] = 12,
	[0][1][RTW89_WW][37] = 30,
	[0][1][RTW89_WW][38] = 16,
	[0][1][RTW89_WW][40] = 16,
	[0][1][RTW89_WW][42] = 16,
	[0][1][RTW89_WW][44] = 16,
	[0][1][RTW89_WW][46] = 16,
	[0][1][RTW89_WW][48] = 12,
	[0][1][RTW89_WW][50] = 12,
	[0][1][RTW89_WW][52] = 12,
	[1][0][RTW89_WW][0] = 34,
	[1][0][RTW89_WW][2] = 34,
	[1][0][RTW89_WW][4] = 34,
	[1][0][RTW89_WW][6] = 34,
	[1][0][RTW89_WW][8] = 34,
	[1][0][RTW89_WW][10] = 34,
	[1][0][RTW89_WW][12] = 34,
	[1][0][RTW89_WW][14] = 34,
	[1][0][RTW89_WW][15] = 34,
	[1][0][RTW89_WW][17] = 34,
	[1][0][RTW89_WW][19] = 34,
	[1][0][RTW89_WW][21] = 34,
	[1][0][RTW89_WW][23] = 34,
	[1][0][RTW89_WW][25] = 40,
	[1][0][RTW89_WW][27] = 42,
	[1][0][RTW89_WW][29] = 42,
	[1][0][RTW89_WW][31] = 34,
	[1][0][RTW89_WW][33] = 34,
	[1][0][RTW89_WW][35] = 34,
	[1][0][RTW89_WW][37] = 56,
	[1][0][RTW89_WW][38] = 28,
	[1][0][RTW89_WW][40] = 28,
	[1][0][RTW89_WW][42] = 28,
	[1][0][RTW89_WW][44] = 28,
	[1][0][RTW89_WW][46] = 28,
	[1][0][RTW89_WW][48] = 36,
	[1][0][RTW89_WW][50] = 36,
	[1][0][RTW89_WW][52] = 36,
	[1][1][RTW89_WW][0] = 10,
	[1][1][RTW89_WW][2] = 14,
	[1][1][RTW89_WW][4] = 10,
	[1][1][RTW89_WW][6] = 10,
	[1][1][RTW89_WW][8] = 20,
	[1][1][RTW89_WW][10] = 20,
	[1][1][RTW89_WW][12] = 22,
	[1][1][RTW89_WW][14] = 22,
	[1][1][RTW89_WW][15] = 22,
	[1][1][RTW89_WW][17] = 22,
	[1][1][RTW89_WW][19] = 22,
	[1][1][RTW89_WW][21] = 22,
	[1][1][RTW89_WW][23] = 22,
	[1][1][RTW89_WW][25] = 28,
	[1][1][RTW89_WW][27] = 30,
	[1][1][RTW89_WW][29] = 30,
	[1][1][RTW89_WW][31] = 22,
	[1][1][RTW89_WW][33] = 22,
	[1][1][RTW89_WW][35] = 22,
	[1][1][RTW89_WW][37] = 40,
	[1][1][RTW89_WW][38] = 16,
	[1][1][RTW89_WW][40] = 16,
	[1][1][RTW89_WW][42] = 16,
	[1][1][RTW89_WW][44] = 16,
	[1][1][RTW89_WW][46] = 16,
	[1][1][RTW89_WW][48] = 24,
	[1][1][RTW89_WW][50] = 24,
	[1][1][RTW89_WW][52] = 24,
	[2][0][RTW89_WW][0] = 46,
	[2][0][RTW89_WW][2] = 46,
	[2][0][RTW89_WW][4] = 46,
	[2][0][RTW89_WW][6] = 46,
	[2][0][RTW89_WW][8] = 44,
	[2][0][RTW89_WW][10] = 44,
	[2][0][RTW89_WW][12] = 48,
	[2][0][RTW89_WW][14] = 48,
	[2][0][RTW89_WW][15] = 48,
	[2][0][RTW89_WW][17] = 48,
	[2][0][RTW89_WW][19] = 48,
	[2][0][RTW89_WW][21] = 48,
	[2][0][RTW89_WW][23] = 48,
	[2][0][RTW89_WW][25] = 52,
	[2][0][RTW89_WW][27] = 52,
	[2][0][RTW89_WW][29] = 52,
	[2][0][RTW89_WW][31] = 48,
	[2][0][RTW89_WW][33] = 48,
	[2][0][RTW89_WW][35] = 48,
	[2][0][RTW89_WW][37] = 62,
	[2][0][RTW89_WW][38] = 28,
	[2][0][RTW89_WW][40] = 28,
	[2][0][RTW89_WW][42] = 28,
	[2][0][RTW89_WW][44] = 28,
	[2][0][RTW89_WW][46] = 28,
	[2][0][RTW89_WW][48] = 48,
	[2][0][RTW89_WW][50] = 48,
	[2][0][RTW89_WW][52] = 48,
	[2][1][RTW89_WW][0] = 20,
	[2][1][RTW89_WW][2] = 18,
	[2][1][RTW89_WW][4] = 22,
	[2][1][RTW89_WW][6] = 22,
	[2][1][RTW89_WW][8] = 32,
	[2][1][RTW89_WW][10] = 32,
	[2][1][RTW89_WW][12] = 36,
	[2][1][RTW89_WW][14] = 36,
	[2][1][RTW89_WW][15] = 36,
	[2][1][RTW89_WW][17] = 36,
	[2][1][RTW89_WW][19] = 36,
	[2][1][RTW89_WW][21] = 36,
	[2][1][RTW89_WW][23] = 36,
	[2][1][RTW89_WW][25] = 40,
	[2][1][RTW89_WW][27] = 40,
	[2][1][RTW89_WW][29] = 40,
	[2][1][RTW89_WW][31] = 36,
	[2][1][RTW89_WW][33] = 36,
	[2][1][RTW89_WW][35] = 36,
	[2][1][RTW89_WW][37] = 42,
	[2][1][RTW89_WW][38] = 16,
	[2][1][RTW89_WW][40] = 16,
	[2][1][RTW89_WW][42] = 16,
	[2][1][RTW89_WW][44] = 16,
	[2][1][RTW89_WW][46] = 16,
	[2][1][RTW89_WW][48] = 36,
	[2][1][RTW89_WW][50] = 36,
	[2][1][RTW89_WW][52] = 36,
	[0][0][RTW89_FCC][0] = 44,
	[0][0][RTW89_ETSI][0] = 30,
	[0][0][RTW89_MKK][0] = 36,
	[0][0][RTW89_IC][0] = 24,
	[0][0][RTW89_ACMA][0] = 24,
	[0][0][RTW89_FCC][2] = 44,
	[0][0][RTW89_ETSI][2] = 30,
	[0][0][RTW89_MKK][2] = 36,
	[0][0][RTW89_IC][2] = 24,
	[0][0][RTW89_ACMA][2] = 24,
	[0][0][RTW89_FCC][4] = 44,
	[0][0][RTW89_ETSI][4] = 30,
	[0][0][RTW89_MKK][4] = 22,
	[0][0][RTW89_IC][4] = 24,
	[0][0][RTW89_ACMA][4] = 24,
	[0][0][RTW89_FCC][6] = 44,
	[0][0][RTW89_ETSI][6] = 30,
	[0][0][RTW89_MKK][6] = 22,
	[0][0][RTW89_IC][6] = 24,
	[0][0][RTW89_ACMA][6] = 24,
	[0][0][RTW89_FCC][8] = 44,
	[0][0][RTW89_ETSI][8] = 28,
	[0][0][RTW89_MKK][8] = 18,
	[0][0][RTW89_IC][8] = 52,
	[0][0][RTW89_ACMA][8] = 24,
	[0][0][RTW89_FCC][10] = 44,
	[0][0][RTW89_ETSI][10] = 28,
	[0][0][RTW89_MKK][10] = 18,
	[0][0][RTW89_IC][10] = 52,
	[0][0][RTW89_ACMA][10] = 24,
	[0][0][RTW89_FCC][12] = 44,
	[0][0][RTW89_ETSI][12] = 28,
	[0][0][RTW89_MKK][12] = 34,
	[0][0][RTW89_IC][12] = 52,
	[0][0][RTW89_ACMA][12] = 24,
	[0][0][RTW89_FCC][14] = 44,
	[0][0][RTW89_ETSI][14] = 28,
	[0][0][RTW89_MKK][14] = 34,
	[0][0][RTW89_IC][14] = 52,
	[0][0][RTW89_ACMA][14] = 24,
	[0][0][RTW89_FCC][15] = 44,
	[0][0][RTW89_ETSI][15] = 30,
	[0][0][RTW89_MKK][15] = 56,
	[0][0][RTW89_IC][15] = 52,
	[0][0][RTW89_ACMA][15] = 24,
	[0][0][RTW89_FCC][17] = 44,
	[0][0][RTW89_ETSI][17] = 30,
	[0][0][RTW89_MKK][17] = 58,
	[0][0][RTW89_IC][17] = 52,
	[0][0][RTW89_ACMA][17] = 24,
	[0][0][RTW89_FCC][19] = 44,
	[0][0][RTW89_ETSI][19] = 30,
	[0][0][RTW89_MKK][19] = 58,
	[0][0][RTW89_IC][19] = 52,
	[0][0][RTW89_ACMA][19] = 24,
	[0][0][RTW89_FCC][21] = 44,
	[0][0][RTW89_ETSI][21] = 30,
	[0][0][RTW89_MKK][21] = 58,
	[0][0][RTW89_IC][21] = 52,
	[0][0][RTW89_ACMA][21] = 24,
	[0][0][RTW89_FCC][23] = 44,
	[0][0][RTW89_ETSI][23] = 30,
	[0][0][RTW89_MKK][23] = 58,
	[0][0][RTW89_IC][23] = 52,
	[0][0][RTW89_ACMA][23] = 24,
	[0][0][RTW89_FCC][25] = 44,
	[0][0][RTW89_ETSI][25] = 30,
	[0][0][RTW89_MKK][25] = 58,
	[0][0][RTW89_IC][25] = 127,
	[0][0][RTW89_ACMA][25] = 127,
	[0][0][RTW89_FCC][27] = 44,
	[0][0][RTW89_ETSI][27] = 30,
	[0][0][RTW89_MKK][27] = 58,
	[0][0][RTW89_IC][27] = 127,
	[0][0][RTW89_ACMA][27] = 127,
	[0][0][RTW89_FCC][29] = 44,
	[0][0][RTW89_ETSI][29] = 30,
	[0][0][RTW89_MKK][29] = 58,
	[0][0][RTW89_IC][29] = 127,
	[0][0][RTW89_ACMA][29] = 127,
	[0][0][RTW89_FCC][31] = 44,
	[0][0][RTW89_ETSI][31] = 30,
	[0][0][RTW89_MKK][31] = 58,
	[0][0][RTW89_IC][31] = 52,
	[0][0][RTW89_ACMA][31] = 24,
	[0][0][RTW89_FCC][33] = 44,
	[0][0][RTW89_ETSI][33] = 30,
	[0][0][RTW89_MKK][33] = 58,
	[0][0][RTW89_IC][33] = 52,
	[0][0][RTW89_ACMA][33] = 24,
	[0][0][RTW89_FCC][35] = 44,
	[0][0][RTW89_ETSI][35] = 30,
	[0][0][RTW89_MKK][35] = 58,
	[0][0][RTW89_IC][35] = 52,
	[0][0][RTW89_ACMA][35] = 24,
	[0][0][RTW89_FCC][37] = 44,
	[0][0][RTW89_ETSI][37] = 127,
	[0][0][RTW89_MKK][37] = 58,
	[0][0][RTW89_IC][37] = 52,
	[0][0][RTW89_ACMA][37] = 52,
	[0][0][RTW89_FCC][38] = 76,
	[0][0][RTW89_ETSI][38] = 28,
	[0][0][RTW89_MKK][38] = 127,
	[0][0][RTW89_IC][38] = 84,
	[0][0][RTW89_ACMA][38] = 84,
	[0][0][RTW89_FCC][40] = 76,
	[0][0][RTW89_ETSI][40] = 28,
	[0][0][RTW89_MKK][40] = 127,
	[0][0][RTW89_IC][40] = 84,
	[0][0][RTW89_ACMA][40] = 84,
	[0][0][RTW89_FCC][42] = 76,
	[0][0][RTW89_ETSI][42] = 28,
	[0][0][RTW89_MKK][42] = 127,
	[0][0][RTW89_IC][42] = 84,
	[0][0][RTW89_ACMA][42] = 84,
	[0][0][RTW89_FCC][44] = 76,
	[0][0][RTW89_ETSI][44] = 28,
	[0][0][RTW89_MKK][44] = 127,
	[0][0][RTW89_IC][44] = 84,
	[0][0][RTW89_ACMA][44] = 84,
	[0][0][RTW89_FCC][46] = 76,
	[0][0][RTW89_ETSI][46] = 28,
	[0][0][RTW89_MKK][46] = 127,
	[0][0][RTW89_IC][46] = 84,
	[0][0][RTW89_ACMA][46] = 84,
	[0][0][RTW89_FCC][48] = 24,
	[0][0][RTW89_ETSI][48] = 127,
	[0][0][RTW89_MKK][48] = 127,
	[0][0][RTW89_IC][48] = 127,
	[0][0][RTW89_ACMA][48] = 127,
	[0][0][RTW89_FCC][50] = 24,
	[0][0][RTW89_ETSI][50] = 127,
	[0][0][RTW89_MKK][50] = 127,
	[0][0][RTW89_IC][50] = 127,
	[0][0][RTW89_ACMA][50] = 127,
	[0][0][RTW89_FCC][52] = 24,
	[0][0][RTW89_ETSI][52] = 127,
	[0][0][RTW89_MKK][52] = 127,
	[0][0][RTW89_IC][52] = 127,
	[0][0][RTW89_ACMA][52] = 127,
	[0][1][RTW89_FCC][0] = 26,
	[0][1][RTW89_ETSI][0] = 18,
	[0][1][RTW89_MKK][0] = 20,
	[0][1][RTW89_IC][0] = 0,
	[0][1][RTW89_ACMA][0] = 12,
	[0][1][RTW89_FCC][2] = 30,
	[0][1][RTW89_ETSI][2] = 18,
	[0][1][RTW89_MKK][2] = 20,
	[0][1][RTW89_IC][2] = 4,
	[0][1][RTW89_ACMA][2] = 12,
	[0][1][RTW89_FCC][4] = 26,
	[0][1][RTW89_ETSI][4] = 18,
	[0][1][RTW89_MKK][4] = 8,
	[0][1][RTW89_IC][4] = 0,
	[0][1][RTW89_ACMA][4] = 12,
	[0][1][RTW89_FCC][6] = 26,
	[0][1][RTW89_ETSI][6] = 18,
	[0][1][RTW89_MKK][6] = 8,
	[0][1][RTW89_IC][6] = 0,
	[0][1][RTW89_ACMA][6] = 12,
	[0][1][RTW89_FCC][8] = 26,
	[0][1][RTW89_ETSI][8] = 16,
	[0][1][RTW89_MKK][8] = 20,
	[0][1][RTW89_IC][8] = 34,
	[0][1][RTW89_ACMA][8] = 12,
	[0][1][RTW89_FCC][10] = 26,
	[0][1][RTW89_ETSI][10] = 16,
	[0][1][RTW89_MKK][10] = 20,
	[0][1][RTW89_IC][10] = 34,
	[0][1][RTW89_ACMA][10] = 12,
	[0][1][RTW89_FCC][12] = 30,
	[0][1][RTW89_ETSI][12] = 16,
	[0][1][RTW89_MKK][12] = 34,
	[0][1][RTW89_IC][12] = 38,
	[0][1][RTW89_ACMA][12] = 12,
	[0][1][RTW89_FCC][14] = 26,
	[0][1][RTW89_ETSI][14] = 16,
	[0][1][RTW89_MKK][14] = 34,
	[0][1][RTW89_IC][14] = 34,
	[0][1][RTW89_ACMA][14] = 12,
	[0][1][RTW89_FCC][15] = 26,
	[0][1][RTW89_ETSI][15] = 18,
	[0][1][RTW89_MKK][15] = 44,
	[0][1][RTW89_IC][15] = 34,
	[0][1][RTW89_ACMA][15] = 12,
	[0][1][RTW89_FCC][17] = 26,
	[0][1][RTW89_ETSI][17] = 18,
	[0][1][RTW89_MKK][17] = 44,
	[0][1][RTW89_IC][17] = 34,
	[0][1][RTW89_ACMA][17] = 12,
	[0][1][RTW89_FCC][19] = 30,
	[0][1][RTW89_ETSI][19] = 18,
	[0][1][RTW89_MKK][19] = 44,
	[0][1][RTW89_IC][19] = 38,
	[0][1][RTW89_ACMA][19] = 12,
	[0][1][RTW89_FCC][21] = 30,
	[0][1][RTW89_ETSI][21] = 18,
	[0][1][RTW89_MKK][21] = 44,
	[0][1][RTW89_IC][21] = 38,
	[0][1][RTW89_ACMA][21] = 12,
	[0][1][RTW89_FCC][23] = 30,
	[0][1][RTW89_ETSI][23] = 18,
	[0][1][RTW89_MKK][23] = 44,
	[0][1][RTW89_IC][23] = 38,
	[0][1][RTW89_ACMA][23] = 12,
	[0][1][RTW89_FCC][25] = 30,
	[0][1][RTW89_ETSI][25] = 18,
	[0][1][RTW89_MKK][25] = 44,
	[0][1][RTW89_IC][25] = 127,
	[0][1][RTW89_ACMA][25] = 127,
	[0][1][RTW89_FCC][27] = 30,
	[0][1][RTW89_ETSI][27] = 16,
	[0][1][RTW89_MKK][27] = 44,
	[0][1][RTW89_IC][27] = 127,
	[0][1][RTW89_ACMA][27] = 127,
	[0][1][RTW89_FCC][29] = 30,
	[0][1][RTW89_ETSI][29] = 16,
	[0][1][RTW89_MKK][29] = 44,
	[0][1][RTW89_IC][29] = 127,
	[0][1][RTW89_ACMA][29] = 127,
	[0][1][RTW89_FCC][31] = 30,
	[0][1][RTW89_ETSI][31] = 16,
	[0][1][RTW89_MKK][31] = 44,
	[0][1][RTW89_IC][31] = 34,
	[0][1][RTW89_ACMA][31] = 12,
	[0][1][RTW89_FCC][33] = 26,
	[0][1][RTW89_ETSI][33] = 16,
	[0][1][RTW89_MKK][33] = 44,
	[0][1][RTW89_IC][33] = 34,
	[0][1][RTW89_ACMA][33] = 12,
	[0][1][RTW89_FCC][35] = 26,
	[0][1][RTW89_ETSI][35] = 16,
	[0][1][RTW89_MKK][35] = 44,
	[0][1][RTW89_IC][35] = 34,
	[0][1][RTW89_ACMA][35] = 12,
	[0][1][RTW89_FCC][37] = 30,
	[0][1][RTW89_ETSI][37] = 127,
	[0][1][RTW89_MKK][37] = 44,
	[0][1][RTW89_IC][37] = 38,
	[0][1][RTW89_ACMA][37] = 38,
	[0][1][RTW89_FCC][38] = 74,
	[0][1][RTW89_ETSI][38] = 16,
	[0][1][RTW89_MKK][38] = 127,
	[0][1][RTW89_IC][38] = 82,
	[0][1][RTW89_ACMA][38] = 84,
	[0][1][RTW89_FCC][40] = 74,
	[0][1][RTW89_ETSI][40] = 16,
	[0][1][RTW89_MKK][40] = 127,
	[0][1][RTW89_IC][40] = 82,
	[0][1][RTW89_ACMA][40] = 84,
	[0][1][RTW89_FCC][42] = 74,
	[0][1][RTW89_ETSI][42] = 16,
	[0][1][RTW89_MKK][42] = 127,
	[0][1][RTW89_IC][42] = 82,
	[0][1][RTW89_ACMA][42] = 84,
	[0][1][RTW89_FCC][44] = 74,
	[0][1][RTW89_ETSI][44] = 16,
	[0][1][RTW89_MKK][44] = 127,
	[0][1][RTW89_IC][44] = 82,
	[0][1][RTW89_ACMA][44] = 84,
	[0][1][RTW89_FCC][46] = 74,
	[0][1][RTW89_ETSI][46] = 16,
	[0][1][RTW89_MKK][46] = 127,
	[0][1][RTW89_IC][46] = 82,
	[0][1][RTW89_ACMA][46] = 84,
	[0][1][RTW89_FCC][48] = 12,
	[0][1][RTW89_ETSI][48] = 127,
	[0][1][RTW89_MKK][48] = 127,
	[0][1][RTW89_IC][48] = 127,
	[0][1][RTW89_ACMA][48] = 127,
	[0][1][RTW89_FCC][50] = 12,
	[0][1][RTW89_ETSI][50] = 127,
	[0][1][RTW89_MKK][50] = 127,
	[0][1][RTW89_IC][50] = 127,
	[0][1][RTW89_ACMA][50] = 127,
	[0][1][RTW89_FCC][52] = 12,
	[0][1][RTW89_ETSI][52] = 127,
	[0][1][RTW89_MKK][52] = 127,
	[0][1][RTW89_IC][52] = 127,
	[0][1][RTW89_ACMA][52] = 127,
	[1][0][RTW89_FCC][0] = 54,
	[1][0][RTW89_ETSI][0] = 40,
	[1][0][RTW89_MKK][0] = 48,
	[1][0][RTW89_IC][0] = 36,
	[1][0][RTW89_ACMA][0] = 34,
	[1][0][RTW89_FCC][2] = 54,
	[1][0][RTW89_ETSI][2] = 40,
	[1][0][RTW89_MKK][2] = 48,
	[1][0][RTW89_IC][2] = 36,
	[1][0][RTW89_ACMA][2] = 34,
	[1][0][RTW89_FCC][4] = 54,
	[1][0][RTW89_ETSI][4] = 40,
	[1][0][RTW89_MKK][4] = 40,
	[1][0][RTW89_IC][4] = 36,
	[1][0][RTW89_ACMA][4] = 34,
	[1][0][RTW89_FCC][6] = 54,
	[1][0][RTW89_ETSI][6] = 40,
	[1][0][RTW89_MKK][6] = 40,
	[1][0][RTW89_IC][6] = 36,
	[1][0][RTW89_ACMA][6] = 34,
	[1][0][RTW89_FCC][8] = 54,
	[1][0][RTW89_ETSI][8] = 40,
	[1][0][RTW89_MKK][8] = 34,
	[1][0][RTW89_IC][8] = 62,
	[1][0][RTW89_ACMA][8] = 34,
	[1][0][RTW89_FCC][10] = 54,
	[1][0][RTW89_ETSI][10] = 40,
	[1][0][RTW89_MKK][10] = 34,
	[1][0][RTW89_IC][10] = 62,
	[1][0][RTW89_ACMA][10] = 34,
	[1][0][RTW89_FCC][12] = 56,
	[1][0][RTW89_ETSI][12] = 40,
	[1][0][RTW89_MKK][12] = 46,
	[1][0][RTW89_IC][12] = 64,
	[1][0][RTW89_ACMA][12] = 34,
	[1][0][RTW89_FCC][14] = 54,
	[1][0][RTW89_ETSI][14] = 40,
	[1][0][RTW89_MKK][14] = 46,
	[1][0][RTW89_IC][14] = 62,
	[1][0][RTW89_ACMA][14] = 34,
	[1][0][RTW89_FCC][15] = 54,
	[1][0][RTW89_ETSI][15] = 40,
	[1][0][RTW89_MKK][15] = 62,
	[1][0][RTW89_IC][15] = 62,
	[1][0][RTW89_ACMA][15] = 34,
	[1][0][RTW89_FCC][17] = 54,
	[1][0][RTW89_ETSI][17] = 40,
	[1][0][RTW89_MKK][17] = 68,
	[1][0][RTW89_IC][17] = 62,
	[1][0][RTW89_ACMA][17] = 34,
	[1][0][RTW89_FCC][19] = 54,
	[1][0][RTW89_ETSI][19] = 40,
	[1][0][RTW89_MKK][19] = 68,
	[1][0][RTW89_IC][19] = 62,
	[1][0][RTW89_ACMA][19] = 34,
	[1][0][RTW89_FCC][21] = 54,
	[1][0][RTW89_ETSI][21] = 40,
	[1][0][RTW89_MKK][21] = 68,
	[1][0][RTW89_IC][21] = 62,
	[1][0][RTW89_ACMA][21] = 34,
	[1][0][RTW89_FCC][23] = 54,
	[1][0][RTW89_ETSI][23] = 40,
	[1][0][RTW89_MKK][23] = 68,
	[1][0][RTW89_IC][23] = 62,
	[1][0][RTW89_ACMA][23] = 34,
	[1][0][RTW89_FCC][25] = 54,
	[1][0][RTW89_ETSI][25] = 40,
	[1][0][RTW89_MKK][25] = 68,
	[1][0][RTW89_IC][25] = 127,
	[1][0][RTW89_ACMA][25] = 127,
	[1][0][RTW89_FCC][27] = 54,
	[1][0][RTW89_ETSI][27] = 42,
	[1][0][RTW89_MKK][27] = 68,
	[1][0][RTW89_IC][27] = 127,
	[1][0][RTW89_ACMA][27] = 127,
	[1][0][RTW89_FCC][29] = 54,
	[1][0][RTW89_ETSI][29] = 42,
	[1][0][RTW89_MKK][29] = 68,
	[1][0][RTW89_IC][29] = 127,
	[1][0][RTW89_ACMA][29] = 127,
	[1][0][RTW89_FCC][31] = 54,
	[1][0][RTW89_ETSI][31] = 42,
	[1][0][RTW89_MKK][31] = 68,
	[1][0][RTW89_IC][31] = 62,
	[1][0][RTW89_ACMA][31] = 34,
	[1][0][RTW89_FCC][33] = 54,
	[1][0][RTW89_ETSI][33] = 42,
	[1][0][RTW89_MKK][33] = 68,
	[1][0][RTW89_IC][33] = 62,
	[1][0][RTW89_ACMA][33] = 34,
	[1][0][RTW89_FCC][35] = 54,
	[1][0][RTW89_ETSI][35] = 42,
	[1][0][RTW89_MKK][35] = 68,
	[1][0][RTW89_IC][35] = 62,
	[1][0][RTW89_ACMA][35] = 34,
	[1][0][RTW89_FCC][37] = 56,
	[1][0][RTW89_ETSI][37] = 127,
	[1][0][RTW89_MKK][37] = 68,
	[1][0][RTW89_IC][37] = 64,
	[1][0][RTW89_ACMA][37] = 64,
	[1][0][RTW89_FCC][38] = 76,
	[1][0][RTW89_ETSI][38] = 28,
	[1][0][RTW89_MKK][38] = 127,
	[1][0][RTW89_IC][38] = 84,
	[1][0][RTW89_ACMA][38] = 84,
	[1][0][RTW89_FCC][40] = 76,
	[1][0][RTW89_ETSI][40] = 28,
	[1][0][RTW89_MKK][40] = 127,
	[1][0][RTW89_IC][40] = 84,
	[1][0][RTW89_ACMA][40] = 84,
	[1][0][RTW89_FCC][42] = 76,
	[1][0][RTW89_ETSI][42] = 28,
	[1][0][RTW89_MKK][42] = 127,
	[1][0][RTW89_IC][42] = 84,
	[1][0][RTW89_ACMA][42] = 84,
	[1][0][RTW89_FCC][44] = 76,
	[1][0][RTW89_ETSI][44] = 28,
	[1][0][RTW89_MKK][44] = 127,
	[1][0][RTW89_IC][44] = 84,
	[1][0][RTW89_ACMA][44] = 84,
	[1][0][RTW89_FCC][46] = 76,
	[1][0][RTW89_ETSI][46] = 28,
	[1][0][RTW89_MKK][46] = 127,
	[1][0][RTW89_IC][46] = 84,
	[1][0][RTW89_ACMA][46] = 84,
	[1][0][RTW89_FCC][48] = 36,
	[1][0][RTW89_ETSI][48] = 127,
	[1][0][RTW89_MKK][48] = 127,
	[1][0][RTW89_IC][48] = 127,
	[1][0][RTW89_ACMA][48] = 127,
	[1][0][RTW89_FCC][50] = 36,
	[1][0][RTW89_ETSI][50] = 127,
	[1][0][RTW89_MKK][50] = 127,
	[1][0][RTW89_IC][50] = 127,
	[1][0][RTW89_ACMA][50] = 127,
	[1][0][RTW89_FCC][52] = 36,
	[1][0][RTW89_ETSI][52] = 127,
	[1][0][RTW89_MKK][52] = 127,
	[1][0][RTW89_IC][52] = 127,
	[1][0][RTW89_ACMA][52] = 127,
	[1][1][RTW89_FCC][0] = 34,
	[1][1][RTW89_ETSI][0] = 30,
	[1][1][RTW89_MKK][0] = 34,
	[1][1][RTW89_IC][0] = 10,
	[1][1][RTW89_ACMA][0] = 22,
	[1][1][RTW89_FCC][2] = 36,
	[1][1][RTW89_ETSI][2] = 30,
	[1][1][RTW89_MKK][2] = 34,
	[1][1][RTW89_IC][2] = 14,
	[1][1][RTW89_ACMA][2] = 22,
	[1][1][RTW89_FCC][4] = 34,
	[1][1][RTW89_ETSI][4] = 30,
	[1][1][RTW89_MKK][4] = 26,
	[1][1][RTW89_IC][4] = 10,
	[1][1][RTW89_ACMA][4] = 22,
	[1][1][RTW89_FCC][6] = 34,
	[1][1][RTW89_ETSI][6] = 30,
	[1][1][RTW89_MKK][6] = 26,
	[1][1][RTW89_IC][6] = 10,
	[1][1][RTW89_ACMA][6] = 22,
	[1][1][RTW89_FCC][8] = 36,
	[1][1][RTW89_ETSI][8] = 30,
	[1][1][RTW89_MKK][8] = 20,
	[1][1][RTW89_IC][8] = 44,
	[1][1][RTW89_ACMA][8] = 22,
	[1][1][RTW89_FCC][10] = 36,
	[1][1][RTW89_ETSI][10] = 30,
	[1][1][RTW89_MKK][10] = 20,
	[1][1][RTW89_IC][10] = 44,
	[1][1][RTW89_ACMA][10] = 22,
	[1][1][RTW89_FCC][12] = 38,
	[1][1][RTW89_ETSI][12] = 30,
	[1][1][RTW89_MKK][12] = 34,
	[1][1][RTW89_IC][12] = 46,
	[1][1][RTW89_ACMA][12] = 22,
	[1][1][RTW89_FCC][14] = 34,
	[1][1][RTW89_ETSI][14] = 30,
	[1][1][RTW89_MKK][14] = 34,
	[1][1][RTW89_IC][14] = 40,
	[1][1][RTW89_ACMA][14] = 22,
	[1][1][RTW89_FCC][15] = 34,
	[1][1][RTW89_ETSI][15] = 28,
	[1][1][RTW89_MKK][15] = 56,
	[1][1][RTW89_IC][15] = 42,
	[1][1][RTW89_ACMA][15] = 22,
	[1][1][RTW89_FCC][17] = 34,
	[1][1][RTW89_ETSI][17] = 28,
	[1][1][RTW89_MKK][17] = 58,
	[1][1][RTW89_IC][17] = 42,
	[1][1][RTW89_ACMA][17] = 22,
	[1][1][RTW89_FCC][19] = 34,
	[1][1][RTW89_ETSI][19] = 28,
	[1][1][RTW89_MKK][19] = 58,
	[1][1][RTW89_IC][19] = 42,
	[1][1][RTW89_ACMA][19] = 22,
	[1][1][RTW89_FCC][21] = 34,
	[1][1][RTW89_ETSI][21] = 28,
	[1][1][RTW89_MKK][21] = 58,
	[1][1][RTW89_IC][21] = 42,
	[1][1][RTW89_ACMA][21] = 22,
	[1][1][RTW89_FCC][23] = 34,
	[1][1][RTW89_ETSI][23] = 28,
	[1][1][RTW89_MKK][23] = 58,
	[1][1][RTW89_IC][23] = 42,
	[1][1][RTW89_ACMA][23] = 22,
	[1][1][RTW89_FCC][25] = 34,
	[1][1][RTW89_ETSI][25] = 28,
	[1][1][RTW89_MKK][25] = 58,
	[1][1][RTW89_IC][25] = 127,
	[1][1][RTW89_ACMA][25] = 127,
	[1][1][RTW89_FCC][27] = 34,
	[1][1][RTW89_ETSI][27] = 30,
	[1][1][RTW89_MKK][27] = 58,
	[1][1][RTW89_IC][27] = 127,
	[1][1][RTW89_ACMA][27] = 127,
	[1][1][RTW89_FCC][29] = 34,
	[1][1][RTW89_ETSI][29] = 30,
	[1][1][RTW89_MKK][29] = 58,
	[1][1][RTW89_IC][29] = 127,
	[1][1][RTW89_ACMA][29] = 127,
	[1][1][RTW89_FCC][31] = 34,
	[1][1][RTW89_ETSI][31] = 30,
	[1][1][RTW89_MKK][31] = 58,
	[1][1][RTW89_IC][31] = 38,
	[1][1][RTW89_ACMA][31] = 22,
	[1][1][RTW89_FCC][33] = 32,
	[1][1][RTW89_ETSI][33] = 30,
	[1][1][RTW89_MKK][33] = 58,
	[1][1][RTW89_IC][33] = 38,
	[1][1][RTW89_ACMA][33] = 22,
	[1][1][RTW89_FCC][35] = 32,
	[1][1][RTW89_ETSI][35] = 30,
	[1][1][RTW89_MKK][35] = 58,
	[1][1][RTW89_IC][35] = 38,
	[1][1][RTW89_ACMA][35] = 22,
	[1][1][RTW89_FCC][37] = 40,
	[1][1][RTW89_ETSI][37] = 127,
	[1][1][RTW89_MKK][37] = 58,
	[1][1][RTW89_IC][37] = 48,
	[1][1][RTW89_ACMA][37] = 48,
	[1][1][RTW89_FCC][38] = 76,
	[1][1][RTW89_ETSI][38] = 16,
	[1][1][RTW89_MKK][38] = 127,
	[1][1][RTW89_IC][38] = 84,
	[1][1][RTW89_ACMA][38] = 82,
	[1][1][RTW89_FCC][40] = 76,
	[1][1][RTW89_ETSI][40] = 16,
	[1][1][RTW89_MKK][40] = 127,
	[1][1][RTW89_IC][40] = 84,
	[1][1][RTW89_ACMA][40] = 82,
	[1][1][RTW89_FCC][42] = 76,
	[1][1][RTW89_ETSI][42] = 16,
	[1][1][RTW89_MKK][42] = 127,
	[1][1][RTW89_IC][42] = 84,
	[1][1][RTW89_ACMA][42] = 84,
	[1][1][RTW89_FCC][44] = 76,
	[1][1][RTW89_ETSI][44] = 16,
	[1][1][RTW89_MKK][44] = 127,
	[1][1][RTW89_IC][44] = 84,
	[1][1][RTW89_ACMA][44] = 84,
	[1][1][RTW89_FCC][46] = 76,
	[1][1][RTW89_ETSI][46] = 16,
	[1][1][RTW89_MKK][46] = 127,
	[1][1][RTW89_IC][46] = 84,
	[1][1][RTW89_ACMA][46] = 84,
	[1][1][RTW89_FCC][48] = 24,
	[1][1][RTW89_ETSI][48] = 127,
	[1][1][RTW89_MKK][48] = 127,
	[1][1][RTW89_IC][48] = 127,
	[1][1][RTW89_ACMA][48] = 127,
	[1][1][RTW89_FCC][50] = 24,
	[1][1][RTW89_ETSI][50] = 127,
	[1][1][RTW89_MKK][50] = 127,
	[1][1][RTW89_IC][50] = 127,
	[1][1][RTW89_ACMA][50] = 127,
	[1][1][RTW89_FCC][52] = 24,
	[1][1][RTW89_ETSI][52] = 127,
	[1][1][RTW89_MKK][52] = 127,
	[1][1][RTW89_IC][52] = 127,
	[1][1][RTW89_ACMA][52] = 127,
	[2][0][RTW89_FCC][0] = 62,
	[2][0][RTW89_ETSI][0] = 52,
	[2][0][RTW89_MKK][0] = 60,
	[2][0][RTW89_IC][0] = 46,
	[2][0][RTW89_ACMA][0] = 48,
	[2][0][RTW89_FCC][2] = 62,
	[2][0][RTW89_ETSI][2] = 52,
	[2][0][RTW89_MKK][2] = 60,
	[2][0][RTW89_IC][2] = 46,
	[2][0][RTW89_ACMA][2] = 48,
	[2][0][RTW89_FCC][4] = 62,
	[2][0][RTW89_ETSI][4] = 52,
	[2][0][RTW89_MKK][4] = 50,
	[2][0][RTW89_IC][4] = 46,
	[2][0][RTW89_ACMA][4] = 48,
	[2][0][RTW89_FCC][6] = 62,
	[2][0][RTW89_ETSI][6] = 52,
	[2][0][RTW89_MKK][6] = 50,
	[2][0][RTW89_IC][6] = 46,
	[2][0][RTW89_ACMA][6] = 48,
	[2][0][RTW89_FCC][8] = 62,
	[2][0][RTW89_ETSI][8] = 52,
	[2][0][RTW89_MKK][8] = 44,
	[2][0][RTW89_IC][8] = 66,
	[2][0][RTW89_ACMA][8] = 48,
	[2][0][RTW89_FCC][10] = 62,
	[2][0][RTW89_ETSI][10] = 52,
	[2][0][RTW89_MKK][10] = 44,
	[2][0][RTW89_IC][10] = 66,
	[2][0][RTW89_ACMA][10] = 48,
	[2][0][RTW89_FCC][12] = 62,
	[2][0][RTW89_ETSI][12] = 52,
	[2][0][RTW89_MKK][12] = 58,
	[2][0][RTW89_IC][12] = 66,
	[2][0][RTW89_ACMA][12] = 48,
	[2][0][RTW89_FCC][14] = 62,
	[2][0][RTW89_ETSI][14] = 52,
	[2][0][RTW89_MKK][14] = 58,
	[2][0][RTW89_IC][14] = 66,
	[2][0][RTW89_ACMA][14] = 48,
	[2][0][RTW89_FCC][15] = 62,
	[2][0][RTW89_ETSI][15] = 52,
	[2][0][RTW89_MKK][15] = 68,
	[2][0][RTW89_IC][15] = 70,
	[2][0][RTW89_ACMA][15] = 48,
	[2][0][RTW89_FCC][17] = 62,
	[2][0][RTW89_ETSI][17] = 52,
	[2][0][RTW89_MKK][17] = 74,
	[2][0][RTW89_IC][17] = 70,
	[2][0][RTW89_ACMA][17] = 48,
	[2][0][RTW89_FCC][19] = 62,
	[2][0][RTW89_ETSI][19] = 52,
	[2][0][RTW89_MKK][19] = 74,
	[2][0][RTW89_IC][19] = 70,
	[2][0][RTW89_ACMA][19] = 48,
	[2][0][RTW89_FCC][21] = 62,
	[2][0][RTW89_ETSI][21] = 52,
	[2][0][RTW89_MKK][21] = 74,
	[2][0][RTW89_IC][21] = 70,
	[2][0][RTW89_ACMA][21] = 48,
	[2][0][RTW89_FCC][23] = 62,
	[2][0][RTW89_ETSI][23] = 52,
	[2][0][RTW89_MKK][23] = 74,
	[2][0][RTW89_IC][23] = 70,
	[2][0][RTW89_ACMA][23] = 48,
	[2][0][RTW89_FCC][25] = 62,
	[2][0][RTW89_ETSI][25] = 52,
	[2][0][RTW89_MKK][25] = 74,
	[2][0][RTW89_IC][25] = 127,
	[2][0][RTW89_ACMA][25] = 127,
	[2][0][RTW89_FCC][27] = 62,
	[2][0][RTW89_ETSI][27] = 52,
	[2][0][RTW89_MKK][27] = 74,
	[2][0][RTW89_IC][27] = 127,
	[2][0][RTW89_ACMA][27] = 127,
	[2][0][RTW89_FCC][29] = 62,
	[2][0][RTW89_ETSI][29] = 52,
	[2][0][RTW89_MKK][29] = 74,
	[2][0][RTW89_IC][29] = 127,
	[2][0][RTW89_ACMA][29] = 127,
	[2][0][RTW89_FCC][31] = 62,
	[2][0][RTW89_ETSI][31] = 52,
	[2][0][RTW89_MKK][31] = 74,
	[2][0][RTW89_IC][31] = 72,
	[2][0][RTW89_ACMA][31] = 48,
	[2][0][RTW89_FCC][33] = 64,
	[2][0][RTW89_ETSI][33] = 52,
	[2][0][RTW89_MKK][33] = 74,
	[2][0][RTW89_IC][33] = 72,
	[2][0][RTW89_ACMA][33] = 48,
	[2][0][RTW89_FCC][35] = 64,
	[2][0][RTW89_ETSI][35] = 52,
	[2][0][RTW89_MKK][35] = 74,
	[2][0][RTW89_IC][35] = 72,
	[2][0][RTW89_ACMA][35] = 48,
	[2][0][RTW89_FCC][37] = 62,
	[2][0][RTW89_ETSI][37] = 127,
	[2][0][RTW89_MKK][37] = 74,
	[2][0][RTW89_IC][37] = 70,
	[2][0][RTW89_ACMA][37] = 76,
	[2][0][RTW89_FCC][38] = 76,
	[2][0][RTW89_ETSI][38] = 28,
	[2][0][RTW89_MKK][38] = 127,
	[2][0][RTW89_IC][38] = 84,
	[2][0][RTW89_ACMA][38] = 84,
	[2][0][RTW89_FCC][40] = 76,
	[2][0][RTW89_ETSI][40] = 28,
	[2][0][RTW89_MKK][40] = 127,
	[2][0][RTW89_IC][40] = 84,
	[2][0][RTW89_ACMA][40] = 84,
	[2][0][RTW89_FCC][42] = 76,
	[2][0][RTW89_ETSI][42] = 28,
	[2][0][RTW89_MKK][42] = 127,
	[2][0][RTW89_IC][42] = 84,
	[2][0][RTW89_ACMA][42] = 84,
	[2][0][RTW89_FCC][44] = 76,
	[2][0][RTW89_ETSI][44] = 28,
	[2][0][RTW89_MKK][44] = 127,
	[2][0][RTW89_IC][44] = 84,
	[2][0][RTW89_ACMA][44] = 84,
	[2][0][RTW89_FCC][46] = 76,
	[2][0][RTW89_ETSI][46] = 28,
	[2][0][RTW89_MKK][46] = 127,
	[2][0][RTW89_IC][46] = 84,
	[2][0][RTW89_ACMA][46] = 84,
	[2][0][RTW89_FCC][48] = 48,
	[2][0][RTW89_ETSI][48] = 127,
	[2][0][RTW89_MKK][48] = 127,
	[2][0][RTW89_IC][48] = 127,
	[2][0][RTW89_ACMA][48] = 127,
	[2][0][RTW89_FCC][50] = 48,
	[2][0][RTW89_ETSI][50] = 127,
	[2][0][RTW89_MKK][50] = 127,
	[2][0][RTW89_IC][50] = 127,
	[2][0][RTW89_ACMA][50] = 127,
	[2][0][RTW89_FCC][52] = 48,
	[2][0][RTW89_ETSI][52] = 127,
	[2][0][RTW89_MKK][52] = 127,
	[2][0][RTW89_IC][52] = 127,
	[2][0][RTW89_ACMA][52] = 127,
	[2][1][RTW89_FCC][0] = 42,
	[2][1][RTW89_ETSI][0] = 40,
	[2][1][RTW89_MKK][0] = 44,
	[2][1][RTW89_IC][0] = 20,
	[2][1][RTW89_ACMA][0] = 36,
	[2][1][RTW89_FCC][2] = 42,
	[2][1][RTW89_ETSI][2] = 40,
	[2][1][RTW89_MKK][2] = 44,
	[2][1][RTW89_IC][2] = 18,
	[2][1][RTW89_ACMA][2] = 36,
	[2][1][RTW89_FCC][4] = 42,
	[2][1][RTW89_ETSI][4] = 40,
	[2][1][RTW89_MKK][4] = 36,
	[2][1][RTW89_IC][4] = 22,
	[2][1][RTW89_ACMA][4] = 36,
	[2][1][RTW89_FCC][6] = 42,
	[2][1][RTW89_ETSI][6] = 40,
	[2][1][RTW89_MKK][6] = 36,
	[2][1][RTW89_IC][6] = 22,
	[2][1][RTW89_ACMA][6] = 36,
	[2][1][RTW89_FCC][8] = 42,
	[2][1][RTW89_ETSI][8] = 40,
	[2][1][RTW89_MKK][8] = 32,
	[2][1][RTW89_IC][8] = 50,
	[2][1][RTW89_ACMA][8] = 36,
	[2][1][RTW89_FCC][10] = 42,
	[2][1][RTW89_ETSI][10] = 40,
	[2][1][RTW89_MKK][10] = 32,
	[2][1][RTW89_IC][10] = 50,
	[2][1][RTW89_ACMA][10] = 36,
	[2][1][RTW89_FCC][12] = 44,
	[2][1][RTW89_ETSI][12] = 40,
	[2][1][RTW89_MKK][12] = 44,
	[2][1][RTW89_IC][12] = 52,
	[2][1][RTW89_ACMA][12] = 36,
	[2][1][RTW89_FCC][14] = 44,
	[2][1][RTW89_ETSI][14] = 40,
	[2][1][RTW89_MKK][14] = 44,
	[2][1][RTW89_IC][14] = 52,
	[2][1][RTW89_ACMA][14] = 36,
	[2][1][RTW89_FCC][15] = 42,
	[2][1][RTW89_ETSI][15] = 40,
	[2][1][RTW89_MKK][15] = 66,
	[2][1][RTW89_IC][15] = 50,
	[2][1][RTW89_ACMA][15] = 36,
	[2][1][RTW89_FCC][17] = 42,
	[2][1][RTW89_ETSI][17] = 40,
	[2][1][RTW89_MKK][17] = 66,
	[2][1][RTW89_IC][17] = 50,
	[2][1][RTW89_ACMA][17] = 36,
	[2][1][RTW89_FCC][19] = 42,
	[2][1][RTW89_ETSI][19] = 40,
	[2][1][RTW89_MKK][19] = 66,
	[2][1][RTW89_IC][19] = 50,
	[2][1][RTW89_ACMA][19] = 36,
	[2][1][RTW89_FCC][21] = 42,
	[2][1][RTW89_ETSI][21] = 40,
	[2][1][RTW89_MKK][21] = 66,
	[2][1][RTW89_IC][21] = 50,
	[2][1][RTW89_ACMA][21] = 36,
	[2][1][RTW89_FCC][23] = 42,
	[2][1][RTW89_ETSI][23] = 40,
	[2][1][RTW89_MKK][23] = 66,
	[2][1][RTW89_IC][23] = 50,
	[2][1][RTW89_ACMA][23] = 36,
	[2][1][RTW89_FCC][25] = 42,
	[2][1][RTW89_ETSI][25] = 40,
	[2][1][RTW89_MKK][25] = 66,
	[2][1][RTW89_IC][25] = 127,
	[2][1][RTW89_ACMA][25] = 127,
	[2][1][RTW89_FCC][27] = 42,
	[2][1][RTW89_ETSI][27] = 40,
	[2][1][RTW89_MKK][27] = 66,
	[2][1][RTW89_IC][27] = 127,
	[2][1][RTW89_ACMA][27] = 127,
	[2][1][RTW89_FCC][29] = 42,
	[2][1][RTW89_ETSI][29] = 40,
	[2][1][RTW89_MKK][29] = 66,
	[2][1][RTW89_IC][29] = 127,
	[2][1][RTW89_ACMA][29] = 127,
	[2][1][RTW89_FCC][31] = 42,
	[2][1][RTW89_ETSI][31] = 40,
	[2][1][RTW89_MKK][31] = 66,
	[2][1][RTW89_IC][31] = 50,
	[2][1][RTW89_ACMA][31] = 36,
	[2][1][RTW89_FCC][33] = 42,
	[2][1][RTW89_ETSI][33] = 40,
	[2][1][RTW89_MKK][33] = 66,
	[2][1][RTW89_IC][33] = 50,
	[2][1][RTW89_ACMA][33] = 36,
	[2][1][RTW89_FCC][35] = 42,
	[2][1][RTW89_ETSI][35] = 40,
	[2][1][RTW89_MKK][35] = 66,
	[2][1][RTW89_IC][35] = 50,
	[2][1][RTW89_ACMA][35] = 36,
	[2][1][RTW89_FCC][37] = 42,
	[2][1][RTW89_ETSI][37] = 127,
	[2][1][RTW89_MKK][37] = 66,
	[2][1][RTW89_IC][37] = 50,
	[2][1][RTW89_ACMA][37] = 60,
	[2][1][RTW89_FCC][38] = 76,
	[2][1][RTW89_ETSI][38] = 16,
	[2][1][RTW89_MKK][38] = 127,
	[2][1][RTW89_IC][38] = 84,
	[2][1][RTW89_ACMA][38] = 84,
	[2][1][RTW89_FCC][40] = 76,
	[2][1][RTW89_ETSI][40] = 16,
	[2][1][RTW89_MKK][40] = 127,
	[2][1][RTW89_IC][40] = 84,
	[2][1][RTW89_ACMA][40] = 84,
	[2][1][RTW89_FCC][42] = 76,
	[2][1][RTW89_ETSI][42] = 16,
	[2][1][RTW89_MKK][42] = 127,
	[2][1][RTW89_IC][42] = 84,
	[2][1][RTW89_ACMA][42] = 84,
	[2][1][RTW89_FCC][44] = 76,
	[2][1][RTW89_ETSI][44] = 16,
	[2][1][RTW89_MKK][44] = 127,
	[2][1][RTW89_IC][44] = 84,
	[2][1][RTW89_ACMA][44] = 84,
	[2][1][RTW89_FCC][46] = 76,
	[2][1][RTW89_ETSI][46] = 16,
	[2][1][RTW89_MKK][46] = 127,
	[2][1][RTW89_IC][46] = 84,
	[2][1][RTW89_ACMA][46] = 84,
	[2][1][RTW89_FCC][48] = 36,
	[2][1][RTW89_ETSI][48] = 127,
	[2][1][RTW89_MKK][48] = 127,
	[2][1][RTW89_IC][48] = 127,
	[2][1][RTW89_ACMA][48] = 127,
	[2][1][RTW89_FCC][50] = 36,
	[2][1][RTW89_ETSI][50] = 127,
	[2][1][RTW89_MKK][50] = 127,
	[2][1][RTW89_IC][50] = 127,
	[2][1][RTW89_ACMA][50] = 127,
	[2][1][RTW89_FCC][52] = 36,
	[2][1][RTW89_ETSI][52] = 127,
	[2][1][RTW89_MKK][52] = 127,
	[2][1][RTW89_IC][52] = 127,
	[2][1][RTW89_ACMA][52] = 127,
};

const s8 rtw89_8852c_txpwr_lmt_ru_6g[RTW89_RU_NUM][RTW89_NTX_NUM]
				    [RTW89_REGD_NUM][RTW89_6G_CH_NUM] = {
	[0][0][RTW89_WW][0] = 76,
	[0][0][RTW89_WW][2] = 76,
	[0][0][RTW89_WW][4] = 76,
	[0][0][RTW89_WW][6] = 76,
	[0][0][RTW89_WW][8] = 76,
	[0][0][RTW89_WW][10] = 76,
	[0][0][RTW89_WW][12] = 76,
	[0][0][RTW89_WW][14] = 76,
	[0][0][RTW89_WW][15] = 76,
	[0][0][RTW89_WW][17] = 76,
	[0][0][RTW89_WW][19] = 76,
	[0][0][RTW89_WW][21] = 76,
	[0][0][RTW89_WW][23] = 76,
	[0][0][RTW89_WW][25] = 76,
	[0][0][RTW89_WW][27] = 76,
	[0][0][RTW89_WW][29] = 76,
	[0][0][RTW89_WW][30] = 76,
	[0][0][RTW89_WW][32] = 76,
	[0][0][RTW89_WW][34] = 76,
	[0][0][RTW89_WW][36] = 76,
	[0][0][RTW89_WW][38] = 76,
	[0][0][RTW89_WW][40] = 76,
	[0][0][RTW89_WW][42] = 76,
	[0][0][RTW89_WW][44] = 76,
	[0][0][RTW89_WW][45] = 76,
	[0][0][RTW89_WW][47] = 76,
	[0][0][RTW89_WW][49] = 76,
	[0][0][RTW89_WW][51] = 76,
	[0][0][RTW89_WW][53] = 76,
	[0][0][RTW89_WW][55] = 76,
	[0][0][RTW89_WW][57] = 76,
	[0][0][RTW89_WW][59] = 76,
	[0][0][RTW89_WW][60] = 76,
	[0][0][RTW89_WW][62] = 76,
	[0][0][RTW89_WW][64] = 76,
	[0][0][RTW89_WW][66] = 76,
	[0][0][RTW89_WW][68] = 76,
	[0][0][RTW89_WW][70] = 76,
	[0][0][RTW89_WW][72] = 76,
	[0][0][RTW89_WW][74] = 76,
	[0][0][RTW89_WW][75] = 76,
	[0][0][RTW89_WW][77] = 76,
	[0][0][RTW89_WW][79] = 76,
	[0][0][RTW89_WW][81] = 76,
	[0][0][RTW89_WW][83] = 76,
	[0][0][RTW89_WW][85] = 76,
	[0][0][RTW89_WW][87] = 76,
	[0][0][RTW89_WW][89] = 76,
	[0][0][RTW89_WW][90] = 76,
	[0][0][RTW89_WW][92] = 76,
	[0][0][RTW89_WW][94] = 76,
	[0][0][RTW89_WW][96] = 76,
	[0][0][RTW89_WW][98] = 76,
	[0][0][RTW89_WW][100] = 76,
	[0][0][RTW89_WW][102] = 76,
	[0][0][RTW89_WW][104] = 76,
	[0][0][RTW89_WW][105] = 76,
	[0][0][RTW89_WW][107] = 76,
	[0][0][RTW89_WW][109] = 76,
	[0][0][RTW89_WW][111] = 0,
	[0][0][RTW89_WW][113] = 0,
	[0][0][RTW89_WW][115] = 0,
	[0][0][RTW89_WW][117] = 0,
	[0][0][RTW89_WW][119] = 0,
	[0][1][RTW89_WW][0] = 76,
	[0][1][RTW89_WW][2] = 76,
	[0][1][RTW89_WW][4] = 76,
	[0][1][RTW89_WW][6] = 76,
	[0][1][RTW89_WW][8] = 76,
	[0][1][RTW89_WW][10] = 76,
	[0][1][RTW89_WW][12] = 76,
	[0][1][RTW89_WW][14] = 76,
	[0][1][RTW89_WW][15] = 76,
	[0][1][RTW89_WW][17] = 76,
	[0][1][RTW89_WW][19] = 76,
	[0][1][RTW89_WW][21] = 76,
	[0][1][RTW89_WW][23] = 76,
	[0][1][RTW89_WW][25] = 76,
	[0][1][RTW89_WW][27] = 76,
	[0][1][RTW89_WW][29] = 76,
	[0][1][RTW89_WW][30] = 76,
	[0][1][RTW89_WW][32] = 76,
	[0][1][RTW89_WW][34] = 76,
	[0][1][RTW89_WW][36] = 76,
	[0][1][RTW89_WW][38] = 76,
	[0][1][RTW89_WW][40] = 76,
	[0][1][RTW89_WW][42] = 76,
	[0][1][RTW89_WW][44] = 76,
	[0][1][RTW89_WW][45] = 76,
	[0][1][RTW89_WW][47] = 76,
	[0][1][RTW89_WW][49] = 76,
	[0][1][RTW89_WW][51] = 76,
	[0][1][RTW89_WW][53] = 76,
	[0][1][RTW89_WW][55] = 76,
	[0][1][RTW89_WW][57] = 76,
	[0][1][RTW89_WW][59] = 76,
	[0][1][RTW89_WW][60] = 76,
	[0][1][RTW89_WW][62] = 76,
	[0][1][RTW89_WW][64] = 76,
	[0][1][RTW89_WW][66] = 76,
	[0][1][RTW89_WW][68] = 76,
	[0][1][RTW89_WW][70] = 76,
	[0][1][RTW89_WW][72] = 76,
	[0][1][RTW89_WW][74] = 76,
	[0][1][RTW89_WW][75] = 76,
	[0][1][RTW89_WW][77] = 76,
	[0][1][RTW89_WW][79] = 76,
	[0][1][RTW89_WW][81] = 76,
	[0][1][RTW89_WW][83] = 76,
	[0][1][RTW89_WW][85] = 76,
	[0][1][RTW89_WW][87] = 76,
	[0][1][RTW89_WW][89] = 76,
	[0][1][RTW89_WW][90] = 76,
	[0][1][RTW89_WW][92] = 76,
	[0][1][RTW89_WW][94] = 76,
	[0][1][RTW89_WW][96] = 76,
	[0][1][RTW89_WW][98] = 76,
	[0][1][RTW89_WW][100] = 76,
	[0][1][RTW89_WW][102] = 76,
	[0][1][RTW89_WW][104] = 76,
	[0][1][RTW89_WW][105] = 76,
	[0][1][RTW89_WW][107] = 76,
	[0][1][RTW89_WW][109] = 76,
	[0][1][RTW89_WW][111] = 0,
	[0][1][RTW89_WW][113] = 0,
	[0][1][RTW89_WW][115] = 0,
	[0][1][RTW89_WW][117] = 0,
	[0][1][RTW89_WW][119] = 0,
	[1][0][RTW89_WW][0] = 76,
	[1][0][RTW89_WW][2] = 76,
	[1][0][RTW89_WW][4] = 76,
	[1][0][RTW89_WW][6] = 76,
	[1][0][RTW89_WW][8] = 76,
	[1][0][RTW89_WW][10] = 76,
	[1][0][RTW89_WW][12] = 76,
	[1][0][RTW89_WW][14] = 76,
	[1][0][RTW89_WW][15] = 76,
	[1][0][RTW89_WW][17] = 76,
	[1][0][RTW89_WW][19] = 76,
	[1][0][RTW89_WW][21] = 76,
	[1][0][RTW89_WW][23] = 76,
	[1][0][RTW89_WW][25] = 76,
	[1][0][RTW89_WW][27] = 76,
	[1][0][RTW89_WW][29] = 76,
	[1][0][RTW89_WW][30] = 76,
	[1][0][RTW89_WW][32] = 76,
	[1][0][RTW89_WW][34] = 76,
	[1][0][RTW89_WW][36] = 76,
	[1][0][RTW89_WW][38] = 76,
	[1][0][RTW89_WW][40] = 76,
	[1][0][RTW89_WW][42] = 76,
	[1][0][RTW89_WW][44] = 76,
	[1][0][RTW89_WW][45] = 76,
	[1][0][RTW89_WW][47] = 76,
	[1][0][RTW89_WW][49] = 76,
	[1][0][RTW89_WW][51] = 76,
	[1][0][RTW89_WW][53] = 76,
	[1][0][RTW89_WW][55] = 76,
	[1][0][RTW89_WW][57] = 76,
	[1][0][RTW89_WW][59] = 76,
	[1][0][RTW89_WW][60] = 76,
	[1][0][RTW89_WW][62] = 76,
	[1][0][RTW89_WW][64] = 76,
	[1][0][RTW89_WW][66] = 76,
	[1][0][RTW89_WW][68] = 76,
	[1][0][RTW89_WW][70] = 76,
	[1][0][RTW89_WW][72] = 76,
	[1][0][RTW89_WW][74] = 76,
	[1][0][RTW89_WW][75] = 76,
	[1][0][RTW89_WW][77] = 76,
	[1][0][RTW89_WW][79] = 76,
	[1][0][RTW89_WW][81] = 76,
	[1][0][RTW89_WW][83] = 76,
	[1][0][RTW89_WW][85] = 76,
	[1][0][RTW89_WW][87] = 76,
	[1][0][RTW89_WW][89] = 76,
	[1][0][RTW89_WW][90] = 76,
	[1][0][RTW89_WW][92] = 76,
	[1][0][RTW89_WW][94] = 76,
	[1][0][RTW89_WW][96] = 76,
	[1][0][RTW89_WW][98] = 76,
	[1][0][RTW89_WW][100] = 76,
	[1][0][RTW89_WW][102] = 76,
	[1][0][RTW89_WW][104] = 76,
	[1][0][RTW89_WW][105] = 76,
	[1][0][RTW89_WW][107] = 76,
	[1][0][RTW89_WW][109] = 76,
	[1][0][RTW89_WW][111] = 0,
	[1][0][RTW89_WW][113] = 0,
	[1][0][RTW89_WW][115] = 0,
	[1][0][RTW89_WW][117] = 0,
	[1][0][RTW89_WW][119] = 0,
	[1][1][RTW89_WW][0] = 76,
	[1][1][RTW89_WW][2] = 76,
	[1][1][RTW89_WW][4] = 76,
	[1][1][RTW89_WW][6] = 76,
	[1][1][RTW89_WW][8] = 76,
	[1][1][RTW89_WW][10] = 76,
	[1][1][RTW89_WW][12] = 76,
	[1][1][RTW89_WW][14] = 76,
	[1][1][RTW89_WW][15] = 76,
	[1][1][RTW89_WW][17] = 76,
	[1][1][RTW89_WW][19] = 76,
	[1][1][RTW89_WW][21] = 76,
	[1][1][RTW89_WW][23] = 76,
	[1][1][RTW89_WW][25] = 76,
	[1][1][RTW89_WW][27] = 76,
	[1][1][RTW89_WW][29] = 76,
	[1][1][RTW89_WW][30] = 76,
	[1][1][RTW89_WW][32] = 76,
	[1][1][RTW89_WW][34] = 76,
	[1][1][RTW89_WW][36] = 76,
	[1][1][RTW89_WW][38] = 76,
	[1][1][RTW89_WW][40] = 76,
	[1][1][RTW89_WW][42] = 76,
	[1][1][RTW89_WW][44] = 76,
	[1][1][RTW89_WW][45] = 76,
	[1][1][RTW89_WW][47] = 76,
	[1][1][RTW89_WW][49] = 76,
	[1][1][RTW89_WW][51] = 76,
	[1][1][RTW89_WW][53] = 76,
	[1][1][RTW89_WW][55] = 76,
	[1][1][RTW89_WW][57] = 76,
	[1][1][RTW89_WW][59] = 76,
	[1][1][RTW89_WW][60] = 76,
	[1][1][RTW89_WW][62] = 76,
	[1][1][RTW89_WW][64] = 76,
	[1][1][RTW89_WW][66] = 76,
	[1][1][RTW89_WW][68] = 76,
	[1][1][RTW89_WW][70] = 76,
	[1][1][RTW89_WW][72] = 76,
	[1][1][RTW89_WW][74] = 76,
	[1][1][RTW89_WW][75] = 76,
	[1][1][RTW89_WW][77] = 76,
	[1][1][RTW89_WW][79] = 76,
	[1][1][RTW89_WW][81] = 76,
	[1][1][RTW89_WW][83] = 76,
	[1][1][RTW89_WW][85] = 76,
	[1][1][RTW89_WW][87] = 76,
	[1][1][RTW89_WW][89] = 76,
	[1][1][RTW89_WW][90] = 76,
	[1][1][RTW89_WW][92] = 76,
	[1][1][RTW89_WW][94] = 76,
	[1][1][RTW89_WW][96] = 76,
	[1][1][RTW89_WW][98] = 76,
	[1][1][RTW89_WW][100] = 76,
	[1][1][RTW89_WW][102] = 76,
	[1][1][RTW89_WW][104] = 76,
	[1][1][RTW89_WW][105] = 76,
	[1][1][RTW89_WW][107] = 76,
	[1][1][RTW89_WW][109] = 76,
	[1][1][RTW89_WW][111] = 0,
	[1][1][RTW89_WW][113] = 0,
	[1][1][RTW89_WW][115] = 0,
	[1][1][RTW89_WW][117] = 0,
	[1][1][RTW89_WW][119] = 0,
	[2][0][RTW89_WW][0] = 76,
	[2][0][RTW89_WW][2] = 76,
	[2][0][RTW89_WW][4] = 76,
	[2][0][RTW89_WW][6] = 76,
	[2][0][RTW89_WW][8] = 76,
	[2][0][RTW89_WW][10] = 76,
	[2][0][RTW89_WW][12] = 76,
	[2][0][RTW89_WW][14] = 76,
	[2][0][RTW89_WW][15] = 76,
	[2][0][RTW89_WW][17] = 76,
	[2][0][RTW89_WW][19] = 76,
	[2][0][RTW89_WW][21] = 76,
	[2][0][RTW89_WW][23] = 76,
	[2][0][RTW89_WW][25] = 76,
	[2][0][RTW89_WW][27] = 76,
	[2][0][RTW89_WW][29] = 76,
	[2][0][RTW89_WW][30] = 76,
	[2][0][RTW89_WW][32] = 76,
	[2][0][RTW89_WW][34] = 76,
	[2][0][RTW89_WW][36] = 76,
	[2][0][RTW89_WW][38] = 76,
	[2][0][RTW89_WW][40] = 76,
	[2][0][RTW89_WW][42] = 76,
	[2][0][RTW89_WW][44] = 76,
	[2][0][RTW89_WW][45] = 76,
	[2][0][RTW89_WW][47] = 76,
	[2][0][RTW89_WW][49] = 76,
	[2][0][RTW89_WW][51] = 76,
	[2][0][RTW89_WW][53] = 76,
	[2][0][RTW89_WW][55] = 76,
	[2][0][RTW89_WW][57] = 76,
	[2][0][RTW89_WW][59] = 76,
	[2][0][RTW89_WW][60] = 76,
	[2][0][RTW89_WW][62] = 76,
	[2][0][RTW89_WW][64] = 76,
	[2][0][RTW89_WW][66] = 76,
	[2][0][RTW89_WW][68] = 76,
	[2][0][RTW89_WW][70] = 76,
	[2][0][RTW89_WW][72] = 76,
	[2][0][RTW89_WW][74] = 76,
	[2][0][RTW89_WW][75] = 76,
	[2][0][RTW89_WW][77] = 76,
	[2][0][RTW89_WW][79] = 76,
	[2][0][RTW89_WW][81] = 76,
	[2][0][RTW89_WW][83] = 76,
	[2][0][RTW89_WW][85] = 76,
	[2][0][RTW89_WW][87] = 76,
	[2][0][RTW89_WW][89] = 76,
	[2][0][RTW89_WW][90] = 76,
	[2][0][RTW89_WW][92] = 76,
	[2][0][RTW89_WW][94] = 76,
	[2][0][RTW89_WW][96] = 76,
	[2][0][RTW89_WW][98] = 76,
	[2][0][RTW89_WW][100] = 76,
	[2][0][RTW89_WW][102] = 76,
	[2][0][RTW89_WW][104] = 76,
	[2][0][RTW89_WW][105] = 76,
	[2][0][RTW89_WW][107] = 76,
	[2][0][RTW89_WW][109] = 76,
	[2][0][RTW89_WW][111] = 0,
	[2][0][RTW89_WW][113] = 0,
	[2][0][RTW89_WW][115] = 0,
	[2][0][RTW89_WW][117] = 0,
	[2][0][RTW89_WW][119] = 0,
	[2][1][RTW89_WW][0] = 76,
	[2][1][RTW89_WW][2] = 76,
	[2][1][RTW89_WW][4] = 76,
	[2][1][RTW89_WW][6] = 76,
	[2][1][RTW89_WW][8] = 76,
	[2][1][RTW89_WW][10] = 76,
	[2][1][RTW89_WW][12] = 76,
	[2][1][RTW89_WW][14] = 76,
	[2][1][RTW89_WW][15] = 76,
	[2][1][RTW89_WW][17] = 76,
	[2][1][RTW89_WW][19] = 76,
	[2][1][RTW89_WW][21] = 76,
	[2][1][RTW89_WW][23] = 76,
	[2][1][RTW89_WW][25] = 76,
	[2][1][RTW89_WW][27] = 76,
	[2][1][RTW89_WW][29] = 76,
	[2][1][RTW89_WW][30] = 76,
	[2][1][RTW89_WW][32] = 76,
	[2][1][RTW89_WW][34] = 76,
	[2][1][RTW89_WW][36] = 76,
	[2][1][RTW89_WW][38] = 76,
	[2][1][RTW89_WW][40] = 76,
	[2][1][RTW89_WW][42] = 76,
	[2][1][RTW89_WW][44] = 76,
	[2][1][RTW89_WW][45] = 76,
	[2][1][RTW89_WW][47] = 76,
	[2][1][RTW89_WW][49] = 76,
	[2][1][RTW89_WW][51] = 76,
	[2][1][RTW89_WW][53] = 76,
	[2][1][RTW89_WW][55] = 76,
	[2][1][RTW89_WW][57] = 76,
	[2][1][RTW89_WW][59] = 76,
	[2][1][RTW89_WW][60] = 76,
	[2][1][RTW89_WW][62] = 76,
	[2][1][RTW89_WW][64] = 76,
	[2][1][RTW89_WW][66] = 76,
	[2][1][RTW89_WW][68] = 76,
	[2][1][RTW89_WW][70] = 76,
	[2][1][RTW89_WW][72] = 76,
	[2][1][RTW89_WW][74] = 76,
	[2][1][RTW89_WW][75] = 76,
	[2][1][RTW89_WW][77] = 76,
	[2][1][RTW89_WW][79] = 76,
	[2][1][RTW89_WW][81] = 76,
	[2][1][RTW89_WW][83] = 76,
	[2][1][RTW89_WW][85] = 76,
	[2][1][RTW89_WW][87] = 76,
	[2][1][RTW89_WW][89] = 76,
	[2][1][RTW89_WW][90] = 76,
	[2][1][RTW89_WW][92] = 76,
	[2][1][RTW89_WW][94] = 76,
	[2][1][RTW89_WW][96] = 76,
	[2][1][RTW89_WW][98] = 76,
	[2][1][RTW89_WW][100] = 76,
	[2][1][RTW89_WW][102] = 76,
	[2][1][RTW89_WW][104] = 76,
	[2][1][RTW89_WW][105] = 76,
	[2][1][RTW89_WW][107] = 76,
	[2][1][RTW89_WW][109] = 76,
	[2][1][RTW89_WW][111] = 0,
	[2][1][RTW89_WW][113] = 0,
	[2][1][RTW89_WW][115] = 0,
	[2][1][RTW89_WW][117] = 0,
	[2][1][RTW89_WW][119] = 0,
	[0][0][RTW89_FCC][0] = 76,
	[0][0][RTW89_FCC][2] = 76,
	[0][0][RTW89_FCC][4] = 76,
	[0][0][RTW89_FCC][6] = 76,
	[0][0][RTW89_FCC][8] = 76,
	[0][0][RTW89_FCC][10] = 76,
	[0][0][RTW89_FCC][12] = 76,
	[0][0][RTW89_FCC][14] = 76,
	[0][0][RTW89_FCC][15] = 76,
	[0][0][RTW89_FCC][17] = 76,
	[0][0][RTW89_FCC][19] = 76,
	[0][0][RTW89_FCC][21] = 76,
	[0][0][RTW89_FCC][23] = 76,
	[0][0][RTW89_FCC][25] = 76,
	[0][0][RTW89_FCC][27] = 76,
	[0][0][RTW89_FCC][29] = 76,
	[0][0][RTW89_FCC][30] = 76,
	[0][0][RTW89_FCC][32] = 76,
	[0][0][RTW89_FCC][34] = 76,
	[0][0][RTW89_FCC][36] = 76,
	[0][0][RTW89_FCC][38] = 76,
	[0][0][RTW89_FCC][40] = 76,
	[0][0][RTW89_FCC][42] = 76,
	[0][0][RTW89_FCC][44] = 76,
	[0][0][RTW89_FCC][45] = 76,
	[0][0][RTW89_FCC][47] = 76,
	[0][0][RTW89_FCC][49] = 76,
	[0][0][RTW89_FCC][51] = 76,
	[0][0][RTW89_FCC][53] = 76,
	[0][0][RTW89_FCC][55] = 76,
	[0][0][RTW89_FCC][57] = 76,
	[0][0][RTW89_FCC][59] = 76,
	[0][0][RTW89_FCC][60] = 76,
	[0][0][RTW89_FCC][62] = 76,
	[0][0][RTW89_FCC][64] = 76,
	[0][0][RTW89_FCC][66] = 76,
	[0][0][RTW89_FCC][68] = 76,
	[0][0][RTW89_FCC][70] = 76,
	[0][0][RTW89_FCC][72] = 76,
	[0][0][RTW89_FCC][74] = 76,
	[0][0][RTW89_FCC][75] = 76,
	[0][0][RTW89_FCC][77] = 76,
	[0][0][RTW89_FCC][79] = 76,
	[0][0][RTW89_FCC][81] = 76,
	[0][0][RTW89_FCC][83] = 76,
	[0][0][RTW89_FCC][85] = 76,
	[0][0][RTW89_FCC][87] = 76,
	[0][0][RTW89_FCC][89] = 76,
	[0][0][RTW89_FCC][90] = 76,
	[0][0][RTW89_FCC][92] = 76,
	[0][0][RTW89_FCC][94] = 76,
	[0][0][RTW89_FCC][96] = 76,
	[0][0][RTW89_FCC][98] = 76,
	[0][0][RTW89_FCC][100] = 76,
	[0][0][RTW89_FCC][102] = 76,
	[0][0][RTW89_FCC][104] = 76,
	[0][0][RTW89_FCC][105] = 76,
	[0][0][RTW89_FCC][107] = 76,
	[0][0][RTW89_FCC][109] = 76,
	[0][0][RTW89_FCC][111] = 127,
	[0][0][RTW89_FCC][113] = 127,
	[0][0][RTW89_FCC][115] = 127,
	[0][0][RTW89_FCC][117] = 127,
	[0][0][RTW89_FCC][119] = 127,
	[0][1][RTW89_FCC][0] = 76,
	[0][1][RTW89_FCC][2] = 76,
	[0][1][RTW89_FCC][4] = 76,
	[0][1][RTW89_FCC][6] = 76,
	[0][1][RTW89_FCC][8] = 76,
	[0][1][RTW89_FCC][10] = 76,
	[0][1][RTW89_FCC][12] = 76,
	[0][1][RTW89_FCC][14] = 76,
	[0][1][RTW89_FCC][15] = 76,
	[0][1][RTW89_FCC][17] = 76,
	[0][1][RTW89_FCC][19] = 76,
	[0][1][RTW89_FCC][21] = 76,
	[0][1][RTW89_FCC][23] = 76,
	[0][1][RTW89_FCC][25] = 76,
	[0][1][RTW89_FCC][27] = 76,
	[0][1][RTW89_FCC][29] = 76,
	[0][1][RTW89_FCC][30] = 76,
	[0][1][RTW89_FCC][32] = 76,
	[0][1][RTW89_FCC][34] = 76,
	[0][1][RTW89_FCC][36] = 76,
	[0][1][RTW89_FCC][38] = 76,
	[0][1][RTW89_FCC][40] = 76,
	[0][1][RTW89_FCC][42] = 76,
	[0][1][RTW89_FCC][44] = 76,
	[0][1][RTW89_FCC][45] = 76,
	[0][1][RTW89_FCC][47] = 76,
	[0][1][RTW89_FCC][49] = 76,
	[0][1][RTW89_FCC][51] = 76,
	[0][1][RTW89_FCC][53] = 76,
	[0][1][RTW89_FCC][55] = 76,
	[0][1][RTW89_FCC][57] = 76,
	[0][1][RTW89_FCC][59] = 76,
	[0][1][RTW89_FCC][60] = 76,
	[0][1][RTW89_FCC][62] = 76,
	[0][1][RTW89_FCC][64] = 76,
	[0][1][RTW89_FCC][66] = 76,
	[0][1][RTW89_FCC][68] = 76,
	[0][1][RTW89_FCC][70] = 76,
	[0][1][RTW89_FCC][72] = 76,
	[0][1][RTW89_FCC][74] = 76,
	[0][1][RTW89_FCC][75] = 76,
	[0][1][RTW89_FCC][77] = 76,
	[0][1][RTW89_FCC][79] = 76,
	[0][1][RTW89_FCC][81] = 76,
	[0][1][RTW89_FCC][83] = 76,
	[0][1][RTW89_FCC][85] = 76,
	[0][1][RTW89_FCC][87] = 76,
	[0][1][RTW89_FCC][89] = 76,
	[0][1][RTW89_FCC][90] = 76,
	[0][1][RTW89_FCC][92] = 76,
	[0][1][RTW89_FCC][94] = 76,
	[0][1][RTW89_FCC][96] = 76,
	[0][1][RTW89_FCC][98] = 76,
	[0][1][RTW89_FCC][100] = 76,
	[0][1][RTW89_FCC][102] = 76,
	[0][1][RTW89_FCC][104] = 76,
	[0][1][RTW89_FCC][105] = 76,
	[0][1][RTW89_FCC][107] = 76,
	[0][1][RTW89_FCC][109] = 76,
	[0][1][RTW89_FCC][111] = 127,
	[0][1][RTW89_FCC][113] = 127,
	[0][1][RTW89_FCC][115] = 127,
	[0][1][RTW89_FCC][117] = 127,
	[0][1][RTW89_FCC][119] = 127,
	[1][0][RTW89_FCC][0] = 76,
	[1][0][RTW89_FCC][2] = 76,
	[1][0][RTW89_FCC][4] = 76,
	[1][0][RTW89_FCC][6] = 76,
	[1][0][RTW89_FCC][8] = 76,
	[1][0][RTW89_FCC][10] = 76,
	[1][0][RTW89_FCC][12] = 76,
	[1][0][RTW89_FCC][14] = 76,
	[1][0][RTW89_FCC][15] = 76,
	[1][0][RTW89_FCC][17] = 76,
	[1][0][RTW89_FCC][19] = 76,
	[1][0][RTW89_FCC][21] = 76,
	[1][0][RTW89_FCC][23] = 76,
	[1][0][RTW89_FCC][25] = 76,
	[1][0][RTW89_FCC][27] = 76,
	[1][0][RTW89_FCC][29] = 76,
	[1][0][RTW89_FCC][30] = 76,
	[1][0][RTW89_FCC][32] = 76,
	[1][0][RTW89_FCC][34] = 76,
	[1][0][RTW89_FCC][36] = 76,
	[1][0][RTW89_FCC][38] = 76,
	[1][0][RTW89_FCC][40] = 76,
	[1][0][RTW89_FCC][42] = 76,
	[1][0][RTW89_FCC][44] = 76,
	[1][0][RTW89_FCC][45] = 76,
	[1][0][RTW89_FCC][47] = 76,
	[1][0][RTW89_FCC][49] = 76,
	[1][0][RTW89_FCC][51] = 76,
	[1][0][RTW89_FCC][53] = 76,
	[1][0][RTW89_FCC][55] = 76,
	[1][0][RTW89_FCC][57] = 76,
	[1][0][RTW89_FCC][59] = 76,
	[1][0][RTW89_FCC][60] = 76,
	[1][0][RTW89_FCC][62] = 76,
	[1][0][RTW89_FCC][64] = 76,
	[1][0][RTW89_FCC][66] = 76,
	[1][0][RTW89_FCC][68] = 76,
	[1][0][RTW89_FCC][70] = 76,
	[1][0][RTW89_FCC][72] = 76,
	[1][0][RTW89_FCC][74] = 76,
	[1][0][RTW89_FCC][75] = 76,
	[1][0][RTW89_FCC][77] = 76,
	[1][0][RTW89_FCC][79] = 76,
	[1][0][RTW89_FCC][81] = 76,
	[1][0][RTW89_FCC][83] = 76,
	[1][0][RTW89_FCC][85] = 76,
	[1][0][RTW89_FCC][87] = 76,
	[1][0][RTW89_FCC][89] = 76,
	[1][0][RTW89_FCC][90] = 76,
	[1][0][RTW89_FCC][92] = 76,
	[1][0][RTW89_FCC][94] = 76,
	[1][0][RTW89_FCC][96] = 76,
	[1][0][RTW89_FCC][98] = 76,
	[1][0][RTW89_FCC][100] = 76,
	[1][0][RTW89_FCC][102] = 76,
	[1][0][RTW89_FCC][104] = 76,
	[1][0][RTW89_FCC][105] = 76,
	[1][0][RTW89_FCC][107] = 76,
	[1][0][RTW89_FCC][109] = 76,
	[1][0][RTW89_FCC][111] = 127,
	[1][0][RTW89_FCC][113] = 127,
	[1][0][RTW89_FCC][115] = 127,
	[1][0][RTW89_FCC][117] = 127,
	[1][0][RTW89_FCC][119] = 127,
	[1][1][RTW89_FCC][0] = 76,
	[1][1][RTW89_FCC][2] = 76,
	[1][1][RTW89_FCC][4] = 76,
	[1][1][RTW89_FCC][6] = 76,
	[1][1][RTW89_FCC][8] = 76,
	[1][1][RTW89_FCC][10] = 76,
	[1][1][RTW89_FCC][12] = 76,
	[1][1][RTW89_FCC][14] = 76,
	[1][1][RTW89_FCC][15] = 76,
	[1][1][RTW89_FCC][17] = 76,
	[1][1][RTW89_FCC][19] = 76,
	[1][1][RTW89_FCC][21] = 76,
	[1][1][RTW89_FCC][23] = 76,
	[1][1][RTW89_FCC][25] = 76,
	[1][1][RTW89_FCC][27] = 76,
	[1][1][RTW89_FCC][29] = 76,
	[1][1][RTW89_FCC][30] = 76,
	[1][1][RTW89_FCC][32] = 76,
	[1][1][RTW89_FCC][34] = 76,
	[1][1][RTW89_FCC][36] = 76,
	[1][1][RTW89_FCC][38] = 76,
	[1][1][RTW89_FCC][40] = 76,
	[1][1][RTW89_FCC][42] = 76,
	[1][1][RTW89_FCC][44] = 76,
	[1][1][RTW89_FCC][45] = 76,
	[1][1][RTW89_FCC][47] = 76,
	[1][1][RTW89_FCC][49] = 76,
	[1][1][RTW89_FCC][51] = 76,
	[1][1][RTW89_FCC][53] = 76,
	[1][1][RTW89_FCC][55] = 76,
	[1][1][RTW89_FCC][57] = 76,
	[1][1][RTW89_FCC][59] = 76,
	[1][1][RTW89_FCC][60] = 76,
	[1][1][RTW89_FCC][62] = 76,
	[1][1][RTW89_FCC][64] = 76,
	[1][1][RTW89_FCC][66] = 76,
	[1][1][RTW89_FCC][68] = 76,
	[1][1][RTW89_FCC][70] = 76,
	[1][1][RTW89_FCC][72] = 76,
	[1][1][RTW89_FCC][74] = 76,
	[1][1][RTW89_FCC][75] = 76,
	[1][1][RTW89_FCC][77] = 76,
	[1][1][RTW89_FCC][79] = 76,
	[1][1][RTW89_FCC][81] = 76,
	[1][1][RTW89_FCC][83] = 76,
	[1][1][RTW89_FCC][85] = 76,
	[1][1][RTW89_FCC][87] = 76,
	[1][1][RTW89_FCC][89] = 76,
	[1][1][RTW89_FCC][90] = 76,
	[1][1][RTW89_FCC][92] = 76,
	[1][1][RTW89_FCC][94] = 76,
	[1][1][RTW89_FCC][96] = 76,
	[1][1][RTW89_FCC][98] = 76,
	[1][1][RTW89_FCC][100] = 76,
	[1][1][RTW89_FCC][102] = 76,
	[1][1][RTW89_FCC][104] = 76,
	[1][1][RTW89_FCC][105] = 76,
	[1][1][RTW89_FCC][107] = 76,
	[1][1][RTW89_FCC][109] = 76,
	[1][1][RTW89_FCC][111] = 127,
	[1][1][RTW89_FCC][113] = 127,
	[1][1][RTW89_FCC][115] = 127,
	[1][1][RTW89_FCC][117] = 127,
	[1][1][RTW89_FCC][119] = 127,
	[2][0][RTW89_FCC][0] = 76,
	[2][0][RTW89_FCC][2] = 76,
	[2][0][RTW89_FCC][4] = 76,
	[2][0][RTW89_FCC][6] = 76,
	[2][0][RTW89_FCC][8] = 76,
	[2][0][RTW89_FCC][10] = 76,
	[2][0][RTW89_FCC][12] = 76,
	[2][0][RTW89_FCC][14] = 76,
	[2][0][RTW89_FCC][15] = 76,
	[2][0][RTW89_FCC][17] = 76,
	[2][0][RTW89_FCC][19] = 76,
	[2][0][RTW89_FCC][21] = 76,
	[2][0][RTW89_FCC][23] = 76,
	[2][0][RTW89_FCC][25] = 76,
	[2][0][RTW89_FCC][27] = 76,
	[2][0][RTW89_FCC][29] = 76,
	[2][0][RTW89_FCC][30] = 76,
	[2][0][RTW89_FCC][32] = 76,
	[2][0][RTW89_FCC][34] = 76,
	[2][0][RTW89_FCC][36] = 76,
	[2][0][RTW89_FCC][38] = 76,
	[2][0][RTW89_FCC][40] = 76,
	[2][0][RTW89_FCC][42] = 76,
	[2][0][RTW89_FCC][44] = 76,
	[2][0][RTW89_FCC][45] = 76,
	[2][0][RTW89_FCC][47] = 76,
	[2][0][RTW89_FCC][49] = 76,
	[2][0][RTW89_FCC][51] = 76,
	[2][0][RTW89_FCC][53] = 76,
	[2][0][RTW89_FCC][55] = 76,
	[2][0][RTW89_FCC][57] = 76,
	[2][0][RTW89_FCC][59] = 76,
	[2][0][RTW89_FCC][60] = 76,
	[2][0][RTW89_FCC][62] = 76,
	[2][0][RTW89_FCC][64] = 76,
	[2][0][RTW89_FCC][66] = 76,
	[2][0][RTW89_FCC][68] = 76,
	[2][0][RTW89_FCC][70] = 76,
	[2][0][RTW89_FCC][72] = 76,
	[2][0][RTW89_FCC][74] = 76,
	[2][0][RTW89_FCC][75] = 76,
	[2][0][RTW89_FCC][77] = 76,
	[2][0][RTW89_FCC][79] = 76,
	[2][0][RTW89_FCC][81] = 76,
	[2][0][RTW89_FCC][83] = 76,
	[2][0][RTW89_FCC][85] = 76,
	[2][0][RTW89_FCC][87] = 76,
	[2][0][RTW89_FCC][89] = 76,
	[2][0][RTW89_FCC][90] = 76,
	[2][0][RTW89_FCC][92] = 76,
	[2][0][RTW89_FCC][94] = 76,
	[2][0][RTW89_FCC][96] = 76,
	[2][0][RTW89_FCC][98] = 76,
	[2][0][RTW89_FCC][100] = 76,
	[2][0][RTW89_FCC][102] = 76,
	[2][0][RTW89_FCC][104] = 76,
	[2][0][RTW89_FCC][105] = 76,
	[2][0][RTW89_FCC][107] = 76,
	[2][0][RTW89_FCC][109] = 76,
	[2][0][RTW89_FCC][111] = 127,
	[2][0][RTW89_FCC][113] = 127,
	[2][0][RTW89_FCC][115] = 127,
	[2][0][RTW89_FCC][117] = 127,
	[2][0][RTW89_FCC][119] = 127,
	[2][1][RTW89_FCC][0] = 76,
	[2][1][RTW89_FCC][2] = 76,
	[2][1][RTW89_FCC][4] = 76,
	[2][1][RTW89_FCC][6] = 76,
	[2][1][RTW89_FCC][8] = 76,
	[2][1][RTW89_FCC][10] = 76,
	[2][1][RTW89_FCC][12] = 76,
	[2][1][RTW89_FCC][14] = 76,
	[2][1][RTW89_FCC][15] = 76,
	[2][1][RTW89_FCC][17] = 76,
	[2][1][RTW89_FCC][19] = 76,
	[2][1][RTW89_FCC][21] = 76,
	[2][1][RTW89_FCC][23] = 76,
	[2][1][RTW89_FCC][25] = 76,
	[2][1][RTW89_FCC][27] = 76,
	[2][1][RTW89_FCC][29] = 76,
	[2][1][RTW89_FCC][30] = 76,
	[2][1][RTW89_FCC][32] = 76,
	[2][1][RTW89_FCC][34] = 76,
	[2][1][RTW89_FCC][36] = 76,
	[2][1][RTW89_FCC][38] = 76,
	[2][1][RTW89_FCC][40] = 76,
	[2][1][RTW89_FCC][42] = 76,
	[2][1][RTW89_FCC][44] = 76,
	[2][1][RTW89_FCC][45] = 76,
	[2][1][RTW89_FCC][47] = 76,
	[2][1][RTW89_FCC][49] = 76,
	[2][1][RTW89_FCC][51] = 76,
	[2][1][RTW89_FCC][53] = 76,
	[2][1][RTW89_FCC][55] = 76,
	[2][1][RTW89_FCC][57] = 76,
	[2][1][RTW89_FCC][59] = 76,
	[2][1][RTW89_FCC][60] = 76,
	[2][1][RTW89_FCC][62] = 76,
	[2][1][RTW89_FCC][64] = 76,
	[2][1][RTW89_FCC][66] = 76,
	[2][1][RTW89_FCC][68] = 76,
	[2][1][RTW89_FCC][70] = 76,
	[2][1][RTW89_FCC][72] = 76,
	[2][1][RTW89_FCC][74] = 76,
	[2][1][RTW89_FCC][75] = 76,
	[2][1][RTW89_FCC][77] = 76,
	[2][1][RTW89_FCC][79] = 76,
	[2][1][RTW89_FCC][81] = 76,
	[2][1][RTW89_FCC][83] = 76,
	[2][1][RTW89_FCC][85] = 76,
	[2][1][RTW89_FCC][87] = 76,
	[2][1][RTW89_FCC][89] = 76,
	[2][1][RTW89_FCC][90] = 76,
	[2][1][RTW89_FCC][92] = 76,
	[2][1][RTW89_FCC][94] = 76,
	[2][1][RTW89_FCC][96] = 76,
	[2][1][RTW89_FCC][98] = 76,
	[2][1][RTW89_FCC][100] = 76,
	[2][1][RTW89_FCC][102] = 76,
	[2][1][RTW89_FCC][104] = 76,
	[2][1][RTW89_FCC][105] = 76,
	[2][1][RTW89_FCC][107] = 76,
	[2][1][RTW89_FCC][109] = 76,
	[2][1][RTW89_FCC][111] = 127,
	[2][1][RTW89_FCC][113] = 127,
	[2][1][RTW89_FCC][115] = 127,
	[2][1][RTW89_FCC][117] = 127,
	[2][1][RTW89_FCC][119] = 127,
};

const struct rtw89_phy_table rtw89_8852c_phy_bb_table = {
	.regs		= rtw89_8852c_phy_bb_regs,
	.n_regs		= ARRAY_SIZE(rtw89_8852c_phy_bb_regs),
	.rf_path	= 0, /* don't care */
};

const struct rtw89_phy_table rtw89_8852c_phy_bb_gain_table = {
	.regs		= rtw89_8852c_phy_bb_reg_gain,
	.n_regs		= ARRAY_SIZE(rtw89_8852c_phy_bb_reg_gain),
	.rf_path	= 0, /* don't care */
};

const struct rtw89_phy_table rtw89_8852c_phy_radioa_table = {
	.regs		= rtw89_8852c_phy_radioa_regs,
	.n_regs		= ARRAY_SIZE(rtw89_8852c_phy_radioa_regs),
	.rf_path	= RF_PATH_A,
	.config		= rtw89_phy_config_rf_reg_v1,
};

const struct rtw89_phy_table rtw89_8852c_phy_radiob_table = {
	.regs		= rtw89_8852c_phy_radiob_regs,
	.n_regs		= ARRAY_SIZE(rtw89_8852c_phy_radiob_regs),
	.rf_path	= RF_PATH_B,
	.config		= rtw89_phy_config_rf_reg_v1,
};

const struct rtw89_phy_table rtw89_8852c_phy_nctl_table = {
	.regs		= rtw89_8852c_phy_nctl_regs,
	.n_regs		= ARRAY_SIZE(rtw89_8852c_phy_nctl_regs),
	.rf_path	= 0, /* don't care */
};

const struct rtw89_txpwr_table rtw89_8852c_byr_table = {
	.data = rtw89_8852c_txpwr_byrate,
	.size = ARRAY_SIZE(rtw89_8852c_txpwr_byrate),
	.load = rtw89_phy_load_txpwr_byrate,
};

const struct rtw89_txpwr_track_cfg rtw89_8852c_trk_cfg = {
	.delta_swingidx_6gb_n = _txpwr_track_delta_swingidx_6gb_n,
	.delta_swingidx_6gb_p = _txpwr_track_delta_swingidx_6gb_p,
	.delta_swingidx_6ga_n = _txpwr_track_delta_swingidx_6ga_n,
	.delta_swingidx_6ga_p = _txpwr_track_delta_swingidx_6ga_p,
	.delta_swingidx_5gb_n = _txpwr_track_delta_swingidx_5gb_n,
	.delta_swingidx_5gb_p = _txpwr_track_delta_swingidx_5gb_p,
	.delta_swingidx_5ga_n = _txpwr_track_delta_swingidx_5ga_n,
	.delta_swingidx_5ga_p = _txpwr_track_delta_swingidx_5ga_p,
	.delta_swingidx_2gb_n = _txpwr_track_delta_swingidx_2gb_n,
	.delta_swingidx_2gb_p = _txpwr_track_delta_swingidx_2gb_p,
	.delta_swingidx_2ga_n = _txpwr_track_delta_swingidx_2ga_n,
	.delta_swingidx_2ga_p = _txpwr_track_delta_swingidx_2ga_p,
	.delta_swingidx_2g_cck_b_n = _txpwr_track_delta_swingidx_2g_cck_b_n,
	.delta_swingidx_2g_cck_b_p = _txpwr_track_delta_swingidx_2g_cck_b_p,
	.delta_swingidx_2g_cck_a_n = _txpwr_track_delta_swingidx_2g_cck_a_n,
	.delta_swingidx_2g_cck_a_p = _txpwr_track_delta_swingidx_2g_cck_a_p,
};

const struct rtw89_phy_tssi_dbw_table rtw89_8852c_tssi_dbw_table = {
	.data[RTW89_TSSI_BANDEDGE_FLAT] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	.data[RTW89_TSSI_BANDEDGE_LOW] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	.data[RTW89_TSSI_BANDEDGE_MID] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	.data[RTW89_TSSI_BANDEDGE_HIGH] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};
