/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGTextElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.svg12.SVG12TextElementBridge;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.ComputedValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.apache.batik.css.engine.value.svg12.LineHeightValue;
import org.apache.batik.css.engine.value.svg12.SVG12ValueConstants;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg12.SVGOMFlowRegionElement;
import org.apache.batik.dom.svg12.XBLEventSupport;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.flow.BlockInfo;
import org.apache.batik.gvt.flow.FlowTextNode;
import org.apache.batik.gvt.flow.RegionInfo;
import org.apache.batik.gvt.flow.TextLineBreaks;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextPath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class SVGFlowRootElementBridge
extends SVG12TextElementBridge {
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_EMPTY_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_EMPTY_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute LINE_HEIGHT = GVTAttributedCharacterIterator.TextAttribute.LINE_HEIGHT;
    public static final GVTAttributedCharacterIterator.TextAttribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    public static final GVTAttributedCharacterIterator.TextAttribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    public static final GVTAttributedCharacterIterator.TextAttribute LETTER_SPACING = GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING;
    public static final GVTAttributedCharacterIterator.TextAttribute WORD_SPACING = GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING;
    public static final GVTAttributedCharacterIterator.TextAttribute KERNING = GVTAttributedCharacterIterator.TextAttribute.KERNING;
    protected Map flowRegionNodes;
    protected RegionChangeListener regionChangeListener;
    protected int startLen;
    int marginTopIndex = -1;
    int marginRightIndex = -1;
    int marginBottomIndex = -1;
    int marginLeftIndex = -1;
    int indentIndex = -1;
    int textAlignIndex = -1;
    int lineHeightIndex = -1;

    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    public String getLocalName() {
        return "flowRoot";
    }

    public Bridge getInstance() {
        return new SVGFlowRootElementBridge();
    }

    public boolean isComposite() {
        return false;
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
        String string = element.getAttributeNS(null, "transform");
        if (string.length() != 0) {
            compositeGraphicsNode.setTransform(SVGUtilities.convertTransform(element, "transform", string));
        }
        compositeGraphicsNode.setVisible(CSSUtilities.convertVisibility(element));
        RenderingHints renderingHints = null;
        renderingHints = CSSUtilities.convertColorRendering(element, renderingHints);
        renderingHints = CSSUtilities.convertTextRendering(element, renderingHints);
        if (renderingHints != null) {
            compositeGraphicsNode.setRenderingHints(renderingHints);
        }
        CompositeGraphicsNode compositeGraphicsNode2 = new CompositeGraphicsNode();
        compositeGraphicsNode.add((Object)compositeGraphicsNode2);
        FlowTextNode flowTextNode = (FlowTextNode)this.instantiateGraphicsNode();
        flowTextNode.setLocation(this.getLocation(bridgeContext, element));
        if (bridgeContext.getTextPainter() != null) {
            flowTextNode.setTextPainter(bridgeContext.getTextPainter());
        }
        compositeGraphicsNode.add((Object)flowTextNode);
        return compositeGraphicsNode;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new FlowTextNode();
    }

    protected Point2D getLocation(BridgeContext bridgeContext, Element element) {
        return new Point2D.Float(0.0f, 0.0f);
    }

    protected boolean isTextElement(Element element) {
        if (!"http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            return false;
        }
        String string = element.getLocalName();
        return string.equals("flowDiv") || string.equals("flowLine") || string.equals("flowPara") || string.equals("flowRegionBreak") || string.equals("flowSpan");
    }

    protected boolean isTextChild(Element element) {
        if (!"http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            return false;
        }
        String string = element.getLocalName();
        return string.equals("a") || string.equals("flowLine") || string.equals("flowPara") || string.equals("flowRegionBreak") || string.equals("flowSpan");
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        boolean bl;
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)graphicsNode;
        boolean bl2 = bl = !bridgeContext.isDynamic();
        if (bl) {
            this.flowRegionNodes = new HashMap();
        } else {
            this.regionChangeListener = new RegionChangeListener();
        }
        CompositeGraphicsNode compositeGraphicsNode2 = (CompositeGraphicsNode)compositeGraphicsNode.get(0);
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        Node node = this.getFirstChild(element);
        while (node != null) {
            if (node instanceof SVGOMFlowRegionElement) {
                XBLEventSupport xBLEventSupport;
                Node node2 = this.getFirstChild(node);
                while (node2 != null) {
                    if (node2.getNodeType() == 1 && (xBLEventSupport = gVTBuilder.build(bridgeContext, (Element)node2)) != null) {
                        compositeGraphicsNode2.add((Object)xBLEventSupport);
                        if (bl) {
                            this.flowRegionNodes.put(node2, xBLEventSupport);
                        }
                    }
                    node2 = this.getNextSibling(node2);
                }
                if (!bl) {
                    node2 = (AbstractNode)node;
                    xBLEventSupport = (XBLEventSupport)node2.initializeEventSupport();
                    xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2000/svg", "shapechange", (EventListener)this.regionChangeListener, false);
                }
            }
            node = this.getNextSibling(node);
        }
        node = (GraphicsNode)compositeGraphicsNode.get(1);
        super.buildGraphicsNode(bridgeContext, element, (GraphicsNode)node);
        this.flowRegionNodes = null;
    }

    protected void computeLaidoutText(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        super.computeLaidoutText(bridgeContext, this.getFlowDivElement(element), graphicsNode);
    }

    protected void addContextToChild(BridgeContext bridgeContext, Element element) {
        String string;
        if ("http://www.w3.org/2000/svg".equals(element.getNamespaceURI()) && ((string = element.getLocalName()).equals("flowDiv") || string.equals("flowLine") || string.equals("flowPara") || string.equals("flowSpan"))) {
            ((SVGOMElement)element).setSVGContext((SVGContext)new FlowContentBridge(bridgeContext, (SVGTextElementBridge)this, element));
        }
        super.addContextToChild(bridgeContext, element);
    }

    protected AttributedString buildAttributedString(BridgeContext bridgeContext, Element element) {
        if (element == null) {
            return null;
        }
        List list = this.getRegions(bridgeContext, element);
        AttributedString attributedString = this.getFlowDiv(bridgeContext, element);
        if (attributedString == null) {
            return attributedString;
        }
        attributedString.addAttribute(FLOW_REGIONS, list, 0, 1);
        TextLineBreaks.findLineBrk((AttributedString)attributedString);
        return attributedString;
    }

    protected void dumpACIWord(AttributedString attributedString) {
        if (attributedString == null) {
            return;
        }
        String string = "";
        String string2 = "";
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        AttributedCharacterIterator.Attribute attribute = TextLineBreaks.WORD_LIMIT;
        char c = attributedCharacterIterator.current();
        while (c != '\uffff') {
            string = string + c + "  ";
            int n = (Integer)attributedCharacterIterator.getAttribute(attribute);
            string2 = n >= 10 ? string2 + "" + n + " " : string2 + "" + n + "  ";
            c = attributedCharacterIterator.next();
        }
        System.out.println(string);
        System.out.println(string2);
    }

    protected Element getFlowDivElement(Element element) {
        String string = element.getNamespaceURI();
        if (!string.equals("http://www.w3.org/2000/svg")) {
            return null;
        }
        String string2 = element.getLocalName();
        if (string2.equals("flowDiv")) {
            return element;
        }
        if (!string2.equals("flowRoot")) {
            return null;
        }
        Node node = this.getFirstChild(element);
        while (node != null) {
            Element element2;
            String string3;
            String string4;
            if (node.getNodeType() == 1 && "http://www.w3.org/2000/svg".equals(string4 = node.getNamespaceURI()) && (string3 = (element2 = (Element)node).getLocalName()).equals("flowDiv")) {
                return element2;
            }
            node = this.getNextSibling(node);
        }
        return null;
    }

    protected AttributedString getFlowDiv(BridgeContext bridgeContext, Element element) {
        Element element2 = this.getFlowDivElement(element);
        if (element2 == null) {
            return null;
        }
        return this.gatherFlowPara(bridgeContext, element2);
    }

    protected AttributedString gatherFlowPara(BridgeContext bridgeContext, Element element) {
        int n;
        Object object;
        TextPaintInfo textPaintInfo = new TextPaintInfo();
        textPaintInfo.visible = true;
        textPaintInfo.fillPaint = Color.black;
        this.elemTPI.put(element, textPaintInfo);
        SVGTextElementBridge.AttributedStringBuffer attributedStringBuffer = new SVGTextElementBridge.AttributedStringBuffer();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Element> arrayList2 = new ArrayList<Element>();
        ArrayList arrayList3 = new ArrayList();
        Object object2 = this.getFirstChild(element);
        while (object2 != null) {
            if (object2.getNodeType() == 1 && this.getNamespaceURI().equals(object2.getNamespaceURI())) {
                Element element2 = (Element)object2;
                object = element2.getLocalName();
                if (((String)object).equals("flowPara")) {
                    this.fillAttributedStringBuffer(bridgeContext, element2, true, null, attributedStringBuffer, arrayList3);
                    arrayList2.add(element2);
                    arrayList.add(new Integer(attributedStringBuffer.length()));
                } else if (((String)object).equals("flowRegionBreak")) {
                    this.fillAttributedStringBuffer(bridgeContext, element2, true, null, attributedStringBuffer, arrayList3);
                    arrayList2.add(element2);
                    arrayList.add(new Integer(attributedStringBuffer.length()));
                }
            }
            object2 = this.getNextSibling((Node)object2);
        }
        textPaintInfo.startChar = 0;
        textPaintInfo.endChar = attributedStringBuffer.length() - 1;
        object2 = attributedStringBuffer.toAttributedString();
        if (object2 == null) {
            return null;
        }
        int n2 = 0;
        object = arrayList3.iterator();
        while (object.hasNext()) {
            n = (Integer)object.next();
            if (n == n2) continue;
            ((AttributedString)object2).addAttribute(FLOW_LINE_BREAK, new Object(), n2, n);
            n2 = n;
        }
        n = 0;
        LinkedList<BlockInfo> linkedList = null;
        for (int i = 0; i < arrayList2.size(); ++i) {
            Element element3 = (Element)arrayList2.get(i);
            int n3 = (Integer)arrayList.get(i);
            if (n == n3) {
                if (linkedList == null) {
                    linkedList = new LinkedList<BlockInfo>();
                }
                linkedList.add(this.makeBlockInfo(bridgeContext, element3));
            } else {
                ((AttributedString)object2).addAttribute(FLOW_PARAGRAPH, this.makeBlockInfo(bridgeContext, element3), n, n3);
                if (linkedList != null) {
                    ((AttributedString)object2).addAttribute(FLOW_EMPTY_PARAGRAPH, linkedList, n, n3);
                    linkedList = null;
                }
            }
            n = n3;
        }
        return object2;
    }

    protected List getRegions(BridgeContext bridgeContext, Element element) {
        element = (Element)element.getParentNode();
        LinkedList linkedList = new LinkedList();
        Node node = this.getFirstChild(element);
        while (node != null) {
            Element element2;
            String string;
            if (node.getNodeType() == 1 && "http://www.w3.org/2000/svg".equals(node.getNamespaceURI()) && "flowRegion".equals(string = (element2 = (Element)node).getLocalName())) {
                float f = 0.0f;
                this.gatherRegionInfo(bridgeContext, element2, f, linkedList);
            }
            node = this.getNextSibling(node);
        }
        return linkedList;
    }

    protected void gatherRegionInfo(BridgeContext bridgeContext, Element element, float f, List list) {
        boolean bl = !bridgeContext.isDynamic();
        Node node = this.getFirstChild(element);
        while (node != null) {
            GraphicsNode graphicsNode;
            Shape shape;
            if (node.getNodeType() == 1 && (shape = (graphicsNode = bl ? (GraphicsNode)this.flowRegionNodes.get(node) : bridgeContext.getGraphicsNode((Element)node)).getOutline()) != null) {
                AffineTransform affineTransform = graphicsNode.getTransform();
                if (affineTransform != null) {
                    shape = affineTransform.createTransformedShape(shape);
                }
                list.add(new RegionInfo(shape, f));
            }
            node = this.getNextSibling(node);
        }
    }

    protected void fillAttributedStringBuffer(BridgeContext bridgeContext, Element element, boolean bl, Integer n, SVGTextElementBridge.AttributedStringBuffer attributedStringBuffer, List list) {
        Object object;
        int n2;
        int n3;
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        String string = XMLSupport.getXMLSpace((Element)element);
        boolean bl2 = string.equals("preserve");
        Element element2 = element;
        int n4 = attributedStringBuffer.length();
        if (bl) {
            this.endLimit = this.startLen = attributedStringBuffer.length();
        }
        if (bl2) {
            this.endLimit = this.startLen;
        }
        Map map = this.getAttributeMap(bridgeContext, element, null, n);
        Object v = map.get(TextAttribute.BIDI_EMBEDDING);
        Integer n5 = n;
        if (v != null) {
            n5 = (Integer)v;
        }
        int n6 = -1;
        if (list.size() != 0) {
            n6 = (Integer)list.get(list.size() - 1);
        }
        Node node = this.getFirstChild(element);
        while (node != null) {
            boolean bl3;
            if (bl2) {
                bl3 = false;
            } else {
                n3 = attributedStringBuffer.length();
                if (n3 == this.startLen) {
                    bl3 = true;
                } else {
                    bl3 = attributedStringBuffer.getLastChar() == 32;
                    n2 = list.size() - 1;
                    if (!bl3 && n2 >= 0 && (Integer)(object = (Integer)list.get(n2)) == n3) {
                        bl3 = true;
                    }
                }
            }
            switch (node.getNodeType()) {
                case 1: {
                    if (!"http://www.w3.org/2000/svg".equals(node.getNamespaceURI())) break;
                    element2 = (Element)node;
                    String string2 = node.getLocalName();
                    if (string2.equals("flowLine")) {
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, n5, attributedStringBuffer, list);
                        n6 = attributedStringBuffer.length();
                        list.add(new Integer(n6));
                        break;
                    }
                    if (string2.equals("flowSpan") || string2.equals("altGlyph")) {
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, n5, attributedStringBuffer, list);
                        break;
                    }
                    if (string2.equals("a")) {
                        if (bridgeContext.isInteractive()) {
                            NodeEventTarget nodeEventTarget = (NodeEventTarget)element2;
                            object = bridgeContext.getUserAgent();
                            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "click", (EventListener)new SVGAElementBridge.AnchorListener((UserAgent)object), false, null);
                            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", (EventListener)new SVGAElementBridge.CursorMouseOverListener((UserAgent)object), false, null);
                            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", (EventListener)new SVGAElementBridge.CursorMouseOutListener((UserAgent)object), false, null);
                        }
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, n5, attributedStringBuffer, list);
                        break;
                    }
                    if (!string2.equals("tref")) break;
                    String string3 = XLinkSupport.getXLinkHref((Element)((Element)node));
                    object = bridgeContext.getReferencedElement((Element)node, string3);
                    string = TextUtilities.getElementContent((Element)object);
                    if ((string = this.normalizeString(string, bl2, bl3)) == null) break;
                    int n7 = attributedStringBuffer.length();
                    Map map2 = this.getAttributeMap(bridgeContext, element2, null, n);
                    attributedStringBuffer.append(string, map2);
                    int n8 = attributedStringBuffer.length() - 1;
                    TextPaintInfo textPaintInfo = (TextPaintInfo)this.elemTPI.get(element2);
                    textPaintInfo.startChar = n7;
                    textPaintInfo.endChar = n8;
                    break;
                }
                case 3: 
                case 4: {
                    string = node.getNodeValue();
                    string = this.normalizeString(string, bl2, bl3);
                    attributedStringBuffer.append(string, map);
                    if (!bl2) break;
                    this.endLimit = attributedStringBuffer.length();
                }
            }
            node = this.getNextSibling(node);
        }
        if (bl) {
            boolean bl4 = false;
            while (this.endLimit < attributedStringBuffer.length() && attributedStringBuffer.getLastChar() == 32) {
                n3 = list.size() - 1;
                n2 = attributedStringBuffer.length();
                if (n3 >= 0 && (Integer)(object = (Integer)list.get(n3)) >= n2) {
                    object = new Integer(n2 - 1);
                    list.set(n3, object);
                    --n3;
                    while (n3 >= 0 && (Integer)(object = (Integer)list.get(n3)) >= n2 - 1) {
                        list.remove(n3);
                        --n3;
                    }
                }
                attributedStringBuffer.stripLast();
                bl4 = true;
            }
            if (bl4) {
                Iterator iterator = this.elemTPI.values().iterator();
                while (iterator.hasNext()) {
                    TextPaintInfo textPaintInfo = (TextPaintInfo)iterator.next();
                    if (textPaintInfo.endChar < attributedStringBuffer.length()) continue;
                    textPaintInfo.endChar = attributedStringBuffer.length() - 1;
                    if (textPaintInfo.startChar <= textPaintInfo.endChar) continue;
                    textPaintInfo.startChar = textPaintInfo.endChar;
                }
            }
        }
        int n9 = attributedStringBuffer.length() - 1;
        TextPaintInfo textPaintInfo = (TextPaintInfo)this.elemTPI.get(element);
        textPaintInfo.startChar = n4;
        textPaintInfo.endChar = n9;
    }

    protected Map getAttributeMap(BridgeContext bridgeContext, Element element, TextPath textPath, Integer n) {
        Map map = super.getAttributeMap(bridgeContext, element, textPath, n);
        float f = TextUtilities.convertFontSize(element).floatValue();
        float f2 = this.getLineHeight(bridgeContext, element, f);
        map.put(LINE_HEIGHT, new Float(f2));
        return map;
    }

    protected void checkMap(Map map) {
        if (map.containsKey(TEXTPATH)) {
            return;
        }
        if (map.containsKey(ANCHOR_TYPE)) {
            return;
        }
        if (map.containsKey(LETTER_SPACING)) {
            return;
        }
        if (map.containsKey(WORD_SPACING)) {
            return;
        }
        if (map.containsKey(KERNING)) {
            return;
        }
    }

    protected void initCSSPropertyIndexes(Element element) {
        CSSEngine cSSEngine = CSSUtilities.getCSSEngine(element);
        this.marginTopIndex = cSSEngine.getPropertyIndex("margin-top");
        this.marginRightIndex = cSSEngine.getPropertyIndex("margin-right");
        this.marginBottomIndex = cSSEngine.getPropertyIndex("margin-bottom");
        this.marginLeftIndex = cSSEngine.getPropertyIndex("margin-left");
        this.indentIndex = cSSEngine.getPropertyIndex("indent");
        this.textAlignIndex = cSSEngine.getPropertyIndex("text-align");
        this.lineHeightIndex = cSSEngine.getPropertyIndex("line-height");
    }

    public BlockInfo makeBlockInfo(BridgeContext bridgeContext, Element element) {
        if (this.marginTopIndex == -1) {
            this.initCSSPropertyIndexes(element);
        }
        Value value = CSSUtilities.getComputedStyle(element, this.marginTopIndex);
        float f = value.getFloatValue();
        value = CSSUtilities.getComputedStyle(element, this.marginRightIndex);
        float f2 = value.getFloatValue();
        value = CSSUtilities.getComputedStyle(element, this.marginBottomIndex);
        float f3 = value.getFloatValue();
        value = CSSUtilities.getComputedStyle(element, this.marginLeftIndex);
        float f4 = value.getFloatValue();
        value = CSSUtilities.getComputedStyle(element, this.indentIndex);
        float f5 = value.getFloatValue();
        value = CSSUtilities.getComputedStyle(element, this.textAlignIndex);
        if (value == ValueConstants.INHERIT_VALUE) {
            value = CSSUtilities.getComputedStyle(element, 11);
            value = value == ValueConstants.LTR_VALUE ? SVG12ValueConstants.START_VALUE : SVG12ValueConstants.END_VALUE;
        }
        int n = value == SVG12ValueConstants.START_VALUE ? 0 : (value == SVG12ValueConstants.MIDDLE_VALUE ? 1 : (value == SVG12ValueConstants.END_VALUE ? 2 : 3));
        HashMap hashMap = new HashMap(20);
        List list = this.getFontList(bridgeContext, element, hashMap);
        Float f6 = (Float)hashMap.get(TextAttribute.SIZE);
        float f7 = f6.floatValue();
        float f8 = this.getLineHeight(bridgeContext, element, f7);
        String string = element.getLocalName();
        boolean bl = string.equals("flowRegionBreak");
        return new BlockInfo(f, f2, f3, f4, f5, n, f8, list, hashMap, bl);
    }

    protected float getLineHeight(BridgeContext bridgeContext, Element element, float f) {
        Value value;
        if (this.lineHeightIndex == -1) {
            this.initCSSPropertyIndexes(element);
        }
        if ((value = CSSUtilities.getComputedStyle(element, this.lineHeightIndex)) == ValueConstants.INHERIT_VALUE || value == SVG12ValueConstants.NORMAL_VALUE) {
            return f * 1.1f;
        }
        float f2 = value.getFloatValue();
        if (value instanceof ComputedValue) {
            value = ((ComputedValue)value).getComputedValue();
        }
        if (value instanceof LineHeightValue && ((LineHeightValue)value).getFontSizeRelative()) {
            f2 *= f;
        }
        return f2;
    }

    protected class RegionChangeListener
    implements EventListener {
        protected RegionChangeListener() {
        }

        public void handleEvent(Event event) {
            SVGFlowRootElementBridge.this.laidoutText = null;
            SVGFlowRootElementBridge.this.computeLaidoutText(SVGFlowRootElementBridge.this.ctx, SVGFlowRootElementBridge.this.e, SVGFlowRootElementBridge.this.node);
        }
    }

    protected class FlowContentBridge
    extends SVGTextElementBridge.AbstractTextChildTextContent {
        public FlowContentBridge(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge, Element element) {
            super(SVGFlowRootElementBridge.this, bridgeContext, sVGTextElementBridge, element);
        }
    }
}

