#!/usr/bin/env python

"""**************************************************************************
** $Id: tooltip.py,v 1.1 2003/07/01 14:18:37 phil Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for TQt.  This example
** program may be used, distributed and modified without limitation.
**
***************************************************************************"""

import sys
from PyTQt.tqt import *
from random import random

class DynamicTip( TQToolTip ):
    def __init__( self, parent ):
        TQToolTip.__init__( self, parent )
            
    def maybeTip( self, pos ):
        #if not self.parent.inherits( "TellMe" ):
        if TQToolTip(self).parentWidget().inherits( "TellMe" ) :
            return
        r = TQRect( TQToolTip(self).parentWidget().tip(pos) )
        if not r.isValid():
            return

        s = TQString( "position: %d,%d" % (r.center().x(), r.center().y()) )
        TQToolTip(self).tip( r, s )
        
    
class TellMe( TQWidget ):
    def __init__( self, parent=None, name=None ):
        TQWidget.__init__( self, parent, name )

        self.setMinimumSize( 30, 30 )
        self.r1 = self.randomRect()
        self.r2 = self.randomRect()
        self.r3 = self.randomRect()

        self.t = DynamicTip( self )

        TQToolTip.add( self, self.r3, "this color is called red" ) # <- helpful
    
    def paintEvent( self, e ):

        p = TQPainter( self )

        # I try to be efficient here, and repaint only what's needed
        if e.rect().intersects( self.r1 ):
            p.setBrush( TQt.blue )
            p.drawRect( self.r1 )
    
        if e.rect().intersects( self.r2 ):
            p.setBrush( TQt.blue )
            p.drawRect( self.r2 )
        
        if e.rect().intersects( self.r3 ):
            p.setBrush( TQt.red )
            p.drawRect( self.r3 )
        
    def mousePressEvent( self, e ):
        
        if self.r1.contains( e.pos() ):
            self.r1 = self.randomRect()
        if self.r2.contains( e.pos() ):
            self.r2 = self.randomRect()
        self.repaint()

    def resizeEvent( self, e ):
        
        if not self.rect().contains( self.r1 ):
             self.r1 = self.randomRect()
        if not self.rect().contains( self.r2 ):
             self.r2 = self.randomRect()
    
    def randomRect( self ):
        return TQRect( int(random() * (self.width() - 20)), int(random() * (self.height() - 20)), 20, 20 )
    
    def tip( self, p ):
        
        if self.r1.contains( p ):
            return self.r1
        elif self.r2.contains( p ):
            return self.r2
        else:
            return TQRect( 0,0, -1,-1 )
    
    def __del__( self ):
        del self.t
        self.t = None

def main( args ):
    a = TQApplication( args )
    
    mw = TellMe()
    mw.setCaption( "TQt Example - Dynamic Tool Tips" )
    a.setMainWidget( mw )
    mw.show()
    
    a.exec_loop()
    
if __name__=="__main__":
    main(sys.argv)
