/***************************************************************************
 *   Copyright (C) 2004 by Tobias Glaesser                                 *
 *   tobi.web@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef FINDDOCUMENTATION_H
#define FINDDOCUMENTATION_H

#include <tqlistview.h>

#include "find_documentationbase.h"

class DocumentationWidget;
class TDEListViewItem;
class FindDocumentationOptions;
class TDEProcess;

class FindDocumentation : public FindDocumentationBase
{
TQ_OBJECT
  
public:
    FindDocumentation(DocumentationWidget* parent, const char* name = 0);
    ~FindDocumentation();
    /*$PUBLIC_FUNCTIONS$*/

public slots:
    /*$PUBLIC_SLOTS$*/
    virtual void buttonPressedOnItem( int button, TQListViewItem * item, const TQPoint & pos, int c );
    virtual void clickOnItem( TQListViewItem * item );
    virtual void procInfoExited( TDEProcess* );
    virtual void procManExited( TDEProcess* );
    virtual void procManReadStdout( TDEProcess*, char*, int );
    virtual void procInfoReadStdout( TDEProcess*, char*, int );
    virtual void searchInInfo();
    virtual void searchInMan();
    virtual void searchInGoogle();
    virtual void searchInContents();
    virtual void searchInIndex();
    virtual void startSearch();
    virtual void setSearchTerm( const TQString & term );
    virtual void clickOptions();

protected:
    /*$PROTECTED_FUNCTIONS$*/
    virtual void focusInEvent(TQFocusEvent *e);

protected slots:
  /*$PROTECTED_SLOTS$*/

private:
    TDEProcess* proc_man;
    TDEProcess* proc_info;
    TQString proc_man_out;
    TQString proc_info_out;
    TDEListViewItem* man_item;
    TDEListViewItem* info_item;
    TDEListViewItem* index_item;
    TDEListViewItem* google_item;
    TDEListViewItem* contents_item;
    TDEListViewItem* last_item;
    DocumentationWidget* m_widget;
    FindDocumentationOptions* m_options;
    bool first_match_found;
    
};

#endif

