
/* This file is part of KMail
 * Copyright (C) 2005 Lus Pedro Coelho <luis@luispedro.org>
 *
 * KMail is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 * 
 * KMail is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of this program with any edition of
 * the TQt library by Trolltech AS, Norway (or with modified versions
 * of TQt that use the same license as TQt), and distribute linked
 * combinations including the two.  You must obey the GNU General
 * Public License in all respects for all of the code used other than
 * TQt.  If you modify this file, you may extend this exception to
 * your version of the file, but you are not obligated to do so.  If
 * you do not wish to do so, delete this exception statement from
 * your version.
 */

#include "tdelistviewindexedsearchline.h"
#include <kdebug.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "headeritem.h"
#include "kmheaders.h"
#include "kmfolder.h"
#include "index.h"

using KMail::HeaderListQuickSearch;

TDEListViewIndexedSearchLine::TDEListViewIndexedSearchLine( TQWidget* parent, TDEListView* listView, TDEActionCollection* actionCollection, const char* name ):
	HeaderListQuickSearch( parent, listView, actionCollection, name ),
	mFiltering( false )
{
}

TDEListViewIndexedSearchLine::~TDEListViewIndexedSearchLine() {
}


void TDEListViewIndexedSearchLine::updateSearch( const TQString& s ) {
	kdDebug( 5006 ) << "updateSearch( -" << s << "- )" << endl;
	mFiltering = false;
	if ( !s.isNull() && !s.isEmpty() ) {
		bool ok = false;
		KMMsgIndex* index = kmkernel->msgIndex();
		if ( index ) {
			mResults = index->simpleSearch( s, &ok );
			std::sort( mResults.begin(), mResults.end() );
			mFiltering = ok;
		}
	}
	TDEListViewSearchLine::updateSearch( s );
}

bool TDEListViewIndexedSearchLine::itemMatches( const TQListViewItem* item, const TQString& s ) const {
	if ( mFiltering && 
			std::binary_search( mResults.begin(), mResults.end(), static_cast<const KMail::HeaderItem*>( item )->msgSerNum() ) )
		return true;
	return KMail::HeaderListQuickSearch::itemMatches( item, s );
}

#include "tdelistviewindexedsearchline.moc"

