/*
 * kcmreslisa.h
 *
 * Copyright (c) 2000-2002 Alexander Neundorf <neundorf@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KCMRESLISA_H
#define KCMRESLISA_H

#include <tdecmodule.h>
#include <tdeconfig.h>


class TQSpinBox;
class TQCheckBox;
class TQPushButton;
class KEditListBox;
class KDialogBase;
class KRestrictedLine;

class ResLisaSettings:public TDECModule
{
   TQ_OBJECT
  
   public:
      ResLisaSettings(const TQString& config, TQWidget *parent=0);
      virtual ~ResLisaSettings() {}
      void load();
      void save();
   signals:
      void changed();
   protected slots:
      void suggestSettings();
   protected:
      TDEConfig m_config;
      TDEConfig m_tdeiolanConfig;
      TQPushButton* m_advancedSettingsButton;
      TQPushButton* m_suggestSettings;
      TQCheckBox* m_useNmblookup;
      KEditListBox *m_pingNames;

      KRestrictedLine *m_allowedAddresses;
      TQSpinBox *m_firstWait;
      TQCheckBox *m_secondScan;
      TQSpinBox *m_secondWait;
      TQSpinBox *m_updatePeriod;
      TQCheckBox *m_deliverUnnamedHosts;
      TQSpinBox *m_maxPingsAtOnce;
      TQCheckBox* m_rlanSidebar;
      KDialogBase* m_reslisaAdvancedDlg;
};

#endif

