#ifndef PARSER_H
#define PARSER_H

// system includes
#include <tqstringlist.h>
#include <tqpixmap.h>
#include <tqimage.h>
#include <tqdict.h>

class Parser : public TQDict<TQStringList>
{
	class ImagePixmap
	{
	public:
		ImagePixmap() : mImage(0), mPixmap(0) {}
		~ImagePixmap() {}
		TQImage mImage;
		TQPixmap mPixmap;
	};

	public:
		Parser();

		void conserveMemory();
		void open(const TQString &file);

		TQString dir() const;
		TQPixmap pixmap(const TQString &pixmap) const
			{ return getPair(pixmap)->mPixmap; }
		TQImage image(const TQString &image) const
			{ return getPair(image)->mImage; }
		TQString about() const { return mSkinAbout; };

		TQString fileItem(const TQString &file) const;

		bool exist(const TQString &i) const;

	public:
		TQStringList& operator[](const TQString &l) { return *find(l);}

	private:
		ImagePixmap *getPair(const TQString &i) const;

	private:
		mutable TQDict<ImagePixmap> mImageCache;
		TQString mDir;
		TQString mSkinAbout;
};
#endif // PARSER_H
