class OptionsForm < TQt::Dialog
    slots 'chooseFont()'
    
    attr_reader :chartTypeComboBox, 
	:noRadioButton, 
	:yesRadioButton, 
	:asPercentageRadioButton,
	:decimalPlacesSpinBox,
	:font
    
    def initialize( parent = nil, name = "options form",
                            modal = false, f = 0 )
        super( parent, name, modal, f )
        setCaption( "Chart -- Options" )
        resize( 320, 290 )
    
        @optionsFormLayout = TQt::VBoxLayout.new( self, 11, 6 )
    
        @chartTypeLayout = TQt::HBoxLayout.new( nil, 0, 6 )
    
        @chartTypeTextLabel = TQt::Label.new( "&Chart Type", self )
        @chartTypeLayout.addWidget( @chartTypeTextLabel )
    
        @chartTypeComboBox = TQt::ComboBox.new( false, self )
        @chartTypeComboBox.insertItem( TQt::Pixmap.new( "images/options_piechart.xpm" ), "Pie Chart" )
        @chartTypeComboBox.insertItem( TQt::Pixmap.new( "images/options_verticalbarchart.xpm" ),
                                    "Vertical Bar Chart" )
        @chartTypeComboBox.insertItem( TQt::Pixmap.new( "images/options_horizontalbarchart.xpm" ),
                                    "Horizontal Bar Chart" )
        @chartTypeLayout.addWidget( @chartTypeComboBox )
        @optionsFormLayout.addLayout( @chartTypeLayout )
    
        @fontLayout = TQt::HBoxLayout.new( nil, 0, 6 )
    
        @fontPushButton = TQt::PushButton.new( "&Font...", self )
        @fontLayout.addWidget( @fontPushButton )
        @spacer = TQt::SpacerItem.new( 0, 0, TQt::SizePolicy::Expanding,
                                            TQt::SizePolicy::Minimum )
        @fontLayout.addItem( @spacer )
    
        @fontTextLabel = TQt::Label.new( self ) # Must be set by caller via setFont()
        @fontLayout.addWidget( @fontTextLabel )
        @optionsFormLayout.addLayout( @fontLayout )
    
        @addValuesFrame = TQt::Frame.new( self )
        @addValuesFrame.setFrameShape( TQt::Frame::StyledPanel )
        @addValuesFrame.setFrameShadow( TQt::Frame::Sunken )
        @addValuesFrameLayout = TQt::VBoxLayout.new( @addValuesFrame, 11, 6 )
    
        @addValuesButtonGroup = TQt::ButtonGroup.new( "Show Values", @addValuesFrame )
        @addValuesButtonGroup.setColumnLayout(0, TQt::Vertical )
        @addValuesButtonGroup.layout().setSpacing( 6 )
        @addValuesButtonGroup.layout().setMargin( 11 )
        @addValuesButtonGroupLayout = TQt::VBoxLayout.new(
                                            @addValuesButtonGroup.layout() )
        @addValuesButtonGroupLayout.setAlignment( TQt::AlignTop )
    
        @noRadioButton = TQt::RadioButton.new( "&No", @addValuesButtonGroup )
        @noRadioButton.setChecked( true )
        @addValuesButtonGroupLayout.addWidget( @noRadioButton )
    
        @yesRadioButton = TQt::RadioButton.new( "&Yes", @addValuesButtonGroup )
        @addValuesButtonGroupLayout.addWidget( 	@yesRadioButton )
    
        @asPercentageRadioButton = TQt::RadioButton.new( "As &Percentage",
                                                    @addValuesButtonGroup )
        @addValuesButtonGroupLayout.addWidget( @asPercentageRadioButton )
        @addValuesFrameLayout.addWidget( @addValuesButtonGroup )
    
        @decimalPlacesLayout = TQt::HBoxLayout.new( nil, 0, 6 )
    
        @decimalPlacesTextLabel = TQt::Label.new( "&Decimal Places", @addValuesFrame )
        @decimalPlacesLayout.addWidget( @decimalPlacesTextLabel )
    
        @decimalPlacesSpinBox = TQt::SpinBox.new( @addValuesFrame )
        @decimalPlacesSpinBox.setMinValue( 0 )
        @decimalPlacesSpinBox.setMaxValue( 9 )
        @decimalPlacesLayout.addWidget( @decimalPlacesSpinBox )
    
        @addValuesFrameLayout.addLayout( @decimalPlacesLayout )
    
        @optionsFormLayout.addWidget( @addValuesFrame )
    
        @buttonsLayout = TQt::HBoxLayout.new( nil, 0, 6 )
        @spacer = TQt::SpacerItem.new( 0, 0,
                                TQt::SizePolicy::Expanding, TQt::SizePolicy::Minimum )
        @buttonsLayout.addItem( @spacer )
    
        @okPushButton = TQt::PushButton.new( "OK", self )
        @okPushButton.setDefault( true )
        @buttonsLayout.addWidget( @okPushButton )
    
        @cancelPushButton = TQt::PushButton.new( "Cancel", self )
        @buttonsLayout.addWidget( @cancelPushButton )
        @optionsFormLayout.addLayout( @buttonsLayout )
    
        connect( @fontPushButton, TQ_SIGNAL( 'clicked()' ), self, TQ_SLOT( 'chooseFont()' ) )
        connect( @okPushButton, TQ_SIGNAL( 'clicked()' ), self, TQ_SLOT( 'accept()' ) )
        connect( @cancelPushButton, TQ_SIGNAL( 'clicked()' ), self, TQ_SLOT( 'reject()' ) )
    
        @chartTypeTextLabel.setBuddy( @chartTypeComboBox )
        @decimalPlacesTextLabel.setBuddy( @decimalPlacesSpinBox )
    end
    
    
    def chooseFont()
        ok = TQt::Boolean.new
        font = TQt::FontDialog.getFont( ok, @font, self )
        if !ok.nil?
            setFont( font )
        end
    end
    
    
    def font=( font )
        label = font.family() + " " + font.pointSize().to_s + "pt"
        if font.bold()
            label += " Bold"
        end
        if font.italic()
            label += " Italic"
        end
        @fontTextLabel.setText( label )
        @font = font
    end

end
