


#include <tqcstring.h>
#include <tqimage.h>
#include <tqpainter.h>
#include <tqpalette.h>
#include <tqpixmap.h>
#include <tqfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <tqcanvas.h>
#include "qcanvaspixmap_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

TQCanvasPixmapImp::TQCanvasPixmapImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

TQCanvasPixmapImp::~TQCanvasPixmapImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void TQCanvasPixmapImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQCanvasPixmapImp *meth = new TQCanvasPixmapImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void TQCanvasPixmapImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_offsetX_5, "offsetX" },
        { Method_offsetY_6, "offsetY" },
        { Method_setOffset_7, "setOffset" },
	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQCanvasPixmapImp *meth = new TQCanvasPixmapImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a TQCanvasPixmap pointer from an Object.
 */
TQCanvasPixmap *TQCanvasPixmapImp::toTQCanvasPixmap( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        TQObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<TQCanvasPixmap *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "TQCanvasPixmap" )
        return 0;

    return op->toNative<TQCanvasPixmap>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object TQCanvasPixmapImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvasPixmap_1:
             return TQCanvasPixmap_1( exec, args );
             break;

         case Constructor_QCanvasPixmap_2:
             return TQCanvasPixmap_2( exec, args );
             break;

         case Constructor_QCanvasPixmap_3:
             return TQCanvasPixmap_3( exec, args );
             break;

         default:
             break;
    }

    TQString msg = i18n("TQCanvasPixmapCons has no constructor with id '%1'.").arg(id);
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Object TQCanvasPixmapImp::TQCanvasPixmap_1( KJS::ExecState *exec, const KJS::List &args )
{

    TQString arg0 = extractTQString(exec, args, 0);


    // We should now create an instance of the TQCanvasPixmap object

    TQCanvasPixmap *ret = new TQCanvasPixmap(

          arg0 );

	return KJS::Object();
}

KJS::Object TQCanvasPixmapImp::TQCanvasPixmap_2( KJS::ExecState *exec, const KJS::List &args )
{

    TQImage arg0 = extractTQImage(exec, args, 0);


    // We should now create an instance of the TQCanvasPixmap object

    TQCanvasPixmap *ret = new TQCanvasPixmap(

          arg0 );

	return KJS::Object();

}

KJS::Object TQCanvasPixmapImp::TQCanvasPixmap_3( KJS::ExecState *exec, const KJS::List &args )
{

    TQPixmap arg0 = extractTQPixmap(exec, args, 0);

    TQPoint arg1 = extractTQPoint(exec, args, 1);


    // We should now create an instance of the TQCanvasPixmap object

    TQCanvasPixmap *ret = new TQCanvasPixmap(

          arg0,
          arg1 );

	return KJS::Object();

}

KJS::Value TQCanvasPixmapImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = TQCanvasPixmapImp::toTQCanvasPixmap( self );

    switch( id ) {

    case Method_offsetX_5:
        return offsetX_5( exec, self, args );
        break;

    case Method_offsetY_6:
        return offsetY_6( exec, self, args );
        break;

    case Method_setOffset_7:
        return setOffset_7( exec, self, args );
        break;

    default:
        break;
    }

    TQString msg = i18n( "TQCanvasPixmapImp has no method with id '%1'." ).arg( id );
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value TQCanvasPixmapImp::offsetX_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->offsetX(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasPixmapImp::offsetY_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->offsetY(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasPixmapImp::setOffset_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      instance->setOffset(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}


} // namespace KJSEmbed
