/***************************************************************************
 *   Copyright (C) 2006 by Sascha Hlusiak                                  *
 *   Spam84@gmx.de                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#include <tdeapplication.h>
#include <tqimage.h>
#include <kimageeffect.h>
#include <tqdesktopwidget.h>
#include "imageholder.h"


QImageHolder::QImageHolder(TQImage act,TQImage inact)
:img_active(NULL),img_inactive(NULL)
{
	rootpixmap=NULL;
	setUserdefinedPictures( act,inact);
	initialized=userdefinedActive && userdefinedInactive;

	emit repaintNeeded();
}

QImageHolder::~QImageHolder()
{
	if (rootpixmap)delete rootpixmap;
	if (img_active && !userdefinedActive)delete img_active;
	if (img_inactive && !userdefinedInactive)delete img_inactive;
}

void QImageHolder::setUserdefinedPictures( TQImage act,TQImage inact)
{
	int w=TQApplication::desktop()->width();
	int h=TQApplication::desktop()->height();
	if (img_active && !userdefinedActive)
	{
		delete img_active;	
		img_active=NULL;
	}
	if (img_inactive && !userdefinedInactive)
	{
		delete img_inactive;
		img_inactive=NULL;
	}

	if (!act.isNull())
		img_active=new TQPixmap(act);
	else
		img_active=NULL;
	if (!inact.isNull())
		img_inactive=new TQPixmap(inact);
	else
		img_inactive=NULL;

	userdefinedActive=(img_active!=NULL);
	userdefinedInactive=(img_inactive!=NULL);

	CheckSanity();
}

void QImageHolder::Init()
{
	if (initialized)return;
	
	rootpixmap=new KMyRootPixmap(NULL/*,this*/);
	rootpixmap->start();
	rootpixmap->repaint(true);
	connect( rootpixmap,TQ_SIGNAL(backgroundUpdated(const TQImage*)),this, TQ_SLOT(BackgroundUpdated(const TQImage*)));
	connect(kapp, TQ_SIGNAL(backgroundChanged(int)),TQ_SLOT(handleDesktopChanged(int)));
	
	initialized=true;
}

void QImageHolder::repaint(bool force)
{
	Init(); 
	if (rootpixmap)rootpixmap->repaint(force);
}

void QImageHolder::handleDesktopChanged(int)
{
	repaint(true);
}

void QImageHolder::CheckSanity()
{
	if (!initialized)return;
	if (userdefinedActive && userdefinedInactive)return;
	if (img_active!=NULL && !userdefinedActive)return;
	if (img_inactive!=NULL && !userdefinedInactive)return;

	if (rootpixmap)delete rootpixmap;
	rootpixmap=NULL;
	
	initialized=false;
}

void QImageHolder::BackgroundUpdated(const TQImage *src)
{
	if (img_active && !userdefinedActive)
	{
		delete img_active;
		img_active=NULL;
	}
	if (img_inactive && !userdefinedInactive)
	{
		delete img_inactive;
		img_inactive=NULL;
	}
	
	if (src && !src->isNull())
	{
		if (!userdefinedInactive)
			img_inactive=new TQPixmap(src->copy());
		if (!userdefinedActive)
			img_active=new TQPixmap(src->copy());
	}
	
	emit repaintNeeded();
}

#include "imageholder.moc"
