/*
   Copyright (c) 2005 Boudewijn Rempt <boud@valdyas.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 */
#ifndef _KO_TOOLBOX_H_
#define _KO_TOOLBOX_H_

#include <tqtoolbutton.h>
#include <tqptrvector.h>
#include <tqtoolbar.h>
#include <koffice_export.h>
#include <tdetoolbar.h>

class TQWidget;
class TDEAction;
class TDEMainWindow;
class KDualColorButton;
class TQGridLayout;
class ToolArea;


/**
 * TDEActionBox is a kind of super-specialized toolbox that can order
 * tools according to type and priority.
 *
 * This is to a large extent a port of the Karbon vtoolbox -- with
 * which it should be merged one day. However, it doesn't depend on a
 * tool-like class, it aggregates actions.
 */

class KOFFICEUI_EXPORT KoToolBox : public TDEToolBar {

    TQ_OBJECT
  

public:

    KoToolBox( TDEMainWindow *mainWin, const char* name, TDEInstance* instance, int numberOfTooltypes);
    virtual ~KoToolBox();

    // Called by the toolcontroller for each tool. For every category,
    // there is a separate list, and the tool is categorized correctly.
    // The tool is not yet added to the widgets; call setupTools()
    // to do that. We don't store the tool.
    void registerTool(TDEAction * tool, int toolType, TQ_UINT32 priority);

    // Called when all tools have been added by the tool controller
    void setupTools();

public slots:

    virtual void setOrientation ( TQt::Orientation o );
    void slotButtonPressed( int id );
    void slotPressButton( int id );

    // Enables or disables all buttons and the corresponding actions.
    void enableTools(bool enable);

    void slotSetTool(const TQString & toolname);

private:

    TQToolButton * createButton(TQWidget * parent, const char* iconName, TQString tooltip);


private:
    TQ_UINT32 m_numberOfButtons;

    TQButtonGroup * m_buttonGroup; // The invisible group of all toolbuttons, so only one can be active at a given time

    TQPtrList<ToolArea> m_toolBoxes; // For every ToolArea

    typedef TQMap< int, TDEAction*> ToolList; // The priority ordered list of tools for a certain tooltype

    TQPtrList<ToolList> m_tools;
    TQPtrList<TDEAction> m_idToActionMap; // Map the buttongroup id's to actions for easy activating.
    TDEInstance* m_instance;
};


class ToolArea : public TQWidget {

public:
    ToolArea(TQWidget *parent);
    ~ToolArea();

    void  setOrientation ( TQt::Orientation o );
    void  add(TQWidget *button);

    TQWidget* getNextParent();

private:
    TQPtrList<TQWidget>  m_children;
    TQBoxLayout        *m_layout;

    TQWidget           *m_leftRow;
    TQBoxLayout        *m_leftLayout;

    TQWidget           *m_rightRow;
    TQBoxLayout        *m_rightLayout;

    bool               m_left;
};


#endif // _KO_TOOLBOX_H_
