/**
 * $Id: kchart_factory.cpp 483001 2005-11-24 18:27:18Z dfaure $
 *
 * Kalle Dalheimer <kalle@kde.org>
 */


#include "kchart_factory.h"
#include "kchart_aboutdata.h"
#include "kchart_part.h"
#include <tdelocale.h>
#include <tdeinstance.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <kstandarddirs.h>

namespace KChart
{

TDEInstance   *KChartFactory::s_global    = 0;
TDEAboutData  *KChartFactory::s_aboutData = 0;


KChartFactory::KChartFactory( TQObject* parent, const char* name )
    : KoFactory( parent, name )
{
    global();
}


KChartFactory::~KChartFactory()
{
    delete s_aboutData;
    s_aboutData = 0;
    delete s_global;
    s_global = 0;
}


KParts::Part* KChartFactory::createPartObject( TQWidget *parentWidget,
					       const char *widgetName,
					       TQObject* parent,
					       const char* name,
					       const char *classname,
					       const TQStringList & )
{
    bool bWantKoDocument = ( strcmp( classname, "KoDocument" ) == 0 );

    KChartPart *part = new KChartPart( parentWidget, widgetName, parent, name,
				       !bWantKoDocument );

    if ( !bWantKoDocument )
      part->setReadWrite( false );

    return part;
}


TDEAboutData* KChartFactory::aboutData()
{
    if( !s_aboutData )
        s_aboutData = newKChartAboutData();
    return s_aboutData;
}


TDEInstance* KChartFactory::global()
{
    if ( !s_global )
    {
         s_global = new TDEInstance(aboutData());
         s_global->dirs()->addResourceType( "kchart_template",
         TDEStandardDirs::kde_default("data") + "kchart/templates/");
         // Tell the iconloader about share/apps/koffice/icons
         s_global->iconLoader()->addAppDir("koffice");
    }
    return s_global;
}

}  //namespace KChart

#include <kchart_factory.moc>
