/***************************************************************************
    begin                : Sun Feb 29 2004
    copyright            : (C) 2004 by Jeroen Wijnhout
    email                : Jeroen.Wijnhout@kdemail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONVERT_H
#define CONVERT_H

#include <tqstring.h>
#include <tqstringlist.h>
#include <tqmap.h>

#include <kurl.h>

namespace Kate { class Document; }

class ConvertMap
{
protected:
	ConvertMap(const TQString & encoding);

public:
	const TQString & encoding() const { return m_aliases[0]; }
	const TQString & isoName() const { return m_aliases[1]; }

	TQChar toEncoding(const TQString & enc) { return m_toEncoding[enc]; }
	TQString toASCII(const TQChar & c) { return m_toASCII[c]; }

	void addPair(TQChar c, const TQString & enc);

	bool canDecode(const TQChar & c) { return ( m_toASCII.contains(c) > 0 ); }
	bool canEncode(const TQString & enc) { return ( m_toEncoding.contains(enc) > 0 ); }

	bool load();

private:
	bool commandIsTerminated(const TQString &);

private:
	TQStringList				m_aliases;
	TQMap<TQChar, TQString>		m_toASCII;
	TQMap<TQString, TQChar>		m_toEncoding;

//static members
public:
	static bool create(const TQString & encoding);
	static TQString encodingNameFor(const TQString &);
	static TQString isoNameFor(const TQString &);
	static ConvertMap * mapFor(const TQString & enc) { return g_maps[enc]; }

private:
	static TQMap<TQString, ConvertMap*>	g_maps;
};

class ConvertIO
{
public:
	ConvertIO(Kate::Document *doc);
	virtual ~ConvertIO() {}

	virtual void nextLine(); //read next line
	virtual TQString & currentLine();
	virtual TQString & text() { return m_text; }
	virtual void writeText();
	virtual uint current(); //current line number
	virtual bool done();

protected:
	Kate::Document	*m_doc;
	TQString			m_text, m_line;
	uint				m_nLine;
};

class ConvertIOFile : public ConvertIO
{
public:
	ConvertIOFile(Kate::Document *doc, const KURL & url);

	void writeText();

private:
	KURL	m_url;
};

class ConvertBase
{
public:
	ConvertBase(const TQString & encoding, ConvertIO * io);
	virtual ~ConvertBase() {};

public:
	virtual bool convert();

protected:
	virtual bool setMap();

	virtual TQString mapNext(uint &);

	ConvertIO		*m_io;
	TQString			m_encoding;
	ConvertMap		*m_map;
};

class ConvertEncToASCII : public ConvertBase
{
public:
	ConvertEncToASCII(const TQString & encoding, ConvertIO * io) : ConvertBase(encoding, io) {}

protected:
	TQString mapNext(uint &);
};

class ConvertASCIIToEnc : public ConvertBase
{
public:
	ConvertASCIIToEnc(const TQString & encoding, ConvertIO * io) : ConvertBase(encoding, io) {}

protected:
	TQString getSequence(uint &);
	TQString nextSequence(uint &);
	bool isModifier(const TQString &);
	TQString mapNext(uint &);
};

#endif
