/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*                                                                         *
*   Copyright (C) 2003-2005 by                                            *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KREEXPORTER_H
#define KREEXPORTER_H

#include "baseexporter.h"
#include "datablocks/categorytree.h"

class IngredientData;

/**
Export class for Krecipes native file format (.kre, .kreml)
 
@author Cyril Bosselut and Jason Kivlighn
*/
class KreExporter : public BaseExporter
{
public:
	KreExporter( CategoryTree *, const TQString&, const TQString& );
	virtual ~KreExporter();

	virtual int supportedItems() const;

protected:
	virtual TQString createContent( const RecipeList & );
	virtual TQString createHeader( const RecipeList & );
	virtual TQString createFooter();
	
	virtual int headerFlags() const;

private:
	bool removeIfUnused( const TQValueList<int> &cat_ids, CategoryTree *parent, bool parent_should_show = false );
	void createCategoryStructure( TQString &xml, const RecipeList &recipes );
	void writeCategoryStructure( TQString &xml, const CategoryTree *categoryTree );
	TQString generateIngredient( const IngredientData &ing );

	CategoryTree *categories;
};

#endif
