/***************************************************************************
    smb4kshareoptions  -  The configuration page for the settings of
    Smb4K regarding share management
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// TQt includes
#include <tqlayout.h>
#include <tqgroupbox.h>
#include <tqbuttongroup.h>
#include <tqlabel.h>
#include <tqcheckbox.h>

// KDE includes
#include <tdelocale.h>
#include <kbuttonbox.h>
#include <kurlrequester.h>
#include <knuminput.h>

// system includes
#include <sys/types.h>
#include <pwd.h>
#include <unistd.h>

// applications specific includes
#include "smb4kshareoptions.h"


Smb4KShareOptions::Smb4KShareOptions( TQWidget *parent, const char *name ) : TQWidget( parent, name )
{
  TQGridLayout *grid = new TQGridLayout( this );
  grid->setSpacing( 10 );

  TQGroupBox *dir_box = new TQGroupBox( 1, TQt::Horizontal, i18n( "Directories" ), this );

  TQWidget *prefix_container =   new TQWidget( dir_box );
  TQGridLayout *prefix_layout =  new TQGridLayout( prefix_container );
  prefix_layout->setSpacing( 10 );

  TQLabel *prefix =              new TQLabel( i18n( "Mount prefix:" ), prefix_container );
  KURLRequester *mount_prefix = new KURLRequester( TQString(), prefix_container,
                                "kcfg_MountPrefix" );
  mount_prefix->setMode( KFile::Directory );
  prefix_layout->addWidget( prefix, 0, 0, 0 );
  prefix_layout->addWidget( mount_prefix, 0, 1, 0 );

  (void) new TQCheckBox( i18n( "Force generated subdirectories to be lower case" ),
                        dir_box, "kcfg_ForceLowerCaseSubdirs" );

  TQButtonGroup *mount_box = new TQButtonGroup( 1, TQt::Horizontal, i18n( "Mounting and Unmounting" ), this );
  (void) new TQCheckBox( i18n( "Unmount all shares of user %1 on exit" ).arg( getpwuid( getuid() )->pw_name ),
                       mount_box, "kcfg_UnmountSharesOnExit" );
  (void) new TQCheckBox( i18n( "Remount recently used shares on program start" ),
                       mount_box, "kcfg_RemountShares" );
  (void) new TQCheckBox( i18n( "Allow the unmounting of shares that are owned by other users" ),
                        mount_box, "kcfg_UnmountForeignShares" );

  TQGroupBox *checks_box = new TQGroupBox( 2, TQt::Horizontal, i18n( "Checks" ), this );

  (void) new TQLabel( i18n( "Interval between checks:" ), checks_box );
  KIntNumInput *check_interval = new KIntNumInput( 2500, checks_box, 10,
                                 "kcfg_CheckInterval" );
  check_interval->setSuffix( " ms" );
  check_interval->setRange( 500, 300000, 1, false );

  TQSpacerItem *spacer2 = new TQSpacerItem( 0, 0, TQSizePolicy::Preferred, TQSizePolicy::Expanding );

  grid->addWidget( dir_box, 0, 0, 0 );
  grid->addWidget( mount_box, 1, 0, 0 );
  grid->addWidget( checks_box, 2, 0, 0 );
  grid->addItem( spacer2, 3, 0 );
}

Smb4KShareOptions::~Smb4KShareOptions()
{
}


#include "smb4kshareoptions.moc"
