/***************************************************************************
                          sq_iconlistitem.cpp  -  description
                             -------------------
    begin                : ??? ??? 19 2004
    copyright            : (C) 2004 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tqlistbox.h>
#include <tqpainter.h>
#include <tqbitmap.h>
#include <tqpixmap.h>

#include "sq_iconlistitem.h"

SQ_IconListItem::SQ_IconListItem(TQListBox *listbox, const TQPixmap &pixmap, const TQString &text)
    : TQListBoxItem(listbox)
{
    mPixmap = pixmap;

    if(mPixmap.isNull())
    mPixmap = defaultPixmap();

    setText(text);
    mMinimumWidth = 0;
}

int SQ_IconListItem::expandMinimumWidth( int width )
{
    mMinimumWidth = TQMAX(mMinimumWidth, width);

    return mMinimumWidth;
}

const TQPixmap& SQ_IconListItem::defaultPixmap()
{
    static TQPixmap *pix=0;

    if(pix == 0)
    {
        pix = new TQPixmap( 32, 32 );
        TQPainter p(pix);
        p.eraseRect(0, 0, pix->width(), pix->height());
        p.setPen(TQt::red);
        p.drawRect(0, 0, pix->width(), pix->height());
        p.end();

        TQBitmap mask(pix->width(), pix->height(), true);
        mask.fill(TQt::black);
        p.begin(&mask);
        p.setPen(TQt::white);
        p.drawRect(0, 0, pix->width(), pix->height());
        p.end();

        pix->setMask(mask);
    }

    return *pix;
}

void SQ_IconListItem::paint(TQPainter *painter)
{
    TQFontMetrics fm = painter->fontMetrics();
    int ht = fm.boundingRect(0, 0, 0, 0, TQt::AlignCenter, text()).height();
    int wp = mPixmap.width();
    int hp = mPixmap.height();

    painter->drawPixmap((mMinimumWidth-wp)/2, 5, mPixmap);

    if(text().isEmpty() == false)
        painter->drawText(0, hp+7, mMinimumWidth, ht, TQt::AlignCenter, text());
}

int SQ_IconListItem::height( const TQListBox *lb ) const
{
    if(text().isEmpty() == true)
        return mPixmap.height();
    else
    {
        int ht = lb->fontMetrics().boundingRect(0, 0, 0, 0, TQt::AlignCenter, text()).height();
        return (mPixmap.height() + ht + 10);
    }
}

int SQ_IconListItem::width( const TQListBox *lb ) const
{
    int wt = lb->fontMetrics().boundingRect(0, 0, 0, 0, TQt::AlignCenter, text()).width() + 10;
    int wp = mPixmap.width() + 10;
    int w  = TQMAX(wt, wp);

    return TQMAX(w, mMinimumWidth);
}
