/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CEXPORTMANAGER_H
#define CEXPORTMANAGER_H

//BibleTime includes
#include "backend/cswordbackend.h"
#include "cbtconfig.h"

#include "util/cpointers.h"

//TQt includes
#include <tqstring.h>
#include <tqptrlist.h>

class ListKey;
class CSwordKey;
class CSwordModuleInfo;
class TQProgressDialog;

/** Contains the functions to export text to disk, clipboard or printer.
  * @author The BibleTime team
  */
class CExportManager : CPointers {
public:
	/** The format the export actions should have
	*/
	enum Format {
		HTML,
		Text
	};

	CExportManager(const TQString& caption, const bool showProgress = true, const TQString& progressLabel = TQString(), const CSwordBackend::FilterOptions filterOptions = CBTConfig::getFilterOptionDefaults(), const CSwordBackend::DisplayOptions displayOptions = CBTConfig::getDisplayOptionDefaults());

	const bool saveKey(CSwordKey* key, const Format format, const bool addText);
	const bool saveKeyList(sword::ListKey* list, CSwordModuleInfo* module, const Format format, const bool addText);
	const bool saveKeyList(TQPtrList<CSwordKey>& list, const Format format, const bool addText );

	const bool copyKey(CSwordKey* key, const Format format, const bool addText);
	const bool copyKeyList(sword::ListKey* list, CSwordModuleInfo* module, const Format format, const bool addText);
	const bool copyKeyList(TQPtrList<CSwordKey>& list, const Format format, const bool addText );

	const bool printKey(CSwordKey* key, CSwordBackend::DisplayOptions displayOptions, CSwordBackend::FilterOptions filterOptions);
	const bool printKey( CSwordModuleInfo* module, const TQString& startKey, const TQString& stopKey, CSwordBackend::DisplayOptions displayOptions, CSwordBackend::FilterOptions filterOptions );
const bool printByHyperlink(const TQString& hyperlink, CSwordBackend::DisplayOptions displayOptions, CSwordBackend::FilterOptions filterOptions);
	const bool printKeyList(sword::ListKey* list, CSwordModuleInfo* module, CSwordBackend::DisplayOptions displayOptions, CSwordBackend::FilterOptions filterOptions);
	const bool printKeyList(const TQStringList& list,CSwordModuleInfo* module, CSwordBackend::DisplayOptions displayOptions, CSwordBackend::FilterOptions filterOptions);
	
protected: // Protected methods
	/**
	* Returns the string for the filedialogs to show the correct files.
	*/
	const TQString filterString( const Format format );
	/**
	* Returns a filename to save a file.
	*/
	const TQString getSaveFileName(const Format format);
	/**
	* Returns a string containing the linebreak for the current format.
	*/
	const TQString lineBreak( const Format format );

private:
	TQString m_caption;
	TQString m_progressLabel;
	bool m_showProgress;
	CSwordBackend::FilterOptions m_filterOptions;
	CSwordBackend::DisplayOptions m_displayOptions;

	TQProgressDialog* m_progressDialog;

	/**
	* Creates the progress dialog with the correct settings.
	*/
	TQProgressDialog* const progressDialog();
	/**
	* Returns the CSS string used in HTML pages.
	*/
	void setProgressRange( const int item );
	/**
	* Increments the progress by one item.
	*/
	inline void incProgress();
	const bool progressWasCancelled();
	/**
	* Closes the progress dialog immediatly.
	*/
	void closeProgressDialog();
};

#endif
