// (c) 2005 Christian Muehlhaeuser <chris@chris.de>
// (c) 2006 Seb Ruiz <me@sebruiz.net>
// License: GNU General Public License V2


#ifndef AMAROK_HTMLVIEW_H
#define AMAROK_HTMLVIEW_H

#include <tdehtml_events.h>
#include <tdehtml_part.h>
#include <tdehtmlview.h>

class TDEAction;
class KTempFile;

class HTMLView : public TDEHTMLPart
{
    TQ_OBJECT
  

    public:
        HTMLView( TQWidget *parentWidget = 0, const char *widgetname = 0, const bool DNDEnabled = false, const bool JScriptEnabled = true );
       ~HTMLView();

        static TQString loadStyleSheet();
        static void    openURLRequest(const KURL &url );
        void   set( const TQString& data );
        static void paletteChange();

    private:
        static KTempFile *m_bgGradientImage;
        static KTempFile *m_headerGradientImage;
        static KTempFile *m_shadowGradientImage;
        static int m_instances;

        TDEAction *m_selectAll;
        TDEAction *m_copy;

    private slots:
        void enableCopyAction();
        void selectAll();
        void copyText();
};

#endif /* AMAROK_HTMLVIEW_H */
