#include"qca.h"
#include<stdio.h>

int main(int argc, char **argv)
{
	TQCA::init();
	TQCString cs = (argc >= 2) ? argv[1] : "hello";

	if(!TQCA::isSupported(TQCA::CAP_SHA1))
		printf("SHA1 not supported!\n");
	else {
		TQString result = TQCA::SHA1::hashToString(cs);
		printf("sha1(\"%s\") = [%s]\n", cs.data(), result.latin1());
	}

	if(!TQCA::isSupported(TQCA::CAP_MD5))
		printf("MD5 not supported!\n");
	else {
		TQString result = TQCA::MD5::hashToString(cs);
		printf("md5(\"%s\") = [%s]\n", cs.data(), result.latin1());
	}

	return 0;
}

