#ifdef TQT_NO_CAST_ASCII
#undef TQT_NO_CAST_ASCII
#endif

#include "latin1literal.h"
#include <tqstring.h>
#include <kdebug.h>
#include <assert.h>

int main(int, char**) {
  kdDebug() << "\n*****************************************************" << endl;

  assert(TQString() == Latin1Literal(0));
  assert(TQString() != Latin1Literal(""));
  assert(TQString::fromLatin1("") == Latin1Literal(""));
  assert(TQString::fromLatin1("") != Latin1Literal(0));
  assert(TQString::fromLatin1("x") != Latin1Literal(""));
  assert(TQString::fromLatin1("a") == Latin1Literal("a"));
  assert(TQString::fromLatin1("a") != Latin1Literal("b"));
  assert(TQString::fromLatin1("\xe4") == Latin1Literal("\xe4"));
  assert(TQString::fromUtf8("\xe2\x82\xac") != Latin1Literal("?"));

  kdDebug() << "\nLatin1Literal Test OK !" << endl;
  kdDebug() << "\n*****************************************************" << endl;
}
