/***************************************************************************
    copyright            : (C) 2008 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_IMPORT_TELLICOXMLHANDLER_H
#define TELLICO_IMPORT_TELLICOXMLHANDLER_H

#include "xmlstatehandler.h"

#include <tqptrstack.h>

namespace Tellico {
  namespace Import {

class TellicoXMLHandler : public TQXmlDefaultHandler {
public:
  TellicoXMLHandler();
  ~TellicoXMLHandler();

  virtual bool startElement(const TQString& namespaceURI, const TQString& localName,
                            const TQString& qName, const TQXmlAttributes& atts);
  virtual bool endElement(const TQString& namespaceURI, const TQString& localName,
                          const TQString& qName);
  virtual bool characters(const TQString& ch);

  virtual TQString errorString();

  Data::CollPtr collection() const;
  bool hasImages() const;

  void setLoadImages(bool loadImages);

private:
  TQPtrStack<SAX::StateHandler> m_handlers;
  SAX::StateData* m_data;
};

  }
}
#endif
