/***************************************************************************
                          specialsb.cpp  -  description
                             -------------------
    begin                : dom ago 3 2003
    copyright            : (C) 2003 by gulmini luciano
    email                : gulmini.luciano@student.unife.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "specialsb.h"
#include "propertysetter.h"
#include "csseditor_globals.h"

#include <klineedit.h>

specialSB::specialSB(TQWidget *parent, const char *name, bool useLineEdit ) : miniEditor(parent,name) {
  if (useLineEdit)
  {
    m_lineEdit = new KLineEdit(this);
    m_sb = 0L;
    connect(m_lineEdit, TQ_SIGNAL(textChanged ( const TQString & )), this, TQ_SLOT(lineEditValueSlot ( const TQString & )));
  }
  else
  {
    m_sb=new mySpinBox(this);
    connect(m_sb, TQ_SIGNAL(valueChanged ( const TQString & )), this, TQ_SLOT(sbValueSlot(const TQString&)));
    m_lineEdit = 0L;
  }
  m_cb = new TQComboBox(this);
  connect(m_cb, TQ_SIGNAL(activated ( const TQString & )), this, TQ_SLOT(cbValueSlot(const TQString&)));
}

specialSB::~specialSB(){
  delete m_cb;
  delete m_sb;
  delete m_lineEdit;
}

void specialSB::connectToPropertySetter(propertySetter* p){
  connect(this, TQ_SIGNAL(valueChanged(const TQString&)), p,TQ_SIGNAL(valueChanged(const TQString&)));
}


void specialSB::cbValueSlot(const TQString& s){
  if (m_sb)
    emit valueChanged( m_sb->text() +s );
  else
    emit valueChanged( m_lineEdit->text() +s );
}

void specialSB::sbValueSlot(const TQString& s){
  emit valueChanged( s + m_cb->currentText());
}

void specialSB::lineEditValueSlot(const TQString& s){
  emit valueChanged( s + m_cb->currentText());
}

void specialSB::setInitialValue(const TQString& s){

  TQRegExp pattern("\\d("+ cbValueList().join("|")+")");

  if (pattern.search(s) != -1) {
    TQString temp(s.stripWhiteSpace());
    TQString cbValue = pattern.cap(1);

    if (m_sb)
      m_sb->setValue(temp.remove(cbValue).toInt());
    else
      m_lineEdit->setText(temp.remove(cbValue));
    m_cb->setCurrentText(cbValue);
  }
  else return;
}

TQStringList specialSB::cbValueList(){
  TQStringList l;
  for(int i=0; i<m_cb->count();i++) l.append(m_cb->text(i));
  return l;
}

frequencyEditor::frequencyEditor(TQWidget *parent, const char *name ) : specialSB(parent,name) {
  m_cb->insertItem("Hz");
  m_cb->insertItem("kHz");
  m_sb->setMaxValue(9999);
}

angleEditor::angleEditor(TQWidget *parent, const char *name) : specialSB(parent,name){
  m_cb->insertItem("deg");
  m_cb->insertItem("grad");
  m_cb->insertItem("rad");
  m_sb->setMaxValue(-400);
  m_sb->setMaxValue(400);
}

timeEditor::timeEditor(TQWidget *parent, const char *name ) : specialSB(parent,name) {
  m_cb->insertItem("ms");
  m_cb->insertItem("s");
  m_sb->setMaxValue(99999);
}

lengthEditor::lengthEditor(TQWidget *parent, const char *name ) : specialSB(parent,name, true) {
  m_cb->insertItem("px");
  m_cb->insertItem("em");
  m_cb->insertItem("ex");
  m_cb->insertItem("in");
  m_cb->insertItem("cm");
  m_cb->insertItem("mm");
  m_cb->insertItem("pt");
  m_cb->insertItem("pc");
  if (m_sb)
    m_sb->setMaxValue(99999);
}





#include "specialsb.moc"
