/***************************************************************************
                             tagattributeitems.h
                             -------------------
    copyright            : (C) 2003 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#ifndef TAGATTRIBUTEITEM_H
#define TAGATTRIBUTEITEM_H

#include <tqptrlist.h>

class KColorCombo;
class KURLRequester;
class TDEListView;
class TDEListViewItem;
class TQListViewItem;
class TQLineEdit;
class TQComboBox;

class Attribute;
class EditableTree;
class TagAttributeTree;
class Node;
class StyleEditor;

class TopLevelItem : public TDEListViewItem
{

public:
    TopLevelItem(TDEListView *parent, const TQString& title);
    TopLevelItem(TDEListView *parent, TQListViewItem* after, const TQString& title);

    virtual ~TopLevelItem();

protected:

    void paintCell( TQPainter *p, const TQColorGroup &cg,
                    int column, int width, int align );
};

class ParentItem : public TDEListViewItem
{

public:
    ParentItem(TagAttributeTree *listView, TQListViewItem *parent);

    virtual ~ParentItem();
    Node *node(int index);
    void addNode(Node *node);
    void showList(bool show);

protected:

    void paintCell( TQPainter *p, const TQColorGroup &cg,
                    int column, int width, int align );

private:
    TQPtrList<Node> m_nodeList;
    TQComboBox *comboBox;
    TagAttributeTree *m_listView;
};

class AttributeItem : public TDEListViewItem
{
public:
    AttributeItem(TQListViewItem* parent, const TQString& title, const TQString& title2);
    AttributeItem(EditableTree *listView, TQListViewItem* parent, const TQString& title, const TQString& title2);
    AttributeItem(EditableTree *listView, const TQString& title, const TQString& title2);
    AttributeItem(EditableTree *listView, const TQString& title, const TQString& title2, TQListViewItem* after);

    virtual ~AttributeItem();
    virtual void replaceCurrentEditor();
    virtual void showEditor(int column = 1);
    virtual void hideEditor(int column = 1);
    virtual void placeEditor(TQWidget *w, int column = 1);
    virtual TQString editorText(int column = 1);

    //I'm not sane... lin is the right editor, lin2 is the left one.
    TQLineEdit *lin, *lin2;

protected:

    void paintCell( TQPainter *p, const TQColorGroup &cg,
                    int column, int width, int align );

    EditableTree *m_listView;
};

class AttributeNameSpaceItem:public AttributeItem
{
public:
    AttributeNameSpaceItem(TQListViewItem* parent, const TQString& title, const TQString& title2): AttributeItem(parent, title, title2){};
    AttributeNameSpaceItem(EditableTree *listView, TQListViewItem* parent, const TQString& title, const TQString& title2):AttributeItem(listView, parent, title, title2){};
    virtual ~AttributeNameSpaceItem(){};

};

class AttributeBoolItem : public AttributeItem
{
public:
    AttributeBoolItem(TagAttributeTree *listView, TQListViewItem* parent, const TQString& title, const TQString& title2);

    virtual ~AttributeBoolItem();
    virtual void showEditor(int column = 1);
    virtual void hideEditor(int column = 1);
    virtual TQString editorText(int column = 1);

private:
    TQComboBox* combo;
};

class AttributeUrlItem : public AttributeItem
{
public:
    AttributeUrlItem(TagAttributeTree *listView, TQListViewItem* parent, const TQString& title, const TQString& title2);

    virtual ~AttributeUrlItem();
    virtual void showEditor(int column = 1);
    virtual void hideEditor(int column = 1);
    virtual TQString editorText(int column = 1);

private:
    KURLRequester* urlRequester;
};

class AttributeListItem : public AttributeItem
{
public:
    AttributeListItem(EditableTree *listView, TQListViewItem* parent, const TQString& title, const TQString& title2, Attribute *attr = 0L);

    virtual ~AttributeListItem();
    virtual void showEditor(int column = 1);
    virtual void hideEditor(int column = 1);
    virtual TQString editorText(int column = 1);

private:
    TQComboBox* combo;
};

class AttributeColorItem : public AttributeItem
{
public:
    AttributeColorItem(EditableTree *listView, TQListViewItem* parent, const TQString& title, const TQString& title2);

    virtual ~AttributeColorItem();
    virtual void showEditor(int column = 1);
    virtual void hideEditor(int column = 1);
    virtual TQString editorText(int column = 1);

private:
    KColorCombo* combo;
};

class AttributeStyleItem : public AttributeItem
{
public:
    AttributeStyleItem(EditableTree *listView, TQListViewItem* parent, const TQString& title, const TQString& title2);

    virtual ~AttributeStyleItem();
    virtual void showEditor(int column = 1);
    virtual void hideEditor(int column = 1);
    virtual TQString editorText(int column = 1);

private:

    StyleEditor *m_se;
};


#endif
