/***************************************************************************
 *   Copyright (C) 2005-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#include "urldlg.h"
#include <kcombobox.h>
#include <kurlrequester.h>
#include <tqlayout.h>
#include <tdeconfig.h>
#include <tdelocale.h>
#include <tdeglobal.h>
#include <klineedit.h>
#include <kurl.h>
#include <kdebug.h>

#include <tqlabel.h>

UrlDlg::UrlDlg(TQWidget *parent, const char *name)
 : KDialogBase(Plain, TQString(), Ok|Cancel|User1, Ok, parent, name,
                true,true, KStdGuiItem::clear())
{
    init_dlg();
}


UrlDlg::~UrlDlg()
{
}


/*!
    \fn UrlDlg::init_dlg
 */
void UrlDlg::init_dlg()
{
    TQVBoxLayout * topLayout = new TQVBoxLayout( plainPage(), 0, spacingHint());
    TQLabel * label = new TQLabel(i18n("Open repository or working copy") , plainPage());
    topLayout->addWidget(label);

    KHistoryCombo * combo = new KHistoryCombo(0,"history_combo");
    combo->setDuplicatesEnabled(false);
    TDEConfig *kc = TDEGlobal::config();
    TDEConfigGroupSaver ks( kc, TQString::fromLatin1("Open-repository settings") );
    int max = kc->readNumEntry( TQString::fromLatin1("Maximum history"), 15 );
    combo->setMaxCount( max );
    TQStringList list = kc->readListEntry( TQString::fromLatin1("History") );
    combo->setHistoryItems(list);
    combo->setMinimumWidth(100);
    combo->adjustSize();
    if (combo->width()>300) {
        combo->resize(300,combo->height());
    }

    urlRequester_ = new KURLRequester(combo, plainPage(), "urlRequester");
    topLayout->addWidget( urlRequester_ );
    urlRequester_->setFocus();
    KFile::Mode mode = static_cast<KFile::Mode>(KFile::ExistingOnly|KFile::Directory);
    urlRequester_->setMode(mode);
    connect(urlRequester_->comboBox(),TQ_SIGNAL(textChanged(const TQString&)),TQ_SLOT(slotTextChanged(const TQString&)));
    enableButtonOK( false );
    enableButton( KDialogBase::User1, false );
    connect( this, TQ_SIGNAL(user1Clicked()), TQ_SLOT(slotClear()));
    urlRequester_->adjustSize();
    resize(TQSize(400,sizeHint().height()));
}

/*!
    \fn UrlDlg::accept()
 */
void UrlDlg::accept()
{
    KHistoryCombo *combo = static_cast<KHistoryCombo*>(urlRequester_->comboBox());
    if (combo) {
        combo->addToHistory(urlRequester_->url());
        TDEConfig *kc = TDEGlobal::config();
        TDEConfigGroupSaver ks(kc, TQString::fromLatin1("Open-repository settings"));
        kc->writeEntry(TQString::fromLatin1("History"), combo->historyItems());
        kc->sync();
    }
    KDialogBase::accept();
}


/*!
    \fn UrlDlg::slotTextChanged(const TQString&)
 */
void UrlDlg::slotTextChanged(const TQString&text)
{
    bool state = !text.stripWhiteSpace().isEmpty();
    enableButtonOK( state );
    enableButton( KDialogBase::User1, state );
}


/*!
    \fn UrlDlg::slotClear()
 */
void UrlDlg::slotClear()
{
    urlRequester_->clear();
}


/*!
    \fn UrlDlg::selectedURL()
 */
KURL UrlDlg::selectedURL()
{
    if ( result() == TQDialog::Accepted ) {
        KURL uri = urlRequester_->url();
        return uri;
        //return KURL::fromPathOrURL( urlRequester_->url() );
    } else {
        return KURL();
    }
}


/*!
    \fn UrlDlg::getURL(TQWidget*parent)
 */
KURL UrlDlg::getURL(TQWidget*parent)
{
    UrlDlg dlg(parent);
    dlg.setCaption(i18n("Open"));
    dlg.exec();
    const KURL& url = dlg.selectedURL();
    return url;
}

#include "urldlg.moc"
