/*
 * KMix -- KDE's full featured mini mixer
 *
 *
 * Copyright (C) 2000 Stefan Schimanski <1Stein@gmx.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KMIXAPPLET_H
#define KMIXAPPLET_H

// TQt
#include <tqlayout.h>
#include <tqptrlist.h>
#include <tqwidget.h>

// KDE
#include <tdeaboutdata.h>
#include <kdialogbase.h>
#include <kpanelapplet.h>

//KMix
#include "viewapplet.h"

class Mixer;
class ColorWidget;
class KMixApplet;


class AppletConfigDialog : public KDialogBase
{
  TQ_OBJECT
  
  public:
   AppletConfigDialog( TQWidget * parent=0, const char * name=0 );
   virtual ~AppletConfigDialog() {};

   void setActiveColors(const TQColor& high, const TQColor& low, const TQColor& back);
   void activeColors(TQColor& high, TQColor& low, TQColor& back) const;

   void setMutedColors(const TQColor& high, const TQColor& low, const TQColor& back);
   void mutedColors(TQColor& high, TQColor& low, TQColor& back) const;

   void setUseCustomColors(bool);
   bool useCustomColors() const;

  protected slots:
   virtual void slotOk();
   virtual void slotApply();

  signals:
   void applied();
  private:
   ColorWidget* colorWidget;
};


class KMixApplet : public KPanelApplet
{
   TQ_OBJECT
  

public:
   KMixApplet( const TQString& configFile, Type t = Normal,
	       TQWidget *parent = 0, const char *name = 0 );
   virtual ~KMixApplet();

   struct Colors {
       TQColor high, low, back, mutedHigh, mutedLow, mutedBack;
   };

   void about();
   void help();
   void preferences();   
   void reportBug();
   void paletteChange ( const TQPalette & oldPalette );

   TQSize sizeHint() const;
   TQSizePolicy sizePolicy() const;
   int widthForHeight(int) const;
   int heightForWidth(int) const;

protected slots:
   void selectMixer();
   void applyPreferences();
   void preferencesDone();
   void updateGeometrySlot();
  
protected:
   void resizeEvent( TQResizeEvent * );
   void saveConfig();
   void saveConfig( TDEConfig *config, const TQString &grp );
   void loadConfig();
   void loadConfig( TDEConfig *config, const TQString &grp );

private:
   void positionChange(Position);
   void setColors();
   void setColors( const Colors &color );

   ViewApplet *m_mixerWidget;
   TQPushButton *m_errorLabel;
   AppletConfigDialog *m_pref;

   static int             s_instCount;
   Mixer                  *_mixer;

   KMixApplet::Colors _colors;
   bool               _customColors;

   TQLayout* _layout;

   TQString _mixerId;
   TQString _mixerName;

   TDEAboutData m_aboutData;
};


#endif
