/***************************************************************************
    begin                : Sun Feb 17 2002
    copyright            : (C) 2002 - 2004 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TAG_H
#define TAG_H

#include <tqfileinfo.h>

namespace TagLib { class File; }

class CacheDataStream;

/*!
 * This should really be called "metadata" and may at some point be titled as
 * such.  Right now it's mostly a TQt wrapper around TagLib.
 */

class Tag
{
    friend class FileHandle;
public:
    Tag(const TQString &fileName);
    /**
     * Create an empty tag.  Used in FileHandle for cache restoration.
     */
    Tag(const TQString &fileName, bool);

    bool save();

    TQString title() const { return m_title; }
    TQString artist() const { return m_artist; }
    TQString album() const { return m_album; }
    TQString genre() const { return m_genre; }
    int track() const { return m_track; }
    int year() const { return m_year; }
    TQString comment() const { return m_comment; }

    TQString fileName() const { return m_fileName; }

    void setTitle(const TQString &value) { m_title = value; }
    void setArtist(const TQString &value) { m_artist = value; }
    void setAlbum(const TQString &value) { m_album = value; }
    void setGenre(const TQString &value) { m_genre = value; }
    void setTrack(int value) { m_track = value; }
    void setYear(int value) { m_year = value; }
    void setComment(const TQString &value) { m_comment = value; }

    void setFileName(const TQString &value) { m_fileName = value; }

    int seconds() const { return m_seconds; }
    int bitrate() const { return m_bitrate; }

    bool isValid() const { return m_isValid; }

    /**
     * As a convenience, since producing a length string from a number of second
     * isn't a one liner, provide the length in string form.
     */
    TQString lengthString() const { return m_lengthString; }
    CacheDataStream &read(CacheDataStream &s);

private:
    void setup(TagLib::File *file);

    TQString m_fileName;
    TQString m_title;
    TQString m_artist;
    TQString m_album;
    TQString m_genre;
    TQString m_comment;
    int m_track;
    int m_year;
    int m_seconds;
    int m_bitrate;
    TQDateTime m_modificationTime;
    TQString m_lengthString;
    bool m_isValid;
};

TQDataStream &operator<<(TQDataStream &s, const Tag &t);
CacheDataStream &operator>>(CacheDataStream &s, Tag &t);

#endif
