/***************************************************************************
    begin                : Thu Oct 28 2004
    copyright            : (C) 2004 by Michael Pyne
    email                : michael.pyne@kdemail.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kurlrequester.h>
#include <tdelocale.h>

#include <tqradiobutton.h>
#include <tqlayout.h>

#include "exampleoptions.h"

ExampleOptions::ExampleOptions(TQWidget *parent) :
    ExampleOptionsBase(parent, "example options widget")
{
}

void ExampleOptions::exampleSelectionChanged()
{
    if(m_fileTagsButton->isChecked())
        emit fileChanged();
    else
        emit dataChanged();
}

void ExampleOptions::exampleDataChanged()
{
    emit dataChanged();
}

void ExampleOptions::exampleFileChanged()
{
    emit fileChanged();
}

ExampleOptionsDialog::ExampleOptionsDialog(TQWidget *parent) :
    TQDialog(parent, "example options dialog")
{
    setCaption(i18n("JuK"));
    TQVBoxLayout *l = new TQVBoxLayout(this);

    m_options = new ExampleOptions(this);
    l->addWidget(m_options);

    // Forward signals

    connect(m_options, TQ_SIGNAL(fileChanged()), TQ_SLOT(fileModeSelected()));
    connect(m_options, TQ_SIGNAL(dataChanged()), TQ_SIGNAL(dataChanged()));
    connect(m_options->m_exampleFile, TQ_SIGNAL(urlSelected(const TQString &)),
            this,                     TQ_SIGNAL(fileChanged(const TQString &)));
    connect(m_options->m_exampleFile, TQ_SIGNAL(returnPressed(const TQString &)),
            this,                     TQ_SIGNAL(fileChanged(const TQString &)));
}

void ExampleOptionsDialog::hideEvent(TQHideEvent *)
{
    emit signalHidden();
}

void ExampleOptionsDialog::showEvent(TQShowEvent *)
{
    emit signalShown();
}

void ExampleOptionsDialog::fileModeSelected()
{
    emit fileChanged(m_options->m_exampleFile->url());
}

#include "exampleoptions.moc"
