#include "sprite.h"

Sprite::Sprite(Screen* screen, int x, int y, int z, int frameDelay):
    m_screen(screen), m_currentFrame(0), m_x(x), m_y(y), m_z(z),
    m_isKilled(false), m_killAfterLastFrame(false),
    m_ticksSinceFrameChange(0), m_frameDelay(frameDelay)
{
}

void Sprite::addFrame(const Frame& frame)
{
    m_frames.append(frame);
}

void Sprite::erase()
{
    m_frames[m_currentFrame].erase(m_screen, m_x, m_y);
}

void Sprite::paint()
{
    m_frames[m_currentFrame].paint(m_screen, m_x, m_y);
}

bool Sprite::timerTick()
{
    ++m_ticksSinceFrameChange;
    if (m_ticksSinceFrameChange * m_screen->msPerTick() < m_frameDelay)
        return false;

    //Ring! Ring!
    m_ticksSinceFrameChange = 0;
    return true;
}

bool Sprite::tickUpdate()
{
    if (m_frames.size() == 1)
        return false;

    if (!timerTick())
        return false;

    erase();

    ++m_currentFrame;
    if (m_currentFrame == m_frames.size())
    {
        m_currentFrame = 0;

        if(m_killAfterLastFrame)
        {
            erase();
            kill();
        }
    }

    return true;
}

TQRect Sprite::geom() const
{
    return TQRect(m_x, m_y, m_frames[0].width(), m_frames[0].height());
}
