"""
A basic panel applet template - working examples are in the
pykpanelapplet/ directory
"""
"""
Copyright 2003 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""

from tdeui import PyKPanelApplet, KPanelApplet


# Any panel applet written in Python must include THIS "factory" function
# The name must be createApplet, and it must take the two args shown; it
# must return a PyKPanelApplet subclass

# Change "PanelAppletName" to something meaningful here and in the class
# declaration
def createApplet (parent, configFile):
    return PanelAppletName (configFile, KPanelApplet.Normal, 0, parent, "nameMe")


# Define the PyKPanelApplet subclass in a fashion similar to this
# (PyKPanelApplet is a subclass of KPanelApplet, and exposes all of
# KPanelApplet's methods)

# You can change the arg list for __init__ as needed (and make the corresponding
# change in the call in createApplet), as long as you have the basic info
# needed to call PyKPanelApplet.__init__
class PanelAppletName (PyKPanelApplet):
    def __init__  (self, configFile, t, actions, parent, name, f = 0):
        PyKPanelApplet.__init__ (self, configFile, t, actions, parent, name, f)

# Change these methods to have kicker size your applet appropriately
# As written, they provide a square applet window
    def widthForHeight (self, h):
        return h

    def heightForWidth (self, w ):
        return w
