/***************************************************************************
                           kxetreeviewsettings.h
                           ---------------------
    begin                : Tue Dec 02 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : hartig@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXETREEVIEWSETTINGS_H
#define KXETREEVIEWSETTINGS_H

#include "kxesettings.h"

class KXETreeViewSettingsPage;

/**
 * This class represents the group of configuration settings for the
 * tree view.
 *
 * @author Olaf Hartig
 */
class KXETreeViewSettings : public KXESettings
{
	public:

		enum AttributeVisibility
		{
			NoAttributes,
			NamesOnly,
			NamesAndValues
		};

		KXETreeViewSettings( TQObject * pParent = 0, const char * pszName = 0 );

		// The following functions can be used to access this object's settings.
		bool createItemsOnDemand() const { return m_bCreateItemsOnDemand; }
		int dfltExpLevel() const { return m_iDfltExpLevel; }
		bool decorateRoot() const { return m_bDecorateRoot; }
		bool enableDragging() const { return m_bEnableDragging; }
		bool enableDropping() const { return m_bEnableDropping; }
		AttributeVisibility elemDisplMode() const { return m_enmElemDisplMode; }

		/**
		 * Derived from @ref KXESettings
		 */
		virtual TQString dialogPageName() const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual TQString dialogPageHeader() const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual TQString dialogPageIcon() const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual TQWidget * dialogPage( TQFrame * pParent );

	protected:

		/**
		 * Derived from @ref KXESettings
		 */
		virtual void write( TDEConfig * ) const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual void read( const TDEConfig * );
		/**
		 * Derived from @ref KXESettings
		 */
		virtual void setFromPage();
		/**
		 * Derived from @ref KXESettings
		 */
		virtual void updatePage() const;

		// the settings itself
		bool m_bCreateItemsOnDemand;
		int m_iDfltExpLevel;
		bool m_bDecorateRoot;
		bool m_bEnableDragging;
		bool m_bEnableDropping;
		AttributeVisibility m_enmElemDisplMode;

		/**
		 * the corresponding configuration dialog page
		 * It is created on demand by @ref dialogPage.
		 */
		KXETreeViewSettingsPage * m_pDialogPage;
};

#endif
