/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//BEGIN INCLUDES
#ifndef NEWPROFILEWIZARD_H
#define NEWPROFILEWIZARD_H

#include <tqwizard.h>
#include <tqwidget.h>
#include <tqhbox.h>
#include <tqvbox.h>
#include <tqstring.h>
#include <tqobject.h>
#include <tqpixmap.h>


#include "kvpncconfig.h"

#include "newprofilewizardtypeselection.h"
#include "newprofilewizardgeneral.h"
#include "newprofilewizardciscoselection.h"
#include "newprofilewizardciscomanually.h"
#include "importprofiledialog.h" // PCF import
#include "importopenvpnprofiledialog.h" //< OpenVPN import
#include "importipsecprofiledialog.h" //< IPSec import
#include "newprofilewizardracoon.h"
#include "newprofilewizardfreeswan.h"
#include "newprofilewizardopenvpn.h"
#include "newprofilewizardopenvpnauth.h"
#include "newprofilewizardopenvpnselection.h"
#include "newprofilewizardpptp.h"
#include "profilevtunoptions.h"
#include "profilesshoptions.h"
#include "newprofilewizardauthselection.h"
#include "newprofilewizardpsk.h"
#include "newprofilewizardcert.h"
#include "newprofilewizardstart.h"
#include "newprofilewizarduser.h"
#include "newprofilewizardnetwork.h"
#include "newprofilewizardnetworkroute.h"
#include "newprofilewizardnat.h"
#include "newprofilewizardp12certselection.h"
#include "importcertificatedialog.h"
#include "newprofilewizardconnectoptions.h"
#include "newprofilewizardconnectionstatuscheck.h"
#include "profilenetworkvirtualipoptions.h"
#include "profilenetworkrouteoptions.h"

//END INCLUDES

/**
Provides a wizard for creating a new profile

@author Christoph Thielecke
*/
class NewProfileWizard : public TQWizard
{
TQ_OBJECT
  
public:
	NewProfileWizard(KVpncConfig* GlobalConfig);

	void dataChanged( const TQString & );
	TQString getName();
	TQString getProfile();
	bool getFinished();
	bool newProfileCreated;
	bool daemonavailable; //< true if required is found, used for connecting after creating
	bool connectaftercreating; //< connect if successful created
	VpnAccountData *profileData;

public slots:
	void showPage( TQWidget* page );
	void next ();
	void back();
	void accept();
	void reject();
	void userdefinedOpenvpnPortToggeled(bool);
	void nsCertTypeOpenvpnToggled(bool);
	void additionalNetworkRoutesToggled(bool);
	void addNetworkRouteClicked();
	void delNetworkRouteClicked();
	void pskIsInFileToggled(bool);
	void useNatToggled(bool);
	void udpPortToggled(bool);
	void pingIpAfterConnectToggled(bool);
	void useSpecialServerCertificateToggled(bool);
	void useUserdefiniedCipherToggled(bool);
	void useHttpProxyToggeled(bool);
	void useTlsAuthToggled(bool);
	void useTlsRemoteHostToggled(bool);
	void connectionStatusCheckToggled(bool);
	void authenticateWithUsernameAndPasswordToggled(bool);
	void pskInputToggled(const TQString& str);
	void userpassToggled(const TQString& str);
	void usernameToggled(const TQString& str);
	void pskToggled(const TQString& str);
	void useRightNextHopToggled(bool);
	void useLeftNextHopToggled(bool);
	void domainNameToggled(bool);
	void idTypeToggled();
	void usePkcs11ProvidersToggled(bool);
	void useSmartcardToggled(bool);
	void useSmartcardOnCertFormateToggled(bool);
	void detectPkcs11Ids();
	void detectPkcs11Slots();
	void mtuToggled(bool);
	void mruToggled(bool);
	void useVirtualIpAddressToggled(bool);
	void usePortToggled(bool);
	void useAuthenticationAlgorithmToggled(bool);
	void useRemoteNetworkToggled(bool);
	void useEspToogled(bool);
	void useIkeToggled(bool);
	void remoteIDTypeRacoonToggled(const TQString&);
	void localIDTypeRacoonToggled(const TQString&);
	void remoteIDTypeIpsecToggled(const TQString&);
	void localIDTypeIpsecToggled(const TQString&);
	void defaultRouteToggled(const TQString&);
	void ikeGroupToggled(bool);
	void useXauthFreeswanToggled(bool);
	void useXauthRacoonToggled(bool);
	void tunnelDeviceTypeChanged(const TQString &);
	void useDnsServerToggled(bool);
	void useSearchDomainInResolvConfToggled(bool);
	void useDomainInResolvConfToggled(bool);
	//void reject();

protected:
	TQString ConnectionType;
	TQString Gateway;
	TQString ID;
	TQString Username;
	TQString UserPassword;
	TQString PreSharedKey;
	TQString ApplicationVersion;
	TQString NtDomainName;
	TQString PerfectForwardSecrecy;
	TQString IkeGroup;
	TQString DnsServer; //< userdefined DNS server for pptp
	TQString Name;
	TQString Description;
	bool saveUserPassword;
	bool savePsk;
	bool useApplicationVersion;
	bool useGlobalIpsecSecret;
	bool useIkeGroup;
	bool useLocalPort;
	bool useNtDomainName;
	bool useSingleDes;
	bool useAdvancedSettings;
	bool usePerfectSecrecy;
	bool useUdp; //< True if NAT-T should be used
	bool useUdpPort; //< True if userdefined UDP port should be used
	bool useDnsServer; //< True if userdefined DNS server should be used
	bool useGetDnsFromPeer; //< True if DNS servers should be retrieved from peer (pptp)bool
	bool refuse40BitEncryption; //< True if 40 bit encryption is refused (pptp)
	bool refuse128BitEncryption; //< True if 128 bit encryption is refused (pptp)
	bool allowStatefulMode;
	bool useNoBsdComp;
	bool useNoDeflate;
	bool requireMppe; //< True if MPPE is required (pptp)
	bool refuseEap; //< True if EAP is refused (pptp)
	int Port;
	int UdpPort; //< Port number of UDP port

private:
	void setupPages();
	bool importProfile(VpnAccountData::ConnectionType ConnType);
	bool importCertificate();
	TQHBox *page1;
	TQHBox *newprofilewizardtypeselectionpage;
	TQHBox *newprofilewizardgeneralpage;
	TQHBox *newprofilewizardciscoselectionpage;
	TQHBox *newprofilewizardciscomanuallypage;
	TQHBox *newprofilewizardracoonpage;
	TQHBox *newprofilewizardfreeswanpage;
	TQHBox *newprofilewizardfreeswanselectionpage;
	TQHBox *newprofilewizardopenvpnpage;
	TQHBox *newprofilewizardopenvpnselectionpage;
	TQHBox *newprofilewizardopenvpnauthpage;
	TQHBox *newprofilewizardpptppage;
	TQHBox *newprofilewizardvtunpage;
	TQHBox *newprofilewizardsshpage;
	TQHBox *newprofilewizardauthselectionpage;
	TQHBox *newprofilewizardpskpage;
	TQHBox *newprofilewizardcertpage;
	TQHBox *newprofilewizardp12certselectionpage;
	TQHBox *newprofilewizarduserpage;
	TQHBox *newprofilewizardnetworkpage;
	TQHBox *newprofilewizardvirtualipaddresspage;
	TQHBox *newprofilewizardnetworkroutepage;
	TQHBox *newprofilewizardnatpage;
	TQHBox *newprofilewizardconnectionstatuscheckpage;
	TQHBox *newprofilewizardconnectoptionspage;
	TQHBox *endpage;
	NewProfileWizardTypeSelection *newprofilewizardtypeselectionpagecontent;
	NewProfileWizardGeneral *newprofilewizardgeneralpagecontent;
	NewProfileWizardCiscoSelection *newprofilewizardciscoselectionpagecontent;
	NewProfileWizardCiscoManually *newprofilewizardciscomanuallypagecontent;
	NewProfileWizardRacoon *newprofilewizardracoonpagecontent;
	NewProfileWizardFreeswan *newprofilewizardfreeswanpagecontent;
	NewProfileWizardOpenvpnSelection *newprofilewizardfreeswanselectionpagecontent;
	NewProfileWizardOpenvpn *newprofilewizardopenvpnpagecontent;
	NewProfileWizardOpenvpnAuth *newprofilewizardopenvpnauthpagecontent;
	NewProfileWizardOpenvpnSelection *newprofilewizardopenvpnselectionpagecontent;
	NewProfileWizardPptp *newprofilewizardpptppagecontent;
	ProfileVtunOptions *newprofilewizardvtunpagecontent;
	ProfileSshOptions *newprofilewizardsshpagecontent;
	NewProfileWizardAuthSelection *newprofilewizardauthselectioncontent;
	NewProfileWizardPsk *newprofilewizardpskcontent;
	NewProfileWizardCert *newprofilewizardcertcontent;
	NewProfileWizardStart *newprofilewizardstartcontent;
	NewProfileWizardP12CertSelection *newprofilewizardp12certselectioncontent;
	NewProfileWizardUser *newprofilewizarduserpagecontent;
	NewProfileWizardNetwork *newprofilewizardnetworkcontent;
	ProfileNetworkRouteOptions *newprofilewizardnetworkroutecontent;
	NewProfileWizardNat *newprofilewizardnatcontent;
	NewProfileWizardConnectionStatusCheck *newprofilewizardconnectionstatuscheckcontent;
	NewProfileWizardConnectOptions *newprofilewizardconnectoptionscontent;
	ProfileNetworkVirtualIpOptions *profilenetworkvirtualipoptionscontent;
	KVpncConfig* GlobalConfig; //< pointer to global config class
	TQWidget* currentpage; // pointer to current page
	TQWidget* previouspage; //< pointer to previous page
	bool finished;
	bool enterdatamanually; //< enter data manually
	bool useCert; //< use certificate for authentication
	bool importOK; //< import was successful
	TQPixmap *SetupPixmap;
	TQPixmap *SetupPixmapFinal;

};

#endif
