/***************************************************************************
*   Copyright (C) 2003-2004 by                                            *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "createunitdialog.h"

#include <tqlabel.h>

#include <tdelocale.h>
#include <klineedit.h>
#include <kcombobox.h>

CreateUnitDialog::CreateUnitDialog( TQWidget *parent, const TQString &name, const TQString &plural, const TQString &name_abbrev, const TQString &plural_abbrev, bool newUnit )
		: KDialogBase( parent, "createElementDialog", true, (newUnit)?i18n( "New Unit" ):i18n("Unit"),
		    KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok )
{
	TQVBox *page = makeVBoxMainWidget();

	box = new TQGroupBox( page );
	box->setColumnLayout( 0, TQt::Vertical );
	box->layout() ->setSpacing( 6 );
	box->layout() ->setMargin( 11 );
	TQGridLayout *gridLayout = new TQGridLayout( box->layout() );
	gridLayout->setAlignment( TQt::AlignTop );

	box->setTitle( (newUnit)?i18n( "New Unit" ):i18n("Unit") );

	TQLabel *nameLabel = new TQLabel( i18n( "Singular:" ), box );
	nameEdit = new KLineEdit( name, box );

	gridLayout->addWidget( nameLabel, 0, 0 );
	gridLayout->addWidget( nameEdit, 0, 1 );

	TQLabel *nameAbbrevLabel = new TQLabel( i18n( "Abbreviation:" ), box );
	nameAbbrevEdit = new KLineEdit( name_abbrev, box );

	gridLayout->addWidget( nameAbbrevLabel, 0, 2 );
	gridLayout->addWidget( nameAbbrevEdit, 0, 3 );

	TQLabel *pluralLabel = new TQLabel( i18n( "Plural:" ), box );
	pluralEdit = new KLineEdit( plural, box );

	gridLayout->addWidget( pluralLabel, 1, 0 );
	gridLayout->addWidget( pluralEdit, 1, 1 );

	TQLabel *pluralAbbrevLabel = new TQLabel( i18n( "Abbreviation:" ), box );
	pluralAbbrevEdit = new KLineEdit( plural_abbrev, box );

	gridLayout->addWidget( pluralAbbrevLabel, 1, 2 );
	gridLayout->addWidget( pluralAbbrevEdit, 1, 3 );

	TQLabel *typeLabel = new TQLabel( i18n( "Type:" ), box );
	typeComboBox = new KComboBox( false, box );
	typeComboBox->insertItem(i18n("Other"));
	typeComboBox->insertItem(i18n("Mass"));
	typeComboBox->insertItem(i18n("Volume"));

	gridLayout->addWidget( typeLabel, 2, 0 );
	gridLayout->addMultiCellWidget( typeComboBox, 2, 2, 1, 3 );

	adjustSize();
	setFixedSize( size() ); //we've got all the widgets put in, now let's keep it this size

	connect( nameAbbrevEdit, TQ_SIGNAL(textChanged(const TQString&)), TQ_SLOT(nameAbbrevTextChanged(const TQString &)) );

	if ( name.isEmpty() )
		nameEdit->setFocus();
	else if ( plural.isEmpty() )
		pluralEdit->setFocus();
}


CreateUnitDialog::~CreateUnitDialog()
{}

Unit CreateUnitDialog::newUnit( void )
{
	TQString name = nameEdit->text();
	TQString plural = pluralEdit->text();

	if ( name.isEmpty() )
		name = plural;
	if ( plural.isEmpty() )
		plural = name;

	Unit new_unit = Unit( name, plural );
	new_unit.name_abbrev = nameAbbrevEdit->text();
	new_unit.plural_abbrev = pluralAbbrevEdit->text();

	new_unit.type = (Unit::Type)typeComboBox->currentItem();

	return new_unit;
}

void CreateUnitDialog::nameAbbrevTextChanged(const TQString &newText)
{
	//appending
	if ( newText.left( newText.length()-1 ) == pluralAbbrevEdit->text() ) {
		pluralAbbrevEdit->setText( newText );
	}

	//truncating
	if ( newText.left( newText.length()-1 ) == pluralAbbrevEdit->text().left( newText.length()-1 ) ) {
		pluralAbbrevEdit->setText( newText );
	}
}

#include "createunitdialog.moc"
