/***************************************************************************
                          kplayerwidget.h
                          ---------------
    begin                : Sun Dec 01 2002
    copyright            : (C) 2002-2007 by kiriuja
    email                : http://kplayer.sourceforge.net/email.html
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KPLAYERWIDGET_H
#define KPLAYERWIDGET_H

#include <tqtimer.h>
#include <tqwidget.h>

#include "kplayerprocess.h"

/** The KPlayer widget where mplayer video output is displayed.
  *@author kiriuja
  */
class KPlayerWidget : public TQWidget
{
   TQ_OBJECT

public: 
  /** The widget constructor. Initializes internal data structures.
      Parameters are passed to the TQWidget constructor. */
  KPlayerWidget (TQWidget* parent = 0, const char* name = 0);
  /** The widget destructor. Frees allocated memory. */
  virtual ~KPlayerWidget();

  void mapHandler (uint wid);
  void unmapHandler (uint wid);

  void sendConfigureEvent (void);

protected:
  /** Processes the widget resize event. Ensures that MPlayer
      continues to display video. Emits resized signal. */
  virtual void resizeEvent (TQResizeEvent*);
  /** Processes the widget show event. Ensures that MPlayer
      continues to display video with correct size. */
  virtual void showEvent (TQShowEvent*);
  /** Ignores a mouse move event. */
  virtual void mouseMoveEvent (TQMouseEvent*);
  /** Ignores a mouse press event. */
  virtual void mousePressEvent (TQMouseEvent*);
  /** Ignores a mouse release event. */
  virtual void mouseReleaseEvent (TQMouseEvent*);
  /** Ignores a mouse double click event. */
  virtual void mouseDoubleClickEvent (TQMouseEvent*);
  /** Ignores a context menu event. */
  virtual void contextMenuEvent (TQContextMenuEvent*);
  /** Ignores a wheel event. */
  virtual void wheelEvent (TQWheelEvent*);
  virtual void focusInEvent (TQFocusEvent*);
  virtual void focusOutEvent (TQFocusEvent*);

protected slots:
  /** Receives the stateChanged signal from KPlayerProcess. */
  void playerStateChanged (KPlayerProcess::State, KPlayerProcess::State);
};

/** The KPlayer workspace that contains the video widget.
  *@author kiriuja
  */
class KPlayerWorkspace : public TQWidget
{
   TQ_OBJECT

public: 
  /** The workspace constructor. Creates the KPlayerWidget.
      Parameters are passed to the TQWidget constructor. */
  KPlayerWorkspace (TQWidget* parent = 0, const char* name = 0);

  /** Returns a pointer to the KPlayerWidget object. */
  KPlayerWidget* widget (void) const
    { return m_widget; }

  /** Returns a pointer to the hidden widget object. */
  TQWidget* hiddenWidget (void) const
    { return m_hidden_widget; }

  /** Resizes the widget to the given size. */
  void setDisplaySize (TQSize);

  /** Handles resizing done by the window manager.
   *  @param resizing true if resizing has started, false if resizing has completed
   */
  void resizeHandler (bool resizing);

  /** Returns whether the workspace is being resized by the user. */
  bool isResizing (void) const
    { return m_resizing; }

protected:
  /** Processes the widget resize event. Resizes the KPlayerWidget to the video size. */
  virtual void resizeEvent (TQResizeEvent*);
  /** Shows mouse cursor and starts timer. */
  virtual void mouseMoveEvent (TQMouseEvent*);
  /** Emits context menu signal on a right click in a part. */
  virtual void mousePressEvent (TQMouseEvent*);
  /** Ignores a mouse release event. */
  virtual void mouseReleaseEvent (TQMouseEvent*);
  /** Processes mouse double click event. Sends a doubleClick signal to the engine. */
  virtual void mouseDoubleClickEvent (TQMouseEvent*);
  /** Processes the wheel event. Sends a wheelZoom signal to the engine. */
  virtual void wheelEvent (TQWheelEvent*);
  /** Emits the contextMenu signal. */
  virtual void contextMenuEvent (TQContextMenuEvent*);
  virtual void windowActivationChange (bool);
  virtual void focusInEvent (TQFocusEvent*);
  virtual void focusOutEvent (TQFocusEvent*);

  /** Starts timer and sets the cursor. */
  void mouseActivity (void);
  /** Sets the mouse cursor to either blank or hand. */
  void setMouseCursor (void);

  /** The pointer to the KPlayerWidget object. */
  KPlayerWidget* m_widget;

  /** The pointer to the hidden widget object. */
  TQWidget* m_hidden_widget;

  // Following should be private
  /** Window manager is resizing the top level window. */
  bool m_resizing;
  /** Mouse activity indicator. */
  bool m_mouse_activity;
  /** Mouse activity timer. */
  TQTimer m_timer;

signals:
  /** Emitted when the widget is resized. */
  void resized (void);
  /** Emitted when the widget is resized by the user. */
  void userResize (void);
  /** Emitted when the context menu event is received. */
  void contextMenu (const TQPoint& global_position);

protected slots:
  /** Set the mouse cursor and tracking. */
  void setMouseCursorTracking (void);
  /** Receives the stateChanged signal from KPlayerProcess. */
  void playerStateChanged (KPlayerProcess::State, KPlayerProcess::State);
  /** Receives the timeout signal from the mouse activity timer. */
  void cursorTimeout (void);
};

#endif
