/* This file is part of the KDE libraries
   Copyright (c) 1998 Stefan Taferner
                    2001/2003 thierry lorthiois (lorthioist@wanadoo.fr)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/
#ifndef _KOWMFSTACK_H_
#define _KOWMFSTACK_H_

#include <tqpen.h>
#include <tqcolor.h>
#include <tqfont.h>
#include <tqbrush.h>
#include <tqpixmap.h>

class KoWmfRead;

/**
 * WMF file allows manipulation on a stack of object.
 * It's possile to create, delete or select an object.
 */
class KoWmfHandle
{
public:
    virtual void apply( KoWmfRead * ) = 0;
};

class KoWmfBrushHandle: public KoWmfHandle
{
public:
    virtual ~KoWmfBrushHandle() {};
    virtual void apply( KoWmfRead * );
    TQBrush brush;
};

class KoWmfPenHandle: public KoWmfHandle
{
public:
    virtual ~KoWmfPenHandle() {};
    virtual void apply( KoWmfRead * );
    TQPen pen;
};

class KoWmfPatternBrushHandle: public KoWmfHandle
{
public:
    virtual ~KoWmfPatternBrushHandle() {};
    virtual void apply( KoWmfRead * );
    TQBrush brush;
    TQPixmap image;
};

class KoWmfFontHandle: public KoWmfHandle
{
public:
    virtual ~KoWmfFontHandle() {};
    virtual void apply( KoWmfRead * );
    TQFont font;
    int rotation;
};

#endif
