/*
*
* Copyright (C) 2005  Fredrik Edemar
*                     f_edemar@linux.se
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*
*/

#ifndef kpresenterprintdlg_included
#define kpresenterprintdlg_included

#include <tdeprint/kprintdialogpage.h>
#include <knuminput.h>

#include <tqcheckbox.h>
#include <tqlabel.h>

class KPrPrinterDlg : public KPrintDialogPage
{
  TQ_OBJECT
  
  public:
    /// Getting the common arguments.
    KPrPrinterDlg( TQWidget *parent = 0, const char *name = 0 );

    /// Reimplemented.
    void getOptions( TQMap<TQString, TQString>& opts, bool include_def = false );
    /// Reimplemented
    void setOptions( const TQMap<TQString, TQString>& opts );
    /// Reimplemented.
    bool isValid( const TQString& msg );

  private slots:
    void txtRows_valueChanged( int );
    void txtColumns_valueChanged( int );

  private:
    KIntNumInput *txtRows;
    KIntNumInput *txtColumns;
    TQCheckBox *drawBorder;
};

#endif //kpresenterprinterdlg_included
