// This implements the TQScintilla plugin for TQt Designer.


#include <tqwidgetplugin.h>

#include "../tqt/tqextscintilla.h"


static const char *tqscintilla_pixmap[]={
	"22 22 35 1",
	"m c #000000",
	"n c #000033",
	"p c #003300",
	"r c #003333",
	"v c #330000",
	"o c #330033",
	"l c #333300",
	"h c #333333",
	"c c #333366",
	"d c #336666",
	"u c #336699",
	"E c #3366cc",
	"k c #663333",
	"i c #663366",
	"b c #666666",
	"e c #666699",
	"A c #6666cc",
	"G c #669966",
	"f c #669999",
	"j c #6699cc",
	"y c #6699ff",
	"t c #996666",
	"a c #999999",
	"g c #9999cc",
	"s c #9999ff",
	"C c #99cc99",
	"x c #99cccc",
	"w c #99ccff",
	"F c #cc99ff",
	"q c #cccccc",
	"# c #ccccff",
	"B c #ccffcc",
	"z c #ccffff",
	"D c #ffffcc",
	". c none",
	"........#abcda........",
	"......abefghdidcf.....",
	".....cadhfaehjheck....",
	"....leh.m.ncbehjddo...",
	"...depn.hqhqhr#mccch..",
	"..bb.hcaeh.hqersjhjcd.",
	".tcm.uqn.hc.uvwxhuygha",
	".feh.n.hb.hhzemcwhmuAm",
	"Bgehghqqme.eo#wlnysbnj",
	"awhdAzn.engjepswhmuyuj",
	"bCh#m.de.jpqwbmcwemlcz",
	"hcb#xh.nd#qrbswfehwzbm",
	"bd#d.A#zor#qmgbzwgjgws",
	"ajbcuqhqzchwwbemewchmr",
	"Dcn#cwmhgwehgsxbmhEjAc",
	".uanauFrhbgeahAAbcbuhh",
	".bohdAegcccfbbebuucmhe",
	"..briuauAediddeclchhh.",
	"...hcbhjccdecbceccch..",
	"....nhcmeccdccephcp...",
	".....crbhchhhrhhck....",
	"......tcmdhohhcnG....."
};


class TQScintillaPlugin : public TQWidgetPlugin
{
public:
	TQScintillaPlugin() {};

	TQStringList keys() const;
	TQWidget *create(const TQString &classname, TQWidget *parent = 0, const char *name = 0);
	TQString group(const TQString &) const;
	TQIconSet iconSet(const TQString &) const;
	TQString includeFile(const TQString &) const;
	TQString toolTip(const TQString &) const;
	TQString whatsThis(const TQString &) const;
	bool isContainer(const TQString &) const;
};


TQStringList TQScintillaPlugin::keys() const
{
	TQStringList list;

	list << "TQextScintilla";

	return list;
}


TQWidget *TQScintillaPlugin::create(const TQString &key, TQWidget *parent, const char *name)
{
	if (key == "TQextScintilla")
		return new TQextScintilla(parent, name);

	return 0;
}


TQString TQScintillaPlugin::group(const TQString &feature) const
{
	if (feature == "TQextScintilla")
		return "Input";

	return TQString();
}


TQIconSet TQScintillaPlugin::iconSet(const TQString &) const
{
	return TQIconSet(TQPixmap(tqscintilla_pixmap));
}


TQString TQScintillaPlugin::includeFile(const TQString &feature) const
{
	if (feature == "TQextScintilla")
		return "tqextscintilla.h";

	return TQString();
}


TQString TQScintillaPlugin::toolTip(const TQString &feature) const
{
	if (feature == "TQextScintilla")
		return "TQScintilla Programmer's Editor";

	return TQString();
}


TQString TQScintillaPlugin::whatsThis(const TQString &feature) const
{
	if (feature == "TQextScintilla")
		return "A port to TQt of the Scintilla programmer's editor";

	return TQString();
}


bool TQScintillaPlugin::isContainer(const TQString &) const
{
	return false;
}


TQ_EXPORT_PLUGIN(TQScintillaPlugin)
