/***************************************************************************
 *   Copyright (C) 2003 by Ajay Guleria                                    *
 *   ajay_guleria at yahoo dot com                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "commentdlg.h"

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tdeapplication.h>
#include <kbuttonbox.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kstdguiitem.h>

CcaseCommentDlg::CcaseCommentDlg(bool bCheckin)
  : TQDialog(0, "", true)
{
  setCaption( i18n("Clearcase Comment") );

  TQBoxLayout *layout = new TQVBoxLayout(this, 10);

  TQLabel *messagelabel = new TQLabel(i18n("Enter log message:"), this);
  messagelabel->setMinimumSize(messagelabel->sizeHint());
  layout->addWidget(messagelabel, 0);

  _edit = new TQMultiLineEdit(this);
  TQFontMetrics fm(_edit->fontMetrics());
  _edit->setMinimumSize(fm.width("0")*40, fm.lineSpacing()*3);
  layout->addWidget(_edit, 10);

  TQBoxLayout *layout2 = new TQHBoxLayout(layout);
  if(bCheckin) {
    _check = new TQCheckBox(i18n("Reserve"), this);
    layout2->addWidget(_check);
  }

  KButtonBox *buttonbox = new KButtonBox(this);
  buttonbox->addStretch();
  TQPushButton *ok = buttonbox->addButton(KStdGuiItem::ok());
  TQPushButton *cancel = buttonbox->addButton(KStdGuiItem::cancel());
  connect(ok, TQT_SIGNAL(clicked()), TQT_SLOT(accept()) );
  connect(cancel, TQT_SIGNAL(clicked()), TQT_SLOT(reject()) );
  ok->setDefault(true);
  buttonbox->layout();
  layout2->addWidget(buttonbox, 0);

  layout->activate();
  adjustSize();
}



#include "commentdlg.moc"
