/**********************************************************************
** Copyright (C) 2000-2002 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef EDITFUNCTIONSIMPL_H
#define EDITFUNCTIONSIMPL_H

#include "editfunctions.h"
#include "hierarchyview.h"
#include "metadatabase.h"
#include <tqmap.h>

class FormWindow;
class TQListViewItem;

class EditFunctions : public EditFunctionsBase
{
    TQ_OBJECT
  

public:
    EditFunctions( TQWidget *parent, FormWindow *fw, bool showOnlySlots = FALSE );

    void setCurrentFunction( const TQString &function );
    void functionAdd( const TQString &access = TQString(),
		      const TQString &type = TQString()  );
    void functionAdd() { functionAdd( "public" ); }

signals:
    void itemRenamed(const TQString &);

protected slots:
    void okClicked();
    void functionRemove();
    void currentItemChanged( TQListViewItem * );
    void currentTextChanged( const TQString &txt );
    void currentSpecifierChanged( const TQString &s );
    void currentAccessChanged( const TQString &a );
    void currentReturnTypeChanged( const TQString &type );
    void currentTypeChanged( const TQString &type );
    void displaySlots( bool justSlots );
    void emitItemRenamed( TQListViewItem *, int, const TQString & );

private:
    enum Attribute { Name, Specifier, Access, ReturnType, Type };
    struct FunctItem {
	int id;
	TQString oldName;
	TQString newName;
	TQString oldRetTyp;
	TQString retTyp;
	TQString spec;
	TQString oldSpec;
	TQString access;
	TQString oldAccess;
	TQString type;
	TQString oldType;

	TQ_DUMMY_COMPARISON_OPERATOR( FunctItem )
    };

    void changeItem( TQListViewItem *item, Attribute a, const TQString &nV );

    FormWindow *formWindow;
    TQMap<TQListViewItem*, int> functionIds;
    TQStringList removedFunctions;
    TQValueList<MetaDataBase::Function> itemList;
    TQValueList<FunctItem> functList;
    int id;
    TQString lastType;
};

#endif
