#include <tqvbox.h>


#include <kiconloader.h>
#include <tdelocale.h>
#include <kdialogbase.h>
#include <kdevgenericfactory.h>

#include <kdevcore.h>
#include <kdevplugininfo.h>

#include "editorchooser_part.h"
#include "editorchooser_widget.h"

typedef KDevGenericFactory<EditorChooserPart> EditorChooserFactory;
static const KDevPluginInfo pluginData("kdeveditorchooser");
K_EXPORT_COMPONENT_FACTORY( libkdeveditorchooser, EditorChooserFactory( pluginData ) )

EditorChooserPart::EditorChooserPart(TQObject *parent, const char *name, const TQStringList &)
  : KDevPlugin(&pluginData, parent, name ? name : "EditorChooserPart")
{
  setInstance(EditorChooserFactory::instance());

  connect(core(), TQT_SIGNAL(configWidget(KDialogBase*)), this, TQT_SLOT(configWidget(KDialogBase*)));
}


EditorChooserPart::~EditorChooserPart()
{
}


void EditorChooserPart::configWidget(KDialogBase *dlg)
{
  TQVBox *vbox = dlg->addVBoxPage(i18n("Editor"), i18n("Editor"), BarIcon("kate", TDEIcon::SizeMedium) );
  EditorChooserWidget *w = new EditorChooserWidget(vbox);
  connect(dlg, TQT_SIGNAL(okClicked()), w, TQT_SLOT(accept()));
}



#include "editorchooser_part.moc"
