/***************************************************************************
 *   Copyright (C) 2003 by Hendrik Kueck                                   *
 *   kueck@cs.ubc.ca                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "custommakeconfigwidget.h"
#include <custombuildoptionswidgetbase.h>
#include <customprojectpart.h>
#include <tqcombobox.h>
#include <tqdir.h>
#include <tqfile.h>
#include <tqfileinfo.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqcheckbox.h>
#include <tqspinbox.h>
#include <tqlistview.h>
#include <tqgroupbox.h>
#include <tqvalidator.h>
#include <klineedit.h>
#include <kdebug.h>
#include <tdelocale.h>

#include <environmentvariableswidget.h>

CustomMakeConfigWidget::CustomMakeConfigWidget(CustomProjectPart* part, const TQString& configGroup, TQWidget* parent)
 : CustomMakeConfigWidgetBase(parent),
    m_part(part), m_configGroup(configGroup), m_dom( *part->projectDom() )
{
    abort_box->setChecked(DomUtil::readBoolEntry(m_dom, m_configGroup + "/make/abortonerror"));
    int numjobs = DomUtil::readIntEntry(m_dom, m_configGroup + "/make/numberofjobs");
    jobs_box->setValue(numjobs);
    runMultiJobs->setChecked( (numjobs > 0 ) );

    prio_box->setValue(DomUtil::readIntEntry(m_dom, m_configGroup + "/make/prio"));
    dontact_box->setChecked(DomUtil::readBoolEntry(m_dom, m_configGroup + "/make/dontact"));
    makebin_edit->setText(DomUtil::readEntry(m_dom, m_configGroup + "/make/makebin"));
    defaultTarget_edit->setText(DomUtil::readEntry(m_dom, m_configGroup + "/make/defaulttarget"));
    makeoptions_edit->setText(DomUtil::readEntry(m_dom, m_configGroup + "/make/makeoptions"));

    envs_combo->setValidator(new TQRegExpValidator(TQRegExp("^\\D[^\\s]*"), TQT_TQOBJECT(this)));
    m_allEnvironments = m_part->allMakeEnvironments();
    m_currentEnvironment = m_part->currentMakeEnvironment();
    env_var_group->setColumnLayout( 1, Qt::Vertical );
    m_envWidget = new EnvironmentVariablesWidget(m_dom, m_configGroup + "/make/environments/" + m_currentEnvironment, env_var_group);
    envs_combo->insertStringList(m_allEnvironments);
    envs_combo->setEditText(m_currentEnvironment);
}


CustomMakeConfigWidget::~CustomMakeConfigWidget()
{

}

void CustomMakeConfigWidget::envNameChanged(const TQString& envName)
{
    TQStringList allEnvNames = m_part->allMakeEnvironments();
    bool canAdd = !allEnvNames.contains(envName) && !envName.contains("/") && !envName.isEmpty();
    bool canRemove = allEnvNames.contains(envName) && allEnvNames.count() > 1;
    addenvs_button->setEnabled(canAdd);
    copyenvs_button->setEnabled(canAdd);
    removeenvs_button->setEnabled(canRemove);
}

void CustomMakeConfigWidget::envChanged(const TQString& envName)
{
    if (envName == m_currentEnvironment || !m_allEnvironments.contains(envName))
        return;

    // save settings of previously active environment
    if (!m_currentEnvironment.isNull() )
        m_envWidget->accept();

    m_currentEnvironment = envName;
    m_envWidget->readEnvironment(m_dom, m_configGroup + "/make/environments/" + envName);
    envs_combo->setEditText(envName);
}

void CustomMakeConfigWidget::envAdded()
{
    TQString env = envs_combo->currentText();
    m_allEnvironments.append(env);

    envs_combo->clear();
    envs_combo->insertStringList(m_allEnvironments);
    envChanged(env);
}

void CustomMakeConfigWidget::envRemoved()
{
    TQString env = envs_combo->currentText();
    TQDomNode node = DomUtil::elementByPath(m_dom, m_configGroup + "/make/environments");
    node.removeChild(node.namedItem(env));
    m_allEnvironments.remove(env);
    envs_combo->clear();
    envs_combo->insertStringList(m_allEnvironments);
    m_currentEnvironment = TQString();
    envChanged( m_allEnvironments[0] );
}

void CustomMakeConfigWidget::envCopied()
{
    TQString env = envs_combo->currentText();
    m_allEnvironments.append(env);
    envs_combo->clear();
    envs_combo->insertStringList(m_allEnvironments);
    m_currentEnvironment = env;
    m_envWidget->changeConfigGroup(m_configGroup + "/make/environments/" + env);
    envs_combo->setEditText(env);
}

void CustomMakeConfigWidget::accept()
{
    DomUtil::writeBoolEntry(m_dom, m_configGroup + "/make/abortonerror", abort_box->isChecked());
    if( runMultiJobs->isChecked() )
        DomUtil::writeIntEntry(m_dom, m_configGroup + "/make/numberofjobs", jobs_box->value());
    else
        DomUtil::writeIntEntry(m_dom, m_configGroup + "/make/numberofjobs", 0);
    DomUtil::writeIntEntry(m_dom, m_configGroup + "/make/prio", prio_box->value());
    DomUtil::writeBoolEntry(m_dom, m_configGroup + "/make/dontact", dontact_box->isChecked());
    DomUtil::writeEntry(m_dom, m_configGroup + "/make/makebin", makebin_edit->text());
    DomUtil::writeEntry(m_dom, m_configGroup + "/make/defaulttarget", defaultTarget_edit->text());
    DomUtil::writeEntry(m_dom, m_configGroup + "/make/makeoptions", makeoptions_edit->text());
    DomUtil::writeEntry(m_dom, m_configGroup + "/make/selectedenvironment", m_currentEnvironment);
    m_envWidget->accept();
}

#include "custommakeconfigwidget.moc"
