/***************************************************************************
 *   Copyright (C) 2006 by Marco Martin   *
 *   notmart@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "tastybutton.h"

#include <tqimage.h>
#include <tqpainter.h>
#include <tqpalette.h>
#include <tqcolor.h>
#include <kimageeffect.h>

TastyButton::TastyButton(TQWidget *parent)
 : TQToolButton(parent)
{
  iconEffect = new TDEIconEffect();
  iconEffect->init();
}


TastyButton::~TastyButton()
{
}

void TastyButton::drawButton( TQPainter * p )
{
  //background image or pseudo transparency
  if( parentWidget()->erasePixmap() )
  {
    const TQPixmap erasePix(size());
    TQPainter buffPainter(&erasePix);
    buffPainter.drawPixmap(TQPoint(0, 0), *parentWidget()->erasePixmap(), geometry());
    buffPainter.end();

    TQImage eraseImg = erasePix.convertToImage();
    if( isDown() )
    {
      KImageEffect::fade(eraseImg, 0.25, black);
      p->drawPixmap(rect(), eraseImg );
    }
    else if( uses3D() )
    {
      KImageEffect::fade(eraseImg, 0.4, white);
      p->drawPixmap(rect(), eraseImg );
    }
    else
      p->drawPixmap(rect(), erasePix );

    //lightScore = 0 grey, >0 lighter <0 darker
    int lightScore = 0;
    //chacks the brightness of 10 pixels of the diagonal
    //we won't be 100% sure if this reflects the global brightess of the image
    //but it seems to work well
    int x = 0;
    int y = 0;
    while( x < eraseImg.width() && y < eraseImg.height() && x < 10 )
    {
      x=++y;
      //deciding the text color to use
      int h,s,v;
      TQColor(eraseImg.pixel(x,y)).getHsv( h, s, v );
      // is purely empirical :)
      if( v > 140) lightScore++;
      else lightScore--;
    }
    if( lightScore < 0 )
      setPaletteForegroundColor(white);
    else
      setPaletteForegroundColor(black);
  }
  //simple background color
  else
  {
    if( isDown() )
    {
      p->fillRect(rect(), colorGroup().background().dark(120));
    }
    else if( uses3D() )
    {
      p->fillRect(rect(), colorGroup().background().light(120));
    }
    else
    {
      p->fillRect(rect(), colorGroup().background());
    }
  }

  drawButtonLabel(p);
}

void TastyButton::setIconSet(  TQIconSet is )
{
   is.setPixmap(iconEffect->apply(is.pixmap(),
                                  (int)TDEIcon::Panel,
                                  (int)TDEIcon::ActiveState),
                                  TQIconSet::Automatic,
                                  TQIconSet::Active);

   TQToolButton::setIconSet( is );
}

