#ifndef _HELPWIDGET_H_
#define _HELPWIDGET_H_
//
//   File : termwidget.h
//   Creation date : Wed Aug 30 2000 15:34:20 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#include "kvi_settings.h"

#ifdef COMPILE_TDE_SUPPORT

#include <tqframe.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include "kvi_tal_hbox.h"

#include "tdeparts/part.h"


class KviFrame;

class KviTermWidget : public TQFrame
{
	TQ_OBJECT
  
	TQ_PROPERTY( int KviProperty_ChildFocusOwner READ dummy )
public:
	KviTermWidget(TQWidget * par,KviFrame * lpFrm,bool bIsStandalone = false);
	~KviTermWidget();
private:
	KviTalHBox        * m_pHBox;
	TQLabel       * m_pTitleLabel;
	TQPushButton  * m_pCloseButton;
	KParts::Part * m_pKonsolePart;
	bool           m_bIsStandalone;
	TQWidget      * m_pKonsoleWidget;
protected:
	virtual void resizeEvent(TQResizeEvent *e);
protected slots:
	void closeClicked();
	void changeTitle(int i,const TQString& str);
	void notifySize(int,int);
	void changeColumns(int);
public:
	TQWidget * konsoleWidget(){ return m_pKonsoleWidget ? m_pKonsoleWidget : this; };
	virtual TQSize sizeHint() const;
	int dummy() const { return 0; };
protected slots:
	void konsoleDestroyed();
	void autoClose();
};

#endif


#endif //_HELPWIDGET_H_
