/***************************************************************************
*   Copyright (C) 2003-2006 Jason Kivlighn (jkivlighn@gmail.com)          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef SIMILARCATEGORIESDIALOG_H
#define SIMILARCATEGORIESDIALOG_H

#include <ntqvariant.h>
#include <ntqdialog.h>
#include <ntqvaluevector.h>

#include "datablocks/elementlist.h"

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQSpacerItem;
class TQSlider;
class TQLabel;
class TQPushButton;
class TQListViewItem;

class TDEListView;
class KLineEdit;

class RecipeDB;

class SimilarCategoriesDialog : public TQDialog
{
TQ_OBJECT
	
public:
	SimilarCategoriesDialog( ElementList &, TQWidget* parent = 0 );
	~SimilarCategoriesDialog();

	TQValueList<int> matches() const;
	TQString element() const;

	KLineEdit* categoriesBox;
	TQSlider* thresholdSlider;
	TQLabel* thresholdLabel;
	TQLabel* categoryLabel;
	TQPushButton* searchButton;
	TQLabel* allLabel;
	TDEListView* allListView;
	TQPushButton* removeButton;
	TQPushButton* addButton;
	TQLabel* toMergeLabel;
	TDEListView* toMergeListView;
	TQPushButton* mergeButton;
	TQPushButton* cancelButton;
	
protected:
	TQVBoxLayout* SimilarCategoriesDialogLayout;
	TQHBoxLayout* layout6;
	TQGridLayout* layout4;
	TQVBoxLayout* layout5;
	TQSpacerItem* spacer4;
	TQHBoxLayout* layout9;
	TQVBoxLayout* layout8;
	TQVBoxLayout* layout1;
	TQSpacerItem* spacer1;
	TQVBoxLayout* layout7;
	TQHBoxLayout* layout10;
	TQSpacerItem* spacer2;
	
protected slots:
	virtual void languageChange();
	void findMatches();
	void mergeMatches();
	void addCategory();
	void removeCategory();

private:
	ElementList m_elementList;

};

#endif // SIMILARCATEGORIESDIALOG_H
