/* This file is part of the KDE project
   Copyright (C) 2001 David Faure <faure@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KOUNAVAIL_H
#define KOUNAVAIL_H

#include <KoDocument.h>

class KoUnavailPart : public KoDocument
{
    TQ_OBJECT
  
    TQ_PROPERTY( TQCString mimetype READ nativeFormatMimeType WRITE setMimeType )
    TQ_PROPERTY( TQString unavailReason READ unavailReason WRITE setUnavailReason )
    TQ_PROPERTY( TQString realURL READ realURL WRITE setRealURL )
public:
    KoUnavailPart( TQWidget *parentWidget = 0, const char *widgetName = 0, TQObject* parent = 0, const char* name = 0 );

    virtual void paintContent( TQPainter& painter, const TQRect& rect, bool transparent = false, double zoomX = 1.0, double zoomY = 1.0 );

    virtual bool initDoc(InitDocFlags, TQWidget* = 0) { return true; }
    virtual bool loadOasis( const TQDomDocument& doc, KoOasisStyles& oasisStyles, const TQDomDocument& settings, KoStore* );
    virtual bool saveOasis(KoStore*, KoXmlWriter*);

    virtual bool loadXML( TQIODevice *, const TQDomDocument & );
    virtual bool saveFile();
    virtual TQDomDocument saveXML();
    virtual bool saveChildren( KoStore* /*_store*/ ) { return true; }

    /** This is called by KoDocumentChild::save */
    virtual TQCString nativeFormatMimeType() const { return m_mimetype; }
    /** This is called by KoDocumentChild::createUnavailDocument */
    void setMimeType( const TQCString& mime );
    // keep in sync with koDocumentChild.h
    enum UnavailReason { DocumentNotFound, HandlerNotFound };
    /** This is called by KoDocumentChild::createUnavailDocument */
    void setUnavailReason( const TQString& reason ) { m_reason = reason; }
    // stupid moc - I want a write-only property !
    TQString unavailReason() const { return m_reason; }
    /** This is called by KoDocumentChild::createUnavailDocument
     * Note the trick: we directly modify the URL of the document,
     * the one returned by KPart's url()
     */
    void setRealURL( const TQString& u ) { m_url = u; }
    // stupid moc again
    TQString realURL() const { return m_url.url(); }

protected:
    virtual KoView* createViewInstance( TQWidget* parent, const char* name );

    TQDomDocument m_doc;
    TQCString m_mimetype;
    TQString m_reason;
};

#include <KoView.h>

class KoUnavailView : public KoView
{
    TQ_OBJECT
  
public:
    KoUnavailView( KoUnavailPart* part, TQWidget* parent = 0, const char* name = 0 );

protected:
    virtual void paintEvent( TQPaintEvent* );
    virtual void updateReadWrite( bool ) {}
};

#include <KoFactory.h>

class TDEInstance;
class TDEAboutData;

class KoUnavailFactory : public KoFactory
{
    TQ_OBJECT
  
public:
    KoUnavailFactory( TQObject* parent = 0, const char* name = 0 );
    ~KoUnavailFactory();

    virtual KParts::Part *createPartObject( TQWidget *parentWidget = 0, const char *widgetName = 0, TQObject *parent = 0, const char *name = 0, const char *classname = "KoDocument", const TQStringList &args = TQStringList() );

    static TDEInstance* global();

    // _Creates_ a TDEAboutData but doesn't keep ownership
    static TDEAboutData* aboutData();

private:
    static TDEInstance* s_global;
    static TDEAboutData* s_aboutData;
};

#endif
