/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2000-2001 theKompany.com & Dave Marotti
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef __kivio_map_h__
#define __kivio_map_h__

class KivioPage;
class KivioMap;
class KivioDoc;

class KoStore;
class KoXmlWriter;
class KoGenStyles;

class TQDomElement;
class TQDomDocument;
class DCOPObject;

#include <tqintdict.h>
#include <tqobject.h>
#include <tqptrlist.h>
#include <tqstringlist.h>

/*
 * A map is a simple container for all pages. Usually a complete map is saved in one file.
 */

class KivioMap : public TQObject
{
  public:
    /**
    * Created an empty map.
    */
    KivioMap( KivioDoc* doc, const char* name = 0 );
    /**
    * This deletes all pages contained in this map.
    */
    virtual ~KivioMap();
  
    TQDomElement save( TQDomDocument& doc );
    void saveOasis(KoStore* store, KoXmlWriter* docWriter, KoGenStyles* styles);
    bool loadXML( const TQDomElement& mymap );
  
    /**
    * @param _page becomes added to the map.
    */
    void addPage( KivioPage* );
  
    void takePage( KivioPage* page );
    void insertPage( KivioPage* page );
  
    /**
    * The page named @param _from is being moved to the page @param _to.
    * If @param _before is true @param _from is inserted before (after otherwise)
    * @param _to.
    */
    void movePage( const TQString & _from, const TQString & _to, bool _before = true );
  
    KivioPage* findPage( const TQString& name );
  
    /**
    * Use the @ref #nextPage function to get all the other pages.
    * Attention: Function is not reentrant.
    *
    * @return a pointer to the first page in this map.
    */
    KivioPage* firstPage();

    /**
     * @return a pointer to the last page in this map.
     */
    KivioPage* lastPage();

    /**
    * Call @ref #firstPage first. This will set the list pointer to
    * the first page. Attention: Function is not reentrant.
    *
    * @return a pointer to the next page in this map.
    */
    KivioPage* nextPage();
  
    TQPtrList<KivioPage>& pageList() { return m_lstPages; }
    
    /**
    * Returns list of visible pages as stringlist.
    */
    TQStringList visiblePages() const;
    
    /**
    * Returns list of hidden pages as stringlist.
    */
    TQStringList hiddenPages() const;
  
    /**
    * @return amount of pages in this map.
    */
    int count()const;
  
    void update();
  
    KivioDoc* doc()const;
  
    virtual DCOPObject* dcopObject();

    void clear();

  private:
    TQPtrList<KivioPage> m_lstPages;
    TQPtrList<KivioPage> m_lstDeletedPages;
  
    KivioDoc* m_pDoc;
    DCOPObject* m_dcop;
};

#endif
